/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.entity.vehicle.MinecartChest;
import net.minecraft.world.entity.vehicle.MinecartCommandBlock;
import net.minecraft.world.entity.vehicle.MinecartFurnace;
import net.minecraft.world.entity.vehicle.MinecartHopper;
import net.minecraft.world.entity.vehicle.MinecartSpawner;
import net.minecraft.world.entity.vehicle.MinecartTNT;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractMinecart
extends Entity {
    private static final EntityDataAccessor<Integer> f_38079_ = SynchedEntityData.m_135353_(AbstractMinecart.class, EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> f_38080_ = SynchedEntityData.m_135353_(AbstractMinecart.class, EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> f_38081_ = SynchedEntityData.m_135353_(AbstractMinecart.class, EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> f_38082_ = SynchedEntityData.m_135353_(AbstractMinecart.class, EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> f_38083_ = SynchedEntityData.m_135353_(AbstractMinecart.class, EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> f_38084_ = SynchedEntityData.m_135353_(AbstractMinecart.class, EntityDataSerializers.f_135035_);
    private static final ImmutableMap<Pose, ImmutableList<Integer>> f_38067_ = ImmutableMap.of((Object)((Object)Pose.STANDING), (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)((Object)Pose.CROUCHING), (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)((Object)Pose.SWIMMING), (Object)ImmutableList.of((Object)0, (Object)1));
    protected static final float f_150249_ = 0.95f;
    private boolean f_38068_;
    private static final Map<RailShape, Pair<Vec3i, Vec3i>> f_38069_ = Util.m_137469_(Maps.newEnumMap(RailShape.class), p_38135_ -> {
        Vec3i vec3i = Direction.WEST.m_122436_();
        \u00e2\u02dc\u0192 = Direction.EAST.m_122436_();
        \u00e2\u02dc\u0192 = Direction.NORTH.m_122436_();
        \u00e2\u02dc\u0192 = Direction.SOUTH.m_122436_();
        \u00e2\u02dc\u0192 = vec3i.m_7495_();
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192.m_7495_();
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192.m_7495_();
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192.m_7495_();
        p_38135_.put(RailShape.NORTH_SOUTH, Pair.of((Object)\u00e2\u02dc\u0192, (Object)\u00e2\u02dc\u0192));
        p_38135_.put(RailShape.EAST_WEST, Pair.of((Object)vec3i, (Object)\u00e2\u02dc\u0192));
        p_38135_.put(RailShape.ASCENDING_EAST, Pair.of((Object)\u00e2\u02dc\u0192, (Object)\u00e2\u02dc\u0192));
        p_38135_.put(RailShape.ASCENDING_WEST, Pair.of((Object)vec3i, (Object)\u00e2\u02dc\u0192));
        p_38135_.put(RailShape.ASCENDING_NORTH, Pair.of((Object)\u00e2\u02dc\u0192, (Object)\u00e2\u02dc\u0192));
        p_38135_.put(RailShape.ASCENDING_SOUTH, Pair.of((Object)\u00e2\u02dc\u0192, (Object)\u00e2\u02dc\u0192));
        p_38135_.put(RailShape.SOUTH_EAST, Pair.of((Object)\u00e2\u02dc\u0192, (Object)\u00e2\u02dc\u0192));
        p_38135_.put(RailShape.SOUTH_WEST, Pair.of((Object)\u00e2\u02dc\u0192, (Object)vec3i));
        p_38135_.put(RailShape.NORTH_WEST, Pair.of((Object)\u00e2\u02dc\u0192, (Object)vec3i));
        p_38135_.put(RailShape.NORTH_EAST, Pair.of((Object)\u00e2\u02dc\u0192, (Object)\u00e2\u02dc\u0192));
    });
    private int f_38070_;
    private double f_38071_;
    private double f_38072_;
    private double f_38073_;
    private double f_38074_;
    private double f_38075_;
    private double f_38076_;
    private double f_38077_;
    private double f_38078_;

    protected AbstractMinecart(EntityType<?> p_38087_, Level p_38088_) {
        super(p_38087_, p_38088_);
        this.f_19850_ = true;
    }

    protected AbstractMinecart(EntityType<?> p_38090_, Level p_38091_, double p_38092_, double p_38093_, double p_38094_) {
        this(p_38090_, p_38091_);
        this.m_6034_(p_38092_, p_38093_, p_38094_);
        this.f_19854_ = p_38092_;
        this.f_19855_ = p_38093_;
        this.f_19856_ = p_38094_;
    }

    public static AbstractMinecart m_38119_(Level p_38120_, double p_38121_, double p_38122_, double p_38123_, Type p_38124_) {
        if (p_38124_ == Type.CHEST) {
            return new MinecartChest(p_38120_, p_38121_, p_38122_, p_38123_);
        }
        if (p_38124_ == Type.FURNACE) {
            return new MinecartFurnace(p_38120_, p_38121_, p_38122_, p_38123_);
        }
        if (p_38124_ == Type.TNT) {
            return new MinecartTNT(p_38120_, p_38121_, p_38122_, p_38123_);
        }
        if (p_38124_ == Type.SPAWNER) {
            return new MinecartSpawner(p_38120_, p_38121_, p_38122_, p_38123_);
        }
        if (p_38124_ == Type.HOPPER) {
            return new MinecartHopper(p_38120_, p_38121_, p_38122_, p_38123_);
        }
        if (p_38124_ == Type.COMMAND_BLOCK) {
            return new MinecartCommandBlock(p_38120_, p_38121_, p_38122_, p_38123_);
        }
        return new Minecart(p_38120_, p_38121_, p_38122_, p_38123_);
    }

    @Override
    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    @Override
    protected void m_8097_() {
        this.f_19804_.m_135372_(f_38079_, 0);
        this.f_19804_.m_135372_(f_38080_, 1);
        this.f_19804_.m_135372_(f_38081_, Float.valueOf(0.0f));
        this.f_19804_.m_135372_(f_38082_, Block.m_49956_(Blocks.f_50016_.m_49966_()));
        this.f_19804_.m_135372_(f_38083_, 6);
        this.f_19804_.m_135372_(f_38084_, false);
    }

    @Override
    public boolean m_7337_(Entity p_38168_) {
        return Boat.m_38323_(this, p_38168_);
    }

    @Override
    public boolean m_6094_() {
        return true;
    }

    @Override
    protected Vec3 m_7643_(Direction.Axis p_38132_, BlockUtil.FoundRectangle p_38133_) {
        return LivingEntity.m_21289_(super.m_7643_(p_38132_, p_38133_));
    }

    @Override
    public double m_6048_() {
        return 0.0;
    }

    @Override
    public Vec3 m_7688_(LivingEntity p_38145_) {
        Direction direction = this.m_6374_();
        if (direction.m_122434_() == Direction.Axis.Y) {
            return super.m_7688_(p_38145_);
        }
        int[][] \u00e2\u02dc\u01922 = DismountHelper.m_38467_(direction);
        BlockPos \u00e2\u02dc\u01923 = this.m_142538_();
        BlockPos.MutableBlockPos \u00e2\u02dc\u01924 = new BlockPos.MutableBlockPos();
        ImmutableList<Pose> \u00e2\u02dc\u01925 = p_38145_.m_7431_();
        for (Pose pose : \u00e2\u02dc\u01925) {
            EntityDimensions entityDimensions = p_38145_.m_6972_(pose);
            float \u00e2\u02dc\u01926 = Math.min(entityDimensions.f_20377_, 1.0f) / 2.0f;
            UnmodifiableIterator unmodifiableIterator = ((ImmutableList)f_38067_.get((Object)pose)).iterator();
            while (unmodifiableIterator.hasNext()) {
                int n = (Integer)unmodifiableIterator.next();
                for (int[] nArray : \u00e2\u02dc\u01922) {
                    \u00e2\u02dc\u01924.m_122178_(\u00e2\u02dc\u01923.m_123341_() + nArray[0], \u00e2\u02dc\u01923.m_123342_() + n, \u00e2\u02dc\u01923.m_123343_() + nArray[1]);
                    double d = this.f_19853_.m_45564_(DismountHelper.m_38446_(this.f_19853_, \u00e2\u02dc\u01924), () -> DismountHelper.m_38446_(this.f_19853_, (BlockPos)\u00e2\u02dc\u01924.m_7495_()));
                    if (!DismountHelper.m_38439_(d) || !DismountHelper.m_38456_(this.f_19853_, p_38145_, (\u00e2\u02dc\u0192 = new AABB(-\u00e2\u02dc\u01926, 0.0, -\u00e2\u02dc\u01926, \u00e2\u02dc\u01926, entityDimensions.f_20378_, \u00e2\u02dc\u01926)).m_82383_(\u00e2\u02dc\u0192 = Vec3.m_82514_(\u00e2\u02dc\u01924, d)))) continue;
                    p_38145_.m_20124_(pose);
                    return \u00e2\u02dc\u0192;
                }
            }
        }
        double d = this.m_142469_().f_82292_;
        \u00e2\u02dc\u01924.m_122169_(\u00e2\u02dc\u01923.m_123341_(), d, \u00e2\u02dc\u01923.m_123343_());
        for (Pose pose : \u00e2\u02dc\u01925) {
            double d2 = p_38145_.m_6972_((Pose)pose).f_20378_;
            int \u00e2\u02dc\u01927 = Mth.m_14165_(d - (double)\u00e2\u02dc\u01924.m_123342_() + d2);
            \u00e2\u02dc\u0192 = DismountHelper.m_38463_(\u00e2\u02dc\u01924, \u00e2\u02dc\u01927, p_38149_ -> this.f_19853_.m_8055_((BlockPos)p_38149_).m_60812_(this.f_19853_, (BlockPos)p_38149_));
            if (!(d + d2 <= \u00e2\u02dc\u0192)) continue;
            p_38145_.m_20124_(pose);
            break;
        }
        return super.m_7688_(p_38145_);
    }

    @Override
    public boolean m_6469_(DamageSource p_38117_, float p_38118_) {
        boolean bl;
        if (this.f_19853_.f_46443_ || this.m_146910_()) {
            return true;
        }
        if (this.m_6673_(p_38117_)) {
            return false;
        }
        this.m_38160_(-this.m_38177_());
        this.m_38154_(10);
        this.m_5834_();
        this.m_38109_(this.m_38169_() + p_38118_ * 10.0f);
        this.m_146852_(GameEvent.f_157808_, p_38117_.m_7639_());
        boolean bl2 = bl = p_38117_.m_7639_() instanceof Player && ((Player)p_38117_.m_7639_()).m_150110_().f_35937_;
        if (bl || this.m_38169_() > 40.0f) {
            this.m_20153_();
            if (!bl || this.m_8077_()) {
                this.m_7617_(p_38117_);
            } else {
                this.m_146870_();
            }
        }
        return true;
    }

    @Override
    protected float m_6041_() {
        BlockState blockState = this.f_19853_.m_8055_(this.m_142538_());
        if (blockState.m_60620_(BlockTags.f_13034_)) {
            return 1.0f;
        }
        return super.m_6041_();
    }

    public void m_7617_(DamageSource p_38115_) {
        this.m_142687_(Entity.RemovalReason.KILLED);
        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            ItemStack itemStack = new ItemStack(Items.f_42449_);
            if (this.m_8077_()) {
                itemStack.m_41714_(this.m_7770_());
            }
            this.m_19983_(itemStack);
        }
    }

    @Override
    public void m_6053_() {
        this.m_38160_(-this.m_38177_());
        this.m_38154_(10);
        this.m_38109_(this.m_38169_() + this.m_38169_() * 10.0f);
    }

    @Override
    public boolean m_6087_() {
        return !this.m_146910_();
    }

    private static Pair<Vec3i, Vec3i> m_38125_(RailShape p_38126_) {
        return f_38069_.get(p_38126_);
    }

    @Override
    public Direction m_6374_() {
        return this.f_38068_ ? this.m_6350_().m_122424_().m_122427_() : this.m_6350_().m_122427_();
    }

    @Override
    public void m_8119_() {
        BlockState blockState;
        int n;
        if (this.m_38176_() > 0) {
            this.m_38154_(this.m_38176_() - 1);
        }
        if (this.m_38169_() > 0.0f) {
            this.m_38109_(this.m_38169_() - 1.0f);
        }
        this.m_146871_();
        this.m_20157_();
        if (this.f_19853_.f_46443_) {
            if (this.f_38070_ > 0) {
                double d = this.m_20185_() + (this.f_38071_ - this.m_20185_()) / (double)this.f_38070_;
                \u00e2\u02dc\u0192 = this.m_20186_() + (this.f_38072_ - this.m_20186_()) / (double)this.f_38070_;
                \u00e2\u02dc\u0192 = this.m_20189_() + (this.f_38073_ - this.m_20189_()) / (double)this.f_38070_;
                \u00e2\u02dc\u0192 = Mth.m_14175_(this.f_38074_ - (double)this.m_146908_());
                this.m_146922_(this.m_146908_() + (float)\u00e2\u02dc\u0192 / (float)this.f_38070_);
                this.m_146926_(this.m_146909_() + (float)(this.f_38075_ - (double)this.m_146909_()) / (float)this.f_38070_);
                --this.f_38070_;
                this.m_6034_(d, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
                this.m_19915_(this.m_146908_(), this.m_146909_());
            } else {
                this.m_20090_();
                this.m_19915_(this.m_146908_(), this.m_146909_());
            }
            return;
        }
        if (!this.m_20068_()) {
            double d = this.m_20069_() ? -0.005 : -0.04;
            this.m_20256_(this.m_20184_().m_82520_(0.0, d, 0.0));
        }
        if (this.f_19853_.m_8055_(new BlockPos(n = Mth.m_14107_(this.m_20185_()), (\u00e2\u02dc\u0192 = Mth.m_14107_(this.m_20186_())) - 1, \u00e2\u02dc\u0192 = Mth.m_14107_(this.m_20189_()))).m_60620_(BlockTags.f_13034_)) {
            --\u00e2\u02dc\u0192;
        }
        if (BaseRailBlock.m_49416_(blockState = this.f_19853_.m_8055_(\u00e2\u02dc\u0192 = new BlockPos(n, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192)))) {
            this.m_6401_(\u00e2\u02dc\u0192, blockState);
            if (blockState.m_60713_(Blocks.f_50285_)) {
                this.m_6025_(n, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, blockState.m_61143_(PoweredRailBlock.f_55215_));
            }
        } else {
            this.m_38163_();
        }
        this.m_20101_();
        this.m_146926_(0.0f);
        double d = this.f_19854_ - this.m_20185_();
        \u00e2\u02dc\u0192 = this.f_19856_ - this.m_20189_();
        if (d * d + \u00e2\u02dc\u0192 * \u00e2\u02dc\u0192 > 0.001) {
            this.m_146922_((float)(Mth.m_14136_(\u00e2\u02dc\u0192, d) * 180.0 / Math.PI));
            if (this.f_38068_) {
                this.m_146922_(this.m_146908_() + 180.0f);
            }
        }
        if ((\u00e2\u02dc\u0192 = (double)Mth.m_14177_(this.m_146908_() - this.f_19859_)) < -170.0 || \u00e2\u02dc\u0192 >= 170.0) {
            this.m_146922_(this.m_146908_() + 180.0f);
            this.f_38068_ = !this.f_38068_;
        }
        this.m_19915_(this.m_146908_(), this.m_146909_());
        if (this.m_6064_() == Type.RIDEABLE && this.m_20184_().m_165925_() > 0.01) {
            List<Entity> list = this.f_19853_.m_6249_(this, this.m_142469_().m_82377_(0.2f, 0.0, 0.2f), EntitySelector.m_20421_(this));
            if (!list.isEmpty()) {
                for (int i = 0; i < list.size(); ++i) {
                    Entity entity = list.get(i);
                    if (entity instanceof Player || entity instanceof IronGolem || entity instanceof AbstractMinecart || this.m_20160_() || entity.m_20159_()) {
                        entity.m_7334_(this);
                        continue;
                    }
                    entity.m_20329_(this);
                }
            }
        } else {
            for (Entity entity : this.f_19853_.m_45933_(this, this.m_142469_().m_82377_(0.2f, 0.0, 0.2f))) {
                if (this.m_20363_(entity) || !entity.m_6094_() || !(entity instanceof AbstractMinecart)) continue;
                entity.m_7334_(this);
            }
        }
        this.m_20073_();
        if (this.m_20077_()) {
            this.m_20093_();
            this.f_19789_ *= 0.5f;
        }
        this.f_19803_ = false;
    }

    protected double m_7097_() {
        return (this.m_20069_() ? 4.0 : 8.0) / 20.0;
    }

    public void m_6025_(int p_38111_, int p_38112_, int p_38113_, boolean p_38114_) {
    }

    protected void m_38163_() {
        double d = this.m_7097_();
        Vec3 \u00e2\u02dc\u01922 = this.m_20184_();
        this.m_20334_(Mth.m_14008_(\u00e2\u02dc\u01922.f_82479_, -d, d), \u00e2\u02dc\u01922.f_82480_, Mth.m_14008_(\u00e2\u02dc\u01922.f_82481_, -d, d));
        if (this.f_19861_) {
            this.m_20256_(this.m_20184_().m_82490_(0.5));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (!this.f_19861_) {
            this.m_20256_(this.m_20184_().m_82490_(0.95));
        }
    }

    protected void m_6401_(BlockPos p_38156_, BlockState p_38157_) {
        double \u00e2\u02dc\u019215;
        Vec3 vec3;
        this.f_19789_ = 0.0f;
        double d = this.m_20185_();
        \u00e2\u02dc\u0192 = this.m_20186_();
        \u00e2\u02dc\u0192 = this.m_20189_();
        Vec3 \u00e2\u02dc\u01922 = this.m_38179_(d, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
        \u00e2\u02dc\u0192 = p_38156_.m_123342_();
        boolean \u00e2\u02dc\u01923 = false;
        boolean \u00e2\u02dc\u01924 = false;
        if (p_38157_.m_60713_(Blocks.f_50030_)) {
            \u00e2\u02dc\u01923 = p_38157_.m_61143_(PoweredRailBlock.f_55215_);
            \u00e2\u02dc\u01924 = !\u00e2\u02dc\u01923;
        }
        \u00e2\u02dc\u0192 = 0.0078125;
        if (this.m_20069_()) {
            \u00e2\u02dc\u0192 *= 0.2;
        }
        Vec3 \u00e2\u02dc\u01925 = this.m_20184_();
        RailShape \u00e2\u02dc\u01926 = p_38157_.m_61143_(((BaseRailBlock)p_38157_.m_60734_()).m_7978_());
        switch (\u00e2\u02dc\u01926) {
            case ASCENDING_EAST: {
                this.m_20256_(\u00e2\u02dc\u01925.m_82520_(-\u00e2\u02dc\u0192, 0.0, 0.0));
                \u00e2\u02dc\u0192 += 1.0;
                break;
            }
            case ASCENDING_WEST: {
                this.m_20256_(\u00e2\u02dc\u01925.m_82520_(\u00e2\u02dc\u0192, 0.0, 0.0));
                \u00e2\u02dc\u0192 += 1.0;
                break;
            }
            case ASCENDING_NORTH: {
                this.m_20256_(\u00e2\u02dc\u01925.m_82520_(0.0, 0.0, \u00e2\u02dc\u0192));
                \u00e2\u02dc\u0192 += 1.0;
                break;
            }
            case ASCENDING_SOUTH: {
                this.m_20256_(\u00e2\u02dc\u01925.m_82520_(0.0, 0.0, -\u00e2\u02dc\u0192));
                \u00e2\u02dc\u0192 += 1.0;
            }
        }
        \u00e2\u02dc\u01925 = this.m_20184_();
        Pair<Vec3i, Vec3i> \u00e2\u02dc\u01927 = AbstractMinecart.m_38125_(\u00e2\u02dc\u01926);
        Vec3i \u00e2\u02dc\u01928 = (Vec3i)\u00e2\u02dc\u01927.getFirst();
        Vec3i \u00e2\u02dc\u01929 = (Vec3i)\u00e2\u02dc\u01927.getSecond();
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u01929.m_123341_() - \u00e2\u02dc\u01928.m_123341_();
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u01929.m_123343_() - \u00e2\u02dc\u01928.m_123343_();
        \u00e2\u02dc\u0192 = Math.sqrt(\u00e2\u02dc\u0192 * \u00e2\u02dc\u0192 + \u00e2\u02dc\u0192 * \u00e2\u02dc\u0192);
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u01925.f_82479_ * \u00e2\u02dc\u0192 + \u00e2\u02dc\u01925.f_82481_ * \u00e2\u02dc\u0192;
        if (\u00e2\u02dc\u0192 < 0.0) {
            \u00e2\u02dc\u0192 = -\u00e2\u02dc\u0192;
            \u00e2\u02dc\u0192 = -\u00e2\u02dc\u0192;
        }
        \u00e2\u02dc\u0192 = Math.min(2.0, \u00e2\u02dc\u01925.m_165924_());
        \u00e2\u02dc\u01925 = new Vec3(\u00e2\u02dc\u0192 * \u00e2\u02dc\u0192 / \u00e2\u02dc\u0192, \u00e2\u02dc\u01925.f_82480_, \u00e2\u02dc\u0192 * \u00e2\u02dc\u0192 / \u00e2\u02dc\u0192);
        this.m_20256_(\u00e2\u02dc\u01925);
        Entity \u00e2\u02dc\u019210 = this.m_146895_();
        if (\u00e2\u02dc\u019210 instanceof Player) {
            Vec3 vec32 = \u00e2\u02dc\u019210.m_20184_();
            double \u00e2\u02dc\u019211 = vec32.m_165925_();
            double \u00e2\u02dc\u019212 = this.m_20184_().m_165925_();
            if (\u00e2\u02dc\u019211 > 1.0E-4 && \u00e2\u02dc\u019212 < 0.01) {
                this.m_20256_(this.m_20184_().m_82520_(vec32.f_82479_ * 0.1, 0.0, vec32.f_82481_ * 0.1));
                \u00e2\u02dc\u01924 = false;
            }
        }
        if (\u00e2\u02dc\u01924) {
            double \u00e2\u02dc\u019213 = this.m_20184_().m_165924_();
            if (\u00e2\u02dc\u019213 < 0.03) {
                this.m_20256_(Vec3.f_82478_);
            } else {
                this.m_20256_(this.m_20184_().m_82542_(0.5, 0.0, 0.5));
            }
        }
        double d2 = (double)p_38156_.m_123341_() + 0.5 + (double)\u00e2\u02dc\u01928.m_123341_() * 0.5;
        \u00e2\u02dc\u0192 = (double)p_38156_.m_123343_() + 0.5 + (double)\u00e2\u02dc\u01928.m_123343_() * 0.5;
        \u00e2\u02dc\u0192 = (double)p_38156_.m_123341_() + 0.5 + (double)\u00e2\u02dc\u01929.m_123341_() * 0.5;
        \u00e2\u02dc\u0192 = (double)p_38156_.m_123343_() + 0.5 + (double)\u00e2\u02dc\u01929.m_123343_() * 0.5;
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 - d2;
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 - \u00e2\u02dc\u0192;
        if (\u00e2\u02dc\u0192 == 0.0) {
            \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 - (double)p_38156_.m_123343_();
        } else if (\u00e2\u02dc\u0192 == 0.0) {
            \u00e2\u02dc\u0192 = d - (double)p_38156_.m_123341_();
        } else {
            \u00e2\u02dc\u0192 = d - d2;
            \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 - \u00e2\u02dc\u0192;
            \u00e2\u02dc\u0192 = (\u00e2\u02dc\u0192 * \u00e2\u02dc\u0192 + \u00e2\u02dc\u0192 * \u00e2\u02dc\u0192) * 2.0;
        }
        d = d2 + \u00e2\u02dc\u0192 * \u00e2\u02dc\u0192;
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 + \u00e2\u02dc\u0192 * \u00e2\u02dc\u0192;
        this.m_6034_(d, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
        \u00e2\u02dc\u0192 = this.m_20160_() ? 0.75 : 1.0;
        \u00e2\u02dc\u0192 = this.m_7097_();
        \u00e2\u02dc\u01925 = this.m_20184_();
        this.m_6478_(MoverType.SELF, new Vec3(Mth.m_14008_(\u00e2\u02dc\u0192 * \u00e2\u02dc\u01925.f_82479_, -\u00e2\u02dc\u0192, \u00e2\u02dc\u0192), 0.0, Mth.m_14008_(\u00e2\u02dc\u0192 * \u00e2\u02dc\u01925.f_82481_, -\u00e2\u02dc\u0192, \u00e2\u02dc\u0192)));
        if (\u00e2\u02dc\u01928.m_123342_() != 0 && Mth.m_14107_(this.m_20185_()) - p_38156_.m_123341_() == \u00e2\u02dc\u01928.m_123341_() && Mth.m_14107_(this.m_20189_()) - p_38156_.m_123343_() == \u00e2\u02dc\u01928.m_123343_()) {
            this.m_6034_(this.m_20185_(), this.m_20186_() + (double)\u00e2\u02dc\u01928.m_123342_(), this.m_20189_());
        } else if (\u00e2\u02dc\u01929.m_123342_() != 0 && Mth.m_14107_(this.m_20185_()) - p_38156_.m_123341_() == \u00e2\u02dc\u01929.m_123341_() && Mth.m_14107_(this.m_20189_()) - p_38156_.m_123343_() == \u00e2\u02dc\u01929.m_123343_()) {
            this.m_6034_(this.m_20185_(), this.m_20186_() + (double)\u00e2\u02dc\u01929.m_123342_(), this.m_20189_());
        }
        this.m_7114_();
        Vec3 \u00e2\u02dc\u019214 = this.m_38179_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        if (\u00e2\u02dc\u019214 != null && \u00e2\u02dc\u01922 != null) {
            \u00e2\u02dc\u0192 = (\u00e2\u02dc\u01922.f_82480_ - \u00e2\u02dc\u019214.f_82480_) * 0.05;
            vec3 = this.m_20184_();
            \u00e2\u02dc\u019215 = vec3.m_165924_();
            if (\u00e2\u02dc\u019215 > 0.0) {
                this.m_20256_(vec3.m_82542_((\u00e2\u02dc\u019215 + \u00e2\u02dc\u0192) / \u00e2\u02dc\u019215, 1.0, (\u00e2\u02dc\u019215 + \u00e2\u02dc\u0192) / \u00e2\u02dc\u019215));
            }
            this.m_6034_(this.m_20185_(), \u00e2\u02dc\u019214.f_82480_, this.m_20189_());
        }
        int n = Mth.m_14107_(this.m_20185_());
        \u00e2\u02dc\u0192 = Mth.m_14107_(this.m_20189_());
        if (n != p_38156_.m_123341_() || \u00e2\u02dc\u0192 != p_38156_.m_123343_()) {
            vec3 = this.m_20184_();
            \u00e2\u02dc\u019215 = vec3.m_165924_();
            this.m_20334_(\u00e2\u02dc\u019215 * (double)(n - p_38156_.m_123341_()), vec3.f_82480_, \u00e2\u02dc\u019215 * (double)(\u00e2\u02dc\u0192 - p_38156_.m_123343_()));
        }
        if (\u00e2\u02dc\u01923) {
            vec3 = this.m_20184_();
            \u00e2\u02dc\u019215 = vec3.m_165924_();
            if (\u00e2\u02dc\u019215 > 0.01) {
                double d3 = 0.06;
                this.m_20256_(vec3.m_82520_(vec3.f_82479_ / \u00e2\u02dc\u019215 * 0.06, 0.0, vec3.f_82481_ / \u00e2\u02dc\u019215 * 0.06));
            } else {
                Vec3 vec33 = this.m_20184_();
                double \u00e2\u02dc\u019216 = vec33.f_82479_;
                double \u00e2\u02dc\u019217 = vec33.f_82481_;
                if (\u00e2\u02dc\u01926 == RailShape.EAST_WEST) {
                    if (this.m_38129_(p_38156_.m_142125_())) {
                        \u00e2\u02dc\u019216 = 0.02;
                    } else if (this.m_38129_(p_38156_.m_142126_())) {
                        \u00e2\u02dc\u019216 = -0.02;
                    }
                } else if (\u00e2\u02dc\u01926 == RailShape.NORTH_SOUTH) {
                    if (this.m_38129_(p_38156_.m_142127_())) {
                        \u00e2\u02dc\u019217 = 0.02;
                    } else if (this.m_38129_(p_38156_.m_142128_())) {
                        \u00e2\u02dc\u019217 = -0.02;
                    }
                } else {
                    return;
                }
                this.m_20334_(\u00e2\u02dc\u019216, vec33.f_82480_, \u00e2\u02dc\u019217);
            }
        }
    }

    private boolean m_38129_(BlockPos p_38130_) {
        return this.f_19853_.m_8055_(p_38130_).m_60796_(this.f_19853_, p_38130_);
    }

    protected void m_7114_() {
        double d = this.m_20160_() ? 0.997 : 0.96;
        Vec3 \u00e2\u02dc\u01922 = this.m_20184_();
        \u00e2\u02dc\u01922 = \u00e2\u02dc\u01922.m_82542_(d, 0.0, d);
        if (this.m_20069_()) {
            \u00e2\u02dc\u01922 = \u00e2\u02dc\u01922.m_82490_(0.95f);
        }
        this.m_20256_(\u00e2\u02dc\u01922);
    }

    @Nullable
    public Vec3 m_38096_(double p_38097_, double p_38098_, double p_38099_, double p_38100_) {
        int n = Mth.m_14107_(p_38097_);
        if (this.f_19853_.m_8055_(new BlockPos(n, (\u00e2\u02dc\u0192 = Mth.m_14107_(p_38098_)) - 1, \u00e2\u02dc\u0192 = Mth.m_14107_(p_38099_))).m_60620_(BlockTags.f_13034_)) {
            --\u00e2\u02dc\u0192;
        }
        if (BaseRailBlock.m_49416_(\u00e2\u02dc\u0192 = this.f_19853_.m_8055_(new BlockPos(n, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192)))) {
            RailShape railShape = \u00e2\u02dc\u0192.m_61143_(((BaseRailBlock)\u00e2\u02dc\u0192.m_60734_()).m_7978_());
            p_38098_ = \u00e2\u02dc\u0192;
            if (railShape.m_61745_()) {
                p_38098_ = \u00e2\u02dc\u0192 + 1;
            }
            Pair<Vec3i, Vec3i> \u00e2\u02dc\u01922 = AbstractMinecart.m_38125_(railShape);
            Vec3i \u00e2\u02dc\u01923 = (Vec3i)\u00e2\u02dc\u01922.getFirst();
            Vec3i \u00e2\u02dc\u01924 = (Vec3i)\u00e2\u02dc\u01922.getSecond();
            double \u00e2\u02dc\u01925 = \u00e2\u02dc\u01924.m_123341_() - \u00e2\u02dc\u01923.m_123341_();
            double \u00e2\u02dc\u01926 = \u00e2\u02dc\u01924.m_123343_() - \u00e2\u02dc\u01923.m_123343_();
            double \u00e2\u02dc\u01927 = Math.sqrt(\u00e2\u02dc\u01925 * \u00e2\u02dc\u01925 + \u00e2\u02dc\u01926 * \u00e2\u02dc\u01926);
            if (\u00e2\u02dc\u01923.m_123342_() != 0 && Mth.m_14107_(p_38097_ += (\u00e2\u02dc\u01925 /= \u00e2\u02dc\u01927) * p_38100_) - n == \u00e2\u02dc\u01923.m_123341_() && Mth.m_14107_(p_38099_ += (\u00e2\u02dc\u01926 /= \u00e2\u02dc\u01927) * p_38100_) - \u00e2\u02dc\u0192 == \u00e2\u02dc\u01923.m_123343_()) {
                p_38098_ += (double)\u00e2\u02dc\u01923.m_123342_();
            } else if (\u00e2\u02dc\u01924.m_123342_() != 0 && Mth.m_14107_(p_38097_) - n == \u00e2\u02dc\u01924.m_123341_() && Mth.m_14107_(p_38099_) - \u00e2\u02dc\u0192 == \u00e2\u02dc\u01924.m_123343_()) {
                p_38098_ += (double)\u00e2\u02dc\u01924.m_123342_();
            }
            return this.m_38179_(p_38097_, p_38098_, p_38099_);
        }
        return null;
    }

    @Nullable
    public Vec3 m_38179_(double p_38180_, double p_38181_, double p_38182_) {
        int n = Mth.m_14107_(p_38180_);
        if (this.f_19853_.m_8055_(new BlockPos(n, (\u00e2\u02dc\u0192 = Mth.m_14107_(p_38181_)) - 1, \u00e2\u02dc\u0192 = Mth.m_14107_(p_38182_))).m_60620_(BlockTags.f_13034_)) {
            --\u00e2\u02dc\u0192;
        }
        if (BaseRailBlock.m_49416_(\u00e2\u02dc\u0192 = this.f_19853_.m_8055_(new BlockPos(n, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192)))) {
            double \u00e2\u02dc\u019214;
            RailShape railShape = \u00e2\u02dc\u0192.m_61143_(((BaseRailBlock)\u00e2\u02dc\u0192.m_60734_()).m_7978_());
            Pair<Vec3i, Vec3i> \u00e2\u02dc\u01922 = AbstractMinecart.m_38125_(railShape);
            Vec3i \u00e2\u02dc\u01923 = (Vec3i)\u00e2\u02dc\u01922.getFirst();
            Vec3i \u00e2\u02dc\u01924 = (Vec3i)\u00e2\u02dc\u01922.getSecond();
            double \u00e2\u02dc\u01925 = (double)n + 0.5 + (double)\u00e2\u02dc\u01923.m_123341_() * 0.5;
            double \u00e2\u02dc\u01926 = (double)\u00e2\u02dc\u0192 + 0.0625 + (double)\u00e2\u02dc\u01923.m_123342_() * 0.5;
            double \u00e2\u02dc\u01927 = (double)\u00e2\u02dc\u0192 + 0.5 + (double)\u00e2\u02dc\u01923.m_123343_() * 0.5;
            double \u00e2\u02dc\u01928 = (double)n + 0.5 + (double)\u00e2\u02dc\u01924.m_123341_() * 0.5;
            double \u00e2\u02dc\u01929 = (double)\u00e2\u02dc\u0192 + 0.0625 + (double)\u00e2\u02dc\u01924.m_123342_() * 0.5;
            double \u00e2\u02dc\u019210 = (double)\u00e2\u02dc\u0192 + 0.5 + (double)\u00e2\u02dc\u01924.m_123343_() * 0.5;
            double \u00e2\u02dc\u019211 = \u00e2\u02dc\u01928 - \u00e2\u02dc\u01925;
            double \u00e2\u02dc\u019212 = (\u00e2\u02dc\u01929 - \u00e2\u02dc\u01926) * 2.0;
            double \u00e2\u02dc\u019213 = \u00e2\u02dc\u019210 - \u00e2\u02dc\u01927;
            if (\u00e2\u02dc\u019211 == 0.0) {
                \u00e2\u02dc\u019214 = p_38182_ - (double)\u00e2\u02dc\u0192;
            } else if (\u00e2\u02dc\u019213 == 0.0) {
                \u00e2\u02dc\u019214 = p_38180_ - (double)n;
            } else {
                double \u00e2\u02dc\u019215 = p_38180_ - \u00e2\u02dc\u01925;
                double \u00e2\u02dc\u019216 = p_38182_ - \u00e2\u02dc\u01927;
                \u00e2\u02dc\u019214 = (\u00e2\u02dc\u019215 * \u00e2\u02dc\u019211 + \u00e2\u02dc\u019216 * \u00e2\u02dc\u019213) * 2.0;
            }
            p_38180_ = \u00e2\u02dc\u01925 + \u00e2\u02dc\u019211 * \u00e2\u02dc\u019214;
            p_38181_ = \u00e2\u02dc\u01926 + \u00e2\u02dc\u019212 * \u00e2\u02dc\u019214;
            p_38182_ = \u00e2\u02dc\u01927 + \u00e2\u02dc\u019213 * \u00e2\u02dc\u019214;
            if (\u00e2\u02dc\u019212 < 0.0) {
                p_38181_ += 1.0;
            } else if (\u00e2\u02dc\u019212 > 0.0) {
                p_38181_ += 0.5;
            }
            return new Vec3(p_38180_, p_38181_, p_38182_);
        }
        return null;
    }

    @Override
    public AABB m_6921_() {
        AABB aABB = this.m_142469_();
        if (this.m_38184_()) {
            return aABB.m_82400_((double)Math.abs(this.m_38183_()) / 16.0);
        }
        return aABB;
    }

    @Override
    protected void m_7378_(CompoundTag p_38137_) {
        if (p_38137_.m_128471_("CustomDisplayTile")) {
            this.m_38146_(NbtUtils.m_129241_(p_38137_.m_128469_("DisplayState")));
            this.m_38174_(p_38137_.m_128451_("DisplayOffset"));
        }
    }

    @Override
    protected void m_7380_(CompoundTag p_38151_) {
        if (this.m_38184_()) {
            p_38151_.m_128379_("CustomDisplayTile", true);
            p_38151_.m_128365_("DisplayState", NbtUtils.m_129202_(this.m_38178_()));
            p_38151_.m_128405_("DisplayOffset", this.m_38183_());
        }
    }

    @Override
    public void m_7334_(Entity p_38165_) {
        if (this.f_19853_.f_46443_) {
            return;
        }
        if (p_38165_.f_19794_ || this.f_19794_) {
            return;
        }
        if (this.m_20363_(p_38165_)) {
            return;
        }
        double d = p_38165_.m_20185_() - this.m_20185_();
        \u00e2\u02dc\u0192 = d * d + (\u00e2\u02dc\u0192 = p_38165_.m_20189_() - this.m_20189_()) * \u00e2\u02dc\u0192;
        if (\u00e2\u02dc\u0192 >= (double)1.0E-4f) {
            \u00e2\u02dc\u0192 = Math.sqrt(\u00e2\u02dc\u0192);
            d /= \u00e2\u02dc\u0192;
            \u00e2\u02dc\u0192 /= \u00e2\u02dc\u0192;
            \u00e2\u02dc\u0192 = 1.0 / \u00e2\u02dc\u0192;
            if (\u00e2\u02dc\u0192 > 1.0) {
                \u00e2\u02dc\u0192 = 1.0;
            }
            d *= \u00e2\u02dc\u0192;
            \u00e2\u02dc\u0192 *= \u00e2\u02dc\u0192;
            d *= (double)0.1f;
            \u00e2\u02dc\u0192 *= (double)0.1f;
            d *= 0.5;
            \u00e2\u02dc\u0192 *= 0.5;
            if (p_38165_ instanceof AbstractMinecart) {
                \u00e2\u02dc\u0192 = p_38165_.m_20185_() - this.m_20185_();
                Vec3 vec3 = new Vec3(\u00e2\u02dc\u0192, 0.0, \u00e2\u02dc\u0192 = p_38165_.m_20189_() - this.m_20189_()).m_82541_();
                double \u00e2\u02dc\u01922 = Math.abs(vec3.m_82526_(\u00e2\u02dc\u0192 = new Vec3(Mth.m_14089_(this.m_146908_() * ((float)Math.PI / 180)), 0.0, Mth.m_14031_(this.m_146908_() * ((float)Math.PI / 180))).m_82541_()));
                if (\u00e2\u02dc\u01922 < (double)0.8f) {
                    return;
                }
                \u00e2\u02dc\u0192 = this.m_20184_();
                \u00e2\u02dc\u0192 = p_38165_.m_20184_();
                if (((AbstractMinecart)p_38165_).m_6064_() == Type.FURNACE && this.m_6064_() != Type.FURNACE) {
                    this.m_20256_(\u00e2\u02dc\u0192.m_82542_(0.2, 1.0, 0.2));
                    this.m_5997_(\u00e2\u02dc\u0192.f_82479_ - d, 0.0, \u00e2\u02dc\u0192.f_82481_ - \u00e2\u02dc\u0192);
                    p_38165_.m_20256_(\u00e2\u02dc\u0192.m_82542_(0.95, 1.0, 0.95));
                } else if (((AbstractMinecart)p_38165_).m_6064_() != Type.FURNACE && this.m_6064_() == Type.FURNACE) {
                    p_38165_.m_20256_(\u00e2\u02dc\u0192.m_82542_(0.2, 1.0, 0.2));
                    p_38165_.m_5997_(\u00e2\u02dc\u0192.f_82479_ + d, 0.0, \u00e2\u02dc\u0192.f_82481_ + \u00e2\u02dc\u0192);
                    this.m_20256_(\u00e2\u02dc\u0192.m_82542_(0.95, 1.0, 0.95));
                } else {
                    double d2 = (\u00e2\u02dc\u0192.f_82479_ + \u00e2\u02dc\u0192.f_82479_) / 2.0;
                    \u00e2\u02dc\u0192 = (\u00e2\u02dc\u0192.f_82481_ + \u00e2\u02dc\u0192.f_82481_) / 2.0;
                    this.m_20256_(\u00e2\u02dc\u0192.m_82542_(0.2, 1.0, 0.2));
                    this.m_5997_(d2 - d, 0.0, \u00e2\u02dc\u0192 - \u00e2\u02dc\u0192);
                    p_38165_.m_20256_(\u00e2\u02dc\u0192.m_82542_(0.2, 1.0, 0.2));
                    p_38165_.m_5997_(d2 + d, 0.0, \u00e2\u02dc\u0192 + \u00e2\u02dc\u0192);
                }
            } else {
                this.m_5997_(-d, 0.0, -\u00e2\u02dc\u0192);
                p_38165_.m_5997_(d / 4.0, 0.0, \u00e2\u02dc\u0192 / 4.0);
            }
        }
    }

    @Override
    public void m_6453_(double p_38102_, double p_38103_, double p_38104_, float p_38105_, float p_38106_, int p_38107_, boolean p_38108_) {
        this.f_38071_ = p_38102_;
        this.f_38072_ = p_38103_;
        this.f_38073_ = p_38104_;
        this.f_38074_ = p_38105_;
        this.f_38075_ = p_38106_;
        this.f_38070_ = p_38107_ + 2;
        this.m_20334_(this.f_38076_, this.f_38077_, this.f_38078_);
    }

    @Override
    public void m_6001_(double p_38171_, double p_38172_, double p_38173_) {
        this.f_38076_ = p_38171_;
        this.f_38077_ = p_38172_;
        this.f_38078_ = p_38173_;
        this.m_20334_(this.f_38076_, this.f_38077_, this.f_38078_);
    }

    public void m_38109_(float p_38110_) {
        this.f_19804_.m_135381_(f_38081_, Float.valueOf(p_38110_));
    }

    public float m_38169_() {
        return this.f_19804_.m_135370_(f_38081_).floatValue();
    }

    public void m_38154_(int p_38155_) {
        this.f_19804_.m_135381_(f_38079_, p_38155_);
    }

    public int m_38176_() {
        return this.f_19804_.m_135370_(f_38079_);
    }

    public void m_38160_(int p_38161_) {
        this.f_19804_.m_135381_(f_38080_, p_38161_);
    }

    public int m_38177_() {
        return this.f_19804_.m_135370_(f_38080_);
    }

    public abstract Type m_6064_();

    public BlockState m_38178_() {
        if (!this.m_38184_()) {
            return this.m_6390_();
        }
        return Block.m_49803_(this.m_20088_().m_135370_(f_38082_));
    }

    public BlockState m_6390_() {
        return Blocks.f_50016_.m_49966_();
    }

    public int m_38183_() {
        if (!this.m_38184_()) {
            return this.m_7144_();
        }
        return this.m_20088_().m_135370_(f_38083_);
    }

    public int m_7144_() {
        return 6;
    }

    public void m_38146_(BlockState p_38147_) {
        this.m_20088_().m_135381_(f_38082_, Block.m_49956_(p_38147_));
        this.m_38138_(true);
    }

    public void m_38174_(int p_38175_) {
        this.m_20088_().m_135381_(f_38083_, p_38175_);
        this.m_38138_(true);
    }

    public boolean m_38184_() {
        return this.m_20088_().m_135370_(f_38084_);
    }

    public void m_38138_(boolean p_38139_) {
        this.m_20088_().m_135381_(f_38084_, p_38139_);
    }

    @Override
    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket(this);
    }

    @Override
    public ItemStack m_142340_() {
        return new ItemStack(switch (this.m_6064_()) {
            case Type.FURNACE -> Items.f_42520_;
            case Type.CHEST -> Items.f_42519_;
            case Type.TNT -> Items.f_42693_;
            case Type.HOPPER -> Items.f_42694_;
            case Type.COMMAND_BLOCK -> Items.f_42657_;
            default -> Items.f_42449_;
        });
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type RIDEABLE = new Type();
        public static final /* enum */ Type CHEST = new Type();
        public static final /* enum */ Type FURNACE = new Type();
        public static final /* enum */ Type TNT = new Type();
        public static final /* enum */ Type SPAWNER = new Type();
        public static final /* enum */ Type HOPPER = new Type();
        public static final /* enum */ Type COMMAND_BLOCK = new Type();
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String p_38200_) {
            return Enum.valueOf(Type.class, p_38200_);
        }

        private static /* synthetic */ Type[] m_150253_() {
            return new Type[]{RIDEABLE, CHEST, FURNACE, TNT, SPAWNER, HOPPER, COMMAND_BLOCK};
        }

        static {
            $VALUES = Type.m_150253_();
        }
    }
}

