/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class AbstractContainerMenu {
    public static final int f_150385_ = -999;
    public static final int f_150386_ = 0;
    public static final int f_150387_ = 1;
    public static final int f_150388_ = 2;
    public static final int f_150389_ = 0;
    public static final int f_150390_ = 1;
    public static final int f_150391_ = 2;
    public static final int f_150392_ = Integer.MAX_VALUE;
    private final NonNullList<ItemStack> f_38841_ = NonNullList.m_122779_();
    public final NonNullList<Slot> f_38839_ = NonNullList.m_122779_();
    private final List<DataSlot> f_38842_ = Lists.newArrayList();
    private ItemStack f_150393_ = ItemStack.f_41583_;
    private final NonNullList<ItemStack> f_150394_ = NonNullList.m_122779_();
    private final IntList f_150395_ = new IntArrayList();
    private ItemStack f_150396_ = ItemStack.f_41583_;
    private int f_182405_;
    @Nullable
    private final MenuType<?> f_38843_;
    public final int f_38840_;
    private int f_38845_ = -1;
    private int f_38846_;
    private final Set<Slot> f_38847_ = Sets.newHashSet();
    private final List<ContainerListener> f_38848_ = Lists.newArrayList();
    @Nullable
    private ContainerSynchronizer f_150397_;
    private boolean f_150398_;

    protected AbstractContainerMenu(@Nullable MenuType<?> p_38851_, int p_38852_) {
        this.f_38843_ = p_38851_;
        this.f_38840_ = p_38852_;
    }

    protected static boolean m_38889_(ContainerLevelAccess p_38890_, Player p_38891_, Block p_38892_) {
        return p_38890_.m_39299_((p_38916_, p_38917_) -> {
            if (!p_38916_.m_8055_((BlockPos)p_38917_).m_60713_(p_38892_)) {
                return false;
            }
            return p_38891_.m_20275_((double)p_38917_.m_123341_() + 0.5, (double)p_38917_.m_123342_() + 0.5, (double)p_38917_.m_123343_() + 0.5) <= 64.0;
        }, true);
    }

    public MenuType<?> m_6772_() {
        if (this.f_38843_ == null) {
            throw new UnsupportedOperationException("Unable to construct this menu by type");
        }
        return this.f_38843_;
    }

    protected static void m_38869_(Container p_38870_, int p_38871_) {
        int n = p_38870_.m_6643_();
        if (n < p_38871_) {
            throw new IllegalArgumentException("Container size " + n + " is smaller than expected " + p_38871_);
        }
    }

    protected static void m_38886_(ContainerData p_38887_, int p_38888_) {
        int n = p_38887_.m_6499_();
        if (n < p_38888_) {
            throw new IllegalArgumentException("Container data count " + n + " is smaller than expected " + p_38888_);
        }
    }

    protected Slot m_38897_(Slot p_38898_) {
        p_38898_.f_40219_ = this.f_38839_.size();
        this.f_38839_.add(p_38898_);
        this.f_38841_.add(ItemStack.f_41583_);
        this.f_150394_.add(ItemStack.f_41583_);
        return p_38898_;
    }

    protected DataSlot m_38895_(DataSlot p_38896_) {
        this.f_38842_.add(p_38896_);
        this.f_150395_.add(0);
        return p_38896_;
    }

    protected void m_38884_(ContainerData p_38885_) {
        for (int i = 0; i < p_38885_.m_6499_(); ++i) {
            this.m_38895_(DataSlot.m_39403_(p_38885_, i));
        }
    }

    public void m_38893_(ContainerListener p_38894_) {
        if (this.f_38848_.contains(p_38894_)) {
            return;
        }
        this.f_38848_.add(p_38894_);
        this.m_38946_();
    }

    public void m_150416_(ContainerSynchronizer p_150417_) {
        this.f_150397_ = p_150417_;
        this.m_150429_();
    }

    public void m_150429_() {
        int n = this.f_38839_.size();
        for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < n; ++\u00e2\u02dc\u0192) {
            this.f_150394_.set(\u00e2\u02dc\u0192, this.f_38839_.get(\u00e2\u02dc\u0192).m_7993_().m_41777_());
        }
        this.f_150396_ = this.m_142621_().m_41777_();
        n = this.f_38842_.size();
        for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < n; ++\u00e2\u02dc\u0192) {
            this.f_150395_.set(\u00e2\u02dc\u0192, this.f_38842_.get(\u00e2\u02dc\u0192).m_6501_());
        }
        if (this.f_150397_ != null) {
            this.f_150397_.m_142589_(this, this.f_150394_, this.f_150396_, this.f_150395_.toIntArray());
        }
    }

    public void m_38943_(ContainerListener p_38944_) {
        this.f_38848_.remove(p_38944_);
    }

    public NonNullList<ItemStack> m_38927_() {
        NonNullList<ItemStack> nonNullList = NonNullList.m_122779_();
        for (Slot slot : this.f_38839_) {
            nonNullList.add(slot.m_7993_());
        }
        return nonNullList;
    }

    public void m_38946_() {
        Object object;
        int n;
        for (n = 0; n < this.f_38839_.size(); ++n) {
            object = this.f_38839_.get(n).m_7993_();
            Supplier \u00e2\u02dc\u01922 = Suppliers.memoize(((ItemStack)object)::m_41777_);
            this.m_150407_(n, (ItemStack)object, (java.util.function.Supplier<ItemStack>)\u00e2\u02dc\u01922);
            this.m_150435_(n, (ItemStack)object, (java.util.function.Supplier<ItemStack>)\u00e2\u02dc\u01922);
        }
        this.m_150445_();
        for (n = 0; n < this.f_38842_.size(); ++n) {
            object = this.f_38842_.get(n);
            int \u00e2\u02dc\u01923 = ((DataSlot)object).m_6501_();
            if (((DataSlot)object).m_39409_()) {
                this.m_182420_(n, \u00e2\u02dc\u01923);
            }
            this.m_150440_(n, \u00e2\u02dc\u01923);
        }
    }

    public void m_182423_() {
        Object object;
        int n;
        for (n = 0; n < this.f_38839_.size(); ++n) {
            object = this.f_38839_.get(n).m_7993_();
            this.m_150407_(n, (ItemStack)object, ((ItemStack)object)::m_41777_);
        }
        for (n = 0; n < this.f_38842_.size(); ++n) {
            object = this.f_38842_.get(n);
            if (!((DataSlot)object).m_39409_()) continue;
            this.m_182420_(n, ((DataSlot)object).m_6501_());
        }
        this.m_150429_();
    }

    private void m_182420_(int p_182421_, int p_182422_) {
        for (ContainerListener containerListener : this.f_38848_) {
            containerListener.m_142153_(this, p_182421_, p_182422_);
        }
    }

    private void m_150407_(int p_150408_, ItemStack p_150409_, java.util.function.Supplier<ItemStack> p_150410_) {
        ItemStack itemStack = this.f_38841_.get(p_150408_);
        if (!ItemStack.m_41728_(itemStack, p_150409_)) {
            \u00e2\u02dc\u0192 = p_150410_.get();
            this.f_38841_.set(p_150408_, \u00e2\u02dc\u0192);
            for (ContainerListener containerListener : this.f_38848_) {
                containerListener.m_7934_(this, p_150408_, \u00e2\u02dc\u0192);
            }
        }
    }

    private void m_150435_(int p_150436_, ItemStack p_150437_, java.util.function.Supplier<ItemStack> p_150438_) {
        if (this.f_150398_) {
            return;
        }
        ItemStack itemStack = this.f_150394_.get(p_150436_);
        if (!ItemStack.m_41728_(itemStack, p_150437_)) {
            \u00e2\u02dc\u0192 = p_150438_.get();
            this.f_150394_.set(p_150436_, \u00e2\u02dc\u0192);
            if (this.f_150397_ != null) {
                this.f_150397_.m_142074_(this, p_150436_, \u00e2\u02dc\u0192);
            }
        }
    }

    private void m_150440_(int p_150441_, int p_150442_) {
        if (this.f_150398_) {
            return;
        }
        int n = this.f_150395_.getInt(p_150441_);
        if (n != p_150442_) {
            this.f_150395_.set(p_150441_, p_150442_);
            if (this.f_150397_ != null) {
                this.f_150397_.m_142145_(this, p_150441_, p_150442_);
            }
        }
    }

    private void m_150445_() {
        if (this.f_150398_) {
            return;
        }
        if (!ItemStack.m_41728_(this.m_142621_(), this.f_150396_)) {
            this.f_150396_ = this.m_142621_().m_41777_();
            if (this.f_150397_ != null) {
                this.f_150397_.m_142529_(this, this.f_150396_);
            }
        }
    }

    public void m_150404_(int p_150405_, ItemStack p_150406_) {
        this.f_150394_.set(p_150405_, p_150406_.m_41777_());
    }

    public void m_182414_(int p_182415_, ItemStack p_182416_) {
        this.f_150394_.set(p_182415_, p_182416_);
    }

    public void m_150422_(ItemStack p_150423_) {
        this.f_150396_ = p_150423_.m_41777_();
    }

    public boolean m_6366_(Player p_38875_, int p_38876_) {
        return false;
    }

    public Slot m_38853_(int p_38854_) {
        return this.f_38839_.get(p_38854_);
    }

    public ItemStack m_7648_(Player p_38941_, int p_38942_) {
        return this.f_38839_.get(p_38942_).m_7993_();
    }

    public void m_150399_(int p_150400_, int p_150401_, ClickType p_150402_, Player p_150403_) {
        try {
            this.m_150430_(p_150400_, p_150401_, p_150402_, p_150403_);
        }
        catch (Exception exception) {
            CrashReport crashReport = CrashReport.m_127521_(exception, "Container click");
            CrashReportCategory \u00e2\u02dc\u01922 = crashReport.m_127514_("Click info");
            \u00e2\u02dc\u01922.m_128165_("Menu Type", () -> this.f_38843_ != null ? Registry.f_122863_.m_7981_(this.f_38843_).toString() : "<no type>");
            \u00e2\u02dc\u01922.m_128165_("Menu Class", () -> this.getClass().getCanonicalName());
            \u00e2\u02dc\u01922.m_128159_("Slot Count", this.f_38839_.size());
            \u00e2\u02dc\u01922.m_128159_("Slot", p_150400_);
            \u00e2\u02dc\u01922.m_128159_("Button", p_150401_);
            \u00e2\u02dc\u01922.m_128159_("Type", (Object)p_150402_);
            throw new ReportedException(crashReport);
        }
    }

    private void m_150430_(int p_150431_, int p_150432_, ClickType p_150433_, Player p_150434_) {
        block39: {
            block50: {
                block46: {
                    ItemStack \u00e2\u02dc\u019211;
                    ItemStack \u00e2\u02dc\u019210;
                    block49: {
                        Slot slot;
                        block48: {
                            block47: {
                                block44: {
                                    block45: {
                                        block43: {
                                            block37: {
                                                block42: {
                                                    block41: {
                                                        block40: {
                                                            block38: {
                                                                Inventory inventory = p_150434_.m_150109_();
                                                                if (p_150433_ != ClickType.QUICK_CRAFT) break block37;
                                                                int \u00e2\u02dc\u01922 = this.f_38846_;
                                                                this.f_38846_ = AbstractContainerMenu.m_38947_(p_150432_);
                                                                if (\u00e2\u02dc\u01922 == 1 && this.f_38846_ == 2 || \u00e2\u02dc\u01922 == this.f_38846_) break block38;
                                                                this.m_38951_();
                                                                break block39;
                                                            }
                                                            if (!this.m_142621_().m_41619_()) break block40;
                                                            this.m_38951_();
                                                            break block39;
                                                        }
                                                        if (this.f_38846_ != 0) break block41;
                                                        this.f_38845_ = AbstractContainerMenu.m_38928_(p_150432_);
                                                        if (AbstractContainerMenu.m_38862_(this.f_38845_, p_150434_)) {
                                                            this.f_38846_ = 1;
                                                            this.f_38847_.clear();
                                                        } else {
                                                            this.m_38951_();
                                                        }
                                                        break block39;
                                                    }
                                                    if (this.f_38846_ != 1) break block42;
                                                    Slot slot2 = this.f_38839_.get(p_150431_);
                                                    if (!AbstractContainerMenu.m_38899_(slot2, \u00e2\u02dc\u0192 = this.m_142621_(), true) || !slot2.m_5857_(\u00e2\u02dc\u0192) || this.f_38845_ != 2 && \u00e2\u02dc\u0192.m_41613_() <= this.f_38847_.size() || !this.m_5622_(slot2)) break block39;
                                                    this.f_38847_.add(slot2);
                                                    break block39;
                                                }
                                                if (this.f_38846_ == 2) {
                                                    if (!this.f_38847_.isEmpty()) {
                                                        if (this.f_38847_.size() == 1) {
                                                            int n = this.f_38847_.iterator().next().f_40219_;
                                                            this.m_38951_();
                                                            this.m_150430_(n, this.f_38845_, ClickType.PICKUP, p_150434_);
                                                            return;
                                                        }
                                                        ItemStack itemStack = this.m_142621_().m_41777_();
                                                        int \u00e2\u02dc\u01923 = this.m_142621_().m_41613_();
                                                        for (Slot slot3 : this.f_38847_) {
                                                            ItemStack itemStack2 = this.m_142621_();
                                                            if (slot3 == null || !AbstractContainerMenu.m_38899_(slot3, itemStack2, true) || !slot3.m_5857_(itemStack2) || this.f_38845_ != 2 && itemStack2.m_41613_() < this.f_38847_.size() || !this.m_5622_(slot3)) continue;
                                                            \u00e2\u02dc\u0192 = itemStack.m_41777_();
                                                            int \u00e2\u02dc\u01924 = slot3.m_6657_() ? slot3.m_7993_().m_41613_() : 0;
                                                            AbstractContainerMenu.m_38922_(this.f_38847_, this.f_38845_, \u00e2\u02dc\u0192, \u00e2\u02dc\u01924);
                                                            int \u00e2\u02dc\u01925 = Math.min(\u00e2\u02dc\u0192.m_41741_(), slot3.m_5866_(\u00e2\u02dc\u0192));
                                                            if (\u00e2\u02dc\u0192.m_41613_() > \u00e2\u02dc\u01925) {
                                                                \u00e2\u02dc\u0192.m_41764_(\u00e2\u02dc\u01925);
                                                            }
                                                            \u00e2\u02dc\u01923 -= \u00e2\u02dc\u0192.m_41613_() - \u00e2\u02dc\u01924;
                                                            slot3.m_5852_(\u00e2\u02dc\u0192);
                                                        }
                                                        itemStack.m_41764_(\u00e2\u02dc\u01923);
                                                        this.m_142503_(itemStack);
                                                    }
                                                    this.m_38951_();
                                                } else {
                                                    this.m_38951_();
                                                }
                                                break block39;
                                            }
                                            if (this.f_38846_ == 0) break block43;
                                            this.m_38951_();
                                            break block39;
                                        }
                                        if (p_150433_ != ClickType.PICKUP && p_150433_ != ClickType.QUICK_MOVE || p_150432_ != 0 && p_150432_ != 1) break block44;
                                        ClickAction clickAction = \u00e2\u02dc\u0192 = p_150432_ == 0 ? ClickAction.PRIMARY : ClickAction.SECONDARY;
                                        if (p_150431_ != -999) break block45;
                                        if (this.m_142621_().m_41619_()) break block39;
                                        if (\u00e2\u02dc\u0192 == ClickAction.PRIMARY) {
                                            p_150434_.m_36176_(this.m_142621_(), true);
                                            this.m_142503_(ItemStack.f_41583_);
                                        } else {
                                            p_150434_.m_36176_(this.m_142621_().m_41620_(1), true);
                                        }
                                        break block39;
                                    }
                                    if (p_150433_ == ClickType.QUICK_MOVE) {
                                        if (p_150431_ < 0) {
                                            return;
                                        }
                                        Slot slot4 = this.f_38839_.get(p_150431_);
                                        if (!slot4.m_8010_(p_150434_)) {
                                            return;
                                        }
                                        ItemStack \u00e2\u02dc\u01926 = this.m_7648_(p_150434_, p_150431_);
                                        while (!\u00e2\u02dc\u01926.m_41619_() && ItemStack.m_41746_(slot4.m_7993_(), \u00e2\u02dc\u01926)) {
                                            \u00e2\u02dc\u01926 = this.m_7648_(p_150434_, p_150431_);
                                        }
                                    } else {
                                        Slot slot5;
                                        if (p_150431_ < 0) {
                                            return;
                                        }
                                        slot5 = this.f_38839_.get(p_150431_);
                                        ItemStack \u00e2\u02dc\u01927 = slot5.m_7993_();
                                        ItemStack \u00e2\u02dc\u01928 = this.m_142621_();
                                        p_150434_.m_141945_(\u00e2\u02dc\u01928, slot5.m_7993_(), \u00e2\u02dc\u0192);
                                        if (!\u00e2\u02dc\u01928.m_150926_(slot5, \u00e2\u02dc\u0192, p_150434_) && !\u00e2\u02dc\u01927.m_150932_(\u00e2\u02dc\u01928, slot5, \u00e2\u02dc\u0192, p_150434_, this.m_150446_())) {
                                            if (\u00e2\u02dc\u01927.m_41619_()) {
                                                if (!\u00e2\u02dc\u01928.m_41619_()) {
                                                    int n = \u00e2\u02dc\u0192 == ClickAction.PRIMARY ? \u00e2\u02dc\u01928.m_41613_() : 1;
                                                    this.m_142503_(slot5.m_150656_(\u00e2\u02dc\u01928, n));
                                                }
                                            } else if (slot5.m_8010_(p_150434_)) {
                                                if (\u00e2\u02dc\u01928.m_41619_()) {
                                                    int n = \u00e2\u02dc\u0192 == ClickAction.PRIMARY ? \u00e2\u02dc\u01927.m_41613_() : (\u00e2\u02dc\u01927.m_41613_() + 1) / 2;
                                                    Optional<ItemStack> \u00e2\u02dc\u01929 = slot5.m_150641_(n, Integer.MAX_VALUE, p_150434_);
                                                    \u00e2\u02dc\u01929.ifPresent(p_150421_ -> {
                                                        this.m_142503_((ItemStack)p_150421_);
                                                        slot5.m_142406_(p_150434_, (ItemStack)p_150421_);
                                                    });
                                                } else if (slot5.m_5857_(\u00e2\u02dc\u01928)) {
                                                    if (ItemStack.m_150942_(\u00e2\u02dc\u01927, \u00e2\u02dc\u01928)) {
                                                        \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 == ClickAction.PRIMARY ? \u00e2\u02dc\u01928.m_41613_() : 1;
                                                        this.m_142503_(slot5.m_150656_(\u00e2\u02dc\u01928, \u00e2\u02dc\u0192));
                                                    } else if (\u00e2\u02dc\u01928.m_41613_() <= slot5.m_5866_(\u00e2\u02dc\u01928)) {
                                                        slot5.m_5852_(\u00e2\u02dc\u01928);
                                                        this.m_142503_(\u00e2\u02dc\u01927);
                                                    }
                                                } else if (ItemStack.m_150942_(\u00e2\u02dc\u01927, \u00e2\u02dc\u01928)) {
                                                    Optional<ItemStack> optional = slot5.m_150641_(\u00e2\u02dc\u01927.m_41613_(), \u00e2\u02dc\u01928.m_41741_() - \u00e2\u02dc\u01928.m_41613_(), p_150434_);
                                                    optional.ifPresent(p_150428_ -> {
                                                        \u00e2\u02dc\u01928.m_41769_(p_150428_.m_41613_());
                                                        slot5.m_142406_(p_150434_, (ItemStack)p_150428_);
                                                    });
                                                }
                                            }
                                        }
                                        slot5.m_6654_();
                                    }
                                    break block39;
                                }
                                if (p_150433_ != ClickType.SWAP) break block46;
                                slot = this.f_38839_.get(p_150431_);
                                \u00e2\u02dc\u019210 = inventory.m_8020_(p_150432_);
                                \u00e2\u02dc\u019211 = slot.m_7993_();
                                if (\u00e2\u02dc\u019210.m_41619_() && \u00e2\u02dc\u019211.m_41619_()) break block39;
                                if (!\u00e2\u02dc\u019210.m_41619_()) break block47;
                                if (!slot.m_8010_(p_150434_)) break block39;
                                inventory.m_6836_(p_150432_, \u00e2\u02dc\u019211);
                                slot.m_6405_(\u00e2\u02dc\u019211.m_41613_());
                                slot.m_5852_(ItemStack.f_41583_);
                                slot.m_142406_(p_150434_, \u00e2\u02dc\u019211);
                                break block39;
                            }
                            if (!\u00e2\u02dc\u019211.m_41619_()) break block48;
                            if (!slot.m_5857_(\u00e2\u02dc\u019210)) break block39;
                            int n = slot.m_5866_(\u00e2\u02dc\u019210);
                            if (\u00e2\u02dc\u019210.m_41613_() > n) {
                                slot.m_5852_(\u00e2\u02dc\u019210.m_41620_(n));
                            } else {
                                slot.m_5852_(\u00e2\u02dc\u019210);
                                inventory.m_6836_(p_150432_, ItemStack.f_41583_);
                            }
                            break block39;
                        }
                        if (!slot.m_8010_(p_150434_) || !slot.m_5857_(\u00e2\u02dc\u019210)) break block39;
                        int \u00e2\u02dc\u019212 = slot.m_5866_(\u00e2\u02dc\u019210);
                        if (\u00e2\u02dc\u019210.m_41613_() <= \u00e2\u02dc\u019212) break block49;
                        slot.m_5852_(\u00e2\u02dc\u019210.m_41620_(\u00e2\u02dc\u019212));
                        slot.m_142406_(p_150434_, \u00e2\u02dc\u019211);
                        if (inventory.m_36054_(\u00e2\u02dc\u019211)) break block39;
                        p_150434_.m_36176_(\u00e2\u02dc\u019211, true);
                        break block39;
                    }
                    slot.m_5852_(\u00e2\u02dc\u019210);
                    inventory.m_6836_(p_150432_, \u00e2\u02dc\u019211);
                    slot.m_142406_(p_150434_, \u00e2\u02dc\u019211);
                    break block39;
                }
                if (p_150433_ != ClickType.CLONE || !p_150434_.m_150110_().f_35937_ || !this.m_142621_().m_41619_() || p_150431_ < 0) break block50;
                \u00e2\u02dc\u0192 = this.f_38839_.get(p_150431_);
                if (!\u00e2\u02dc\u0192.m_6657_()) break block39;
                ItemStack itemStack = \u00e2\u02dc\u0192.m_7993_().m_41777_();
                itemStack.m_41764_(itemStack.m_41741_());
                this.m_142503_(itemStack);
                break block39;
            }
            if (p_150433_ == ClickType.THROW && this.m_142621_().m_41619_() && p_150431_ >= 0) {
                Slot slot = this.f_38839_.get(p_150431_);
                int \u00e2\u02dc\u019213 = p_150432_ == 0 ? 1 : slot.m_7993_().m_41613_();
                ItemStack \u00e2\u02dc\u019214 = slot.m_150647_(\u00e2\u02dc\u019213, Integer.MAX_VALUE, p_150434_);
                p_150434_.m_36176_(\u00e2\u02dc\u019214, true);
            } else if (p_150433_ == ClickType.PICKUP_ALL && p_150431_ >= 0) {
                \u00e2\u02dc\u0192 = this.f_38839_.get(p_150431_);
                ItemStack itemStack = this.m_142621_();
                if (!(itemStack.m_41619_() || \u00e2\u02dc\u0192.m_6657_() && \u00e2\u02dc\u0192.m_8010_(p_150434_))) {
                    int n = p_150432_ == 0 ? 0 : this.f_38839_.size() - 1;
                    \u00e2\u02dc\u0192 = p_150432_ == 0 ? 1 : -1;
                    for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < 2; ++\u00e2\u02dc\u0192) {
                        for (\u00e2\u02dc\u0192 = n; \u00e2\u02dc\u0192 >= 0 && \u00e2\u02dc\u0192 < this.f_38839_.size() && itemStack.m_41613_() < itemStack.m_41741_(); \u00e2\u02dc\u0192 += \u00e2\u02dc\u0192) {
                            Slot slot = this.f_38839_.get(\u00e2\u02dc\u0192);
                            if (!slot.m_6657_() || !AbstractContainerMenu.m_38899_(slot, itemStack, true) || !slot.m_8010_(p_150434_) || !this.m_5882_(itemStack, slot)) continue;
                            ItemStack \u00e2\u02dc\u019215 = slot.m_7993_();
                            if (\u00e2\u02dc\u0192 == 0 && \u00e2\u02dc\u019215.m_41613_() == \u00e2\u02dc\u019215.m_41741_()) continue;
                            ItemStack \u00e2\u02dc\u019216 = slot.m_150647_(\u00e2\u02dc\u019215.m_41613_(), itemStack.m_41741_() - itemStack.m_41613_(), p_150434_);
                            itemStack.m_41769_(\u00e2\u02dc\u019216.m_41613_());
                        }
                    }
                }
            }
        }
    }

    private SlotAccess m_150446_() {
        return new SlotAccess(){

            @Override
            public ItemStack m_142196_() {
                return AbstractContainerMenu.this.m_142621_();
            }

            @Override
            public boolean m_142104_(ItemStack p_150452_) {
                AbstractContainerMenu.this.m_142503_(p_150452_);
                return true;
            }
        };
    }

    public boolean m_5882_(ItemStack p_38908_, Slot p_38909_) {
        return true;
    }

    public void m_6877_(Player p_38940_) {
        ItemStack itemStack;
        if (p_38940_ instanceof ServerPlayer && !(itemStack = this.m_142621_()).m_41619_()) {
            if (!p_38940_.m_6084_() || ((ServerPlayer)p_38940_).m_9232_()) {
                p_38940_.m_36176_(itemStack, false);
            } else {
                p_38940_.m_150109_().m_150079_(itemStack);
            }
            this.m_142503_(ItemStack.f_41583_);
        }
    }

    protected void m_150411_(Player p_150412_, Container p_150413_) {
        if (!p_150412_.m_6084_() || p_150412_ instanceof ServerPlayer && ((ServerPlayer)p_150412_).m_9232_()) {
            for (int i = 0; i < p_150413_.m_6643_(); ++i) {
                p_150412_.m_36176_(p_150413_.m_8016_(i), false);
            }
            return;
        }
        for (int i = 0; i < p_150413_.m_6643_(); ++i) {
            Inventory inventory = p_150412_.m_150109_();
            if (!(inventory.f_35978_ instanceof ServerPlayer)) continue;
            inventory.m_150079_(p_150413_.m_8016_(i));
        }
    }

    public void m_6199_(Container p_38868_) {
        this.m_38946_();
    }

    public void m_182406_(int p_182407_, int p_182408_, ItemStack p_182409_) {
        this.m_38853_(p_182407_).m_5852_(p_182409_);
        this.f_182405_ = p_182408_;
    }

    public void m_182410_(int p_182411_, List<ItemStack> p_182412_, ItemStack p_182413_) {
        for (int i = 0; i < p_182412_.size(); ++i) {
            this.m_38853_(i).m_5852_(p_182412_.get(i));
        }
        this.f_150393_ = p_182413_;
        this.f_182405_ = p_182411_;
    }

    public void m_7511_(int p_38855_, int p_38856_) {
        this.f_38842_.get(p_38855_).m_6422_(p_38856_);
    }

    public abstract boolean m_6875_(Player var1);

    protected boolean m_38903_(ItemStack p_38904_, int p_38905_, int p_38906_, boolean p_38907_) {
        ItemStack \u00e2\u02dc\u01923;
        boolean \u00e2\u02dc\u01924 = false;
        int \u00e2\u02dc\u01922 = p_38905_;
        if (p_38907_) {
            \u00e2\u02dc\u01922 = p_38906_ - 1;
        }
        if (p_38904_.m_41753_()) {
            while (!p_38904_.m_41619_() && (p_38907_ ? \u00e2\u02dc\u01922 >= p_38905_ : \u00e2\u02dc\u01922 < p_38906_)) {
                Slot slot = this.f_38839_.get(\u00e2\u02dc\u01922);
                \u00e2\u02dc\u01923 = slot.m_7993_();
                if (!\u00e2\u02dc\u01923.m_41619_() && ItemStack.m_150942_(p_38904_, \u00e2\u02dc\u01923)) {
                    int n = \u00e2\u02dc\u01923.m_41613_() + p_38904_.m_41613_();
                    if (n <= p_38904_.m_41741_()) {
                        p_38904_.m_41764_(0);
                        \u00e2\u02dc\u01923.m_41764_(n);
                        slot.m_6654_();
                        \u00e2\u02dc\u01924 = true;
                    } else if (\u00e2\u02dc\u01923.m_41613_() < p_38904_.m_41741_()) {
                        p_38904_.m_41774_(p_38904_.m_41741_() - \u00e2\u02dc\u01923.m_41613_());
                        \u00e2\u02dc\u01923.m_41764_(p_38904_.m_41741_());
                        slot.m_6654_();
                        \u00e2\u02dc\u01924 = true;
                    }
                }
                if (p_38907_) {
                    --\u00e2\u02dc\u01922;
                    continue;
                }
                ++\u00e2\u02dc\u01922;
            }
        }
        if (!p_38904_.m_41619_()) {
            \u00e2\u02dc\u01922 = p_38907_ ? p_38906_ - 1 : p_38905_;
            while (p_38907_ ? \u00e2\u02dc\u01922 >= p_38905_ : \u00e2\u02dc\u01922 < p_38906_) {
                slot = this.f_38839_.get(\u00e2\u02dc\u01922);
                \u00e2\u02dc\u01923 = slot.m_7993_();
                if (\u00e2\u02dc\u01923.m_41619_() && slot.m_5857_(p_38904_)) {
                    if (p_38904_.m_41613_() > slot.m_6641_()) {
                        slot.m_5852_(p_38904_.m_41620_(slot.m_6641_()));
                    } else {
                        slot.m_5852_(p_38904_.m_41620_(p_38904_.m_41613_()));
                    }
                    slot.m_6654_();
                    \u00e2\u02dc\u01924 = true;
                    break;
                }
                if (p_38907_) {
                    --\u00e2\u02dc\u01922;
                    continue;
                }
                ++\u00e2\u02dc\u01922;
            }
        }
        return \u00e2\u02dc\u01924;
    }

    public static int m_38928_(int p_38929_) {
        return p_38929_ >> 2 & 3;
    }

    public static int m_38947_(int p_38948_) {
        return p_38948_ & 3;
    }

    public static int m_38930_(int p_38931_, int p_38932_) {
        return p_38931_ & 3 | (p_38932_ & 3) << 2;
    }

    public static boolean m_38862_(int p_38863_, Player p_38864_) {
        if (p_38863_ == 0) {
            return true;
        }
        if (p_38863_ == 1) {
            return true;
        }
        return p_38863_ == 2 && p_38864_.m_150110_().f_35937_;
    }

    protected void m_38951_() {
        this.f_38846_ = 0;
        this.f_38847_.clear();
    }

    public static boolean m_38899_(@Nullable Slot p_38900_, ItemStack p_38901_, boolean p_38902_) {
        boolean bl;
        boolean bl2 = bl = p_38900_ == null || !p_38900_.m_6657_();
        if (!bl && ItemStack.m_150942_(p_38901_, p_38900_.m_7993_())) {
            return p_38900_.m_7993_().m_41613_() + (p_38902_ ? 0 : p_38901_.m_41613_()) <= p_38901_.m_41741_();
        }
        return bl;
    }

    public static void m_38922_(Set<Slot> p_38923_, int p_38924_, ItemStack p_38925_, int p_38926_) {
        switch (p_38924_) {
            case 0: {
                p_38925_.m_41764_(Mth.m_14143_((float)p_38925_.m_41613_() / (float)p_38923_.size()));
                break;
            }
            case 1: {
                p_38925_.m_41764_(1);
                break;
            }
            case 2: {
                p_38925_.m_41764_(p_38925_.m_41720_().m_41459_());
            }
        }
        p_38925_.m_41769_(p_38926_);
    }

    public boolean m_5622_(Slot p_38945_) {
        return true;
    }

    public static int m_38918_(@Nullable BlockEntity p_38919_) {
        if (p_38919_ instanceof Container) {
            return AbstractContainerMenu.m_38938_((Container)((Object)p_38919_));
        }
        return 0;
    }

    public static int m_38938_(@Nullable Container p_38939_) {
        if (p_38939_ == null) {
            return 0;
        }
        int n = 0;
        float \u00e2\u02dc\u01922 = 0.0f;
        for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < p_38939_.m_6643_(); ++\u00e2\u02dc\u0192) {
            ItemStack itemStack = p_38939_.m_8020_(\u00e2\u02dc\u0192);
            if (itemStack.m_41619_()) continue;
            \u00e2\u02dc\u01922 += (float)itemStack.m_41613_() / (float)Math.min(p_38939_.m_6893_(), itemStack.m_41741_());
            ++n;
        }
        return Mth.m_14143_((\u00e2\u02dc\u01922 /= (float)p_38939_.m_6643_()) * 14.0f) + (n > 0 ? 1 : 0);
    }

    public void m_142503_(ItemStack p_150439_) {
        this.f_150393_ = p_150439_;
    }

    public ItemStack m_142621_() {
        return this.f_150393_;
    }

    public void m_150443_() {
        this.f_150398_ = true;
    }

    public void m_150444_() {
        this.f_150398_ = false;
    }

    public void m_150414_(AbstractContainerMenu p_150415_) {
        Slot slot;
        int n;
        HashBasedTable hashBasedTable = HashBasedTable.create();
        for (n = 0; n < p_150415_.f_38839_.size(); ++n) {
            slot = p_150415_.f_38839_.get(n);
            hashBasedTable.put((Object)slot.f_40218_, (Object)slot.m_150661_(), (Object)n);
        }
        for (n = 0; n < this.f_38839_.size(); ++n) {
            slot = this.f_38839_.get(n);
            Integer \u00e2\u02dc\u01922 = (Integer)hashBasedTable.get((Object)slot.f_40218_, (Object)slot.m_150661_());
            if (\u00e2\u02dc\u01922 == null) continue;
            this.f_38841_.set(n, p_150415_.f_38841_.get(\u00e2\u02dc\u01922));
            this.f_150394_.set(n, p_150415_.f_150394_.get(\u00e2\u02dc\u01922));
        }
    }

    public OptionalInt m_182417_(Container p_182418_, int p_182419_) {
        for (int i = 0; i < this.f_38839_.size(); ++i) {
            Slot slot = this.f_38839_.get(i);
            if (slot.f_40218_ != p_182418_ || p_182419_ != slot.m_150661_()) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    public int m_182424_() {
        return this.f_182405_;
    }

    public int m_182425_() {
        this.f_182405_ = this.f_182405_ + 1 & Short.MAX_VALUE;
        return this.f_182405_;
    }
}

