/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class BundleItem
extends Item {
    private static final String f_150721_ = "Items";
    public static final int f_150720_ = 64;
    private static final int f_150722_ = 4;
    private static final int f_150723_ = Mth.m_14159_(0.4f, 0.4f, 1.0f);

    public BundleItem(Item.Properties p_150726_) {
        super(p_150726_);
    }

    public static float m_150766_(ItemStack p_150767_) {
        return (float)BundleItem.m_150778_(p_150767_) / 64.0f;
    }

    @Override
    public boolean m_142207_(ItemStack p_150733_, Slot p_150734_, ClickAction p_150735_, Player p_150736_) {
        if (p_150735_ != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack itemStack = p_150734_.m_7993_();
        if (itemStack.m_41619_()) {
            BundleItem.m_150780_(p_150733_).ifPresent(p_150740_ -> BundleItem.m_150763_(p_150733_, p_150734_.m_150659_((ItemStack)p_150740_)));
        } else if (itemStack.m_41720_().m_142095_()) {
            int n = (64 - BundleItem.m_150778_(p_150733_)) / BundleItem.m_150776_(itemStack);
            BundleItem.m_150763_(p_150733_, p_150734_.m_150647_(itemStack.m_41613_(), n, p_150736_));
        }
        return true;
    }

    @Override
    public boolean m_142305_(ItemStack p_150742_, ItemStack p_150743_, Slot p_150744_, ClickAction p_150745_, Player p_150746_, SlotAccess p_150747_) {
        if (p_150745_ != ClickAction.SECONDARY || !p_150744_.m_150651_(p_150746_)) {
            return false;
        }
        if (p_150743_.m_41619_()) {
            BundleItem.m_150780_(p_150742_).ifPresent(p_150747_::m_142104_);
        } else {
            p_150743_.m_41774_(BundleItem.m_150763_(p_150742_, p_150743_));
        }
        return true;
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level p_150760_, Player p_150761_, InteractionHand p_150762_) {
        ItemStack itemStack = p_150761_.m_21120_(p_150762_);
        if (BundleItem.m_150729_(itemStack, p_150761_)) {
            p_150761_.m_36246_(Stats.f_12982_.m_12902_(this));
            return InteractionResultHolder.m_19092_(itemStack, p_150760_.m_5776_());
        }
        return InteractionResultHolder.m_19100_(itemStack);
    }

    @Override
    public boolean m_142522_(ItemStack p_150769_) {
        return BundleItem.m_150778_(p_150769_) > 0;
    }

    @Override
    public int m_142158_(ItemStack p_150771_) {
        return Math.min(1 + 12 * BundleItem.m_150778_(p_150771_) / 64, 13);
    }

    @Override
    public int m_142159_(ItemStack p_150773_) {
        return f_150723_;
    }

    private static int m_150763_(ItemStack p_150764_, ItemStack p_150765_) {
        if (p_150765_.m_41619_() || !p_150765_.m_41720_().m_142095_()) {
            return 0;
        }
        CompoundTag compoundTag = p_150764_.m_41784_();
        if (!compoundTag.m_128441_(f_150721_)) {
            compoundTag.m_128365_(f_150721_, new ListTag());
        }
        int \u00e2\u02dc\u01922 = BundleItem.m_150778_(p_150764_);
        int \u00e2\u02dc\u01923 = BundleItem.m_150776_(p_150765_);
        int \u00e2\u02dc\u01924 = Math.min(p_150765_.m_41613_(), (64 - \u00e2\u02dc\u01922) / \u00e2\u02dc\u01923);
        if (\u00e2\u02dc\u01924 == 0) {
            return 0;
        }
        ListTag \u00e2\u02dc\u01925 = compoundTag.m_128437_(f_150721_, 10);
        Optional<CompoundTag> \u00e2\u02dc\u01926 = BundleItem.m_150756_(p_150765_, \u00e2\u02dc\u01925);
        if (\u00e2\u02dc\u01926.isPresent()) {
            \u00e2\u02dc\u0192 = \u00e2\u02dc\u01926.get();
            ItemStack itemStack = ItemStack.m_41712_(\u00e2\u02dc\u0192);
            itemStack.m_41769_(\u00e2\u02dc\u01924);
            itemStack.m_41739_(\u00e2\u02dc\u0192);
            \u00e2\u02dc\u01925.remove(\u00e2\u02dc\u0192);
            \u00e2\u02dc\u01925.add(0, \u00e2\u02dc\u0192);
        } else {
            ItemStack itemStack = p_150765_.m_41777_();
            itemStack.m_41764_(\u00e2\u02dc\u01924);
            CompoundTag \u00e2\u02dc\u01927 = new CompoundTag();
            itemStack.m_41739_(\u00e2\u02dc\u01927);
            \u00e2\u02dc\u01925.add(0, \u00e2\u02dc\u01927);
        }
        return \u00e2\u02dc\u01924;
    }

    private static Optional<CompoundTag> m_150756_(ItemStack p_150757_, ListTag p_150758_) {
        if (p_150757_.m_150930_(Items.f_151058_)) {
            return Optional.empty();
        }
        return p_150758_.stream().filter(CompoundTag.class::isInstance).map(CompoundTag.class::cast).filter(p_150755_ -> ItemStack.m_150942_(ItemStack.m_41712_(p_150755_), p_150757_)).findFirst();
    }

    private static int m_150776_(ItemStack p_150777_) {
        CompoundTag compoundTag;
        if (p_150777_.m_150930_(Items.f_151058_)) {
            return 4 + BundleItem.m_150778_(p_150777_);
        }
        if ((p_150777_.m_150930_(Items.f_42786_) || p_150777_.m_150930_(Items.f_42785_)) && p_150777_.m_41782_() && (compoundTag = p_150777_.m_41737_("BlockEntityTag")) != null && !compoundTag.m_128437_("Bees", 10).isEmpty()) {
            return 64;
        }
        return 64 / p_150777_.m_41741_();
    }

    private static int m_150778_(ItemStack p_150779_) {
        return BundleItem.m_150782_(p_150779_).mapToInt(p_150785_ -> BundleItem.m_150776_(p_150785_) * p_150785_.m_41613_()).sum();
    }

    private static Optional<ItemStack> m_150780_(ItemStack p_150781_) {
        CompoundTag compoundTag = p_150781_.m_41784_();
        if (!compoundTag.m_128441_(f_150721_)) {
            return Optional.empty();
        }
        ListTag \u00e2\u02dc\u01922 = compoundTag.m_128437_(f_150721_, 10);
        if (\u00e2\u02dc\u01922.isEmpty()) {
            return Optional.empty();
        }
        boolean \u00e2\u02dc\u01923 = false;
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u01922.m_128728_(0);
        ItemStack \u00e2\u02dc\u01924 = ItemStack.m_41712_(\u00e2\u02dc\u0192);
        \u00e2\u02dc\u01922.remove(0);
        if (\u00e2\u02dc\u01922.isEmpty()) {
            p_150781_.m_41749_(f_150721_);
        }
        return Optional.of(\u00e2\u02dc\u01924);
    }

    private static boolean m_150729_(ItemStack p_150730_, Player p_150731_) {
        CompoundTag compoundTag = p_150730_.m_41784_();
        if (!compoundTag.m_128441_(f_150721_)) {
            return false;
        }
        if (p_150731_ instanceof ServerPlayer) {
            ListTag listTag = compoundTag.m_128437_(f_150721_, 10);
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag compoundTag2 = listTag.m_128728_(i);
                ItemStack \u00e2\u02dc\u01922 = ItemStack.m_41712_(compoundTag2);
                p_150731_.m_36176_(\u00e2\u02dc\u01922, true);
            }
        }
        p_150730_.m_41749_(f_150721_);
        return true;
    }

    private static Stream<ItemStack> m_150782_(ItemStack p_150783_) {
        CompoundTag compoundTag = p_150783_.m_41783_();
        if (compoundTag == null) {
            return Stream.empty();
        }
        ListTag \u00e2\u02dc\u01922 = compoundTag.m_128437_(f_150721_, 10);
        return \u00e2\u02dc\u01922.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_);
    }

    @Override
    public Optional<TooltipComponent> m_142422_(ItemStack p_150775_) {
        NonNullList<ItemStack> nonNullList = NonNullList.m_122779_();
        BundleItem.m_150782_(p_150775_).forEach(nonNullList::add);
        return Optional.of(new BundleTooltip(nonNullList, BundleItem.m_150778_(p_150775_)));
    }

    @Override
    public void m_7373_(ItemStack p_150749_, Level p_150750_, List<Component> p_150751_, TooltipFlag p_150752_) {
        p_150751_.add(new TranslatableComponent("item.minecraft.bundle.fullness", BundleItem.m_150778_(p_150749_), 64).m_130940_(ChatFormatting.GRAY));
    }

    @Override
    public void m_142023_(ItemEntity p_150728_) {
        ItemUtils.m_150952_(p_150728_, BundleItem.m_150782_(p_150728_.m_32055_()));
    }
}

