/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.FireworkStarItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class FireworkRocketItem
extends Item {
    public static final String f_150831_ = "Fireworks";
    public static final String f_150832_ = "Explosion";
    public static final String f_150833_ = "Explosions";
    public static final String f_150834_ = "Flight";
    public static final String f_150835_ = "Type";
    public static final String f_150836_ = "Trail";
    public static final String f_150837_ = "Flicker";
    public static final String f_150838_ = "Colors";
    public static final String f_150839_ = "FadeColors";
    public static final double f_150840_ = 0.15;

    public FireworkRocketItem(Item.Properties p_41209_) {
        super(p_41209_);
    }

    @Override
    public InteractionResult m_6225_(UseOnContext p_41216_) {
        Level level = p_41216_.m_43725_();
        if (!level.f_46443_) {
            ItemStack itemStack = p_41216_.m_43722_();
            Vec3 \u00e2\u02dc\u01922 = p_41216_.m_43720_();
            Direction \u00e2\u02dc\u01923 = p_41216_.m_43719_();
            FireworkRocketEntity \u00e2\u02dc\u01924 = new FireworkRocketEntity(level, p_41216_.m_43723_(), \u00e2\u02dc\u01922.f_82479_ + (double)\u00e2\u02dc\u01923.m_122429_() * 0.15, \u00e2\u02dc\u01922.f_82480_ + (double)\u00e2\u02dc\u01923.m_122430_() * 0.15, \u00e2\u02dc\u01922.f_82481_ + (double)\u00e2\u02dc\u01923.m_122431_() * 0.15, itemStack);
            level.m_7967_(\u00e2\u02dc\u01924);
            itemStack.m_41774_(1);
        }
        return InteractionResult.m_19078_(level.f_46443_);
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level p_41218_, Player p_41219_, InteractionHand p_41220_) {
        if (p_41219_.m_21255_()) {
            ItemStack itemStack = p_41219_.m_21120_(p_41220_);
            if (!p_41218_.f_46443_) {
                FireworkRocketEntity fireworkRocketEntity = new FireworkRocketEntity(p_41218_, itemStack, p_41219_);
                p_41218_.m_7967_(fireworkRocketEntity);
                if (!p_41219_.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
                p_41219_.m_36246_(Stats.f_12982_.m_12902_(this));
            }
            return InteractionResultHolder.m_19092_(p_41219_.m_21120_(p_41220_), p_41218_.m_5776_());
        }
        return InteractionResultHolder.m_19098_(p_41219_.m_21120_(p_41220_));
    }

    @Override
    public void m_7373_(ItemStack p_41211_, @Nullable Level p_41212_, List<Component> p_41213_, TooltipFlag p_41214_) {
        CompoundTag compoundTag = p_41211_.m_41737_(f_150831_);
        if (compoundTag == null) {
            return;
        }
        if (compoundTag.m_128425_(f_150834_, 99)) {
            p_41213_.add(new TranslatableComponent("item.minecraft.firework_rocket.flight").m_130946_(" ").m_130946_(String.valueOf(compoundTag.m_128445_(f_150834_))).m_130940_(ChatFormatting.GRAY));
        }
        if (!(\u00e2\u02dc\u0192 = compoundTag.m_128437_(f_150833_, 10)).isEmpty()) {
            for (int i = 0; i < \u00e2\u02dc\u0192.size(); ++i) {
                CompoundTag compoundTag2 = \u00e2\u02dc\u0192.m_128728_(i);
                ArrayList \u00e2\u02dc\u01922 = Lists.newArrayList();
                FireworkStarItem.m_41256_(compoundTag2, \u00e2\u02dc\u01922);
                if (\u00e2\u02dc\u01922.isEmpty()) continue;
                for (int j = 1; j < \u00e2\u02dc\u01922.size(); ++j) {
                    \u00e2\u02dc\u01922.set(j, new TextComponent("  ").m_7220_((Component)\u00e2\u02dc\u01922.get(j)).m_130940_(ChatFormatting.GRAY));
                }
                p_41213_.addAll(\u00e2\u02dc\u01922);
            }
        }
    }

    @Override
    public ItemStack m_7968_() {
        ItemStack itemStack = new ItemStack(this);
        itemStack.m_41784_().m_128344_(f_150834_, (byte)1);
        return itemStack;
    }

    public static final class Shape
    extends Enum<Shape> {
        public static final /* enum */ Shape SMALL_BALL = new Shape(0, "small_ball");
        public static final /* enum */ Shape LARGE_BALL = new Shape(1, "large_ball");
        public static final /* enum */ Shape STAR = new Shape(2, "star");
        public static final /* enum */ Shape CREEPER = new Shape(3, "creeper");
        public static final /* enum */ Shape BURST = new Shape(4, "burst");
        private static final Shape[] f_41226_;
        private final int f_41227_;
        private final String f_41228_;
        private static final /* synthetic */ Shape[] $VALUES;

        public static Shape[] values() {
            return (Shape[])$VALUES.clone();
        }

        public static Shape valueOf(String p_41245_) {
            return Enum.valueOf(Shape.class, p_41245_);
        }

        private Shape(int p_41234_, String p_41235_) {
            this.f_41227_ = p_41234_;
            this.f_41228_ = p_41235_;
        }

        public int m_41236_() {
            return this.f_41227_;
        }

        public String m_41241_() {
            return this.f_41228_;
        }

        public static Shape m_41237_(int p_41238_) {
            if (p_41238_ < 0 || p_41238_ >= f_41226_.length) {
                return SMALL_BALL;
            }
            return f_41226_[p_41238_];
        }

        private static /* synthetic */ Shape[] m_150842_() {
            return new Shape[]{SMALL_BALL, LARGE_BALL, STAR, CREEPER, BURST};
        }

        static {
            $VALUES = Shape.m_150842_();
            f_41226_ = (Shape[])Arrays.stream(Shape.values()).sorted(Comparator.comparingInt(p_41240_ -> p_41240_.f_41227_)).toArray(Shape[]::new);
        }
    }
}

