/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.commands.arguments.blocks.BlockPredicateArgument;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagContainer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.DigDurabilityEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ItemStack {
    public static final Codec<ItemStack> f_41582_ = RecordCodecBuilder.create(p_41697_ -> p_41697_.group((App)Registry.f_122827_.fieldOf("id").forGetter(p_150946_ -> p_150946_.f_41589_), (App)Codec.INT.fieldOf("Count").forGetter(p_150941_ -> p_150941_.f_41587_), (App)CompoundTag.f_128325_.optionalFieldOf("tag").forGetter(p_150939_ -> Optional.ofNullable(p_150939_.f_41590_))).apply((Applicative)p_41697_, ItemStack::new));
    private static final Logger f_41585_ = LogManager.getLogger();
    public static final ItemStack f_41583_ = new ItemStack((ItemLike)null);
    public static final DecimalFormat f_41584_ = Util.m_137469_(new DecimalFormat("#.##"), p_41704_ -> p_41704_.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    public static final String f_150906_ = "Enchantments";
    public static final String f_150909_ = "display";
    public static final String f_150910_ = "Name";
    public static final String f_150911_ = "Lore";
    public static final String f_150912_ = "Damage";
    public static final String f_150913_ = "color";
    private static final String f_150914_ = "Unbreakable";
    private static final String f_150915_ = "RepairCost";
    private static final String f_150916_ = "CanDestroy";
    private static final String f_150917_ = "CanPlaceOn";
    private static final String f_150918_ = "HideFlags";
    private static final int f_150919_ = 0;
    private static final Style f_41586_ = Style.f_131099_.m_131140_(ChatFormatting.DARK_PURPLE).m_131155_(true);
    private int f_41587_;
    private int f_41588_;
    @Deprecated
    private final Item f_41589_;
    private CompoundTag f_41590_;
    private boolean f_41591_;
    private Entity f_41592_;
    private BlockInWorld f_41593_;
    private boolean f_41594_;
    private BlockInWorld f_41595_;
    private boolean f_41596_;

    public Optional<TooltipComponent> m_150921_() {
        return this.m_41720_().m_142422_(this);
    }

    public ItemStack(ItemLike p_41599_) {
        this(p_41599_, 1);
    }

    private ItemStack(ItemLike p_41604_, int p_41605_, Optional<CompoundTag> p_41606_) {
        this(p_41604_, p_41605_);
        p_41606_.ifPresent(this::m_41751_);
    }

    public ItemStack(ItemLike p_41601_, int p_41602_) {
        this.f_41589_ = p_41601_ == null ? null : p_41601_.m_5456_();
        this.f_41587_ = p_41602_;
        if (this.f_41589_ != null && this.f_41589_.m_41465_()) {
            this.m_41721_(this.m_41773_());
        }
        this.m_41617_();
    }

    private void m_41617_() {
        this.f_41591_ = false;
        this.f_41591_ = this.m_41619_();
    }

    private ItemStack(CompoundTag p_41608_) {
        this.f_41589_ = Registry.f_122827_.m_7745_(new ResourceLocation(p_41608_.m_128461_("id")));
        this.f_41587_ = p_41608_.m_128445_("Count");
        if (p_41608_.m_128425_("tag", 10)) {
            this.f_41590_ = p_41608_.m_128469_("tag");
            this.m_41720_().m_142312_(this.f_41590_);
        }
        if (this.m_41720_().m_41465_()) {
            this.m_41721_(this.m_41773_());
        }
        this.m_41617_();
    }

    public static ItemStack m_41712_(CompoundTag p_41713_) {
        try {
            return new ItemStack(p_41713_);
        }
        catch (RuntimeException runtimeException) {
            f_41585_.debug("Tried to load invalid item: {}", (Object)p_41713_, (Object)runtimeException);
            return f_41583_;
        }
    }

    public boolean m_41619_() {
        if (this == f_41583_) {
            return true;
        }
        if (this.m_41720_() == null || this.m_150930_(Items.f_41852_)) {
            return true;
        }
        return this.f_41587_ <= 0;
    }

    public ItemStack m_41620_(int p_41621_) {
        int n = Math.min(p_41621_, this.f_41587_);
        ItemStack \u00e2\u02dc\u01922 = this.m_41777_();
        \u00e2\u02dc\u01922.m_41764_(n);
        this.m_41774_(n);
        return \u00e2\u02dc\u01922;
    }

    public Item m_41720_() {
        return this.f_41591_ ? Items.f_41852_ : this.f_41589_;
    }

    public boolean m_150922_(Tag<Item> p_150923_) {
        return p_150923_.m_8110_(this.m_41720_());
    }

    public boolean m_150930_(Item p_150931_) {
        return this.m_41720_() == p_150931_;
    }

    public InteractionResult m_41661_(UseOnContext p_41662_) {
        Player player = p_41662_.m_43723_();
        BlockPos \u00e2\u02dc\u01922 = p_41662_.m_8083_();
        BlockInWorld \u00e2\u02dc\u01923 = new BlockInWorld(p_41662_.m_43725_(), \u00e2\u02dc\u01922, false);
        if (player != null && !player.m_150110_().f_35938_ && !this.m_41723_(p_41662_.m_43725_().m_5999_(), \u00e2\u02dc\u01923)) {
            return InteractionResult.PASS;
        }
        Item \u00e2\u02dc\u01924 = this.m_41720_();
        InteractionResult \u00e2\u02dc\u01925 = \u00e2\u02dc\u01924.m_6225_(p_41662_);
        if (player != null && \u00e2\u02dc\u01925.m_146666_()) {
            player.m_36246_(Stats.f_12982_.m_12902_(\u00e2\u02dc\u01924));
        }
        return \u00e2\u02dc\u01925;
    }

    public float m_41691_(BlockState p_41692_) {
        return this.m_41720_().m_8102_(this, p_41692_);
    }

    public InteractionResultHolder<ItemStack> m_41682_(Level p_41683_, Player p_41684_, InteractionHand p_41685_) {
        return this.m_41720_().m_7203_(p_41683_, p_41684_, p_41685_);
    }

    public ItemStack m_41671_(Level p_41672_, LivingEntity p_41673_) {
        return this.m_41720_().m_5922_(this, p_41672_, p_41673_);
    }

    public CompoundTag m_41739_(CompoundTag p_41740_) {
        ResourceLocation resourceLocation = Registry.f_122827_.m_7981_(this.m_41720_());
        p_41740_.m_128359_("id", resourceLocation == null ? "minecraft:air" : resourceLocation.toString());
        p_41740_.m_128344_("Count", (byte)this.f_41587_);
        if (this.f_41590_ != null) {
            p_41740_.m_128365_("tag", this.f_41590_.m_6426_());
        }
        return p_41740_;
    }

    public int m_41741_() {
        return this.m_41720_().m_41459_();
    }

    public boolean m_41753_() {
        return this.m_41741_() > 1 && (!this.m_41763_() || !this.m_41768_());
    }

    public boolean m_41763_() {
        if (this.f_41591_ || this.m_41720_().m_41462_() <= 0) {
            return false;
        }
        CompoundTag compoundTag = this.m_41783_();
        return compoundTag == null || !compoundTag.m_128471_(f_150914_);
    }

    public boolean m_41768_() {
        return this.m_41763_() && this.m_41773_() > 0;
    }

    public int m_41773_() {
        return this.f_41590_ == null ? 0 : this.f_41590_.m_128451_(f_150912_);
    }

    public void m_41721_(int p_41722_) {
        this.m_41784_().m_128405_(f_150912_, Math.max(0, p_41722_));
    }

    public int m_41776_() {
        return this.m_41720_().m_41462_();
    }

    public boolean m_41629_(int p_41630_, Random p_41631_, @Nullable ServerPlayer p_41632_) {
        int n;
        if (!this.m_41763_()) {
            return false;
        }
        if (p_41630_ > 0) {
            n = EnchantmentHelper.m_44843_(Enchantments.f_44986_, this);
            \u00e2\u02dc\u0192 = 0;
            for (\u00e2\u02dc\u0192 = 0; n > 0 && \u00e2\u02dc\u0192 < p_41630_; ++\u00e2\u02dc\u0192) {
                if (!DigDurabilityEnchantment.m_44655_(this, n, p_41631_)) continue;
                ++\u00e2\u02dc\u0192;
            }
            if ((p_41630_ -= \u00e2\u02dc\u0192) <= 0) {
                return false;
            }
        }
        if (p_41632_ != null && p_41630_ != 0) {
            CriteriaTriggers.f_10586_.m_43669_(p_41632_, this, this.m_41773_() + p_41630_);
        }
        n = this.m_41773_() + p_41630_;
        this.m_41721_(n);
        return n >= this.m_41776_();
    }

    public <T extends LivingEntity> void m_41622_(int p_41623_, T p_41624_, Consumer<T> p_41625_) {
        if (p_41624_.f_19853_.f_46443_ || p_41624_ instanceof Player && ((Player)p_41624_).m_150110_().f_35937_) {
            return;
        }
        if (!this.m_41763_()) {
            return;
        }
        if (this.m_41629_(p_41623_, p_41624_.m_21187_(), p_41624_ instanceof ServerPlayer ? (ServerPlayer)p_41624_ : null)) {
            p_41625_.accept(p_41624_);
            Item item = this.m_41720_();
            this.m_41774_(1);
            if (p_41624_ instanceof Player) {
                ((Player)p_41624_).m_36246_(Stats.f_12983_.m_12902_(item));
            }
            this.m_41721_(0);
        }
    }

    public boolean m_150947_() {
        return this.f_41589_.m_142522_(this);
    }

    public int m_150948_() {
        return this.f_41589_.m_142158_(this);
    }

    public int m_150949_() {
        return this.f_41589_.m_142159_(this);
    }

    public boolean m_150926_(Slot p_150927_, ClickAction p_150928_, Player p_150929_) {
        return this.m_41720_().m_142207_(this, p_150927_, p_150928_, p_150929_);
    }

    public boolean m_150932_(ItemStack p_150933_, Slot p_150934_, ClickAction p_150935_, Player p_150936_, SlotAccess p_150937_) {
        return this.m_41720_().m_142305_(this, p_150933_, p_150934_, p_150935_, p_150936_, p_150937_);
    }

    public void m_41640_(LivingEntity p_41641_, Player p_41642_) {
        Item item = this.m_41720_();
        if (item.m_7579_(this, p_41641_, p_41642_)) {
            p_41642_.m_36246_(Stats.f_12982_.m_12902_(item));
        }
    }

    public void m_41686_(Level p_41687_, BlockState p_41688_, BlockPos p_41689_, Player p_41690_) {
        Item item = this.m_41720_();
        if (item.m_6813_(this, p_41687_, p_41688_, p_41689_, p_41690_)) {
            p_41690_.m_36246_(Stats.f_12982_.m_12902_(item));
        }
    }

    public boolean m_41735_(BlockState p_41736_) {
        return this.m_41720_().m_8096_(p_41736_);
    }

    public InteractionResult m_41647_(Player p_41648_, LivingEntity p_41649_, InteractionHand p_41650_) {
        return this.m_41720_().m_6880_(this, p_41648_, p_41649_, p_41650_);
    }

    public ItemStack m_41777_() {
        if (this.m_41619_()) {
            return f_41583_;
        }
        ItemStack itemStack = new ItemStack(this.m_41720_(), this.f_41587_);
        itemStack.m_41754_(this.m_41612_());
        if (this.f_41590_ != null) {
            itemStack.f_41590_ = this.f_41590_.m_6426_();
        }
        return itemStack;
    }

    public static boolean m_41658_(ItemStack p_41659_, ItemStack p_41660_) {
        if (p_41659_.m_41619_() && p_41660_.m_41619_()) {
            return true;
        }
        if (p_41659_.m_41619_() || p_41660_.m_41619_()) {
            return false;
        }
        if (p_41659_.f_41590_ == null && p_41660_.f_41590_ != null) {
            return false;
        }
        return p_41659_.f_41590_ == null || p_41659_.f_41590_.equals(p_41660_.f_41590_);
    }

    public static boolean m_41728_(ItemStack p_41729_, ItemStack p_41730_) {
        if (p_41729_.m_41619_() && p_41730_.m_41619_()) {
            return true;
        }
        if (p_41729_.m_41619_() || p_41730_.m_41619_()) {
            return false;
        }
        return p_41729_.m_41744_(p_41730_);
    }

    private boolean m_41744_(ItemStack p_41745_) {
        if (this.f_41587_ != p_41745_.f_41587_) {
            return false;
        }
        if (!this.m_150930_(p_41745_.m_41720_())) {
            return false;
        }
        if (this.f_41590_ == null && p_41745_.f_41590_ != null) {
            return false;
        }
        return this.f_41590_ == null || this.f_41590_.equals(p_41745_.f_41590_);
    }

    public static boolean m_41746_(ItemStack p_41747_, ItemStack p_41748_) {
        if (p_41747_ == p_41748_) {
            return true;
        }
        if (!p_41747_.m_41619_() && !p_41748_.m_41619_()) {
            return p_41747_.m_41656_(p_41748_);
        }
        return false;
    }

    public static boolean m_41758_(ItemStack p_41759_, ItemStack p_41760_) {
        if (p_41759_ == p_41760_) {
            return true;
        }
        if (!p_41759_.m_41619_() && !p_41760_.m_41619_()) {
            return p_41759_.m_41726_(p_41760_);
        }
        return false;
    }

    public boolean m_41656_(ItemStack p_41657_) {
        return !p_41657_.m_41619_() && this.m_150930_(p_41657_.m_41720_());
    }

    public boolean m_41726_(ItemStack p_41727_) {
        if (this.m_41763_()) {
            return !p_41727_.m_41619_() && this.m_150930_(p_41727_.m_41720_());
        }
        return this.m_41656_(p_41727_);
    }

    public static boolean m_150942_(ItemStack p_150943_, ItemStack p_150944_) {
        return p_150943_.m_150930_(p_150944_.m_41720_()) && ItemStack.m_41658_(p_150943_, p_150944_);
    }

    public String m_41778_() {
        return this.m_41720_().m_5671_(this);
    }

    public String toString() {
        return this.f_41587_ + " " + this.m_41720_();
    }

    public void m_41666_(Level p_41667_, Entity p_41668_, int p_41669_, boolean p_41670_) {
        if (this.f_41588_ > 0) {
            --this.f_41588_;
        }
        if (this.m_41720_() != null) {
            this.m_41720_().m_6883_(this, p_41667_, p_41668_, p_41669_, p_41670_);
        }
    }

    public void m_41678_(Level p_41679_, Player p_41680_, int p_41681_) {
        p_41680_.m_6278_(Stats.f_12981_.m_12902_(this.m_41720_()), p_41681_);
        this.m_41720_().m_7836_(this, p_41679_, p_41680_);
    }

    public int m_41779_() {
        return this.m_41720_().m_8105_(this);
    }

    public UseAnim m_41780_() {
        return this.m_41720_().m_6164_(this);
    }

    public void m_41674_(Level p_41675_, LivingEntity p_41676_, int p_41677_) {
        this.m_41720_().m_5551_(this, p_41675_, p_41676_, p_41677_);
    }

    public boolean m_41781_() {
        return this.m_41720_().m_41463_(this);
    }

    public boolean m_41782_() {
        return !this.f_41591_ && this.f_41590_ != null && !this.f_41590_.m_128456_();
    }

    @Nullable
    public CompoundTag m_41783_() {
        return this.f_41590_;
    }

    public CompoundTag m_41784_() {
        if (this.f_41590_ == null) {
            this.m_41751_(new CompoundTag());
        }
        return this.f_41590_;
    }

    public CompoundTag m_41698_(String p_41699_) {
        if (this.f_41590_ == null || !this.f_41590_.m_128425_(p_41699_, 10)) {
            CompoundTag compoundTag = new CompoundTag();
            this.m_41700_(p_41699_, compoundTag);
            return compoundTag;
        }
        return this.f_41590_.m_128469_(p_41699_);
    }

    @Nullable
    public CompoundTag m_41737_(String p_41738_) {
        if (this.f_41590_ == null || !this.f_41590_.m_128425_(p_41738_, 10)) {
            return null;
        }
        return this.f_41590_.m_128469_(p_41738_);
    }

    public void m_41749_(String p_41750_) {
        if (this.f_41590_ != null && this.f_41590_.m_128441_(p_41750_)) {
            this.f_41590_.m_128473_(p_41750_);
            if (this.f_41590_.m_128456_()) {
                this.f_41590_ = null;
            }
        }
    }

    public ListTag m_41785_() {
        if (this.f_41590_ != null) {
            return this.f_41590_.m_128437_(f_150906_, 10);
        }
        return new ListTag();
    }

    public void m_41751_(@Nullable CompoundTag p_41752_) {
        this.f_41590_ = p_41752_;
        if (this.m_41720_().m_41465_()) {
            this.m_41721_(this.m_41773_());
        }
        if (p_41752_ != null) {
            this.m_41720_().m_142312_(p_41752_);
        }
    }

    public Component m_41786_() {
        CompoundTag compoundTag = this.m_41737_(f_150909_);
        if (compoundTag != null && compoundTag.m_128425_(f_150910_, 8)) {
            try {
                MutableComponent mutableComponent = Component.Serializer.m_130701_(compoundTag.m_128461_(f_150910_));
                if (mutableComponent != null) {
                    return mutableComponent;
                }
                compoundTag.m_128473_(f_150910_);
            }
            catch (JsonParseException jsonParseException) {
                compoundTag.m_128473_(f_150910_);
            }
        }
        return this.m_41720_().m_7626_(this);
    }

    public ItemStack m_41714_(@Nullable Component p_41715_) {
        CompoundTag compoundTag = this.m_41698_(f_150909_);
        if (p_41715_ != null) {
            compoundTag.m_128359_(f_150910_, Component.Serializer.m_130703_(p_41715_));
        } else {
            compoundTag.m_128473_(f_150910_);
        }
        return this;
    }

    public void m_41787_() {
        CompoundTag compoundTag = this.m_41737_(f_150909_);
        if (compoundTag != null) {
            compoundTag.m_128473_(f_150910_);
            if (compoundTag.m_128456_()) {
                this.m_41749_(f_150909_);
            }
        }
        if (this.f_41590_ != null && this.f_41590_.m_128456_()) {
            this.f_41590_ = null;
        }
    }

    public boolean m_41788_() {
        CompoundTag compoundTag = this.m_41737_(f_150909_);
        return compoundTag != null && compoundTag.m_128425_(f_150910_, 8);
    }

    public List<Component> m_41651_(@Nullable Player p_41652_, TooltipFlag p_41653_) {
        Object object;
        ArrayList arrayList = Lists.newArrayList();
        MutableComponent \u00e2\u02dc\u01922 = new TextComponent("").m_7220_(this.m_41786_()).m_130940_(this.m_41791_().f_43022_);
        if (this.m_41788_()) {
            \u00e2\u02dc\u01922.m_130940_(ChatFormatting.ITALIC);
        }
        arrayList.add(\u00e2\u02dc\u01922);
        if (!p_41653_.m_7050_() && !this.m_41788_() && this.m_150930_(Items.f_42573_) && (\u00e2\u02dc\u0192 = MapItem.m_151131_(this)) != null) {
            arrayList.add(new TextComponent("#" + \u00e2\u02dc\u0192).m_130940_(ChatFormatting.GRAY));
        }
        if (ItemStack.m_41626_(n = this.m_41618_(), TooltipPart.ADDITIONAL)) {
            this.m_41720_().m_7373_(this, p_41652_ == null ? null : p_41652_.f_19853_, arrayList, p_41653_);
        }
        if (this.m_41782_()) {
            if (ItemStack.m_41626_(n, TooltipPart.ENCHANTMENTS)) {
                ItemStack.m_41709_(arrayList, this.m_41785_());
            }
            if (this.f_41590_.m_128425_(f_150909_, 10)) {
                Object object2 = this.f_41590_.m_128469_(f_150909_);
                if (ItemStack.m_41626_(n, TooltipPart.DYE) && ((CompoundTag)object2).m_128425_(f_150913_, 99)) {
                    if (p_41653_.m_7050_()) {
                        arrayList.add(new TranslatableComponent("item.color", String.format("#%06X", ((CompoundTag)object2).m_128451_(f_150913_))).m_130940_(ChatFormatting.GRAY));
                    } else {
                        arrayList.add(new TranslatableComponent("item.dyed").m_130944_(ChatFormatting.GRAY, ChatFormatting.ITALIC));
                    }
                }
                if (((CompoundTag)object2).m_128435_(f_150911_) == 9) {
                    ListTag listTag = ((CompoundTag)object2).m_128437_(f_150911_, 8);
                    for (int i = 0; i < listTag.size(); ++i) {
                        object = listTag.m_128778_(i);
                        try {
                            \u00e2\u02dc\u0192 = Component.Serializer.m_130701_((String)object);
                            if (\u00e2\u02dc\u0192 == null) continue;
                            arrayList.add(ComponentUtils.m_130750_(\u00e2\u02dc\u0192, f_41586_));
                            continue;
                        }
                        catch (JsonParseException \u00e2\u02dc\u01923) {
                            ((CompoundTag)object2).m_128473_(f_150911_);
                        }
                    }
                }
            }
        }
        if (ItemStack.m_41626_(n, TooltipPart.MODIFIERS)) {
            object2 = EquipmentSlot.values();
            int listTag = ((EquipmentSlot[])object2).length;
            for (int i = 0; i < listTag; ++i) {
                object = object2[i];
                \u00e2\u02dc\u0192 = this.m_41638_((EquipmentSlot)((Object)object));
                if (\u00e2\u02dc\u0192.isEmpty()) continue;
                arrayList.add(TextComponent.f_131282_);
                arrayList.add(new TranslatableComponent("item.modifiers." + object.m_20751_()).m_130940_(ChatFormatting.GRAY));
                for (Map.Entry entry : \u00e2\u02dc\u0192.entries()) {
                    AttributeModifier attributeModifier = (AttributeModifier)entry.getValue();
                    double \u00e2\u02dc\u01924 = attributeModifier.m_22218_();
                    boolean \u00e2\u02dc\u01925 = false;
                    if (p_41652_ != null) {
                        if (attributeModifier.m_22209_() == Item.f_41374_) {
                            \u00e2\u02dc\u01924 += p_41652_.m_21172_(Attributes.f_22281_);
                            \u00e2\u02dc\u01924 += (double)EnchantmentHelper.m_44833_(this, MobType.f_21640_);
                            \u00e2\u02dc\u01925 = true;
                        } else if (attributeModifier.m_22209_() == Item.f_41375_) {
                            \u00e2\u02dc\u01924 += p_41652_.m_21172_(Attributes.f_22283_);
                            \u00e2\u02dc\u01925 = true;
                        }
                    }
                    double \u00e2\u02dc\u01926 = attributeModifier.m_22217_() == AttributeModifier.Operation.MULTIPLY_BASE || attributeModifier.m_22217_() == AttributeModifier.Operation.MULTIPLY_TOTAL ? \u00e2\u02dc\u01924 * 100.0 : (((Attribute)entry.getKey()).equals(Attributes.f_22278_) ? \u00e2\u02dc\u01924 * 10.0 : \u00e2\u02dc\u01924);
                    if (\u00e2\u02dc\u01925) {
                        arrayList.add(new TextComponent(" ").m_7220_(new TranslatableComponent("attribute.modifier.equals." + attributeModifier.m_22217_().m_22235_(), f_41584_.format(\u00e2\u02dc\u01926), new TranslatableComponent(((Attribute)entry.getKey()).m_22087_()))).m_130940_(ChatFormatting.DARK_GREEN));
                        continue;
                    }
                    if (\u00e2\u02dc\u01924 > 0.0) {
                        arrayList.add(new TranslatableComponent("attribute.modifier.plus." + attributeModifier.m_22217_().m_22235_(), f_41584_.format(\u00e2\u02dc\u01926), new TranslatableComponent(((Attribute)entry.getKey()).m_22087_())).m_130940_(ChatFormatting.BLUE));
                        continue;
                    }
                    if (!(\u00e2\u02dc\u01924 < 0.0)) continue;
                    arrayList.add(new TranslatableComponent("attribute.modifier.take." + attributeModifier.m_22217_().m_22235_(), f_41584_.format(\u00e2\u02dc\u01926 *= -1.0), new TranslatableComponent(((Attribute)entry.getKey()).m_22087_())).m_130940_(ChatFormatting.RED));
                }
            }
        }
        if (this.m_41782_()) {
            int n;
            if (ItemStack.m_41626_(n, TooltipPart.UNBREAKABLE) && this.f_41590_.m_128471_(f_150914_)) {
                arrayList.add(new TranslatableComponent("item.unbreakable").m_130940_(ChatFormatting.BLUE));
            }
            if (ItemStack.m_41626_(n, TooltipPart.CAN_DESTROY) && this.f_41590_.m_128425_(f_150916_, 9) && !((ListTag)(object2 = this.f_41590_.m_128437_(f_150916_, 8))).isEmpty()) {
                arrayList.add(TextComponent.f_131282_);
                arrayList.add(new TranslatableComponent("item.canBreak").m_130940_(ChatFormatting.GRAY));
                for (int i = 0; i < ((ListTag)object2).size(); ++i) {
                    arrayList.addAll(ItemStack.m_41761_(((ListTag)object2).m_128778_(i)));
                }
            }
            if (ItemStack.m_41626_(n, TooltipPart.CAN_PLACE) && this.f_41590_.m_128425_(f_150917_, 9) && !((ListTag)(object2 = this.f_41590_.m_128437_(f_150917_, 8))).isEmpty()) {
                arrayList.add(TextComponent.f_131282_);
                arrayList.add(new TranslatableComponent("item.canPlace").m_130940_(ChatFormatting.GRAY));
                for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < ((ListTag)object2).size(); ++\u00e2\u02dc\u0192) {
                    arrayList.addAll(ItemStack.m_41761_(((ListTag)object2).m_128778_(\u00e2\u02dc\u0192)));
                }
            }
        }
        if (p_41653_.m_7050_()) {
            if (this.m_41768_()) {
                arrayList.add(new TranslatableComponent("item.durability", this.m_41776_() - this.m_41773_(), this.m_41776_()));
            }
            arrayList.add(new TextComponent(Registry.f_122827_.m_7981_(this.m_41720_()).toString()).m_130940_(ChatFormatting.DARK_GRAY));
            if (this.m_41782_()) {
                arrayList.add(new TranslatableComponent("item.nbt_tags", this.f_41590_.m_128431_().size()).m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
        return arrayList;
    }

    private static boolean m_41626_(int p_41627_, TooltipPart p_41628_) {
        return (p_41627_ & p_41628_.m_41809_()) == 0;
    }

    private int m_41618_() {
        if (this.m_41782_() && this.f_41590_.m_128425_(f_150918_, 99)) {
            return this.f_41590_.m_128451_(f_150918_);
        }
        return 0;
    }

    public void m_41654_(TooltipPart p_41655_) {
        CompoundTag compoundTag = this.m_41784_();
        compoundTag.m_128405_(f_150918_, compoundTag.m_128451_(f_150918_) | p_41655_.m_41809_());
    }

    public static void m_41709_(List<Component> p_41710_, ListTag p_41711_) {
        for (int i = 0; i < p_41711_.size(); ++i) {
            CompoundTag compoundTag = p_41711_.m_128728_(i);
            Registry.f_122825_.m_6612_(EnchantmentHelper.m_182446_(compoundTag)).ifPresent(p_41708_ -> p_41710_.add(p_41708_.m_44700_(EnchantmentHelper.m_182438_(compoundTag))));
        }
    }

    private static Collection<Component> m_41761_(String p_41762_) {
        try {
            BlockStateParser blockStateParser = new BlockStateParser(new StringReader(p_41762_), true).m_116806_(true);
            BlockState \u00e2\u02dc\u01922 = blockStateParser.m_116808_();
            ResourceLocation \u00e2\u02dc\u01923 = blockStateParser.m_116822_();
            boolean \u00e2\u02dc\u01924 = \u00e2\u02dc\u01922 != null;
            boolean bl = \u00e2\u02dc\u0192 = \u00e2\u02dc\u01923 != null;
            if (\u00e2\u02dc\u01924 || \u00e2\u02dc\u0192) {
                if (\u00e2\u02dc\u01924) {
                    return Lists.newArrayList((Object[])new Component[]{\u00e2\u02dc\u01922.m_60734_().m_49954_().m_130940_(ChatFormatting.DARK_GRAY)});
                }
                Tag<Block> tag = BlockTags.m_13115_().m_13404_(\u00e2\u02dc\u01923);
                if (tag != null && !(\u00e2\u02dc\u0192 = tag.m_6497_()).isEmpty()) {
                    return \u00e2\u02dc\u0192.stream().map(Block::m_49954_).map(p_41717_ -> p_41717_.m_130940_(ChatFormatting.DARK_GRAY)).collect(Collectors.toList());
                }
            }
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return Lists.newArrayList((Object[])new Component[]{new TextComponent("missingno").m_130940_(ChatFormatting.DARK_GRAY)});
    }

    public boolean m_41790_() {
        return this.m_41720_().m_5812_(this);
    }

    public Rarity m_41791_() {
        return this.m_41720_().m_41460_(this);
    }

    public boolean m_41792_() {
        if (!this.m_41720_().m_8120_(this)) {
            return false;
        }
        return !this.m_41793_();
    }

    public void m_41663_(Enchantment p_41664_, int p_41665_) {
        this.m_41784_();
        if (!this.f_41590_.m_128425_(f_150906_, 9)) {
            this.f_41590_.m_128365_(f_150906_, new ListTag());
        }
        ListTag listTag = this.f_41590_.m_128437_(f_150906_, 10);
        listTag.add(EnchantmentHelper.m_182443_(EnchantmentHelper.m_182432_(p_41664_), (byte)p_41665_));
    }

    public boolean m_41793_() {
        if (this.f_41590_ != null && this.f_41590_.m_128425_(f_150906_, 9)) {
            return !this.f_41590_.m_128437_(f_150906_, 10).isEmpty();
        }
        return false;
    }

    public void m_41700_(String p_41701_, net.minecraft.nbt.Tag p_41702_) {
        this.m_41784_().m_128365_(p_41701_, p_41702_);
    }

    public boolean m_41794_() {
        return this.f_41592_ instanceof ItemFrame;
    }

    public void m_41636_(@Nullable Entity p_41637_) {
        this.f_41592_ = p_41637_;
    }

    @Nullable
    public ItemFrame m_41795_() {
        return this.f_41592_ instanceof ItemFrame ? (ItemFrame)this.m_41609_() : null;
    }

    @Nullable
    public Entity m_41609_() {
        return !this.f_41591_ ? this.f_41592_ : null;
    }

    public int m_41610_() {
        if (this.m_41782_() && this.f_41590_.m_128425_(f_150915_, 3)) {
            return this.f_41590_.m_128451_(f_150915_);
        }
        return 0;
    }

    public void m_41742_(int p_41743_) {
        this.m_41784_().m_128405_(f_150915_, p_41743_);
    }

    public Multimap<Attribute, AttributeModifier> m_41638_(EquipmentSlot p_41639_) {
        HashMultimap hashMultimap;
        if (this.m_41782_() && this.f_41590_.m_128425_("AttributeModifiers", 9)) {
            hashMultimap = HashMultimap.create();
            ListTag \u00e2\u02dc\u01922 = this.f_41590_.m_128437_("AttributeModifiers", 10);
            for (int i = 0; i < \u00e2\u02dc\u01922.size(); ++i) {
                CompoundTag compoundTag = \u00e2\u02dc\u01922.m_128728_(i);
                if (compoundTag.m_128425_("Slot", 8) && !compoundTag.m_128461_("Slot").equals(p_41639_.m_20751_()) || !(\u00e2\u02dc\u0192 = Registry.f_122866_.m_6612_(ResourceLocation.m_135820_(compoundTag.m_128461_("AttributeName")))).isPresent() || (\u00e2\u02dc\u0192 = AttributeModifier.m_22212_(compoundTag)) == null || \u00e2\u02dc\u0192.m_22209_().getLeastSignificantBits() == 0L || \u00e2\u02dc\u0192.m_22209_().getMostSignificantBits() == 0L) continue;
                hashMultimap.put((Object)\u00e2\u02dc\u0192.get(), (Object)\u00e2\u02dc\u0192);
            }
        } else {
            hashMultimap = this.m_41720_().m_7167_(p_41639_);
        }
        return hashMultimap;
    }

    public void m_41643_(Attribute p_41644_, AttributeModifier p_41645_, @Nullable EquipmentSlot p_41646_) {
        this.m_41784_();
        if (!this.f_41590_.m_128425_("AttributeModifiers", 9)) {
            this.f_41590_.m_128365_("AttributeModifiers", new ListTag());
        }
        ListTag listTag = this.f_41590_.m_128437_("AttributeModifiers", 10);
        CompoundTag \u00e2\u02dc\u01922 = p_41645_.m_22219_();
        \u00e2\u02dc\u01922.m_128359_("AttributeName", Registry.f_122866_.m_7981_(p_41644_).toString());
        if (p_41646_ != null) {
            \u00e2\u02dc\u01922.m_128359_("Slot", p_41646_.m_20751_());
        }
        listTag.add(\u00e2\u02dc\u01922);
    }

    public Component m_41611_() {
        MutableComponent mutableComponent = new TextComponent("").m_7220_(this.m_41786_());
        if (this.m_41788_()) {
            mutableComponent.m_130940_(ChatFormatting.ITALIC);
        }
        \u00e2\u02dc\u0192 = ComponentUtils.m_130748_(mutableComponent);
        if (!this.f_41591_) {
            \u00e2\u02dc\u0192.m_130940_(this.m_41791_().f_43022_).m_130938_(p_41719_ -> p_41719_.m_131144_(new HoverEvent(HoverEvent.Action.f_130832_, new HoverEvent.ItemStackInfo(this))));
        }
        return \u00e2\u02dc\u0192;
    }

    private static boolean m_41693_(BlockInWorld p_41694_, @Nullable BlockInWorld p_41695_) {
        if (p_41695_ == null || p_41694_.m_61168_() != p_41695_.m_61168_()) {
            return false;
        }
        if (p_41694_.m_61174_() == null && p_41695_.m_61174_() == null) {
            return true;
        }
        if (p_41694_.m_61174_() == null || p_41695_.m_61174_() == null) {
            return false;
        }
        return Objects.equals(p_41694_.m_61174_().m_6945_(new CompoundTag()), p_41695_.m_61174_().m_6945_(new CompoundTag()));
    }

    public boolean m_41633_(TagContainer p_41634_, BlockInWorld p_41635_) {
        if (ItemStack.m_41693_(p_41635_, this.f_41593_)) {
            return this.f_41594_;
        }
        this.f_41593_ = p_41635_;
        if (this.m_41782_() && this.f_41590_.m_128425_(f_150916_, 9)) {
            ListTag listTag = this.f_41590_.m_128437_(f_150916_, 8);
            for (int i = 0; i < listTag.size(); ++i) {
                String string = listTag.m_128778_(i);
                try {
                    Predicate<BlockInWorld> predicate = BlockPredicateArgument.m_115570_().parse(new StringReader(string)).m_115602_(p_41634_);
                    if (predicate.test(p_41635_)) {
                        this.f_41594_ = true;
                        return true;
                    }
                    continue;
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
            }
        }
        this.f_41594_ = false;
        return false;
    }

    public boolean m_41723_(TagContainer p_41724_, BlockInWorld p_41725_) {
        if (ItemStack.m_41693_(p_41725_, this.f_41595_)) {
            return this.f_41596_;
        }
        this.f_41595_ = p_41725_;
        if (this.m_41782_() && this.f_41590_.m_128425_(f_150917_, 9)) {
            ListTag listTag = this.f_41590_.m_128437_(f_150917_, 8);
            for (int i = 0; i < listTag.size(); ++i) {
                String string = listTag.m_128778_(i);
                try {
                    Predicate<BlockInWorld> predicate = BlockPredicateArgument.m_115570_().parse(new StringReader(string)).m_115602_(p_41724_);
                    if (predicate.test(p_41725_)) {
                        this.f_41596_ = true;
                        return true;
                    }
                    continue;
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
            }
        }
        this.f_41596_ = false;
        return false;
    }

    public int m_41612_() {
        return this.f_41588_;
    }

    public void m_41754_(int p_41755_) {
        this.f_41588_ = p_41755_;
    }

    public int m_41613_() {
        return this.f_41591_ ? 0 : this.f_41587_;
    }

    public void m_41764_(int p_41765_) {
        this.f_41587_ = p_41765_;
        this.m_41617_();
    }

    public void m_41769_(int p_41770_) {
        this.m_41764_(this.f_41587_ + p_41770_);
    }

    public void m_41774_(int p_41775_) {
        this.m_41769_(-p_41775_);
    }

    public void m_41731_(Level p_41732_, LivingEntity p_41733_, int p_41734_) {
        this.m_41720_().m_5929_(p_41732_, p_41733_, this, p_41734_);
    }

    public void m_150924_(ItemEntity p_150925_) {
        this.m_41720_().m_142023_(p_150925_);
    }

    public boolean m_41614_() {
        return this.m_41720_().m_41472_();
    }

    public SoundEvent m_41615_() {
        return this.m_41720_().m_6023_();
    }

    public SoundEvent m_41616_() {
        return this.m_41720_().m_6061_();
    }

    @Nullable
    public SoundEvent m_150920_() {
        return this.m_41720_().m_142602_();
    }

    public static final class TooltipPart
    extends Enum<TooltipPart> {
        public static final /* enum */ TooltipPart ENCHANTMENTS = new TooltipPart();
        public static final /* enum */ TooltipPart MODIFIERS = new TooltipPart();
        public static final /* enum */ TooltipPart UNBREAKABLE = new TooltipPart();
        public static final /* enum */ TooltipPart CAN_DESTROY = new TooltipPart();
        public static final /* enum */ TooltipPart CAN_PLACE = new TooltipPart();
        public static final /* enum */ TooltipPart ADDITIONAL = new TooltipPart();
        public static final /* enum */ TooltipPart DYE = new TooltipPart();
        private final int f_41803_ = 1 << this.ordinal();
        private static final /* synthetic */ TooltipPart[] $VALUES;

        public static TooltipPart[] values() {
            return (TooltipPart[])$VALUES.clone();
        }

        public static TooltipPart valueOf(String p_41811_) {
            return Enum.valueOf(TooltipPart.class, p_41811_);
        }

        public int m_41809_() {
            return this.f_41803_;
        }

        private static /* synthetic */ TooltipPart[] m_150950_() {
            return new TooltipPart[]{ENCHANTMENTS, MODIFIERS, UNBREAKABLE, CAN_DESTROY, CAN_PLACE, ADDITIONAL, DYE};
        }

        static {
            $VALUES = TooltipPart.m_150950_();
        }
    }
}

