/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ComplexItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class MapItem
extends ComplexItem {
    public static final int f_151104_ = 128;
    public static final int f_151105_ = 128;
    private static final int f_151106_ = -12173266;
    private static final String f_151107_ = "map";

    public MapItem(Item.Properties p_42847_) {
        super(p_42847_);
    }

    public static ItemStack m_42886_(Level p_42887_, int p_42888_, int p_42889_, byte p_42890_, boolean p_42891_, boolean p_42892_) {
        ItemStack itemStack = new ItemStack(Items.f_42573_);
        MapItem.m_151111_(itemStack, p_42887_, p_42888_, p_42889_, p_42890_, p_42891_, p_42892_, p_42887_.m_46472_());
        return itemStack;
    }

    @Nullable
    public static MapItemSavedData m_151128_(@Nullable Integer p_151129_, Level p_151130_) {
        return p_151129_ == null ? null : p_151130_.m_7489_(MapItem.m_42848_(p_151129_));
    }

    @Nullable
    public static MapItemSavedData m_42853_(ItemStack p_42854_, Level p_42855_) {
        Integer n = MapItem.m_151131_(p_42854_);
        return MapItem.m_151128_(n, p_42855_);
    }

    @Nullable
    public static Integer m_151131_(ItemStack p_151132_) {
        CompoundTag compoundTag = p_151132_.m_41783_();
        return compoundTag != null && compoundTag.m_128425_(f_151107_, 99) ? Integer.valueOf(compoundTag.m_128451_(f_151107_)) : null;
    }

    private static int m_151120_(Level p_151121_, int p_151122_, int p_151123_, int p_151124_, boolean p_151125_, boolean p_151126_, ResourceKey<Level> p_151127_) {
        MapItemSavedData mapItemSavedData = MapItemSavedData.m_164780_(p_151122_, p_151123_, (byte)p_151124_, p_151125_, p_151126_, p_151127_);
        int \u00e2\u02dc\u01922 = p_151121_.m_7354_();
        p_151121_.m_142325_(MapItem.m_42848_(\u00e2\u02dc\u01922), mapItemSavedData);
        return \u00e2\u02dc\u01922;
    }

    private static void m_151108_(ItemStack p_151109_, int p_151110_) {
        p_151109_.m_41784_().m_128405_(f_151107_, p_151110_);
    }

    private static void m_151111_(ItemStack p_151112_, Level p_151113_, int p_151114_, int p_151115_, int p_151116_, boolean p_151117_, boolean p_151118_, ResourceKey<Level> p_151119_) {
        int n = MapItem.m_151120_(p_151113_, p_151114_, p_151115_, p_151116_, p_151117_, p_151118_, p_151119_);
        MapItem.m_151108_(p_151112_, n);
    }

    public static String m_42848_(int p_42849_) {
        return "map_" + p_42849_;
    }

    public void m_42893_(Level p_42894_, Entity p_42895_, MapItemSavedData p_42896_) {
        if (p_42894_.m_46472_() != p_42896_.f_77887_ || !(p_42895_ instanceof Player)) {
            return;
        }
        int n = 1 << p_42896_.f_77890_;
        \u00e2\u02dc\u0192 = p_42896_.f_77885_;
        \u00e2\u02dc\u0192 = p_42896_.f_77886_;
        \u00e2\u02dc\u0192 = Mth.m_14107_(p_42895_.m_20185_() - (double)\u00e2\u02dc\u0192) / n + 64;
        \u00e2\u02dc\u0192 = Mth.m_14107_(p_42895_.m_20189_() - (double)\u00e2\u02dc\u0192) / n + 64;
        \u00e2\u02dc\u0192 = 128 / n;
        if (p_42894_.m_6042_().m_63946_()) {
            \u00e2\u02dc\u0192 /= 2;
        }
        MapItemSavedData.HoldingPlayer \u00e2\u02dc\u01922 = p_42896_.m_77916_((Player)p_42895_);
        ++\u00e2\u02dc\u01922.f_77960_;
        boolean \u00e2\u02dc\u01923 = false;
        for (\u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 - \u00e2\u02dc\u0192 + 1; \u00e2\u02dc\u0192 < \u00e2\u02dc\u0192 + \u00e2\u02dc\u0192; ++\u00e2\u02dc\u0192) {
            if ((\u00e2\u02dc\u0192 & 0xF) != (\u00e2\u02dc\u01922.f_77960_ & 0xF) && !\u00e2\u02dc\u01923) continue;
            \u00e2\u02dc\u01923 = false;
            double \u00e2\u02dc\u019214 = 0.0;
            for (int i = \u00e2\u02dc\u0192 - \u00e2\u02dc\u0192 - 1; i < \u00e2\u02dc\u0192 + \u00e2\u02dc\u0192; ++i) {
                if (\u00e2\u02dc\u0192 < 0 || i < -1 || \u00e2\u02dc\u0192 >= 128 || i >= 128) continue;
                \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 - \u00e2\u02dc\u0192;
                \u00e2\u02dc\u0192 = i - \u00e2\u02dc\u0192;
                boolean bl = \u00e2\u02dc\u0192 * \u00e2\u02dc\u0192 + \u00e2\u02dc\u0192 * \u00e2\u02dc\u0192 > (\u00e2\u02dc\u0192 - 2) * (\u00e2\u02dc\u0192 - 2);
                int \u00e2\u02dc\u01924 = (\u00e2\u02dc\u0192 / n + \u00e2\u02dc\u0192 - 64) * n;
                int \u00e2\u02dc\u01925 = (\u00e2\u02dc\u0192 / n + i - 64) * n;
                LinkedHashMultiset \u00e2\u02dc\u01926 = LinkedHashMultiset.create();
                LevelChunk \u00e2\u02dc\u01927 = p_42894_.m_46745_(new BlockPos(\u00e2\u02dc\u01924, 0, \u00e2\u02dc\u01925));
                if (\u00e2\u02dc\u01927.m_6430_()) continue;
                ChunkPos \u00e2\u02dc\u01928 = \u00e2\u02dc\u01927.m_7697_();
                int \u00e2\u02dc\u01929 = \u00e2\u02dc\u01924 & 0xF;
                int \u00e2\u02dc\u019210 = \u00e2\u02dc\u01925 & 0xF;
                int \u00e2\u02dc\u019211 = 0;
                double \u00e2\u02dc\u019212 = 0.0;
                if (p_42894_.m_6042_().m_63946_()) {
                    int n2 = \u00e2\u02dc\u01924 + \u00e2\u02dc\u01925 * 231871;
                    if (((n2 = n2 * n2 * 31287121 + n2 * 11) >> 20 & 1) == 0) {
                        \u00e2\u02dc\u01926.add((Object)Blocks.f_50493_.m_49966_().m_60780_(p_42894_, BlockPos.f_121853_), 10);
                    } else {
                        \u00e2\u02dc\u01926.add((Object)Blocks.f_50069_.m_49966_().m_60780_(p_42894_, BlockPos.f_121853_), 100);
                    }
                    \u00e2\u02dc\u019212 = 100.0;
                } else {
                    BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
                    \u00e2\u02dc\u0192 = new BlockPos.MutableBlockPos();
                    for (int j = 0; j < n; ++j) {
                        for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < n; ++\u00e2\u02dc\u0192) {
                            \u00e2\u02dc\u0192 = \u00e2\u02dc\u01927.m_5885_(Heightmap.Types.WORLD_SURFACE, j + \u00e2\u02dc\u01929, \u00e2\u02dc\u0192 + \u00e2\u02dc\u019210) + 1;
                            if (\u00e2\u02dc\u0192 > p_42894_.m_141937_() + 1) {
                                do {
                                    mutableBlockPos.m_122178_(\u00e2\u02dc\u01928.m_45604_() + j + \u00e2\u02dc\u01929, --\u00e2\u02dc\u0192, \u00e2\u02dc\u01928.m_45605_() + \u00e2\u02dc\u0192 + \u00e2\u02dc\u019210);
                                } while ((\u00e2\u02dc\u0192 = \u00e2\u02dc\u01927.m_8055_(mutableBlockPos)).m_60780_(p_42894_, mutableBlockPos) == MaterialColor.f_76398_ && \u00e2\u02dc\u0192 > p_42894_.m_141937_());
                                if (\u00e2\u02dc\u0192 > p_42894_.m_141937_() && !\u00e2\u02dc\u0192.m_60819_().m_76178_()) {
                                    \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 - 1;
                                    \u00e2\u02dc\u0192.m_122190_(mutableBlockPos);
                                    do {
                                        \u00e2\u02dc\u0192.m_142448_(\u00e2\u02dc\u0192--);
                                        BlockState blockState = \u00e2\u02dc\u01927.m_8055_(\u00e2\u02dc\u0192);
                                        ++\u00e2\u02dc\u019211;
                                    } while (\u00e2\u02dc\u0192 > p_42894_.m_141937_() && !blockState.m_60819_().m_76178_());
                                    \u00e2\u02dc\u0192 = this.m_42900_(p_42894_, \u00e2\u02dc\u0192, mutableBlockPos);
                                }
                            } else {
                                \u00e2\u02dc\u0192 = Blocks.f_50752_.m_49966_();
                            }
                            p_42896_.m_77930_(p_42894_, \u00e2\u02dc\u01928.m_45604_() + j + \u00e2\u02dc\u01929, \u00e2\u02dc\u01928.m_45605_() + \u00e2\u02dc\u0192 + \u00e2\u02dc\u019210);
                            \u00e2\u02dc\u019212 += (double)\u00e2\u02dc\u0192 / (double)(n * n);
                            \u00e2\u02dc\u01926.add((Object)\u00e2\u02dc\u0192.m_60780_(p_42894_, mutableBlockPos));
                        }
                    }
                }
                \u00e2\u02dc\u019211 /= n * n;
                double \u00e2\u02dc\u019213 = (\u00e2\u02dc\u019212 - \u00e2\u02dc\u019214) * 4.0 / (double)(n + 4) + ((double)(\u00e2\u02dc\u0192 + i & 1) - 0.5) * 0.4;
                j = 1;
                if (\u00e2\u02dc\u019213 > 0.6) {
                    j = 2;
                }
                if (\u00e2\u02dc\u019213 < -0.6) {
                    j = 0;
                }
                if ((\u00e2\u02dc\u0192 = (MaterialColor)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)\u00e2\u02dc\u01926), (Object)MaterialColor.f_76398_)) == MaterialColor.f_76410_) {
                    \u00e2\u02dc\u019213 = (double)\u00e2\u02dc\u019211 * 0.1 + (double)(\u00e2\u02dc\u0192 + i & 1) * 0.2;
                    j = 1;
                    if (\u00e2\u02dc\u019213 < 0.5) {
                        j = 2;
                    }
                    if (\u00e2\u02dc\u019213 > 0.9) {
                        j = 0;
                    }
                }
                \u00e2\u02dc\u019214 = \u00e2\u02dc\u019212;
                if (i < 0 || \u00e2\u02dc\u0192 * \u00e2\u02dc\u0192 + \u00e2\u02dc\u0192 * \u00e2\u02dc\u0192 >= \u00e2\u02dc\u0192 * \u00e2\u02dc\u0192 || bl && (\u00e2\u02dc\u0192 + i & 1) == 0) continue;
                \u00e2\u02dc\u01923 |= p_42896_.m_164792_(\u00e2\u02dc\u0192, i, (byte)(\u00e2\u02dc\u0192.f_76397_ * 4 + j));
            }
        }
    }

    private BlockState m_42900_(Level p_42901_, BlockState p_42902_, BlockPos p_42903_) {
        FluidState fluidState = p_42902_.m_60819_();
        if (!fluidState.m_76178_() && !p_42902_.m_60783_(p_42901_, p_42903_, Direction.UP)) {
            return fluidState.m_76188_();
        }
        return p_42902_;
    }

    private static boolean m_42904_(Biome[] p_42905_, int p_42906_, int p_42907_, int p_42908_) {
        return p_42905_[p_42907_ * p_42906_ + p_42908_ * p_42906_ * 128 * p_42906_].m_47545_() >= 0.0f;
    }

    public static void m_42850_(ServerLevel p_42851_, ItemStack p_42852_) {
        int n;
        MapItemSavedData mapItemSavedData = MapItem.m_42853_(p_42852_, p_42851_);
        if (mapItemSavedData == null) {
            return;
        }
        if (p_42851_.m_46472_() != mapItemSavedData.f_77887_) {
            return;
        }
        int \u00e2\u02dc\u01922 = 1 << mapItemSavedData.f_77890_;
        int \u00e2\u02dc\u01923 = mapItemSavedData.f_77885_;
        int \u00e2\u02dc\u01924 = mapItemSavedData.f_77886_;
        Biome[] \u00e2\u02dc\u01925 = new Biome[128 * \u00e2\u02dc\u01922 * 128 * \u00e2\u02dc\u01922];
        for (n = 0; n < 128 * \u00e2\u02dc\u01922; ++n) {
            for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < 128 * \u00e2\u02dc\u01922; ++\u00e2\u02dc\u0192) {
                \u00e2\u02dc\u01925[n * 128 * \u00e2\u02dc\u01922 + \u00e2\u02dc\u0192] = p_42851_.m_46857_(new BlockPos((\u00e2\u02dc\u01923 / \u00e2\u02dc\u01922 - 64) * \u00e2\u02dc\u01922 + \u00e2\u02dc\u0192, 0, (\u00e2\u02dc\u01924 / \u00e2\u02dc\u01922 - 64) * \u00e2\u02dc\u01922 + n));
            }
        }
        for (n = 0; n < 128; ++n) {
            for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < 128; ++\u00e2\u02dc\u0192) {
                if (n <= 0 || \u00e2\u02dc\u0192 <= 0 || n >= 127 || \u00e2\u02dc\u0192 >= 127) continue;
                Biome biome = \u00e2\u02dc\u01925[n * \u00e2\u02dc\u01922 + \u00e2\u02dc\u0192 * \u00e2\u02dc\u01922 * 128 * \u00e2\u02dc\u01922];
                int \u00e2\u02dc\u01926 = 8;
                if (MapItem.m_42904_(\u00e2\u02dc\u01925, \u00e2\u02dc\u01922, n - 1, \u00e2\u02dc\u0192 - 1)) {
                    --\u00e2\u02dc\u01926;
                }
                if (MapItem.m_42904_(\u00e2\u02dc\u01925, \u00e2\u02dc\u01922, n - 1, \u00e2\u02dc\u0192 + 1)) {
                    --\u00e2\u02dc\u01926;
                }
                if (MapItem.m_42904_(\u00e2\u02dc\u01925, \u00e2\u02dc\u01922, n - 1, \u00e2\u02dc\u0192)) {
                    --\u00e2\u02dc\u01926;
                }
                if (MapItem.m_42904_(\u00e2\u02dc\u01925, \u00e2\u02dc\u01922, n + 1, \u00e2\u02dc\u0192 - 1)) {
                    --\u00e2\u02dc\u01926;
                }
                if (MapItem.m_42904_(\u00e2\u02dc\u01925, \u00e2\u02dc\u01922, n + 1, \u00e2\u02dc\u0192 + 1)) {
                    --\u00e2\u02dc\u01926;
                }
                if (MapItem.m_42904_(\u00e2\u02dc\u01925, \u00e2\u02dc\u01922, n + 1, \u00e2\u02dc\u0192)) {
                    --\u00e2\u02dc\u01926;
                }
                if (MapItem.m_42904_(\u00e2\u02dc\u01925, \u00e2\u02dc\u01922, n, \u00e2\u02dc\u0192 - 1)) {
                    --\u00e2\u02dc\u01926;
                }
                if (MapItem.m_42904_(\u00e2\u02dc\u01925, \u00e2\u02dc\u01922, n, \u00e2\u02dc\u0192 + 1)) {
                    --\u00e2\u02dc\u01926;
                }
                int \u00e2\u02dc\u01927 = 3;
                MaterialColor \u00e2\u02dc\u01928 = MaterialColor.f_76398_;
                if (biome.m_47545_() < 0.0f) {
                    \u00e2\u02dc\u01928 = MaterialColor.f_76413_;
                    if (\u00e2\u02dc\u01926 > 7 && \u00e2\u02dc\u0192 % 2 == 0) {
                        \u00e2\u02dc\u01927 = (n + (int)(Mth.m_14031_((float)\u00e2\u02dc\u0192 + 0.0f) * 7.0f)) / 8 % 5;
                        if (\u00e2\u02dc\u01927 == 3) {
                            \u00e2\u02dc\u01927 = 1;
                        } else if (\u00e2\u02dc\u01927 == 4) {
                            \u00e2\u02dc\u01927 = 0;
                        }
                    } else if (\u00e2\u02dc\u01926 > 7) {
                        \u00e2\u02dc\u01928 = MaterialColor.f_76398_;
                    } else if (\u00e2\u02dc\u01926 > 5) {
                        \u00e2\u02dc\u01927 = 1;
                    } else if (\u00e2\u02dc\u01926 > 3) {
                        \u00e2\u02dc\u01927 = 0;
                    } else if (\u00e2\u02dc\u01926 > 1) {
                        \u00e2\u02dc\u01927 = 0;
                    }
                } else if (\u00e2\u02dc\u01926 > 0) {
                    \u00e2\u02dc\u01928 = MaterialColor.f_76362_;
                    \u00e2\u02dc\u01927 = \u00e2\u02dc\u01926 > 3 ? 1 : 3;
                }
                if (\u00e2\u02dc\u01928 == MaterialColor.f_76398_) continue;
                mapItemSavedData.m_164803_(n, \u00e2\u02dc\u0192, (byte)(\u00e2\u02dc\u01928.f_76397_ * 4 + \u00e2\u02dc\u01927));
            }
        }
    }

    @Override
    public void m_6883_(ItemStack p_42870_, Level p_42871_, Entity p_42872_, int p_42873_, boolean p_42874_) {
        if (p_42871_.f_46443_) {
            return;
        }
        MapItemSavedData mapItemSavedData = MapItem.m_42853_(p_42870_, p_42871_);
        if (mapItemSavedData == null) {
            return;
        }
        if (p_42872_ instanceof Player) {
            Player player = (Player)p_42872_;
            mapItemSavedData.m_77918_(player, p_42870_);
        }
        if (!mapItemSavedData.f_77892_ && (p_42874_ || p_42872_ instanceof Player && ((Player)p_42872_).m_21206_() == p_42870_)) {
            this.m_42893_(p_42871_, p_42872_, mapItemSavedData);
        }
    }

    @Override
    @Nullable
    public Packet<?> m_7233_(ItemStack p_42876_, Level p_42877_, Player p_42878_) {
        Integer n = MapItem.m_151131_(p_42876_);
        MapItemSavedData \u00e2\u02dc\u01922 = MapItem.m_151128_(n, p_42877_);
        if (\u00e2\u02dc\u01922 != null) {
            return \u00e2\u02dc\u01922.m_164796_(n, p_42878_);
        }
        return null;
    }

    @Override
    public void m_7836_(ItemStack p_42913_, Level p_42914_, Player p_42915_) {
        CompoundTag compoundTag = p_42913_.m_41783_();
        if (compoundTag != null && compoundTag.m_128425_("map_scale_direction", 99)) {
            MapItem.m_42856_(p_42913_, p_42914_, compoundTag.m_128451_("map_scale_direction"));
            compoundTag.m_128473_("map_scale_direction");
        } else if (compoundTag != null && compoundTag.m_128425_("map_to_lock", 1) && compoundTag.m_128471_("map_to_lock")) {
            MapItem.m_42897_(p_42914_, p_42913_);
            compoundTag.m_128473_("map_to_lock");
        }
    }

    private static void m_42856_(ItemStack p_42857_, Level p_42858_, int p_42859_) {
        MapItemSavedData mapItemSavedData = MapItem.m_42853_(p_42857_, p_42858_);
        if (mapItemSavedData != null) {
            int n = p_42858_.m_7354_();
            p_42858_.m_142325_(MapItem.m_42848_(n), mapItemSavedData.m_164787_(p_42859_));
            MapItem.m_151108_(p_42857_, n);
        }
    }

    public static void m_42897_(Level p_42898_, ItemStack p_42899_) {
        MapItemSavedData mapItemSavedData = MapItem.m_42853_(p_42899_, p_42898_);
        if (mapItemSavedData != null) {
            int n = p_42898_.m_7354_();
            String \u00e2\u02dc\u01922 = MapItem.m_42848_(n);
            MapItemSavedData \u00e2\u02dc\u01923 = mapItemSavedData.m_164775_();
            p_42898_.m_142325_(\u00e2\u02dc\u01922, \u00e2\u02dc\u01923);
            MapItem.m_151108_(p_42899_, n);
        }
    }

    @Override
    public void m_7373_(ItemStack p_42880_, @Nullable Level p_42881_, List<Component> p_42882_, TooltipFlag p_42883_) {
        Integer n = MapItem.m_151131_(p_42880_);
        MapItemSavedData mapItemSavedData = \u00e2\u02dc\u0192 = p_42881_ == null ? null : MapItem.m_151128_(n, p_42881_);
        if (\u00e2\u02dc\u0192 != null && \u00e2\u02dc\u0192.f_77892_) {
            p_42882_.add(new TranslatableComponent("filled_map.locked", n).m_130940_(ChatFormatting.GRAY));
        }
        if (p_42883_.m_7050_()) {
            if (\u00e2\u02dc\u0192 != null) {
                p_42882_.add(new TranslatableComponent("filled_map.id", n).m_130940_(ChatFormatting.GRAY));
                p_42882_.add(new TranslatableComponent("filled_map.scale", 1 << \u00e2\u02dc\u0192.f_77890_).m_130940_(ChatFormatting.GRAY));
                p_42882_.add(new TranslatableComponent("filled_map.level", \u00e2\u02dc\u0192.f_77890_, 4).m_130940_(ChatFormatting.GRAY));
            } else {
                p_42882_.add(new TranslatableComponent("filled_map.unknown").m_130940_(ChatFormatting.GRAY));
            }
        }
    }

    public static int m_42918_(ItemStack p_42919_) {
        CompoundTag compoundTag = p_42919_.m_41737_("display");
        if (compoundTag != null && compoundTag.m_128425_("MapColor", 99)) {
            int n = compoundTag.m_128451_("MapColor");
            return 0xFF000000 | n & 0xFFFFFF;
        }
        return -12173266;
    }

    @Override
    public InteractionResult m_6225_(UseOnContext p_42885_) {
        BlockState blockState = p_42885_.m_43725_().m_8055_(p_42885_.m_8083_());
        if (blockState.m_60620_(BlockTags.f_13028_)) {
            if (!p_42885_.m_43725_().f_46443_ && (\u00e2\u02dc\u0192 = MapItem.m_42853_(p_42885_.m_43722_(), p_42885_.m_43725_())) != null && !\u00e2\u02dc\u0192.m_77934_(p_42885_.m_43725_(), p_42885_.m_8083_())) {
                return InteractionResult.FAIL;
            }
            return InteractionResult.m_19078_(p_42885_.m_43725_().f_46443_);
        }
        return super.m_6225_(p_42885_);
    }
}

