/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SpawnEggItem
extends Item {
    private static final Map<EntityType<? extends Mob>, SpawnEggItem> f_43201_ = Maps.newIdentityHashMap();
    private final int f_151200_;
    private final int f_151201_;
    private final EntityType<?> f_43204_;

    public SpawnEggItem(EntityType<? extends Mob> p_43207_, int p_43208_, int p_43209_, Item.Properties p_43210_) {
        super(p_43210_);
        this.f_43204_ = p_43207_;
        this.f_151200_ = p_43208_;
        this.f_151201_ = p_43209_;
        f_43201_.put(p_43207_, this);
    }

    @Override
    public InteractionResult m_6225_(UseOnContext p_43223_) {
        Level level = p_43223_.m_43725_();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack \u00e2\u02dc\u01922 = p_43223_.m_43722_();
        BlockPos \u00e2\u02dc\u01923 = p_43223_.m_8083_();
        Direction \u00e2\u02dc\u01924 = p_43223_.m_43719_();
        BlockState \u00e2\u02dc\u01925 = level.m_8055_(\u00e2\u02dc\u01923);
        if (\u00e2\u02dc\u01925.m_60713_(Blocks.f_50085_) && (object = level.m_7702_(\u00e2\u02dc\u01923)) instanceof SpawnerBlockEntity) {
            BaseSpawner baseSpawner = ((SpawnerBlockEntity)object).m_59801_();
            EntityType<?> \u00e2\u02dc\u01926 = this.m_43228_(\u00e2\u02dc\u01922.m_41783_());
            baseSpawner.m_45462_(\u00e2\u02dc\u01926);
            ((BlockEntity)object).m_6596_();
            level.m_7260_(\u00e2\u02dc\u01923, \u00e2\u02dc\u01925, \u00e2\u02dc\u01925, 3);
            \u00e2\u02dc\u01922.m_41774_(1);
            return InteractionResult.CONSUME;
        }
        Object object = \u00e2\u02dc\u01925.m_60812_(level, \u00e2\u02dc\u01923).m_83281_() ? \u00e2\u02dc\u01923 : \u00e2\u02dc\u01923.m_142300_(\u00e2\u02dc\u01924);
        EntityType<?> \u00e2\u02dc\u01927 = this.m_43228_(\u00e2\u02dc\u01922.m_41783_());
        if (\u00e2\u02dc\u01927.m_20592_((ServerLevel)level, \u00e2\u02dc\u01922, p_43223_.m_43723_(), (BlockPos)object, MobSpawnType.SPAWN_EGG, true, !Objects.equals(\u00e2\u02dc\u01923, object) && \u00e2\u02dc\u01924 == Direction.UP) != null) {
            \u00e2\u02dc\u01922.m_41774_(1);
            level.m_142346_(p_43223_.m_43723_(), GameEvent.f_157810_, \u00e2\u02dc\u01923);
        }
        return InteractionResult.CONSUME;
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level p_43225_, Player p_43226_, InteractionHand p_43227_) {
        ItemStack itemStack = p_43226_.m_21120_(p_43227_);
        BlockHitResult \u00e2\u02dc\u01922 = SpawnEggItem.m_41435_(p_43225_, p_43226_, ClipContext.Fluid.SOURCE_ONLY);
        if (((HitResult)\u00e2\u02dc\u01922).m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_(itemStack);
        }
        if (!(p_43225_ instanceof ServerLevel)) {
            return InteractionResultHolder.m_19090_(itemStack);
        }
        BlockHitResult \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922;
        BlockPos \u00e2\u02dc\u01924 = \u00e2\u02dc\u01923.m_82425_();
        if (!(p_43225_.m_8055_(\u00e2\u02dc\u01924).m_60734_() instanceof LiquidBlock)) {
            return InteractionResultHolder.m_19098_(itemStack);
        }
        if (!p_43225_.m_7966_(p_43226_, \u00e2\u02dc\u01924) || !p_43226_.m_36204_(\u00e2\u02dc\u01924, \u00e2\u02dc\u01923.m_82434_(), itemStack)) {
            return InteractionResultHolder.m_19100_(itemStack);
        }
        EntityType<?> \u00e2\u02dc\u01925 = this.m_43228_(itemStack.m_41783_());
        if (\u00e2\u02dc\u01925.m_20592_((ServerLevel)p_43225_, itemStack, p_43226_, \u00e2\u02dc\u01924, MobSpawnType.SPAWN_EGG, false, false) == null) {
            return InteractionResultHolder.m_19098_(itemStack);
        }
        if (!p_43226_.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        p_43226_.m_36246_(Stats.f_12982_.m_12902_(this));
        p_43225_.m_151552_(GameEvent.f_157810_, p_43226_);
        return InteractionResultHolder.m_19096_(itemStack);
    }

    public boolean m_43230_(@Nullable CompoundTag p_43231_, EntityType<?> p_43232_) {
        return Objects.equals(this.m_43228_(p_43231_), p_43232_);
    }

    public int m_43211_(int p_43212_) {
        return p_43212_ == 0 ? this.f_151200_ : this.f_151201_;
    }

    @Nullable
    public static SpawnEggItem m_43213_(@Nullable EntityType<?> p_43214_) {
        return f_43201_.get(p_43214_);
    }

    public static Iterable<SpawnEggItem> m_43233_() {
        return Iterables.unmodifiableIterable(f_43201_.values());
    }

    public EntityType<?> m_43228_(@Nullable CompoundTag p_43229_) {
        CompoundTag compoundTag;
        if (p_43229_ != null && p_43229_.m_128425_("EntityTag", 10) && (compoundTag = p_43229_.m_128469_("EntityTag")).m_128425_("id", 8)) {
            return EntityType.m_20632_(compoundTag.m_128461_("id")).orElse(this.f_43204_);
        }
        return this.f_43204_;
    }

    public Optional<Mob> m_43215_(Player p_43216_, Mob p_43217_, EntityType<? extends Mob> p_43218_, ServerLevel p_43219_, Vec3 p_43220_, ItemStack p_43221_) {
        if (!this.m_43230_(p_43221_.m_41783_(), p_43218_)) {
            return Optional.empty();
        }
        Mob mob = p_43217_ instanceof AgeableMob ? ((AgeableMob)p_43217_).m_142606_(p_43219_, (AgeableMob)p_43217_) : p_43218_.m_20615_(p_43219_);
        if (mob == null) {
            return Optional.empty();
        }
        mob.m_6863_(true);
        if (!mob.m_6162_()) {
            return Optional.empty();
        }
        mob.m_7678_(p_43220_.m_7096_(), p_43220_.m_7098_(), p_43220_.m_7094_(), 0.0f, 0.0f);
        p_43219_.m_47205_(mob);
        if (p_43221_.m_41788_()) {
            mob.m_6593_(p_43221_.m_41786_());
        }
        if (!p_43216_.m_150110_().f_35937_) {
            p_43221_.m_41774_(1);
        }
        return Optional.of(mob);
    }
}

