/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class TridentItem
extends Item
implements Vanishable {
    public static final int f_151230_ = 10;
    public static final float f_151231_ = 8.0f;
    public static final float f_151232_ = 2.5f;
    private final Multimap<Attribute, AttributeModifier> f_43379_;

    public TridentItem(Item.Properties p_43381_) {
        super(p_43381_);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", 8.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)-2.9f, AttributeModifier.Operation.ADDITION));
        this.f_43379_ = builder.build();
    }

    @Override
    public boolean m_6777_(BlockState p_43409_, Level p_43410_, BlockPos p_43411_, Player p_43412_) {
        return !p_43412_.m_7500_();
    }

    @Override
    public UseAnim m_6164_(ItemStack p_43417_) {
        return UseAnim.SPEAR;
    }

    @Override
    public int m_8105_(ItemStack p_43419_) {
        return 72000;
    }

    @Override
    public void m_5551_(ItemStack p_43394_, Level p_43395_, LivingEntity p_43396_, int p_43397_) {
        if (!(p_43396_ instanceof Player)) {
            return;
        }
        Player player = (Player)p_43396_;
        int \u00e2\u02dc\u01922 = this.m_8105_(p_43394_) - p_43397_;
        if (\u00e2\u02dc\u01922 < 10) {
            return;
        }
        int \u00e2\u02dc\u01923 = EnchantmentHelper.m_44932_(p_43394_);
        if (\u00e2\u02dc\u01923 > 0 && !player.m_20070_()) {
            return;
        }
        if (!p_43395_.f_46443_) {
            p_43394_.m_41622_(1, player, p_43388_ -> p_43388_.m_21190_(p_43396_.m_7655_()));
            if (\u00e2\u02dc\u01923 == 0) {
                ThrownTrident thrownTrident = new ThrownTrident(p_43395_, (LivingEntity)player, p_43394_);
                thrownTrident.m_37251_(player, player.m_146909_(), player.m_146908_(), 0.0f, 2.5f + (float)\u00e2\u02dc\u01923 * 0.5f, 1.0f);
                if (player.m_150110_().f_35937_) {
                    thrownTrident.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                }
                p_43395_.m_7967_(thrownTrident);
                p_43395_.m_6269_(null, thrownTrident, SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f);
                if (!player.m_150110_().f_35937_) {
                    player.m_150109_().m_36057_(p_43394_);
                }
            }
        }
        player.m_36246_(Stats.f_12982_.m_12902_(this));
        if (\u00e2\u02dc\u01923 > 0) {
            float f = player.m_146908_();
            \u00e2\u02dc\u0192 = player.m_146909_();
            \u00e2\u02dc\u0192 = -Mth.m_14031_(f * ((float)Math.PI / 180)) * Mth.m_14089_(\u00e2\u02dc\u0192 * ((float)Math.PI / 180));
            \u00e2\u02dc\u0192 = -Mth.m_14031_(\u00e2\u02dc\u0192 * ((float)Math.PI / 180));
            \u00e2\u02dc\u0192 = Mth.m_14089_(f * ((float)Math.PI / 180)) * Mth.m_14089_(\u00e2\u02dc\u0192 * ((float)Math.PI / 180));
            \u00e2\u02dc\u0192 = Mth.m_14116_(\u00e2\u02dc\u0192 * \u00e2\u02dc\u0192 + \u00e2\u02dc\u0192 * \u00e2\u02dc\u0192 + \u00e2\u02dc\u0192 * \u00e2\u02dc\u0192);
            \u00e2\u02dc\u0192 = 3.0f * ((1.0f + (float)\u00e2\u02dc\u01923) / 4.0f);
            player.m_5997_(\u00e2\u02dc\u0192 *= \u00e2\u02dc\u0192 / \u00e2\u02dc\u0192, \u00e2\u02dc\u0192 *= \u00e2\u02dc\u0192 / \u00e2\u02dc\u0192, \u00e2\u02dc\u0192 *= \u00e2\u02dc\u0192 / \u00e2\u02dc\u0192);
            player.m_21326_(20);
            if (player.m_20096_()) {
                \u00e2\u02dc\u0192 = 1.1999999f;
                player.m_6478_(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
            }
            SoundEvent \u00e2\u02dc\u01924 = \u00e2\u02dc\u01923 >= 3 ? SoundEvents.f_12519_ : (\u00e2\u02dc\u01923 == 2 ? SoundEvents.f_12518_ : SoundEvents.f_12517_);
            p_43395_.m_6269_(null, player, \u00e2\u02dc\u01924, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level p_43405_, Player p_43406_, InteractionHand p_43407_) {
        ItemStack itemStack = p_43406_.m_21120_(p_43407_);
        if (itemStack.m_41773_() >= itemStack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_(itemStack);
        }
        if (EnchantmentHelper.m_44932_(itemStack) > 0 && !p_43406_.m_20070_()) {
            return InteractionResultHolder.m_19100_(itemStack);
        }
        p_43406_.m_6672_(p_43407_);
        return InteractionResultHolder.m_19096_(itemStack);
    }

    @Override
    public boolean m_7579_(ItemStack p_43390_, LivingEntity p_43391_, LivingEntity p_43392_) {
        p_43390_.m_41622_(1, p_43392_, p_43414_ -> p_43414_.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    @Override
    public boolean m_6813_(ItemStack p_43399_, Level p_43400_, BlockState p_43401_, BlockPos p_43402_, LivingEntity p_43403_) {
        if ((double)p_43401_.m_60800_(p_43400_, p_43402_) != 0.0) {
            p_43399_.m_41622_(2, p_43403_, p_43385_ -> p_43385_.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    @Override
    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot p_43383_) {
        if (p_43383_ == EquipmentSlot.MAINHAND) {
            return this.f_43379_;
        }
        return super.m_7167_(p_43383_);
    }

    @Override
    public int m_6473_() {
        return 1;
    }
}

