/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.alchemy;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;

public class PotionUtils {
    public static final String f_151254_ = "CustomPotionEffects";
    public static final String f_151255_ = "CustomPotionColor";
    public static final String f_151256_ = "Potion";
    private static final int f_151257_ = 0xF800F8;
    private static final Component f_43545_ = new TranslatableComponent("effect.none").m_130940_(ChatFormatting.GRAY);

    public static List<MobEffectInstance> m_43547_(ItemStack p_43548_) {
        return PotionUtils.m_43566_(p_43548_.m_41783_());
    }

    public static List<MobEffectInstance> m_43561_(Potion p_43562_, Collection<MobEffectInstance> p_43563_) {
        ArrayList arrayList = Lists.newArrayList();
        arrayList.addAll(p_43562_.m_43488_());
        arrayList.addAll(p_43563_);
        return arrayList;
    }

    public static List<MobEffectInstance> m_43566_(@Nullable CompoundTag p_43567_) {
        ArrayList arrayList = Lists.newArrayList();
        arrayList.addAll(PotionUtils.m_43577_(p_43567_).m_43488_());
        PotionUtils.m_43568_(p_43567_, arrayList);
        return arrayList;
    }

    public static List<MobEffectInstance> m_43571_(ItemStack p_43572_) {
        return PotionUtils.m_43573_(p_43572_.m_41783_());
    }

    public static List<MobEffectInstance> m_43573_(@Nullable CompoundTag p_43574_) {
        ArrayList arrayList = Lists.newArrayList();
        PotionUtils.m_43568_(p_43574_, arrayList);
        return arrayList;
    }

    public static void m_43568_(@Nullable CompoundTag p_43569_, List<MobEffectInstance> p_43570_) {
        if (p_43569_ != null && p_43569_.m_128425_(f_151254_, 9)) {
            ListTag listTag = p_43569_.m_128437_(f_151254_, 10);
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag compoundTag = listTag.m_128728_(i);
                MobEffectInstance \u00e2\u02dc\u01922 = MobEffectInstance.m_19560_(compoundTag);
                if (\u00e2\u02dc\u01922 == null) continue;
                p_43570_.add(\u00e2\u02dc\u01922);
            }
        }
    }

    public static int m_43575_(ItemStack p_43576_) {
        CompoundTag compoundTag = p_43576_.m_41783_();
        if (compoundTag != null && compoundTag.m_128425_(f_151255_, 99)) {
            return compoundTag.m_128451_(f_151255_);
        }
        return PotionUtils.m_43579_(p_43576_) == Potions.f_43598_ ? 0xF800F8 : PotionUtils.m_43564_(PotionUtils.m_43547_(p_43576_));
    }

    public static int m_43559_(Potion p_43560_) {
        return p_43560_ == Potions.f_43598_ ? 0xF800F8 : PotionUtils.m_43564_(p_43560_.m_43488_());
    }

    public static int m_43564_(Collection<MobEffectInstance> p_43565_) {
        int n;
        int n2 = 3694022;
        if (p_43565_.isEmpty()) {
            return 3694022;
        }
        float \u00e2\u02dc\u01922 = 0.0f;
        float \u00e2\u02dc\u01923 = 0.0f;
        float \u00e2\u02dc\u01924 = 0.0f;
        n = 0;
        for (MobEffectInstance mobEffectInstance : p_43565_) {
            if (!mobEffectInstance.m_19572_()) continue;
            int n3 = mobEffectInstance.m_19544_().m_19484_();
            \u00e2\u02dc\u0192 = mobEffectInstance.m_19564_() + 1;
            \u00e2\u02dc\u01922 += (float)(\u00e2\u02dc\u0192 * (n3 >> 16 & 0xFF)) / 255.0f;
            \u00e2\u02dc\u01923 += (float)(\u00e2\u02dc\u0192 * (n3 >> 8 & 0xFF)) / 255.0f;
            \u00e2\u02dc\u01924 += (float)(\u00e2\u02dc\u0192 * (n3 >> 0 & 0xFF)) / 255.0f;
            n += \u00e2\u02dc\u0192;
        }
        if (n == 0) {
            return 0;
        }
        \u00e2\u02dc\u01922 = \u00e2\u02dc\u01922 / (float)n * 255.0f;
        \u00e2\u02dc\u01923 = \u00e2\u02dc\u01923 / (float)n * 255.0f;
        \u00e2\u02dc\u01924 = \u00e2\u02dc\u01924 / (float)n * 255.0f;
        return (int)\u00e2\u02dc\u01922 << 16 | (int)\u00e2\u02dc\u01923 << 8 | (int)\u00e2\u02dc\u01924;
    }

    public static Potion m_43579_(ItemStack p_43580_) {
        return PotionUtils.m_43577_(p_43580_.m_41783_());
    }

    public static Potion m_43577_(@Nullable CompoundTag p_43578_) {
        if (p_43578_ == null) {
            return Potions.f_43598_;
        }
        return Potion.m_43489_(p_43578_.m_128461_(f_151256_));
    }

    public static ItemStack m_43549_(ItemStack p_43550_, Potion p_43551_) {
        ResourceLocation resourceLocation = Registry.f_122828_.m_7981_(p_43551_);
        if (p_43551_ == Potions.f_43598_) {
            p_43550_.m_41749_(f_151256_);
        } else {
            p_43550_.m_41784_().m_128359_(f_151256_, resourceLocation.toString());
        }
        return p_43550_;
    }

    public static ItemStack m_43552_(ItemStack p_43553_, Collection<MobEffectInstance> p_43554_) {
        if (p_43554_.isEmpty()) {
            return p_43553_;
        }
        CompoundTag compoundTag = p_43553_.m_41784_();
        ListTag \u00e2\u02dc\u01922 = compoundTag.m_128437_(f_151254_, 9);
        for (MobEffectInstance mobEffectInstance : p_43554_) {
            \u00e2\u02dc\u01922.add(mobEffectInstance.m_19555_(new CompoundTag()));
        }
        compoundTag.m_128365_(f_151254_, \u00e2\u02dc\u01922);
        return p_43553_;
    }

    public static void m_43555_(ItemStack p_43556_, List<Component> p_43557_, float p_43558_) {
        Object object;
        List<MobEffectInstance> list = PotionUtils.m_43547_(p_43556_);
        ArrayList \u00e2\u02dc\u01922 = Lists.newArrayList();
        if (list.isEmpty()) {
            p_43557_.add(f_43545_);
        } else {
            for (MobEffectInstance mobEffectInstance2 : list) {
                MobEffectInstance mobEffectInstance2;
                object = new TranslatableComponent(mobEffectInstance2.m_19576_());
                MobEffect \u00e2\u02dc\u01923 = mobEffectInstance2.m_19544_();
                Map<Attribute, AttributeModifier> \u00e2\u02dc\u01924 = \u00e2\u02dc\u01923.m_19485_();
                if (!\u00e2\u02dc\u01924.isEmpty()) {
                    for (Map.Entry<Attribute, AttributeModifier> entry : \u00e2\u02dc\u01924.entrySet()) {
                        AttributeModifier attributeModifier = entry.getValue();
                        \u00e2\u02dc\u0192 = new AttributeModifier(attributeModifier.m_22214_(), \u00e2\u02dc\u01923.m_7048_(mobEffectInstance2.m_19564_(), attributeModifier), attributeModifier.m_22217_());
                        \u00e2\u02dc\u01922.add(new Pair((Object)entry.getKey(), (Object)\u00e2\u02dc\u0192));
                    }
                }
                if (mobEffectInstance2.m_19564_() > 0) {
                    object = new TranslatableComponent("potion.withAmplifier", object, new TranslatableComponent("potion.potency." + mobEffectInstance2.m_19564_()));
                }
                if (mobEffectInstance2.m_19557_() > 20) {
                    object = new TranslatableComponent("potion.withDuration", object, MobEffectUtil.m_19581_(mobEffectInstance2, p_43558_));
                }
                p_43557_.add(object.m_130940_(\u00e2\u02dc\u01923.m_19483_().m_19497_()));
            }
        }
        if (!\u00e2\u02dc\u01922.isEmpty()) {
            p_43557_.add(TextComponent.f_131282_);
            p_43557_.add(new TranslatableComponent("potion.whenDrank").m_130940_(ChatFormatting.DARK_PURPLE));
            for (MobEffectInstance mobEffectInstance2 : \u00e2\u02dc\u01922) {
                object = (AttributeModifier)mobEffectInstance2.getSecond();
                double \u00e2\u02dc\u01925 = ((AttributeModifier)object).m_22218_();
                double \u00e2\u02dc\u01926 = ((AttributeModifier)object).m_22217_() == AttributeModifier.Operation.MULTIPLY_BASE || ((AttributeModifier)object).m_22217_() == AttributeModifier.Operation.MULTIPLY_TOTAL ? ((AttributeModifier)object).m_22218_() * 100.0 : ((AttributeModifier)object).m_22218_();
                if (\u00e2\u02dc\u01925 > 0.0) {
                    p_43557_.add(new TranslatableComponent("attribute.modifier.plus." + ((AttributeModifier)object).m_22217_().m_22235_(), ItemStack.f_41584_.format(\u00e2\u02dc\u01926), new TranslatableComponent(((Attribute)mobEffectInstance2.getFirst()).m_22087_())).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                if (!(\u00e2\u02dc\u01925 < 0.0)) continue;
                p_43557_.add(new TranslatableComponent("attribute.modifier.take." + ((AttributeModifier)object).m_22217_().m_22235_(), ItemStack.f_41584_.format(\u00e2\u02dc\u01926 *= -1.0), new TranslatableComponent(((Attribute)mobEffectInstance2.getFirst()).m_22087_())).m_130940_(ChatFormatting.RED));
            }
        }
    }
}

