/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class ShapedRecipe
implements CraftingRecipe {
    final int f_44146_;
    final int f_44147_;
    final NonNullList<Ingredient> f_44148_;
    final ItemStack f_44149_;
    private final ResourceLocation f_44150_;
    final String f_44151_;

    public ShapedRecipe(ResourceLocation p_44153_, String p_44154_, int p_44155_, int p_44156_, NonNullList<Ingredient> p_44157_, ItemStack p_44158_) {
        this.f_44150_ = p_44153_;
        this.f_44151_ = p_44154_;
        this.f_44146_ = p_44155_;
        this.f_44147_ = p_44156_;
        this.f_44148_ = p_44157_;
        this.f_44149_ = p_44158_;
    }

    @Override
    public ResourceLocation m_6423_() {
        return this.f_44150_;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return RecipeSerializer.f_44076_;
    }

    @Override
    public String m_6076_() {
        return this.f_44151_;
    }

    @Override
    public ItemStack m_8043_() {
        return this.f_44149_;
    }

    @Override
    public NonNullList<Ingredient> m_7527_() {
        return this.f_44148_;
    }

    @Override
    public boolean m_8004_(int p_44161_, int p_44162_) {
        return p_44161_ >= this.f_44146_ && p_44162_ >= this.f_44147_;
    }

    @Override
    public boolean m_5818_(CraftingContainer p_44176_, Level p_44177_) {
        for (int i = 0; i <= p_44176_.m_39347_() - this.f_44146_; ++i) {
            for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 <= p_44176_.m_39346_() - this.f_44147_; ++\u00e2\u02dc\u0192) {
                if (this.m_44170_(p_44176_, i, \u00e2\u02dc\u0192, true)) {
                    return true;
                }
                if (!this.m_44170_(p_44176_, i, \u00e2\u02dc\u0192, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean m_44170_(CraftingContainer p_44171_, int p_44172_, int p_44173_, boolean p_44174_) {
        for (int i = 0; i < p_44171_.m_39347_(); ++i) {
            for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < p_44171_.m_39346_(); ++\u00e2\u02dc\u0192) {
                \u00e2\u02dc\u0192 = i - p_44172_;
                \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 - p_44173_;
                Ingredient ingredient = Ingredient.f_43901_;
                if (\u00e2\u02dc\u0192 >= 0 && \u00e2\u02dc\u0192 >= 0 && \u00e2\u02dc\u0192 < this.f_44146_ && \u00e2\u02dc\u0192 < this.f_44147_) {
                    ingredient = p_44174_ ? this.f_44148_.get(this.f_44146_ - \u00e2\u02dc\u0192 - 1 + \u00e2\u02dc\u0192 * this.f_44146_) : this.f_44148_.get(\u00e2\u02dc\u0192 + \u00e2\u02dc\u0192 * this.f_44146_);
                }
                if (ingredient.test(p_44171_.m_8020_(i + \u00e2\u02dc\u0192 * p_44171_.m_39347_()))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public ItemStack m_5874_(CraftingContainer p_44169_) {
        return this.m_8043_().m_41777_();
    }

    public int m_44220_() {
        return this.f_44146_;
    }

    public int m_44221_() {
        return this.f_44147_;
    }

    static NonNullList<Ingredient> m_44202_(String[] p_44203_, Map<String, Ingredient> p_44204_, int p_44205_, int p_44206_) {
        NonNullList<Ingredient> nonNullList = NonNullList.m_122780_(p_44205_ * p_44206_, Ingredient.f_43901_);
        HashSet \u00e2\u02dc\u01922 = Sets.newHashSet(p_44204_.keySet());
        \u00e2\u02dc\u01922.remove(" ");
        for (int i = 0; i < p_44203_.length; ++i) {
            for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < p_44203_[i].length(); ++\u00e2\u02dc\u0192) {
                String string = p_44203_[i].substring(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192 + 1);
                Ingredient \u00e2\u02dc\u01923 = p_44204_.get(string);
                if (\u00e2\u02dc\u01923 == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + string + "' but it's not defined in the key");
                }
                \u00e2\u02dc\u01922.remove(string);
                nonNullList.set(\u00e2\u02dc\u0192 + p_44205_ * i, \u00e2\u02dc\u01923);
            }
        }
        if (!\u00e2\u02dc\u01922.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + \u00e2\u02dc\u01922);
        }
        return nonNullList;
    }

    @VisibleForTesting
    static String[] m_44186_(String ... p_44187_) {
        int \u00e2\u02dc\u01925;
        int \u00e2\u02dc\u01924;
        int \u00e2\u02dc\u01922 = Integer.MAX_VALUE;
        \u00e2\u02dc\u01924 = 0;
        \u00e2\u02dc\u0192 = 0;
        \u00e2\u02dc\u01925 = 0;
        for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < p_44187_.length; ++\u00e2\u02dc\u0192) {
            String string = p_44187_[\u00e2\u02dc\u0192];
            \u00e2\u02dc\u01922 = Math.min(\u00e2\u02dc\u01922, ShapedRecipe.m_44184_(string));
            int \u00e2\u02dc\u01923 = ShapedRecipe.m_44200_(string);
            \u00e2\u02dc\u01924 = Math.max(\u00e2\u02dc\u01924, \u00e2\u02dc\u01923);
            if (\u00e2\u02dc\u01923 < 0) {
                if (\u00e2\u02dc\u0192 == \u00e2\u02dc\u0192) {
                    ++\u00e2\u02dc\u0192;
                }
                ++\u00e2\u02dc\u01925;
                continue;
            }
            \u00e2\u02dc\u01925 = 0;
        }
        if (p_44187_.length == \u00e2\u02dc\u01925) {
            return new String[0];
        }
        String[] stringArray = new String[p_44187_.length - \u00e2\u02dc\u01925 - \u00e2\u02dc\u0192];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = p_44187_[i + \u00e2\u02dc\u0192].substring(\u00e2\u02dc\u01922, \u00e2\u02dc\u01924 + 1);
        }
        return stringArray;
    }

    @Override
    public boolean m_142505_() {
        NonNullList<Ingredient> nonNullList = this.m_7527_();
        return nonNullList.isEmpty() || nonNullList.stream().filter(p_151277_ -> !p_151277_.m_43947_()).anyMatch(p_151273_ -> p_151273_.m_43908_().length == 0);
    }

    private static int m_44184_(String p_44185_) {
        int n;
        for (n = 0; n < p_44185_.length() && p_44185_.charAt(n) == ' '; ++n) {
        }
        return n;
    }

    private static int m_44200_(String p_44201_) {
        int n;
        for (n = p_44201_.length() - 1; n >= 0 && p_44201_.charAt(n) == ' '; --n) {
        }
        return n;
    }

    static String[] m_44196_(JsonArray p_44197_) {
        String[] stringArray = new String[p_44197_.size()];
        if (stringArray.length > 3) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, 3 is maximum");
        }
        if (stringArray.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = GsonHelper.m_13805_(p_44197_.get(i), "pattern[" + i + "]");
            if (string.length() > 3) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, 3 is maximum");
            }
            if (i > 0 && stringArray[0].length() != string.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            stringArray[i] = string;
        }
        return stringArray;
    }

    static Map<String, Ingredient> m_44210_(JsonObject p_44211_) {
        HashMap hashMap = Maps.newHashMap();
        for (Map.Entry entry : p_44211_.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            hashMap.put((String)entry.getKey(), Ingredient.m_43917_((JsonElement)entry.getValue()));
        }
        hashMap.put(" ", Ingredient.f_43901_);
        return hashMap;
    }

    public static ItemStack m_151274_(JsonObject p_151275_) {
        Item item = ShapedRecipe.m_151278_(p_151275_);
        if (p_151275_.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        int \u00e2\u02dc\u01922 = GsonHelper.m_13824_(p_151275_, "count", 1);
        if (\u00e2\u02dc\u01922 < 1) {
            throw new JsonSyntaxException("Invalid output count: " + \u00e2\u02dc\u01922);
        }
        return new ItemStack(item, \u00e2\u02dc\u01922);
    }

    public static Item m_151278_(JsonObject p_151279_) {
        String string = GsonHelper.m_13906_(p_151279_, "item");
        Item \u00e2\u02dc\u01922 = Registry.f_122827_.m_6612_(new ResourceLocation(string)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + string + "'"));
        if (\u00e2\u02dc\u01922 == Items.f_41852_) {
            throw new JsonSyntaxException("Invalid item: " + string);
        }
        return \u00e2\u02dc\u01922;
    }

    public static class Serializer
    implements RecipeSerializer<ShapedRecipe> {
        @Override
        public ShapedRecipe m_6729_(ResourceLocation p_44236_, JsonObject p_44237_) {
            String string = GsonHelper.m_13851_(p_44237_, "group", "");
            Map<String, Ingredient> \u00e2\u02dc\u01922 = ShapedRecipe.m_44210_(GsonHelper.m_13930_(p_44237_, "key"));
            String[] \u00e2\u02dc\u01923 = ShapedRecipe.m_44186_(ShapedRecipe.m_44196_(GsonHelper.m_13933_(p_44237_, "pattern")));
            int \u00e2\u02dc\u01924 = \u00e2\u02dc\u01923[0].length();
            int \u00e2\u02dc\u01925 = \u00e2\u02dc\u01923.length;
            NonNullList<Ingredient> \u00e2\u02dc\u01926 = ShapedRecipe.m_44202_(\u00e2\u02dc\u01923, \u00e2\u02dc\u01922, \u00e2\u02dc\u01924, \u00e2\u02dc\u01925);
            ItemStack \u00e2\u02dc\u01927 = ShapedRecipe.m_151274_(GsonHelper.m_13930_(p_44237_, "result"));
            return new ShapedRecipe(p_44236_, string, \u00e2\u02dc\u01924, \u00e2\u02dc\u01925, \u00e2\u02dc\u01926, \u00e2\u02dc\u01927);
        }

        @Override
        public ShapedRecipe m_8005_(ResourceLocation p_44239_, FriendlyByteBuf p_44240_) {
            int n = p_44240_.m_130242_();
            \u00e2\u02dc\u0192 = p_44240_.m_130242_();
            String \u00e2\u02dc\u01922 = p_44240_.m_130277_();
            NonNullList<Ingredient> \u00e2\u02dc\u01923 = NonNullList.m_122780_(n * \u00e2\u02dc\u0192, Ingredient.f_43901_);
            for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < \u00e2\u02dc\u01923.size(); ++\u00e2\u02dc\u0192) {
                \u00e2\u02dc\u01923.set(\u00e2\u02dc\u0192, Ingredient.m_43940_(p_44240_));
            }
            ItemStack \u00e2\u02dc\u01924 = p_44240_.m_130267_();
            return new ShapedRecipe(p_44239_, \u00e2\u02dc\u01922, n, \u00e2\u02dc\u0192, \u00e2\u02dc\u01923, \u00e2\u02dc\u01924);
        }

        @Override
        public void m_6178_(FriendlyByteBuf p_44227_, ShapedRecipe p_44228_) {
            p_44227_.m_130130_(p_44228_.f_44146_);
            p_44227_.m_130130_(p_44228_.f_44147_);
            p_44227_.m_130070_(p_44228_.f_44151_);
            for (Ingredient ingredient : p_44228_.f_44148_) {
                ingredient.m_43923_(p_44227_);
            }
            p_44227_.m_130055_(p_44228_.f_44149_);
        }

        @Override
        public /* synthetic */ Recipe m_8005_(ResourceLocation resourceLocation, FriendlyByteBuf friendlyByteBuf) {
            return this.m_8005_(resourceLocation, friendlyByteBuf);
        }

        @Override
        public /* synthetic */ Recipe m_6729_(ResourceLocation resourceLocation, JsonObject jsonObject) {
            return this.m_6729_(resourceLocation, jsonObject);
        }
    }
}

