/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.SweepingEdgeEnchantment;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;

public class EnchantmentHelper {
    private static final String f_182430_ = "id";
    private static final String f_182431_ = "lvl";

    public static CompoundTag m_182443_(@Nullable ResourceLocation p_182444_, int p_182445_) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128359_(f_182430_, String.valueOf(p_182444_));
        compoundTag.m_128376_(f_182431_, (short)p_182445_);
        return compoundTag;
    }

    public static void m_182440_(CompoundTag p_182441_, int p_182442_) {
        p_182441_.m_128376_(f_182431_, (short)p_182442_);
    }

    public static int m_182438_(CompoundTag p_182439_) {
        return Mth.m_14045_(p_182439_.m_128451_(f_182431_), 0, 255);
    }

    @Nullable
    public static ResourceLocation m_182446_(CompoundTag p_182447_) {
        return ResourceLocation.m_135820_(p_182447_.m_128461_(f_182430_));
    }

    @Nullable
    public static ResourceLocation m_182432_(Enchantment p_182433_) {
        return Registry.f_122825_.m_7981_(p_182433_);
    }

    public static int m_44843_(Enchantment p_44844_, ItemStack p_44845_) {
        if (p_44845_.m_41619_()) {
            return 0;
        }
        ResourceLocation resourceLocation = EnchantmentHelper.m_182432_(p_44844_);
        ListTag \u00e2\u02dc\u01922 = p_44845_.m_41785_();
        for (int i = 0; i < \u00e2\u02dc\u01922.size(); ++i) {
            CompoundTag compoundTag = \u00e2\u02dc\u01922.m_128728_(i);
            ResourceLocation \u00e2\u02dc\u01923 = EnchantmentHelper.m_182446_(compoundTag);
            if (\u00e2\u02dc\u01923 == null || !\u00e2\u02dc\u01923.equals(resourceLocation)) continue;
            return EnchantmentHelper.m_182438_(compoundTag);
        }
        return 0;
    }

    public static Map<Enchantment, Integer> m_44831_(ItemStack p_44832_) {
        ListTag listTag = p_44832_.m_150930_(Items.f_42690_) ? EnchantedBookItem.m_41163_(p_44832_) : p_44832_.m_41785_();
        return EnchantmentHelper.m_44882_(listTag);
    }

    public static Map<Enchantment, Integer> m_44882_(ListTag p_44883_) {
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
        for (int i = 0; i < p_44883_.size(); ++i) {
            CompoundTag compoundTag = p_44883_.m_128728_(i);
            Registry.f_122825_.m_6612_(EnchantmentHelper.m_182446_(compoundTag)).ifPresent(p_44871_ -> linkedHashMap.put(p_44871_, EnchantmentHelper.m_182438_(compoundTag)));
        }
        return linkedHashMap;
    }

    public static void m_44865_(Map<Enchantment, Integer> p_44866_, ItemStack p_44867_) {
        ListTag listTag = new ListTag();
        for (Map.Entry<Enchantment, Integer> entry : p_44866_.entrySet()) {
            Enchantment enchantment = entry.getKey();
            if (enchantment == null) continue;
            int \u00e2\u02dc\u01922 = entry.getValue();
            listTag.add(EnchantmentHelper.m_182443_(EnchantmentHelper.m_182432_(enchantment), \u00e2\u02dc\u01922));
            if (!p_44867_.m_150930_(Items.f_42690_)) continue;
            EnchantedBookItem.m_41153_(p_44867_, new EnchantmentInstance(enchantment, \u00e2\u02dc\u01922));
        }
        if (listTag.isEmpty()) {
            p_44867_.m_41749_("Enchantments");
        } else if (!p_44867_.m_150930_(Items.f_42690_)) {
            p_44867_.m_41700_("Enchantments", listTag);
        }
    }

    private static void m_44850_(EnchantmentVisitor p_44851_, ItemStack p_44852_) {
        if (p_44852_.m_41619_()) {
            return;
        }
        ListTag listTag = p_44852_.m_41785_();
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag compoundTag = listTag.m_128728_(i);
            Registry.f_122825_.m_6612_(EnchantmentHelper.m_182446_(compoundTag)).ifPresent(p_182437_ -> p_44851_.m_44944_((Enchantment)p_182437_, EnchantmentHelper.m_182438_(compoundTag)));
        }
    }

    private static void m_44853_(EnchantmentVisitor p_44854_, Iterable<ItemStack> p_44855_) {
        for (ItemStack itemStack : p_44855_) {
            EnchantmentHelper.m_44850_(p_44854_, itemStack);
        }
    }

    public static int m_44856_(Iterable<ItemStack> p_44857_, DamageSource p_44858_) {
        MutableInt mutableInt = new MutableInt();
        EnchantmentHelper.m_44853_((p_44892_, p_44893_) -> mutableInt.add(p_44892_.m_7205_(p_44893_, p_44858_)), p_44857_);
        return mutableInt.intValue();
    }

    public static float m_44833_(ItemStack p_44834_, MobType p_44835_) {
        MutableFloat mutableFloat = new MutableFloat();
        EnchantmentHelper.m_44850_((p_44887_, p_44888_) -> mutableFloat.add(p_44887_.m_7335_(p_44888_, p_44835_)), p_44834_);
        return mutableFloat.floatValue();
    }

    public static float m_44821_(LivingEntity p_44822_) {
        int n = EnchantmentHelper.m_44836_(Enchantments.f_44983_, p_44822_);
        if (n > 0) {
            return SweepingEdgeEnchantment.m_45193_(n);
        }
        return 0.0f;
    }

    public static void m_44823_(LivingEntity p_44824_, Entity p_44825_) {
        EnchantmentVisitor enchantmentVisitor = (p_44902_, p_44903_) -> p_44902_.m_7675_(p_44824_, p_44825_, p_44903_);
        if (p_44824_ != null) {
            EnchantmentHelper.m_44853_(enchantmentVisitor, p_44824_.m_20158_());
        }
        if (p_44825_ instanceof Player) {
            EnchantmentHelper.m_44850_(enchantmentVisitor, p_44824_.m_21205_());
        }
    }

    public static void m_44896_(LivingEntity p_44897_, Entity p_44898_) {
        EnchantmentVisitor enchantmentVisitor = (p_44829_, p_44830_) -> p_44829_.m_7677_(p_44897_, p_44898_, p_44830_);
        if (p_44897_ != null) {
            EnchantmentHelper.m_44853_(enchantmentVisitor, p_44897_.m_20158_());
        }
        if (p_44897_ instanceof Player) {
            EnchantmentHelper.m_44850_(enchantmentVisitor, p_44897_.m_21205_());
        }
    }

    public static int m_44836_(Enchantment p_44837_, LivingEntity p_44838_) {
        Collection<ItemStack> collection = p_44837_.m_44684_(p_44838_).values();
        if (collection == null) {
            return 0;
        }
        int \u00e2\u02dc\u01922 = 0;
        for (ItemStack itemStack : collection) {
            int n = EnchantmentHelper.m_44843_(p_44837_, itemStack);
            if (n <= \u00e2\u02dc\u01922) continue;
            \u00e2\u02dc\u01922 = n;
        }
        return \u00e2\u02dc\u01922;
    }

    public static int m_44894_(LivingEntity p_44895_) {
        return EnchantmentHelper.m_44836_(Enchantments.f_44980_, p_44895_);
    }

    public static int m_44914_(LivingEntity p_44915_) {
        return EnchantmentHelper.m_44836_(Enchantments.f_44981_, p_44915_);
    }

    public static int m_44918_(LivingEntity p_44919_) {
        return EnchantmentHelper.m_44836_(Enchantments.f_44970_, p_44919_);
    }

    public static int m_44922_(LivingEntity p_44923_) {
        return EnchantmentHelper.m_44836_(Enchantments.f_44973_, p_44923_);
    }

    public static int m_44926_(LivingEntity p_44927_) {
        return EnchantmentHelper.m_44836_(Enchantments.f_44984_, p_44927_);
    }

    public static int m_44904_(ItemStack p_44905_) {
        return EnchantmentHelper.m_44843_(Enchantments.f_44953_, p_44905_);
    }

    public static int m_44916_(ItemStack p_44917_) {
        return EnchantmentHelper.m_44843_(Enchantments.f_44954_, p_44917_);
    }

    public static int m_44930_(LivingEntity p_44931_) {
        return EnchantmentHelper.m_44836_(Enchantments.f_44982_, p_44931_);
    }

    public static boolean m_44934_(LivingEntity p_44935_) {
        return EnchantmentHelper.m_44836_(Enchantments.f_44971_, p_44935_) > 0;
    }

    public static boolean m_44938_(LivingEntity p_44939_) {
        return EnchantmentHelper.m_44836_(Enchantments.f_44974_, p_44939_) > 0;
    }

    public static boolean m_44942_(LivingEntity p_44943_) {
        return EnchantmentHelper.m_44836_(Enchantments.f_44976_, p_44943_) > 0;
    }

    public static boolean m_44920_(ItemStack p_44921_) {
        return EnchantmentHelper.m_44843_(Enchantments.f_44975_, p_44921_) > 0;
    }

    public static boolean m_44924_(ItemStack p_44925_) {
        return EnchantmentHelper.m_44843_(Enchantments.f_44963_, p_44925_) > 0;
    }

    public static int m_44928_(ItemStack p_44929_) {
        return EnchantmentHelper.m_44843_(Enchantments.f_44955_, p_44929_);
    }

    public static int m_44932_(ItemStack p_44933_) {
        return EnchantmentHelper.m_44843_(Enchantments.f_44957_, p_44933_);
    }

    public static boolean m_44936_(ItemStack p_44937_) {
        return EnchantmentHelper.m_44843_(Enchantments.f_44958_, p_44937_) > 0;
    }

    @Nullable
    public static Map.Entry<EquipmentSlot, ItemStack> m_44906_(Enchantment p_44907_, LivingEntity p_44908_) {
        return EnchantmentHelper.m_44839_(p_44907_, p_44908_, p_44941_ -> true);
    }

    @Nullable
    public static Map.Entry<EquipmentSlot, ItemStack> m_44839_(Enchantment p_44840_, LivingEntity p_44841_, Predicate<ItemStack> p_44842_) {
        Map<EquipmentSlot, ItemStack> map = p_44840_.m_44684_(p_44841_);
        if (map.isEmpty()) {
            return null;
        }
        ArrayList \u00e2\u02dc\u01922 = Lists.newArrayList();
        for (Map.Entry<EquipmentSlot, ItemStack> entry : map.entrySet()) {
            ItemStack itemStack = entry.getValue();
            if (itemStack.m_41619_() || EnchantmentHelper.m_44843_(p_44840_, itemStack) <= 0 || !p_44842_.test(itemStack)) continue;
            \u00e2\u02dc\u01922.add(entry);
        }
        return \u00e2\u02dc\u01922.isEmpty() ? null : (Map.Entry)\u00e2\u02dc\u01922.get(p_44841_.m_21187_().nextInt(\u00e2\u02dc\u01922.size()));
    }

    public static int m_44872_(Random p_44873_, int p_44874_, int p_44875_, ItemStack p_44876_) {
        Item item = p_44876_.m_41720_();
        int \u00e2\u02dc\u01922 = item.m_6473_();
        if (\u00e2\u02dc\u01922 <= 0) {
            return 0;
        }
        if (p_44875_ > 15) {
            p_44875_ = 15;
        }
        int \u00e2\u02dc\u01923 = p_44873_.nextInt(8) + 1 + (p_44875_ >> 1) + p_44873_.nextInt(p_44875_ + 1);
        if (p_44874_ == 0) {
            return Math.max(\u00e2\u02dc\u01923 / 3, 1);
        }
        if (p_44874_ == 1) {
            return \u00e2\u02dc\u01923 * 2 / 3 + 1;
        }
        return Math.max(\u00e2\u02dc\u01923, p_44875_ * 2);
    }

    public static ItemStack m_44877_(Random p_44878_, ItemStack p_44879_, int p_44880_, boolean p_44881_) {
        List<EnchantmentInstance> list = EnchantmentHelper.m_44909_(p_44878_, p_44879_, p_44880_, p_44881_);
        boolean \u00e2\u02dc\u01922 = p_44879_.m_150930_(Items.f_42517_);
        if (\u00e2\u02dc\u01922) {
            p_44879_ = new ItemStack(Items.f_42690_);
        }
        for (EnchantmentInstance enchantmentInstance : list) {
            if (\u00e2\u02dc\u01922) {
                EnchantedBookItem.m_41153_(p_44879_, enchantmentInstance);
                continue;
            }
            p_44879_.m_41663_(enchantmentInstance.f_44947_, enchantmentInstance.f_44948_);
        }
        return p_44879_;
    }

    public static List<EnchantmentInstance> m_44909_(Random p_44910_, ItemStack p_44911_, int p_44912_, boolean p_44913_) {
        ArrayList arrayList = Lists.newArrayList();
        Item \u00e2\u02dc\u01922 = p_44911_.m_41720_();
        int \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922.m_6473_();
        if (\u00e2\u02dc\u01923 <= 0) {
            return arrayList;
        }
        p_44912_ += 1 + p_44910_.nextInt(\u00e2\u02dc\u01923 / 4 + 1) + p_44910_.nextInt(\u00e2\u02dc\u01923 / 4 + 1);
        float \u00e2\u02dc\u01924 = (p_44910_.nextFloat() + p_44910_.nextFloat() - 1.0f) * 0.15f;
        List<EnchantmentInstance> \u00e2\u02dc\u01925 = EnchantmentHelper.m_44817_(p_44912_ = Mth.m_14045_(Math.round((float)p_44912_ + (float)p_44912_ * \u00e2\u02dc\u01924), 1, Integer.MAX_VALUE), p_44911_, p_44913_);
        if (!\u00e2\u02dc\u01925.isEmpty()) {
            WeightedRandom.m_146317_(p_44910_, \u00e2\u02dc\u01925).ifPresent(arrayList::add);
            while (p_44910_.nextInt(50) <= p_44912_) {
                if (!arrayList.isEmpty()) {
                    EnchantmentHelper.m_44862_(\u00e2\u02dc\u01925, (EnchantmentInstance)Util.m_137509_(arrayList));
                }
                if (\u00e2\u02dc\u01925.isEmpty()) break;
                WeightedRandom.m_146317_(p_44910_, \u00e2\u02dc\u01925).ifPresent(arrayList::add);
                p_44912_ /= 2;
            }
        }
        return arrayList;
    }

    public static void m_44862_(List<EnchantmentInstance> p_44863_, EnchantmentInstance p_44864_) {
        Iterator<EnchantmentInstance> iterator = p_44863_.iterator();
        while (iterator.hasNext()) {
            if (p_44864_.f_44947_.m_44695_(iterator.next().f_44947_)) continue;
            iterator.remove();
        }
    }

    public static boolean m_44859_(Collection<Enchantment> p_44860_, Enchantment p_44861_) {
        for (Enchantment enchantment : p_44860_) {
            if (enchantment.m_44695_(p_44861_)) continue;
            return false;
        }
        return true;
    }

    public static List<EnchantmentInstance> m_44817_(int p_44818_, ItemStack p_44819_, boolean p_44820_) {
        ArrayList arrayList = Lists.newArrayList();
        Item \u00e2\u02dc\u01922 = p_44819_.m_41720_();
        boolean \u00e2\u02dc\u01923 = p_44819_.m_150930_(Items.f_42517_);
        block0: for (Enchantment enchantment : Registry.f_122825_) {
            if (enchantment.m_6591_() && !p_44820_ || !enchantment.m_6592_() || !enchantment.f_44672_.m_7454_(\u00e2\u02dc\u01922) && !\u00e2\u02dc\u01923) continue;
            for (int i = enchantment.m_6586_(); i > enchantment.m_44702_() - 1; --i) {
                if (p_44818_ < enchantment.m_6183_(i) || p_44818_ > enchantment.m_6175_(i)) continue;
                arrayList.add(new EnchantmentInstance(enchantment, i));
                continue block0;
            }
        }
        return arrayList;
    }

    @FunctionalInterface
    static interface EnchantmentVisitor {
        public void m_44944_(Enchantment var1, int var2);
    }
}

