/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ClipBlockStateContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface BlockGetter
extends LevelHeightAccessor {
    @Nullable
    public BlockEntity m_7702_(BlockPos var1);

    default public <T extends BlockEntity> Optional<T> m_141902_(BlockPos p_151367_, BlockEntityType<T> p_151368_) {
        BlockEntity blockEntity = this.m_7702_(p_151367_);
        if (blockEntity == null || blockEntity.m_58903_() != p_151368_) {
            return Optional.empty();
        }
        return Optional.of(blockEntity);
    }

    public BlockState m_8055_(BlockPos var1);

    public FluidState m_6425_(BlockPos var1);

    default public int m_7146_(BlockPos p_45572_) {
        return this.m_8055_(p_45572_).m_60791_();
    }

    default public int m_7469_() {
        return 15;
    }

    default public Stream<BlockState> m_45556_(AABB p_45557_) {
        return BlockPos.m_121921_(p_45557_).map(this::m_8055_);
    }

    default public BlockHitResult m_151353_(ClipBlockStateContext p_151354_) {
        return BlockGetter.m_151361_(p_151354_.m_151405_(), p_151354_.m_151404_(), p_151354_, (p_151356_, p_151357_) -> {
            BlockState blockState = this.m_8055_((BlockPos)p_151357_);
            Vec3 \u00e2\u02dc\u01922 = p_151356_.m_151405_().m_82546_(p_151356_.m_151404_());
            return p_151356_.m_151406_().test(blockState) ? new BlockHitResult(p_151356_.m_151404_(), Direction.m_122366_(\u00e2\u02dc\u01922.f_82479_, \u00e2\u02dc\u01922.f_82480_, \u00e2\u02dc\u01922.f_82481_), new BlockPos(p_151356_.m_151404_()), false) : null;
        }, p_151370_ -> {
            Vec3 vec3 = p_151370_.m_151405_().m_82546_(p_151370_.m_151404_());
            return BlockHitResult.m_82426_(p_151370_.m_151404_(), Direction.m_122366_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_), new BlockPos(p_151370_.m_151404_()));
        });
    }

    default public BlockHitResult m_45547_(ClipContext p_45548_) {
        return BlockGetter.m_151361_(p_45548_.m_45702_(), p_45548_.m_45693_(), p_45548_, (p_151359_, p_151360_) -> {
            BlockState blockState = this.m_8055_((BlockPos)p_151360_);
            FluidState \u00e2\u02dc\u01922 = this.m_6425_((BlockPos)p_151360_);
            Vec3 \u00e2\u02dc\u01923 = p_151359_.m_45702_();
            Vec3 \u00e2\u02dc\u01924 = p_151359_.m_45693_();
            VoxelShape \u00e2\u02dc\u01925 = p_151359_.m_45694_(blockState, this, (BlockPos)p_151360_);
            BlockHitResult \u00e2\u02dc\u01926 = this.m_45558_(\u00e2\u02dc\u01923, \u00e2\u02dc\u01924, (BlockPos)p_151360_, \u00e2\u02dc\u01925, blockState);
            VoxelShape \u00e2\u02dc\u01927 = p_151359_.m_45698_(\u00e2\u02dc\u01922, this, (BlockPos)p_151360_);
            BlockHitResult \u00e2\u02dc\u01928 = \u00e2\u02dc\u01927.m_83220_(\u00e2\u02dc\u01923, \u00e2\u02dc\u01924, (BlockPos)p_151360_);
            double \u00e2\u02dc\u01929 = \u00e2\u02dc\u01926 == null ? Double.MAX_VALUE : p_151359_.m_45702_().m_82557_(\u00e2\u02dc\u01926.m_82450_());
            double \u00e2\u02dc\u019210 = \u00e2\u02dc\u01928 == null ? Double.MAX_VALUE : p_151359_.m_45702_().m_82557_(\u00e2\u02dc\u01928.m_82450_());
            return \u00e2\u02dc\u01929 <= \u00e2\u02dc\u019210 ? \u00e2\u02dc\u01926 : \u00e2\u02dc\u01928;
        }, p_151372_ -> {
            Vec3 vec3 = p_151372_.m_45702_().m_82546_(p_151372_.m_45693_());
            return BlockHitResult.m_82426_(p_151372_.m_45693_(), Direction.m_122366_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_), new BlockPos(p_151372_.m_45693_()));
        });
    }

    @Nullable
    default public BlockHitResult m_45558_(Vec3 p_45559_, Vec3 p_45560_, BlockPos p_45561_, VoxelShape p_45562_, BlockState p_45563_) {
        BlockHitResult blockHitResult = p_45562_.m_83220_(p_45559_, p_45560_, p_45561_);
        if (blockHitResult != null && (\u00e2\u02dc\u0192 = p_45563_.m_60820_(this, p_45561_).m_83220_(p_45559_, p_45560_, p_45561_)) != null && \u00e2\u02dc\u0192.m_82450_().m_82546_(p_45559_).m_82556_() < blockHitResult.m_82450_().m_82546_(p_45559_).m_82556_()) {
            return blockHitResult.m_82432_(\u00e2\u02dc\u0192.m_82434_());
        }
        return blockHitResult;
    }

    default public double m_45564_(VoxelShape p_45565_, Supplier<VoxelShape> p_45566_) {
        if (!p_45565_.m_83281_()) {
            return p_45565_.m_83297_(Direction.Axis.Y);
        }
        double d = p_45566_.get().m_83297_(Direction.Axis.Y);
        if (d >= 1.0) {
            return d - 1.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    default public double m_45573_(BlockPos p_45574_) {
        return this.m_45564_(this.m_8055_(p_45574_).m_60812_(this, p_45574_), () -> {
            BlockPos blockPos = p_45574_.m_7495_();
            return this.m_8055_(blockPos).m_60812_(this, blockPos);
        });
    }

    public static <T, C> T m_151361_(Vec3 p_151362_, Vec3 p_151363_, C p_151364_, BiFunction<C, BlockPos, T> p_151365_, Function<C, T> p_151366_) {
        if (p_151362_.equals(p_151363_)) {
            return p_151366_.apply(p_151364_);
        }
        double d = Mth.m_14139_(-1.0E-7, p_151363_.f_82479_, p_151362_.f_82479_);
        \u00e2\u02dc\u0192 = Mth.m_14139_(-1.0E-7, p_151363_.f_82480_, p_151362_.f_82480_);
        \u00e2\u02dc\u0192 = Mth.m_14139_(-1.0E-7, p_151363_.f_82481_, p_151362_.f_82481_);
        \u00e2\u02dc\u0192 = Mth.m_14139_(-1.0E-7, p_151362_.f_82479_, p_151363_.f_82479_);
        \u00e2\u02dc\u0192 = Mth.m_14139_(-1.0E-7, p_151362_.f_82480_, p_151363_.f_82480_);
        \u00e2\u02dc\u0192 = Mth.m_14139_(-1.0E-7, p_151362_.f_82481_, p_151363_.f_82481_);
        int \u00e2\u02dc\u01922 = Mth.m_14107_(\u00e2\u02dc\u0192);
        BlockPos.MutableBlockPos \u00e2\u02dc\u01923 = new BlockPos.MutableBlockPos(\u00e2\u02dc\u01922, \u00e2\u02dc\u0192 = Mth.m_14107_(\u00e2\u02dc\u0192), \u00e2\u02dc\u0192 = Mth.m_14107_(\u00e2\u02dc\u0192));
        T \u00e2\u02dc\u01924 = p_151365_.apply(p_151364_, \u00e2\u02dc\u01923);
        if (\u00e2\u02dc\u01924 != null) {
            return \u00e2\u02dc\u01924;
        }
        \u00e2\u02dc\u0192 = d - \u00e2\u02dc\u0192;
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 - \u00e2\u02dc\u0192;
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 - \u00e2\u02dc\u0192;
        int \u00e2\u02dc\u01925 = Mth.m_14205_(\u00e2\u02dc\u0192);
        int \u00e2\u02dc\u01926 = Mth.m_14205_(\u00e2\u02dc\u0192);
        int \u00e2\u02dc\u01927 = Mth.m_14205_(\u00e2\u02dc\u0192);
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u01925 == 0 ? Double.MAX_VALUE : (double)\u00e2\u02dc\u01925 / \u00e2\u02dc\u0192;
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u01926 == 0 ? Double.MAX_VALUE : (double)\u00e2\u02dc\u01926 / \u00e2\u02dc\u0192;
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u01927 == 0 ? Double.MAX_VALUE : (double)\u00e2\u02dc\u01927 / \u00e2\u02dc\u0192;
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 * (\u00e2\u02dc\u01925 > 0 ? 1.0 - Mth.m_14185_(\u00e2\u02dc\u0192) : Mth.m_14185_(\u00e2\u02dc\u0192));
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 * (\u00e2\u02dc\u01926 > 0 ? 1.0 - Mth.m_14185_(\u00e2\u02dc\u0192) : Mth.m_14185_(\u00e2\u02dc\u0192));
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 * (\u00e2\u02dc\u01927 > 0 ? 1.0 - Mth.m_14185_(\u00e2\u02dc\u0192) : Mth.m_14185_(\u00e2\u02dc\u0192));
        while (\u00e2\u02dc\u0192 <= 1.0 || \u00e2\u02dc\u0192 <= 1.0 || \u00e2\u02dc\u0192 <= 1.0) {
            if (\u00e2\u02dc\u0192 < \u00e2\u02dc\u0192) {
                if (\u00e2\u02dc\u0192 < \u00e2\u02dc\u0192) {
                    \u00e2\u02dc\u01922 += \u00e2\u02dc\u01925;
                    \u00e2\u02dc\u0192 += \u00e2\u02dc\u0192;
                } else {
                    \u00e2\u02dc\u0192 += \u00e2\u02dc\u01927;
                    \u00e2\u02dc\u0192 += \u00e2\u02dc\u0192;
                }
            } else if (\u00e2\u02dc\u0192 < \u00e2\u02dc\u0192) {
                \u00e2\u02dc\u0192 += \u00e2\u02dc\u01926;
                \u00e2\u02dc\u0192 += \u00e2\u02dc\u0192;
            } else {
                \u00e2\u02dc\u0192 += \u00e2\u02dc\u01927;
                \u00e2\u02dc\u0192 += \u00e2\u02dc\u0192;
            }
            if ((\u00e2\u02dc\u0192 = p_151365_.apply(p_151364_, \u00e2\u02dc\u01923.m_122178_(\u00e2\u02dc\u01922, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192))) == null) continue;
            return \u00e2\u02dc\u0192;
        }
        return p_151366_.apply(p_151364_);
    }
}

