/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface EntityGetter {
    public List<Entity> m_6249_(@Nullable Entity var1, AABB var2, Predicate<? super Entity> var3);

    public <T extends Entity> List<T> m_142425_(EntityTypeTest<Entity, T> var1, AABB var2, Predicate<? super T> var3);

    default public <T extends Entity> List<T> m_6443_(Class<T> p_45979_, AABB p_45980_, Predicate<? super T> p_45981_) {
        return this.m_142425_(EntityTypeTest.m_156916_(p_45979_), p_45980_, p_45981_);
    }

    public List<? extends Player> m_6907_();

    default public List<Entity> m_45933_(@Nullable Entity p_45934_, AABB p_45935_) {
        return this.m_6249_(p_45934_, p_45935_, EntitySelector.f_20408_);
    }

    default public boolean m_5450_(@Nullable Entity p_45939_, VoxelShape p_45940_) {
        if (p_45940_.m_83281_()) {
            return true;
        }
        for (Entity entity : this.m_45933_(p_45939_, p_45940_.m_83215_())) {
            if (entity.m_146910_() || !entity.f_19850_ || p_45939_ != null && entity.m_20365_(p_45939_) || !Shapes.m_83157_(p_45940_, Shapes.m_83064_(entity.m_142469_()), BooleanOp.f_82689_)) continue;
            return false;
        }
        return true;
    }

    default public <T extends Entity> List<T> m_45976_(Class<T> p_45977_, AABB p_45978_) {
        return this.m_6443_(p_45977_, p_45978_, EntitySelector.f_20408_);
    }

    default public Stream<VoxelShape> m_5454_(@Nullable Entity p_46005_, AABB p_46006_, Predicate<Entity> p_46007_) {
        if (p_46006_.m_82309_() < 1.0E-7) {
            return Stream.empty();
        }
        AABB aABB = p_46006_.m_82400_(1.0E-7);
        return this.m_6249_(p_46005_, aABB, p_46007_.and(p_45962_ -> p_45962_.m_142469_().m_82381_(aABB) && (p_46005_ == null ? p_45962_.m_5829_() : p_46005_.m_7337_((Entity)p_45962_)))).stream().map(Entity::m_142469_).map(Shapes::m_83064_);
    }

    @Nullable
    default public Player m_5788_(double p_45919_, double p_45920_, double p_45921_, double p_45922_, @Nullable Predicate<Entity> p_45923_) {
        double d = -1.0;
        Player \u00e2\u02dc\u01922 = null;
        for (Player player : this.m_6907_()) {
            if (p_45923_ != null && !p_45923_.test(player)) continue;
            double d2 = player.m_20275_(p_45919_, p_45920_, p_45921_);
            if (!(p_45922_ < 0.0) && !(d2 < p_45922_ * p_45922_) || d != -1.0 && !(d2 < d)) continue;
            d = d2;
            \u00e2\u02dc\u01922 = player;
        }
        return \u00e2\u02dc\u01922;
    }

    @Nullable
    default public Player m_45930_(Entity p_45931_, double p_45932_) {
        return this.m_45924_(p_45931_.m_20185_(), p_45931_.m_20186_(), p_45931_.m_20189_(), p_45932_, false);
    }

    @Nullable
    default public Player m_45924_(double p_45925_, double p_45926_, double p_45927_, double p_45928_, boolean p_45929_) {
        Predicate<Entity> predicate = p_45929_ ? EntitySelector.f_20406_ : EntitySelector.f_20408_;
        return this.m_5788_(p_45925_, p_45926_, p_45927_, p_45928_, predicate);
    }

    default public boolean m_45914_(double p_45915_, double p_45916_, double p_45917_, double p_45918_) {
        for (Player player : this.m_6907_()) {
            if (!EntitySelector.f_20408_.test(player) || !EntitySelector.f_20403_.test(player)) continue;
            double d = player.m_20275_(p_45915_, p_45916_, p_45917_);
            if (!(p_45918_ < 0.0) && !(d < p_45918_ * p_45918_)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    default public Player m_45946_(TargetingConditions p_45947_, LivingEntity p_45948_) {
        return this.m_45982_(this.m_6907_(), p_45947_, p_45948_, p_45948_.m_20185_(), p_45948_.m_20186_(), p_45948_.m_20189_());
    }

    @Nullable
    default public Player m_45949_(TargetingConditions p_45950_, LivingEntity p_45951_, double p_45952_, double p_45953_, double p_45954_) {
        return this.m_45982_(this.m_6907_(), p_45950_, p_45951_, p_45952_, p_45953_, p_45954_);
    }

    @Nullable
    default public Player m_45941_(TargetingConditions p_45942_, double p_45943_, double p_45944_, double p_45945_) {
        return this.m_45982_(this.m_6907_(), p_45942_, null, p_45943_, p_45944_, p_45945_);
    }

    @Nullable
    default public <T extends LivingEntity> T m_45963_(Class<? extends T> p_45964_, TargetingConditions p_45965_, @Nullable LivingEntity p_45966_, double p_45967_, double p_45968_, double p_45969_, AABB p_45970_) {
        return (T)this.m_45982_(this.m_6443_(p_45964_, p_45970_, p_151468_ -> true), p_45965_, p_45966_, p_45967_, p_45968_, p_45969_);
    }

    @Nullable
    default public <T extends LivingEntity> T m_45982_(List<? extends T> p_45983_, TargetingConditions p_45984_, @Nullable LivingEntity p_45985_, double p_45986_, double p_45987_, double p_45988_) {
        double d = -1.0;
        LivingEntity \u00e2\u02dc\u01922 = null;
        for (LivingEntity livingEntity : p_45983_) {
            if (!p_45984_.m_26885_(p_45985_, livingEntity)) continue;
            double d2 = livingEntity.m_20275_(p_45986_, p_45987_, p_45988_);
            if (d != -1.0 && !(d2 < d)) continue;
            d = d2;
            \u00e2\u02dc\u01922 = livingEntity;
        }
        return (T)\u00e2\u02dc\u01922;
    }

    default public List<Player> m_45955_(TargetingConditions p_45956_, LivingEntity p_45957_, AABB p_45958_) {
        ArrayList arrayList = Lists.newArrayList();
        for (Player player : this.m_6907_()) {
            if (!p_45958_.m_82393_(player.m_20185_(), player.m_20186_(), player.m_20189_()) || !p_45956_.m_26885_(p_45957_, player)) continue;
            arrayList.add(player);
        }
        return arrayList;
    }

    default public <T extends LivingEntity> List<T> m_45971_(Class<T> p_45972_, TargetingConditions p_45973_, LivingEntity p_45974_, AABB p_45975_) {
        List<LivingEntity> list = this.m_6443_(p_45972_, p_45975_, p_151463_ -> true);
        ArrayList \u00e2\u02dc\u01922 = Lists.newArrayList();
        for (LivingEntity livingEntity : list) {
            if (!p_45973_.m_26885_(p_45974_, livingEntity)) continue;
            \u00e2\u02dc\u01922.add(livingEntity);
        }
        return \u00e2\u02dc\u01922;
    }

    @Nullable
    default public Player m_46003_(UUID p_46004_) {
        for (int i = 0; i < this.m_6907_().size(); ++i) {
            Player player = this.m_6907_().get(i);
            if (!p_46004_.equals(player.m_142081_())) continue;
            return player;
        }
        return null;
    }
}

