/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.EntityBasedExplosionDamageCalculator;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class Explosion {
    private static final ExplosionDamageCalculator f_46008_ = new ExplosionDamageCalculator();
    private static final int f_151469_ = 16;
    private final boolean f_46009_;
    private final BlockInteraction f_46010_;
    private final Random f_46011_ = new Random();
    private final Level f_46012_;
    private final double f_46013_;
    private final double f_46014_;
    private final double f_46015_;
    @Nullable
    private final Entity f_46016_;
    private final float f_46017_;
    private final DamageSource f_46018_;
    private final ExplosionDamageCalculator f_46019_;
    private final List<BlockPos> f_46020_ = Lists.newArrayList();
    private final Map<Player, Vec3> f_46021_ = Maps.newHashMap();

    public Explosion(Level p_151471_, @Nullable Entity p_151472_, double p_151473_, double p_151474_, double p_151475_, float p_151476_) {
        this(p_151471_, p_151472_, p_151473_, p_151474_, p_151475_, p_151476_, false, BlockInteraction.DESTROY);
    }

    public Explosion(Level p_46024_, @Nullable Entity p_46025_, double p_46026_, double p_46027_, double p_46028_, float p_46029_, List<BlockPos> p_46030_) {
        this(p_46024_, p_46025_, p_46026_, p_46027_, p_46028_, p_46029_, false, BlockInteraction.DESTROY, p_46030_);
    }

    public Explosion(Level p_46041_, @Nullable Entity p_46042_, double p_46043_, double p_46044_, double p_46045_, float p_46046_, boolean p_46047_, BlockInteraction p_46048_, List<BlockPos> p_46049_) {
        this(p_46041_, p_46042_, p_46043_, p_46044_, p_46045_, p_46046_, p_46047_, p_46048_);
        this.f_46020_.addAll(p_46049_);
    }

    public Explosion(Level p_46032_, @Nullable Entity p_46033_, double p_46034_, double p_46035_, double p_46036_, float p_46037_, boolean p_46038_, BlockInteraction p_46039_) {
        this(p_46032_, p_46033_, null, null, p_46034_, p_46035_, p_46036_, p_46037_, p_46038_, p_46039_);
    }

    public Explosion(Level p_46051_, @Nullable Entity p_46052_, @Nullable DamageSource p_46053_, @Nullable ExplosionDamageCalculator p_46054_, double p_46055_, double p_46056_, double p_46057_, float p_46058_, boolean p_46059_, BlockInteraction p_46060_) {
        this.f_46012_ = p_46051_;
        this.f_46016_ = p_46052_;
        this.f_46017_ = p_46058_;
        this.f_46013_ = p_46055_;
        this.f_46014_ = p_46056_;
        this.f_46015_ = p_46057_;
        this.f_46009_ = p_46059_;
        this.f_46010_ = p_46060_;
        this.f_46018_ = p_46053_ == null ? DamageSource.m_19358_(this) : p_46053_;
        this.f_46019_ = p_46054_ == null ? this.m_46062_(p_46052_) : p_46054_;
    }

    private ExplosionDamageCalculator m_46062_(@Nullable Entity p_46063_) {
        return p_46063_ == null ? f_46008_ : new EntityBasedExplosionDamageCalculator(p_46063_);
    }

    public static float m_46064_(Vec3 p_46065_, Entity p_46066_) {
        AABB aABB = p_46066_.m_142469_();
        double \u00e2\u02dc\u01922 = 1.0 / ((aABB.f_82291_ - aABB.f_82288_) * 2.0 + 1.0);
        double \u00e2\u02dc\u01923 = 1.0 / ((aABB.f_82292_ - aABB.f_82289_) * 2.0 + 1.0);
        double \u00e2\u02dc\u01924 = 1.0 / ((aABB.f_82293_ - aABB.f_82290_) * 2.0 + 1.0);
        double \u00e2\u02dc\u01925 = (1.0 - Math.floor(1.0 / \u00e2\u02dc\u01922) * \u00e2\u02dc\u01922) / 2.0;
        double \u00e2\u02dc\u01926 = (1.0 - Math.floor(1.0 / \u00e2\u02dc\u01924) * \u00e2\u02dc\u01924) / 2.0;
        if (\u00e2\u02dc\u01922 < 0.0 || \u00e2\u02dc\u01923 < 0.0 || \u00e2\u02dc\u01924 < 0.0) {
            return 0.0f;
        }
        int \u00e2\u02dc\u01927 = 0;
        int \u00e2\u02dc\u01928 = 0;
        float \u00e2\u02dc\u01929 = 0.0f;
        while (\u00e2\u02dc\u01929 <= 1.0f) {
            float f = 0.0f;
            while (f <= 1.0f) {
                \u00e2\u02dc\u019211 = 0.0f;
                while (\u00e2\u02dc\u019211 <= 1.0f) {
                    double d = Mth.m_14139_(\u00e2\u02dc\u01929, aABB.f_82288_, aABB.f_82291_);
                    Vec3 \u00e2\u02dc\u019210 = new Vec3(d + \u00e2\u02dc\u01925, \u00e2\u02dc\u0192 = Mth.m_14139_(f, aABB.f_82289_, aABB.f_82292_), (\u00e2\u02dc\u0192 = Mth.m_14139_(\u00e2\u02dc\u019211, aABB.f_82290_, aABB.f_82293_)) + \u00e2\u02dc\u01926);
                    if (p_46066_.f_19853_.m_45547_(new ClipContext(\u00e2\u02dc\u019210, p_46065_, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, p_46066_)).m_6662_() == HitResult.Type.MISS) {
                        ++\u00e2\u02dc\u01927;
                    }
                    ++\u00e2\u02dc\u01928;
                    float \u00e2\u02dc\u019211 = (float)((double)\u00e2\u02dc\u019211 + \u00e2\u02dc\u01924);
                }
                f = (float)((double)f + \u00e2\u02dc\u01923);
            }
            \u00e2\u02dc\u01929 = (float)((double)\u00e2\u02dc\u01929 + \u00e2\u02dc\u01922);
        }
        return (float)\u00e2\u02dc\u01927 / (float)\u00e2\u02dc\u01928;
    }

    public void m_46061_() {
        this.f_46012_.m_142346_(this.f_46016_, GameEvent.f_157812_, new BlockPos(this.f_46013_, this.f_46014_, this.f_46015_));
        HashSet hashSet = Sets.newHashSet();
        int \u00e2\u02dc\u01922 = 16;
        for (int i = 0; i < 16; ++i) {
            for (\u00e2\u02dc\u01927 = 0; \u00e2\u02dc\u01927 < 16; ++\u00e2\u02dc\u01927) {
                block2: for (\u00e2\u02dc\u01928 = 0; \u00e2\u02dc\u01928 < 16; ++\u00e2\u02dc\u01928) {
                    if (i != 0 && i != 15 && \u00e2\u02dc\u01927 != 0 && \u00e2\u02dc\u01927 != 15 && \u00e2\u02dc\u01928 != 0 && \u00e2\u02dc\u01928 != 15) continue;
                    double d = (float)i / 15.0f * 2.0f - 1.0f;
                    \u00e2\u02dc\u0192 = (float)\u00e2\u02dc\u01927 / 15.0f * 2.0f - 1.0f;
                    \u00e2\u02dc\u0192 = (float)\u00e2\u02dc\u01928 / 15.0f * 2.0f - 1.0f;
                    \u00e2\u02dc\u0192 = Math.sqrt(d * d + \u00e2\u02dc\u0192 * \u00e2\u02dc\u0192 + \u00e2\u02dc\u0192 * \u00e2\u02dc\u0192);
                    d /= \u00e2\u02dc\u0192;
                    \u00e2\u02dc\u0192 /= \u00e2\u02dc\u0192;
                    \u00e2\u02dc\u0192 /= \u00e2\u02dc\u0192;
                    \u00e2\u02dc\u0192 = this.f_46013_;
                    \u00e2\u02dc\u0192 = this.f_46014_;
                    \u00e2\u02dc\u0192 = this.f_46015_;
                    float \u00e2\u02dc\u01923 = 0.3f;
                    for (float f = this.f_46017_ * (0.7f + this.f_46012_.f_46441_.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockPos = new BlockPos(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
                        BlockState \u00e2\u02dc\u01924 = this.f_46012_.m_8055_(blockPos);
                        FluidState \u00e2\u02dc\u01925 = this.f_46012_.m_6425_(blockPos);
                        if (!this.f_46012_.m_46739_(blockPos)) continue block2;
                        Optional<Float> \u00e2\u02dc\u01926 = this.f_46019_.m_6617_(this, this.f_46012_, blockPos, \u00e2\u02dc\u01924, \u00e2\u02dc\u01925);
                        if (\u00e2\u02dc\u01926.isPresent()) {
                            f -= (\u00e2\u02dc\u01926.get().floatValue() + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && this.f_46019_.m_6714_(this, this.f_46012_, blockPos, \u00e2\u02dc\u01924, f)) {
                            hashSet.add(blockPos);
                        }
                        \u00e2\u02dc\u0192 += d * (double)0.3f;
                        \u00e2\u02dc\u0192 += \u00e2\u02dc\u0192 * (double)0.3f;
                        \u00e2\u02dc\u0192 += \u00e2\u02dc\u0192 * (double)0.3f;
                    }
                }
            }
        }
        this.f_46020_.addAll(hashSet);
        float f = this.f_46017_ * 2.0f;
        int \u00e2\u02dc\u01927 = Mth.m_14107_(this.f_46013_ - (double)f - 1.0);
        int \u00e2\u02dc\u01928 = Mth.m_14107_(this.f_46013_ + (double)f + 1.0);
        int \u00e2\u02dc\u01929 = Mth.m_14107_(this.f_46014_ - (double)f - 1.0);
        int \u00e2\u02dc\u019210 = Mth.m_14107_(this.f_46014_ + (double)f + 1.0);
        int \u00e2\u02dc\u019211 = Mth.m_14107_(this.f_46015_ - (double)f - 1.0);
        int \u00e2\u02dc\u019212 = Mth.m_14107_(this.f_46015_ + (double)f + 1.0);
        List<Entity> \u00e2\u02dc\u019213 = this.f_46012_.m_45933_(this.f_46016_, new AABB(\u00e2\u02dc\u01927, \u00e2\u02dc\u01929, \u00e2\u02dc\u019211, \u00e2\u02dc\u01928, \u00e2\u02dc\u019210, \u00e2\u02dc\u019212));
        Vec3 \u00e2\u02dc\u019214 = new Vec3(this.f_46013_, this.f_46014_, this.f_46015_);
        for (int i = 0; i < \u00e2\u02dc\u019213.size(); ++i) {
            Entity entity = \u00e2\u02dc\u019213.get(i);
            if (entity.m_6128_() || !((\u00e2\u02dc\u0192 = Math.sqrt(entity.m_20238_(\u00e2\u02dc\u019214)) / (double)f) <= 1.0) || (\u00e2\u02dc\u0192 = Math.sqrt((\u00e2\u02dc\u0192 = entity.m_20185_() - this.f_46013_) * \u00e2\u02dc\u0192 + (\u00e2\u02dc\u0192 = (entity instanceof PrimedTnt ? entity.m_20186_() : entity.m_20188_()) - this.f_46014_) * \u00e2\u02dc\u0192 + (\u00e2\u02dc\u0192 = entity.m_20189_() - this.f_46015_) * \u00e2\u02dc\u0192)) == 0.0) continue;
            \u00e2\u02dc\u0192 /= \u00e2\u02dc\u0192;
            \u00e2\u02dc\u0192 /= \u00e2\u02dc\u0192;
            \u00e2\u02dc\u0192 /= \u00e2\u02dc\u0192;
            double \u00e2\u02dc\u019215 = Explosion.m_46064_(\u00e2\u02dc\u019214, entity);
            double \u00e2\u02dc\u019216 = (1.0 - \u00e2\u02dc\u0192) * \u00e2\u02dc\u019215;
            entity.m_6469_(this.m_46077_(), (int)((\u00e2\u02dc\u019216 * \u00e2\u02dc\u019216 + \u00e2\u02dc\u019216) / 2.0 * 7.0 * (double)f + 1.0));
            double \u00e2\u02dc\u019217 = \u00e2\u02dc\u019216;
            if (entity instanceof LivingEntity) {
                \u00e2\u02dc\u019217 = ProtectionEnchantment.m_45135_((LivingEntity)entity, \u00e2\u02dc\u019216);
            }
            entity.m_20256_(entity.m_20184_().m_82520_(\u00e2\u02dc\u0192 * \u00e2\u02dc\u019217, \u00e2\u02dc\u0192 * \u00e2\u02dc\u019217, \u00e2\u02dc\u0192 * \u00e2\u02dc\u019217));
            if (!(entity instanceof Player) || (\u00e2\u02dc\u0192 = (Player)entity).m_5833_() || \u00e2\u02dc\u0192.m_7500_() && \u00e2\u02dc\u0192.m_150110_().f_35935_) continue;
            this.f_46021_.put(\u00e2\u02dc\u0192, new Vec3(\u00e2\u02dc\u0192 * \u00e2\u02dc\u019216, \u00e2\u02dc\u0192 * \u00e2\u02dc\u019216, \u00e2\u02dc\u0192 * \u00e2\u02dc\u019216));
        }
    }

    public void m_46075_(boolean p_46076_) {
        boolean bl;
        if (this.f_46012_.f_46443_) {
            this.f_46012_.m_7785_(this.f_46013_, this.f_46014_, this.f_46015_, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (this.f_46012_.f_46441_.nextFloat() - this.f_46012_.f_46441_.nextFloat()) * 0.2f) * 0.7f, false);
        }
        boolean bl2 = bl = this.f_46010_ != BlockInteraction.NONE;
        if (p_46076_) {
            if (this.f_46017_ < 2.0f || !bl) {
                this.f_46012_.m_7106_(ParticleTypes.f_123813_, this.f_46013_, this.f_46014_, this.f_46015_, 1.0, 0.0, 0.0);
            } else {
                this.f_46012_.m_7106_(ParticleTypes.f_123812_, this.f_46013_, this.f_46014_, this.f_46015_, 1.0, 0.0, 0.0);
            }
        }
        if (bl) {
            ObjectArrayList objectArrayList = new ObjectArrayList();
            Collections.shuffle(this.f_46020_, this.f_46012_.f_46441_);
            for (BlockPos blockPos : this.f_46020_) {
                BlockState blockState = this.f_46012_.m_8055_(blockPos);
                Block \u00e2\u02dc\u01922 = blockState.m_60734_();
                if (blockState.m_60795_()) continue;
                BlockPos \u00e2\u02dc\u01923 = blockPos.m_7949_();
                this.f_46012_.m_46473_().m_6180_("explosion_blocks");
                if (\u00e2\u02dc\u01922.m_6903_(this) && this.f_46012_ instanceof ServerLevel) {
                    BlockEntity blockEntity = blockState.m_155947_() ? this.f_46012_.m_7702_(blockPos) : null;
                    LootContext.Builder \u00e2\u02dc\u01924 = new LootContext.Builder((ServerLevel)this.f_46012_).m_78977_(this.f_46012_.f_46441_).m_78972_(LootContextParams.f_81460_, Vec3.m_82512_(blockPos)).m_78972_(LootContextParams.f_81463_, ItemStack.f_41583_).m_78984_(LootContextParams.f_81462_, blockEntity).m_78984_(LootContextParams.f_81455_, this.f_46016_);
                    if (this.f_46010_ == BlockInteraction.DESTROY) {
                        \u00e2\u02dc\u01924.m_78972_(LootContextParams.f_81464_, Float.valueOf(this.f_46017_));
                    }
                    blockState.m_60724_(\u00e2\u02dc\u01924).forEach(p_46074_ -> Explosion.m_46067_((ObjectArrayList<Pair<ItemStack, BlockPos>>)objectArrayList, p_46074_, \u00e2\u02dc\u01923));
                }
                this.f_46012_.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 3);
                \u00e2\u02dc\u01922.m_7592_(this.f_46012_, blockPos, this);
                this.f_46012_.m_46473_().m_7238_();
            }
            for (BlockPos blockPos : objectArrayList) {
                Block.m_49840_(this.f_46012_, (BlockPos)blockPos.getSecond(), (ItemStack)blockPos.getFirst());
            }
        }
        if (this.f_46009_) {
            for (BlockPos blockPos : this.f_46020_) {
                if (this.f_46011_.nextInt(3) != 0 || !this.f_46012_.m_8055_(blockPos).m_60795_() || !this.f_46012_.m_8055_(blockPos.m_7495_()).m_60804_(this.f_46012_, blockPos.m_7495_())) continue;
                this.f_46012_.m_46597_(blockPos, BaseFireBlock.m_49245_(this.f_46012_, blockPos));
            }
        }
    }

    private static void m_46067_(ObjectArrayList<Pair<ItemStack, BlockPos>> p_46068_, ItemStack p_46069_, BlockPos p_46070_) {
        int n = p_46068_.size();
        for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < n; ++\u00e2\u02dc\u0192) {
            Pair pair = (Pair)p_46068_.get(\u00e2\u02dc\u0192);
            ItemStack \u00e2\u02dc\u01922 = (ItemStack)pair.getFirst();
            if (!ItemEntity.m_32026_(\u00e2\u02dc\u01922, p_46069_)) continue;
            ItemStack \u00e2\u02dc\u01923 = ItemEntity.m_32029_(\u00e2\u02dc\u01922, p_46069_, 16);
            p_46068_.set(\u00e2\u02dc\u0192, (Object)Pair.of((Object)\u00e2\u02dc\u01923, (Object)((BlockPos)pair.getSecond())));
            if (!p_46069_.m_41619_()) continue;
            return;
        }
        p_46068_.add((Object)Pair.of((Object)p_46069_, (Object)p_46070_));
    }

    public DamageSource m_46077_() {
        return this.f_46018_;
    }

    public Map<Player, Vec3> m_46078_() {
        return this.f_46021_;
    }

    @Nullable
    public LivingEntity m_46079_() {
        Entity entity;
        if (this.f_46016_ == null) {
            return null;
        }
        if (this.f_46016_ instanceof PrimedTnt) {
            return ((PrimedTnt)this.f_46016_).m_32099_();
        }
        if (this.f_46016_ instanceof LivingEntity) {
            return (LivingEntity)this.f_46016_;
        }
        if (this.f_46016_ instanceof Projectile && (entity = ((Projectile)this.f_46016_).m_37282_()) instanceof LivingEntity) {
            return (LivingEntity)entity;
        }
        return null;
    }

    public void m_46080_() {
        this.f_46020_.clear();
    }

    public List<BlockPos> m_46081_() {
        return this.f_46020_;
    }

    public static final class BlockInteraction
    extends Enum<BlockInteraction> {
        public static final /* enum */ BlockInteraction NONE = new BlockInteraction();
        public static final /* enum */ BlockInteraction BREAK = new BlockInteraction();
        public static final /* enum */ BlockInteraction DESTROY = new BlockInteraction();
        private static final /* synthetic */ BlockInteraction[] $VALUES;

        public static BlockInteraction[] values() {
            return (BlockInteraction[])$VALUES.clone();
        }

        public static BlockInteraction valueOf(String p_46091_) {
            return Enum.valueOf(BlockInteraction.class, p_46091_);
        }

        private static /* synthetic */ BlockInteraction[] m_151477_() {
            return new BlockInteraction[]{NONE, BREAK, DESTROY};
        }

        static {
            $VALUES = BlockInteraction.m_151477_();
        }
    }
}

