/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.PotentialCalculator;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.biome.NearestNeighborBiomeZoomer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class NaturalSpawner {
    private static final Logger f_46977_ = LogManager.getLogger();
    private static final int f_151589_ = 24;
    public static final int f_151587_ = 8;
    public static final int f_151588_ = 128;
    static final int f_46978_ = (int)Math.pow(17.0, 2.0);
    private static final MobCategory[] f_46979_ = (MobCategory[])Stream.of(MobCategory.values()).filter(p_47037_ -> p_47037_ != MobCategory.MISC).toArray(MobCategory[]::new);

    private NaturalSpawner() {
    }

    public static SpawnState m_46984_(int p_46985_, Iterable<Entity> p_46986_, ChunkGetter p_46987_) {
        PotentialCalculator potentialCalculator = new PotentialCalculator();
        Object2IntOpenHashMap \u00e2\u02dc\u01922 = new Object2IntOpenHashMap();
        for (Entity entity : p_46986_) {
            if (entity instanceof Mob && (((Mob)(\u00e2\u02dc\u0192 = (Mob)entity)).m_21532_() || ((Mob)\u00e2\u02dc\u0192).m_8023_()) || (\u00e2\u02dc\u0192 = entity.m_6095_().m_20674_()) == MobCategory.MISC) continue;
            BlockPos blockPos = entity.m_142538_();
            long \u00e2\u02dc\u01923 = ChunkPos.m_45589_(SectionPos.m_123171_(blockPos.m_123341_()), SectionPos.m_123171_(blockPos.m_123343_()));
            p_46987_.m_47103_(\u00e2\u02dc\u01923, arg_0 -> NaturalSpawner.m_47085_(blockPos, entity, potentialCalculator, \u00e2\u02dc\u01922, (MobCategory)\u00e2\u02dc\u0192, arg_0));
        }
        return new SpawnState(p_46985_, (Object2IntOpenHashMap<MobCategory>)\u00e2\u02dc\u01922, potentialCalculator);
    }

    static Biome m_47095_(BlockPos p_47096_, ChunkAccess p_47097_) {
        return NearestNeighborBiomeZoomer.INSTANCE.m_7782_(0L, p_47096_.m_123341_(), p_47096_.m_123342_(), p_47096_.m_123343_(), p_47097_.m_6221_());
    }

    public static void m_47029_(ServerLevel p_47030_, LevelChunk p_47031_, SpawnState p_47032_, boolean p_47033_, boolean p_47034_, boolean p_47035_) {
        p_47030_.m_46473_().m_6180_("spawner");
        for (MobCategory mobCategory : f_46979_) {
            if (!p_47033_ && mobCategory.m_21609_() || !p_47034_ && !mobCategory.m_21609_() || !p_47035_ && mobCategory.m_21610_() || !p_47032_.m_47134_(mobCategory)) continue;
            NaturalSpawner.m_47045_(mobCategory, p_47030_, p_47031_, p_47032_::m_47127_, p_47032_::m_47131_);
        }
        p_47030_.m_46473_().m_7238_();
    }

    public static void m_47045_(MobCategory p_47046_, ServerLevel p_47047_, LevelChunk p_47048_, SpawnPredicate p_47049_, AfterSpawnCallback p_47050_) {
        BlockPos blockPos = NaturalSpawner.m_47062_(p_47047_, p_47048_);
        if (blockPos.m_123342_() < p_47047_.m_141937_() + 1) {
            return;
        }
        NaturalSpawner.m_47038_(p_47046_, p_47047_, p_47048_, blockPos, p_47049_, p_47050_);
    }

    @VisibleForDebug
    public static void m_151612_(MobCategory p_151613_, ServerLevel p_151614_, BlockPos p_151615_) {
        NaturalSpawner.m_47038_(p_151613_, p_151614_, p_151614_.m_46865_(p_151615_), p_151615_, (p_151606_, p_151607_, p_151608_) -> true, (p_151610_, p_151611_) -> {});
    }

    public static void m_47038_(MobCategory p_47039_, ServerLevel p_47040_, ChunkAccess p_47041_, BlockPos p_47042_, SpawnPredicate p_47043_, AfterSpawnCallback p_47044_) {
        StructureFeatureManager structureFeatureManager = p_47040_.m_8595_();
        ChunkGenerator \u00e2\u02dc\u01922 = p_47040_.m_7726_().m_8481_();
        int \u00e2\u02dc\u01923 = p_47042_.m_123342_();
        BlockState \u00e2\u02dc\u01924 = p_47041_.m_8055_(p_47042_);
        if (\u00e2\u02dc\u01924.m_60796_(p_47041_, p_47042_)) {
            return;
        }
        BlockPos.MutableBlockPos \u00e2\u02dc\u01925 = new BlockPos.MutableBlockPos();
        int \u00e2\u02dc\u01926 = 0;
        block0: for (int i = 0; i < 3; ++i) {
            \u00e2\u02dc\u0192 = p_47042_.m_123341_();
            \u00e2\u02dc\u0192 = p_47042_.m_123343_();
            \u00e2\u02dc\u0192 = 6;
            MobSpawnSettings.SpawnerData \u00e2\u02dc\u019211 = null;
            SpawnGroupData \u00e2\u02dc\u01927 = null;
            int \u00e2\u02dc\u01928 = Mth.m_14167_(p_47040_.f_46441_.nextFloat() * 4.0f);
            int \u00e2\u02dc\u01929 = 0;
            for (int j = 0; j < \u00e2\u02dc\u01928; ++j) {
                \u00e2\u02dc\u01925.m_122178_(\u00e2\u02dc\u0192 += p_47040_.f_46441_.nextInt(6) - p_47040_.f_46441_.nextInt(6), \u00e2\u02dc\u01923, \u00e2\u02dc\u0192 += p_47040_.f_46441_.nextInt(6) - p_47040_.f_46441_.nextInt(6));
                double d = (double)\u00e2\u02dc\u0192 + 0.5;
                \u00e2\u02dc\u0192 = (double)\u00e2\u02dc\u0192 + 0.5;
                Player \u00e2\u02dc\u019210 = p_47040_.m_45924_(d, \u00e2\u02dc\u01923, \u00e2\u02dc\u0192, -1.0, false);
                if (\u00e2\u02dc\u019210 == null || !NaturalSpawner.m_47024_(p_47040_, p_47041_, \u00e2\u02dc\u01925, \u00e2\u02dc\u0192 = \u00e2\u02dc\u019210.m_20275_(d, \u00e2\u02dc\u01923, \u00e2\u02dc\u0192))) continue;
                if (\u00e2\u02dc\u019211 == null) {
                    Object object = NaturalSpawner.m_151598_(p_47040_, structureFeatureManager, \u00e2\u02dc\u01922, p_47039_, p_47040_.f_46441_, \u00e2\u02dc\u01925);
                    if (!((Optional)object).isPresent()) continue block0;
                    \u00e2\u02dc\u019211 = ((Optional)object).get();
                    \u00e2\u02dc\u01928 = \u00e2\u02dc\u019211.f_48405_ + p_47040_.f_46441_.nextInt(1 + \u00e2\u02dc\u019211.f_48406_ - \u00e2\u02dc\u019211.f_48405_);
                }
                if (!NaturalSpawner.m_46995_(p_47040_, p_47039_, structureFeatureManager, \u00e2\u02dc\u01922, \u00e2\u02dc\u019211, \u00e2\u02dc\u01925, \u00e2\u02dc\u0192) || !p_47043_.m_47106_(\u00e2\u02dc\u019211.f_48404_, \u00e2\u02dc\u01925, p_47041_)) continue;
                object = NaturalSpawner.m_46988_(p_47040_, \u00e2\u02dc\u019211.f_48404_);
                if (object == null) {
                    return;
                }
                ((Entity)object).m_7678_(d, \u00e2\u02dc\u01923, \u00e2\u02dc\u0192, p_47040_.f_46441_.nextFloat() * 360.0f, 0.0f);
                if (!NaturalSpawner.m_46991_(p_47040_, (Mob)object, \u00e2\u02dc\u0192)) continue;
                \u00e2\u02dc\u01927 = ((Mob)object).m_6518_(p_47040_, p_47040_.m_6436_(((Entity)object).m_142538_()), MobSpawnType.NATURAL, \u00e2\u02dc\u01927, null);
                ++\u00e2\u02dc\u01929;
                p_47040_.m_47205_((Entity)object);
                p_47044_.m_47100_((Mob)object, p_47041_);
                if (++\u00e2\u02dc\u01926 >= ((Mob)object).m_5792_()) {
                    return;
                }
                if (((Mob)object).m_7296_(\u00e2\u02dc\u01929)) continue block0;
            }
        }
    }

    private static boolean m_47024_(ServerLevel p_47025_, ChunkAccess p_47026_, BlockPos.MutableBlockPos p_47027_, double p_47028_) {
        if (p_47028_ <= 576.0) {
            return false;
        }
        if (p_47025_.m_8900_().m_123306_(new Vec3((double)p_47027_.m_123341_() + 0.5, p_47027_.m_123342_(), (double)p_47027_.m_123343_() + 0.5), 24.0)) {
            return false;
        }
        return Objects.equals(new ChunkPos(p_47027_), p_47026_.m_7697_()) || p_47025_.m_143340_(p_47027_);
    }

    private static boolean m_46995_(ServerLevel p_46996_, MobCategory p_46997_, StructureFeatureManager p_46998_, ChunkGenerator p_46999_, MobSpawnSettings.SpawnerData p_47000_, BlockPos.MutableBlockPos p_47001_, double p_47002_) {
        EntityType<?> entityType = p_47000_.f_48404_;
        if (entityType.m_20674_() == MobCategory.MISC) {
            return false;
        }
        if (!entityType.m_20673_() && p_47002_ > (double)(entityType.m_20674_().m_21611_() * entityType.m_20674_().m_21611_())) {
            return false;
        }
        if (!entityType.m_20654_() || !NaturalSpawner.m_47003_(p_46996_, p_46998_, p_46999_, p_46997_, p_47000_, p_47001_)) {
            return false;
        }
        SpawnPlacements.Type \u00e2\u02dc\u01922 = SpawnPlacements.m_21752_(entityType);
        if (!NaturalSpawner.m_47051_(\u00e2\u02dc\u01922, p_46996_, p_47001_, entityType)) {
            return false;
        }
        if (!SpawnPlacements.m_21759_(entityType, p_46996_, MobSpawnType.NATURAL, p_47001_, p_46996_.f_46441_)) {
            return false;
        }
        return p_46996_.m_45772_(entityType.m_20585_((double)p_47001_.m_123341_() + 0.5, p_47001_.m_123342_(), (double)p_47001_.m_123343_() + 0.5));
    }

    @Nullable
    private static Mob m_46988_(ServerLevel p_46989_, EntityType<?> p_46990_) {
        Mob \u00e2\u02dc\u01922;
        try {
            Object obj = p_46990_.m_20615_(p_46989_);
            if (!(obj instanceof Mob)) {
                throw new IllegalStateException("Trying to spawn a non-mob: " + Registry.f_122826_.m_7981_(p_46990_));
            }
            \u00e2\u02dc\u01922 = (Mob)obj;
        }
        catch (Exception exception) {
            f_46977_.warn("Failed to create mob", (Throwable)exception);
            return null;
        }
        return \u00e2\u02dc\u01922;
    }

    private static boolean m_46991_(ServerLevel p_46992_, Mob p_46993_, double p_46994_) {
        if (p_46994_ > (double)(p_46993_.m_6095_().m_20674_().m_21611_() * p_46993_.m_6095_().m_20674_().m_21611_()) && p_46993_.m_6785_(p_46994_)) {
            return false;
        }
        return p_46993_.m_5545_(p_46992_, MobSpawnType.NATURAL) && p_46993_.m_6914_(p_46992_);
    }

    private static Optional<MobSpawnSettings.SpawnerData> m_151598_(ServerLevel p_151599_, StructureFeatureManager p_151600_, ChunkGenerator p_151601_, MobCategory p_151602_, Random p_151603_, BlockPos p_151604_) {
        Biome biome = p_151599_.m_46857_(p_151604_);
        if (p_151602_ == MobCategory.WATER_AMBIENT && biome.m_47567_() == Biome.BiomeCategory.RIVER && p_151603_.nextFloat() < 0.98f) {
            return Optional.empty();
        }
        return NaturalSpawner.m_151591_(p_151599_, p_151600_, p_151601_, p_151602_, p_151604_, biome).m_146335_(p_151603_);
    }

    private static boolean m_47003_(ServerLevel p_47004_, StructureFeatureManager p_47005_, ChunkGenerator p_47006_, MobCategory p_47007_, MobSpawnSettings.SpawnerData p_47008_, BlockPos p_47009_) {
        return NaturalSpawner.m_151591_(p_47004_, p_47005_, p_47006_, p_47007_, p_47009_, null).m_146338_().contains(p_47008_);
    }

    private static WeightedRandomList<MobSpawnSettings.SpawnerData> m_151591_(ServerLevel p_151592_, StructureFeatureManager p_151593_, ChunkGenerator p_151594_, MobCategory p_151595_, BlockPos p_151596_, @Nullable Biome p_151597_) {
        if (p_151595_ == MobCategory.MONSTER && p_151592_.m_8055_(p_151596_.m_7495_()).m_60713_(Blocks.f_50197_) && p_151593_.m_47285_(p_151596_, false, StructureFeature.f_67025_).m_73603_()) {
            return StructureFeature.f_67025_.m_142494_();
        }
        return p_151594_.m_142184_(p_151597_ != null ? p_151597_ : p_151592_.m_46857_(p_151596_), p_151593_, p_151595_, p_151596_);
    }

    private static BlockPos m_47062_(Level p_47063_, LevelChunk p_47064_) {
        ChunkPos chunkPos = p_47064_.m_7697_();
        int \u00e2\u02dc\u01922 = chunkPos.m_45604_() + p_47063_.f_46441_.nextInt(16);
        int \u00e2\u02dc\u01923 = chunkPos.m_45605_() + p_47063_.f_46441_.nextInt(16);
        int \u00e2\u02dc\u01924 = p_47064_.m_5885_(Heightmap.Types.WORLD_SURFACE, \u00e2\u02dc\u01922, \u00e2\u02dc\u01923) + 1;
        int \u00e2\u02dc\u01925 = Mth.m_144928_(p_47063_.f_46441_, p_47063_.m_141937_(), \u00e2\u02dc\u01924);
        return new BlockPos(\u00e2\u02dc\u01922, \u00e2\u02dc\u01925, \u00e2\u02dc\u01923);
    }

    public static boolean m_47056_(BlockGetter p_47057_, BlockPos p_47058_, BlockState p_47059_, FluidState p_47060_, EntityType<?> p_47061_) {
        if (p_47059_.m_60838_(p_47057_, p_47058_)) {
            return false;
        }
        if (p_47059_.m_60803_()) {
            return false;
        }
        if (!p_47060_.m_76178_()) {
            return false;
        }
        if (p_47059_.m_60620_(BlockTags.f_13054_)) {
            return false;
        }
        return !p_47061_.m_20630_(p_47059_);
    }

    public static boolean m_47051_(SpawnPlacements.Type p_47052_, LevelReader p_47053_, BlockPos p_47054_, @Nullable EntityType<?> p_47055_) {
        if (p_47052_ == SpawnPlacements.Type.NO_RESTRICTIONS) {
            return true;
        }
        if (p_47055_ == null || !p_47053_.m_6857_().m_61937_(p_47054_)) {
            return false;
        }
        BlockState blockState = p_47053_.m_8055_(p_47054_);
        FluidState \u00e2\u02dc\u01922 = p_47053_.m_6425_(p_47054_);
        BlockPos \u00e2\u02dc\u01923 = p_47054_.m_7494_();
        BlockPos \u00e2\u02dc\u01924 = p_47054_.m_7495_();
        switch (p_47052_) {
            case IN_WATER: {
                return \u00e2\u02dc\u01922.m_76153_(FluidTags.f_13131_) && p_47053_.m_6425_(\u00e2\u02dc\u01924).m_76153_(FluidTags.f_13131_) && !p_47053_.m_8055_(\u00e2\u02dc\u01923).m_60796_(p_47053_, \u00e2\u02dc\u01923);
            }
            case IN_LAVA: {
                return \u00e2\u02dc\u01922.m_76153_(FluidTags.f_13132_);
            }
        }
        \u00e2\u02dc\u0192 = p_47053_.m_8055_(\u00e2\u02dc\u01924);
        if (!\u00e2\u02dc\u0192.m_60643_(p_47053_, \u00e2\u02dc\u01924, p_47055_)) {
            return false;
        }
        return NaturalSpawner.m_47056_(p_47053_, p_47054_, blockState, \u00e2\u02dc\u01922, p_47055_) && NaturalSpawner.m_47056_(p_47053_, \u00e2\u02dc\u01923, p_47053_.m_8055_(\u00e2\u02dc\u01923), p_47053_.m_6425_(\u00e2\u02dc\u01923), p_47055_);
    }

    public static void m_151616_(ServerLevelAccessor p_151617_, Biome p_151618_, ChunkPos p_151619_, Random p_151620_) {
        MobSpawnSettings mobSpawnSettings = p_151618_.m_47518_();
        WeightedRandomList<MobSpawnSettings.SpawnerData> \u00e2\u02dc\u01922 = mobSpawnSettings.m_151798_(MobCategory.CREATURE);
        if (\u00e2\u02dc\u01922.m_146337_()) {
            return;
        }
        int \u00e2\u02dc\u01923 = p_151619_.m_45604_();
        int \u00e2\u02dc\u01924 = p_151619_.m_45605_();
        while (p_151620_.nextFloat() < mobSpawnSettings.m_48344_()) {
            Optional<MobSpawnSettings.SpawnerData> optional = \u00e2\u02dc\u01922.m_146335_(p_151620_);
            if (!optional.isPresent()) continue;
            MobSpawnSettings.SpawnerData \u00e2\u02dc\u01925 = optional.get();
            int \u00e2\u02dc\u01926 = \u00e2\u02dc\u01925.f_48405_ + p_151620_.nextInt(1 + \u00e2\u02dc\u01925.f_48406_ - \u00e2\u02dc\u01925.f_48405_);
            SpawnGroupData \u00e2\u02dc\u01927 = null;
            int \u00e2\u02dc\u01928 = \u00e2\u02dc\u01923 + p_151620_.nextInt(16);
            int \u00e2\u02dc\u01929 = \u00e2\u02dc\u01924 + p_151620_.nextInt(16);
            int \u00e2\u02dc\u019210 = \u00e2\u02dc\u01928;
            int \u00e2\u02dc\u019211 = \u00e2\u02dc\u01929;
            for (int i = 0; i < \u00e2\u02dc\u01926; ++i) {
                boolean bl = false;
                for (int j = 0; !bl && j < 4; ++j) {
                    BlockPos blockPos = NaturalSpawner.m_47065_(p_151617_, \u00e2\u02dc\u01925.f_48404_, \u00e2\u02dc\u01928, \u00e2\u02dc\u01929);
                    if (\u00e2\u02dc\u01925.f_48404_.m_20654_() && NaturalSpawner.m_47051_(SpawnPlacements.m_21752_(\u00e2\u02dc\u01925.f_48404_), p_151617_, blockPos, \u00e2\u02dc\u01925.f_48404_)) {
                        float f = \u00e2\u02dc\u01925.f_48404_.m_20678_();
                        double \u00e2\u02dc\u019212 = Mth.m_14008_(\u00e2\u02dc\u01928, (double)\u00e2\u02dc\u01923 + (double)f, (double)\u00e2\u02dc\u01923 + 16.0 - (double)f);
                        double \u00e2\u02dc\u019213 = Mth.m_14008_(\u00e2\u02dc\u01929, (double)\u00e2\u02dc\u01924 + (double)f, (double)\u00e2\u02dc\u01924 + 16.0 - (double)f);
                        if (!p_151617_.m_45772_(\u00e2\u02dc\u01925.f_48404_.m_20585_(\u00e2\u02dc\u019212, blockPos.m_123342_(), \u00e2\u02dc\u019213)) || !SpawnPlacements.m_21759_(\u00e2\u02dc\u01925.f_48404_, p_151617_, MobSpawnType.CHUNK_GENERATION, new BlockPos(\u00e2\u02dc\u019212, (double)blockPos.m_123342_(), \u00e2\u02dc\u019213), p_151617_.m_5822_())) continue;
                        try {
                            Object obj = \u00e2\u02dc\u01925.f_48404_.m_20615_(p_151617_.m_6018_());
                        }
                        catch (Exception exception) {
                            f_46977_.warn("Failed to create mob", (Throwable)exception);
                            continue;
                        }
                        ((Entity)obj).m_7678_(\u00e2\u02dc\u019212, blockPos.m_123342_(), \u00e2\u02dc\u019213, p_151620_.nextFloat() * 360.0f, 0.0f);
                        if (obj instanceof Mob && (\u00e2\u02dc\u0192 = (Mob)obj).m_5545_(p_151617_, MobSpawnType.CHUNK_GENERATION) && \u00e2\u02dc\u0192.m_6914_(p_151617_)) {
                            \u00e2\u02dc\u01927 = \u00e2\u02dc\u0192.m_6518_(p_151617_, p_151617_.m_6436_(\u00e2\u02dc\u0192.m_142538_()), MobSpawnType.CHUNK_GENERATION, \u00e2\u02dc\u01927, null);
                            p_151617_.m_47205_(\u00e2\u02dc\u0192);
                            bl = true;
                        }
                    }
                    \u00e2\u02dc\u01928 += p_151620_.nextInt(5) - p_151620_.nextInt(5);
                    \u00e2\u02dc\u01929 += p_151620_.nextInt(5) - p_151620_.nextInt(5);
                    while (\u00e2\u02dc\u01928 < \u00e2\u02dc\u01923 || \u00e2\u02dc\u01928 >= \u00e2\u02dc\u01923 + 16 || \u00e2\u02dc\u01929 < \u00e2\u02dc\u01924 || \u00e2\u02dc\u01929 >= \u00e2\u02dc\u01924 + 16) {
                        \u00e2\u02dc\u01928 = \u00e2\u02dc\u019210 + p_151620_.nextInt(5) - p_151620_.nextInt(5);
                        \u00e2\u02dc\u01929 = \u00e2\u02dc\u019211 + p_151620_.nextInt(5) - p_151620_.nextInt(5);
                    }
                }
            }
        }
    }

    private static BlockPos m_47065_(LevelReader p_47066_, EntityType<?> p_47067_, int p_47068_, int p_47069_) {
        int n = p_47066_.m_6924_(SpawnPlacements.m_21765_(p_47067_), p_47068_, p_47069_);
        BlockPos.MutableBlockPos \u00e2\u02dc\u01922 = new BlockPos.MutableBlockPos(p_47068_, n, p_47069_);
        if (p_47066_.m_6042_().m_63946_()) {
            do {
                \u00e2\u02dc\u01922.m_122173_(Direction.DOWN);
            } while (!p_47066_.m_8055_(\u00e2\u02dc\u01922).m_60795_());
            do {
                \u00e2\u02dc\u01922.m_122173_(Direction.DOWN);
            } while (p_47066_.m_8055_(\u00e2\u02dc\u01922).m_60795_() && \u00e2\u02dc\u01922.m_123342_() > p_47066_.m_141937_());
        }
        if (SpawnPlacements.m_21752_(p_47067_) == SpawnPlacements.Type.ON_GROUND && p_47066_.m_8055_((BlockPos)(\u00e2\u02dc\u0192 = \u00e2\u02dc\u01922.m_7495_())).m_60647_(p_47066_, (BlockPos)\u00e2\u02dc\u0192, PathComputationType.LAND)) {
            return \u00e2\u02dc\u0192;
        }
        return \u00e2\u02dc\u01922.m_7949_();
    }

    private static /* synthetic */ void m_47085_(BlockPos p_47086_, Entity p_47087_, PotentialCalculator p_47088_, Object2IntOpenHashMap p_47089_, MobCategory p_47090_, LevelChunk p_47091_) {
        MobSpawnSettings.MobSpawnCost mobSpawnCost = NaturalSpawner.m_47095_(p_47086_, p_47091_).m_47518_().m_48345_(p_47087_.m_6095_());
        if (mobSpawnCost != null) {
            p_47088_.m_47192_(p_47087_.m_142538_(), mobSpawnCost.m_48400_());
        }
        p_47089_.addTo((Object)p_47090_, 1);
    }

    @FunctionalInterface
    public static interface ChunkGetter {
        public void m_47103_(long var1, Consumer<LevelChunk> var3);
    }

    public static class SpawnState {
        private final int f_47110_;
        private final Object2IntOpenHashMap<MobCategory> f_47111_;
        private final PotentialCalculator f_47112_;
        private final Object2IntMap<MobCategory> f_47113_;
        @Nullable
        private BlockPos f_47114_;
        @Nullable
        private EntityType<?> f_47115_;
        private double f_47116_;

        SpawnState(int p_47118_, Object2IntOpenHashMap<MobCategory> p_47119_, PotentialCalculator p_47120_) {
            this.f_47110_ = p_47118_;
            this.f_47111_ = p_47119_;
            this.f_47112_ = p_47120_;
            this.f_47113_ = Object2IntMaps.unmodifiable(p_47119_);
        }

        private boolean m_47127_(EntityType<?> p_47128_, BlockPos p_47129_, ChunkAccess p_47130_) {
            this.f_47114_ = p_47129_;
            this.f_47115_ = p_47128_;
            MobSpawnSettings.MobSpawnCost mobSpawnCost = NaturalSpawner.m_47095_(p_47129_, p_47130_).m_47518_().m_48345_(p_47128_);
            if (mobSpawnCost == null) {
                this.f_47116_ = 0.0;
                return true;
            }
            this.f_47116_ = \u00e2\u02dc\u0192 = mobSpawnCost.m_48400_();
            double \u00e2\u02dc\u01922 = this.f_47112_.m_47195_(p_47129_, \u00e2\u02dc\u0192);
            return \u00e2\u02dc\u01922 <= mobSpawnCost.m_48395_();
        }

        private void m_47131_(Mob p_47132_, ChunkAccess p_47133_) {
            EntityType<?> entityType = p_47132_.m_6095_();
            BlockPos \u00e2\u02dc\u01922 = p_47132_.m_142538_();
            double \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922.equals(this.f_47114_) && entityType == this.f_47115_ ? this.f_47116_ : ((\u00e2\u02dc\u0192 = NaturalSpawner.m_47095_(\u00e2\u02dc\u01922, p_47133_).m_47518_().m_48345_(entityType)) != null ? \u00e2\u02dc\u0192.m_48400_() : 0.0);
            this.f_47112_.m_47192_(\u00e2\u02dc\u01922, \u00e2\u02dc\u01923);
            this.f_47111_.addTo((Object)entityType.m_20674_(), 1);
        }

        public int m_47126_() {
            return this.f_47110_;
        }

        public Object2IntMap<MobCategory> m_47148_() {
            return this.f_47113_;
        }

        boolean m_47134_(MobCategory p_47135_) {
            int n = p_47135_.m_21608_() * this.f_47110_ / f_46978_;
            return this.f_47111_.getInt((Object)p_47135_) < n;
        }
    }

    @FunctionalInterface
    public static interface SpawnPredicate {
        public boolean m_47106_(EntityType<?> var1, BlockPos var2, ChunkAccess var3);
    }

    @FunctionalInterface
    public static interface AfterSpawnCallback {
        public void m_47100_(Mob var1, ChunkAccess var2);
    }
}

