/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Function3;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryLookupCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class MultiNoiseBiomeSource
extends BiomeSource {
    private static final NoiseParameters f_48426_ = new NoiseParameters(-7, (List<Double>)ImmutableList.of((Object)1.0, (Object)1.0));
    public static final MapCodec<MultiNoiseBiomeSource> f_48424_ = RecordCodecBuilder.mapCodec(p_48477_ -> p_48477_.group((App)Codec.LONG.fieldOf("seed").forGetter(p_151852_ -> p_151852_.f_48437_), (App)RecordCodecBuilder.create(p_151838_ -> p_151838_.group((App)Biome.ClimateParameters.f_47649_.fieldOf("parameters").forGetter(Pair::getFirst), (App)Biome.f_47431_.fieldOf("biome").forGetter(Pair::getSecond)).apply((Applicative)p_151838_, Pair::of)).listOf().fieldOf("biomes").forGetter(p_151850_ -> p_151850_.f_48435_), (App)NoiseParameters.f_48501_.fieldOf("temperature_noise").forGetter(p_151848_ -> p_151848_.f_48427_), (App)NoiseParameters.f_48501_.fieldOf("humidity_noise").forGetter(p_151846_ -> p_151846_.f_48428_), (App)NoiseParameters.f_48501_.fieldOf("altitude_noise").forGetter(p_151844_ -> p_151844_.f_48429_), (App)NoiseParameters.f_48501_.fieldOf("weirdness_noise").forGetter(p_151842_ -> p_151842_.f_48430_)).apply((Applicative)p_48477_, MultiNoiseBiomeSource::new));
    public static final Codec<MultiNoiseBiomeSource> f_48425_ = Codec.mapEither(PresetInstance.f_48540_, f_48424_).xmap(p_48473_ -> (MultiNoiseBiomeSource)p_48473_.map(PresetInstance::m_48565_, Function.identity()), p_48471_ -> p_48471_.m_48490_().map(Either::left).orElseGet(() -> Either.right((Object)p_48471_))).codec();
    private final NoiseParameters f_48427_;
    private final NoiseParameters f_48428_;
    private final NoiseParameters f_48429_;
    private final NoiseParameters f_48430_;
    private final NormalNoise f_48431_;
    private final NormalNoise f_48432_;
    private final NormalNoise f_48433_;
    private final NormalNoise f_48434_;
    private final List<Pair<Biome.ClimateParameters, Supplier<Biome>>> f_48435_;
    private final boolean f_48436_;
    private final long f_48437_;
    private final Optional<Pair<Registry<Biome>, Preset>> f_48438_;

    public MultiNoiseBiomeSource(long p_151828_, List<Pair<Biome.ClimateParameters, Supplier<Biome>>> p_151829_) {
        this(p_151828_, p_151829_, Optional.empty());
    }

    MultiNoiseBiomeSource(long p_48456_, List<Pair<Biome.ClimateParameters, Supplier<Biome>>> p_48457_, Optional<Pair<Registry<Biome>, Preset>> p_48458_) {
        this(p_48456_, p_48457_, f_48426_, f_48426_, f_48426_, f_48426_, p_48458_);
    }

    private MultiNoiseBiomeSource(long p_48441_, List<Pair<Biome.ClimateParameters, Supplier<Biome>>> p_48442_, NoiseParameters p_48443_, NoiseParameters p_48444_, NoiseParameters p_48445_, NoiseParameters p_48446_) {
        this(p_48441_, p_48442_, p_48443_, p_48444_, p_48445_, p_48446_, Optional.empty());
    }

    private MultiNoiseBiomeSource(long p_48448_, List<Pair<Biome.ClimateParameters, Supplier<Biome>>> p_48449_, NoiseParameters p_48450_, NoiseParameters p_48451_, NoiseParameters p_48452_, NoiseParameters p_48453_, Optional<Pair<Registry<Biome>, Preset>> p_48454_) {
        super(p_48449_.stream().map(Pair::getSecond));
        this.f_48437_ = p_48448_;
        this.f_48438_ = p_48454_;
        this.f_48427_ = p_48450_;
        this.f_48428_ = p_48451_;
        this.f_48429_ = p_48452_;
        this.f_48430_ = p_48453_;
        this.f_48431_ = NormalNoise.m_164350_(new WorldgenRandom(p_48448_), p_48450_.m_48508_(), p_48450_.m_48511_());
        this.f_48432_ = NormalNoise.m_164350_(new WorldgenRandom(p_48448_ + 1L), p_48451_.m_48508_(), p_48451_.m_48511_());
        this.f_48433_ = NormalNoise.m_164350_(new WorldgenRandom(p_48448_ + 2L), p_48452_.m_48508_(), p_48452_.m_48511_());
        this.f_48434_ = NormalNoise.m_164350_(new WorldgenRandom(p_48448_ + 3L), p_48453_.m_48508_(), p_48453_.m_48511_());
        this.f_48435_ = p_48449_;
        this.f_48436_ = false;
    }

    public static MultiNoiseBiomeSource m_151832_(Registry<Biome> p_151833_, long p_151834_) {
        ImmutableList<Pair<Biome.ClimateParameters, Supplier<Biome>>> immutableList = MultiNoiseBiomeSource.m_151830_(p_151833_);
        NoiseParameters \u00e2\u02dc\u01922 = new NoiseParameters(-9, 1.0, 0.0, 3.0, 3.0, 3.0, 3.0);
        NoiseParameters \u00e2\u02dc\u01923 = new NoiseParameters(-7, 1.0, 2.0, 4.0, 4.0);
        NoiseParameters \u00e2\u02dc\u01924 = new NoiseParameters(-9, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0);
        NoiseParameters \u00e2\u02dc\u01925 = new NoiseParameters(-8, 1.2, 0.6, 0.0, 0.0, 1.0, 0.0);
        return new MultiNoiseBiomeSource(p_151834_, (List<Pair<Biome.ClimateParameters, Supplier<Biome>>>)immutableList, \u00e2\u02dc\u01922, \u00e2\u02dc\u01923, \u00e2\u02dc\u01924, \u00e2\u02dc\u01925, Optional.empty());
    }

    @Override
    protected Codec<? extends BiomeSource> m_5820_() {
        return f_48425_;
    }

    @Override
    public BiomeSource m_7206_(long p_48466_) {
        return new MultiNoiseBiomeSource(p_48466_, this.f_48435_, this.f_48427_, this.f_48428_, this.f_48429_, this.f_48430_, this.f_48438_);
    }

    private Optional<PresetInstance> m_48490_() {
        return this.f_48438_.map(p_48475_ -> new PresetInstance((Preset)p_48475_.getSecond(), (Registry)p_48475_.getFirst(), this.f_48437_));
    }

    @Override
    public Biome m_7158_(int p_48479_, int p_48480_, int p_48481_) {
        int n = this.f_48436_ ? p_48480_ : 0;
        Biome.ClimateParameters \u00e2\u02dc\u01922 = new Biome.ClimateParameters((float)this.f_48431_.m_75380_(p_48479_, n, p_48481_), (float)this.f_48432_.m_75380_(p_48479_, n, p_48481_), (float)this.f_48433_.m_75380_(p_48479_, n, p_48481_), (float)this.f_48434_.m_75380_(p_48479_, n, p_48481_), 0.0f);
        return this.f_48435_.stream().min(Comparator.comparing(p_48469_ -> Float.valueOf(((Biome.ClimateParameters)p_48469_.getFirst()).m_47662_(\u00e2\u02dc\u01922)))).map(Pair::getSecond).map(Supplier::get).orElse(net.minecraft.data.worldgen.biome.Biomes.f_127322_);
    }

    public static ImmutableList<Pair<Biome.ClimateParameters, Supplier<Biome>>> m_151830_(Registry<Biome> p_151831_) {
        return ImmutableList.of((Object)Pair.of((Object)new Biome.ClimateParameters(0.0f, 0.0f, 0.0f, 0.0f, 0.0f), () -> p_151831_.m_123013_(Biomes.f_48202_)));
    }

    public boolean m_48482_(long p_48483_) {
        return this.f_48437_ == p_48483_ && this.f_48438_.isPresent() && Objects.equals(this.f_48438_.get().getSecond(), Preset.f_48512_);
    }

    static class NoiseParameters {
        private final int f_48502_;
        private final DoubleList f_48503_;
        public static final Codec<NoiseParameters> f_48501_ = RecordCodecBuilder.create(p_48510_ -> p_48510_.group((App)Codec.INT.fieldOf("firstOctave").forGetter(NoiseParameters::m_48508_), (App)Codec.DOUBLE.listOf().fieldOf("amplitudes").forGetter(NoiseParameters::m_48511_)).apply((Applicative)p_48510_, NoiseParameters::new));

        public NoiseParameters(int p_48506_, List<Double> p_48507_) {
            this.f_48502_ = p_48506_;
            this.f_48503_ = new DoubleArrayList(p_48507_);
        }

        public NoiseParameters(int p_151854_, double ... p_151855_) {
            this.f_48502_ = p_151854_;
            this.f_48503_ = new DoubleArrayList(p_151855_);
        }

        public int m_48508_() {
            return this.f_48502_;
        }

        public DoubleList m_48511_() {
            return this.f_48503_;
        }
    }

    public static class Preset {
        static final Map<ResourceLocation, Preset> f_48513_ = Maps.newHashMap();
        public static final Preset f_48512_ = new Preset(new ResourceLocation("nether"), (Function3<Preset, Registry<Biome>, Long, MultiNoiseBiomeSource>)((Function3)(p_48524_, p_48525_, p_48526_) -> new MultiNoiseBiomeSource((long)p_48526_, (List<Pair<Biome.ClimateParameters, Supplier<Biome>>>)ImmutableList.of((Object)Pair.of((Object)new Biome.ClimateParameters(0.0f, 0.0f, 0.0f, 0.0f, 0.0f), () -> p_48525_.m_123013_(Biomes.f_48209_)), (Object)Pair.of((Object)new Biome.ClimateParameters(0.0f, -0.5f, 0.0f, 0.0f, 0.0f), () -> p_48525_.m_123013_(Biomes.f_48199_)), (Object)Pair.of((Object)new Biome.ClimateParameters(0.4f, 0.0f, 0.0f, 0.0f, 0.0f), () -> p_48525_.m_123013_(Biomes.f_48200_)), (Object)Pair.of((Object)new Biome.ClimateParameters(0.0f, 0.5f, 0.0f, 0.0f, 0.375f), () -> p_48525_.m_123013_(Biomes.f_48201_)), (Object)Pair.of((Object)new Biome.ClimateParameters(-0.5f, 0.0f, 0.0f, 0.0f, 0.175f), () -> p_48525_.m_123013_(Biomes.f_48175_))), Optional.of(Pair.of((Object)p_48525_, (Object)p_48524_)))));
        final ResourceLocation f_48514_;
        private final Function3<Preset, Registry<Biome>, Long, MultiNoiseBiomeSource> f_48515_;

        public Preset(ResourceLocation p_48518_, Function3<Preset, Registry<Biome>, Long, MultiNoiseBiomeSource> p_48519_) {
            this.f_48514_ = p_48518_;
            this.f_48515_ = p_48519_;
            f_48513_.put(p_48518_, this);
        }

        public MultiNoiseBiomeSource m_48529_(Registry<Biome> p_48530_, long p_48531_) {
            return (MultiNoiseBiomeSource)this.f_48515_.apply((Object)this, p_48530_, (Object)p_48531_);
        }
    }

    static final class PresetInstance {
        public static final MapCodec<PresetInstance> f_48540_ = RecordCodecBuilder.mapCodec(p_48558_ -> p_48558_.group((App)ResourceLocation.f_135803_.flatXmap(p_151869_ -> Optional.ofNullable(Preset.f_48513_.get(p_151869_)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown preset: " + p_151869_))), p_151867_ -> DataResult.success((Object)p_151867_.f_48514_)).fieldOf("preset").stable().forGetter(PresetInstance::m_48554_), (App)RegistryLookupCodec.m_135622_(Registry.f_122885_).forGetter(PresetInstance::m_48561_), (App)Codec.LONG.fieldOf("seed").stable().forGetter(PresetInstance::m_48564_)).apply((Applicative)p_48558_, p_48558_.stable(PresetInstance::new)));
        private final Preset f_48541_;
        private final Registry<Biome> f_48542_;
        private final long f_48543_;

        PresetInstance(Preset p_48546_, Registry<Biome> p_48547_, long p_48548_) {
            this.f_48541_ = p_48546_;
            this.f_48542_ = p_48547_;
            this.f_48543_ = p_48548_;
        }

        public Preset m_48554_() {
            return this.f_48541_;
        }

        public Registry<Biome> m_48561_() {
            return this.f_48542_;
        }

        public long m_48564_() {
            return this.f_48543_;
        }

        public MultiNoiseBiomeSource m_48565_() {
            return this.f_48541_.m_48529_(this.f_48542_, this.f_48543_);
        }
    }
}

