/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VineBlock
extends Block {
    public static final BooleanProperty f_57833_ = PipeBlock.f_55152_;
    public static final BooleanProperty f_57834_ = PipeBlock.f_55148_;
    public static final BooleanProperty f_57835_ = PipeBlock.f_55149_;
    public static final BooleanProperty f_57836_ = PipeBlock.f_55150_;
    public static final BooleanProperty f_57837_ = PipeBlock.f_55151_;
    public static final Map<Direction, BooleanProperty> f_57838_ = PipeBlock.f_55154_.entrySet().stream().filter(p_57886_ -> p_57886_.getKey() != Direction.DOWN).collect(Util.m_137448_());
    protected static final float f_154875_ = 1.0f;
    private static final VoxelShape f_57839_ = Block.m_49796_(0.0, 15.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape f_57840_ = Block.m_49796_(0.0, 0.0, 0.0, 1.0, 16.0, 16.0);
    private static final VoxelShape f_57841_ = Block.m_49796_(15.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape f_57842_ = Block.m_49796_(0.0, 0.0, 0.0, 16.0, 16.0, 1.0);
    private static final VoxelShape f_57843_ = Block.m_49796_(0.0, 0.0, 15.0, 16.0, 16.0, 16.0);
    private final Map<BlockState, VoxelShape> f_57844_;

    public VineBlock(BlockBehaviour.Properties p_57847_) {
        super(p_57847_);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(f_57833_, false)).m_61124_(f_57834_, false)).m_61124_(f_57835_, false)).m_61124_(f_57836_, false)).m_61124_(f_57837_, false));
        this.f_57844_ = ImmutableMap.copyOf(this.f_49792_.m_61056_().stream().collect(Collectors.toMap(Function.identity(), VineBlock::m_57905_)));
    }

    private static VoxelShape m_57905_(BlockState p_57906_) {
        VoxelShape voxelShape = Shapes.m_83040_();
        if (p_57906_.m_61143_(f_57833_).booleanValue()) {
            voxelShape = f_57839_;
        }
        if (p_57906_.m_61143_(f_57834_).booleanValue()) {
            voxelShape = Shapes.m_83110_(voxelShape, f_57842_);
        }
        if (p_57906_.m_61143_(f_57836_).booleanValue()) {
            voxelShape = Shapes.m_83110_(voxelShape, f_57843_);
        }
        if (p_57906_.m_61143_(f_57835_).booleanValue()) {
            voxelShape = Shapes.m_83110_(voxelShape, f_57841_);
        }
        if (p_57906_.m_61143_(f_57837_).booleanValue()) {
            voxelShape = Shapes.m_83110_(voxelShape, f_57840_);
        }
        return voxelShape.m_83281_() ? Shapes.m_83144_() : voxelShape;
    }

    @Override
    public VoxelShape m_5940_(BlockState p_57897_, BlockGetter p_57898_, BlockPos p_57899_, CollisionContext p_57900_) {
        return this.f_57844_.get(p_57897_);
    }

    @Override
    public boolean m_7420_(BlockState p_181239_, BlockGetter p_181240_, BlockPos p_181241_) {
        return true;
    }

    @Override
    public boolean m_7898_(BlockState p_57861_, LevelReader p_57862_, BlockPos p_57863_) {
        return this.m_57907_(this.m_57901_(p_57861_, p_57862_, p_57863_));
    }

    private boolean m_57907_(BlockState p_57908_) {
        return this.m_57909_(p_57908_) > 0;
    }

    private int m_57909_(BlockState p_57910_) {
        int n = 0;
        for (BooleanProperty booleanProperty : f_57838_.values()) {
            if (!p_57910_.m_61143_(booleanProperty).booleanValue()) continue;
            ++n;
        }
        return n;
    }

    private boolean m_57887_(BlockGetter p_57888_, BlockPos p_57889_, Direction p_57890_) {
        if (p_57890_ == Direction.DOWN) {
            return false;
        }
        BlockPos blockPos = p_57889_.m_142300_(p_57890_);
        if (VineBlock.m_57853_(p_57888_, blockPos, p_57890_)) {
            return true;
        }
        if (p_57890_.m_122434_() != Direction.Axis.Y) {
            BooleanProperty booleanProperty = f_57838_.get(p_57890_);
            BlockState \u00e2\u02dc\u01922 = p_57888_.m_8055_(p_57889_.m_7494_());
            return \u00e2\u02dc\u01922.m_60713_(this) && \u00e2\u02dc\u01922.m_61143_(booleanProperty) != false;
        }
        return false;
    }

    public static boolean m_57853_(BlockGetter p_57854_, BlockPos p_57855_, Direction p_57856_) {
        BlockState blockState = p_57854_.m_8055_(p_57855_);
        return Block.m_49918_(blockState.m_60812_(p_57854_, p_57855_), p_57856_.m_122424_());
    }

    private BlockState m_57901_(BlockState p_57902_, BlockGetter p_57903_, BlockPos p_57904_) {
        BlockPos blockPos = p_57904_.m_7494_();
        if (p_57902_.m_61143_(f_57833_).booleanValue()) {
            p_57902_ = (BlockState)p_57902_.m_61124_(f_57833_, VineBlock.m_57853_(p_57903_, blockPos, Direction.DOWN));
        }
        BlockBehaviour.BlockStateBase \u00e2\u02dc\u01922 = null;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BooleanProperty booleanProperty = VineBlock.m_57883_(direction);
            if (!p_57902_.m_61143_(booleanProperty).booleanValue()) continue;
            boolean \u00e2\u02dc\u01923 = this.m_57887_(p_57903_, p_57904_, direction);
            if (!\u00e2\u02dc\u01923) {
                if (\u00e2\u02dc\u01922 == null) {
                    \u00e2\u02dc\u01922 = p_57903_.m_8055_(blockPos);
                }
                \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922.m_60713_(this) && \u00e2\u02dc\u01922.m_61143_(booleanProperty) != false;
            }
            p_57902_ = (BlockState)p_57902_.m_61124_(booleanProperty, \u00e2\u02dc\u01923);
        }
        return p_57902_;
    }

    @Override
    public BlockState m_7417_(BlockState p_57875_, Direction p_57876_, BlockState p_57877_, LevelAccessor p_57878_, BlockPos p_57879_, BlockPos p_57880_) {
        if (p_57876_ == Direction.DOWN) {
            return super.m_7417_(p_57875_, p_57876_, p_57877_, p_57878_, p_57879_, p_57880_);
        }
        BlockState blockState = this.m_57901_(p_57875_, p_57878_, p_57879_);
        if (!this.m_57907_(blockState)) {
            return Blocks.f_50016_.m_49966_();
        }
        return blockState;
    }

    @Override
    public void m_7455_(BlockState p_57892_, ServerLevel p_57893_, BlockPos p_57894_, Random p_57895_) {
        if (p_57895_.nextInt(4) != 0) {
            return;
        }
        Direction direction = Direction.m_122404_(p_57895_);
        BlockPos \u00e2\u02dc\u01922 = p_57894_.m_7494_();
        if (direction.m_122434_().m_122479_() && !p_57892_.m_61143_(VineBlock.m_57883_(direction)).booleanValue()) {
            if (!this.m_57850_(p_57893_, p_57894_)) {
                return;
            }
            BlockPos blockPos = p_57894_.m_142300_(direction);
            BlockState \u00e2\u02dc\u01923 = p_57893_.m_8055_(blockPos);
            if (\u00e2\u02dc\u01923.m_60795_()) {
                Direction direction2 = direction.m_122427_();
                \u00e2\u02dc\u0192 = direction.m_122428_();
                boolean \u00e2\u02dc\u01924 = p_57892_.m_61143_(VineBlock.m_57883_(direction2));
                boolean \u00e2\u02dc\u01925 = p_57892_.m_61143_(VineBlock.m_57883_(\u00e2\u02dc\u0192));
                BlockPos \u00e2\u02dc\u01926 = blockPos.m_142300_(direction2);
                BlockPos \u00e2\u02dc\u01927 = blockPos.m_142300_(\u00e2\u02dc\u0192);
                if (\u00e2\u02dc\u01924 && VineBlock.m_57853_(p_57893_, \u00e2\u02dc\u01926, direction2)) {
                    p_57893_.m_7731_(blockPos, (BlockState)this.m_49966_().m_61124_(VineBlock.m_57883_(direction2), true), 2);
                } else if (\u00e2\u02dc\u01925 && VineBlock.m_57853_(p_57893_, \u00e2\u02dc\u01927, \u00e2\u02dc\u0192)) {
                    p_57893_.m_7731_(blockPos, (BlockState)this.m_49966_().m_61124_(VineBlock.m_57883_(\u00e2\u02dc\u0192), true), 2);
                } else {
                    \u00e2\u02dc\u0192 = direction.m_122424_();
                    if (\u00e2\u02dc\u01924 && p_57893_.m_46859_(\u00e2\u02dc\u01926) && VineBlock.m_57853_(p_57893_, p_57894_.m_142300_(direction2), \u00e2\u02dc\u0192)) {
                        p_57893_.m_7731_(\u00e2\u02dc\u01926, (BlockState)this.m_49966_().m_61124_(VineBlock.m_57883_(\u00e2\u02dc\u0192), true), 2);
                    } else if (\u00e2\u02dc\u01925 && p_57893_.m_46859_(\u00e2\u02dc\u01927) && VineBlock.m_57853_(p_57893_, p_57894_.m_142300_(\u00e2\u02dc\u0192), \u00e2\u02dc\u0192)) {
                        p_57893_.m_7731_(\u00e2\u02dc\u01927, (BlockState)this.m_49966_().m_61124_(VineBlock.m_57883_(\u00e2\u02dc\u0192), true), 2);
                    } else if ((double)p_57895_.nextFloat() < 0.05 && VineBlock.m_57853_(p_57893_, blockPos.m_7494_(), Direction.UP)) {
                        p_57893_.m_7731_(blockPos, (BlockState)this.m_49966_().m_61124_(f_57833_, true), 2);
                    }
                }
            } else if (VineBlock.m_57853_(p_57893_, blockPos, direction)) {
                p_57893_.m_7731_(p_57894_, (BlockState)p_57892_.m_61124_(VineBlock.m_57883_(direction), true), 2);
            }
            return;
        }
        if (direction == Direction.UP && p_57894_.m_123342_() < p_57893_.m_151558_() - 1) {
            if (this.m_57887_(p_57893_, p_57894_, direction)) {
                p_57893_.m_7731_(p_57894_, (BlockState)p_57892_.m_61124_(f_57833_, true), 2);
                return;
            }
            if (p_57893_.m_46859_(\u00e2\u02dc\u01922)) {
                if (!this.m_57850_(p_57893_, p_57894_)) {
                    return;
                }
                BlockState \u00e2\u02dc\u01928 = p_57892_;
                for (Direction direction3 : Direction.Plane.HORIZONTAL) {
                    if (!p_57895_.nextBoolean() && VineBlock.m_57853_(p_57893_, \u00e2\u02dc\u01922.m_142300_(direction3), direction3)) continue;
                    \u00e2\u02dc\u01928 = (BlockState)\u00e2\u02dc\u01928.m_61124_(VineBlock.m_57883_(direction3), false);
                }
                if (this.m_57911_(\u00e2\u02dc\u01928)) {
                    p_57893_.m_7731_(\u00e2\u02dc\u01922, \u00e2\u02dc\u01928, 2);
                }
                return;
            }
        }
        if (p_57894_.m_123342_() > p_57893_.m_141937_() && ((\u00e2\u02dc\u0192 = p_57893_.m_8055_(\u00e2\u02dc\u0192 = p_57894_.m_7495_())).m_60795_() || \u00e2\u02dc\u0192.m_60713_(this)) && (\u00e2\u02dc\u0192 = \u00e2\u02dc\u0192.m_60795_() ? this.m_49966_() : \u00e2\u02dc\u0192) != (\u00e2\u02dc\u0192 = this.m_57870_(p_57892_, \u00e2\u02dc\u0192, p_57895_)) && this.m_57911_(\u00e2\u02dc\u0192)) {
            p_57893_.m_7731_(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192, 2);
        }
    }

    private BlockState m_57870_(BlockState p_57871_, BlockState p_57872_, Random p_57873_) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!p_57873_.nextBoolean() || !p_57871_.m_61143_(\u00e2\u02dc\u0192 = VineBlock.m_57883_(direction)).booleanValue()) continue;
            p_57872_ = (BlockState)p_57872_.m_61124_(\u00e2\u02dc\u0192, true);
        }
        return p_57872_;
    }

    private boolean m_57911_(BlockState p_57912_) {
        return p_57912_.m_61143_(f_57834_) != false || p_57912_.m_61143_(f_57835_) != false || p_57912_.m_61143_(f_57836_) != false || p_57912_.m_61143_(f_57837_) != false;
    }

    private boolean m_57850_(BlockGetter p_57851_, BlockPos p_57852_) {
        int n = 4;
        Iterable<BlockPos> \u00e2\u02dc\u01922 = BlockPos.m_121976_(p_57852_.m_123341_() - 4, p_57852_.m_123342_() - 1, p_57852_.m_123343_() - 4, p_57852_.m_123341_() + 4, p_57852_.m_123342_() + 1, p_57852_.m_123343_() + 4);
        \u00e2\u02dc\u0192 = 5;
        for (BlockPos blockPos : \u00e2\u02dc\u01922) {
            if (!p_57851_.m_8055_(blockPos).m_60713_(this) || --\u00e2\u02dc\u0192 > 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean m_6864_(BlockState p_57858_, BlockPlaceContext p_57859_) {
        BlockState blockState = p_57859_.m_43725_().m_8055_(p_57859_.m_8083_());
        if (blockState.m_60713_(this)) {
            return this.m_57909_(blockState) < f_57838_.size();
        }
        return super.m_6864_(p_57858_, p_57859_);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext p_57849_) {
        BlockState blockState;
        BlockState blockState2 = p_57849_.m_43725_().m_8055_(p_57849_.m_8083_());
        boolean \u00e2\u02dc\u01922 = blockState2.m_60713_(this);
        blockState = \u00e2\u02dc\u01922 ? blockState2 : this.m_49966_();
        for (Direction direction : p_57849_.m_6232_()) {
            if (direction == Direction.DOWN) continue;
            BooleanProperty booleanProperty = VineBlock.m_57883_(direction);
            boolean bl = \u00e2\u02dc\u0192 = \u00e2\u02dc\u01922 && blockState2.m_61143_(booleanProperty) != false;
            if (\u00e2\u02dc\u0192 || !this.m_57887_(p_57849_.m_43725_(), p_57849_.m_8083_(), direction)) continue;
            return (BlockState)blockState.m_61124_(booleanProperty, true);
        }
        return \u00e2\u02dc\u01922 ? blockState : null;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_57882_) {
        p_57882_.m_61104_(f_57833_, f_57834_, f_57835_, f_57836_, f_57837_);
    }

    @Override
    public BlockState m_6843_(BlockState p_57868_, Rotation p_57869_) {
        switch (p_57869_) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)p_57868_.m_61124_(f_57834_, p_57868_.m_61143_(f_57836_))).m_61124_(f_57835_, p_57868_.m_61143_(f_57837_))).m_61124_(f_57836_, p_57868_.m_61143_(f_57834_))).m_61124_(f_57837_, p_57868_.m_61143_(f_57835_));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)p_57868_.m_61124_(f_57834_, p_57868_.m_61143_(f_57835_))).m_61124_(f_57835_, p_57868_.m_61143_(f_57836_))).m_61124_(f_57836_, p_57868_.m_61143_(f_57837_))).m_61124_(f_57837_, p_57868_.m_61143_(f_57834_));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)p_57868_.m_61124_(f_57834_, p_57868_.m_61143_(f_57837_))).m_61124_(f_57835_, p_57868_.m_61143_(f_57834_))).m_61124_(f_57836_, p_57868_.m_61143_(f_57835_))).m_61124_(f_57837_, p_57868_.m_61143_(f_57836_));
            }
        }
        return p_57868_;
    }

    @Override
    public BlockState m_6943_(BlockState p_57865_, Mirror p_57866_) {
        switch (p_57866_) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)p_57865_.m_61124_(f_57834_, p_57865_.m_61143_(f_57836_))).m_61124_(f_57836_, p_57865_.m_61143_(f_57834_));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)p_57865_.m_61124_(f_57835_, p_57865_.m_61143_(f_57837_))).m_61124_(f_57837_, p_57865_.m_61143_(f_57835_));
            }
        }
        return super.m_6943_(p_57865_, p_57866_);
    }

    public static BooleanProperty m_57883_(Direction p_57884_) {
        return f_57838_.get(p_57884_);
    }
}

