/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BeehiveBlockEntity
extends BlockEntity {
    public static final String f_155121_ = "FlowerPos";
    public static final String f_155122_ = "MinOccupationTicks";
    public static final String f_155123_ = "EntityData";
    public static final String f_155124_ = "TicksInHive";
    public static final String f_155125_ = "HasNectar";
    public static final String f_155126_ = "Bees";
    private static final List<String> f_155129_ = Arrays.asList("Air", "ArmorDropChances", "ArmorItems", "Brain", "CanPickUpLoot", "DeathTime", "FallDistance", "FallFlying", "Fire", "HandDropChances", "HandItems", "HurtByTimestamp", "HurtTime", "LeftHanded", "Motion", "NoGravity", "OnGround", "PortalCooldown", "Pos", "Rotation", "CannotEnterHiveTicks", "TicksSincePollination", "CropsGrownSincePollination", "HivePos", "Passengers", "Leash", "UUID");
    public static final int f_155127_ = 3;
    private static final int f_155130_ = 400;
    private static final int f_155131_ = 2400;
    public static final int f_155128_ = 600;
    private final List<BeeData> f_58732_ = Lists.newArrayList();
    @Nullable
    private BlockPos f_58733_;

    public BeehiveBlockEntity(BlockPos p_155134_, BlockState p_155135_) {
        super(BlockEntityType.f_58912_, p_155134_, p_155135_);
    }

    @Override
    public void m_6596_() {
        if (this.m_58773_()) {
            this.m_58748_(null, this.f_58857_.m_8055_(this.m_58899_()), BeeReleaseStatus.EMERGENCY);
        }
        super.m_6596_();
    }

    public boolean m_58773_() {
        if (this.f_58857_ == null) {
            return false;
        }
        for (BlockPos blockPos : BlockPos.m_121940_(this.f_58858_.m_142082_(-1, -1, -1), this.f_58858_.m_142082_(1, 1, 1))) {
            if (!(this.f_58857_.m_8055_(blockPos).m_60734_() instanceof FireBlock)) continue;
            return true;
        }
        return false;
    }

    public boolean m_58774_() {
        return this.f_58732_.isEmpty();
    }

    public boolean m_58775_() {
        return this.f_58732_.size() == 3;
    }

    public void m_58748_(@Nullable Player p_58749_, BlockState p_58750_, BeeReleaseStatus p_58751_) {
        List<Entity> list = this.m_58759_(p_58750_, p_58751_);
        if (p_58749_ != null) {
            for (Entity entity : list) {
                if (!(entity instanceof Bee)) continue;
                Bee bee = (Bee)entity;
                if (!(p_58749_.m_20182_().m_82557_(entity.m_20182_()) <= 16.0)) continue;
                if (!this.m_58777_()) {
                    bee.m_6710_(p_58749_);
                    continue;
                }
                bee.m_27915_(400);
            }
        }
    }

    private List<Entity> m_58759_(BlockState p_58760_, BeeReleaseStatus p_58761_) {
        ArrayList arrayList = Lists.newArrayList();
        this.f_58732_.removeIf(p_58766_ -> BeehiveBlockEntity.m_155136_(this.f_58857_, this.f_58858_, p_58760_, p_58766_, arrayList, p_58761_, this.f_58733_));
        return arrayList;
    }

    public void m_58741_(Entity p_58742_, boolean p_58743_) {
        this.m_58744_(p_58742_, p_58743_, 0);
    }

    @VisibleForDebug
    public int m_58776_() {
        return this.f_58732_.size();
    }

    public static int m_58752_(BlockState p_58753_) {
        return p_58753_.m_61143_(BeehiveBlock.f_49564_);
    }

    @VisibleForDebug
    public boolean m_58777_() {
        return CampfireBlock.m_51248_(this.f_58857_, this.m_58899_());
    }

    public void m_58744_(Entity p_58745_, boolean p_58746_, int p_58747_) {
        if (this.f_58732_.size() >= 3) {
            return;
        }
        p_58745_.m_8127_();
        p_58745_.m_20153_();
        CompoundTag compoundTag = new CompoundTag();
        p_58745_.m_20223_(compoundTag);
        this.m_155157_(compoundTag, p_58747_, p_58746_);
        if (this.f_58857_ != null) {
            if (p_58745_ instanceof Bee && ((Bee)(object = (Bee)p_58745_)).m_27852_() && (!this.m_58780_() || this.f_58857_.f_46441_.nextBoolean())) {
                this.f_58733_ = ((Bee)object).m_27851_();
            }
            Object object = this.m_58899_();
            this.f_58857_.m_6263_(null, ((Vec3i)object).m_123341_(), ((Vec3i)object).m_123342_(), ((Vec3i)object).m_123343_(), SoundEvents.f_11695_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        p_58745_.m_146870_();
    }

    public void m_155157_(CompoundTag p_155158_, int p_155159_, boolean p_155160_) {
        this.f_58732_.add(new BeeData(p_155158_, p_155159_, p_155160_ ? 2400 : 600));
    }

    private static boolean m_155136_(Level p_155137_, BlockPos p_155138_, BlockState p_155139_, BeeData p_155140_, @Nullable List<Entity> p_155141_, BeeReleaseStatus p_155142_, @Nullable BlockPos p_155143_) {
        if ((p_155137_.m_46462_() || p_155137_.m_46471_()) && p_155142_ != BeeReleaseStatus.EMERGENCY) {
            return false;
        }
        CompoundTag compoundTag = p_155140_.f_58782_;
        BeehiveBlockEntity.m_155161_(compoundTag);
        compoundTag.m_128365_("HivePos", NbtUtils.m_129224_(p_155138_));
        compoundTag.m_128379_("NoGravity", true);
        Direction \u00e2\u02dc\u01922 = p_155139_.m_61143_(BeehiveBlock.f_49563_);
        BlockPos \u00e2\u02dc\u01923 = p_155138_.m_142300_(\u00e2\u02dc\u01922);
        boolean bl = \u00e2\u02dc\u0192 = !p_155137_.m_8055_(\u00e2\u02dc\u01923).m_60812_(p_155137_, \u00e2\u02dc\u01923).m_83281_();
        if (\u00e2\u02dc\u0192 && p_155142_ != BeeReleaseStatus.EMERGENCY) {
            return false;
        }
        Entity \u00e2\u02dc\u01924 = EntityType.m_20645_(compoundTag, p_155137_, p_58740_ -> p_58740_);
        if (\u00e2\u02dc\u01924 != null) {
            if (!\u00e2\u02dc\u01924.m_6095_().m_20609_(EntityTypeTags.f_13122_)) {
                return false;
            }
            if (\u00e2\u02dc\u01924 instanceof Bee) {
                Bee bee = (Bee)\u00e2\u02dc\u01924;
                if (p_155143_ != null && !bee.m_27852_() && p_155137_.f_46441_.nextFloat() < 0.9f) {
                    bee.m_27876_(p_155143_);
                }
                if (p_155142_ == BeeReleaseStatus.HONEY_DELIVERED) {
                    bee.m_27864_();
                    if (p_155139_.m_60620_(BlockTags.f_13072_) && (\u00e2\u02dc\u0192 = BeehiveBlockEntity.m_58752_(p_155139_)) < 5) {
                        int n = \u00e2\u02dc\u0192 = p_155137_.f_46441_.nextInt(100) == 0 ? 2 : 1;
                        if (\u00e2\u02dc\u0192 + \u00e2\u02dc\u0192 > 5) {
                            --\u00e2\u02dc\u0192;
                        }
                        p_155137_.m_46597_(p_155138_, (BlockState)p_155139_.m_61124_(BeehiveBlock.f_49564_, \u00e2\u02dc\u0192 + \u00e2\u02dc\u0192));
                    }
                }
                BeehiveBlockEntity.m_58736_(p_155140_.f_58783_, bee);
                if (p_155141_ != null) {
                    p_155141_.add(bee);
                }
                float \u00e2\u02dc\u01925 = \u00e2\u02dc\u01924.m_20205_();
                double \u00e2\u02dc\u01926 = \u00e2\u02dc\u0192 ? 0.0 : 0.55 + (double)(\u00e2\u02dc\u01925 / 2.0f);
                double \u00e2\u02dc\u01927 = (double)p_155138_.m_123341_() + 0.5 + \u00e2\u02dc\u01926 * (double)\u00e2\u02dc\u01922.m_122429_();
                double \u00e2\u02dc\u01928 = (double)p_155138_.m_123342_() + 0.5 - (double)(\u00e2\u02dc\u01924.m_20206_() / 2.0f);
                double \u00e2\u02dc\u01929 = (double)p_155138_.m_123343_() + 0.5 + \u00e2\u02dc\u01926 * (double)\u00e2\u02dc\u01922.m_122431_();
                \u00e2\u02dc\u01924.m_7678_(\u00e2\u02dc\u01927, \u00e2\u02dc\u01928, \u00e2\u02dc\u01929, \u00e2\u02dc\u01924.m_146908_(), \u00e2\u02dc\u01924.m_146909_());
            }
            p_155137_.m_5594_(null, p_155138_, SoundEvents.f_11696_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return p_155137_.m_7967_(\u00e2\u02dc\u01924);
        }
        return false;
    }

    static void m_155161_(CompoundTag p_155162_) {
        for (String string : f_155129_) {
            p_155162_.m_128473_(string);
        }
    }

    private static void m_58736_(int p_58737_, Bee p_58738_) {
        int n = p_58738_.m_146764_();
        if (n < 0) {
            p_58738_.m_146762_(Math.min(0, n + p_58737_));
        } else if (n > 0) {
            p_58738_.m_146762_(Math.max(0, n - p_58737_));
        }
        p_58738_.m_27601_(Math.max(0, p_58738_.m_27591_() - p_58737_));
    }

    private boolean m_58780_() {
        return this.f_58733_ != null;
    }

    private static void m_155149_(Level p_155150_, BlockPos p_155151_, BlockState p_155152_, List<BeeData> p_155153_, @Nullable BlockPos p_155154_) {
        Iterator<BeeData> iterator = p_155153_.iterator();
        while (iterator.hasNext()) {
            BeeData beeData = iterator.next();
            if (beeData.f_58783_ > beeData.f_58784_) {
                BeeReleaseStatus beeReleaseStatus = \u00e2\u02dc\u0192 = beeData.f_58782_.m_128471_(f_155125_) ? BeeReleaseStatus.HONEY_DELIVERED : BeeReleaseStatus.BEE_RELEASED;
                if (BeehiveBlockEntity.m_155136_(p_155150_, p_155151_, p_155152_, beeData, null, \u00e2\u02dc\u0192, p_155154_)) {
                    iterator.remove();
                }
            }
            ++beeData.f_58783_;
        }
    }

    public static void m_155144_(Level p_155145_, BlockPos p_155146_, BlockState p_155147_, BeehiveBlockEntity p_155148_) {
        BeehiveBlockEntity.m_155149_(p_155145_, p_155146_, p_155147_, p_155148_.f_58732_, p_155148_.f_58733_);
        if (!p_155148_.f_58732_.isEmpty() && p_155145_.m_5822_().nextDouble() < 0.005) {
            double d = (double)p_155146_.m_123341_() + 0.5;
            \u00e2\u02dc\u0192 = p_155146_.m_123342_();
            \u00e2\u02dc\u0192 = (double)p_155146_.m_123343_() + 0.5;
            p_155145_.m_6263_(null, d, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, SoundEvents.f_11698_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        DebugPackets.m_179510_(p_155145_, p_155146_, p_155147_, p_155148_);
    }

    @Override
    public void m_142466_(CompoundTag p_155156_) {
        super.m_142466_(p_155156_);
        this.f_58732_.clear();
        ListTag listTag = p_155156_.m_128437_(f_155126_, 10);
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag compoundTag = listTag.m_128728_(i);
            BeeData \u00e2\u02dc\u01922 = new BeeData(compoundTag.m_128469_(f_155123_), compoundTag.m_128451_(f_155124_), compoundTag.m_128451_(f_155122_));
            this.f_58732_.add(\u00e2\u02dc\u01922);
        }
        this.f_58733_ = null;
        if (p_155156_.m_128441_(f_155121_)) {
            this.f_58733_ = NbtUtils.m_129239_(p_155156_.m_128469_(f_155121_));
        }
    }

    @Override
    public CompoundTag m_6945_(CompoundTag p_58771_) {
        super.m_6945_(p_58771_);
        p_58771_.m_128365_(f_155126_, this.m_58779_());
        if (this.m_58780_()) {
            p_58771_.m_128365_(f_155121_, NbtUtils.m_129224_(this.f_58733_));
        }
        return p_58771_;
    }

    public ListTag m_58779_() {
        ListTag listTag = new ListTag();
        for (BeeData beeData : this.f_58732_) {
            beeData.f_58782_.m_128473_("UUID");
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128365_(f_155123_, beeData.f_58782_);
            compoundTag.m_128405_(f_155124_, beeData.f_58783_);
            compoundTag.m_128405_(f_155122_, beeData.f_58784_);
            listTag.add(compoundTag);
        }
        return listTag;
    }

    public static final class BeeReleaseStatus
    extends Enum<BeeReleaseStatus> {
        public static final /* enum */ BeeReleaseStatus HONEY_DELIVERED = new BeeReleaseStatus();
        public static final /* enum */ BeeReleaseStatus BEE_RELEASED = new BeeReleaseStatus();
        public static final /* enum */ BeeReleaseStatus EMERGENCY = new BeeReleaseStatus();
        private static final /* synthetic */ BeeReleaseStatus[] $VALUES;

        public static BeeReleaseStatus[] values() {
            return (BeeReleaseStatus[])$VALUES.clone();
        }

        public static BeeReleaseStatus valueOf(String p_58811_) {
            return Enum.valueOf(BeeReleaseStatus.class, p_58811_);
        }

        private static /* synthetic */ BeeReleaseStatus[] m_155163_() {
            return new BeeReleaseStatus[]{HONEY_DELIVERED, BEE_RELEASED, EMERGENCY};
        }

        static {
            $VALUES = BeeReleaseStatus.m_155163_();
        }
    }

    static class BeeData {
        final CompoundTag f_58782_;
        int f_58783_;
        final int f_58784_;

        BeeData(CompoundTag p_58786_, int p_58787_, int p_58788_) {
            BeehiveBlockEntity.m_155161_(p_58786_);
            this.f_58782_ = p_58786_;
            this.f_58783_ = p_58787_;
            this.f_58784_ = p_58788_;
        }
    }
}

