/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ConduitBlockEntity
extends BlockEntity {
    private static final int f_155390_ = 2;
    private static final int f_155391_ = 13;
    private static final float f_155392_ = -0.0375f;
    private static final int f_155393_ = 16;
    private static final int f_155394_ = 42;
    private static final int f_155395_ = 8;
    private static final Block[] f_59184_ = new Block[]{Blocks.f_50377_, Blocks.f_50378_, Blocks.f_50386_, Blocks.f_50379_};
    public int f_59183_;
    private float f_59185_;
    private boolean f_59186_;
    private boolean f_59187_;
    private final List<BlockPos> f_59188_ = Lists.newArrayList();
    @Nullable
    private LivingEntity f_59189_;
    @Nullable
    private UUID f_59190_;
    private long f_59191_;

    public ConduitBlockEntity(BlockPos p_155397_, BlockState p_155398_) {
        super(BlockEntityType.f_58941_, p_155397_, p_155398_);
    }

    @Override
    public void m_142466_(CompoundTag p_155437_) {
        super.m_142466_(p_155437_);
        this.f_59190_ = p_155437_.m_128403_("Target") ? p_155437_.m_128342_("Target") : null;
    }

    @Override
    public CompoundTag m_6945_(CompoundTag p_59207_) {
        super.m_6945_(p_59207_);
        if (this.f_59189_ != null) {
            p_59207_.m_128362_("Target", this.f_59189_.m_142081_());
        }
        return p_59207_;
    }

    @Override
    @Nullable
    public ClientboundBlockEntityDataPacket m_7033_() {
        return new ClientboundBlockEntityDataPacket(this.f_58858_, 5, this.m_5995_());
    }

    @Override
    public CompoundTag m_5995_() {
        return this.m_6945_(new CompoundTag());
    }

    public static void m_155403_(Level p_155404_, BlockPos p_155405_, BlockState p_155406_, ConduitBlockEntity p_155407_) {
        ++p_155407_.f_59183_;
        long l = p_155404_.m_46467_();
        List<BlockPos> \u00e2\u02dc\u01922 = p_155407_.f_59188_;
        if (l % 40L == 0L) {
            p_155407_.f_59186_ = ConduitBlockEntity.m_155414_(p_155404_, p_155405_, \u00e2\u02dc\u01922);
            ConduitBlockEntity.m_155428_(p_155407_, \u00e2\u02dc\u01922);
        }
        ConduitBlockEntity.m_155399_(p_155404_, p_155405_, p_155407_);
        ConduitBlockEntity.m_155418_(p_155404_, p_155405_, \u00e2\u02dc\u01922, p_155407_.f_59189_, p_155407_.f_59183_);
        if (p_155407_.m_59216_()) {
            p_155407_.f_59185_ += 1.0f;
        }
    }

    public static void m_155438_(Level p_155439_, BlockPos p_155440_, BlockState p_155441_, ConduitBlockEntity p_155442_) {
        ++p_155442_.f_59183_;
        long l = p_155439_.m_46467_();
        List<BlockPos> \u00e2\u02dc\u01922 = p_155442_.f_59188_;
        if (l % 40L == 0L) {
            boolean bl = ConduitBlockEntity.m_155414_(p_155439_, p_155440_, \u00e2\u02dc\u01922);
            if (bl != p_155442_.f_59186_) {
                SoundEvent soundEvent = bl ? SoundEvents.f_11767_ : SoundEvents.f_11824_;
                p_155439_.m_5594_(null, p_155440_, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            p_155442_.f_59186_ = bl;
            ConduitBlockEntity.m_155428_(p_155442_, \u00e2\u02dc\u01922);
            if (bl) {
                ConduitBlockEntity.m_155443_(p_155439_, p_155440_, \u00e2\u02dc\u01922);
                ConduitBlockEntity.m_155408_(p_155439_, p_155440_, p_155441_, \u00e2\u02dc\u01922, p_155442_);
            }
        }
        if (p_155442_.m_59216_()) {
            if (l % 80L == 0L) {
                p_155439_.m_5594_(null, p_155440_, SoundEvents.f_11768_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (l > p_155442_.f_59191_) {
                p_155442_.f_59191_ = l + 60L + (long)p_155439_.m_5822_().nextInt(40);
                p_155439_.m_5594_(null, p_155440_, SoundEvents.f_11822_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    private static void m_155428_(ConduitBlockEntity p_155429_, List<BlockPos> p_155430_) {
        p_155429_.m_59214_(p_155430_.size() >= 42);
    }

    private static boolean m_155414_(Level p_155415_, BlockPos p_155416_, List<BlockPos> p_155417_) {
        int n;
        p_155417_.clear();
        for (n = -1; n <= 1; ++n) {
            for (\u00e2\u02dc\u0192 = -1; \u00e2\u02dc\u0192 <= 1; ++\u00e2\u02dc\u0192) {
                for (\u00e2\u02dc\u0192 = -1; \u00e2\u02dc\u0192 <= 1; ++\u00e2\u02dc\u0192) {
                    BlockPos blockPos = p_155416_.m_142082_(n, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
                    if (p_155415_.m_46801_(blockPos)) continue;
                    return false;
                }
            }
        }
        for (n = -2; n <= 2; ++n) {
            for (\u00e2\u02dc\u0192 = -2; \u00e2\u02dc\u0192 <= 2; ++\u00e2\u02dc\u0192) {
                for (\u00e2\u02dc\u0192 = -2; \u00e2\u02dc\u0192 <= 2; ++\u00e2\u02dc\u0192) {
                    \u00e2\u02dc\u0192 = Math.abs(n);
                    \u00e2\u02dc\u0192 = Math.abs(\u00e2\u02dc\u0192);
                    \u00e2\u02dc\u0192 = Math.abs(\u00e2\u02dc\u0192);
                    if (\u00e2\u02dc\u0192 <= 1 && \u00e2\u02dc\u0192 <= 1 && \u00e2\u02dc\u0192 <= 1 || (n != 0 || \u00e2\u02dc\u0192 != 2 && \u00e2\u02dc\u0192 != 2) && (\u00e2\u02dc\u0192 != 0 || \u00e2\u02dc\u0192 != 2 && \u00e2\u02dc\u0192 != 2) && (\u00e2\u02dc\u0192 != 0 || \u00e2\u02dc\u0192 != 2 && \u00e2\u02dc\u0192 != 2)) continue;
                    BlockPos blockPos = p_155416_.m_142082_(n, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
                    BlockState \u00e2\u02dc\u01922 = p_155415_.m_8055_(blockPos);
                    for (Block block : f_59184_) {
                        if (!\u00e2\u02dc\u01922.m_60713_(block)) continue;
                        p_155417_.add(blockPos);
                    }
                }
            }
        }
        return p_155417_.size() >= 16;
    }

    private static void m_155443_(Level p_155444_, BlockPos p_155445_, List<BlockPos> p_155446_) {
        int n = p_155446_.size();
        \u00e2\u02dc\u0192 = n / 7 * 16;
        \u00e2\u02dc\u0192 = p_155445_.m_123341_();
        AABB \u00e2\u02dc\u01922 = new AABB(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192 = p_155445_.m_123342_(), \u00e2\u02dc\u0192 = p_155445_.m_123343_(), \u00e2\u02dc\u0192 + 1, \u00e2\u02dc\u0192 + 1, \u00e2\u02dc\u0192 + 1).m_82400_(\u00e2\u02dc\u0192).m_82363_(0.0, p_155444_.m_141928_(), 0.0);
        List<Player> \u00e2\u02dc\u01923 = p_155444_.m_45976_(Player.class, \u00e2\u02dc\u01922);
        if (\u00e2\u02dc\u01923.isEmpty()) {
            return;
        }
        for (Player player : \u00e2\u02dc\u01923) {
            if (!p_155445_.m_123314_(player.m_142538_(), \u00e2\u02dc\u0192) || !player.m_20070_()) continue;
            player.m_7292_(new MobEffectInstance(MobEffects.f_19592_, 260, 0, true, true));
        }
    }

    private static void m_155408_(Level p_155409_, BlockPos p_155410_, BlockState p_155411_, List<BlockPos> p_155412_, ConduitBlockEntity p_155413_) {
        LivingEntity livingEntity = p_155413_.f_59189_;
        int \u00e2\u02dc\u01922 = p_155412_.size();
        if (\u00e2\u02dc\u01922 < 42) {
            p_155413_.f_59189_ = null;
        } else if (p_155413_.f_59189_ == null && p_155413_.f_59190_ != null) {
            p_155413_.f_59189_ = ConduitBlockEntity.m_155424_(p_155409_, p_155410_, p_155413_.f_59190_);
            p_155413_.f_59190_ = null;
        } else if (p_155413_.f_59189_ == null) {
            List<LivingEntity> list = p_155409_.m_6443_(LivingEntity.class, ConduitBlockEntity.m_155431_(p_155410_), p_59213_ -> p_59213_ instanceof Enemy && p_59213_.m_20070_());
            if (!list.isEmpty()) {
                p_155413_.f_59189_ = list.get(p_155409_.f_46441_.nextInt(list.size()));
            }
        } else if (!p_155413_.f_59189_.m_6084_() || !p_155410_.m_123314_(p_155413_.f_59189_.m_142538_(), 8.0)) {
            p_155413_.f_59189_ = null;
        }
        if (p_155413_.f_59189_ != null) {
            p_155409_.m_6263_(null, p_155413_.f_59189_.m_20185_(), p_155413_.f_59189_.m_20186_(), p_155413_.f_59189_.m_20189_(), SoundEvents.f_11823_, SoundSource.BLOCKS, 1.0f, 1.0f);
            p_155413_.f_59189_.m_6469_(DamageSource.f_19319_, 4.0f);
        }
        if (livingEntity != p_155413_.f_59189_) {
            p_155409_.m_7260_(p_155410_, p_155411_, p_155411_, 2);
        }
    }

    private static void m_155399_(Level p_155400_, BlockPos p_155401_, ConduitBlockEntity p_155402_) {
        if (p_155402_.f_59190_ == null) {
            p_155402_.f_59189_ = null;
        } else if (p_155402_.f_59189_ == null || !p_155402_.f_59189_.m_142081_().equals(p_155402_.f_59190_)) {
            p_155402_.f_59189_ = ConduitBlockEntity.m_155424_(p_155400_, p_155401_, p_155402_.f_59190_);
            if (p_155402_.f_59189_ == null) {
                p_155402_.f_59190_ = null;
            }
        }
    }

    private static AABB m_155431_(BlockPos p_155432_) {
        int n = p_155432_.m_123341_();
        \u00e2\u02dc\u0192 = p_155432_.m_123342_();
        \u00e2\u02dc\u0192 = p_155432_.m_123343_();
        return new AABB(n, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, n + 1, \u00e2\u02dc\u0192 + 1, \u00e2\u02dc\u0192 + 1).m_82400_(8.0);
    }

    @Nullable
    private static LivingEntity m_155424_(Level p_155425_, BlockPos p_155426_, UUID p_155427_) {
        List<LivingEntity> list = p_155425_.m_6443_(LivingEntity.class, ConduitBlockEntity.m_155431_(p_155426_), p_155435_ -> p_155435_.m_142081_().equals(p_155427_));
        if (list.size() == 1) {
            return list.get(0);
        }
        return null;
    }

    private static void m_155418_(Level p_155419_, BlockPos p_155420_, List<BlockPos> p_155421_, @Nullable Entity p_155422_, int p_155423_) {
        float \u00e2\u02dc\u01926;
        Random random = p_155419_.f_46441_;
        double \u00e2\u02dc\u01922 = Mth.m_14031_((float)(p_155423_ + 35) * 0.1f) / 2.0f + 0.5f;
        \u00e2\u02dc\u01922 = (\u00e2\u02dc\u01922 * \u00e2\u02dc\u01922 + \u00e2\u02dc\u01922) * (double)0.3f;
        Vec3 \u00e2\u02dc\u01923 = new Vec3((double)p_155420_.m_123341_() + 0.5, (double)p_155420_.m_123342_() + 1.5 + \u00e2\u02dc\u01922, (double)p_155420_.m_123343_() + 0.5);
        for (BlockPos blockPos : p_155421_) {
            if (random.nextInt(50) != 0) continue;
            \u00e2\u02dc\u0192 = blockPos.m_141950_(p_155420_);
            \u00e2\u02dc\u01926 = -0.5f + random.nextFloat() + (float)\u00e2\u02dc\u0192.m_123341_();
            \u00e2\u02dc\u0192 = -2.0f + random.nextFloat() + (float)\u00e2\u02dc\u0192.m_123342_();
            \u00e2\u02dc\u0192 = -0.5f + random.nextFloat() + (float)\u00e2\u02dc\u0192.m_123343_();
            p_155419_.m_7106_(ParticleTypes.f_123775_, \u00e2\u02dc\u01923.f_82479_, \u00e2\u02dc\u01923.f_82480_, \u00e2\u02dc\u01923.f_82481_, \u00e2\u02dc\u01926, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
        }
        if (p_155422_ != null) {
            Vec3 vec3 = new Vec3(p_155422_.m_20185_(), p_155422_.m_20188_(), p_155422_.m_20189_());
            float \u00e2\u02dc\u01924 = (-0.5f + random.nextFloat()) * (3.0f + p_155422_.m_20205_());
            float \u00e2\u02dc\u01925 = -1.0f + random.nextFloat() * p_155422_.m_20206_();
            \u00e2\u02dc\u01926 = (-0.5f + random.nextFloat()) * (3.0f + p_155422_.m_20205_());
            \u00e2\u02dc\u0192 = new Vec3(\u00e2\u02dc\u01924, \u00e2\u02dc\u01925, \u00e2\u02dc\u01926);
            p_155419_.m_7106_(ParticleTypes.f_123775_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, \u00e2\u02dc\u0192.f_82479_, \u00e2\u02dc\u0192.f_82480_, \u00e2\u02dc\u0192.f_82481_);
        }
    }

    public boolean m_59216_() {
        return this.f_59186_;
    }

    public boolean m_59217_() {
        return this.f_59187_;
    }

    private void m_59214_(boolean p_59215_) {
        this.f_59187_ = p_59215_;
    }

    public float m_59197_(float p_59198_) {
        return (this.f_59185_ + p_59198_) * -0.0375f;
    }
}

