/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.piston;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.piston.PistonStructureResolver;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.PistonType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PistonBaseBlock
extends DirectionalBlock {
    public static final BooleanProperty f_60153_ = BlockStateProperties.f_61432_;
    public static final int f_155888_ = 0;
    public static final int f_155889_ = 1;
    public static final int f_155890_ = 2;
    public static final float f_155891_ = 4.0f;
    protected static final VoxelShape f_60154_ = Block.m_49796_(0.0, 0.0, 0.0, 12.0, 16.0, 16.0);
    protected static final VoxelShape f_60155_ = Block.m_49796_(4.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape f_60156_ = Block.m_49796_(0.0, 0.0, 0.0, 16.0, 16.0, 12.0);
    protected static final VoxelShape f_60157_ = Block.m_49796_(0.0, 0.0, 4.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape f_60158_ = Block.m_49796_(0.0, 0.0, 0.0, 16.0, 12.0, 16.0);
    protected static final VoxelShape f_60159_ = Block.m_49796_(0.0, 4.0, 0.0, 16.0, 16.0, 16.0);
    private final boolean f_60160_;

    public PistonBaseBlock(boolean p_60163_, BlockBehaviour.Properties p_60164_) {
        super(p_60164_);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(f_52588_, Direction.NORTH)).m_61124_(f_60153_, false));
        this.f_60160_ = p_60163_;
    }

    @Override
    public VoxelShape m_5940_(BlockState p_60220_, BlockGetter p_60221_, BlockPos p_60222_, CollisionContext p_60223_) {
        if (p_60220_.m_61143_(f_60153_).booleanValue()) {
            switch (p_60220_.m_61143_(f_52588_)) {
                case DOWN: {
                    return f_60159_;
                }
                default: {
                    return f_60158_;
                }
                case NORTH: {
                    return f_60157_;
                }
                case SOUTH: {
                    return f_60156_;
                }
                case WEST: {
                    return f_60155_;
                }
                case EAST: 
            }
            return f_60154_;
        }
        return Shapes.m_83144_();
    }

    @Override
    public void m_6402_(Level p_60172_, BlockPos p_60173_, BlockState p_60174_, LivingEntity p_60175_, ItemStack p_60176_) {
        if (!p_60172_.f_46443_) {
            this.m_60167_(p_60172_, p_60173_, p_60174_);
        }
    }

    @Override
    public void m_6861_(BlockState p_60198_, Level p_60199_, BlockPos p_60200_, Block p_60201_, BlockPos p_60202_, boolean p_60203_) {
        if (!p_60199_.f_46443_) {
            this.m_60167_(p_60199_, p_60200_, p_60198_);
        }
    }

    @Override
    public void m_6807_(BlockState p_60225_, Level p_60226_, BlockPos p_60227_, BlockState p_60228_, boolean p_60229_) {
        if (p_60228_.m_60713_(p_60225_.m_60734_())) {
            return;
        }
        if (!p_60226_.f_46443_ && p_60226_.m_7702_(p_60227_) == null) {
            this.m_60167_(p_60226_, p_60227_, p_60225_);
        }
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext p_60166_) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_(f_52588_, p_60166_.m_7820_().m_122424_())).m_61124_(f_60153_, false);
    }

    private void m_60167_(Level p_60168_, BlockPos p_60169_, BlockState p_60170_) {
        Direction direction = p_60170_.m_61143_(f_52588_);
        boolean \u00e2\u02dc\u01922 = this.m_60177_(p_60168_, p_60169_, direction);
        if (\u00e2\u02dc\u01922 && !p_60170_.m_61143_(f_60153_).booleanValue()) {
            if (new PistonStructureResolver(p_60168_, p_60169_, direction, true).m_60422_()) {
                p_60168_.m_7696_(p_60169_, this, 0, direction.m_122411_());
            }
        } else if (!\u00e2\u02dc\u01922 && p_60170_.m_61143_(f_60153_).booleanValue()) {
            BlockPos blockPos = p_60169_.m_5484_(direction, 2);
            BlockState \u00e2\u02dc\u01923 = p_60168_.m_8055_(blockPos);
            int \u00e2\u02dc\u01924 = 1;
            if (\u00e2\u02dc\u01923.m_60713_(Blocks.f_50110_) && \u00e2\u02dc\u01923.m_61143_(f_52588_) == direction && (\u00e2\u02dc\u0192 = p_60168_.m_7702_(blockPos)) instanceof PistonMovingBlockEntity && (\u00e2\u02dc\u0192 = (PistonMovingBlockEntity)\u00e2\u02dc\u0192).m_60387_() && (\u00e2\u02dc\u0192.m_60350_(0.0f) < 0.5f || p_60168_.m_46467_() == \u00e2\u02dc\u0192.m_60402_() || ((ServerLevel)p_60168_).m_8874_())) {
                \u00e2\u02dc\u01924 = 2;
            }
            p_60168_.m_7696_(p_60169_, this, \u00e2\u02dc\u01924, direction.m_122411_());
        }
    }

    private boolean m_60177_(Level p_60178_, BlockPos p_60179_, Direction p_60180_) {
        for (Direction direction : Direction.values()) {
            if (direction == p_60180_ || !p_60178_.m_46616_(p_60179_.m_142300_(direction), direction)) continue;
            return true;
        }
        if (p_60178_.m_46616_(p_60179_, Direction.DOWN)) {
            return true;
        }
        BlockPos blockPos = p_60179_.m_7494_();
        for (Direction direction : Direction.values()) {
            if (direction == Direction.DOWN || !p_60178_.m_46616_(blockPos.m_142300_(direction), direction)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean m_8133_(BlockState p_60192_, Level p_60193_, BlockPos p_60194_, int p_60195_, int p_60196_) {
        Direction direction = p_60192_.m_61143_(f_52588_);
        if (!p_60193_.f_46443_) {
            boolean bl = this.m_60177_(p_60193_, p_60194_, direction);
            if (bl && (p_60195_ == 1 || p_60195_ == 2)) {
                p_60193_.m_7731_(p_60194_, (BlockState)p_60192_.m_61124_(f_60153_, true), 2);
                return false;
            }
            if (!bl && p_60195_ == 0) {
                return false;
            }
        }
        if (p_60195_ == 0) {
            if (!this.m_60181_(p_60193_, p_60194_, direction, true)) return false;
            p_60193_.m_7731_(p_60194_, (BlockState)p_60192_.m_61124_(f_60153_, true), 67);
            p_60193_.m_5594_(null, p_60194_, SoundEvents.f_12312_, SoundSource.BLOCKS, 0.5f, p_60193_.f_46441_.nextFloat() * 0.25f + 0.6f);
            p_60193_.m_151555_(GameEvent.f_157775_, p_60194_);
            return true;
        } else {
            if (p_60195_ != 1 && p_60195_ != 2) return true;
            BlockEntity \u00e2\u02dc\u01922 = p_60193_.m_7702_(p_60194_.m_142300_(direction));
            if (\u00e2\u02dc\u01922 instanceof PistonMovingBlockEntity) {
                ((PistonMovingBlockEntity)\u00e2\u02dc\u01922).m_60401_();
            }
            BlockState \u00e2\u02dc\u01923 = (BlockState)((BlockState)Blocks.f_50110_.m_49966_().m_61124_(MovingPistonBlock.f_60046_, direction)).m_61124_(MovingPistonBlock.f_60047_, this.f_60160_ ? PistonType.STICKY : PistonType.DEFAULT);
            p_60193_.m_7731_(p_60194_, \u00e2\u02dc\u01923, 20);
            p_60193_.m_151523_(MovingPistonBlock.m_155881_(p_60194_, \u00e2\u02dc\u01923, (BlockState)this.m_49966_().m_61124_(f_52588_, Direction.m_122376_(p_60196_ & 7)), direction, false, true));
            p_60193_.m_6289_(p_60194_, \u00e2\u02dc\u01923.m_60734_());
            \u00e2\u02dc\u01923.m_60701_(p_60193_, p_60194_, 2);
            if (this.f_60160_) {
                BlockPos blockPos = p_60194_.m_142082_(direction.m_122429_() * 2, direction.m_122430_() * 2, direction.m_122431_() * 2);
                BlockState \u00e2\u02dc\u01924 = p_60193_.m_8055_(blockPos);
                boolean \u00e2\u02dc\u01925 = false;
                if (\u00e2\u02dc\u01924.m_60713_(Blocks.f_50110_) && (\u00e2\u02dc\u0192 = p_60193_.m_7702_(blockPos)) instanceof PistonMovingBlockEntity && (\u00e2\u02dc\u0192 = (PistonMovingBlockEntity)\u00e2\u02dc\u0192).m_60392_() == direction && \u00e2\u02dc\u0192.m_60387_()) {
                    \u00e2\u02dc\u0192.m_60401_();
                    \u00e2\u02dc\u01925 = true;
                }
                if (!\u00e2\u02dc\u01925) {
                    if (p_60195_ == 1 && !\u00e2\u02dc\u01924.m_60795_() && PistonBaseBlock.m_60204_(\u00e2\u02dc\u01924, p_60193_, blockPos, direction.m_122424_(), false, direction) && (\u00e2\u02dc\u01924.m_60811_() == PushReaction.NORMAL || \u00e2\u02dc\u01924.m_60713_(Blocks.f_50039_) || \u00e2\u02dc\u01924.m_60713_(Blocks.f_50032_))) {
                        this.m_60181_(p_60193_, p_60194_, direction, false);
                    } else {
                        p_60193_.m_7471_(p_60194_.m_142300_(direction), false);
                    }
                }
            } else {
                p_60193_.m_7471_(p_60194_.m_142300_(direction), false);
            }
            p_60193_.m_5594_(null, p_60194_, SoundEvents.f_12311_, SoundSource.BLOCKS, 0.5f, p_60193_.f_46441_.nextFloat() * 0.15f + 0.6f);
            p_60193_.m_151555_(GameEvent.f_157774_, p_60194_);
        }
        return true;
    }

    public static boolean m_60204_(BlockState p_60205_, Level p_60206_, BlockPos p_60207_, Direction p_60208_, boolean p_60209_, Direction p_60210_) {
        if (p_60207_.m_123342_() < p_60206_.m_141937_() || p_60207_.m_123342_() > p_60206_.m_151558_() - 1 || !p_60206_.m_6857_().m_61937_(p_60207_)) {
            return false;
        }
        if (p_60205_.m_60795_()) {
            return true;
        }
        if (p_60205_.m_60713_(Blocks.f_50080_) || p_60205_.m_60713_(Blocks.f_50723_) || p_60205_.m_60713_(Blocks.f_50724_)) {
            return false;
        }
        if (p_60208_ == Direction.DOWN && p_60207_.m_123342_() == p_60206_.m_141937_()) {
            return false;
        }
        if (p_60208_ == Direction.UP && p_60207_.m_123342_() == p_60206_.m_151558_() - 1) {
            return false;
        }
        if (p_60205_.m_60713_(Blocks.f_50039_) || p_60205_.m_60713_(Blocks.f_50032_)) {
            if (p_60205_.m_61143_(f_60153_).booleanValue()) {
                return false;
            }
        } else {
            if (p_60205_.m_60800_(p_60206_, p_60207_) == -1.0f) {
                return false;
            }
            switch (p_60205_.m_60811_()) {
                case BLOCK: {
                    return false;
                }
                case DESTROY: {
                    return p_60209_;
                }
                case PUSH_ONLY: {
                    return p_60208_ == p_60210_;
                }
            }
        }
        return !p_60205_.m_155947_();
    }

    private boolean m_60181_(Level p_60182_, BlockPos p_60183_, Direction p_60184_, boolean p_60185_) {
        Object object;
        Object object2;
        PistonStructureResolver pistonStructureResolver;
        BlockPos blockPos = p_60183_.m_142300_(p_60184_);
        if (!p_60185_ && p_60182_.m_8055_(blockPos).m_60713_(Blocks.f_50040_)) {
            p_60182_.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 20);
        }
        if (!(pistonStructureResolver = new PistonStructureResolver(p_60182_, p_60183_, p_60184_, p_60185_)).m_60422_()) {
            return false;
        }
        HashMap \u00e2\u02dc\u01922 = Maps.newHashMap();
        List<BlockPos> \u00e2\u02dc\u01923 = pistonStructureResolver.m_60436_();
        ArrayList \u00e2\u02dc\u01924 = Lists.newArrayList();
        for (int i = 0; i < \u00e2\u02dc\u01923.size(); ++i) {
            BlockPos \u00e2\u02dc\u01926 = \u00e2\u02dc\u01923.get(i);
            BlockState \u00e2\u02dc\u01925 = p_60182_.m_8055_(\u00e2\u02dc\u01926);
            \u00e2\u02dc\u01924.add(\u00e2\u02dc\u01925);
            \u00e2\u02dc\u01922.put(\u00e2\u02dc\u01926, \u00e2\u02dc\u01925);
        }
        List<BlockPos> list = pistonStructureResolver.m_60437_();
        BlockState[] \u00e2\u02dc\u01929 = new BlockState[\u00e2\u02dc\u01923.size() + list.size()];
        Direction \u00e2\u02dc\u019211 = p_60185_ ? p_60184_ : p_60184_.m_122424_();
        int \u00e2\u02dc\u01927 = 0;
        for (int n2 = list.size() - 1; n2 >= 0; --n2) {
            BlockPos \u00e2\u02dc\u01928 = list.get(n2);
            BlockState blockState = p_60182_.m_8055_(\u00e2\u02dc\u01928);
            BlockEntity object3 = blockState.m_155947_() ? p_60182_.m_7702_(\u00e2\u02dc\u01928) : null;
            PistonBaseBlock.m_49892_(blockState, p_60182_, \u00e2\u02dc\u01928, object3);
            p_60182_.m_7731_(\u00e2\u02dc\u01928, Blocks.f_50016_.m_49966_(), 18);
            if (!blockState.m_60620_(BlockTags.f_13076_)) {
                p_60182_.m_142052_(\u00e2\u02dc\u01928, blockState);
            }
            \u00e2\u02dc\u01929[\u00e2\u02dc\u01927++] = blockState;
        }
        for (int i = \u00e2\u02dc\u01923.size() - 1; i >= 0; --i) {
            object2 = \u00e2\u02dc\u01923.get(i);
            BlockState blockState = p_60182_.m_8055_((BlockPos)object2);
            object2 = ((BlockPos)object2).m_142300_(\u00e2\u02dc\u019211);
            \u00e2\u02dc\u01922.remove(object2);
            object = (BlockState)Blocks.f_50110_.m_49966_().m_61124_(f_52588_, p_60184_);
            p_60182_.m_7731_((BlockPos)object2, (BlockState)object, 68);
            p_60182_.m_151523_(MovingPistonBlock.m_155881_((BlockPos)object2, (BlockState)object, (BlockState)\u00e2\u02dc\u01924.get(i), p_60184_, p_60185_, false));
            \u00e2\u02dc\u01929[\u00e2\u02dc\u01927++] = blockState;
        }
        if (p_60185_) {
            PistonType pistonType = this.f_60160_ ? PistonType.STICKY : PistonType.DEFAULT;
            object2 = (BlockState)((BlockState)Blocks.f_50040_.m_49966_().m_61124_(PistonHeadBlock.f_52588_, p_60184_)).m_61124_(PistonHeadBlock.f_60235_, pistonType);
            BlockState blockState = (BlockState)((BlockState)Blocks.f_50110_.m_49966_().m_61124_(MovingPistonBlock.f_60046_, p_60184_)).m_61124_(MovingPistonBlock.f_60047_, this.f_60160_ ? PistonType.STICKY : PistonType.DEFAULT);
            \u00e2\u02dc\u01922.remove(blockPos);
            p_60182_.m_7731_(blockPos, blockState, 68);
            p_60182_.m_151523_(MovingPistonBlock.m_155881_(blockPos, blockState, (BlockState)object2, p_60184_, true, true));
        }
        BlockState blockState = Blocks.f_50016_.m_49966_();
        for (BlockPos blockPos2 : \u00e2\u02dc\u01922.keySet()) {
            p_60182_.m_7731_(blockPos2, blockState, 82);
        }
        for (Map.Entry entry : \u00e2\u02dc\u01922.entrySet()) {
            object = (BlockPos)entry.getKey();
            BlockState \u00e2\u02dc\u019210 = (BlockState)entry.getValue();
            \u00e2\u02dc\u019210.m_60758_(p_60182_, (BlockPos)object, 2);
            blockState.m_60701_(p_60182_, (BlockPos)object, 2);
            blockState.m_60758_(p_60182_, (BlockPos)object, 2);
        }
        \u00e2\u02dc\u01927 = 0;
        for (int n = list.size() - 1; n >= 0; --n) {
            BlockState blockState2 = \u00e2\u02dc\u01929[\u00e2\u02dc\u01927++];
            object = list.get(n);
            blockState2.m_60758_(p_60182_, (BlockPos)object, 2);
            p_60182_.m_46672_((BlockPos)object, blockState2.m_60734_());
        }
        for (int i = \u00e2\u02dc\u01923.size() - 1; i >= 0; --i) {
            p_60182_.m_46672_(\u00e2\u02dc\u01923.get(i), \u00e2\u02dc\u01929[\u00e2\u02dc\u01927++].m_60734_());
        }
        if (p_60185_) {
            p_60182_.m_46672_(blockPos, Blocks.f_50040_);
        }
        return true;
    }

    @Override
    public BlockState m_6843_(BlockState p_60215_, Rotation p_60216_) {
        return (BlockState)p_60215_.m_61124_(f_52588_, p_60216_.m_55954_(p_60215_.m_61143_(f_52588_)));
    }

    @Override
    public BlockState m_6943_(BlockState p_60212_, Mirror p_60213_) {
        return p_60212_.m_60717_(p_60213_.m_54846_(p_60212_.m_61143_(f_52588_)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_60218_) {
        p_60218_.m_61104_(f_52588_, f_60153_);
    }

    @Override
    public boolean m_7923_(BlockState p_60231_) {
        return p_60231_.m_61143_(f_60153_);
    }

    @Override
    public boolean m_7357_(BlockState p_60187_, BlockGetter p_60188_, BlockPos p_60189_, PathComputationType p_60190_) {
        return false;
    }
}

