/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;

public class StateDefinition<O, S extends StateHolder<O, S>> {
    static final Pattern f_61046_ = Pattern.compile("^[a-z0-9_]+$");
    private final O f_61047_;
    private final ImmutableSortedMap<String, Property<?>> f_61048_;
    private final ImmutableList<S> f_61049_;

    protected StateDefinition(Function<O, S> p_61052_, O p_61053_, Factory<O, S> p_61054_, Map<String, Property<?>> p_61055_) {
        Object \u00e2\u02dc\u019232;
        this.f_61047_ = p_61053_;
        this.f_61048_ = ImmutableSortedMap.copyOf(p_61055_);
        Supplier<StateHolder> supplier = () -> (StateHolder)p_61052_.apply(p_61053_);
        MapCodec<StateHolder> \u00e2\u02dc\u01922 = MapCodec.of((MapEncoder)Encoder.empty(), (MapDecoder)Decoder.unit(supplier));
        for (Object \u00e2\u02dc\u019232 : this.f_61048_.entrySet()) {
            \u00e2\u02dc\u01922 = StateDefinition.m_61076_(\u00e2\u02dc\u01922, supplier, (String)\u00e2\u02dc\u019232.getKey(), (Property)\u00e2\u02dc\u019232.getValue());
        }
        MapCodec<StateHolder> mapCodec = \u00e2\u02dc\u01922;
        \u00e2\u02dc\u019232 = Maps.newLinkedHashMap();
        ArrayList \u00e2\u02dc\u01924 = Lists.newArrayList();
        Stream<List<List<Object>>> \u00e2\u02dc\u01925 = Stream.of(Collections.emptyList());
        for (Object object : this.f_61048_.values()) {
            \u00e2\u02dc\u01925 = \u00e2\u02dc\u01925.flatMap(arg_0 -> StateDefinition.m_61070_((Property)object, arg_0));
        }
        \u00e2\u02dc\u01925.forEach(arg_0 -> StateDefinition.m_61057_(p_61054_, p_61053_, mapCodec, (Map)\u00e2\u02dc\u019232, \u00e2\u02dc\u01924, arg_0));
        for (Object object : \u00e2\u02dc\u01924) {
            ((StateHolder)object).m_61133_(\u00e2\u02dc\u019232);
        }
        this.f_61049_ = ImmutableList.copyOf((Collection)\u00e2\u02dc\u01924);
    }

    private static <S extends StateHolder<?, S>, T extends Comparable<T>> MapCodec<S> m_61076_(MapCodec<S> p_61077_, Supplier<S> p_61078_, String p_61079_, Property<T> p_61080_) {
        return Codec.mapPair(p_61077_, (MapCodec)p_61080_.m_61705_().fieldOf(p_61079_).setPartial(() -> p_61080_.m_61694_((StateHolder)p_61078_.get()))).xmap(p_61069_ -> (StateHolder)((StateHolder)p_61069_.getFirst()).m_61124_(p_61080_, ((Property.Value)p_61069_.getSecond()).m_61722_()), p_61066_ -> Pair.of((Object)p_61066_, p_61080_.m_61694_((StateHolder<?, ?>)p_61066_)));
    }

    public ImmutableList<S> m_61056_() {
        return this.f_61049_;
    }

    public S m_61090_() {
        return (S)((StateHolder)this.f_61049_.get(0));
    }

    public O m_61091_() {
        return this.f_61047_;
    }

    public Collection<Property<?>> m_61092_() {
        return this.f_61048_.values();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("block", this.f_61047_).add("properties", this.f_61048_.values().stream().map(Property::m_61708_).collect(Collectors.toList())).toString();
    }

    @Nullable
    public Property<?> m_61081_(String p_61082_) {
        return (Property)this.f_61048_.get((Object)p_61082_);
    }

    private static /* synthetic */ void m_61057_(Factory p_61058_, Object p_61059_, MapCodec p_61060_, Map p_61061_, List p_61062_, List p_61063_) {
        ImmutableMap immutableMap = (ImmutableMap)p_61063_.stream().collect(ImmutableMap.toImmutableMap(Pair::getFirst, Pair::getSecond));
        StateHolder \u00e2\u02dc\u01922 = (StateHolder)p_61058_.m_61106_(p_61059_, immutableMap, p_61060_);
        p_61061_.put(immutableMap, \u00e2\u02dc\u01922);
        p_61062_.add(\u00e2\u02dc\u01922);
    }

    private static /* synthetic */ Stream m_61070_(Property p_61071_, List p_61072_) {
        return p_61071_.m_6908_().stream().map(p_155961_ -> {
            ArrayList arrayList = Lists.newArrayList((Iterable)p_61072_);
            arrayList.add(Pair.of((Object)p_61071_, (Object)p_155961_));
            return arrayList;
        });
    }

    public static interface Factory<O, S> {
        public S m_61106_(O var1, ImmutableMap<Property<?>, Comparable<?>> var2, MapCodec<S> var3);
    }

    public static class Builder<O, S extends StateHolder<O, S>> {
        private final O f_61095_;
        private final Map<String, Property<?>> f_61096_ = Maps.newHashMap();

        public Builder(O p_61098_) {
            this.f_61095_ = p_61098_;
        }

        public Builder<O, S> m_61104_(Property<?> ... p_61105_) {
            for (Property<?> property : p_61105_) {
                this.m_61099_(property);
                this.f_61096_.put(property.m_61708_(), property);
            }
            return this;
        }

        private <T extends Comparable<T>> void m_61099_(Property<T> p_61100_) {
            String string = p_61100_.m_61708_();
            if (!f_61046_.matcher(string).matches()) {
                throw new IllegalArgumentException(this.f_61095_ + " has invalidly named property: " + string);
            }
            Collection<T> \u00e2\u02dc\u01922 = p_61100_.m_6908_();
            if (\u00e2\u02dc\u01922.size() <= 1) {
                throw new IllegalArgumentException(this.f_61095_ + " attempted use property " + string + " with <= 1 possible values");
            }
            for (Comparable comparable : \u00e2\u02dc\u01922) {
                String string2 = p_61100_.m_6940_(comparable);
                if (f_61046_.matcher(string2).matches()) continue;
                throw new IllegalArgumentException(this.f_61095_ + " has property: " + string + " with invalidly named value: " + string2);
            }
            if (this.f_61096_.containsKey(string)) {
                throw new IllegalArgumentException(this.f_61095_ + " has duplicate property: " + string);
            }
        }

        public StateDefinition<O, S> m_61101_(Function<O, S> p_61102_, Factory<O, S> p_61103_) {
            return new StateDefinition<O, S>(p_61102_, this.f_61095_, p_61103_, this.f_61096_);
        }
    }
}

