/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.data.worldgen.StructureFeatures;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkBiomeContainer;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.BaseStoneSource;
import net.minecraft.world.level.levelgen.DebugLevelSource;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.SingleBaseStoneSource;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.StrongholdConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;

public abstract class ChunkGenerator {
    public static final Codec<ChunkGenerator> f_62136_;
    protected final BiomeSource f_62137_;
    protected final BiomeSource f_62138_;
    private final StructureSettings f_62139_;
    private final long f_62140_;
    private final List<ChunkPos> f_62141_ = Lists.newArrayList();
    private final BaseStoneSource f_156149_;

    public ChunkGenerator(BiomeSource p_62149_, StructureSettings p_62150_) {
        this(p_62149_, p_62149_, p_62150_, 0L);
    }

    public ChunkGenerator(BiomeSource p_62144_, BiomeSource p_62145_, StructureSettings p_62146_, long p_62147_) {
        this.f_62137_ = p_62144_;
        this.f_62138_ = p_62145_;
        this.f_62139_ = p_62146_;
        this.f_62140_ = p_62147_;
        this.f_156149_ = new SingleBaseStoneSource(Blocks.f_50069_.m_49966_());
    }

    private void m_62219_() {
        if (!this.f_62141_.isEmpty()) {
            return;
        }
        StrongholdConfiguration strongholdConfiguration = this.f_62139_.m_64597_();
        if (strongholdConfiguration == null || strongholdConfiguration.m_68161_() == 0) {
            return;
        }
        ArrayList \u00e2\u02dc\u01922 = Lists.newArrayList();
        for (Biome biome : this.f_62137_.m_47922_()) {
            if (!biome.m_47536_().m_47808_(StructureFeature.f_67022_)) continue;
            \u00e2\u02dc\u01922.add(biome);
        }
        int \u00e2\u02dc\u01923 = strongholdConfiguration.m_68157_();
        int \u00e2\u02dc\u01924 = strongholdConfiguration.m_68161_();
        int \u00e2\u02dc\u01925 = strongholdConfiguration.m_68160_();
        Random \u00e2\u02dc\u01926 = new Random();
        \u00e2\u02dc\u01926.setSeed(this.f_62140_);
        double \u00e2\u02dc\u01927 = \u00e2\u02dc\u01926.nextDouble() * Math.PI * 2.0;
        int \u00e2\u02dc\u01928 = 0;
        int \u00e2\u02dc\u01929 = 0;
        for (int i = 0; i < \u00e2\u02dc\u01924; ++i) {
            double d = (double)(4 * \u00e2\u02dc\u01923 + \u00e2\u02dc\u01923 * \u00e2\u02dc\u01929 * 6) + (\u00e2\u02dc\u01926.nextDouble() - 0.5) * ((double)\u00e2\u02dc\u01923 * 2.5);
            int \u00e2\u02dc\u019210 = (int)Math.round(Math.cos(\u00e2\u02dc\u01927) * d);
            int \u00e2\u02dc\u019211 = (int)Math.round(Math.sin(\u00e2\u02dc\u01927) * d);
            BlockPos \u00e2\u02dc\u019212 = this.f_62137_.m_47909_(SectionPos.m_175554_(\u00e2\u02dc\u019210, 8), 0, SectionPos.m_175554_(\u00e2\u02dc\u019211, 8), 112, \u00e2\u02dc\u01922::contains, \u00e2\u02dc\u01926);
            if (\u00e2\u02dc\u019212 != null) {
                \u00e2\u02dc\u019210 = SectionPos.m_123171_(\u00e2\u02dc\u019212.m_123341_());
                \u00e2\u02dc\u019211 = SectionPos.m_123171_(\u00e2\u02dc\u019212.m_123343_());
            }
            this.f_62141_.add(new ChunkPos(\u00e2\u02dc\u019210, \u00e2\u02dc\u019211));
            \u00e2\u02dc\u01927 += Math.PI * 2 / (double)\u00e2\u02dc\u01925;
            if (++\u00e2\u02dc\u01928 != \u00e2\u02dc\u01925) continue;
            \u00e2\u02dc\u01928 = 0;
            \u00e2\u02dc\u01925 += 2 * \u00e2\u02dc\u01925 / (++\u00e2\u02dc\u01929 + 1);
            \u00e2\u02dc\u01925 = Math.min(\u00e2\u02dc\u01925, \u00e2\u02dc\u01924 - i);
            \u00e2\u02dc\u01927 += \u00e2\u02dc\u01926.nextDouble() * Math.PI * 2.0;
        }
    }

    protected abstract Codec<? extends ChunkGenerator> m_6909_();

    public abstract ChunkGenerator m_6819_(long var1);

    public void m_62196_(Registry<Biome> p_62197_, ChunkAccess p_62198_) {
        ChunkPos chunkPos = p_62198_.m_7697_();
        ((ProtoChunk)p_62198_).m_7329_(new ChunkBiomeContainer(p_62197_, p_62198_, chunkPos, this.f_62138_));
    }

    public void m_6013_(long p_62157_, BiomeManager p_62158_, ChunkAccess p_62159_, GenerationStep.Carving p_62160_) {
        BiomeManager biomeManager = p_62158_.m_47879_(this.f_62137_);
        WorldgenRandom \u00e2\u02dc\u01922 = new WorldgenRandom();
        int \u00e2\u02dc\u01923 = 8;
        ChunkPos \u00e2\u02dc\u01924 = p_62159_.m_7697_();
        CarvingContext \u00e2\u02dc\u01925 = new CarvingContext(this, p_62159_);
        Aquifer \u00e2\u02dc\u01926 = this.m_142439_(p_62159_);
        BitSet \u00e2\u02dc\u01927 = ((ProtoChunk)p_62159_).m_6547_(p_62160_);
        for (int i = -8; i <= 8; ++i) {
            for (\u00e2\u02dc\u0192 = -8; \u00e2\u02dc\u0192 <= 8; ++\u00e2\u02dc\u0192) {
                ChunkPos chunkPos = new ChunkPos(\u00e2\u02dc\u01924.f_45578_ + i, \u00e2\u02dc\u01924.f_45579_ + \u00e2\u02dc\u0192);
                BiomeGenerationSettings \u00e2\u02dc\u01928 = this.f_62137_.m_7158_(QuartPos.m_175400_(chunkPos.m_45604_()), 0, QuartPos.m_175400_(chunkPos.m_45605_())).m_47536_();
                List<Supplier<ConfiguredWorldCarver<?>>> \u00e2\u02dc\u01929 = \u00e2\u02dc\u01928.m_47799_(p_62160_);
                ListIterator<Supplier<ConfiguredWorldCarver<?>>> \u00e2\u02dc\u019210 = \u00e2\u02dc\u01929.listIterator();
                while (\u00e2\u02dc\u019210.hasNext()) {
                    int n = \u00e2\u02dc\u019210.nextIndex();
                    ConfiguredWorldCarver<?> \u00e2\u02dc\u019211 = \u00e2\u02dc\u019210.next().get();
                    \u00e2\u02dc\u01922.m_64703_(p_62157_ + (long)n, chunkPos.f_45578_, chunkPos.f_45579_);
                    if (!\u00e2\u02dc\u019211.m_159273_(\u00e2\u02dc\u01922)) continue;
                    \u00e2\u02dc\u019211.m_159265_(\u00e2\u02dc\u01925, p_62159_, biomeManager::m_47881_, \u00e2\u02dc\u01922, \u00e2\u02dc\u01926, chunkPos, \u00e2\u02dc\u01927);
                }
            }
        }
    }

    protected Aquifer m_142439_(ChunkAccess p_156162_) {
        return Aquifer.m_157956_(this.m_6337_(), Blocks.f_49990_.m_49966_());
    }

    @Nullable
    public BlockPos m_62161_(ServerLevel p_62162_, StructureFeature<?> p_62163_, BlockPos p_62164_, int p_62165_, boolean p_62166_) {
        if (!this.f_62137_.m_47917_(p_62163_)) {
            return null;
        }
        if (p_62163_ == StructureFeature.f_67022_) {
            this.m_62219_();
            BlockPos blockPos = null;
            double \u00e2\u02dc\u01922 = Double.MAX_VALUE;
            BlockPos.MutableBlockPos \u00e2\u02dc\u01923 = new BlockPos.MutableBlockPos();
            for (ChunkPos chunkPos : this.f_62141_) {
                \u00e2\u02dc\u01923.m_122178_(SectionPos.m_175554_(chunkPos.f_45578_, 8), 32, SectionPos.m_175554_(chunkPos.f_45579_, 8));
                double d = \u00e2\u02dc\u01923.m_123331_(p_62164_);
                if (blockPos == null) {
                    blockPos = new BlockPos(\u00e2\u02dc\u01923);
                    \u00e2\u02dc\u01922 = d;
                    continue;
                }
                if (!(d < \u00e2\u02dc\u01922)) continue;
                blockPos = new BlockPos(\u00e2\u02dc\u01923);
                \u00e2\u02dc\u01922 = d;
            }
            return blockPos;
        }
        StructureFeatureConfiguration structureFeatureConfiguration = this.f_62139_.m_64593_(p_62163_);
        if (structureFeatureConfiguration == null) {
            return null;
        }
        return p_62163_.m_67046_(p_62162_, p_62162_.m_8595_(), p_62164_, p_62165_, p_62166_, p_62162_.m_7328_(), structureFeatureConfiguration);
    }

    public void m_7399_(WorldGenRegion p_62168_, StructureFeatureManager p_62169_) {
        ChunkPos chunkPos = p_62168_.m_143488_();
        int \u00e2\u02dc\u01922 = chunkPos.m_45604_();
        int \u00e2\u02dc\u01923 = chunkPos.m_45605_();
        BlockPos \u00e2\u02dc\u01924 = new BlockPos(\u00e2\u02dc\u01922, p_62168_.m_141937_(), \u00e2\u02dc\u01923);
        Biome \u00e2\u02dc\u01925 = this.f_62137_.m_151754_(chunkPos);
        WorldgenRandom \u00e2\u02dc\u01926 = new WorldgenRandom();
        long \u00e2\u02dc\u01927 = \u00e2\u02dc\u01926.m_64690_(p_62168_.m_7328_(), \u00e2\u02dc\u01922, \u00e2\u02dc\u01923);
        try {
            \u00e2\u02dc\u01925.m_47484_(p_62169_, this, p_62168_, \u00e2\u02dc\u01927, \u00e2\u02dc\u01926, \u00e2\u02dc\u01924);
        }
        catch (Exception \u00e2\u02dc\u01928) {
            CrashReport crashReport = CrashReport.m_127521_(\u00e2\u02dc\u01928, "Biome decoration");
            crashReport.m_127514_("Generation").m_128159_("CenterX", chunkPos.f_45578_).m_128159_("CenterZ", chunkPos.f_45579_).m_128159_("Seed", \u00e2\u02dc\u01927).m_128159_("Biome", \u00e2\u02dc\u01925);
            throw new ReportedException(crashReport);
        }
    }

    public abstract void m_7338_(WorldGenRegion var1, ChunkAccess var2);

    public void m_6929_(WorldGenRegion p_62167_) {
    }

    public StructureSettings m_62205_() {
        return this.f_62139_;
    }

    public int m_142051_(LevelHeightAccessor p_156157_) {
        return 64;
    }

    public BiomeSource m_62218_() {
        return this.f_62138_;
    }

    public int m_6331_() {
        return 256;
    }

    public WeightedRandomList<MobSpawnSettings.SpawnerData> m_142184_(Biome p_156158_, StructureFeatureManager p_156159_, MobCategory p_156160_, BlockPos p_156161_) {
        return p_156158_.m_47518_().m_151798_(p_156160_);
    }

    public void m_62199_(RegistryAccess p_62200_, StructureFeatureManager p_62201_, ChunkAccess p_62202_, StructureManager p_62203_, long p_62204_) {
        Biome biome = this.f_62137_.m_151754_(p_62202_.m_7697_());
        this.m_156163_(StructureFeatures.f_127249_, p_62200_, p_62201_, p_62202_, p_62203_, p_62204_, biome);
        for (Supplier<ConfiguredStructureFeature<?, ?>> supplier : biome.m_47536_().m_47796_()) {
            this.m_156163_(supplier.get(), p_62200_, p_62201_, p_62202_, p_62203_, p_62204_, biome);
        }
    }

    private void m_156163_(ConfiguredStructureFeature<?, ?> p_156164_, RegistryAccess p_156165_, StructureFeatureManager p_156166_, ChunkAccess p_156167_, StructureManager p_156168_, long p_156169_, Biome p_156170_) {
        ChunkPos chunkPos = p_156167_.m_7697_();
        SectionPos \u00e2\u02dc\u01922 = SectionPos.m_175562_(p_156167_);
        StructureStart<?> \u00e2\u02dc\u01923 = p_156166_.m_47297_(\u00e2\u02dc\u01922, (StructureFeature<?>)p_156164_.f_65403_, p_156167_);
        int \u00e2\u02dc\u01924 = \u00e2\u02dc\u01923 != null ? \u00e2\u02dc\u01923.m_73608_() : 0;
        StructureFeatureConfiguration \u00e2\u02dc\u01925 = this.f_62139_.m_64593_((StructureFeature<?>)p_156164_.f_65403_);
        if (\u00e2\u02dc\u01925 != null) {
            StructureStart<?> structureStart = p_156164_.m_159524_(p_156165_, this, this.f_62137_, p_156168_, p_156169_, chunkPos, p_156170_, \u00e2\u02dc\u01924, \u00e2\u02dc\u01925, p_156167_);
            p_156166_.m_47301_(\u00e2\u02dc\u01922, (StructureFeature<?>)p_156164_.f_65403_, structureStart, p_156167_);
        }
    }

    public void m_62177_(WorldGenLevel p_62178_, StructureFeatureManager p_62179_, ChunkAccess p_62180_) {
        int n = 8;
        ChunkPos \u00e2\u02dc\u01922 = p_62180_.m_7697_();
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u01922.f_45578_;
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u01922.f_45579_;
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u01922.m_45604_();
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u01922.m_45605_();
        SectionPos \u00e2\u02dc\u01923 = SectionPos.m_175562_(p_62180_);
        for (\u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 - 8; \u00e2\u02dc\u0192 <= \u00e2\u02dc\u0192 + 8; ++\u00e2\u02dc\u0192) {
            for (\u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 - 8; \u00e2\u02dc\u0192 <= \u00e2\u02dc\u0192 + 8; ++\u00e2\u02dc\u0192) {
                long l = ChunkPos.m_45589_(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
                for (StructureStart<?> structureStart : p_62178_.m_6325_(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192).m_6633_().values()) {
                    try {
                        if (!structureStart.m_73603_() || !structureStart.m_73601_().m_71019_(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192 + 15, \u00e2\u02dc\u0192 + 15)) continue;
                        p_62179_.m_47292_(\u00e2\u02dc\u01923, structureStart.m_73610_(), l, p_62180_);
                        DebugPackets.m_133711_(p_62178_, structureStart);
                    }
                    catch (Exception exception) {
                        CrashReport crashReport = CrashReport.m_127521_(exception, "Generating structure reference");
                        CrashReportCategory \u00e2\u02dc\u01924 = crashReport.m_127514_("Structure");
                        \u00e2\u02dc\u01924.m_128165_("Id", () -> Registry.f_122841_.m_7981_(structureStart.m_73610_()).toString());
                        \u00e2\u02dc\u01924.m_128165_("Name", () -> structureStart.m_73610_().m_67098_());
                        \u00e2\u02dc\u01924.m_128165_("Class", () -> structureStart.m_73610_().getClass().getCanonicalName());
                        throw new ReportedException(crashReport);
                    }
                }
            }
        }
    }

    public abstract CompletableFuture<ChunkAccess> m_142189_(Executor var1, StructureFeatureManager var2, ChunkAccess var3);

    public int m_6337_() {
        return 63;
    }

    public int m_142062_() {
        return 0;
    }

    public abstract int m_142647_(int var1, int var2, Heightmap.Types var3, LevelHeightAccessor var4);

    public abstract NoiseColumn m_141914_(int var1, int var2, LevelHeightAccessor var3);

    public int m_156174_(int p_156175_, int p_156176_, Heightmap.Types p_156177_, LevelHeightAccessor p_156178_) {
        return this.m_142647_(p_156175_, p_156176_, p_156177_, p_156178_);
    }

    public int m_156179_(int p_156180_, int p_156181_, Heightmap.Types p_156182_, LevelHeightAccessor p_156183_) {
        return this.m_142647_(p_156180_, p_156181_, p_156182_, p_156183_) - 1;
    }

    public boolean m_62172_(ChunkPos p_62173_) {
        this.m_62219_();
        return this.f_62141_.contains(p_62173_);
    }

    public BaseStoneSource m_142168_() {
        return this.f_156149_;
    }

    static {
        Registry.m_122961_(Registry.f_122890_, "noise", NoiseBasedChunkGenerator.f_64314_);
        Registry.m_122961_(Registry.f_122890_, "flat", FlatLevelSource.f_64164_);
        Registry.m_122961_(Registry.f_122890_, "debug", DebugLevelSource.f_64111_);
        f_62136_ = Registry.f_122890_.dispatchStable(ChunkGenerator::m_6909_, Function.identity());
    }
}

