/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.TickList;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkBiomeContainer;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoTickList;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProtoChunk
implements ChunkAccess {
    private static final Logger f_63147_ = LogManager.getLogger();
    private final ChunkPos f_63148_;
    private volatile boolean f_63149_;
    @Nullable
    private ChunkBiomeContainer f_63150_;
    @Nullable
    private volatile LevelLightEngine f_63151_;
    private final Map<Heightmap.Types, Heightmap> f_63152_ = Maps.newEnumMap(Heightmap.Types.class);
    private volatile ChunkStatus f_63153_ = ChunkStatus.f_62314_;
    private final Map<BlockPos, BlockEntity> f_63154_ = Maps.newHashMap();
    private final Map<BlockPos, CompoundTag> f_63155_ = Maps.newHashMap();
    private final LevelChunkSection[] f_63156_;
    private final List<CompoundTag> f_63157_ = Lists.newArrayList();
    private final List<BlockPos> f_63158_ = Lists.newArrayList();
    private final ShortList[] f_63159_;
    private final Map<StructureFeature<?>, StructureStart<?>> f_63160_ = Maps.newHashMap();
    private final Map<StructureFeature<?>, LongSet> f_63161_ = Maps.newHashMap();
    private final UpgradeData f_63162_;
    private final ProtoTickList<Block> f_63163_;
    private final ProtoTickList<Fluid> f_63164_;
    private final LevelHeightAccessor f_156475_;
    private long f_63165_;
    private final Map<GenerationStep.Carving, BitSet> f_63166_ = new Object2ObjectArrayMap();
    private volatile boolean f_63167_;

    public ProtoChunk(ChunkPos p_156477_, UpgradeData p_156478_, LevelHeightAccessor p_156479_) {
        this(p_156477_, p_156478_, null, new ProtoTickList<Block>(p_63185_ -> p_63185_ == null || p_63185_.m_49966_().m_60795_(), p_156477_, p_156479_), new ProtoTickList<Fluid>(p_63212_ -> p_63212_ == null || p_63212_ == Fluids.f_76191_, p_156477_, p_156479_), p_156479_);
    }

    public ProtoChunk(ChunkPos p_156481_, UpgradeData p_156482_, @Nullable LevelChunkSection[] p_156483_, ProtoTickList<Block> p_156484_, ProtoTickList<Fluid> p_156485_, LevelHeightAccessor p_156486_) {
        this.f_63148_ = p_156481_;
        this.f_63162_ = p_156482_;
        this.f_63163_ = p_156484_;
        this.f_63164_ = p_156485_;
        this.f_156475_ = p_156486_;
        this.f_63156_ = new LevelChunkSection[p_156486_.m_151559_()];
        if (p_156483_ != null) {
            if (this.f_63156_.length == p_156483_.length) {
                System.arraycopy(p_156483_, 0, this.f_63156_, 0, this.f_63156_.length);
            } else {
                f_63147_.warn("Could not set level chunk sections, array length is {} instead of {}", (Object)p_156483_.length, (Object)this.f_63156_.length);
            }
        }
        this.f_63159_ = new ShortList[p_156486_.m_151559_()];
    }

    @Override
    public BlockState m_8055_(BlockPos p_63264_) {
        int n = p_63264_.m_123342_();
        if (this.m_151562_(n)) {
            return Blocks.f_50626_.m_49966_();
        }
        LevelChunkSection \u00e2\u02dc\u01922 = this.m_7103_()[this.m_151564_(n)];
        if (LevelChunkSection.m_63000_(\u00e2\u02dc\u01922)) {
            return Blocks.f_50016_.m_49966_();
        }
        return \u00e2\u02dc\u01922.m_62982_(p_63264_.m_123341_() & 0xF, n & 0xF, p_63264_.m_123343_() & 0xF);
    }

    @Override
    public FluidState m_6425_(BlockPos p_63239_) {
        int n = p_63239_.m_123342_();
        if (this.m_151562_(n)) {
            return Fluids.f_76191_.m_76145_();
        }
        LevelChunkSection \u00e2\u02dc\u01922 = this.m_7103_()[this.m_151564_(n)];
        if (LevelChunkSection.m_63000_(\u00e2\u02dc\u01922)) {
            return Fluids.f_76191_.m_76145_();
        }
        return \u00e2\u02dc\u01922.m_63007_(p_63239_.m_123341_() & 0xF, n & 0xF, p_63239_.m_123343_() & 0xF);
    }

    @Override
    public Stream<BlockPos> m_6267_() {
        return this.f_63158_.stream();
    }

    public ShortList[] m_63291_() {
        ShortList[] shortListArray = new ShortList[this.m_151559_()];
        for (BlockPos blockPos : this.f_63158_) {
            ChunkAccess.m_62095_(shortListArray, this.m_151564_(blockPos.m_123342_())).add(ProtoChunk.m_63280_(blockPos));
        }
        return shortListArray;
    }

    public void m_63244_(short p_63245_, int p_63246_) {
        this.m_63277_(ProtoChunk.m_63227_(p_63245_, this.m_151568_(p_63246_), this.f_63148_));
    }

    public void m_63277_(BlockPos p_63278_) {
        this.f_63158_.add(p_63278_.m_7949_());
    }

    @Override
    @Nullable
    public BlockState m_6978_(BlockPos p_63217_, BlockState p_63218_, boolean p_63219_) {
        int n = p_63217_.m_123341_();
        \u00e2\u02dc\u0192 = p_63217_.m_123342_();
        \u00e2\u02dc\u0192 = p_63217_.m_123343_();
        if (\u00e2\u02dc\u0192 < this.m_141937_() || \u00e2\u02dc\u0192 >= this.m_151558_()) {
            return Blocks.f_50626_.m_49966_();
        }
        \u00e2\u02dc\u0192 = this.m_151564_(\u00e2\u02dc\u0192);
        if (this.f_63156_[\u00e2\u02dc\u0192] == LevelChunk.f_62770_ && p_63218_.m_60713_(Blocks.f_50016_)) {
            return p_63218_;
        }
        if (p_63218_.m_60791_() > 0) {
            this.f_63158_.add(new BlockPos((n & 0xF) + this.m_7697_().m_45604_(), \u00e2\u02dc\u0192, (\u00e2\u02dc\u0192 & 0xF) + this.m_7697_().m_45605_()));
        }
        LevelChunkSection \u00e2\u02dc\u01922 = this.m_156115_(\u00e2\u02dc\u0192);
        BlockState \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922.m_62986_(n & 0xF, \u00e2\u02dc\u0192 & 0xF, \u00e2\u02dc\u0192 & 0xF, p_63218_);
        if (this.f_63153_.m_62427_(ChunkStatus.f_62322_) && p_63218_ != \u00e2\u02dc\u01923 && (p_63218_.m_60739_(this, p_63217_) != \u00e2\u02dc\u01923.m_60739_(this, p_63217_) || p_63218_.m_60791_() != \u00e2\u02dc\u01923.m_60791_() || p_63218_.m_60787_() || \u00e2\u02dc\u01923.m_60787_())) {
            this.f_63151_.m_142202_(p_63217_);
        }
        EnumSet<Heightmap.Types> \u00e2\u02dc\u01924 = this.m_6415_().m_62500_();
        EnumSet<Heightmap.Types> \u00e2\u02dc\u01925 = null;
        for (Heightmap.Types types : \u00e2\u02dc\u01924) {
            Heightmap heightmap = this.f_63152_.get(types);
            if (heightmap != null) continue;
            if (\u00e2\u02dc\u01925 == null) {
                \u00e2\u02dc\u01925 = EnumSet.noneOf(Heightmap.Types.class);
            }
            \u00e2\u02dc\u01925.add(types);
        }
        if (\u00e2\u02dc\u01925 != null) {
            Heightmap.m_64256_(this, \u00e2\u02dc\u01925);
        }
        for (Heightmap.Types types : \u00e2\u02dc\u01924) {
            this.f_63152_.get(types).m_64249_(n & 0xF, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192 & 0xF, p_63218_);
        }
        return \u00e2\u02dc\u01923;
    }

    @Override
    public void m_142169_(BlockEntity p_156488_) {
        this.f_63154_.put(p_156488_.m_58899_(), p_156488_);
    }

    @Override
    public Set<BlockPos> m_5928_() {
        HashSet hashSet = Sets.newHashSet(this.f_63155_.keySet());
        hashSet.addAll(this.f_63154_.keySet());
        return hashSet;
    }

    @Override
    @Nullable
    public BlockEntity m_7702_(BlockPos p_63257_) {
        return this.f_63154_.get(p_63257_);
    }

    public Map<BlockPos, BlockEntity> m_63292_() {
        return this.f_63154_;
    }

    public void m_63242_(CompoundTag p_63243_) {
        this.f_63157_.add(p_63243_);
    }

    @Override
    public void m_6286_(Entity p_63183_) {
        if (p_63183_.m_20159_()) {
            return;
        }
        CompoundTag compoundTag = new CompoundTag();
        p_63183_.m_20223_(compoundTag);
        this.m_63242_(compoundTag);
    }

    public List<CompoundTag> m_63293_() {
        return this.f_63157_;
    }

    public void m_7329_(ChunkBiomeContainer p_63186_) {
        this.f_63150_ = p_63186_;
    }

    @Override
    @Nullable
    public ChunkBiomeContainer m_6221_() {
        return this.f_63150_;
    }

    @Override
    public void m_8092_(boolean p_63232_) {
        this.f_63149_ = p_63232_;
    }

    @Override
    public boolean m_6344_() {
        return this.f_63149_;
    }

    @Override
    public ChunkStatus m_6415_() {
        return this.f_63153_;
    }

    public void m_7150_(ChunkStatus p_63187_) {
        this.f_63153_ = p_63187_;
        this.m_8092_(true);
    }

    @Override
    public LevelChunkSection[] m_7103_() {
        return this.f_63156_;
    }

    @Override
    public Collection<Map.Entry<Heightmap.Types, Heightmap>> m_6890_() {
        return Collections.unmodifiableSet(this.f_63152_.entrySet());
    }

    @Override
    public Heightmap m_6005_(Heightmap.Types p_63193_) {
        return this.f_63152_.computeIfAbsent(p_63193_, p_63253_ -> new Heightmap(this, (Heightmap.Types)p_63253_));
    }

    @Override
    public int m_5885_(Heightmap.Types p_63195_, int p_63196_, int p_63197_) {
        Heightmap heightmap = this.f_63152_.get(p_63195_);
        if (heightmap == null) {
            Heightmap.m_64256_(this, EnumSet.of(p_63195_));
            heightmap = this.f_63152_.get(p_63195_);
        }
        return heightmap.m_64242_(p_63196_ & 0xF, p_63197_ & 0xF) - 1;
    }

    @Override
    public BlockPos m_142241_(Heightmap.Types p_156490_) {
        int n = this.m_141937_();
        BlockPos.MutableBlockPos \u00e2\u02dc\u01922 = new BlockPos.MutableBlockPos();
        for (\u00e2\u02dc\u0192 = this.f_63148_.m_45604_(); \u00e2\u02dc\u0192 <= this.f_63148_.m_45608_(); ++\u00e2\u02dc\u0192) {
            for (\u00e2\u02dc\u0192 = this.f_63148_.m_45605_(); \u00e2\u02dc\u0192 <= this.f_63148_.m_45609_(); ++\u00e2\u02dc\u0192) {
                \u00e2\u02dc\u0192 = this.m_5885_(p_156490_, \u00e2\u02dc\u0192 & 0xF, \u00e2\u02dc\u0192 & 0xF);
                if (\u00e2\u02dc\u0192 <= n) continue;
                n = \u00e2\u02dc\u0192;
                \u00e2\u02dc\u01922.m_122178_(\u00e2\u02dc\u0192, n, \u00e2\u02dc\u0192);
            }
        }
        return \u00e2\u02dc\u01922.m_7949_();
    }

    @Override
    public ChunkPos m_7697_() {
        return this.f_63148_;
    }

    @Override
    @Nullable
    public StructureStart<?> m_7253_(StructureFeature<?> p_63202_) {
        return this.f_63160_.get(p_63202_);
    }

    @Override
    public void m_8078_(StructureFeature<?> p_63207_, StructureStart<?> p_63208_) {
        this.f_63160_.put(p_63207_, p_63208_);
        this.f_63149_ = true;
    }

    @Override
    public Map<StructureFeature<?>, StructureStart<?>> m_6633_() {
        return Collections.unmodifiableMap(this.f_63160_);
    }

    @Override
    public void m_8040_(Map<StructureFeature<?>, StructureStart<?>> p_63221_) {
        this.f_63160_.clear();
        this.f_63160_.putAll(p_63221_);
        this.f_63149_ = true;
    }

    @Override
    public LongSet m_6705_(StructureFeature<?> p_63237_) {
        return this.f_63161_.computeIfAbsent(p_63237_, p_63260_ -> new LongOpenHashSet());
    }

    @Override
    public void m_6306_(StructureFeature<?> p_63204_, long p_63205_) {
        this.f_63161_.computeIfAbsent(p_63204_, p_63255_ -> new LongOpenHashSet()).add(p_63205_);
        this.f_63149_ = true;
    }

    @Override
    public Map<StructureFeature<?>, LongSet> m_7049_() {
        return Collections.unmodifiableMap(this.f_63161_);
    }

    @Override
    public void m_7946_(Map<StructureFeature<?>, LongSet> p_63241_) {
        this.f_63161_.clear();
        this.f_63161_.putAll(p_63241_);
        this.f_63149_ = true;
    }

    public static short m_63280_(BlockPos p_63281_) {
        int n = p_63281_.m_123341_();
        \u00e2\u02dc\u0192 = p_63281_.m_123342_();
        \u00e2\u02dc\u0192 = p_63281_.m_123343_();
        \u00e2\u02dc\u0192 = n & 0xF;
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 & 0xF;
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 & 0xF;
        return (short)(\u00e2\u02dc\u0192 | \u00e2\u02dc\u0192 << 4 | \u00e2\u02dc\u0192 << 8);
    }

    public static BlockPos m_63227_(short p_63228_, int p_63229_, ChunkPos p_63230_) {
        int n = SectionPos.m_175554_(p_63230_.f_45578_, p_63228_ & 0xF);
        \u00e2\u02dc\u0192 = SectionPos.m_175554_(p_63229_, p_63228_ >>> 4 & 0xF);
        \u00e2\u02dc\u0192 = SectionPos.m_175554_(p_63230_.f_45579_, p_63228_ >>> 8 & 0xF);
        return new BlockPos(n, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
    }

    @Override
    public void m_8113_(BlockPos p_63266_) {
        if (!this.m_151570_(p_63266_)) {
            ChunkAccess.m_62095_(this.f_63159_, this.m_151564_(p_63266_.m_123342_())).add(ProtoChunk.m_63280_(p_63266_));
        }
    }

    @Override
    public ShortList[] m_6720_() {
        return this.f_63159_;
    }

    @Override
    public void m_6561_(short p_63225_, int p_63226_) {
        ChunkAccess.m_62095_(this.f_63159_, p_63226_).add(p_63225_);
    }

    public ProtoTickList<Block> m_5782_() {
        return this.f_63163_;
    }

    public ProtoTickList<Fluid> m_5783_() {
        return this.f_63164_;
    }

    @Override
    public UpgradeData m_7387_() {
        return this.f_63162_;
    }

    @Override
    public void m_6141_(long p_63234_) {
        this.f_63165_ = p_63234_;
    }

    @Override
    public long m_6319_() {
        return this.f_63165_;
    }

    @Override
    public void m_5604_(CompoundTag p_63223_) {
        this.f_63155_.put(new BlockPos(p_63223_.m_128451_("x"), p_63223_.m_128451_("y"), p_63223_.m_128451_("z")), p_63223_);
    }

    public Map<BlockPos, CompoundTag> m_63294_() {
        return Collections.unmodifiableMap(this.f_63155_);
    }

    @Override
    public CompoundTag m_8049_(BlockPos p_63272_) {
        return this.f_63155_.get(p_63272_);
    }

    @Override
    @Nullable
    public CompoundTag m_8051_(BlockPos p_63275_) {
        BlockEntity blockEntity = this.m_7702_(p_63275_);
        if (blockEntity != null) {
            return blockEntity.m_6945_(new CompoundTag());
        }
        return this.f_63155_.get(p_63275_);
    }

    @Override
    public void m_8114_(BlockPos p_63262_) {
        this.f_63154_.remove(p_63262_);
        this.f_63155_.remove(p_63262_);
    }

    @Nullable
    public BitSet m_6548_(GenerationStep.Carving p_63188_) {
        return this.f_63166_.get(p_63188_);
    }

    public BitSet m_6547_(GenerationStep.Carving p_63235_) {
        return this.f_63166_.computeIfAbsent(p_63235_, p_63251_ -> new BitSet(65536));
    }

    public void m_63189_(GenerationStep.Carving p_63190_, BitSet p_63191_) {
        this.f_63166_.put(p_63190_, p_63191_);
    }

    public void m_63209_(LevelLightEngine p_63210_) {
        this.f_63151_ = p_63210_;
    }

    @Override
    public boolean m_6332_() {
        return this.f_63167_;
    }

    @Override
    public void m_8094_(boolean p_63248_) {
        this.f_63167_ = p_63248_;
        this.m_8092_(true);
    }

    @Override
    public int m_141937_() {
        return this.f_156475_.m_141937_();
    }

    @Override
    public int m_141928_() {
        return this.f_156475_.m_141928_();
    }

    public /* synthetic */ TickList m_5783_() {
        return this.m_5783_();
    }

    public /* synthetic */ TickList m_5782_() {
        return this.m_5782_();
    }
}

