/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Direction8;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.StemGrownBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpgradeData {
    private static final Logger f_63321_ = LogManager.getLogger();
    public static final UpgradeData f_63320_ = new UpgradeData(EmptyBlockGetter.INSTANCE);
    private static final String f_156504_ = "Indices";
    private static final Direction8[] f_63322_ = Direction8.values();
    private final EnumSet<Direction8> f_63323_ = EnumSet.noneOf(Direction8.class);
    private final int[][] f_63324_;
    static final Map<Block, BlockFixer> f_63325_ = new IdentityHashMap<Block, BlockFixer>();
    static final Set<BlockFixer> f_63326_ = Sets.newHashSet();

    private UpgradeData(LevelHeightAccessor p_156506_) {
        this.f_63324_ = new int[p_156506_.m_151559_()][];
    }

    public UpgradeData(CompoundTag p_156508_, LevelHeightAccessor p_156509_) {
        this(p_156509_);
        if (p_156508_.m_128425_(f_156504_, 10)) {
            CompoundTag compoundTag = p_156508_.m_128469_(f_156504_);
            for (int i = 0; i < this.f_63324_.length; ++i) {
                String string = String.valueOf(i);
                if (!compoundTag.m_128425_(string, 11)) continue;
                this.f_63324_[i] = compoundTag.m_128465_(string);
            }
        }
        int n = p_156508_.m_128451_("Sides");
        for (Direction8 direction8 : Direction8.values()) {
            if ((n & 1 << direction8.ordinal()) == 0) continue;
            this.f_63323_.add(direction8);
        }
    }

    public void m_63341_(LevelChunk p_63342_) {
        this.m_63347_(p_63342_);
        for (Direction8 direction8 : f_63322_) {
            UpgradeData.m_63343_(p_63342_, direction8);
        }
        Level level = p_63342_.m_62953_();
        f_63326_.forEach(p_63334_ -> p_63334_.m_5870_(level));
    }

    private static void m_63343_(LevelChunk p_63344_, Direction8 p_63345_) {
        Level level = p_63344_.m_62953_();
        if (!p_63344_.m_7387_().f_63323_.remove((Object)p_63345_)) {
            return;
        }
        Set<Direction> \u00e2\u02dc\u01922 = p_63345_.m_122593_();
        boolean \u00e2\u02dc\u01923 = false;
        int \u00e2\u02dc\u01924 = 15;
        boolean \u00e2\u02dc\u01925 = \u00e2\u02dc\u01922.contains(Direction.EAST);
        boolean \u00e2\u02dc\u01926 = \u00e2\u02dc\u01922.contains(Direction.WEST);
        boolean \u00e2\u02dc\u01927 = \u00e2\u02dc\u01922.contains(Direction.SOUTH);
        boolean \u00e2\u02dc\u01928 = \u00e2\u02dc\u01922.contains(Direction.NORTH);
        boolean \u00e2\u02dc\u01929 = \u00e2\u02dc\u01922.size() == 1;
        ChunkPos \u00e2\u02dc\u019210 = p_63344_.m_7697_();
        int \u00e2\u02dc\u019211 = \u00e2\u02dc\u019210.m_45604_() + (\u00e2\u02dc\u01929 && (\u00e2\u02dc\u01928 || \u00e2\u02dc\u01927) ? 1 : (\u00e2\u02dc\u01926 ? 0 : 15));
        int \u00e2\u02dc\u019212 = \u00e2\u02dc\u019210.m_45604_() + (\u00e2\u02dc\u01929 && (\u00e2\u02dc\u01928 || \u00e2\u02dc\u01927) ? 14 : (\u00e2\u02dc\u01926 ? 0 : 15));
        int \u00e2\u02dc\u019213 = \u00e2\u02dc\u019210.m_45605_() + (\u00e2\u02dc\u01929 && (\u00e2\u02dc\u01925 || \u00e2\u02dc\u01926) ? 1 : (\u00e2\u02dc\u01928 ? 0 : 15));
        int \u00e2\u02dc\u019214 = \u00e2\u02dc\u019210.m_45605_() + (\u00e2\u02dc\u01929 && (\u00e2\u02dc\u01925 || \u00e2\u02dc\u01926) ? 14 : (\u00e2\u02dc\u01928 ? 0 : 15));
        Direction[] \u00e2\u02dc\u019215 = Direction.values();
        BlockPos.MutableBlockPos \u00e2\u02dc\u019216 = new BlockPos.MutableBlockPos();
        for (BlockPos blockPos : BlockPos.m_121976_(\u00e2\u02dc\u019211, level.m_141937_(), \u00e2\u02dc\u019213, \u00e2\u02dc\u019212, level.m_151558_() - 1, \u00e2\u02dc\u019214)) {
            BlockState blockState;
            BlockState blockState2 = blockState = level.m_8055_(blockPos);
            for (Direction direction : \u00e2\u02dc\u019215) {
                \u00e2\u02dc\u019216.m_122159_(blockPos, direction);
                blockState2 = UpgradeData.m_63335_(blockState2, direction, level, blockPos, \u00e2\u02dc\u019216);
            }
            Block.m_49902_(blockState, blockState2, level, blockPos, 18);
        }
    }

    private static BlockState m_63335_(BlockState p_63336_, Direction p_63337_, LevelAccessor p_63338_, BlockPos p_63339_, BlockPos p_63340_) {
        return f_63325_.getOrDefault(p_63336_.m_60734_(), BlockFixers.DEFAULT).m_5731_(p_63336_, p_63337_, p_63338_.m_8055_(p_63340_), p_63338_, p_63339_, p_63340_);
    }

    private void m_63347_(LevelChunk p_63348_) {
        int n;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        \u00e2\u02dc\u0192 = new BlockPos.MutableBlockPos();
        ChunkPos \u00e2\u02dc\u01922 = p_63348_.m_7697_();
        Level \u00e2\u02dc\u01923 = p_63348_.m_62953_();
        for (n = 0; n < this.f_63324_.length; ++n) {
            LevelChunkSection levelChunkSection = p_63348_.m_7103_()[n];
            int[] \u00e2\u02dc\u01924 = this.f_63324_[n];
            this.f_63324_[n] = null;
            if (levelChunkSection == null || \u00e2\u02dc\u01924 == null || \u00e2\u02dc\u01924.length <= 0) continue;
            Direction[] \u00e2\u02dc\u01925 = Direction.values();
            PalettedContainer<BlockState> \u00e2\u02dc\u01926 = levelChunkSection.m_63019_();
            for (int n2 : \u00e2\u02dc\u01924) {
                BlockState blockState;
                \u00e2\u02dc\u0192 = n2 & 0xF;
                \u00e2\u02dc\u0192 = n2 >> 8 & 0xF;
                \u00e2\u02dc\u0192 = n2 >> 4 & 0xF;
                mutableBlockPos.m_122178_(\u00e2\u02dc\u01922.m_45604_() + \u00e2\u02dc\u0192, levelChunkSection.m_63017_() + \u00e2\u02dc\u0192, \u00e2\u02dc\u01922.m_45605_() + \u00e2\u02dc\u0192);
                BlockState blockState2 = blockState = \u00e2\u02dc\u01926.m_63085_(n2);
                for (Direction direction : \u00e2\u02dc\u01925) {
                    \u00e2\u02dc\u0192.m_122159_(mutableBlockPos, direction);
                    if (SectionPos.m_123171_(mutableBlockPos.m_123341_()) != \u00e2\u02dc\u01922.f_45578_ || SectionPos.m_123171_(mutableBlockPos.m_123343_()) != \u00e2\u02dc\u01922.f_45579_) continue;
                    blockState2 = UpgradeData.m_63335_(blockState2, direction, \u00e2\u02dc\u01923, mutableBlockPos, \u00e2\u02dc\u0192);
                }
                Block.m_49902_(blockState, blockState2, \u00e2\u02dc\u01923, mutableBlockPos, 18);
            }
        }
        for (n = 0; n < this.f_63324_.length; ++n) {
            if (this.f_63324_[n] != null) {
                f_63321_.warn("Discarding update data for section {} for chunk ({} {})", (Object)\u00e2\u02dc\u01923.m_151568_(n), (Object)\u00e2\u02dc\u01922.f_45578_, (Object)\u00e2\u02dc\u01922.f_45579_);
            }
            this.f_63324_[n] = null;
        }
    }

    public boolean m_63331_() {
        for (int[] nArray : this.f_63324_) {
            if (nArray == null) continue;
            return false;
        }
        return this.f_63323_.isEmpty();
    }

    public CompoundTag m_63346_() {
        CompoundTag compoundTag;
        int n;
        CompoundTag compoundTag2 = new CompoundTag();
        compoundTag = new CompoundTag();
        for (n = 0; n < this.f_63324_.length; ++n) {
            String string = String.valueOf(n);
            if (this.f_63324_[n] == null || this.f_63324_[n].length == 0) continue;
            compoundTag.m_128385_(string, this.f_63324_[n]);
        }
        if (!compoundTag.m_128456_()) {
            compoundTag2.m_128365_(f_156504_, compoundTag);
        }
        n = 0;
        for (Direction8 direction8 : this.f_63323_) {
            n |= 1 << direction8.ordinal();
        }
        compoundTag2.m_128344_("Sides", (byte)n);
        return compoundTag2;
    }

    static abstract class BlockFixers
    extends Enum<BlockFixers>
    implements BlockFixer {
        public static final /* enum */ BlockFixers BLACKLIST = new BlockFixers(new Block[]{Blocks.f_50455_, Blocks.f_50142_, Blocks.f_50506_, Blocks.f_50507_, Blocks.f_50508_, Blocks.f_50509_, Blocks.f_50510_, Blocks.f_50511_, Blocks.f_50512_, Blocks.f_50513_, Blocks.f_50514_, Blocks.f_50515_, Blocks.f_50516_, Blocks.f_50517_, Blocks.f_50518_, Blocks.f_50519_, Blocks.f_50573_, Blocks.f_50574_, Blocks.f_50322_, Blocks.f_50323_, Blocks.f_50324_, Blocks.f_50260_, Blocks.f_49994_, Blocks.f_49992_, Blocks.f_49993_, Blocks.f_50095_, Blocks.f_50149_, Blocks.f_50150_, Blocks.f_50151_, Blocks.f_50152_, Blocks.f_50153_, Blocks.f_50158_, Blocks.f_50159_, Blocks.f_50160_, Blocks.f_50161_, Blocks.f_50162_, Blocks.f_50163_}){

            @Override
            public BlockState m_5731_(BlockState p_63394_, Direction p_63395_, BlockState p_63396_, LevelAccessor p_63397_, BlockPos p_63398_, BlockPos p_63399_) {
                return p_63394_;
            }
        };
        public static final /* enum */ BlockFixers DEFAULT = new BlockFixers(new Block[0]){

            @Override
            public BlockState m_5731_(BlockState p_63405_, Direction p_63406_, BlockState p_63407_, LevelAccessor p_63408_, BlockPos p_63409_, BlockPos p_63410_) {
                return p_63405_.m_60728_(p_63406_, p_63408_.m_8055_(p_63410_), p_63408_, p_63409_, p_63410_);
            }
        };
        public static final /* enum */ BlockFixers CHEST = new BlockFixers(new Block[]{Blocks.f_50087_, Blocks.f_50325_}){

            @Override
            public BlockState m_5731_(BlockState p_63416_, Direction p_63417_, BlockState p_63418_, LevelAccessor p_63419_, BlockPos p_63420_, BlockPos p_63421_) {
                if (p_63418_.m_60713_(p_63416_.m_60734_()) && p_63417_.m_122434_().m_122479_() && p_63416_.m_61143_(ChestBlock.f_51479_) == ChestType.SINGLE && p_63418_.m_61143_(ChestBlock.f_51479_) == ChestType.SINGLE) {
                    Direction direction = p_63416_.m_61143_(ChestBlock.f_51478_);
                    if (p_63417_.m_122434_() != direction.m_122434_() && direction == p_63418_.m_61143_(ChestBlock.f_51478_)) {
                        ChestType chestType = p_63417_ == direction.m_122427_() ? ChestType.LEFT : ChestType.RIGHT;
                        p_63419_.m_7731_(p_63421_, (BlockState)p_63418_.m_61124_(ChestBlock.f_51479_, chestType.m_61486_()), 18);
                        if (direction == Direction.NORTH || direction == Direction.EAST) {
                            BlockEntity blockEntity = p_63419_.m_7702_(p_63420_);
                            \u00e2\u02dc\u0192 = p_63419_.m_7702_(p_63421_);
                            if (blockEntity instanceof ChestBlockEntity && \u00e2\u02dc\u0192 instanceof ChestBlockEntity) {
                                ChestBlockEntity.m_59103_((ChestBlockEntity)blockEntity, (ChestBlockEntity)\u00e2\u02dc\u0192);
                            }
                        }
                        return (BlockState)p_63416_.m_61124_(ChestBlock.f_51479_, chestType);
                    }
                }
                return p_63416_;
            }
        };
        public static final /* enum */ BlockFixers LEAVES = new BlockFixers(true, new Block[]{Blocks.f_50054_, Blocks.f_50052_, Blocks.f_50055_, Blocks.f_50053_, Blocks.f_50050_, Blocks.f_50051_}){
            private final ThreadLocal<List<ObjectSet<BlockPos>>> f_63422_ = ThreadLocal.withInitial(() -> Lists.newArrayListWithCapacity((int)7));

            @Override
            public BlockState m_5731_(BlockState p_63432_, Direction p_63433_, BlockState p_63434_, LevelAccessor p_63435_, BlockPos p_63436_, BlockPos p_63437_) {
                BlockState blockState = p_63432_.m_60728_(p_63433_, p_63435_.m_8055_(p_63437_), p_63435_, p_63436_, p_63437_);
                if (p_63432_ != blockState) {
                    int n = blockState.m_61143_(BlockStateProperties.f_61414_);
                    List<ObjectSet<BlockPos>> \u00e2\u02dc\u01922 = this.f_63422_.get();
                    if (\u00e2\u02dc\u01922.isEmpty()) {
                        for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < 7; ++\u00e2\u02dc\u0192) {
                            \u00e2\u02dc\u01922.add((ObjectSet<BlockPos>)new ObjectOpenHashSet());
                        }
                    }
                    \u00e2\u02dc\u01922.get(n).add((Object)p_63436_.m_7949_());
                }
                return p_63432_;
            }

            @Override
            public void m_5870_(LevelAccessor p_63430_) {
                BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
                List<ObjectSet<BlockPos>> \u00e2\u02dc\u01922 = this.f_63422_.get();
                for (int i = 2; i < \u00e2\u02dc\u01922.size(); ++i) {
                    \u00e2\u02dc\u0192 = i - 1;
                    ObjectSet<BlockPos> objectSet = \u00e2\u02dc\u01922.get(\u00e2\u02dc\u0192);
                    \u00e2\u02dc\u0192 = \u00e2\u02dc\u01922.get(i);
                    for (BlockPos blockPos : objectSet) {
                        BlockState blockState = p_63430_.m_8055_(blockPos);
                        if (blockState.m_61143_(BlockStateProperties.f_61414_) < \u00e2\u02dc\u0192) continue;
                        p_63430_.m_7731_(blockPos, (BlockState)blockState.m_61124_(BlockStateProperties.f_61414_, \u00e2\u02dc\u0192), 18);
                        if (i == 7) continue;
                        for (Direction direction : f_63363_) {
                            mutableBlockPos.m_122159_(blockPos, direction);
                            BlockState blockState2 = p_63430_.m_8055_(mutableBlockPos);
                            if (!blockState2.m_61138_(BlockStateProperties.f_61414_) || blockState.m_61143_(BlockStateProperties.f_61414_) <= i) continue;
                            \u00e2\u02dc\u0192.add((Object)mutableBlockPos.m_7949_());
                        }
                    }
                }
                \u00e2\u02dc\u01922.clear();
            }
        };
        public static final /* enum */ BlockFixers STEM_BLOCK = new BlockFixers(new Block[]{Blocks.f_50190_, Blocks.f_50189_}){

            @Override
            public BlockState m_5731_(BlockState p_63443_, Direction p_63444_, BlockState p_63445_, LevelAccessor p_63446_, BlockPos p_63447_, BlockPos p_63448_) {
                StemGrownBlock stemGrownBlock;
                if (p_63443_.m_61143_(StemBlock.f_57013_) == 7 && p_63445_.m_60713_(stemGrownBlock = ((StemBlock)p_63443_.m_60734_()).m_57056_())) {
                    return (BlockState)stemGrownBlock.m_7810_().m_49966_().m_61124_(HorizontalDirectionalBlock.f_54117_, p_63444_);
                }
                return p_63443_;
            }
        };
        public static final Direction[] f_63363_;
        private static final /* synthetic */ BlockFixers[] $VALUES;

        public static BlockFixers[] values() {
            return (BlockFixers[])$VALUES.clone();
        }

        public static BlockFixers valueOf(String p_63387_) {
            return Enum.valueOf(BlockFixers.class, p_63387_);
        }

        BlockFixers(Block ... p_63380_) {
            this(false, p_63380_);
        }

        BlockFixers(boolean p_63369_, Block ... p_63370_) {
            for (Block block : p_63370_) {
                f_63325_.put(block, this);
            }
            if (p_63369_) {
                f_63326_.add(this);
            }
        }

        private static /* synthetic */ BlockFixers[] m_156510_() {
            return new BlockFixers[]{BLACKLIST, DEFAULT, CHEST, LEAVES, STEM_BLOCK};
        }

        static {
            $VALUES = BlockFixers.m_156510_();
            f_63363_ = Direction.values();
        }
    }

    public static interface BlockFixer {
        public BlockState m_5731_(BlockState var1, Direction var2, BlockState var3, LevelAccessor var4, BlockPos var5, BlockPos var6);

        default public void m_5870_(LevelAccessor p_63351_) {
        }
    }
}

