/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ChunkTickList;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerTickList;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkBiomeContainer;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.ProtoTickList;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkSerializer {
    private static final Logger f_63449_ = LogManager.getLogger();
    public static final String f_156511_ = "UpgradeData";

    public static ProtoChunk m_63457_(ServerLevel p_63458_, StructureManager p_63459_, PoiManager p_63460_, ChunkPos p_63461_, CompoundTag p_63462_) {
        ChunkAccess \u00e2\u02dc\u019221;
        ChunkGenerator chunkGenerator = p_63458_.m_7726_().m_8481_();
        BiomeSource \u00e2\u02dc\u01922 = chunkGenerator.m_62218_();
        CompoundTag \u00e2\u02dc\u01923 = p_63462_.m_128469_("Level");
        ChunkPos \u00e2\u02dc\u01924 = new ChunkPos(\u00e2\u02dc\u01923.m_128451_("xPos"), \u00e2\u02dc\u01923.m_128451_("zPos"));
        if (!Objects.equals(p_63461_, \u00e2\u02dc\u01924)) {
            f_63449_.error("Chunk file at {} is in the wrong location; relocating. (Expected {}, got {})", (Object)p_63461_, (Object)p_63461_, (Object)\u00e2\u02dc\u01924);
        }
        ChunkBiomeContainer \u00e2\u02dc\u01925 = new ChunkBiomeContainer(p_63458_.m_5962_().m_175515_(Registry.f_122885_), p_63458_, p_63461_, \u00e2\u02dc\u01922, \u00e2\u02dc\u01923.m_128425_("Biomes", 11) ? \u00e2\u02dc\u01923.m_128465_("Biomes") : null);
        UpgradeData \u00e2\u02dc\u01926 = \u00e2\u02dc\u01923.m_128425_(f_156511_, 10) ? new UpgradeData(\u00e2\u02dc\u01923.m_128469_(f_156511_), p_63458_) : UpgradeData.f_63320_;
        ProtoTickList<Block> \u00e2\u02dc\u01927 = new ProtoTickList<Block>(p_63475_ -> p_63475_ == null || p_63475_.m_49966_().m_60795_(), p_63461_, \u00e2\u02dc\u01923.m_128437_("ToBeTicked", 9), p_63458_);
        ProtoTickList<Fluid> \u00e2\u02dc\u01928 = new ProtoTickList<Fluid>(p_63484_ -> p_63484_ == null || p_63484_ == Fluids.f_76191_, p_63461_, \u00e2\u02dc\u01923.m_128437_("LiquidsToBeTicked", 9), p_63458_);
        boolean \u00e2\u02dc\u01929 = \u00e2\u02dc\u01923.m_128471_("isLightOn");
        ListTag \u00e2\u02dc\u019210 = \u00e2\u02dc\u01923.m_128437_("Sections", 10);
        int \u00e2\u02dc\u019211 = p_63458_.m_151559_();
        LevelChunkSection[] \u00e2\u02dc\u019212 = new LevelChunkSection[\u00e2\u02dc\u019211];
        boolean \u00e2\u02dc\u019213 = p_63458_.m_6042_().m_63935_();
        ServerChunkCache \u00e2\u02dc\u019214 = p_63458_.m_7726_();
        LevelLightEngine \u00e2\u02dc\u019215 = ((ChunkSource)\u00e2\u02dc\u019214).m_7827_();
        if (\u00e2\u02dc\u01929) {
            \u00e2\u02dc\u019215.m_6462_(p_63461_, true);
        }
        for (int i = 0; i < \u00e2\u02dc\u019210.size(); ++i) {
            CompoundTag compoundTag = \u00e2\u02dc\u019210.m_128728_(i);
            byte \u00e2\u02dc\u019216 = compoundTag.m_128445_("Y");
            if (compoundTag.m_128425_("Palette", 9) && compoundTag.m_128425_("BlockStates", 12)) {
                LevelChunkSection \u00e2\u02dc\u019219 = new LevelChunkSection(\u00e2\u02dc\u019216);
                \u00e2\u02dc\u019219.m_63019_().m_63115_(compoundTag.m_128437_("Palette", 10), compoundTag.m_128467_("BlockStates"));
                \u00e2\u02dc\u019219.m_63018_();
                if (!\u00e2\u02dc\u019219.m_63013_()) {
                    \u00e2\u02dc\u019212[p_63458_.m_151566_((int)\u00e2\u02dc\u019216)] = \u00e2\u02dc\u019219;
                }
                p_63460_.m_27047_(p_63461_, \u00e2\u02dc\u019219);
            }
            if (!\u00e2\u02dc\u01929) continue;
            if (compoundTag.m_128425_("BlockLight", 7)) {
                \u00e2\u02dc\u019215.m_5687_(LightLayer.BLOCK, SectionPos.m_123196_(p_63461_, \u00e2\u02dc\u019216), new DataLayer(compoundTag.m_128463_("BlockLight")), true);
            }
            if (!\u00e2\u02dc\u019213 || !compoundTag.m_128425_("SkyLight", 7)) continue;
            \u00e2\u02dc\u019215.m_5687_(LightLayer.SKY, SectionPos.m_123196_(p_63461_, \u00e2\u02dc\u019216), new DataLayer(compoundTag.m_128463_("SkyLight")), true);
        }
        long l = \u00e2\u02dc\u01923.m_128454_("InhabitedTime");
        ChunkStatus.ChunkType \u00e2\u02dc\u019217 = ChunkSerializer.m_63485_(p_63462_);
        if (\u00e2\u02dc\u019217 == ChunkStatus.ChunkType.LEVELCHUNK) {
            ProtoTickList<Fluid> \u00e2\u02dc\u019218;
            ProtoTickList<Block> tickList;
            if (\u00e2\u02dc\u01923.m_128425_("TileTicks", 9)) {
                \u00e2\u02dc\u0192 = ChunkTickList.m_45656_(\u00e2\u02dc\u01923.m_128437_("TileTicks", 10), Registry.f_122824_::m_7981_, Registry.f_122824_::m_7745_);
            } else {
                tickList = \u00e2\u02dc\u01927;
            }
            if (\u00e2\u02dc\u01923.m_128425_("LiquidTicks", 9)) {
                Object object = ChunkTickList.m_45656_(\u00e2\u02dc\u01923.m_128437_("LiquidTicks", 10), Registry.f_122822_::m_7981_, Registry.f_122822_::m_7745_);
            } else {
                \u00e2\u02dc\u019218 = \u00e2\u02dc\u01928;
            }
            \u00e2\u02dc\u019221 = new LevelChunk(p_63458_.m_6018_(), p_63461_, \u00e2\u02dc\u01925, \u00e2\u02dc\u01926, tickList, \u00e2\u02dc\u019218, l, \u00e2\u02dc\u019212, p_156533_ -> ChunkSerializer.m_156522_(p_63458_, \u00e2\u02dc\u01923, p_156533_));
        } else {
            \u00e2\u02dc\u0192 = new ProtoChunk(p_63461_, \u00e2\u02dc\u01926, \u00e2\u02dc\u019212, \u00e2\u02dc\u01927, \u00e2\u02dc\u01928, p_63458_);
            ((ProtoChunk)\u00e2\u02dc\u0192).m_7329_(\u00e2\u02dc\u01925);
            \u00e2\u02dc\u019221 = \u00e2\u02dc\u0192;
            \u00e2\u02dc\u019221.m_6141_(l);
            ((ProtoChunk)\u00e2\u02dc\u0192).m_7150_(ChunkStatus.m_62397_(\u00e2\u02dc\u01923.m_128461_("Status")));
            if (\u00e2\u02dc\u019221.m_6415_().m_62427_(ChunkStatus.f_62322_)) {
                ((ProtoChunk)\u00e2\u02dc\u0192).m_63209_(\u00e2\u02dc\u019215);
            }
            if (!\u00e2\u02dc\u01929 && \u00e2\u02dc\u019221.m_6415_().m_62427_(ChunkStatus.f_62323_)) {
                for (BlockPos blockPos : BlockPos.m_121976_(p_63461_.m_45604_(), p_63458_.m_141937_(), p_63461_.m_45605_(), p_63461_.m_45608_(), p_63458_.m_151558_() - 1, p_63461_.m_45609_())) {
                    if (\u00e2\u02dc\u019221.m_8055_(blockPos).m_60791_() == 0) continue;
                    ((ProtoChunk)\u00e2\u02dc\u0192).m_63277_(blockPos);
                }
            }
        }
        \u00e2\u02dc\u019221.m_8094_(\u00e2\u02dc\u01929);
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u01923.m_128469_("Heightmaps");
        object = EnumSet.noneOf(Heightmap.Types.class);
        for (Heightmap.Types types : \u00e2\u02dc\u019221.m_6415_().m_62500_()) {
            String string = types.m_64294_();
            if (((CompoundTag)\u00e2\u02dc\u0192).m_128425_(string, 12)) {
                \u00e2\u02dc\u019221.m_6511_(types, ((CompoundTag)\u00e2\u02dc\u0192).m_128467_(string));
                continue;
            }
            ((AbstractCollection)object).add(types);
        }
        Heightmap.m_64256_(\u00e2\u02dc\u019221, (Set<Heightmap.Types>)object);
        CompoundTag compoundTag = \u00e2\u02dc\u01923.m_128469_("Structures");
        \u00e2\u02dc\u019221.m_8040_(ChunkSerializer.m_156518_(p_63458_, compoundTag, p_63458_.m_7328_()));
        \u00e2\u02dc\u019221.m_7946_(ChunkSerializer.m_63471_(p_63461_, compoundTag));
        if (\u00e2\u02dc\u01923.m_128471_("shouldSave")) {
            \u00e2\u02dc\u019221.m_8092_(true);
        }
        ListTag listTag = \u00e2\u02dc\u01923.m_128437_("PostProcessing", 9);
        for (int i = 0; i < listTag.size(); ++i) {
            ListTag \u00e2\u02dc\u019220 = listTag.m_128744_(i);
            for (int n = 0; n < \u00e2\u02dc\u019220.size(); ++n) {
                \u00e2\u02dc\u019221.m_6561_(\u00e2\u02dc\u019220.m_128757_(n), i);
            }
        }
        if (\u00e2\u02dc\u019217 == ChunkStatus.ChunkType.LEVELCHUNK) {
            return new ImposterProtoChunk((LevelChunk)\u00e2\u02dc\u019221);
        }
        ProtoChunk protoChunk = (ProtoChunk)\u00e2\u02dc\u019221;
        ListTag listTag2 = \u00e2\u02dc\u01923.m_128437_("Entities", 10);
        for (int i = 0; i < listTag2.size(); ++i) {
            protoChunk.m_63242_(listTag2.m_128728_(i));
        }
        ListTag listTag3 = \u00e2\u02dc\u01923.m_128437_("TileEntities", 10);
        for (int i = 0; i < listTag3.size(); ++i) {
            CompoundTag compoundTag2 = listTag3.m_128728_(i);
            \u00e2\u02dc\u019221.m_5604_(compoundTag2);
        }
        ListTag listTag22 = \u00e2\u02dc\u01923.m_128437_("Lights", 9);
        for (int i = 0; i < listTag22.size(); ++i) {
            ListTag listTag32 = listTag22.m_128744_(i);
            for (int j = 0; j < listTag32.size(); ++j) {
                protoChunk.m_63244_(listTag32.m_128757_(j), i);
            }
        }
        CompoundTag compoundTag3 = \u00e2\u02dc\u01923.m_128469_("CarvingMasks");
        for (String string : compoundTag3.m_128431_()) {
            GenerationStep.Carving carving = GenerationStep.Carving.valueOf(string);
            protoChunk.m_63189_(carving, BitSet.valueOf(compoundTag3.m_128463_(string)));
        }
        return protoChunk;
    }

    public static CompoundTag m_63454_(ServerLevel p_63455_, ChunkAccess p_63456_) {
        CompoundTag \u00e2\u02dc\u019213;
        ChunkBiomeContainer chunkBiomeContainer;
        ChunkPos chunkPos = p_63456_.m_7697_();
        CompoundTag \u00e2\u02dc\u01922 = new CompoundTag();
        CompoundTag \u00e2\u02dc\u01923 = new CompoundTag();
        \u00e2\u02dc\u01922.m_128405_("DataVersion", SharedConstants.m_136187_().getWorldVersion());
        \u00e2\u02dc\u01922.m_128365_("Level", \u00e2\u02dc\u01923);
        \u00e2\u02dc\u01923.m_128405_("xPos", chunkPos.f_45578_);
        \u00e2\u02dc\u01923.m_128405_("zPos", chunkPos.f_45579_);
        \u00e2\u02dc\u01923.m_128356_("LastUpdate", p_63455_.m_46467_());
        \u00e2\u02dc\u01923.m_128356_("InhabitedTime", p_63456_.m_6319_());
        \u00e2\u02dc\u01923.m_128359_("Status", p_63456_.m_6415_().m_62467_());
        UpgradeData \u00e2\u02dc\u01924 = p_63456_.m_7387_();
        if (!\u00e2\u02dc\u01924.m_63331_()) {
            \u00e2\u02dc\u01923.m_128365_(f_156511_, \u00e2\u02dc\u01924.m_63346_());
        }
        LevelChunkSection[] \u00e2\u02dc\u01925 = p_63456_.m_7103_();
        ListTag \u00e2\u02dc\u01926 = new ListTag();
        ThreadedLevelLightEngine \u00e2\u02dc\u01927 = p_63455_.m_7726_().m_7827_();
        boolean \u00e2\u02dc\u01928 = p_63456_.m_6332_();
        for (int i = \u00e2\u02dc\u01927.m_164447_(); i < \u00e2\u02dc\u01927.m_164448_(); ++i) {
            int n = i;
            LevelChunkSection \u00e2\u02dc\u019212 = Arrays.stream(\u00e2\u02dc\u01925).filter(p_63453_ -> p_63453_ != null && SectionPos.m_123171_(p_63453_.m_63017_()) == n).findFirst().orElse(LevelChunk.f_62770_);
            DataLayer \u00e2\u02dc\u01929 = \u00e2\u02dc\u01927.m_75814_(LightLayer.BLOCK).m_8079_(SectionPos.m_123196_(chunkPos, n));
            DataLayer \u00e2\u02dc\u019210 = \u00e2\u02dc\u01927.m_75814_(LightLayer.SKY).m_8079_(SectionPos.m_123196_(chunkPos, n));
            if (\u00e2\u02dc\u019212 == LevelChunk.f_62770_ && \u00e2\u02dc\u01929 == null && \u00e2\u02dc\u019210 == null) continue;
            CompoundTag \u00e2\u02dc\u019211 = new CompoundTag();
            \u00e2\u02dc\u019211.m_128344_("Y", (byte)(n & 0xFF));
            if (\u00e2\u02dc\u019212 != LevelChunk.f_62770_) {
                \u00e2\u02dc\u019212.m_63019_().m_63111_(\u00e2\u02dc\u019211, "Palette", "BlockStates");
            }
            if (\u00e2\u02dc\u01929 != null && !\u00e2\u02dc\u01929.m_62575_()) {
                \u00e2\u02dc\u019211.m_128382_("BlockLight", \u00e2\u02dc\u01929.m_7877_());
            }
            if (\u00e2\u02dc\u019210 != null && !\u00e2\u02dc\u019210.m_62575_()) {
                \u00e2\u02dc\u019211.m_128382_("SkyLight", \u00e2\u02dc\u019210.m_7877_());
            }
            \u00e2\u02dc\u01926.add(\u00e2\u02dc\u019211);
        }
        \u00e2\u02dc\u01923.m_128365_("Sections", \u00e2\u02dc\u01926);
        if (\u00e2\u02dc\u01928) {
            \u00e2\u02dc\u01923.m_128379_("isLightOn", true);
        }
        if ((chunkBiomeContainer = p_63456_.m_6221_()) != null) {
            \u00e2\u02dc\u01923.m_128385_("Biomes", chunkBiomeContainer.m_62131_());
        }
        ListTag listTag = new ListTag();
        for (Object object : p_63456_.m_5928_()) {
            \u00e2\u02dc\u019213 = p_63456_.m_8051_((BlockPos)object);
            if (\u00e2\u02dc\u019213 == null) continue;
            listTag.add(\u00e2\u02dc\u019213);
        }
        \u00e2\u02dc\u01923.m_128365_("TileEntities", listTag);
        if (p_63456_.m_6415_().m_62494_() == ChunkStatus.ChunkType.PROTOCHUNK) {
            Object object = (ProtoChunk)p_63456_;
            object = new ListTag();
            ((AbstractCollection)object).addAll(((ProtoChunk)object).m_63293_());
            \u00e2\u02dc\u01923.m_128365_("Entities", (Tag)object);
            \u00e2\u02dc\u01923.m_128365_("Lights", ChunkSerializer.m_63490_(((ProtoChunk)object).m_63291_()));
            \u00e2\u02dc\u019213 = new CompoundTag();
            for (GenerationStep.Carving carving : GenerationStep.Carving.values()) {
                BitSet bitSet = ((ProtoChunk)object).m_6548_(carving);
                if (bitSet == null) continue;
                \u00e2\u02dc\u019213.m_128382_(carving.toString(), bitSet.toByteArray());
            }
            \u00e2\u02dc\u01923.m_128365_("CarvingMasks", \u00e2\u02dc\u019213);
        }
        if ((object = p_63456_.m_5782_()) instanceof ProtoTickList) {
            \u00e2\u02dc\u01923.m_128365_("ToBeTicked", ((ProtoTickList)object).m_63316_());
        } else if (object instanceof ChunkTickList) {
            \u00e2\u02dc\u01923.m_128365_("TileTicks", ((ChunkTickList)object).m_45660_());
        } else {
            \u00e2\u02dc\u01923.m_128365_("TileTicks", ((ServerTickList)p_63455_.m_6219_()).m_47221_(chunkPos));
        }
        object = p_63456_.m_5783_();
        if (object instanceof ProtoTickList) {
            \u00e2\u02dc\u01923.m_128365_("LiquidsToBeTicked", ((ProtoTickList)object).m_63316_());
        } else if (object instanceof ChunkTickList) {
            \u00e2\u02dc\u01923.m_128365_("LiquidTicks", ((ChunkTickList)object).m_45660_());
        } else {
            \u00e2\u02dc\u01923.m_128365_("LiquidTicks", ((ServerTickList)p_63455_.m_6217_()).m_47221_(chunkPos));
        }
        \u00e2\u02dc\u01923.m_128365_("PostProcessing", ChunkSerializer.m_63490_(p_63456_.m_6720_()));
        \u00e2\u02dc\u019213 = new CompoundTag();
        for (Map.Entry entry : p_63456_.m_6890_()) {
            if (!p_63456_.m_6415_().m_62500_().contains(entry.getKey())) continue;
            \u00e2\u02dc\u019213.m_128365_(((Heightmap.Types)entry.getKey()).m_64294_(), new LongArrayTag(((Heightmap)entry.getValue()).m_64239_()));
        }
        \u00e2\u02dc\u01923.m_128365_("Heightmaps", \u00e2\u02dc\u019213);
        \u00e2\u02dc\u01923.m_128365_("Structures", ChunkSerializer.m_156513_(p_63455_, chunkPos, p_63456_.m_6633_(), p_63456_.m_7049_()));
        return \u00e2\u02dc\u01922;
    }

    public static ChunkStatus.ChunkType m_63485_(@Nullable CompoundTag p_63486_) {
        ChunkStatus chunkStatus;
        if (p_63486_ != null && (chunkStatus = ChunkStatus.m_62397_(p_63486_.m_128469_("Level").m_128461_("Status"))) != null) {
            return chunkStatus.m_62494_();
        }
        return ChunkStatus.ChunkType.PROTOCHUNK;
    }

    private static void m_156522_(ServerLevel p_156523_, CompoundTag p_156524_, LevelChunk p_156525_) {
        ListTag listTag;
        if (p_156524_.m_128425_("Entities", 9) && !(listTag = p_156524_.m_128437_("Entities", 10)).isEmpty()) {
            p_156523_.m_143311_(EntityType.m_147045_(listTag, p_156523_));
        }
        listTag = p_156524_.m_128437_("TileEntities", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag compoundTag = listTag.m_128728_(i);
            boolean \u00e2\u02dc\u01922 = compoundTag.m_128471_("keepPacked");
            if (\u00e2\u02dc\u01922) {
                p_156525_.m_5604_(compoundTag);
                continue;
            }
            BlockPos \u00e2\u02dc\u01923 = new BlockPos(compoundTag.m_128451_("x"), compoundTag.m_128451_("y"), compoundTag.m_128451_("z"));
            BlockEntity \u00e2\u02dc\u01924 = BlockEntity.m_155241_(\u00e2\u02dc\u01923, p_156525_.m_8055_(\u00e2\u02dc\u01923), compoundTag);
            if (\u00e2\u02dc\u01924 == null) continue;
            p_156525_.m_142169_(\u00e2\u02dc\u01924);
        }
    }

    private static CompoundTag m_156513_(ServerLevel p_156514_, ChunkPos p_156515_, Map<StructureFeature<?>, StructureStart<?>> p_156516_, Map<StructureFeature<?>, LongSet> p_156517_) {
        CompoundTag compoundTag = new CompoundTag();
        \u00e2\u02dc\u0192 = new CompoundTag();
        for (Map.Entry<StructureFeature<?>, StructureStart<?>> entry : p_156516_.entrySet()) {
            \u00e2\u02dc\u0192.m_128365_(entry.getKey().m_67098_(), entry.getValue().m_163606_(p_156514_, p_156515_));
        }
        compoundTag.m_128365_("Starts", \u00e2\u02dc\u0192);
        \u00e2\u02dc\u0192 = new CompoundTag();
        for (Map.Entry<StructureFeature<?>, LongSet> entry : p_156517_.entrySet()) {
            \u00e2\u02dc\u0192.m_128365_(entry.getKey().m_67098_(), new LongArrayTag(entry.getValue()));
        }
        compoundTag.m_128365_("References", \u00e2\u02dc\u0192);
        return compoundTag;
    }

    private static Map<StructureFeature<?>, StructureStart<?>> m_156518_(ServerLevel p_156519_, CompoundTag p_156520_, long p_156521_) {
        HashMap hashMap = Maps.newHashMap();
        CompoundTag \u00e2\u02dc\u01922 = p_156520_.m_128469_("Starts");
        for (String string : \u00e2\u02dc\u01922.m_128431_()) {
            \u00e2\u02dc\u0192 = string.toLowerCase(Locale.ROOT);
            StructureFeature structureFeature = (StructureFeature)StructureFeature.f_67012_.get((Object)\u00e2\u02dc\u0192);
            if (structureFeature == null) {
                f_63449_.error("Unknown structure start: {}", (Object)\u00e2\u02dc\u0192);
                continue;
            }
            StructureStart<?> \u00e2\u02dc\u01923 = StructureFeature.m_160447_(p_156519_, \u00e2\u02dc\u01922.m_128469_(string), p_156521_);
            if (\u00e2\u02dc\u01923 == null) continue;
            hashMap.put(structureFeature, \u00e2\u02dc\u01923);
        }
        return hashMap;
    }

    private static Map<StructureFeature<?>, LongSet> m_63471_(ChunkPos p_63472_, CompoundTag p_63473_) {
        HashMap hashMap = Maps.newHashMap();
        CompoundTag \u00e2\u02dc\u01922 = p_63473_.m_128469_("References");
        for (String string : \u00e2\u02dc\u01922.m_128431_()) {
            \u00e2\u02dc\u0192 = string.toLowerCase(Locale.ROOT);
            StructureFeature structureFeature = (StructureFeature)StructureFeature.f_67012_.get((Object)\u00e2\u02dc\u0192);
            if (structureFeature == null) {
                f_63449_.warn("Found reference to unknown structure '{}' in chunk {}, discarding", (Object)\u00e2\u02dc\u0192, (Object)p_63472_);
                continue;
            }
            hashMap.put(structureFeature, new LongOpenHashSet(Arrays.stream(\u00e2\u02dc\u01922.m_128467_(string)).filter(p_156529_ -> {
                ChunkPos chunkPos = new ChunkPos(p_156529_);
                if (chunkPos.m_45594_(p_63472_) > 8) {
                    f_63449_.warn("Found invalid structure reference [ {} @ {} ] for chunk {}.", (Object)\u00e2\u02dc\u0192, (Object)chunkPos, (Object)p_63472_);
                    return false;
                }
                return true;
            }).toArray()));
        }
        return hashMap;
    }

    public static ListTag m_63490_(ShortList[] p_63491_) {
        ListTag listTag = new ListTag();
        for (ShortList shortList : p_63491_) {
            ListTag listTag2 = new ListTag();
            if (shortList != null) {
                for (Short s : shortList) {
                    listTag2.add(ShortTag.m_129258_(s));
                }
            }
            listTag.add(listTag2);
        }
        return listTag;
    }
}

