/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.DataFixer;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.thread.ProcessorMailbox;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.IOWorker;
import net.minecraft.world.level.entity.ChunkEntities;
import net.minecraft.world.level.entity.EntityPersistentStorage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityStorage
implements EntityPersistentStorage<Entity> {
    private static final Logger f_156535_ = LogManager.getLogger();
    private static final String f_156536_ = "Entities";
    private static final String f_156537_ = "Position";
    private final ServerLevel f_156538_;
    private final IOWorker f_156539_;
    private final LongSet f_156540_ = new LongOpenHashSet();
    private final ProcessorMailbox<Runnable> f_182485_;
    protected final DataFixer f_156534_;

    public EntityStorage(ServerLevel p_156544_, File p_156545_, DataFixer p_156546_, boolean p_156547_, Executor p_156548_) {
        this.f_156538_ = p_156544_;
        this.f_156534_ = p_156546_;
        this.f_182485_ = ProcessorMailbox.m_18751_(p_156548_, "entity-deserializer");
        this.f_156539_ = new IOWorker(p_156545_, p_156547_, "entities");
    }

    @Override
    public CompletableFuture<ChunkEntities<Entity>> m_141930_(ChunkPos p_156551_) {
        if (this.f_156540_.contains(p_156551_.m_45588_())) {
            return CompletableFuture.completedFuture(EntityStorage.m_156568_(p_156551_));
        }
        return this.f_156539_.m_156587_(p_156551_).thenApplyAsync(p_156557_ -> {
            Object object;
            if (p_156557_ == null) {
                this.f_156540_.add(p_156551_.m_45588_());
                return EntityStorage.m_156568_(p_156551_);
            }
            try {
                object = EntityStorage.m_156570_(p_156557_);
                if (!Objects.equals(p_156551_, object)) {
                    f_156535_.error("Chunk file at {} is in the wrong location. (Expected {}, got {})", (Object)p_156551_, (Object)p_156551_, object);
                }
            }
            catch (Exception exception) {
                f_156535_.warn("Failed to parse chunk {} position info", (Object)p_156551_, (Object)exception);
            }
            object = this.m_156572_((CompoundTag)p_156557_);
            ListTag \u00e2\u02dc\u01922 = ((CompoundTag)object).m_128437_(f_156536_, 10);
            List \u00e2\u02dc\u01923 = (List)EntityType.m_147045_(\u00e2\u02dc\u01922, this.f_156538_).collect(ImmutableList.toImmutableList());
            return new ChunkEntities(p_156551_, \u00e2\u02dc\u01923);
        }, this.f_182485_::m_6937_);
    }

    private static ChunkPos m_156570_(CompoundTag p_156571_) {
        int[] nArray = p_156571_.m_128465_(f_156537_);
        return new ChunkPos(nArray[0], nArray[1]);
    }

    private static void m_156562_(CompoundTag p_156563_, ChunkPos p_156564_) {
        p_156563_.m_128365_(f_156537_, new IntArrayTag(new int[]{p_156564_.f_45578_, p_156564_.f_45579_}));
    }

    private static ChunkEntities<Entity> m_156568_(ChunkPos p_156569_) {
        return new ChunkEntities<Entity>(p_156569_, (List<Entity>)ImmutableList.of());
    }

    @Override
    public void m_141971_(ChunkEntities<Entity> p_156559_) {
        ChunkPos chunkPos = p_156559_.m_156791_();
        if (p_156559_.m_156793_()) {
            if (this.f_156540_.add(chunkPos.m_45588_())) {
                this.f_156539_.m_63538_(chunkPos, null);
            }
            return;
        }
        ListTag \u00e2\u02dc\u01922 = new ListTag();
        p_156559_.m_156792_().forEach(p_156567_ -> {
            CompoundTag compoundTag = new CompoundTag();
            if (p_156567_.m_20223_(compoundTag)) {
                \u00e2\u02dc\u01922.add(compoundTag);
            }
        });
        CompoundTag \u00e2\u02dc\u01923 = new CompoundTag();
        \u00e2\u02dc\u01923.m_128405_("DataVersion", SharedConstants.m_136187_().getWorldVersion());
        \u00e2\u02dc\u01923.m_128365_(f_156536_, \u00e2\u02dc\u01922);
        EntityStorage.m_156562_(\u00e2\u02dc\u01923, chunkPos);
        this.f_156539_.m_63538_(chunkPos, \u00e2\u02dc\u01923).exceptionally(p_156554_ -> {
            f_156535_.error("Failed to store chunk {}", (Object)chunkPos, p_156554_);
            return null;
        });
        this.f_156540_.remove(chunkPos.m_45588_());
    }

    @Override
    public void m_182219_(boolean p_182487_) {
        this.f_156539_.m_182498_(p_182487_).join();
        this.f_182485_.m_182329_();
    }

    private CompoundTag m_156572_(CompoundTag p_156573_) {
        int n = EntityStorage.m_156560_(p_156573_);
        return NbtUtils.m_129213_(this.f_156534_, DataFixTypes.ENTITY_CHUNK, p_156573_, n);
    }

    public static int m_156560_(CompoundTag p_156561_) {
        return p_156561_.m_128425_("DataVersion", 99) ? p_156561_.m_128451_("DataVersion") : -1;
    }

    @Override
    public void close() throws IOException {
        this.f_156539_.close();
    }
}

