/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Unit;
import net.minecraft.util.thread.ProcessorHandle;
import net.minecraft.util.thread.ProcessorMailbox;
import net.minecraft.util.thread.StrictQueue;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.RegionFileStorage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IOWorker
implements AutoCloseable {
    private static final Logger f_63515_ = LogManager.getLogger();
    private final AtomicBoolean f_63516_ = new AtomicBoolean();
    private final ProcessorMailbox<StrictQueue.IntRunnable> f_63517_;
    private final RegionFileStorage f_63518_;
    private final Map<ChunkPos, PendingStore> f_63519_ = Maps.newLinkedHashMap();

    protected IOWorker(File p_63522_, boolean p_63523_, String p_63524_) {
        this.f_63518_ = new RegionFileStorage(p_63522_, p_63523_);
        this.f_63517_ = new ProcessorMailbox<StrictQueue.IntRunnable>(new StrictQueue.FixedPriorityQueue(Priority.values().length), Util.m_137579_(), "IOWorker-" + p_63524_);
    }

    public CompletableFuture<Void> m_63538_(ChunkPos p_63539_, @Nullable CompoundTag p_63540_) {
        return this.m_63545_(() -> {
            PendingStore pendingStore = this.f_63519_.computeIfAbsent(p_63539_, p_156584_ -> new PendingStore(p_63540_));
            pendingStore.f_63565_ = p_63540_;
            return Either.left(pendingStore.f_63566_);
        }).thenCompose(Function.identity());
    }

    @Nullable
    public CompoundTag m_63533_(ChunkPos p_63534_) throws IOException {
        CompletableFuture<CompoundTag> completableFuture = this.m_156587_(p_63534_);
        try {
            return completableFuture.join();
        }
        catch (CompletionException \u00e2\u02dc\u01922) {
            if (\u00e2\u02dc\u01922.getCause() instanceof IOException) {
                throw (IOException)\u00e2\u02dc\u01922.getCause();
            }
            throw \u00e2\u02dc\u01922;
        }
    }

    protected CompletableFuture<CompoundTag> m_156587_(ChunkPos p_156588_) {
        return this.m_63545_(() -> {
            PendingStore pendingStore = this.f_63519_.get(p_156588_);
            if (pendingStore != null) {
                return Either.left((Object)pendingStore.f_63565_);
            }
            try {
                CompoundTag compoundTag = this.f_63518_.m_63706_(p_156588_);
                return Either.left((Object)compoundTag);
            }
            catch (Exception exception) {
                f_63515_.warn("Failed to read chunk {}", (Object)p_156588_, (Object)exception);
                return Either.right((Object)exception);
            }
        });
    }

    public CompletableFuture<Void> m_182498_(boolean p_182499_) {
        CompletionStage completionStage = this.m_63545_(() -> Either.left(CompletableFuture.allOf((CompletableFuture[])this.f_63519_.values().stream().map(p_156581_ -> p_156581_.f_63566_).toArray(CompletableFuture[]::new)))).thenCompose(Function.identity());
        if (p_182499_) {
            return ((CompletableFuture)completionStage).thenCompose(p_63544_ -> this.m_63545_(() -> {
                try {
                    this.f_63518_.m_63705_();
                    return Either.left(null);
                }
                catch (Exception exception) {
                    f_63515_.warn("Failed to synchronize chunks", (Throwable)exception);
                    return Either.right((Object)exception);
                }
            }));
        }
        return ((CompletableFuture)completionStage).thenCompose(p_182494_ -> this.m_63545_(() -> Either.left(null)));
    }

    private <T> CompletableFuture<T> m_63545_(Supplier<Either<T, Exception>> p_63546_) {
        return this.f_63517_.m_18722_(p_63549_ -> new StrictQueue.IntRunnable(Priority.FOREGROUND.ordinal(), () -> this.m_182490_(p_63549_, (Supplier)p_63546_)));
    }

    private void m_63553_() {
        if (this.f_63519_.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<ChunkPos, PendingStore>> iterator = this.f_63519_.entrySet().iterator();
        Map.Entry<ChunkPos, PendingStore> \u00e2\u02dc\u01922 = iterator.next();
        iterator.remove();
        this.m_63535_(\u00e2\u02dc\u01922.getKey(), \u00e2\u02dc\u01922.getValue());
        this.m_63561_();
    }

    private void m_63561_() {
        this.f_63517_.m_6937_(new StrictQueue.IntRunnable(Priority.BACKGROUND.ordinal(), this::m_63553_));
    }

    private void m_63535_(ChunkPos p_63536_, PendingStore p_63537_) {
        try {
            this.f_63518_.m_63708_(p_63536_, p_63537_.f_63565_);
            p_63537_.f_63566_.complete(null);
        }
        catch (Exception exception) {
            f_63515_.error("Failed to store chunk {}", (Object)p_63536_, (Object)exception);
            p_63537_.f_63566_.completeExceptionally(exception);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.f_63516_.compareAndSet(false, true)) {
            return;
        }
        this.f_63517_.m_18720_(p_63529_ -> new StrictQueue.IntRunnable(Priority.SHUTDOWN.ordinal(), () -> p_63529_.m_6937_(Unit.INSTANCE))).join();
        this.f_63517_.close();
        try {
            this.f_63518_.close();
        }
        catch (Exception exception) {
            f_63515_.error("Failed to close storage", (Throwable)exception);
        }
    }

    private /* synthetic */ void m_182490_(ProcessorHandle p_182491_, Supplier p_182492_) {
        if (!this.f_63516_.get()) {
            p_182491_.m_6937_((Either)p_182492_.get());
        }
        this.m_63561_();
    }

    static final class Priority
    extends Enum<Priority> {
        public static final /* enum */ Priority FOREGROUND = new Priority();
        public static final /* enum */ Priority BACKGROUND = new Priority();
        public static final /* enum */ Priority SHUTDOWN = new Priority();
        private static final /* synthetic */ Priority[] $VALUES;

        public static Priority[] values() {
            return (Priority[])$VALUES.clone();
        }

        public static Priority valueOf(String p_63584_) {
            return Enum.valueOf(Priority.class, p_63584_);
        }

        private static /* synthetic */ Priority[] m_156595_() {
            return new Priority[]{FOREGROUND, BACKGROUND, SHUTDOWN};
        }

        static {
            $VALUES = Priority.m_156595_();
        }
    }

    static class PendingStore {
        @Nullable
        CompoundTag f_63565_;
        final CompletableFuture<Void> f_63566_ = new CompletableFuture();

        public PendingStore(@Nullable CompoundTag p_63568_) {
            this.f_63565_ = p_63568_;
        }
    }
}

