/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.RegionBitmap;
import net.minecraft.world.level.chunk.storage.RegionFileVersion;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegionFile
implements AutoCloseable {
    private static final Logger f_63619_ = LogManager.getLogger();
    private static final int f_156605_ = 4096;
    @VisibleForTesting
    protected static final int f_156604_ = 1024;
    private static final int f_156606_ = 5;
    private static final int f_156607_ = 0;
    private static final ByteBuffer f_63620_ = ByteBuffer.allocateDirect(1);
    private static final String f_156608_ = ".mcc";
    private static final int f_156609_ = 128;
    private static final int f_156610_ = 256;
    private static final int f_156611_ = 0;
    private final FileChannel f_63621_;
    private final Path f_63622_;
    final RegionFileVersion f_63623_;
    private final ByteBuffer f_63624_ = ByteBuffer.allocateDirect(8192);
    private final IntBuffer f_63625_;
    private final IntBuffer f_63626_;
    @VisibleForTesting
    protected final RegionBitmap f_63618_ = new RegionBitmap();

    public RegionFile(File p_63629_, File p_63630_, boolean p_63631_) throws IOException {
        this(p_63629_.toPath(), p_63630_.toPath(), RegionFileVersion.f_63744_, p_63631_);
    }

    public RegionFile(Path p_63633_, Path p_63634_, RegionFileVersion p_63635_, boolean p_63636_) throws IOException {
        this.f_63623_ = p_63635_;
        if (!Files.isDirectory(p_63634_, new LinkOption[0])) {
            throw new IllegalArgumentException("Expected directory, got " + p_63634_.toAbsolutePath());
        }
        this.f_63622_ = p_63634_;
        this.f_63625_ = this.f_63624_.asIntBuffer();
        this.f_63625_.limit(1024);
        this.f_63624_.position(4096);
        this.f_63626_ = this.f_63624_.asIntBuffer();
        this.f_63621_ = p_63636_ ? FileChannel.open(p_63633_, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.DSYNC) : FileChannel.open(p_63633_, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        this.f_63618_.m_63612_(0, 2);
        this.f_63624_.position(0);
        int n = this.f_63621_.read(this.f_63624_, 0L);
        if (n != -1) {
            if (n != 8192) {
                f_63619_.warn("Region file {} has truncated header: {}", (Object)p_63633_, (Object)n);
            }
            long l = Files.size(p_63633_);
            for (int i = 0; i < 1024; ++i) {
                \u00e2\u02dc\u0192 = this.f_63625_.get(i);
                if (\u00e2\u02dc\u0192 == 0) continue;
                \u00e2\u02dc\u0192 = RegionFile.m_63671_(\u00e2\u02dc\u0192);
                \u00e2\u02dc\u0192 = RegionFile.m_63640_(\u00e2\u02dc\u0192);
                if (\u00e2\u02dc\u0192 < 2) {
                    f_63619_.warn("Region file {} has invalid sector at index: {}; sector {} overlaps with header", (Object)p_63633_, (Object)i, (Object)\u00e2\u02dc\u0192);
                    this.f_63625_.put(i, 0);
                    continue;
                }
                if (\u00e2\u02dc\u0192 == 0) {
                    f_63619_.warn("Region file {} has an invalid sector at index: {}; size has to be > 0", (Object)p_63633_, (Object)i);
                    this.f_63625_.put(i, 0);
                    continue;
                }
                if ((long)\u00e2\u02dc\u0192 * 4096L > l) {
                    f_63619_.warn("Region file {} has an invalid sector at index: {}; sector {} is out of bounds", (Object)p_63633_, (Object)i, (Object)\u00e2\u02dc\u0192);
                    this.f_63625_.put(i, 0);
                    continue;
                }
                this.f_63618_.m_63612_(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
            }
        }
    }

    private Path m_63684_(ChunkPos p_63685_) {
        String string = "c." + p_63685_.f_45578_ + "." + p_63685_.f_45579_ + f_156608_;
        return this.f_63622_.resolve(string);
    }

    @Nullable
    public synchronized DataInputStream m_63645_(ChunkPos p_63646_) throws IOException {
        int n = this.m_63686_(p_63646_);
        if (n == 0) {
            return null;
        }
        \u00e2\u02dc\u0192 = RegionFile.m_63671_(n);
        \u00e2\u02dc\u0192 = RegionFile.m_63640_(n);
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 * 4096;
        ByteBuffer \u00e2\u02dc\u01922 = ByteBuffer.allocate(\u00e2\u02dc\u0192);
        this.f_63621_.read(\u00e2\u02dc\u01922, \u00e2\u02dc\u0192 * 4096);
        \u00e2\u02dc\u01922.flip();
        if (\u00e2\u02dc\u01922.remaining() < 5) {
            f_63619_.error("Chunk {} header is truncated: expected {} but read {}", (Object)p_63646_, (Object)\u00e2\u02dc\u0192, (Object)\u00e2\u02dc\u01922.remaining());
            return null;
        }
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u01922.getInt();
        byte \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922.get();
        if (\u00e2\u02dc\u0192 == 0) {
            f_63619_.warn("Chunk {} is allocated, but stream is missing", (Object)p_63646_);
            return null;
        }
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 - 1;
        if (RegionFile.m_63638_(\u00e2\u02dc\u01923)) {
            if (\u00e2\u02dc\u0192 != 0) {
                f_63619_.warn("Chunk has both internal and external streams");
            }
            return this.m_63647_(p_63646_, RegionFile.m_63669_(\u00e2\u02dc\u01923));
        }
        if (\u00e2\u02dc\u0192 > \u00e2\u02dc\u01922.remaining()) {
            f_63619_.error("Chunk {} stream is truncated: expected {} but read {}", (Object)p_63646_, (Object)\u00e2\u02dc\u0192, (Object)\u00e2\u02dc\u01922.remaining());
            return null;
        }
        if (\u00e2\u02dc\u0192 < 0) {
            f_63619_.error("Declared size {} of chunk {} is negative", (Object)\u00e2\u02dc\u0192, (Object)p_63646_);
            return null;
        }
        return this.m_63650_(p_63646_, \u00e2\u02dc\u01923, RegionFile.m_63659_(\u00e2\u02dc\u01922, \u00e2\u02dc\u0192));
    }

    private static int m_156612_() {
        return (int)(Util.m_137574_() / 1000L);
    }

    private static boolean m_63638_(byte p_63639_) {
        return (p_63639_ & 0x80) != 0;
    }

    private static byte m_63669_(byte p_63670_) {
        return (byte)(p_63670_ & 0xFFFFFF7F);
    }

    @Nullable
    private DataInputStream m_63650_(ChunkPos p_63651_, byte p_63652_, InputStream p_63653_) throws IOException {
        RegionFileVersion regionFileVersion = RegionFileVersion.m_63756_(p_63652_);
        if (regionFileVersion == null) {
            f_63619_.error("Chunk {} has invalid chunk stream version {}", (Object)p_63651_, (Object)p_63652_);
            return null;
        }
        return new DataInputStream(new BufferedInputStream(regionFileVersion.m_63760_(p_63653_)));
    }

    @Nullable
    private DataInputStream m_63647_(ChunkPos p_63648_, byte p_63649_) throws IOException {
        Path path = this.m_63684_(p_63648_);
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            f_63619_.error("External chunk path {} is not file", (Object)path);
            return null;
        }
        return this.m_63650_(p_63648_, p_63649_, Files.newInputStream(path, new OpenOption[0]));
    }

    private static ByteArrayInputStream m_63659_(ByteBuffer p_63660_, int p_63661_) {
        return new ByteArrayInputStream(p_63660_.array(), p_63660_.position(), p_63661_);
    }

    private int m_63642_(int p_63643_, int p_63644_) {
        return p_63643_ << 8 | p_63644_;
    }

    private static int m_63640_(int p_63641_) {
        return p_63641_ & 0xFF;
    }

    private static int m_63671_(int p_63672_) {
        return p_63672_ >> 8 & 0xFFFFFF;
    }

    private static int m_63676_(int p_63677_) {
        return (p_63677_ + 4096 - 1) / 4096;
    }

    public boolean m_63673_(ChunkPos p_63674_) {
        int n = this.m_63686_(p_63674_);
        if (n == 0) {
            return false;
        }
        \u00e2\u02dc\u0192 = RegionFile.m_63671_(n);
        \u00e2\u02dc\u0192 = RegionFile.m_63640_(n);
        ByteBuffer \u00e2\u02dc\u01922 = ByteBuffer.allocate(5);
        try {
            this.f_63621_.read(\u00e2\u02dc\u01922, \u00e2\u02dc\u0192 * 4096);
            \u00e2\u02dc\u01922.flip();
            if (\u00e2\u02dc\u01922.remaining() != 5) {
                return false;
            }
            \u00e2\u02dc\u0192 = \u00e2\u02dc\u01922.getInt();
            byte by = \u00e2\u02dc\u01922.get();
            if (RegionFile.m_63638_(by)) {
                if (!RegionFileVersion.m_63764_(RegionFile.m_63669_(by))) {
                    return false;
                }
                if (!Files.isRegularFile(this.m_63684_(p_63674_), new LinkOption[0])) {
                    return false;
                }
            } else {
                if (!RegionFileVersion.m_63764_(by)) {
                    return false;
                }
                if (\u00e2\u02dc\u0192 == 0) {
                    return false;
                }
                int n2 = \u00e2\u02dc\u0192 - 1;
                if (n2 < 0 || n2 > 4096 * \u00e2\u02dc\u0192) {
                    return false;
                }
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public DataOutputStream m_63678_(ChunkPos p_63679_) throws IOException {
        return new DataOutputStream(new BufferedOutputStream(this.f_63623_.m_63762_(new ChunkBuffer(p_63679_))));
    }

    public void m_63637_() throws IOException {
        this.f_63621_.force(true);
    }

    public void m_156613_(ChunkPos p_156614_) throws IOException {
        int n = RegionFile.m_63688_(p_156614_);
        \u00e2\u02dc\u0192 = this.f_63625_.get(n);
        if (\u00e2\u02dc\u0192 == 0) {
            return;
        }
        this.f_63625_.put(n, 0);
        this.f_63626_.put(n, RegionFile.m_156612_());
        this.m_63675_();
        Files.deleteIfExists(this.m_63684_(p_156614_));
        this.f_63618_.m_63615_(RegionFile.m_63671_(\u00e2\u02dc\u0192), RegionFile.m_63640_(\u00e2\u02dc\u0192));
    }

    protected synchronized void m_63654_(ChunkPos p_63655_, ByteBuffer p_63656_) throws IOException {
        CommitOp \u00e2\u02dc\u01924;
        int \u00e2\u02dc\u01923;
        int \u00e2\u02dc\u01922;
        int n = RegionFile.m_63688_(p_63655_);
        \u00e2\u02dc\u0192 = this.f_63625_.get(n);
        \u00e2\u02dc\u0192 = RegionFile.m_63671_(\u00e2\u02dc\u0192);
        \u00e2\u02dc\u0192 = RegionFile.m_63640_(\u00e2\u02dc\u0192);
        \u00e2\u02dc\u0192 = p_63656_.remaining();
        \u00e2\u02dc\u01922 = RegionFile.m_63676_(\u00e2\u02dc\u0192);
        if (\u00e2\u02dc\u01922 >= 256) {
            Path path = this.m_63684_(p_63655_);
            f_63619_.warn("Saving oversized chunk {} ({} bytes} to external file {}", (Object)p_63655_, (Object)\u00e2\u02dc\u0192, (Object)path);
            \u00e2\u02dc\u01922 = 1;
            \u00e2\u02dc\u01923 = this.f_63618_.m_63610_(\u00e2\u02dc\u01922);
            \u00e2\u02dc\u01924 = this.m_63662_(path, p_63656_);
            ByteBuffer \u00e2\u02dc\u01925 = this.m_63668_();
            this.f_63621_.write(\u00e2\u02dc\u01925, \u00e2\u02dc\u01923 * 4096);
        } else {
            \u00e2\u02dc\u01923 = this.f_63618_.m_63610_(\u00e2\u02dc\u01922);
            \u00e2\u02dc\u01924 = () -> Files.deleteIfExists(this.m_63684_(p_63655_));
            this.f_63621_.write(p_63656_, \u00e2\u02dc\u01923 * 4096);
        }
        this.f_63625_.put(n, this.m_63642_(\u00e2\u02dc\u01923, \u00e2\u02dc\u01922));
        this.f_63626_.put(n, RegionFile.m_156612_());
        this.m_63675_();
        \u00e2\u02dc\u01924.m_63698_();
        if (\u00e2\u02dc\u0192 != 0) {
            this.f_63618_.m_63615_(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
        }
    }

    private ByteBuffer m_63668_() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(5);
        byteBuffer.putInt(1);
        byteBuffer.put((byte)(this.f_63623_.m_63755_() | 0x80));
        byteBuffer.flip();
        return byteBuffer;
    }

    private CommitOp m_63662_(Path p_63663_, ByteBuffer p_63664_) throws IOException {
        Path path = Files.createTempFile(this.f_63622_, "tmp", null, new FileAttribute[0]);
        try (FileChannel \u00e2\u02dc\u01922 = FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            p_63664_.position(5);
            \u00e2\u02dc\u01922.write(p_63664_);
        }
        return () -> Files.move(path, p_63663_, StandardCopyOption.REPLACE_EXISTING);
    }

    private void m_63675_() throws IOException {
        this.f_63624_.position(0);
        this.f_63621_.write(this.f_63624_, 0L);
    }

    private int m_63686_(ChunkPos p_63687_) {
        return this.f_63625_.get(RegionFile.m_63688_(p_63687_));
    }

    public boolean m_63682_(ChunkPos p_63683_) {
        return this.m_63686_(p_63683_) != 0;
    }

    private static int m_63688_(ChunkPos p_63689_) {
        return p_63689_.m_45613_() + p_63689_.m_45614_() * 32;
    }

    @Override
    public void close() throws IOException {
        try {
            this.m_63681_();
        }
        finally {
            try {
                this.f_63621_.force(true);
            }
            finally {
                this.f_63621_.close();
            }
        }
    }

    private void m_63681_() throws IOException {
        int n = (int)this.f_63621_.size();
        if (n != (\u00e2\u02dc\u0192 = RegionFile.m_63676_(n) * 4096)) {
            ByteBuffer byteBuffer = f_63620_.duplicate();
            byteBuffer.position(0);
            this.f_63621_.write(byteBuffer, \u00e2\u02dc\u0192 - 1);
        }
    }

    class ChunkBuffer
    extends ByteArrayOutputStream {
        private final ChunkPos f_63693_;

        public ChunkBuffer(ChunkPos p_63696_) {
            super(8096);
            super.write(0);
            super.write(0);
            super.write(0);
            super.write(0);
            super.write(RegionFile.this.f_63623_.m_63755_());
            this.f_63693_ = p_63696_;
        }

        @Override
        public void close() throws IOException {
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.buf, 0, this.count);
            byteBuffer.putInt(0, this.count - 5 + 1);
            RegionFile.this.m_63654_(this.f_63693_, byteBuffer);
        }
    }

    static interface CommitOp {
        public void m_63698_() throws IOException;
    }
}

