/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.util.ExceptionCollector;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.RegionFile;

public final class RegionFileStorage
implements AutoCloseable {
    public static final String f_156615_ = ".mca";
    private static final int f_156616_ = 256;
    private final Long2ObjectLinkedOpenHashMap<RegionFile> f_63699_ = new Long2ObjectLinkedOpenHashMap();
    private final File f_63700_;
    private final boolean f_63701_;

    RegionFileStorage(File p_63703_, boolean p_63704_) {
        this.f_63700_ = p_63703_;
        this.f_63701_ = p_63704_;
    }

    private RegionFile m_63711_(ChunkPos p_63712_) throws IOException {
        long l = ChunkPos.m_45589_(p_63712_.m_45610_(), p_63712_.m_45612_());
        RegionFile \u00e2\u02dc\u01922 = (RegionFile)this.f_63699_.getAndMoveToFirst(l);
        if (\u00e2\u02dc\u01922 != null) {
            return \u00e2\u02dc\u01922;
        }
        if (this.f_63699_.size() >= 256) {
            ((RegionFile)this.f_63699_.removeLast()).close();
        }
        if (!this.f_63700_.exists()) {
            this.f_63700_.mkdirs();
        }
        File \u00e2\u02dc\u01923 = new File(this.f_63700_, "r." + p_63712_.m_45610_() + "." + p_63712_.m_45612_() + f_156615_);
        RegionFile \u00e2\u02dc\u01924 = new RegionFile(\u00e2\u02dc\u01923, this.f_63700_, this.f_63701_);
        this.f_63699_.putAndMoveToFirst(l, (Object)\u00e2\u02dc\u01924);
        return \u00e2\u02dc\u01924;
    }

    @Nullable
    public CompoundTag m_63706_(ChunkPos p_63707_) throws IOException {
        RegionFile regionFile = this.m_63711_(p_63707_);
        try (DataInputStream \u00e2\u02dc\u01922 = regionFile.m_63645_(p_63707_);){
            if (\u00e2\u02dc\u01922 == null) {
                CompoundTag compoundTag = null;
                return compoundTag;
            }
            CompoundTag compoundTag = NbtIo.m_128928_(\u00e2\u02dc\u01922);
            return compoundTag;
        }
    }

    protected void m_63708_(ChunkPos p_63709_, @Nullable CompoundTag p_63710_) throws IOException {
        RegionFile regionFile = this.m_63711_(p_63709_);
        if (p_63710_ == null) {
            regionFile.m_156613_(p_63709_);
        } else {
            try (DataOutputStream dataOutputStream = regionFile.m_63678_(p_63709_);){
                NbtIo.m_128941_(p_63710_, dataOutputStream);
            }
        }
    }

    @Override
    public void close() throws IOException {
        ExceptionCollector<IOException> exceptionCollector = new ExceptionCollector<IOException>();
        for (RegionFile regionFile : this.f_63699_.values()) {
            try {
                regionFile.close();
            }
            catch (IOException iOException) {
                exceptionCollector.m_13653_(iOException);
            }
        }
        exceptionCollector.m_13652_();
    }

    public void m_63705_() throws IOException {
        for (RegionFile regionFile : this.f_63699_.values()) {
            regionFile.m_63637_();
        }
    }
}

