/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;

public class FlatLevelSource
extends ChunkGenerator {
    public static final Codec<FlatLevelSource> f_64164_ = FlatLevelGeneratorSettings.f_70347_.fieldOf("settings").xmap(FlatLevelSource::new, FlatLevelSource::m_64191_).codec();
    private final FlatLevelGeneratorSettings f_64165_;

    public FlatLevelSource(FlatLevelGeneratorSettings p_64168_) {
        super(new FixedBiomeSource(p_64168_.m_70390_()), new FixedBiomeSource(p_64168_.m_70400_()), p_64168_.m_70395_(), 0L);
        this.f_64165_ = p_64168_;
    }

    @Override
    protected Codec<? extends ChunkGenerator> m_6909_() {
        return f_64164_;
    }

    @Override
    public ChunkGenerator m_6819_(long p_64180_) {
        return this;
    }

    public FlatLevelGeneratorSettings m_64191_() {
        return this.f_64165_;
    }

    @Override
    public void m_7338_(WorldGenRegion p_64182_, ChunkAccess p_64183_) {
    }

    @Override
    public int m_142051_(LevelHeightAccessor p_158279_) {
        return p_158279_.m_141937_() + Math.min(p_158279_.m_141928_(), this.f_64165_.m_161917_().size());
    }

    @Override
    public CompletableFuture<ChunkAccess> m_142189_(Executor p_158281_, StructureFeatureManager p_158282_, ChunkAccess p_158283_) {
        List<BlockState> list = this.f_64165_.m_161917_();
        BlockPos.MutableBlockPos \u00e2\u02dc\u01922 = new BlockPos.MutableBlockPos();
        Heightmap \u00e2\u02dc\u01923 = p_158283_.m_6005_(Heightmap.Types.OCEAN_FLOOR_WG);
        Heightmap \u00e2\u02dc\u01924 = p_158283_.m_6005_(Heightmap.Types.WORLD_SURFACE_WG);
        for (int i = 0; i < Math.min(p_158283_.m_141928_(), list.size()); ++i) {
            BlockState blockState = list.get(i);
            if (blockState == null) continue;
            int \u00e2\u02dc\u01925 = p_158283_.m_141937_() + i;
            for (int j = 0; j < 16; ++j) {
                for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < 16; ++\u00e2\u02dc\u0192) {
                    p_158283_.m_6978_(\u00e2\u02dc\u01922.m_122178_(j, \u00e2\u02dc\u01925, \u00e2\u02dc\u0192), blockState, false);
                    \u00e2\u02dc\u01923.m_64249_(j, \u00e2\u02dc\u01925, \u00e2\u02dc\u0192, blockState);
                    \u00e2\u02dc\u01924.m_64249_(j, \u00e2\u02dc\u01925, \u00e2\u02dc\u0192, blockState);
                }
            }
        }
        return CompletableFuture.completedFuture(p_158283_);
    }

    @Override
    public int m_142647_(int p_158274_, int p_158275_, Heightmap.Types p_158276_, LevelHeightAccessor p_158277_) {
        List<BlockState> list = this.f_64165_.m_161917_();
        for (int i = Math.min(list.size(), p_158277_.m_151558_()) - 1; i >= 0; --i) {
            BlockState blockState = list.get(i);
            if (blockState == null || !p_158276_.m_64299_().test(blockState)) continue;
            return p_158277_.m_141937_() + i + 1;
        }
        return p_158277_.m_141937_();
    }

    @Override
    public NoiseColumn m_141914_(int p_158270_, int p_158271_, LevelHeightAccessor p_158272_) {
        return new NoiseColumn(p_158272_.m_141937_(), (BlockState[])this.f_64165_.m_161917_().stream().limit(p_158272_.m_141928_()).map(p_64189_ -> p_64189_ == null ? Blocks.f_50016_.m_49966_() : p_64189_).toArray(BlockState[]::new));
    }
}

