/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.util.BitStorage;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Heightmap {
    private static final Logger f_158363_ = LogManager.getLogger();
    static final Predicate<BlockState> f_64230_ = p_64263_ -> !p_64263_.m_60795_();
    static final Predicate<BlockState> f_64231_ = p_64255_ -> p_64255_.m_60767_().m_76334_();
    private final BitStorage f_64232_;
    private final Predicate<BlockState> f_64233_;
    private final ChunkAccess f_64234_;

    public Heightmap(ChunkAccess p_64237_, Types p_64238_) {
        this.f_64233_ = p_64238_.m_64299_();
        this.f_64234_ = p_64237_;
        int n = Mth.m_14163_(p_64237_.m_141928_() + 1);
        this.f_64232_ = new BitStorage(n, 256);
    }

    public static void m_64256_(ChunkAccess p_64257_, Set<Types> p_64258_) {
        int n = p_64258_.size();
        ObjectArrayList \u00e2\u02dc\u01922 = new ObjectArrayList(n);
        ObjectListIterator \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922.iterator();
        int n2 = p_64257_.m_62098_() + 16;
        BlockPos.MutableBlockPos \u00e2\u02dc\u01924 = new BlockPos.MutableBlockPos();
        for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < 16; ++\u00e2\u02dc\u0192) {
            block1: for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < 16; ++\u00e2\u02dc\u0192) {
                for (Types types : p_64258_) {
                    \u00e2\u02dc\u01922.add((Object)p_64257_.m_6005_(types));
                }
                for (int i = n2 - 1; i >= p_64257_.m_141937_(); --i) {
                    \u00e2\u02dc\u01924.m_122178_(\u00e2\u02dc\u0192, i, \u00e2\u02dc\u0192);
                    BlockState blockState = p_64257_.m_8055_(\u00e2\u02dc\u01924);
                    if (blockState.m_60713_(Blocks.f_50016_)) continue;
                    while (\u00e2\u02dc\u01923.hasNext()) {
                        Heightmap heightmap = (Heightmap)\u00e2\u02dc\u01923.next();
                        if (!heightmap.f_64233_.test(blockState)) continue;
                        heightmap.m_64245_(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192, i + 1);
                        \u00e2\u02dc\u01923.remove();
                    }
                    if (\u00e2\u02dc\u01922.isEmpty()) continue block1;
                    \u00e2\u02dc\u01923.back(n);
                }
            }
        }
    }

    public boolean m_64249_(int p_64250_, int p_64251_, int p_64252_, BlockState p_64253_) {
        int n = this.m_64242_(p_64250_, p_64252_);
        if (p_64251_ <= n - 2) {
            return false;
        }
        if (this.f_64233_.test(p_64253_)) {
            if (p_64251_ >= n) {
                this.m_64245_(p_64250_, p_64252_, p_64251_ + 1);
                return true;
            }
        } else if (n - 1 == p_64251_) {
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            for (int i = p_64251_ - 1; i >= this.f_64234_.m_141937_(); --i) {
                mutableBlockPos.m_122178_(p_64250_, i, p_64252_);
                if (!this.f_64233_.test(this.f_64234_.m_8055_(mutableBlockPos))) continue;
                this.m_64245_(p_64250_, p_64252_, i + 1);
                return true;
            }
            this.m_64245_(p_64250_, p_64252_, this.f_64234_.m_141937_());
            return true;
        }
        return false;
    }

    public int m_64242_(int p_64243_, int p_64244_) {
        return this.m_64240_(Heightmap.m_64265_(p_64243_, p_64244_));
    }

    public int m_158368_(int p_158369_, int p_158370_) {
        return this.m_64240_(Heightmap.m_64265_(p_158369_, p_158370_)) - 1;
    }

    private int m_64240_(int p_64241_) {
        return this.f_64232_.m_13514_(p_64241_) + this.f_64234_.m_141937_();
    }

    private void m_64245_(int p_64246_, int p_64247_, int p_64248_) {
        this.f_64232_.m_13524_(Heightmap.m_64265_(p_64246_, p_64247_), p_64248_ - this.f_64234_.m_141937_());
    }

    public void m_158364_(ChunkAccess p_158365_, Types p_158366_, long[] p_158367_) {
        long[] lArray = this.f_64232_.m_13513_();
        if (lArray.length == p_158367_.length) {
            System.arraycopy(p_158367_, 0, lArray, 0, p_158367_.length);
            return;
        }
        f_158363_.warn("Ignoring heightmap data for chunk " + p_158365_.m_7697_() + ", size does not match; expected: " + lArray.length + ", got: " + p_158367_.length);
        Heightmap.m_64256_(p_158365_, EnumSet.of(p_158366_));
    }

    public long[] m_64239_() {
        return this.f_64232_.m_13513_();
    }

    private static int m_64265_(int p_64266_, int p_64267_) {
        return p_64266_ + p_64267_ * 16;
    }

    public static final class Types
    extends Enum<Types>
    implements StringRepresentable {
        public static final /* enum */ Types WORLD_SURFACE_WG = new Types("WORLD_SURFACE_WG", Usage.WORLDGEN, f_64230_);
        public static final /* enum */ Types WORLD_SURFACE = new Types("WORLD_SURFACE", Usage.CLIENT, f_64230_);
        public static final /* enum */ Types OCEAN_FLOOR_WG = new Types("OCEAN_FLOOR_WG", Usage.WORLDGEN, f_64231_);
        public static final /* enum */ Types OCEAN_FLOOR = new Types("OCEAN_FLOOR", Usage.LIVE_WORLD, f_64231_);
        public static final /* enum */ Types MOTION_BLOCKING = new Types("MOTION_BLOCKING", Usage.CLIENT, p_64296_ -> p_64296_.m_60767_().m_76334_() || !p_64296_.m_60819_().m_76178_());
        public static final /* enum */ Types MOTION_BLOCKING_NO_LEAVES = new Types("MOTION_BLOCKING_NO_LEAVES", Usage.LIVE_WORLD, p_64289_ -> (p_64289_.m_60767_().m_76334_() || !p_64289_.m_60819_().m_76178_()) && !(p_64289_.m_60734_() instanceof LeavesBlock));
        public static final Codec<Types> f_64274_;
        private final String f_64275_;
        private final Usage f_64276_;
        private final Predicate<BlockState> f_64277_;
        private static final Map<String, Types> f_64278_;
        private static final /* synthetic */ Types[] $VALUES;

        public static Types[] values() {
            return (Types[])$VALUES.clone();
        }

        public static Types valueOf(String p_64301_) {
            return Enum.valueOf(Types.class, p_64301_);
        }

        private Types(String p_64284_, Usage p_64285_, Predicate<BlockState> p_64286_) {
            this.f_64275_ = p_64284_;
            this.f_64276_ = p_64285_;
            this.f_64277_ = p_64286_;
        }

        public String m_64294_() {
            return this.f_64275_;
        }

        public boolean m_64297_() {
            return this.f_64276_ == Usage.CLIENT;
        }

        public boolean m_64298_() {
            return this.f_64276_ != Usage.WORLDGEN;
        }

        @Nullable
        public static Types m_64290_(String p_64291_) {
            return f_64278_.get(p_64291_);
        }

        public Predicate<BlockState> m_64299_() {
            return this.f_64277_;
        }

        @Override
        public String m_7912_() {
            return this.f_64275_;
        }

        private static /* synthetic */ Types[] m_158371_() {
            return new Types[]{WORLD_SURFACE_WG, WORLD_SURFACE, OCEAN_FLOOR_WG, OCEAN_FLOOR, MOTION_BLOCKING, MOTION_BLOCKING_NO_LEAVES};
        }

        static {
            $VALUES = Types.m_158371_();
            f_64274_ = StringRepresentable.m_14350_(Types::values, Types::m_64290_);
            f_64278_ = Util.m_137469_(Maps.newHashMap(), p_64293_ -> {
                for (Types types : Types.values()) {
                    p_64293_.put(types.f_64275_, types);
                }
            });
        }
    }

    public static final class Usage
    extends Enum<Usage> {
        public static final /* enum */ Usage WORLDGEN = new Usage();
        public static final /* enum */ Usage LIVE_WORLD = new Usage();
        public static final /* enum */ Usage CLIENT = new Usage();
        private static final /* synthetic */ Usage[] $VALUES;

        public static Usage[] values() {
            return (Usage[])$VALUES.clone();
        }

        public static Usage valueOf(String p_64312_) {
            return Enum.valueOf(Usage.class, p_64312_);
        }

        private static /* synthetic */ Usage[] m_158372_() {
            return new Usage[]{WORLDGEN, LIVE_WORLD, CLIENT};
        }

        static {
            $VALUES = Usage.m_158372_();
        }
    }
}

