/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.OptionalInt;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.DoubleFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.Mth;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.BaseStoneSource;
import net.minecraft.world.level.levelgen.Beardifier;
import net.minecraft.world.level.levelgen.Cavifier;
import net.minecraft.world.level.levelgen.DepthBasedReplacingBaseStoneSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseInterpolator;
import net.minecraft.world.level.levelgen.NoiseModifier;
import net.minecraft.world.level.levelgen.NoiseSampler;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.NoodleCavifier;
import net.minecraft.world.level.levelgen.OreVeinifier;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.SimpleRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.synth.BlendedNoise;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraft.world.level.levelgen.synth.PerlinNoise;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;
import net.minecraft.world.level.levelgen.synth.SurfaceNoise;

public final class NoiseBasedChunkGenerator
extends ChunkGenerator {
    public static final Codec<NoiseBasedChunkGenerator> f_64314_ = RecordCodecBuilder.create(p_64405_ -> p_64405_.group((App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(p_158489_ -> p_158489_.f_62137_), (App)Codec.LONG.fieldOf("seed").stable().forGetter(p_158487_ -> p_158487_.f_64333_), (App)NoiseGeneratorSettings.f_64431_.fieldOf("settings").forGetter(p_158458_ -> p_158458_.f_64318_)).apply((Applicative)p_64405_, p_64405_.stable(NoiseBasedChunkGenerator::new)));
    private static final BlockState f_64321_ = Blocks.f_50016_.m_49966_();
    private static final BlockState[] f_158373_ = new BlockState[0];
    private final int f_158374_;
    private final int f_158375_;
    final int f_158376_;
    final int f_158377_;
    final int f_158378_;
    private final SurfaceNoise f_64330_;
    private final NormalNoise f_158379_;
    private final NormalNoise f_158380_;
    private final NormalNoise f_158381_;
    protected final BlockState f_64316_;
    protected final BlockState f_64317_;
    private final long f_64333_;
    protected final Supplier<NoiseGeneratorSettings> f_64318_;
    private final int f_64334_;
    private final NoiseSampler f_158382_;
    private final BaseStoneSource f_158383_;
    final OreVeinifier f_158384_;
    final NoodleCavifier f_158385_;

    public NoiseBasedChunkGenerator(BiomeSource p_64337_, long p_64338_, Supplier<NoiseGeneratorSettings> p_64339_) {
        this(p_64337_, p_64337_, p_64338_, p_64339_);
    }

    private NoiseBasedChunkGenerator(BiomeSource p_64341_, BiomeSource p_64342_, long p_64343_, Supplier<NoiseGeneratorSettings> p_64344_) {
        super(p_64341_, p_64342_, p_64344_.get().m_64457_(), p_64343_);
        SimplexNoise \u00e2\u02dc\u01926;
        this.f_64333_ = p_64343_;
        NoiseGeneratorSettings noiseGeneratorSettings = p_64344_.get();
        this.f_64318_ = p_64344_;
        NoiseSettings \u00e2\u02dc\u01922 = noiseGeneratorSettings.m_64481_();
        this.f_64334_ = \u00e2\u02dc\u01922.m_64534_();
        this.f_158374_ = QuartPos.m_175402_(\u00e2\u02dc\u01922.m_64541_());
        this.f_158375_ = QuartPos.m_175402_(\u00e2\u02dc\u01922.m_64540_());
        this.f_64316_ = noiseGeneratorSettings.m_64482_();
        this.f_64317_ = noiseGeneratorSettings.m_64483_();
        this.f_158376_ = 16 / this.f_158375_;
        this.f_158377_ = \u00e2\u02dc\u01922.m_64534_() / this.f_158374_;
        this.f_158378_ = 16 / this.f_158375_;
        WorldgenRandom \u00e2\u02dc\u01923 = new WorldgenRandom(p_64343_);
        BlendedNoise \u00e2\u02dc\u01924 = new BlendedNoise(\u00e2\u02dc\u01923);
        this.f_64330_ = \u00e2\u02dc\u01922.m_64544_() ? new PerlinSimplexNoise((RandomSource)\u00e2\u02dc\u01923, IntStream.rangeClosed(-3, 0)) : new PerlinNoise((RandomSource)\u00e2\u02dc\u01923, IntStream.rangeClosed(-3, 0));
        \u00e2\u02dc\u01923.m_158876_(2620);
        PerlinNoise \u00e2\u02dc\u01925 = new PerlinNoise((RandomSource)\u00e2\u02dc\u01923, IntStream.rangeClosed(-15, 0));
        if (\u00e2\u02dc\u01922.m_64546_()) {
            Object object = new WorldgenRandom(p_64343_);
            object.m_158876_(17292);
            \u00e2\u02dc\u01926 = new SimplexNoise((RandomSource)object);
        } else {
            \u00e2\u02dc\u01926 = null;
        }
        this.f_158379_ = NormalNoise.m_164354_(new SimpleRandomSource(\u00e2\u02dc\u01923.nextLong()), -3, 1.0);
        this.f_158380_ = NormalNoise.m_164354_(new SimpleRandomSource(\u00e2\u02dc\u01923.nextLong()), -3, 1.0, 0.0, 2.0);
        this.f_158381_ = NormalNoise.m_164354_(new SimpleRandomSource(\u00e2\u02dc\u01923.nextLong()), -1, 1.0, 0.0);
        object = noiseGeneratorSettings.m_158568_() ? new Cavifier(\u00e2\u02dc\u01923, \u00e2\u02dc\u01922.m_158703_() / this.f_158374_) : NoiseModifier.f_158626_;
        this.f_158382_ = new NoiseSampler(p_64341_, this.f_158375_, this.f_158374_, this.f_158377_, \u00e2\u02dc\u01922, \u00e2\u02dc\u01924, \u00e2\u02dc\u01926, \u00e2\u02dc\u01925, (NoiseModifier)object);
        this.f_158383_ = new DepthBasedReplacingBaseStoneSource(p_64343_, this.f_64316_, Blocks.f_152550_.m_49966_(), noiseGeneratorSettings);
        this.f_158384_ = new OreVeinifier(p_64343_, this.f_64316_, this.f_158375_, this.f_158374_, noiseGeneratorSettings.m_64481_().m_158703_());
        this.f_158385_ = new NoodleCavifier(p_64343_);
    }

    private boolean m_158492_() {
        return this.f_64318_.get().m_158567_();
    }

    @Override
    protected Codec<? extends ChunkGenerator> m_6909_() {
        return f_64314_;
    }

    @Override
    public ChunkGenerator m_6819_(long p_64374_) {
        return new NoiseBasedChunkGenerator(this.f_62137_.m_7206_(p_64374_), p_64374_, this.f_64318_);
    }

    public boolean m_64375_(long p_64376_, ResourceKey<NoiseGeneratorSettings> p_64377_) {
        return this.f_64333_ == p_64376_ && this.f_64318_.get().m_64476_(p_64377_);
    }

    private double[] m_158391_(int p_158392_, int p_158393_, int p_158394_, int p_158395_) {
        double[] dArray = new double[p_158395_ + 1];
        this.m_158466_(dArray, p_158392_, p_158393_, p_158394_, p_158395_);
        return dArray;
    }

    private void m_158466_(double[] p_158467_, int p_158468_, int p_158469_, int p_158470_, int p_158471_) {
        NoiseSettings noiseSettings = this.f_64318_.get().m_64481_();
        this.f_158382_.m_158678_(p_158467_, p_158468_, p_158469_, noiseSettings, this.m_6337_(), p_158470_, p_158471_);
    }

    @Override
    public int m_142647_(int p_158405_, int p_158406_, Heightmap.Types p_158407_, LevelHeightAccessor p_158408_) {
        int n = Math.max(this.f_64318_.get().m_64481_().m_158703_(), p_158408_.m_141937_());
        \u00e2\u02dc\u0192 = Math.min(this.f_64318_.get().m_64481_().m_158703_() + this.f_64318_.get().m_64481_().m_64534_(), p_158408_.m_151558_());
        \u00e2\u02dc\u0192 = Mth.m_14042_(n, this.f_158374_);
        \u00e2\u02dc\u0192 = Mth.m_14042_(\u00e2\u02dc\u0192 - n, this.f_158374_);
        if (\u00e2\u02dc\u0192 <= 0) {
            return p_158408_.m_141937_();
        }
        return this.m_158413_(p_158405_, p_158406_, null, p_158407_.m_64299_(), \u00e2\u02dc\u0192, \u00e2\u02dc\u0192).orElse(p_158408_.m_141937_());
    }

    @Override
    public NoiseColumn m_141914_(int p_158401_, int p_158402_, LevelHeightAccessor p_158403_) {
        int n = Math.max(this.f_64318_.get().m_64481_().m_158703_(), p_158403_.m_141937_());
        \u00e2\u02dc\u0192 = Math.min(this.f_64318_.get().m_64481_().m_158703_() + this.f_64318_.get().m_64481_().m_64534_(), p_158403_.m_151558_());
        \u00e2\u02dc\u0192 = Mth.m_14042_(n, this.f_158374_);
        \u00e2\u02dc\u0192 = Mth.m_14042_(\u00e2\u02dc\u0192 - n, this.f_158374_);
        if (\u00e2\u02dc\u0192 <= 0) {
            return new NoiseColumn(n, f_158373_);
        }
        BlockState[] \u00e2\u02dc\u01922 = new BlockState[\u00e2\u02dc\u0192 * this.f_158374_];
        this.m_158413_(p_158401_, p_158402_, \u00e2\u02dc\u01922, null, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
        return new NoiseColumn(n, \u00e2\u02dc\u01922);
    }

    @Override
    public BaseStoneSource m_142168_() {
        return this.f_158383_;
    }

    private OptionalInt m_158413_(int p_158414_, int p_158415_, @Nullable BlockState[] p_158416_, @Nullable Predicate<BlockState> p_158417_, int p_158418_, int p_158419_) {
        int n = SectionPos.m_123171_(p_158414_);
        \u00e2\u02dc\u0192 = SectionPos.m_123171_(p_158415_);
        \u00e2\u02dc\u0192 = Math.floorDiv(p_158414_, this.f_158375_);
        \u00e2\u02dc\u0192 = Math.floorDiv(p_158415_, this.f_158375_);
        \u00e2\u02dc\u0192 = Math.floorMod(p_158414_, this.f_158375_);
        \u00e2\u02dc\u0192 = Math.floorMod(p_158415_, this.f_158375_);
        double \u00e2\u02dc\u01922 = (double)\u00e2\u02dc\u0192 / (double)this.f_158375_;
        double \u00e2\u02dc\u01923 = (double)\u00e2\u02dc\u0192 / (double)this.f_158375_;
        double[][] \u00e2\u02dc\u01924 = new double[][]{this.m_158391_(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192, p_158418_, p_158419_), this.m_158391_(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192 + 1, p_158418_, p_158419_), this.m_158391_(\u00e2\u02dc\u0192 + 1, \u00e2\u02dc\u0192, p_158418_, p_158419_), this.m_158391_(\u00e2\u02dc\u0192 + 1, \u00e2\u02dc\u0192 + 1, p_158418_, p_158419_)};
        Aquifer \u00e2\u02dc\u01925 = this.m_158396_(p_158418_, p_158419_, new ChunkPos(n, \u00e2\u02dc\u0192));
        for (\u00e2\u02dc\u0192 = p_158419_ - 1; \u00e2\u02dc\u0192 >= 0; --\u00e2\u02dc\u0192) {
            double d = \u00e2\u02dc\u01924[0][\u00e2\u02dc\u0192];
            \u00e2\u02dc\u0192 = \u00e2\u02dc\u01924[1][\u00e2\u02dc\u0192];
            \u00e2\u02dc\u0192 = \u00e2\u02dc\u01924[2][\u00e2\u02dc\u0192];
            \u00e2\u02dc\u0192 = \u00e2\u02dc\u01924[3][\u00e2\u02dc\u0192];
            \u00e2\u02dc\u0192 = \u00e2\u02dc\u01924[0][\u00e2\u02dc\u0192 + 1];
            \u00e2\u02dc\u0192 = \u00e2\u02dc\u01924[1][\u00e2\u02dc\u0192 + 1];
            \u00e2\u02dc\u0192 = \u00e2\u02dc\u01924[2][\u00e2\u02dc\u0192 + 1];
            \u00e2\u02dc\u0192 = \u00e2\u02dc\u01924[3][\u00e2\u02dc\u0192 + 1];
            for (int i = this.f_158374_ - 1; i >= 0; --i) {
                double d2 = (double)i / (double)this.f_158374_;
                \u00e2\u02dc\u0192 = Mth.m_14019_(d2, \u00e2\u02dc\u01922, \u00e2\u02dc\u01923, d, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
                int \u00e2\u02dc\u01926 = \u00e2\u02dc\u0192 * this.f_158374_ + i;
                int \u00e2\u02dc\u01927 = \u00e2\u02dc\u01926 + p_158418_ * this.f_158374_;
                BlockState \u00e2\u02dc\u01928 = this.m_158439_(Beardifier.f_158059_, \u00e2\u02dc\u01925, this.f_158383_, NoiseModifier.f_158626_, p_158414_, \u00e2\u02dc\u01927, p_158415_, \u00e2\u02dc\u0192);
                if (p_158416_ != null) {
                    p_158416_[\u00e2\u02dc\u01926] = \u00e2\u02dc\u01928;
                }
                if (p_158417_ == null || !p_158417_.test(\u00e2\u02dc\u01928)) continue;
                return OptionalInt.of(\u00e2\u02dc\u01927 + 1);
            }
        }
        return OptionalInt.empty();
    }

    private Aquifer m_158396_(int p_158397_, int p_158398_, ChunkPos p_158399_) {
        if (!this.m_158492_()) {
            return Aquifer.m_157956_(this.m_6337_(), this.f_64317_);
        }
        return Aquifer.m_157959_(p_158399_, this.f_158379_, this.f_158380_, this.f_158381_, this.f_64318_.get(), this.f_158382_, p_158397_ * this.f_158374_, p_158398_ * this.f_158374_);
    }

    protected BlockState m_158439_(Beardifier p_158440_, Aquifer p_158441_, BaseStoneSource p_158442_, NoiseModifier p_158443_, int p_158444_, int p_158445_, int p_158446_, double p_158447_) {
        double d = Mth.m_14008_(p_158447_ / 200.0, -1.0, 1.0);
        d = d / 2.0 - d * d * d / 24.0;
        d = p_158443_.m_142124_(d, p_158444_, p_158445_, p_158446_);
        return p_158441_.m_142419_(p_158442_, p_158444_, p_158445_, p_158446_, d += p_158440_.m_158072_(p_158444_, p_158445_, p_158446_));
    }

    @Override
    public void m_7338_(WorldGenRegion p_64381_, ChunkAccess p_64382_) {
        ChunkPos chunkPos = p_64382_.m_7697_();
        int \u00e2\u02dc\u01922 = chunkPos.f_45578_;
        int \u00e2\u02dc\u01923 = chunkPos.f_45579_;
        WorldgenRandom \u00e2\u02dc\u01924 = new WorldgenRandom();
        \u00e2\u02dc\u01924.m_64682_(\u00e2\u02dc\u01922, \u00e2\u02dc\u01923);
        \u00e2\u02dc\u0192 = p_64382_.m_7697_();
        int \u00e2\u02dc\u01925 = \u00e2\u02dc\u0192.m_45604_();
        int \u00e2\u02dc\u01926 = \u00e2\u02dc\u0192.m_45605_();
        double \u00e2\u02dc\u01927 = 0.0625;
        BlockPos.MutableBlockPos \u00e2\u02dc\u01928 = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 16; ++i) {
            for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < 16; ++\u00e2\u02dc\u0192) {
                \u00e2\u02dc\u0192 = \u00e2\u02dc\u01925 + i;
                \u00e2\u02dc\u0192 = \u00e2\u02dc\u01926 + \u00e2\u02dc\u0192;
                \u00e2\u02dc\u0192 = p_64382_.m_5885_(Heightmap.Types.WORLD_SURFACE_WG, i, \u00e2\u02dc\u0192) + 1;
                double d = this.f_64330_.m_5495_((double)\u00e2\u02dc\u0192 * 0.0625, (double)\u00e2\u02dc\u0192 * 0.0625, 0.0625, (double)i * 0.0625) * 15.0;
                int \u00e2\u02dc\u01929 = this.f_64318_.get().m_158566_();
                p_64381_.m_46857_(\u00e2\u02dc\u01928.m_122178_(\u00e2\u02dc\u01925 + i, \u00e2\u02dc\u0192, \u00e2\u02dc\u01926 + \u00e2\u02dc\u0192)).m_151682_(\u00e2\u02dc\u01924, p_64382_, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, d, this.f_64316_, this.f_64317_, this.m_6337_(), \u00e2\u02dc\u01929, p_64381_.m_7328_());
            }
        }
        this.m_64399_(p_64382_, \u00e2\u02dc\u01924);
    }

    private void m_64399_(ChunkAccess p_64400_, Random p_64401_) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int \u00e2\u02dc\u01922 = p_64400_.m_7697_().m_45604_();
        int \u00e2\u02dc\u01923 = p_64400_.m_7697_().m_45605_();
        NoiseGeneratorSettings \u00e2\u02dc\u01924 = this.f_64318_.get();
        int \u00e2\u02dc\u01925 = \u00e2\u02dc\u01924.m_64481_().m_158703_();
        int \u00e2\u02dc\u01926 = \u00e2\u02dc\u01925 + \u00e2\u02dc\u01924.m_64485_();
        int \u00e2\u02dc\u01927 = this.f_64334_ - 1 + \u00e2\u02dc\u01925 - \u00e2\u02dc\u01924.m_64484_();
        int \u00e2\u02dc\u01928 = 5;
        int \u00e2\u02dc\u01929 = p_64400_.m_141937_();
        int \u00e2\u02dc\u019210 = p_64400_.m_151558_();
        boolean \u00e2\u02dc\u019211 = \u00e2\u02dc\u01927 + 5 - 1 >= \u00e2\u02dc\u01929 && \u00e2\u02dc\u01927 < \u00e2\u02dc\u019210;
        boolean bl = bl2 = \u00e2\u02dc\u01926 + 5 - 1 >= \u00e2\u02dc\u01929 && \u00e2\u02dc\u01926 < \u00e2\u02dc\u019210;
        if (!\u00e2\u02dc\u019211 && !bl2) {
            return;
        }
        for (BlockPos blockPos : BlockPos.m_121976_(\u00e2\u02dc\u01922, 0, \u00e2\u02dc\u01923, \u00e2\u02dc\u01922 + 15, 0, \u00e2\u02dc\u01923 + 15)) {
            boolean bl2;
            int n;
            if (\u00e2\u02dc\u019211) {
                for (n = 0; n < 5; ++n) {
                    if (n > p_64401_.nextInt(5)) continue;
                    p_64400_.m_6978_(mutableBlockPos.m_122178_(blockPos.m_123341_(), \u00e2\u02dc\u01927 - n, blockPos.m_123343_()), Blocks.f_50752_.m_49966_(), false);
                }
            }
            if (!bl2) continue;
            for (n = 4; n >= 0; --n) {
                if (n > p_64401_.nextInt(5)) continue;
                p_64400_.m_6978_(mutableBlockPos.m_122178_(blockPos.m_123341_(), \u00e2\u02dc\u01926 + n, blockPos.m_123343_()), Blocks.f_50752_.m_49966_(), false);
            }
        }
    }

    @Override
    public CompletableFuture<ChunkAccess> m_142189_(Executor p_158463_, StructureFeatureManager p_158464_, ChunkAccess p_158465_) {
        NoiseSettings noiseSettings = this.f_64318_.get().m_64481_();
        int \u00e2\u02dc\u01922 = Math.max(noiseSettings.m_158703_(), p_158465_.m_141937_());
        int \u00e2\u02dc\u01923 = Math.min(noiseSettings.m_158703_() + noiseSettings.m_64534_(), p_158465_.m_151558_());
        int \u00e2\u02dc\u01924 = Mth.m_14042_(\u00e2\u02dc\u01922, this.f_158374_);
        int \u00e2\u02dc\u01925 = Mth.m_14042_(\u00e2\u02dc\u01923 - \u00e2\u02dc\u01922, this.f_158374_);
        if (\u00e2\u02dc\u01925 <= 0) {
            return CompletableFuture.completedFuture(p_158465_);
        }
        int \u00e2\u02dc\u01926 = p_158465_.m_151564_(\u00e2\u02dc\u01925 * this.f_158374_ - 1 + \u00e2\u02dc\u01922);
        int \u00e2\u02dc\u01927 = p_158465_.m_151564_(\u00e2\u02dc\u01922);
        return CompletableFuture.supplyAsync(() -> {
            HashSet hashSet = Sets.newHashSet();
            try {
                for (int i = \u00e2\u02dc\u01926; i >= \u00e2\u02dc\u01927; --i) {
                    LevelChunkSection levelChunkSection = p_158465_.m_156115_(i);
                    levelChunkSection.m_62981_();
                    hashSet.add(levelChunkSection);
                }
                ChunkAccess chunkAccess = this.m_158427_(p_158464_, p_158465_, \u00e2\u02dc\u01924, \u00e2\u02dc\u01925);
                return chunkAccess;
            }
            finally {
                for (LevelChunkSection \u00e2\u02dc\u01922 : hashSet) {
                    \u00e2\u02dc\u01922.m_63006_();
                }
            }
        }, Util.m_137578_());
    }

    private ChunkAccess m_158427_(StructureFeatureManager p_158428_, ChunkAccess p_158429_, int p_158430_, int p_158431_) {
        Heightmap heightmap = p_158429_.m_6005_(Heightmap.Types.OCEAN_FLOOR_WG);
        \u00e2\u02dc\u0192 = p_158429_.m_6005_(Heightmap.Types.WORLD_SURFACE_WG);
        ChunkPos \u00e2\u02dc\u01922 = p_158429_.m_7697_();
        int \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922.m_45604_();
        int \u00e2\u02dc\u01924 = \u00e2\u02dc\u01922.m_45605_();
        Beardifier \u00e2\u02dc\u01925 = new Beardifier(p_158428_, p_158429_);
        Aquifer \u00e2\u02dc\u01926 = this.m_158396_(p_158430_, p_158431_, \u00e2\u02dc\u01922);
        NoiseInterpolator \u00e2\u02dc\u01927 = new NoiseInterpolator(this.f_158376_, p_158431_, this.f_158378_, \u00e2\u02dc\u01922, p_158430_, this::m_158466_);
        ArrayList \u00e2\u02dc\u01928 = Lists.newArrayList((Object[])new NoiseInterpolator[]{\u00e2\u02dc\u01927});
        Consumer<NoiseInterpolator> \u00e2\u02dc\u01929 = \u00e2\u02dc\u01928::add;
        DoubleFunction<BaseStoneSource> \u00e2\u02dc\u019210 = this.m_158477_(p_158430_, \u00e2\u02dc\u01922, \u00e2\u02dc\u01929);
        DoubleFunction<NoiseModifier> \u00e2\u02dc\u019211 = this.m_158420_(p_158430_, \u00e2\u02dc\u01922, \u00e2\u02dc\u01929);
        \u00e2\u02dc\u01928.forEach(NoiseInterpolator::m_158601_);
        BlockPos.MutableBlockPos \u00e2\u02dc\u019212 = new BlockPos.MutableBlockPos();
        for (int i = 0; i < this.f_158376_; ++i) {
            \u00e2\u02dc\u0192 = i;
            \u00e2\u02dc\u01928.forEach(p_158426_ -> p_158426_.m_158604_(\u00e2\u02dc\u0192));
            for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < this.f_158378_; ++\u00e2\u02dc\u0192) {
                LevelChunkSection levelChunkSection = p_158429_.m_156115_(p_158429_.m_151559_() - 1);
                for (int j = p_158431_ - 1; j >= 0; --j) {
                    \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192;
                    \u00e2\u02dc\u0192 = j;
                    \u00e2\u02dc\u01928.forEach(p_158412_ -> p_158412_.m_158606_(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192));
                    for (n = this.f_158374_ - 1; n >= 0; --n) {
                        int n;
                        \u00e2\u02dc\u0192 = (p_158430_ + j) * this.f_158374_ + n;
                        \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 & 0xF;
                        \u00e2\u02dc\u0192 = p_158429_.m_151564_(\u00e2\u02dc\u0192);
                        if (p_158429_.m_151564_(levelChunkSection.m_63017_()) != \u00e2\u02dc\u0192) {
                            levelChunkSection = p_158429_.m_156115_(\u00e2\u02dc\u0192);
                        }
                        double \u00e2\u02dc\u019213 = (double)n / (double)this.f_158374_;
                        \u00e2\u02dc\u01928.forEach(p_158476_ -> p_158476_.m_158602_(\u00e2\u02dc\u019213));
                        for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < this.f_158375_; ++\u00e2\u02dc\u0192) {
                            \u00e2\u02dc\u0192 = \u00e2\u02dc\u01923 + i * this.f_158375_ + \u00e2\u02dc\u0192;
                            \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 & 0xF;
                            double d = (double)\u00e2\u02dc\u0192 / (double)this.f_158375_;
                            \u00e2\u02dc\u01928.forEach(p_158390_ -> p_158390_.m_158613_(d));
                            for (int k = 0; k < this.f_158375_; ++k) {
                                \u00e2\u02dc\u0192 = \u00e2\u02dc\u01924 + \u00e2\u02dc\u0192 * this.f_158375_ + k;
                                \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 & 0xF;
                                double d2 = (double)k / (double)this.f_158375_;
                                \u00e2\u02dc\u0192 = \u00e2\u02dc\u01927.m_158618_(d2);
                                BlockState \u00e2\u02dc\u019214 = this.m_158439_(\u00e2\u02dc\u01925, \u00e2\u02dc\u01926, \u00e2\u02dc\u019210.apply(d2), \u00e2\u02dc\u019211.apply(d2), \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
                                if (\u00e2\u02dc\u019214 == f_64321_) continue;
                                if (\u00e2\u02dc\u019214.m_60791_() != 0 && p_158429_ instanceof ProtoChunk) {
                                    \u00e2\u02dc\u019212.m_122178_(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
                                    ((ProtoChunk)p_158429_).m_63277_(\u00e2\u02dc\u019212);
                                }
                                levelChunkSection.m_62991_(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u019214, false);
                                heightmap.m_64249_(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u019214);
                                \u00e2\u02dc\u0192.m_64249_(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u019214);
                                if (!\u00e2\u02dc\u01926.m_142203_() || \u00e2\u02dc\u019214.m_60819_().m_76178_()) continue;
                                \u00e2\u02dc\u019212.m_122178_(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
                                p_158429_.m_5783_().m_5945_(\u00e2\u02dc\u019212, \u00e2\u02dc\u019214.m_60819_().m_76152_(), 0);
                            }
                        }
                    }
                }
            }
            \u00e2\u02dc\u01928.forEach(NoiseInterpolator::m_158612_);
        }
        return p_158429_;
    }

    private DoubleFunction<NoiseModifier> m_158420_(int p_158421_, ChunkPos p_158422_, Consumer<NoiseInterpolator> p_158423_) {
        if (!this.f_64318_.get().m_158571_()) {
            return p_158473_ -> NoiseModifier.f_158626_;
        }
        NoodleCaveNoiseModifier noodleCaveNoiseModifier = new NoodleCaveNoiseModifier(p_158422_, p_158421_);
        noodleCaveNoiseModifier.m_158505_(p_158423_);
        return noodleCaveNoiseModifier::m_158503_;
    }

    private DoubleFunction<BaseStoneSource> m_158477_(int p_158478_, ChunkPos p_158479_, Consumer<NoiseInterpolator> p_158480_) {
        if (!this.f_64318_.get().m_158570_()) {
            return p_158387_ -> this.f_158383_;
        }
        OreVeinNoiseSource oreVeinNoiseSource = new OreVeinNoiseSource(p_158479_, p_158478_, this.f_64333_ + 1L);
        oreVeinNoiseSource.m_158526_(p_158480_);
        BaseStoneSource \u00e2\u02dc\u01922 = (p_158450_, p_158451_, p_158452_) -> {
            BlockState blockState = oreVeinNoiseSource.m_142722_(p_158450_, p_158451_, p_158452_);
            if (blockState != this.f_64316_) {
                return blockState;
            }
            return this.f_158383_.m_142722_(p_158450_, p_158451_, p_158452_);
        };
        return p_158456_ -> {
            oreVeinNoiseSource.m_158524_(p_158456_);
            return \u00e2\u02dc\u01922;
        };
    }

    @Override
    protected Aquifer m_142439_(ChunkAccess p_158438_) {
        ChunkPos chunkPos = p_158438_.m_7697_();
        int \u00e2\u02dc\u01922 = Math.max(this.f_64318_.get().m_64481_().m_158703_(), p_158438_.m_141937_());
        int \u00e2\u02dc\u01923 = Mth.m_14042_(\u00e2\u02dc\u01922, this.f_158374_);
        return this.m_158396_(\u00e2\u02dc\u01923, this.f_158377_, chunkPos);
    }

    @Override
    public int m_6331_() {
        return this.f_64334_;
    }

    @Override
    public int m_6337_() {
        return this.f_64318_.get().m_64486_();
    }

    @Override
    public int m_142062_() {
        return this.f_64318_.get().m_64481_().m_158703_();
    }

    @Override
    public WeightedRandomList<MobSpawnSettings.SpawnerData> m_142184_(Biome p_158433_, StructureFeatureManager p_158434_, MobCategory p_158435_, BlockPos p_158436_) {
        if (p_158434_.m_47285_(p_158436_, true, StructureFeature.f_67021_).m_73603_()) {
            if (p_158435_ == MobCategory.MONSTER) {
                return StructureFeature.f_67021_.m_142494_();
            }
            if (p_158435_ == MobCategory.CREATURE) {
                return StructureFeature.f_67021_.m_142498_();
            }
        }
        if (p_158435_ == MobCategory.MONSTER) {
            if (p_158434_.m_47285_(p_158436_, false, StructureFeature.f_67013_).m_73603_()) {
                return StructureFeature.f_67013_.m_142494_();
            }
            if (p_158434_.m_47285_(p_158436_, false, StructureFeature.f_67023_).m_73603_()) {
                return StructureFeature.f_67023_.m_142494_();
            }
            if (p_158434_.m_47285_(p_158436_, true, StructureFeature.f_67025_).m_73603_()) {
                return StructureFeature.f_67025_.m_142494_();
            }
        }
        if (p_158435_ == MobCategory.UNDERGROUND_WATER_CREATURE && p_158434_.m_47285_(p_158436_, false, StructureFeature.f_67023_).m_73603_()) {
            return StructureFeature.f_67023_.m_160477_();
        }
        return super.m_142184_(p_158433_, p_158434_, p_158435_, p_158436_);
    }

    @Override
    public void m_6929_(WorldGenRegion p_64379_) {
        if (this.f_64318_.get().m_64487_()) {
            return;
        }
        ChunkPos chunkPos = p_64379_.m_143488_();
        Biome \u00e2\u02dc\u01922 = p_64379_.m_46857_(chunkPos.m_45615_());
        WorldgenRandom \u00e2\u02dc\u01923 = new WorldgenRandom();
        \u00e2\u02dc\u01923.m_64690_(p_64379_.m_7328_(), chunkPos.m_45604_(), chunkPos.m_45605_());
        NaturalSpawner.m_151616_(p_64379_, \u00e2\u02dc\u01922, chunkPos, \u00e2\u02dc\u01923);
    }

    class NoodleCaveNoiseModifier
    implements NoiseModifier {
        private final NoiseInterpolator f_158494_;
        private final NoiseInterpolator f_158495_;
        private final NoiseInterpolator f_158496_;
        private final NoiseInterpolator f_158497_;
        private double f_158498_;

        public NoodleCaveNoiseModifier(ChunkPos p_158501_, int p_158502_) {
            this.f_158494_ = new NoiseInterpolator(NoiseBasedChunkGenerator.this.f_158376_, NoiseBasedChunkGenerator.this.f_158377_, NoiseBasedChunkGenerator.this.f_158378_, p_158501_, p_158502_, NoiseBasedChunkGenerator.this.f_158385_::m_158742_);
            this.f_158495_ = new NoiseInterpolator(NoiseBasedChunkGenerator.this.f_158376_, NoiseBasedChunkGenerator.this.f_158377_, NoiseBasedChunkGenerator.this.f_158378_, p_158501_, p_158502_, NoiseBasedChunkGenerator.this.f_158385_::m_158765_);
            this.f_158496_ = new NoiseInterpolator(NoiseBasedChunkGenerator.this.f_158376_, NoiseBasedChunkGenerator.this.f_158377_, NoiseBasedChunkGenerator.this.f_158378_, p_158501_, p_158502_, NoiseBasedChunkGenerator.this.f_158385_::m_158771_);
            this.f_158497_ = new NoiseInterpolator(NoiseBasedChunkGenerator.this.f_158376_, NoiseBasedChunkGenerator.this.f_158377_, NoiseBasedChunkGenerator.this.f_158378_, p_158501_, p_158502_, NoiseBasedChunkGenerator.this.f_158385_::m_158777_);
        }

        public NoiseModifier m_158503_(double p_158504_) {
            this.f_158498_ = p_158504_;
            return this;
        }

        @Override
        public double m_142124_(double p_158508_, int p_158509_, int p_158510_, int p_158511_) {
            double d = this.f_158494_.m_158618_(this.f_158498_);
            \u00e2\u02dc\u0192 = this.f_158495_.m_158618_(this.f_158498_);
            \u00e2\u02dc\u0192 = this.f_158496_.m_158618_(this.f_158498_);
            \u00e2\u02dc\u0192 = this.f_158497_.m_158618_(this.f_158498_);
            return NoiseBasedChunkGenerator.this.f_158385_.m_158732_(p_158508_, p_158509_, p_158510_, p_158511_, d, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, NoiseBasedChunkGenerator.this.m_142062_());
        }

        public void m_158505_(Consumer<NoiseInterpolator> p_158506_) {
            p_158506_.accept(this.f_158494_);
            p_158506_.accept(this.f_158495_);
            p_158506_.accept(this.f_158496_);
            p_158506_.accept(this.f_158497_);
        }
    }

    class OreVeinNoiseSource
    implements BaseStoneSource {
        private final NoiseInterpolator f_158513_;
        private final NoiseInterpolator f_158514_;
        private final NoiseInterpolator f_158515_;
        private double f_158516_;
        private final long f_158517_;
        private final WorldgenRandom f_158518_ = new WorldgenRandom();

        public OreVeinNoiseSource(ChunkPos p_158521_, int p_158522_, long p_158523_) {
            this.f_158513_ = new NoiseInterpolator(NoiseBasedChunkGenerator.this.f_158376_, NoiseBasedChunkGenerator.this.f_158377_, NoiseBasedChunkGenerator.this.f_158378_, p_158521_, p_158522_, NoiseBasedChunkGenerator.this.f_158384_::m_158827_);
            this.f_158514_ = new NoiseInterpolator(NoiseBasedChunkGenerator.this.f_158376_, NoiseBasedChunkGenerator.this.f_158377_, NoiseBasedChunkGenerator.this.f_158378_, p_158521_, p_158522_, NoiseBasedChunkGenerator.this.f_158384_::m_158843_);
            this.f_158515_ = new NoiseInterpolator(NoiseBasedChunkGenerator.this.f_158376_, NoiseBasedChunkGenerator.this.f_158377_, NoiseBasedChunkGenerator.this.f_158378_, p_158521_, p_158522_, NoiseBasedChunkGenerator.this.f_158384_::m_158849_);
            this.f_158517_ = p_158523_;
        }

        public void m_158526_(Consumer<NoiseInterpolator> p_158527_) {
            p_158527_.accept(this.f_158513_);
            p_158527_.accept(this.f_158514_);
            p_158527_.accept(this.f_158515_);
        }

        public void m_158524_(double p_158525_) {
            this.f_158516_ = p_158525_;
        }

        @Override
        public BlockState m_142722_(int p_158529_, int p_158530_, int p_158531_) {
            double d = this.f_158513_.m_158618_(this.f_158516_);
            \u00e2\u02dc\u0192 = this.f_158514_.m_158618_(this.f_158516_);
            \u00e2\u02dc\u0192 = this.f_158515_.m_158618_(this.f_158516_);
            this.f_158518_.m_158961_(this.f_158517_, p_158529_, p_158530_, p_158531_);
            return NoiseBasedChunkGenerator.this.f_158384_.m_158819_(this.f_158518_, p_158529_, p_158530_, p_158531_, d, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
        }
    }
}

