/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.util.Mth;
import net.minecraft.util.ThreadingDetector;
import net.minecraft.world.level.levelgen.RandomSource;

public class SimpleRandomSource
implements RandomSource {
    private static final int f_158880_ = 48;
    private static final long f_158881_ = 0xFFFFFFFFFFFFL;
    private static final long f_158882_ = 25214903917L;
    private static final long f_158883_ = 11L;
    private static final float f_158884_ = 5.9604645E-8f;
    private static final double f_158885_ = (double)1.110223E-16f;
    private final AtomicLong f_158886_ = new AtomicLong();
    private double f_158887_;
    private boolean f_158888_;

    public SimpleRandomSource(long p_158890_) {
        this.setSeed(p_158890_);
    }

    @Override
    public void setSeed(long p_158902_) {
        if (!this.f_158886_.compareAndSet(this.f_158886_.get(), (p_158902_ ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL)) {
            throw ThreadingDetector.m_145007_("SimpleRandomSource", null);
        }
    }

    private int m_158891_(int p_158892_) {
        long l = this.f_158886_.get();
        if (!this.f_158886_.compareAndSet(l, \u00e2\u02dc\u0192 = l * 25214903917L + 11L & 0xFFFFFFFFFFFFL)) {
            throw ThreadingDetector.m_145007_("SimpleRandomSource", null);
        }
        return (int)(\u00e2\u02dc\u0192 >> 48 - p_158892_);
    }

    @Override
    public int nextInt() {
        return this.m_158891_(32);
    }

    @Override
    public int nextInt(int p_158899_) {
        int n;
        if (p_158899_ <= 0) {
            throw new IllegalArgumentException("Bound must be positive");
        }
        if ((p_158899_ & p_158899_ - 1) == 0) {
            return (int)((long)p_158899_ * (long)this.m_158891_(31) >> 31);
        }
        while ((n = this.m_158891_(31)) - (\u00e2\u02dc\u0192 = n % p_158899_) + (p_158899_ - 1) < 0) {
        }
        return \u00e2\u02dc\u0192;
    }

    @Override
    public long nextLong() {
        int n = this.m_158891_(32);
        \u00e2\u02dc\u0192 = this.m_158891_(32);
        long \u00e2\u02dc\u01922 = (long)n << 32;
        return \u00e2\u02dc\u01922 + (long)\u00e2\u02dc\u0192;
    }

    @Override
    public boolean nextBoolean() {
        return this.m_158891_(1) != 0;
    }

    @Override
    public float nextFloat() {
        return (float)this.m_158891_(24) * 5.9604645E-8f;
    }

    @Override
    public double nextDouble() {
        int n = this.m_158891_(26);
        \u00e2\u02dc\u0192 = this.m_158891_(27);
        long \u00e2\u02dc\u01922 = ((long)n << 27) + (long)\u00e2\u02dc\u0192;
        return (double)\u00e2\u02dc\u01922 * (double)1.110223E-16f;
    }

    @Override
    public double nextGaussian() {
        double d;
        if (this.f_158888_) {
            this.f_158888_ = false;
            return this.f_158887_;
        }
        do {
            \u00e2\u02dc\u0192 = 2.0 * this.nextDouble() - 1.0;
            \u00e2\u02dc\u0192 = 2.0 * this.nextDouble() - 1.0;
        } while ((d = Mth.m_144952_(\u00e2\u02dc\u0192) + Mth.m_144952_(\u00e2\u02dc\u0192)) >= 1.0 || d == 0.0);
        \u00e2\u02dc\u0192 = Math.sqrt(-2.0 * Math.log(d) / d);
        this.f_158887_ = \u00e2\u02dc\u0192 * \u00e2\u02dc\u0192;
        this.f_158888_ = true;
        return \u00e2\u02dc\u0192 * \u00e2\u02dc\u0192;
    }
}

