/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.carver;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import java.util.BitSet;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.BaseStoneSource;
import net.minecraft.world.level.levelgen.SingleBaseStoneSource;
import net.minecraft.world.level.levelgen.carver.CanyonCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CanyonWorldCarver;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.CaveCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CaveWorldCarver;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.carver.NetherWorldCarver;
import net.minecraft.world.level.levelgen.carver.UnderwaterCanyonWorldCarver;
import net.minecraft.world.level.levelgen.carver.UnderwaterCaveWorldCarver;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.apache.commons.lang3.mutable.MutableBoolean;

public abstract class WorldCarver<C extends CarverConfiguration> {
    public static final WorldCarver<CaveCarverConfiguration> f_64974_ = WorldCarver.m_65065_("cave", new CaveWorldCarver(CaveCarverConfiguration.f_159154_));
    public static final WorldCarver<CaveCarverConfiguration> f_64975_ = WorldCarver.m_65065_("nether_cave", new NetherWorldCarver(CaveCarverConfiguration.f_159154_));
    public static final WorldCarver<CanyonCarverConfiguration> f_64976_ = WorldCarver.m_65065_("canyon", new CanyonWorldCarver(CanyonCarverConfiguration.f_158966_));
    public static final WorldCarver<CanyonCarverConfiguration> f_64977_ = WorldCarver.m_65065_("underwater_canyon", new UnderwaterCanyonWorldCarver(CanyonCarverConfiguration.f_158966_));
    public static final WorldCarver<CaveCarverConfiguration> f_64978_ = WorldCarver.m_65065_("underwater_cave", new UnderwaterCaveWorldCarver(CaveCarverConfiguration.f_159154_));
    protected static final BaseStoneSource f_159364_ = new SingleBaseStoneSource(Blocks.f_50069_.m_49966_());
    protected static final BlockState f_64979_ = Blocks.f_50016_.m_49966_();
    protected static final BlockState f_64980_ = Blocks.f_50627_.m_49966_();
    protected static final FluidState f_64981_ = Fluids.f_76193_.m_76145_();
    protected static final FluidState f_64982_ = Fluids.f_76195_.m_76145_();
    protected Set<Block> f_64983_ = ImmutableSet.of((Object)Blocks.f_50069_, (Object)Blocks.f_50122_, (Object)Blocks.f_50228_, (Object)Blocks.f_50334_, (Object)Blocks.f_50493_, (Object)Blocks.f_50546_, (Object[])new Block[]{Blocks.f_50599_, Blocks.f_50440_, Blocks.f_50352_, Blocks.f_50287_, Blocks.f_50288_, Blocks.f_50289_, Blocks.f_50290_, Blocks.f_50291_, Blocks.f_50292_, Blocks.f_50293_, Blocks.f_50294_, Blocks.f_50295_, Blocks.f_50296_, Blocks.f_50297_, Blocks.f_50298_, Blocks.f_50299_, Blocks.f_50300_, Blocks.f_50301_, Blocks.f_50302_, Blocks.f_50062_, Blocks.f_50394_, Blocks.f_50195_, Blocks.f_50125_, Blocks.f_50354_, Blocks.f_152550_, Blocks.f_152496_, Blocks.f_50122_, Blocks.f_49996_, Blocks.f_152468_, Blocks.f_152598_, Blocks.f_152505_, Blocks.f_152506_, Blocks.f_152599_});
    protected Set<Fluid> f_64984_ = ImmutableSet.of((Object)Fluids.f_76193_);
    private final Codec<ConfiguredWorldCarver<C>> f_64986_;

    private static <C extends CarverConfiguration, F extends WorldCarver<C>> F m_65065_(String p_65066_, F p_65067_) {
        return (F)Registry.m_122961_(Registry.f_122837_, p_65066_, p_65067_);
    }

    public WorldCarver(Codec<C> p_159366_) {
        this.f_64986_ = p_159366_.fieldOf("config").xmap(this::m_65063_, ConfiguredWorldCarver::m_64855_).codec();
    }

    public ConfiguredWorldCarver<C> m_65063_(C p_65064_) {
        return new ConfiguredWorldCarver<C>(this, p_65064_);
    }

    public Codec<ConfiguredWorldCarver<C>> m_65072_() {
        return this.f_64986_;
    }

    public int m_65073_() {
        return 4;
    }

    protected boolean m_159386_(CarvingContext p_159387_, C p_159388_, ChunkAccess p_159389_, Function<BlockPos, Biome> p_159390_, long p_159391_, Aquifer p_159392_, double p_159393_, double p_159394_, double p_159395_, double p_159396_, double p_159397_, BitSet p_159398_, CarveSkipChecker p_159399_) {
        ChunkPos chunkPos = p_159389_.m_7697_();
        int \u00e2\u02dc\u01922 = chunkPos.f_45578_;
        int \u00e2\u02dc\u01923 = chunkPos.f_45579_;
        Random \u00e2\u02dc\u01924 = new Random(p_159391_ + (long)\u00e2\u02dc\u01922 + (long)\u00e2\u02dc\u01923);
        double \u00e2\u02dc\u01925 = chunkPos.m_151390_();
        double \u00e2\u02dc\u01926 = chunkPos.m_151393_();
        double \u00e2\u02dc\u01927 = 16.0 + p_159396_ * 2.0;
        if (Math.abs(p_159393_ - \u00e2\u02dc\u01925) > \u00e2\u02dc\u01927 || Math.abs(p_159395_ - \u00e2\u02dc\u01926) > \u00e2\u02dc\u01927) {
            return false;
        }
        int \u00e2\u02dc\u01928 = chunkPos.m_45604_();
        int \u00e2\u02dc\u01929 = chunkPos.m_45605_();
        int \u00e2\u02dc\u019210 = Math.max(Mth.m_14107_(p_159393_ - p_159396_) - \u00e2\u02dc\u01928 - 1, 0);
        int \u00e2\u02dc\u019211 = Math.min(Mth.m_14107_(p_159393_ + p_159396_) - \u00e2\u02dc\u01928, 15);
        int \u00e2\u02dc\u019212 = Math.max(Mth.m_14107_(p_159394_ - p_159397_) - 1, p_159387_.m_142201_() + 1);
        int \u00e2\u02dc\u019213 = Math.min(Mth.m_14107_(p_159394_ + p_159397_) + 1, p_159387_.m_142201_() + p_159387_.m_142208_() - 8);
        int \u00e2\u02dc\u019214 = Math.max(Mth.m_14107_(p_159395_ - p_159396_) - \u00e2\u02dc\u01929 - 1, 0);
        int \u00e2\u02dc\u019215 = Math.min(Mth.m_14107_(p_159395_ + p_159396_) - \u00e2\u02dc\u01929, 15);
        if (!((CarverConfiguration)p_159388_).f_159091_ && this.m_141931_(p_159389_, \u00e2\u02dc\u019210, \u00e2\u02dc\u019211, \u00e2\u02dc\u019212, \u00e2\u02dc\u019213, \u00e2\u02dc\u019214, \u00e2\u02dc\u019215)) {
            return false;
        }
        boolean \u00e2\u02dc\u019216 = false;
        BlockPos.MutableBlockPos \u00e2\u02dc\u019217 = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos \u00e2\u02dc\u019218 = new BlockPos.MutableBlockPos();
        for (int i = \u00e2\u02dc\u019210; i <= \u00e2\u02dc\u019211; ++i) {
            \u00e2\u02dc\u0192 = chunkPos.m_151382_(i);
            double d = ((double)\u00e2\u02dc\u0192 + 0.5 - p_159393_) / p_159396_;
            for (int j = \u00e2\u02dc\u019214; j <= \u00e2\u02dc\u019215; ++j) {
                \u00e2\u02dc\u0192 = chunkPos.m_151391_(j);
                double d2 = ((double)\u00e2\u02dc\u0192 + 0.5 - p_159395_) / p_159396_;
                if (d * d + d2 * d2 >= 1.0) continue;
                MutableBoolean \u00e2\u02dc\u019219 = new MutableBoolean(false);
                for (int k = \u00e2\u02dc\u019213; k > \u00e2\u02dc\u019212; --k) {
                    double d3 = ((double)k - 0.5 - p_159394_) / p_159397_;
                    if (p_159399_.m_159425_(p_159387_, d, d3, d2, k) || p_159398_.get(\u00e2\u02dc\u0192 = i | j << 4 | (\u00e2\u02dc\u0192 = k - p_159387_.m_142201_()) << 8) && !WorldCarver.m_159423_(p_159388_)) continue;
                    p_159398_.set(\u00e2\u02dc\u0192);
                    \u00e2\u02dc\u019217.m_122178_(\u00e2\u02dc\u0192, k, \u00e2\u02dc\u0192);
                    \u00e2\u02dc\u019216 |= this.m_141949_(p_159387_, p_159388_, p_159389_, p_159390_, p_159398_, \u00e2\u02dc\u01924, \u00e2\u02dc\u019217, \u00e2\u02dc\u019218, p_159392_, \u00e2\u02dc\u019219);
                }
            }
        }
        return \u00e2\u02dc\u019216;
    }

    protected boolean m_141949_(CarvingContext p_159400_, C p_159401_, ChunkAccess p_159402_, Function<BlockPos, Biome> p_159403_, BitSet p_159404_, Random p_159405_, BlockPos.MutableBlockPos p_159406_, BlockPos.MutableBlockPos p_159407_, Aquifer p_159408_, MutableBoolean p_159409_) {
        BlockState blockState = p_159402_.m_8055_(p_159406_);
        \u00e2\u02dc\u0192 = p_159402_.m_8055_(p_159407_.m_122159_(p_159406_, Direction.UP));
        if (blockState.m_60713_(Blocks.f_50440_) || blockState.m_60713_(Blocks.f_50195_)) {
            p_159409_.setTrue();
        }
        if (!this.m_65012_(blockState, \u00e2\u02dc\u0192) && !WorldCarver.m_159423_(p_159401_)) {
            return false;
        }
        \u00e2\u02dc\u0192 = this.m_159418_(p_159400_, p_159401_, p_159406_, p_159408_);
        if (\u00e2\u02dc\u0192 == null) {
            return false;
        }
        p_159402_.m_6978_(p_159406_, \u00e2\u02dc\u0192, false);
        if (p_159409_.isTrue()) {
            p_159407_.m_122159_(p_159406_, Direction.DOWN);
            if (p_159402_.m_8055_(p_159407_).m_60713_(Blocks.f_50493_)) {
                p_159402_.m_6978_(p_159407_, p_159403_.apply(p_159406_).m_47536_().m_47824_().m_6743_(), false);
            }
        }
        return true;
    }

    @Nullable
    private BlockState m_159418_(CarvingContext p_159419_, C p_159420_, BlockPos p_159421_, Aquifer p_159422_) {
        if (p_159421_.m_123342_() <= ((CarverConfiguration)p_159420_).f_159090_.m_142322_(p_159419_)) {
            return f_64982_.m_76188_();
        }
        if (!((CarverConfiguration)p_159420_).f_159091_) {
            return WorldCarver.m_159423_(p_159420_) ? WorldCarver.m_159381_(p_159420_, f_64979_) : f_64979_;
        }
        BlockState blockState = p_159422_.m_142419_(f_159364_, p_159421_.m_123341_(), p_159421_.m_123342_(), p_159421_.m_123343_(), 0.0);
        if (blockState == Blocks.f_50069_.m_49966_()) {
            return WorldCarver.m_159423_(p_159420_) ? ((CarverConfiguration)p_159420_).f_159092_.m_159148_() : null;
        }
        return WorldCarver.m_159423_(p_159420_) ? WorldCarver.m_159381_(p_159420_, blockState) : blockState;
    }

    private static BlockState m_159381_(CarverConfiguration p_159382_, BlockState p_159383_) {
        if (p_159383_.m_60713_(Blocks.f_50016_)) {
            return p_159382_.f_159092_.m_159145_();
        }
        if (p_159383_.m_60713_(Blocks.f_49990_)) {
            BlockState blockState = p_159382_.f_159092_.m_159146_();
            if (blockState.m_61138_(BlockStateProperties.f_61362_)) {
                return (BlockState)blockState.m_61124_(BlockStateProperties.f_61362_, true);
            }
            return blockState;
        }
        if (p_159383_.m_60713_(Blocks.f_49991_)) {
            return p_159382_.f_159092_.m_159147_();
        }
        return p_159383_;
    }

    public abstract boolean m_142404_(CarvingContext var1, C var2, ChunkAccess var3, Function<BlockPos, Biome> var4, Random var5, Aquifer var6, ChunkPos var7, BitSet var8);

    public abstract boolean m_142512_(C var1, Random var2);

    protected boolean m_65010_(BlockState p_65011_) {
        return this.f_64983_.contains(p_65011_.m_60734_());
    }

    protected boolean m_65012_(BlockState p_65013_, BlockState p_65014_) {
        return this.m_65010_(p_65013_) || (p_65013_.m_60713_(Blocks.f_49992_) || p_65013_.m_60713_(Blocks.f_49994_)) && !p_65014_.m_60819_().m_76153_(FluidTags.f_13131_);
    }

    protected boolean m_141931_(ChunkAccess p_159374_, int p_159375_, int p_159376_, int p_159377_, int p_159378_, int p_159379_, int p_159380_) {
        ChunkPos chunkPos = p_159374_.m_7697_();
        int \u00e2\u02dc\u01922 = chunkPos.m_45604_();
        int \u00e2\u02dc\u01923 = chunkPos.m_45605_();
        BlockPos.MutableBlockPos \u00e2\u02dc\u01924 = new BlockPos.MutableBlockPos();
        for (int i = p_159375_; i <= p_159376_; ++i) {
            for (\u00e2\u02dc\u0192 = p_159379_; \u00e2\u02dc\u0192 <= p_159380_; ++\u00e2\u02dc\u0192) {
                for (\u00e2\u02dc\u0192 = p_159377_ - 1; \u00e2\u02dc\u0192 <= p_159378_ + 1; ++\u00e2\u02dc\u0192) {
                    \u00e2\u02dc\u01924.m_122178_(\u00e2\u02dc\u01922 + i, \u00e2\u02dc\u0192, \u00e2\u02dc\u01923 + \u00e2\u02dc\u0192);
                    if (this.f_64984_.contains(p_159374_.m_6425_(\u00e2\u02dc\u01924).m_76152_())) {
                        return true;
                    }
                    if (\u00e2\u02dc\u0192 == p_159378_ + 1 || WorldCarver.m_65003_(i, \u00e2\u02dc\u0192, p_159375_, p_159376_, p_159379_, p_159380_)) continue;
                    \u00e2\u02dc\u0192 = p_159378_;
                }
            }
        }
        return false;
    }

    private static boolean m_65003_(int p_65004_, int p_65005_, int p_65006_, int p_65007_, int p_65008_, int p_65009_) {
        return p_65004_ == p_65006_ || p_65004_ == p_65007_ || p_65005_ == p_65008_ || p_65005_ == p_65009_;
    }

    protected static boolean m_159367_(ChunkPos p_159368_, double p_159369_, double p_159370_, int p_159371_, int p_159372_, float p_159373_) {
        double d = p_159368_.m_151390_();
        \u00e2\u02dc\u0192 = p_159369_ - d;
        return \u00e2\u02dc\u0192 * \u00e2\u02dc\u0192 + (\u00e2\u02dc\u0192 = p_159370_ - (\u00e2\u02dc\u0192 = (double)p_159368_.m_151393_())) * \u00e2\u02dc\u0192 - (\u00e2\u02dc\u0192 = (double)(p_159372_ - p_159371_)) * \u00e2\u02dc\u0192 <= (\u00e2\u02dc\u0192 = (double)(p_159373_ + 2.0f + 16.0f)) * \u00e2\u02dc\u0192;
    }

    private static boolean m_159423_(CarverConfiguration p_159424_) {
        return p_159424_.f_159092_.m_159128_();
    }

    public static interface CarveSkipChecker {
        public boolean m_159425_(CarvingContext var1, double var2, double var4, double var6, int var8);
    }
}

