/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.ClampedNormalFloat;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.DripstoneClusterConfiguration;

public class DripstoneClusterFeature
extends Feature<DripstoneClusterConfiguration> {
    public DripstoneClusterFeature(Codec<DripstoneClusterConfiguration> p_159575_) {
        super(p_159575_);
    }

    @Override
    public boolean m_142674_(FeaturePlaceContext<DripstoneClusterConfiguration> p_159605_) {
        WorldGenLevel worldGenLevel = p_159605_.m_159774_();
        BlockPos \u00e2\u02dc\u01922 = p_159605_.m_159777_();
        DripstoneClusterConfiguration \u00e2\u02dc\u01923 = p_159605_.m_159778_();
        Random \u00e2\u02dc\u01924 = p_159605_.m_159776_();
        if (!DripstoneUtils.m_159628_(worldGenLevel, \u00e2\u02dc\u01922)) {
            return false;
        }
        int \u00e2\u02dc\u01925 = \u00e2\u02dc\u01923.f_160760_.m_142270_(\u00e2\u02dc\u01924);
        float \u00e2\u02dc\u01926 = \u00e2\u02dc\u01923.f_160766_.m_142269_(\u00e2\u02dc\u01924);
        float \u00e2\u02dc\u01927 = \u00e2\u02dc\u01923.f_160765_.m_142269_(\u00e2\u02dc\u01924);
        int \u00e2\u02dc\u01928 = \u00e2\u02dc\u01923.f_160761_.m_142270_(\u00e2\u02dc\u01924);
        int \u00e2\u02dc\u01929 = \u00e2\u02dc\u01923.f_160761_.m_142270_(\u00e2\u02dc\u01924);
        for (int i = -\u00e2\u02dc\u01928; i <= \u00e2\u02dc\u01928; ++i) {
            for (\u00e2\u02dc\u0192 = -\u00e2\u02dc\u01929; \u00e2\u02dc\u0192 <= \u00e2\u02dc\u01929; ++\u00e2\u02dc\u0192) {
                double d = this.m_159576_(\u00e2\u02dc\u01928, \u00e2\u02dc\u01929, i, \u00e2\u02dc\u0192, \u00e2\u02dc\u01923);
                BlockPos \u00e2\u02dc\u019210 = \u00e2\u02dc\u01922.m_142082_(i, 0, \u00e2\u02dc\u0192);
                this.m_159593_(worldGenLevel, \u00e2\u02dc\u01924, \u00e2\u02dc\u019210, i, \u00e2\u02dc\u0192, \u00e2\u02dc\u01926, d, \u00e2\u02dc\u01925, \u00e2\u02dc\u01927, \u00e2\u02dc\u01923);
            }
        }
        return true;
    }

    private void m_159593_(WorldGenLevel p_159594_, Random p_159595_, BlockPos p_159596_, int p_159597_, int p_159598_, float p_159599_, double p_159600_, int p_159601_, float p_159602_, DripstoneClusterConfiguration p_159603_) {
        int n;
        Column \u00e2\u02dc\u01924;
        Optional<Column> optional = Column.m_158175_(p_159594_, p_159596_, p_159603_.f_160759_, DripstoneUtils::m_159664_, DripstoneUtils::m_159649_);
        if (!optional.isPresent()) {
            return;
        }
        OptionalInt \u00e2\u02dc\u01922 = optional.get().m_142011_();
        OptionalInt \u00e2\u02dc\u01923 = optional.get().m_142009_();
        if (!\u00e2\u02dc\u01922.isPresent() && !\u00e2\u02dc\u01923.isPresent()) {
            return;
        }
        boolean bl = \u00e2\u02dc\u0192 = p_159595_.nextFloat() < p_159599_;
        if (\u00e2\u02dc\u0192 && \u00e2\u02dc\u01923.isPresent() && this.m_159619_(p_159594_, p_159596_.m_175288_(\u00e2\u02dc\u01923.getAsInt()))) {
            int n2 = \u00e2\u02dc\u01923.getAsInt();
            \u00e2\u02dc\u01924 = optional.get().m_158181_(OptionalInt.of(n2 - 1));
            p_159594_.m_7731_(p_159596_.m_175288_(n2), Blocks.f_49990_.m_49966_(), 2);
        } else {
            \u00e2\u02dc\u01924 = optional.get();
        }
        OptionalInt optionalInt = \u00e2\u02dc\u01924.m_142009_();
        boolean bl2 = \u00e2\u02dc\u0192 = p_159595_.nextDouble() < p_159600_;
        if (\u00e2\u02dc\u01922.isPresent() && \u00e2\u02dc\u0192 && !this.m_159585_(p_159594_, p_159596_.m_175288_(\u00e2\u02dc\u01922.getAsInt()))) {
            int n3 = p_159603_.f_160764_.m_142270_(p_159595_);
            this.m_159588_(p_159594_, p_159596_.m_175288_(\u00e2\u02dc\u01922.getAsInt()), n3, Direction.UP);
            n = optionalInt.isPresent() ? Math.min(p_159601_, \u00e2\u02dc\u01922.getAsInt() - optionalInt.getAsInt()) : p_159601_;
            n4 = this.m_159612_(p_159595_, p_159597_, p_159598_, p_159602_, n, p_159603_);
        } else {
            int n4 = 0;
        }
        int n5 = n = p_159595_.nextDouble() < p_159600_ ? 1 : 0;
        if (optionalInt.isPresent() && n != 0 && !this.m_159585_(p_159594_, p_159596_.m_175288_(optionalInt.getAsInt()))) {
            \u00e2\u02dc\u0192 = p_159603_.f_160764_.m_142270_(p_159595_);
            this.m_159588_(p_159594_, p_159596_.m_175288_(optionalInt.getAsInt()), \u00e2\u02dc\u0192, Direction.DOWN);
            n3 = Math.max(0, n4 + Mth.m_144928_(p_159595_, -p_159603_.f_160762_, p_159603_.f_160762_));
        } else {
            n3 = 0;
        }
        if (\u00e2\u02dc\u01922.isPresent() && optionalInt.isPresent() && \u00e2\u02dc\u01922.getAsInt() - n4 <= optionalInt.getAsInt() + n3) {
            \u00e2\u02dc\u0192 = optionalInt.getAsInt();
            \u00e2\u02dc\u0192 = \u00e2\u02dc\u01922.getAsInt();
            \u00e2\u02dc\u0192 = Math.max(\u00e2\u02dc\u0192 - n4, \u00e2\u02dc\u0192 + 1);
            \u00e2\u02dc\u0192 = Math.min(\u00e2\u02dc\u0192 + n3, \u00e2\u02dc\u0192 - 1);
            \u00e2\u02dc\u0192 = Mth.m_144928_(p_159595_, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192 + 1);
            \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 - 1;
            \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 - \u00e2\u02dc\u0192;
            \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 - \u00e2\u02dc\u0192;
        } else {
            \u00e2\u02dc\u0192 = n4;
            \u00e2\u02dc\u0192 = n3;
        }
        int n6 = \u00e2\u02dc\u0192 = p_159595_.nextBoolean() && \u00e2\u02dc\u0192 > 0 && \u00e2\u02dc\u0192 > 0 && \u00e2\u02dc\u01924.m_142030_().isPresent() && \u00e2\u02dc\u0192 + \u00e2\u02dc\u0192 == \u00e2\u02dc\u01924.m_142030_().getAsInt() ? 1 : 0;
        if (\u00e2\u02dc\u01922.isPresent()) {
            DripstoneUtils.m_159643_(p_159594_, p_159596_.m_175288_(\u00e2\u02dc\u01922.getAsInt() - 1), Direction.DOWN, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192 != 0);
        }
        if (optionalInt.isPresent()) {
            DripstoneUtils.m_159643_(p_159594_, p_159596_.m_175288_(optionalInt.getAsInt() + 1), Direction.UP, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192 != 0);
        }
    }

    private boolean m_159585_(LevelReader p_159586_, BlockPos p_159587_) {
        return p_159586_.m_8055_(p_159587_).m_60713_(Blocks.f_49991_);
    }

    private int m_159612_(Random p_159613_, int p_159614_, int p_159615_, float p_159616_, int p_159617_, DripstoneClusterConfiguration p_159618_) {
        if (p_159613_.nextFloat() > p_159616_) {
            return 0;
        }
        int n = Math.abs(p_159614_) + Math.abs(p_159615_);
        float \u00e2\u02dc\u01922 = (float)Mth.m_144851_(n, 0.0, p_159618_.f_160769_, (double)p_159617_ / 2.0, 0.0);
        return (int)DripstoneClusterFeature.m_159606_(p_159613_, 0.0f, p_159617_, \u00e2\u02dc\u01922, p_159618_.f_160763_);
    }

    private boolean m_159619_(WorldGenLevel p_159620_, BlockPos p_159621_) {
        BlockState blockState = p_159620_.m_8055_(p_159621_);
        if (blockState.m_60713_(Blocks.f_49990_) || blockState.m_60713_(Blocks.f_152537_) || blockState.m_60713_(Blocks.f_152588_)) {
            return false;
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (this.m_159582_(p_159620_, p_159621_.m_142300_(direction))) continue;
            return false;
        }
        return this.m_159582_(p_159620_, p_159621_.m_7495_());
    }

    private boolean m_159582_(LevelAccessor p_159583_, BlockPos p_159584_) {
        BlockState blockState = p_159583_.m_8055_(p_159584_);
        return blockState.m_60620_(BlockTags.f_13061_) || blockState.m_60819_().m_76153_(FluidTags.f_13131_);
    }

    private void m_159588_(WorldGenLevel p_159589_, BlockPos p_159590_, int p_159591_, Direction p_159592_) {
        BlockPos.MutableBlockPos mutableBlockPos = p_159590_.m_122032_();
        for (int i = 0; i < p_159591_; ++i) {
            if (!DripstoneUtils.m_159636_(p_159589_, mutableBlockPos)) {
                return;
            }
            mutableBlockPos.m_122173_(p_159592_);
        }
    }

    private double m_159576_(int p_159577_, int p_159578_, int p_159579_, int p_159580_, DripstoneClusterConfiguration p_159581_) {
        int n = p_159577_ - Math.abs(p_159579_);
        \u00e2\u02dc\u0192 = p_159578_ - Math.abs(p_159580_);
        \u00e2\u02dc\u0192 = Math.min(n, \u00e2\u02dc\u0192);
        return Mth.m_144851_(\u00e2\u02dc\u0192, 0.0, p_159581_.f_160768_, p_159581_.f_160767_, 1.0);
    }

    private static float m_159606_(Random p_159607_, float p_159608_, float p_159609_, float p_159610_, float p_159611_) {
        return ClampedNormalFloat.m_146434_(p_159607_, p_159610_, p_159611_, p_159608_, p_159609_);
    }
}

