/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RuinedPortalConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.RuinedPortalPiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class RuinedPortalFeature
extends StructureFeature<RuinedPortalConfiguration> {
    static final String[] f_66664_ = new String[]{"ruined_portal/portal_1", "ruined_portal/portal_2", "ruined_portal/portal_3", "ruined_portal/portal_4", "ruined_portal/portal_5", "ruined_portal/portal_6", "ruined_portal/portal_7", "ruined_portal/portal_8", "ruined_portal/portal_9", "ruined_portal/portal_10"};
    static final String[] f_66665_ = new String[]{"ruined_portal/giant_portal_1", "ruined_portal/giant_portal_2", "ruined_portal/giant_portal_3"};
    private static final float f_160264_ = 0.05f;
    private static final float f_160265_ = 0.5f;
    private static final float f_160266_ = 0.5f;
    private static final float f_160260_ = 0.8f;
    private static final float f_160261_ = 0.8f;
    private static final float f_160262_ = 0.5f;
    private static final int f_160263_ = 15;

    public RuinedPortalFeature(Codec<RuinedPortalConfiguration> p_66668_) {
        super(p_66668_);
    }

    @Override
    public StructureFeature.StructureStartFactory<RuinedPortalConfiguration> m_6258_() {
        return FeatureStart::new;
    }

    static boolean m_66688_(BlockPos p_66689_, Biome p_66690_) {
        return p_66690_.m_47505_(p_66689_) < 0.15f;
    }

    static int m_160271_(Random p_160272_, ChunkGenerator p_160273_, RuinedPortalPiece.VerticalPlacement p_160274_, boolean p_160275_, int p_160276_, int p_160277_, BoundingBox p_160278_, LevelHeightAccessor p_160279_) {
        int n;
        if (p_160274_ == RuinedPortalPiece.VerticalPlacement.IN_NETHER) {
            \u00e2\u02dc\u0192 = p_160275_ ? Mth.m_144928_(p_160272_, 32, 100) : (p_160272_.nextFloat() < 0.5f ? Mth.m_144928_(p_160272_, 27, 29) : Mth.m_144928_(p_160272_, 29, 100));
        } else if (p_160274_ == RuinedPortalPiece.VerticalPlacement.IN_MOUNTAIN) {
            \u00e2\u02dc\u0192 = p_160276_ - p_160277_;
            \u00e2\u02dc\u0192 = RuinedPortalFeature.m_66691_(p_160272_, 70, \u00e2\u02dc\u0192);
        } else if (p_160274_ == RuinedPortalPiece.VerticalPlacement.UNDERGROUND) {
            \u00e2\u02dc\u0192 = p_160276_ - p_160277_;
            \u00e2\u02dc\u0192 = RuinedPortalFeature.m_66691_(p_160272_, 15, \u00e2\u02dc\u0192);
        } else {
            \u00e2\u02dc\u0192 = p_160274_ == RuinedPortalPiece.VerticalPlacement.PARTLY_BURIED ? p_160276_ - p_160277_ + Mth.m_144928_(p_160272_, 2, 8) : p_160276_;
        }
        ImmutableList immutableList = ImmutableList.of((Object)new BlockPos(p_160278_.m_162395_(), 0, p_160278_.m_162398_()), (Object)new BlockPos(p_160278_.m_162399_(), 0, p_160278_.m_162398_()), (Object)new BlockPos(p_160278_.m_162395_(), 0, p_160278_.m_162401_()), (Object)new BlockPos(p_160278_.m_162399_(), 0, p_160278_.m_162401_()));
        List \u00e2\u02dc\u01922 = immutableList.stream().map(p_160270_ -> p_160273_.m_141914_(p_160270_.m_123341_(), p_160270_.m_123343_(), p_160279_)).collect(Collectors.toList());
        Heightmap.Types \u00e2\u02dc\u01923 = p_160274_ == RuinedPortalPiece.VerticalPlacement.ON_OCEAN_FLOOR ? Heightmap.Types.OCEAN_FLOOR_WG : Heightmap.Types.WORLD_SURFACE_WG;
        BlockPos.MutableBlockPos \u00e2\u02dc\u01924 = new BlockPos.MutableBlockPos();
        block0: for (n = \u00e2\u02dc\u0192; n > 15; --n) {
            \u00e2\u02dc\u0192 = 0;
            \u00e2\u02dc\u01924.m_122178_(0, n, 0);
            for (NoiseColumn noiseColumn : \u00e2\u02dc\u01922) {
                BlockState blockState = noiseColumn.m_47156_(\u00e2\u02dc\u01924);
                if (!\u00e2\u02dc\u01923.m_64299_().test(blockState) || ++\u00e2\u02dc\u0192 != 3) continue;
                break block0;
            }
        }
        return n;
    }

    private static int m_66691_(Random p_66692_, int p_66693_, int p_66694_) {
        if (p_66693_ < p_66694_) {
            return Mth.m_144928_(p_66692_, p_66693_, p_66694_);
        }
        return p_66694_;
    }

    public static final class Type
    extends Enum<Type>
    implements StringRepresentable {
        public static final /* enum */ Type STANDARD = new Type("standard");
        public static final /* enum */ Type DESERT = new Type("desert");
        public static final /* enum */ Type JUNGLE = new Type("jungle");
        public static final /* enum */ Type SWAMP = new Type("swamp");
        public static final /* enum */ Type MOUNTAIN = new Type("mountain");
        public static final /* enum */ Type OCEAN = new Type("ocean");
        public static final /* enum */ Type NETHER = new Type("nether");
        public static final Codec<Type> f_66735_;
        private static final Map<String, Type> f_66736_;
        private final String f_66737_;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String p_66751_) {
            return Enum.valueOf(Type.class, p_66751_);
        }

        private Type(String p_66743_) {
            this.f_66737_ = p_66743_;
        }

        public String m_66749_() {
            return this.f_66737_;
        }

        public static Type m_66747_(String p_66748_) {
            return f_66736_.get(p_66748_);
        }

        @Override
        public String m_7912_() {
            return this.f_66737_;
        }

        private static /* synthetic */ Type[] m_160301_() {
            return new Type[]{STANDARD, DESERT, JUNGLE, SWAMP, MOUNTAIN, OCEAN, NETHER};
        }

        static {
            $VALUES = Type.m_160301_();
            f_66735_ = StringRepresentable.m_14350_(Type::values, Type::m_66747_);
            f_66736_ = Arrays.stream(Type.values()).collect(Collectors.toMap(Type::m_66749_, p_66746_ -> p_66746_));
        }
    }

    public static class FeatureStart
    extends StructureStart<RuinedPortalConfiguration> {
        protected FeatureStart(StructureFeature<RuinedPortalConfiguration> p_160281_, ChunkPos p_160282_, int p_160283_, long p_160284_) {
            super(p_160281_, p_160282_, p_160283_, p_160284_);
        }

        @Override
        public void m_142743_(RegistryAccess p_160294_, ChunkGenerator p_160295_, StructureManager p_160296_, ChunkPos p_160297_, Biome p_160298_, RuinedPortalConfiguration p_160299_, LevelHeightAccessor p_160300_) {
            RuinedPortalPiece.VerticalPlacement \u00e2\u02dc\u01922;
            RuinedPortalPiece.Properties properties = new RuinedPortalPiece.Properties();
            if (p_160299_.f_68055_ == Type.DESERT) {
                \u00e2\u02dc\u01922 = RuinedPortalPiece.VerticalPlacement.PARTLY_BURIED;
                properties.f_72738_ = false;
                properties.f_72737_ = 0.0f;
            } else if (p_160299_.f_68055_ == Type.JUNGLE) {
                \u00e2\u02dc\u01922 = RuinedPortalPiece.VerticalPlacement.ON_LAND_SURFACE;
                properties.f_72738_ = this.f_73564_.nextFloat() < 0.5f;
                properties.f_72737_ = 0.8f;
                properties.f_72739_ = true;
                properties.f_72740_ = true;
            } else if (p_160299_.f_68055_ == Type.SWAMP) {
                \u00e2\u02dc\u01922 = RuinedPortalPiece.VerticalPlacement.ON_OCEAN_FLOOR;
                properties.f_72738_ = false;
                properties.f_72737_ = 0.5f;
                properties.f_72740_ = true;
            } else if (p_160299_.f_68055_ == Type.MOUNTAIN) {
                boolean bl = this.f_73564_.nextFloat() < 0.5f;
                \u00e2\u02dc\u01922 = bl ? RuinedPortalPiece.VerticalPlacement.IN_MOUNTAIN : RuinedPortalPiece.VerticalPlacement.ON_LAND_SURFACE;
                properties.f_72738_ = bl || this.f_73564_.nextFloat() < 0.5f;
            } else if (p_160299_.f_68055_ == Type.OCEAN) {
                \u00e2\u02dc\u01922 = RuinedPortalPiece.VerticalPlacement.ON_OCEAN_FLOOR;
                properties.f_72738_ = false;
                properties.f_72737_ = 0.8f;
            } else if (p_160299_.f_68055_ == Type.NETHER) {
                \u00e2\u02dc\u01922 = RuinedPortalPiece.VerticalPlacement.IN_NETHER;
                properties.f_72738_ = this.f_73564_.nextFloat() < 0.5f;
                properties.f_72737_ = 0.0f;
                properties.f_72741_ = true;
            } else {
                bl = this.f_73564_.nextFloat() < 0.5f;
                \u00e2\u02dc\u01922 = bl ? RuinedPortalPiece.VerticalPlacement.UNDERGROUND : RuinedPortalPiece.VerticalPlacement.ON_LAND_SURFACE;
                properties.f_72738_ = bl || this.f_73564_.nextFloat() < 0.5f;
            }
            ResourceLocation resourceLocation = this.f_73564_.nextFloat() < 0.05f ? new ResourceLocation(f_66665_[this.f_73564_.nextInt(f_66665_.length)]) : new ResourceLocation(f_66664_[this.f_73564_.nextInt(f_66664_.length)]);
            StructureTemplate \u00e2\u02dc\u01923 = p_160296_.m_74341_(resourceLocation);
            Rotation \u00e2\u02dc\u01924 = Util.m_137545_(Rotation.values(), this.f_73564_);
            Mirror \u00e2\u02dc\u01925 = this.f_73564_.nextFloat() < 0.5f ? Mirror.NONE : Mirror.FRONT_BACK;
            BlockPos \u00e2\u02dc\u01926 = new BlockPos(\u00e2\u02dc\u01923.m_163801_().m_123341_() / 2, 0, \u00e2\u02dc\u01923.m_163801_().m_123343_() / 2);
            BlockPos \u00e2\u02dc\u01927 = p_160297_.m_45615_();
            BoundingBox \u00e2\u02dc\u01928 = \u00e2\u02dc\u01923.m_74598_(\u00e2\u02dc\u01927, \u00e2\u02dc\u01924, \u00e2\u02dc\u01926, \u00e2\u02dc\u01925);
            BlockPos \u00e2\u02dc\u01929 = \u00e2\u02dc\u01928.m_162394_();
            int \u00e2\u02dc\u019210 = \u00e2\u02dc\u01929.m_123341_();
            int \u00e2\u02dc\u019211 = \u00e2\u02dc\u01929.m_123343_();
            int \u00e2\u02dc\u019212 = p_160295_.m_142647_(\u00e2\u02dc\u019210, \u00e2\u02dc\u019211, RuinedPortalPiece.m_72692_(\u00e2\u02dc\u01922), p_160300_) - 1;
            int \u00e2\u02dc\u019213 = RuinedPortalFeature.m_160271_(this.f_73564_, p_160295_, \u00e2\u02dc\u01922, properties.f_72738_, \u00e2\u02dc\u019212, \u00e2\u02dc\u01928.m_71057_(), \u00e2\u02dc\u01928, p_160300_);
            BlockPos \u00e2\u02dc\u019214 = new BlockPos(\u00e2\u02dc\u01927.m_123341_(), \u00e2\u02dc\u019213, \u00e2\u02dc\u01927.m_123343_());
            if (p_160299_.f_68055_ == Type.MOUNTAIN || p_160299_.f_68055_ == Type.OCEAN || p_160299_.f_68055_ == Type.STANDARD) {
                properties.f_72736_ = RuinedPortalFeature.m_66688_(\u00e2\u02dc\u019214, p_160298_);
            }
            this.m_142679_(new RuinedPortalPiece(p_160296_, \u00e2\u02dc\u019214, \u00e2\u02dc\u01922, properties, resourceLocation, \u00e2\u02dc\u01923, \u00e2\u02dc\u01924, \u00e2\u02dc\u01925, \u00e2\u02dc\u01926));
        }
    }
}

