/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.SpikeConfiguration;
import net.minecraft.world.phys.AABB;

public class SpikeFeature
extends Feature<SpikeConfiguration> {
    public static final int f_160369_ = 10;
    private static final int f_160370_ = 42;
    private static final LoadingCache<Long, List<EndSpike>> f_66849_ = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build((CacheLoader)new SpikeCacheLoader());

    public SpikeFeature(Codec<SpikeConfiguration> p_66852_) {
        super(p_66852_);
    }

    public static List<EndSpike> m_66858_(WorldGenLevel p_66859_) {
        Random random = new Random(p_66859_.m_7328_());
        long \u00e2\u02dc\u01922 = random.nextLong() & 0xFFFFL;
        return (List)f_66849_.getUnchecked((Object)\u00e2\u02dc\u01922);
    }

    @Override
    public boolean m_142674_(FeaturePlaceContext<SpikeConfiguration> p_160372_) {
        SpikeConfiguration spikeConfiguration = p_160372_.m_159778_();
        WorldGenLevel \u00e2\u02dc\u01922 = p_160372_.m_159774_();
        Random \u00e2\u02dc\u01923 = p_160372_.m_159776_();
        BlockPos \u00e2\u02dc\u01924 = p_160372_.m_159777_();
        List<EndSpike> \u00e2\u02dc\u01925 = spikeConfiguration.m_68119_();
        if (\u00e2\u02dc\u01925.isEmpty()) {
            \u00e2\u02dc\u01925 = SpikeFeature.m_66858_(\u00e2\u02dc\u01922);
        }
        for (EndSpike endSpike : \u00e2\u02dc\u01925) {
            if (!endSpike.m_66891_(\u00e2\u02dc\u01924)) continue;
            this.m_66853_(\u00e2\u02dc\u01922, \u00e2\u02dc\u01923, spikeConfiguration, endSpike);
        }
        return true;
    }

    private void m_66853_(ServerLevelAccessor p_66854_, Random p_66855_, SpikeConfiguration p_66856_, EndSpike p_66857_) {
        int n = p_66857_.m_66896_();
        for (BlockPos blockPos : BlockPos.m_121940_(new BlockPos(p_66857_.m_66886_() - n, p_66854_.m_141937_(), p_66857_.m_66893_() - n), new BlockPos(p_66857_.m_66886_() + n, p_66857_.m_66899_() + 10, p_66857_.m_66893_() + n))) {
            if (blockPos.m_123299_(p_66857_.m_66886_(), blockPos.m_123342_(), p_66857_.m_66893_(), false) <= (double)(n * n + 1) && blockPos.m_123342_() < p_66857_.m_66899_()) {
                this.m_5974_(p_66854_, blockPos, Blocks.f_50080_.m_49966_());
                continue;
            }
            if (blockPos.m_123342_() <= 65) continue;
            this.m_5974_(p_66854_, blockPos, Blocks.f_50016_.m_49966_());
        }
        if (p_66857_.m_66902_()) {
            int n2 = -2;
            \u00e2\u02dc\u0192 = 2;
            \u00e2\u02dc\u0192 = 3;
            BlockPos.MutableBlockPos \u00e2\u02dc\u01922 = new BlockPos.MutableBlockPos();
            for (\u00e2\u02dc\u0192 = -2; \u00e2\u02dc\u0192 <= 2; ++\u00e2\u02dc\u0192) {
                for (\u00e2\u02dc\u0192 = -2; \u00e2\u02dc\u0192 <= 2; ++\u00e2\u02dc\u0192) {
                    for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 <= 3; ++\u00e2\u02dc\u0192) {
                        boolean bl = Mth.m_14040_(\u00e2\u02dc\u0192) == 2;
                        \u00e2\u02dc\u0192 = Mth.m_14040_(\u00e2\u02dc\u0192) == 2;
                        boolean bl2 = \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 == 3;
                        if (!bl && !\u00e2\u02dc\u0192 && !\u00e2\u02dc\u0192) continue;
                        \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 == -2 || \u00e2\u02dc\u0192 == 2 || \u00e2\u02dc\u0192;
                        \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 == -2 || \u00e2\u02dc\u0192 == 2 || \u00e2\u02dc\u0192;
                        BlockState \u00e2\u02dc\u01923 = (BlockState)((BlockState)((BlockState)((BlockState)Blocks.f_50183_.m_49966_().m_61124_(IronBarsBlock.f_52309_, \u00e2\u02dc\u0192 && \u00e2\u02dc\u0192 != -2)).m_61124_(IronBarsBlock.f_52311_, \u00e2\u02dc\u0192 && \u00e2\u02dc\u0192 != 2)).m_61124_(IronBarsBlock.f_52312_, \u00e2\u02dc\u0192 && \u00e2\u02dc\u0192 != -2)).m_61124_(IronBarsBlock.f_52310_, \u00e2\u02dc\u0192 && \u00e2\u02dc\u0192 != 2);
                        this.m_5974_(p_66854_, \u00e2\u02dc\u01922.m_122178_(p_66857_.m_66886_() + \u00e2\u02dc\u0192, p_66857_.m_66899_() + \u00e2\u02dc\u0192, p_66857_.m_66893_() + \u00e2\u02dc\u0192), \u00e2\u02dc\u01923);
                    }
                }
            }
        }
        EndCrystal endCrystal = EntityType.f_20564_.m_20615_(p_66854_.m_6018_());
        endCrystal.m_31052_(p_66856_.m_68122_());
        endCrystal.m_20331_(p_66856_.m_68116_());
        endCrystal.m_7678_((double)p_66857_.m_66886_() + 0.5, p_66857_.m_66899_() + 1, (double)p_66857_.m_66893_() + 0.5, p_66855_.nextFloat() * 360.0f, 0.0f);
        p_66854_.m_7967_(endCrystal);
        this.m_5974_(p_66854_, new BlockPos(p_66857_.m_66886_(), p_66857_.m_66899_(), p_66857_.m_66893_()), Blocks.f_50752_.m_49966_());
    }

    public static class EndSpike {
        public static final Codec<EndSpike> f_66872_ = RecordCodecBuilder.create(p_66890_ -> p_66890_.group((App)Codec.INT.fieldOf("centerX").orElse((Object)0).forGetter(p_160382_ -> p_160382_.f_66873_), (App)Codec.INT.fieldOf("centerZ").orElse((Object)0).forGetter(p_160380_ -> p_160380_.f_66874_), (App)Codec.INT.fieldOf("radius").orElse((Object)0).forGetter(p_160378_ -> p_160378_.f_66875_), (App)Codec.INT.fieldOf("height").orElse((Object)0).forGetter(p_160376_ -> p_160376_.f_66876_), (App)Codec.BOOL.fieldOf("guarded").orElse((Object)false).forGetter(p_160374_ -> p_160374_.f_66877_)).apply((Applicative)p_66890_, EndSpike::new));
        private final int f_66873_;
        private final int f_66874_;
        private final int f_66875_;
        private final int f_66876_;
        private final boolean f_66877_;
        private final AABB f_66878_;

        public EndSpike(int p_66881_, int p_66882_, int p_66883_, int p_66884_, boolean p_66885_) {
            this.f_66873_ = p_66881_;
            this.f_66874_ = p_66882_;
            this.f_66875_ = p_66883_;
            this.f_66876_ = p_66884_;
            this.f_66877_ = p_66885_;
            this.f_66878_ = new AABB(p_66881_ - p_66883_, DimensionType.f_156653_, p_66882_ - p_66883_, p_66881_ + p_66883_, DimensionType.f_156652_, p_66882_ + p_66883_);
        }

        public boolean m_66891_(BlockPos p_66892_) {
            return SectionPos.m_123171_(p_66892_.m_123341_()) == SectionPos.m_123171_(this.f_66873_) && SectionPos.m_123171_(p_66892_.m_123343_()) == SectionPos.m_123171_(this.f_66874_);
        }

        public int m_66886_() {
            return this.f_66873_;
        }

        public int m_66893_() {
            return this.f_66874_;
        }

        public int m_66896_() {
            return this.f_66875_;
        }

        public int m_66899_() {
            return this.f_66876_;
        }

        public boolean m_66902_() {
            return this.f_66877_;
        }

        public AABB m_66905_() {
            return this.f_66878_;
        }
    }

    static class SpikeCacheLoader
    extends CacheLoader<Long, List<EndSpike>> {
        SpikeCacheLoader() {
        }

        public List<EndSpike> load(Long p_66910_) {
            List list = IntStream.range(0, 10).boxed().collect(Collectors.toList());
            Collections.shuffle(list, new Random(p_66910_));
            ArrayList \u00e2\u02dc\u01922 = Lists.newArrayList();
            for (int i = 0; i < 10; ++i) {
                \u00e2\u02dc\u0192 = Mth.m_14107_(42.0 * Math.cos(2.0 * (-Math.PI + 0.3141592653589793 * (double)i)));
                \u00e2\u02dc\u0192 = Mth.m_14107_(42.0 * Math.sin(2.0 * (-Math.PI + 0.3141592653589793 * (double)i)));
                \u00e2\u02dc\u0192 = (Integer)list.get(i);
                \u00e2\u02dc\u0192 = 2 + \u00e2\u02dc\u0192 / 3;
                \u00e2\u02dc\u0192 = 76 + \u00e2\u02dc\u0192 * 3;
                boolean bl = \u00e2\u02dc\u0192 == 1 || \u00e2\u02dc\u0192 == 2;
                \u00e2\u02dc\u01922.add(new EndSpike(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, bl));
            }
            return \u00e2\u02dc\u01922;
        }

        public /* synthetic */ Object load(Object object) throws Exception {
            return this.load((Long)object);
        }
    }
}

