/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;

public class TreeFeature
extends Feature<TreeConfiguration> {
    private static final int f_160509_ = 19;

    public TreeFeature(Codec<TreeConfiguration> p_67201_) {
        super(p_67201_);
    }

    public static boolean m_67262_(LevelSimulatedReader p_67263_, BlockPos p_67264_) {
        return TreeFeature.m_67272_(p_67263_, p_67264_) || p_67263_.m_7433_(p_67264_, p_67281_ -> p_67281_.m_60620_(BlockTags.f_13106_));
    }

    private static boolean m_67277_(LevelSimulatedReader p_67278_, BlockPos p_67279_) {
        return p_67278_.m_7433_(p_67279_, p_67276_ -> p_67276_.m_60713_(Blocks.f_50191_));
    }

    private static boolean m_67282_(LevelSimulatedReader p_67283_, BlockPos p_67284_) {
        return p_67283_.m_7433_(p_67284_, p_67271_ -> p_67271_.m_60713_(Blocks.f_49990_));
    }

    public static boolean m_67267_(LevelSimulatedReader p_67268_, BlockPos p_67269_) {
        return p_67268_.m_7433_(p_67269_, p_67266_ -> p_67266_.m_60795_() || p_67266_.m_60620_(BlockTags.f_13035_));
    }

    private static boolean m_67288_(LevelSimulatedReader p_67289_, BlockPos p_67290_) {
        return p_67289_.m_7433_(p_67290_, p_160551_ -> {
            Material material = p_160551_.m_60767_();
            return material == Material.f_76302_;
        });
    }

    private static void m_67256_(LevelWriter p_67257_, BlockPos p_67258_, BlockState p_67259_) {
        p_67257_.m_7731_(p_67258_, p_67259_, 19);
    }

    public static boolean m_67272_(LevelSimulatedReader p_67273_, BlockPos p_67274_) {
        return TreeFeature.m_67267_(p_67273_, p_67274_) || TreeFeature.m_67288_(p_67273_, p_67274_) || TreeFeature.m_67282_(p_67273_, p_67274_);
    }

    private boolean m_160510_(WorldGenLevel p_160511_, Random p_160512_, BlockPos p_160513_, BiConsumer<BlockPos, BlockState> p_160514_, BiConsumer<BlockPos, BlockState> p_160515_, TreeConfiguration p_160516_) {
        int n = p_160516_.f_68190_.m_70309_(p_160512_);
        \u00e2\u02dc\u0192 = p_160516_.f_68189_.m_5969_(p_160512_, n, p_160516_);
        \u00e2\u02dc\u0192 = n - \u00e2\u02dc\u0192;
        \u00e2\u02dc\u0192 = p_160516_.f_68189_.m_5937_(p_160512_, \u00e2\u02dc\u0192);
        if (p_160513_.m_123342_() < p_160511_.m_141937_() + 1 || p_160513_.m_123342_() + n + 1 > p_160511_.m_151558_()) {
            return false;
        }
        if (!p_160516_.f_161214_.m_7112_(p_160512_, p_160513_).m_60710_(p_160511_, p_160513_)) {
            return false;
        }
        OptionalInt \u00e2\u02dc\u01922 = p_160516_.f_68191_.m_68295_();
        \u00e2\u02dc\u0192 = this.m_67215_(p_160511_, n, p_160513_, p_160516_);
        if (!(\u00e2\u02dc\u0192 >= n || \u00e2\u02dc\u01922.isPresent() && \u00e2\u02dc\u0192 >= \u00e2\u02dc\u01922.getAsInt())) {
            return false;
        }
        List<FoliagePlacer.FoliageAttachment> \u00e2\u02dc\u01923 = p_160516_.f_68190_.m_142625_(p_160511_, p_160514_, p_160512_, \u00e2\u02dc\u0192, p_160513_, p_160516_);
        \u00e2\u02dc\u01923.forEach(p_160539_ -> p_160532_.f_68189_.m_161413_(p_160511_, p_160515_, p_160512_, p_160516_, \u00e2\u02dc\u0192, (FoliagePlacer.FoliageAttachment)p_160539_, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192));
        return true;
    }

    private int m_67215_(LevelSimulatedReader p_67216_, int p_67217_, BlockPos p_67218_, TreeConfiguration p_67219_) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int i = 0; i <= p_67217_ + 1; ++i) {
            \u00e2\u02dc\u0192 = p_67219_.f_68191_.m_6133_(p_67217_, i);
            for (\u00e2\u02dc\u0192 = -\u00e2\u02dc\u0192; \u00e2\u02dc\u0192 <= \u00e2\u02dc\u0192; ++\u00e2\u02dc\u0192) {
                for (\u00e2\u02dc\u0192 = -\u00e2\u02dc\u0192; \u00e2\u02dc\u0192 <= \u00e2\u02dc\u0192; ++\u00e2\u02dc\u0192) {
                    mutableBlockPos.m_122154_(p_67218_, \u00e2\u02dc\u0192, i, \u00e2\u02dc\u0192);
                    if (TreeFeature.m_67262_(p_67216_, mutableBlockPos) && (p_67219_.f_68193_ || !TreeFeature.m_67277_(p_67216_, mutableBlockPos))) continue;
                    return i - 2;
                }
            }
        }
        return p_67217_;
    }

    @Override
    protected void m_5974_(LevelWriter p_67221_, BlockPos p_67222_, BlockState p_67223_) {
        TreeFeature.m_67256_(p_67221_, p_67222_, p_67223_);
    }

    @Override
    public final boolean m_142674_(FeaturePlaceContext<TreeConfiguration> p_160530_) {
        WorldGenLevel worldGenLevel = p_160530_.m_159774_();
        Random \u00e2\u02dc\u01922 = p_160530_.m_159776_();
        BlockPos \u00e2\u02dc\u01923 = p_160530_.m_159777_();
        TreeConfiguration \u00e2\u02dc\u01924 = p_160530_.m_159778_();
        HashSet \u00e2\u02dc\u01925 = Sets.newHashSet();
        HashSet \u00e2\u02dc\u01926 = Sets.newHashSet();
        HashSet \u00e2\u02dc\u01927 = Sets.newHashSet();
        BiConsumer<BlockPos, BlockState> \u00e2\u02dc\u01928 = (p_160555_, p_160556_) -> {
            \u00e2\u02dc\u01925.add(p_160555_.m_7949_());
            worldGenLevel.m_7731_((BlockPos)p_160555_, (BlockState)p_160556_, 19);
        };
        BiConsumer<BlockPos, BlockState> \u00e2\u02dc\u01929 = (p_160548_, p_160549_) -> {
            \u00e2\u02dc\u01926.add(p_160548_.m_7949_());
            worldGenLevel.m_7731_((BlockPos)p_160548_, (BlockState)p_160549_, 19);
        };
        BiConsumer<BlockPos, BlockState> \u00e2\u02dc\u019210 = (p_160543_, p_160544_) -> {
            \u00e2\u02dc\u01927.add(p_160543_.m_7949_());
            worldGenLevel.m_7731_((BlockPos)p_160543_, (BlockState)p_160544_, 19);
        };
        boolean \u00e2\u02dc\u019211 = this.m_160510_(worldGenLevel, \u00e2\u02dc\u01922, \u00e2\u02dc\u01923, \u00e2\u02dc\u01928, \u00e2\u02dc\u01929, \u00e2\u02dc\u01924);
        if (!\u00e2\u02dc\u019211 || \u00e2\u02dc\u01925.isEmpty() && \u00e2\u02dc\u01926.isEmpty()) {
            return false;
        }
        if (!\u00e2\u02dc\u01924.f_68187_.isEmpty()) {
            ArrayList arrayList = Lists.newArrayList((Iterable)\u00e2\u02dc\u01925);
            \u00e2\u02dc\u0192 = Lists.newArrayList((Iterable)\u00e2\u02dc\u01926);
            arrayList.sort(Comparator.comparingInt(Vec3i::m_123342_));
            \u00e2\u02dc\u0192.sort(Comparator.comparingInt(Vec3i::m_123342_));
            \u00e2\u02dc\u01924.f_68187_.forEach(p_160528_ -> p_160528_.m_142741_(worldGenLevel, \u00e2\u02dc\u019210, \u00e2\u02dc\u01922, arrayList, \u00e2\u02dc\u0192));
        }
        return BoundingBox.m_162378_(Iterables.concat((Iterable)\u00e2\u02dc\u01925, (Iterable)\u00e2\u02dc\u01926, (Iterable)\u00e2\u02dc\u01927)).map(p_160521_ -> {
            DiscreteVoxelShape discreteVoxelShape = TreeFeature.m_67202_(worldGenLevel, p_160521_, \u00e2\u02dc\u01925, \u00e2\u02dc\u01927);
            StructureTemplate.m_74510_(worldGenLevel, 3, discreteVoxelShape, p_160521_.m_162395_(), p_160521_.m_162396_(), p_160521_.m_162398_());
            return true;
        }).orElse(false);
    }

    private static DiscreteVoxelShape m_67202_(LevelAccessor p_67203_, BoundingBox p_67204_, Set<BlockPos> p_67205_, Set<BlockPos> p_67206_) {
        ArrayList arrayList = Lists.newArrayList();
        BitSetDiscreteVoxelShape \u00e2\u02dc\u01922 = new BitSetDiscreteVoxelShape(p_67204_.m_71056_(), p_67204_.m_71057_(), p_67204_.m_71058_());
        int \u00e2\u02dc\u01923 = 6;
        for (int i = 0; i < 6; ++i) {
            arrayList.add(Sets.newHashSet());
        }
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (Object object : Lists.newArrayList(p_67206_)) {
            if (!p_67204_.m_71051_((Vec3i)object)) continue;
            ((DiscreteVoxelShape)\u00e2\u02dc\u01922).m_142703_(((Vec3i)object).m_123341_() - p_67204_.m_162395_(), ((Vec3i)object).m_123342_() - p_67204_.m_162396_(), ((Vec3i)object).m_123343_() - p_67204_.m_162398_());
        }
        for (Object object : Lists.newArrayList(p_67205_)) {
            if (p_67204_.m_71051_((Vec3i)object)) {
                ((DiscreteVoxelShape)\u00e2\u02dc\u01922).m_142703_(((Vec3i)object).m_123341_() - p_67204_.m_162395_(), ((Vec3i)object).m_123342_() - p_67204_.m_162396_(), ((Vec3i)object).m_123343_() - p_67204_.m_162398_());
            }
            for (Direction direction : Direction.values()) {
                mutableBlockPos.m_122159_((Vec3i)object, direction);
                if (p_67205_.contains(mutableBlockPos) || !(\u00e2\u02dc\u0192 = p_67203_.m_8055_(mutableBlockPos)).m_61138_(BlockStateProperties.f_61414_)) continue;
                ((Set)arrayList.get(0)).add(mutableBlockPos.m_7949_());
                TreeFeature.m_67256_(p_67203_, mutableBlockPos, (BlockState)\u00e2\u02dc\u0192.m_61124_(BlockStateProperties.f_61414_, 1));
                if (!p_67204_.m_71051_(mutableBlockPos)) continue;
                ((DiscreteVoxelShape)\u00e2\u02dc\u01922).m_142703_(mutableBlockPos.m_123341_() - p_67204_.m_162395_(), mutableBlockPos.m_123342_() - p_67204_.m_162396_(), mutableBlockPos.m_123343_() - p_67204_.m_162398_());
            }
        }
        for (int i = 1; i < 6; ++i) {
            Object object;
            object = (Set)arrayList.get(i - 1);
            Set \u00e2\u02dc\u01924 = (Set)arrayList.get(i);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                BlockPos blockPos = (BlockPos)iterator.next();
                if (p_67204_.m_71051_(blockPos)) {
                    ((DiscreteVoxelShape)\u00e2\u02dc\u01922).m_142703_(blockPos.m_123341_() - p_67204_.m_162395_(), blockPos.m_123342_() - p_67204_.m_162396_(), blockPos.m_123343_() - p_67204_.m_162398_());
                }
                for (Direction direction : Direction.values()) {
                    mutableBlockPos.m_122159_(blockPos, direction);
                    if (object.contains(mutableBlockPos) || \u00e2\u02dc\u01924.contains(mutableBlockPos) || !(\u00e2\u02dc\u0192 = p_67203_.m_8055_(mutableBlockPos)).m_61138_(BlockStateProperties.f_61414_) || (\u00e2\u02dc\u0192 = \u00e2\u02dc\u0192.m_61143_(BlockStateProperties.f_61414_).intValue()) <= i + 1) continue;
                    BlockState blockState = (BlockState)\u00e2\u02dc\u0192.m_61124_(BlockStateProperties.f_61414_, i + 1);
                    TreeFeature.m_67256_(p_67203_, mutableBlockPos, blockState);
                    if (p_67204_.m_71051_(mutableBlockPos)) {
                        ((DiscreteVoxelShape)\u00e2\u02dc\u01922).m_142703_(mutableBlockPos.m_123341_() - p_67204_.m_162395_(), mutableBlockPos.m_123342_() - p_67204_.m_162396_(), mutableBlockPos.m_123343_() - p_67204_.m_162398_());
                    }
                    \u00e2\u02dc\u01924.add(mutableBlockPos.m_7949_());
                }
            }
        }
        return \u00e2\u02dc\u01922;
    }
}

