/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.structures;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.structures.EmptyPoolElement;
import net.minecraft.world.level.levelgen.feature.structures.JigsawJunction;
import net.minecraft.world.level.levelgen.feature.structures.StructurePoolElement;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JigsawPlacement {
    static final Logger f_68941_ = LogManager.getLogger();

    public static void m_161612_(RegistryAccess p_161613_, JigsawConfiguration p_161614_, PieceFactory p_161615_, ChunkGenerator p_161616_, StructureManager p_161617_, BlockPos p_161618_, StructurePieceAccessor p_161619_, Random p_161620_, boolean p_161621_, boolean p_161622_, LevelHeightAccessor p_161623_) {
        StructureFeature.m_67096_();
        ArrayList arrayList = Lists.newArrayList();
        Registry<StructureTemplatePool> \u00e2\u02dc\u01922 = p_161613_.m_175515_(Registry.f_122884_);
        Rotation \u00e2\u02dc\u01923 = Rotation.m_55956_(p_161620_);
        StructureTemplatePool \u00e2\u02dc\u01924 = p_161614_.m_67766_().get();
        StructurePoolElement \u00e2\u02dc\u01925 = \u00e2\u02dc\u01924.m_69273_(p_161620_);
        if (\u00e2\u02dc\u01925 == EmptyPoolElement.f_68856_) {
            return;
        }
        PoolElementStructurePiece \u00e2\u02dc\u01926 = p_161615_.m_68964_(p_161617_, \u00e2\u02dc\u01925, p_161618_, \u00e2\u02dc\u01925.m_69231_(), \u00e2\u02dc\u01923, \u00e2\u02dc\u01925.m_6867_(p_161617_, p_161618_, \u00e2\u02dc\u01923));
        BoundingBox \u00e2\u02dc\u01927 = \u00e2\u02dc\u01926.m_73547_();
        int \u00e2\u02dc\u01928 = (\u00e2\u02dc\u01927.m_162399_() + \u00e2\u02dc\u01927.m_162395_()) / 2;
        int \u00e2\u02dc\u01929 = (\u00e2\u02dc\u01927.m_162401_() + \u00e2\u02dc\u01927.m_162398_()) / 2;
        int \u00e2\u02dc\u019210 = p_161622_ ? p_161618_.m_123342_() + p_161616_.m_156174_(\u00e2\u02dc\u01928, \u00e2\u02dc\u01929, Heightmap.Types.WORLD_SURFACE_WG, p_161623_) : p_161618_.m_123342_();
        int \u00e2\u02dc\u019211 = \u00e2\u02dc\u01927.m_162396_() + \u00e2\u02dc\u01926.m_72647_();
        \u00e2\u02dc\u01926.m_6324_(0, \u00e2\u02dc\u019210 - \u00e2\u02dc\u019211, 0);
        arrayList.add(\u00e2\u02dc\u01926);
        if (p_161614_.m_67765_() <= 0) {
            return;
        }
        int \u00e2\u02dc\u019212 = 80;
        AABB \u00e2\u02dc\u019213 = new AABB(\u00e2\u02dc\u01928 - 80, \u00e2\u02dc\u019210 - 80, \u00e2\u02dc\u01929 - 80, \u00e2\u02dc\u01928 + 80 + 1, \u00e2\u02dc\u019210 + 80 + 1, \u00e2\u02dc\u01929 + 80 + 1);
        Placer \u00e2\u02dc\u019214 = new Placer(\u00e2\u02dc\u01922, p_161614_.m_67765_(), p_161615_, p_161616_, p_161617_, arrayList, p_161620_);
        \u00e2\u02dc\u019214.f_69001_.addLast(new PieceState(\u00e2\u02dc\u01926, (MutableObject<VoxelShape>)new MutableObject((Object)Shapes.m_83113_(Shapes.m_83064_(\u00e2\u02dc\u019213), Shapes.m_83064_(AABB.m_82321_(\u00e2\u02dc\u01927)), BooleanOp.f_82685_)), \u00e2\u02dc\u019210 + 80, 0));
        while (!\u00e2\u02dc\u019214.f_69001_.isEmpty()) {
            PieceState pieceState = \u00e2\u02dc\u019214.f_69001_.removeFirst();
            \u00e2\u02dc\u019214.m_161636_(pieceState.f_68971_, pieceState.f_68972_, pieceState.f_68973_, pieceState.f_68974_, p_161621_, p_161623_);
        }
        arrayList.forEach(p_161619_::m_142679_);
    }

    public static void m_161624_(RegistryAccess p_161625_, PoolElementStructurePiece p_161626_, int p_161627_, PieceFactory p_161628_, ChunkGenerator p_161629_, StructureManager p_161630_, List<? super PoolElementStructurePiece> p_161631_, Random p_161632_, LevelHeightAccessor p_161633_) {
        Registry<StructureTemplatePool> registry = p_161625_.m_175515_(Registry.f_122884_);
        Placer \u00e2\u02dc\u01922 = new Placer(registry, p_161627_, p_161628_, p_161629_, p_161630_, p_161631_, p_161632_);
        \u00e2\u02dc\u01922.f_69001_.addLast(new PieceState(p_161626_, (MutableObject<VoxelShape>)new MutableObject((Object)Shapes.f_83036_), 0, 0));
        while (!\u00e2\u02dc\u01922.f_69001_.isEmpty()) {
            PieceState pieceState = \u00e2\u02dc\u01922.f_69001_.removeFirst();
            \u00e2\u02dc\u01922.m_161636_(pieceState.f_68971_, pieceState.f_68972_, pieceState.f_68973_, pieceState.f_68974_, false, p_161633_);
        }
    }

    public static interface PieceFactory {
        public PoolElementStructurePiece m_68964_(StructureManager var1, StructurePoolElement var2, BlockPos var3, int var4, Rotation var5, BoundingBox var6);
    }

    static final class Placer {
        private final Registry<StructureTemplatePool> f_68994_;
        private final int f_68995_;
        private final PieceFactory f_68996_;
        private final ChunkGenerator f_68997_;
        private final StructureManager f_68998_;
        private final List<? super PoolElementStructurePiece> f_68999_;
        private final Random f_69000_;
        final Deque<PieceState> f_69001_ = Queues.newArrayDeque();

        Placer(Registry<StructureTemplatePool> p_69003_, int p_69004_, PieceFactory p_69005_, ChunkGenerator p_69006_, StructureManager p_69007_, List<? super PoolElementStructurePiece> p_69008_, Random p_69009_) {
            this.f_68994_ = p_69003_;
            this.f_68995_ = p_69004_;
            this.f_68996_ = p_69005_;
            this.f_68997_ = p_69006_;
            this.f_68998_ = p_69007_;
            this.f_68999_ = p_69008_;
            this.f_69000_ = p_69009_;
        }

        void m_161636_(PoolElementStructurePiece p_161637_, MutableObject<VoxelShape> p_161638_, int p_161639_, int p_161640_, boolean p_161641_, LevelHeightAccessor p_161642_) {
            StructurePoolElement structurePoolElement = p_161637_.m_72645_();
            BlockPos \u00e2\u02dc\u01922 = p_161637_.m_72646_();
            Rotation \u00e2\u02dc\u01923 = p_161637_.m_6830_();
            StructureTemplatePool.Projection \u00e2\u02dc\u01924 = structurePoolElement.m_69230_();
            boolean \u00e2\u02dc\u01925 = \u00e2\u02dc\u01924 == StructureTemplatePool.Projection.RIGID;
            MutableObject<VoxelShape> \u00e2\u02dc\u01926 = new MutableObject<VoxelShape>();
            BoundingBox \u00e2\u02dc\u01927 = p_161637_.m_73547_();
            int \u00e2\u02dc\u01928 = \u00e2\u02dc\u01927.m_162396_();
            block0: for (StructureTemplate.StructureBlockInfo structureBlockInfo : structurePoolElement.m_6439_(this.f_68998_, \u00e2\u02dc\u01922, \u00e2\u02dc\u01923, this.f_69000_)) {
                int \u00e2\u02dc\u019218;
                Direction direction = JigsawBlock.m_54250_(structureBlockInfo.f_74676_);
                BlockPos \u00e2\u02dc\u01929 = structureBlockInfo.f_74675_;
                BlockPos \u00e2\u02dc\u019210 = \u00e2\u02dc\u01929.m_142300_(direction);
                int \u00e2\u02dc\u019211 = \u00e2\u02dc\u01929.m_123342_() - \u00e2\u02dc\u01928;
                int \u00e2\u02dc\u019212 = -1;
                ResourceLocation \u00e2\u02dc\u019213 = new ResourceLocation(structureBlockInfo.f_74677_.m_128461_("pool"));
                Optional<StructureTemplatePool> \u00e2\u02dc\u019214 = this.f_68994_.m_6612_(\u00e2\u02dc\u019213);
                if (!\u00e2\u02dc\u019214.isPresent() || \u00e2\u02dc\u019214.get().m_69278_() == 0 && !Objects.equals(\u00e2\u02dc\u019213, Pools.f_127186_.m_135782_())) {
                    f_68941_.warn("Empty or non-existent pool: {}", (Object)\u00e2\u02dc\u019213);
                    continue;
                }
                ResourceLocation \u00e2\u02dc\u019215 = \u00e2\u02dc\u019214.get().m_69263_();
                Optional<StructureTemplatePool> \u00e2\u02dc\u019216 = this.f_68994_.m_6612_(\u00e2\u02dc\u019215);
                if (!\u00e2\u02dc\u019216.isPresent() || \u00e2\u02dc\u019216.get().m_69278_() == 0 && !Objects.equals(\u00e2\u02dc\u019215, Pools.f_127186_.m_135782_())) {
                    f_68941_.warn("Empty or non-existent fallback pool: {}", (Object)\u00e2\u02dc\u019215);
                    continue;
                }
                boolean \u00e2\u02dc\u019217 = \u00e2\u02dc\u01927.m_71051_(\u00e2\u02dc\u019210);
                if (\u00e2\u02dc\u019217) {
                    MutableObject<VoxelShape> mutableObject = \u00e2\u02dc\u01926;
                    \u00e2\u02dc\u019218 = \u00e2\u02dc\u01928;
                    if (\u00e2\u02dc\u01926.getValue() == null) {
                        \u00e2\u02dc\u01926.setValue((Object)Shapes.m_83064_(AABB.m_82321_(\u00e2\u02dc\u01927)));
                    }
                } else {
                    mutableObject = p_161638_;
                    \u00e2\u02dc\u019218 = p_161639_;
                }
                ArrayList arrayList = Lists.newArrayList();
                if (p_161640_ != this.f_68995_) {
                    arrayList.addAll(\u00e2\u02dc\u019214.get().m_69276_(this.f_69000_));
                }
                arrayList.addAll(\u00e2\u02dc\u019216.get().m_69276_(this.f_69000_));
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext() && (\u00e2\u02dc\u0192 = (StructurePoolElement)iterator.next()) != EmptyPoolElement.f_68856_) {
                    for (Rotation rotation : Rotation.m_55958_(this.f_69000_)) {
                        List<StructureTemplate.StructureBlockInfo> list = \u00e2\u02dc\u0192.m_6439_(this.f_68998_, BlockPos.f_121853_, rotation, this.f_69000_);
                        BoundingBox \u00e2\u02dc\u019219 = \u00e2\u02dc\u0192.m_6867_(this.f_68998_, BlockPos.f_121853_, rotation);
                        int \u00e2\u02dc\u019220 = !p_161641_ || \u00e2\u02dc\u019219.m_71057_() > 16 ? 0 : list.stream().mapToInt(p_69032_ -> {
                            if (!\u00e2\u02dc\u019219.m_71051_(p_69032_.f_74675_.m_142300_(JigsawBlock.m_54250_(p_69032_.f_74676_)))) {
                                return 0;
                            }
                            ResourceLocation resourceLocation = new ResourceLocation(p_69032_.f_74677_.m_128461_("pool"));
                            Optional<StructureTemplatePool> \u00e2\u02dc\u01922 = this.f_68994_.m_6612_(resourceLocation);
                            Optional<Integer> \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922.flatMap(p_161646_ -> this.f_68994_.m_6612_(p_161646_.m_69263_()));
                            int \u00e2\u02dc\u01924 = \u00e2\u02dc\u01922.map(p_161644_ -> p_161644_.m_69268_(this.f_68998_)).orElse(0);
                            int \u00e2\u02dc\u01925 = \u00e2\u02dc\u01923.map(p_161635_ -> p_161635_.m_69268_(this.f_68998_)).orElse(0);
                            return Math.max(\u00e2\u02dc\u01924, \u00e2\u02dc\u01925);
                        }).max().orElse(0);
                        for (StructureTemplate.StructureBlockInfo structureBlockInfo2 : list) {
                            int n;
                            if (!JigsawBlock.m_54245_(structureBlockInfo, structureBlockInfo2)) continue;
                            BlockPos blockPos = structureBlockInfo2.f_74675_;
                            \u00e2\u02dc\u0192 = \u00e2\u02dc\u019210.m_141950_(blockPos);
                            BoundingBox \u00e2\u02dc\u019221 = \u00e2\u02dc\u0192.m_6867_(this.f_68998_, \u00e2\u02dc\u0192, rotation);
                            int \u00e2\u02dc\u019222 = \u00e2\u02dc\u019221.m_162396_();
                            StructureTemplatePool.Projection \u00e2\u02dc\u019223 = \u00e2\u02dc\u0192.m_69230_();
                            boolean \u00e2\u02dc\u019224 = \u00e2\u02dc\u019223 == StructureTemplatePool.Projection.RIGID;
                            int \u00e2\u02dc\u019225 = blockPos.m_123342_();
                            int \u00e2\u02dc\u019226 = \u00e2\u02dc\u019211 - \u00e2\u02dc\u019225 + JigsawBlock.m_54250_(structureBlockInfo.f_74676_).m_122430_();
                            if (\u00e2\u02dc\u01925 && \u00e2\u02dc\u019224) {
                                n = \u00e2\u02dc\u01928 + \u00e2\u02dc\u019226;
                            } else {
                                if (\u00e2\u02dc\u019212 == -1) {
                                    \u00e2\u02dc\u019212 = this.f_68997_.m_156174_(\u00e2\u02dc\u01929.m_123341_(), \u00e2\u02dc\u01929.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, p_161642_);
                                }
                                n = \u00e2\u02dc\u019212 - \u00e2\u02dc\u019225;
                            }
                            \u00e2\u02dc\u0192 = n - \u00e2\u02dc\u019222;
                            BoundingBox \u00e2\u02dc\u019227 = \u00e2\u02dc\u019221.m_71045_(0, \u00e2\u02dc\u0192, 0);
                            BlockPos \u00e2\u02dc\u019228 = \u00e2\u02dc\u0192.m_142082_(0, \u00e2\u02dc\u0192, 0);
                            if (\u00e2\u02dc\u019220 > 0) {
                                \u00e2\u02dc\u0192 = Math.max(\u00e2\u02dc\u019220 + 1, \u00e2\u02dc\u019227.m_162400_() - \u00e2\u02dc\u019227.m_162396_());
                                \u00e2\u02dc\u019227.m_162371_(new BlockPos(\u00e2\u02dc\u019227.m_162395_(), \u00e2\u02dc\u019227.m_162396_() + \u00e2\u02dc\u0192, \u00e2\u02dc\u019227.m_162398_()));
                            }
                            if (Shapes.m_83157_((VoxelShape)mutableObject.getValue(), Shapes.m_83064_(AABB.m_82321_(\u00e2\u02dc\u019227).m_82406_(0.25)), BooleanOp.f_82683_)) continue;
                            mutableObject.setValue((Object)Shapes.m_83148_((VoxelShape)mutableObject.getValue(), Shapes.m_83064_(AABB.m_82321_(\u00e2\u02dc\u019227)), BooleanOp.f_82685_));
                            \u00e2\u02dc\u0192 = p_161637_.m_72647_();
                            \u00e2\u02dc\u0192 = \u00e2\u02dc\u019224 ? \u00e2\u02dc\u0192 - \u00e2\u02dc\u019226 : \u00e2\u02dc\u0192.m_69231_();
                            PoolElementStructurePiece \u00e2\u02dc\u019229 = this.f_68996_.m_68964_(this.f_68998_, \u00e2\u02dc\u0192, \u00e2\u02dc\u019228, \u00e2\u02dc\u0192, rotation, \u00e2\u02dc\u019227);
                            if (\u00e2\u02dc\u01925) {
                                \u00e2\u02dc\u0192 = \u00e2\u02dc\u01928 + \u00e2\u02dc\u019211;
                            } else if (\u00e2\u02dc\u019224) {
                                \u00e2\u02dc\u0192 = n + \u00e2\u02dc\u019225;
                            } else {
                                if (\u00e2\u02dc\u019212 == -1) {
                                    \u00e2\u02dc\u019212 = this.f_68997_.m_156174_(\u00e2\u02dc\u01929.m_123341_(), \u00e2\u02dc\u01929.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, p_161642_);
                                }
                                \u00e2\u02dc\u0192 = \u00e2\u02dc\u019212 + \u00e2\u02dc\u019226 / 2;
                            }
                            p_161637_.m_72635_(new JigsawJunction(\u00e2\u02dc\u019210.m_123341_(), \u00e2\u02dc\u0192 - \u00e2\u02dc\u019211 + \u00e2\u02dc\u0192, \u00e2\u02dc\u019210.m_123343_(), \u00e2\u02dc\u019226, \u00e2\u02dc\u019223));
                            \u00e2\u02dc\u019229.m_72635_(new JigsawJunction(\u00e2\u02dc\u01929.m_123341_(), \u00e2\u02dc\u0192 - \u00e2\u02dc\u019225 + \u00e2\u02dc\u0192, \u00e2\u02dc\u01929.m_123343_(), -\u00e2\u02dc\u019226, \u00e2\u02dc\u01924));
                            this.f_68999_.add(\u00e2\u02dc\u019229);
                            if (p_161640_ + 1 > this.f_68995_) continue block0;
                            this.f_69001_.addLast(new PieceState(\u00e2\u02dc\u019229, mutableObject, \u00e2\u02dc\u019218, p_161640_ + 1));
                            continue block0;
                        }
                    }
                }
            }
        }
    }

    static final class PieceState {
        final PoolElementStructurePiece f_68971_;
        final MutableObject<VoxelShape> f_68972_;
        final int f_68973_;
        final int f_68974_;

        PieceState(PoolElementStructurePiece p_68976_, MutableObject<VoxelShape> p_68977_, int p_68978_, int p_68979_) {
            this.f_68971_ = p_68976_;
            this.f_68972_ = p_68977_;
            this.f_68973_ = p_68978_;
            this.f_68974_ = p_68979_;
        }
    }
}

