/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.trunkplacers;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class FancyTrunkPlacer
extends TrunkPlacer {
    public static final Codec<FancyTrunkPlacer> f_70091_ = RecordCodecBuilder.create(p_70136_ -> FancyTrunkPlacer.m_70305_(p_70136_).apply((Applicative)p_70136_, FancyTrunkPlacer::new));
    private static final double f_161796_ = 0.618;
    private static final double f_161797_ = 1.382;
    private static final double f_161798_ = 0.381;
    private static final double f_161799_ = 0.328;

    public FancyTrunkPlacer(int p_70094_, int p_70095_, int p_70096_) {
        super(p_70094_, p_70095_, p_70096_);
    }

    @Override
    protected TrunkPlacerType<?> m_7362_() {
        return TrunkPlacerType.f_70320_;
    }

    @Override
    public List<FoliagePlacer.FoliageAttachment> m_142625_(LevelSimulatedReader p_161801_, BiConsumer<BlockPos, BlockState> p_161802_, Random p_161803_, int p_161804_, BlockPos p_161805_, TreeConfiguration p_161806_) {
        int n = 5;
        \u00e2\u02dc\u0192 = p_161804_ + 2;
        \u00e2\u02dc\u0192 = Mth.m_14107_((double)\u00e2\u02dc\u0192 * 0.618);
        FancyTrunkPlacer.m_161880_(p_161801_, p_161802_, p_161803_, p_161805_.m_7495_(), p_161806_);
        double \u00e2\u02dc\u01922 = 1.0;
        \u00e2\u02dc\u0192 = Math.min(1, Mth.m_14107_(1.382 + Math.pow(1.0 * (double)\u00e2\u02dc\u0192 / 13.0, 2.0)));
        \u00e2\u02dc\u0192 = p_161805_.m_123342_() + \u00e2\u02dc\u0192;
        ArrayList \u00e2\u02dc\u01923 = Lists.newArrayList();
        \u00e2\u02dc\u01923.add(new FoliageCoords(p_161805_.m_6630_(\u00e2\u02dc\u0192), \u00e2\u02dc\u0192));
        for (\u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 - 5; \u00e2\u02dc\u0192 >= 0; --\u00e2\u02dc\u0192) {
            float f = FancyTrunkPlacer.m_70132_(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
            if (f < 0.0f) continue;
            for (int i = 0; i < \u00e2\u02dc\u0192; ++i) {
                double d = 1.0;
                \u00e2\u02dc\u0192 = 1.0 * (double)f * ((double)p_161803_.nextFloat() + 0.328);
                \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 * Math.sin(\u00e2\u02dc\u0192 = (double)(p_161803_.nextFloat() * 2.0f) * Math.PI) + 0.5;
                BlockPos \u00e2\u02dc\u01924 = p_161805_.m_142022_(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192 - 1, \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 * Math.cos(\u00e2\u02dc\u0192) + 0.5);
                if (!this.m_161815_(p_161801_, p_161802_, p_161803_, \u00e2\u02dc\u01924, \u00e2\u02dc\u0192 = \u00e2\u02dc\u01924.m_6630_(5), false, p_161806_)) continue;
                int \u00e2\u02dc\u01925 = p_161805_.m_123341_() - \u00e2\u02dc\u01924.m_123341_();
                int \u00e2\u02dc\u01926 = p_161805_.m_123343_() - \u00e2\u02dc\u01924.m_123343_();
                \u00e2\u02dc\u0192 = (double)\u00e2\u02dc\u01924.m_123342_() - Math.sqrt(\u00e2\u02dc\u01925 * \u00e2\u02dc\u01925 + \u00e2\u02dc\u01926 * \u00e2\u02dc\u01926) * 0.381;
                int \u00e2\u02dc\u01927 = \u00e2\u02dc\u0192 > (double)\u00e2\u02dc\u0192 ? \u00e2\u02dc\u0192 : (int)\u00e2\u02dc\u0192;
                BlockPos \u00e2\u02dc\u01928 = new BlockPos(p_161805_.m_123341_(), \u00e2\u02dc\u01927, p_161805_.m_123343_());
                if (!this.m_161815_(p_161801_, p_161802_, p_161803_, \u00e2\u02dc\u01928, \u00e2\u02dc\u01924, false, p_161806_)) continue;
                \u00e2\u02dc\u01923.add(new FoliageCoords(\u00e2\u02dc\u01924, \u00e2\u02dc\u01928.m_123342_()));
            }
        }
        this.m_161815_(p_161801_, p_161802_, p_161803_, p_161805_, p_161805_.m_6630_(\u00e2\u02dc\u0192), true, p_161806_);
        this.m_161807_(p_161801_, p_161802_, p_161803_, \u00e2\u02dc\u0192, p_161805_, \u00e2\u02dc\u01923, p_161806_);
        ArrayList arrayList = Lists.newArrayList();
        for (FoliageCoords foliageCoords : \u00e2\u02dc\u01923) {
            if (!this.m_70098_(\u00e2\u02dc\u0192, foliageCoords.m_70142_() - p_161805_.m_123342_())) continue;
            arrayList.add(foliageCoords.f_70137_);
        }
        return arrayList;
    }

    private boolean m_161815_(LevelSimulatedReader p_161816_, BiConsumer<BlockPos, BlockState> p_161817_, Random p_161818_, BlockPos p_161819_, BlockPos p_161820_, boolean p_161821_, TreeConfiguration p_161822_) {
        if (!p_161821_ && Objects.equals(p_161819_, p_161820_)) {
            return true;
        }
        BlockPos blockPos = p_161820_.m_142082_(-p_161819_.m_123341_(), -p_161819_.m_123342_(), -p_161819_.m_123343_());
        int \u00e2\u02dc\u01922 = this.m_70127_(blockPos);
        float \u00e2\u02dc\u01923 = (float)blockPos.m_123341_() / (float)\u00e2\u02dc\u01922;
        float \u00e2\u02dc\u01924 = (float)blockPos.m_123342_() / (float)\u00e2\u02dc\u01922;
        float \u00e2\u02dc\u01925 = (float)blockPos.m_123343_() / (float)\u00e2\u02dc\u01922;
        for (int i = 0; i <= \u00e2\u02dc\u01922; ++i) {
            BlockPos blockPos2 = p_161819_.m_142022_(0.5f + (float)i * \u00e2\u02dc\u01923, 0.5f + (float)i * \u00e2\u02dc\u01924, 0.5f + (float)i * \u00e2\u02dc\u01925);
            if (p_161821_) {
                TrunkPlacer.m_161886_(p_161816_, p_161817_, p_161818_, blockPos2, p_161822_, p_161826_ -> (BlockState)p_161826_.m_61124_(RotatedPillarBlock.f_55923_, this.m_70129_(p_161819_, blockPos2)));
                continue;
            }
            if (TreeFeature.m_67262_(p_161816_, blockPos2)) continue;
            return false;
        }
        return true;
    }

    private int m_70127_(BlockPos p_70128_) {
        int n = Mth.m_14040_(p_70128_.m_123341_());
        \u00e2\u02dc\u0192 = Mth.m_14040_(p_70128_.m_123342_());
        \u00e2\u02dc\u0192 = Mth.m_14040_(p_70128_.m_123343_());
        return Math.max(n, Math.max(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192));
    }

    private Direction.Axis m_70129_(BlockPos p_70130_, BlockPos p_70131_) {
        Direction.Axis axis = Direction.Axis.Y;
        int \u00e2\u02dc\u01922 = Math.abs(p_70131_.m_123341_() - p_70130_.m_123341_());
        int \u00e2\u02dc\u01923 = Math.max(\u00e2\u02dc\u01922, \u00e2\u02dc\u0192 = Math.abs(p_70131_.m_123343_() - p_70130_.m_123343_()));
        if (\u00e2\u02dc\u01923 > 0) {
            axis = \u00e2\u02dc\u01922 == \u00e2\u02dc\u01923 ? Direction.Axis.X : Direction.Axis.Z;
        }
        return axis;
    }

    private boolean m_70098_(int p_70099_, int p_70100_) {
        return (double)p_70100_ >= (double)p_70099_ * 0.2;
    }

    private void m_161807_(LevelSimulatedReader p_161808_, BiConsumer<BlockPos, BlockState> p_161809_, Random p_161810_, int p_161811_, BlockPos p_161812_, List<FoliageCoords> p_161813_, TreeConfiguration p_161814_) {
        for (FoliageCoords foliageCoords : p_161813_) {
            int n = foliageCoords.m_70142_();
            BlockPos \u00e2\u02dc\u01922 = new BlockPos(p_161812_.m_123341_(), n, p_161812_.m_123343_());
            if (\u00e2\u02dc\u01922.equals(foliageCoords.f_70137_.m_161451_()) || !this.m_70098_(p_161811_, n - p_161812_.m_123342_())) continue;
            this.m_161815_(p_161808_, p_161809_, p_161810_, \u00e2\u02dc\u01922, foliageCoords.f_70137_.m_161451_(), true, p_161814_);
        }
    }

    private static float m_70132_(int p_70133_, int p_70134_) {
        if ((float)p_70134_ < (float)p_70133_ * 0.3f) {
            return -1.0f;
        }
        float f = (float)p_70133_ / 2.0f;
        \u00e2\u02dc\u0192 = f - (float)p_70134_;
        \u00e2\u02dc\u0192 = Mth.m_14116_(f * f - \u00e2\u02dc\u0192 * \u00e2\u02dc\u0192);
        if (\u00e2\u02dc\u0192 == 0.0f) {
            \u00e2\u02dc\u0192 = f;
        } else if (Math.abs(\u00e2\u02dc\u0192) >= f) {
            return 0.0f;
        }
        return \u00e2\u02dc\u0192 * 0.5f;
    }

    static class FoliageCoords {
        final FoliagePlacer.FoliageAttachment f_70137_;
        private final int f_70138_;

        public FoliageCoords(BlockPos p_70140_, int p_70141_) {
            this.f_70137_ = new FoliagePlacer.FoliageAttachment(p_70140_, 0, false);
            this.f_70138_ = p_70141_;
        }

        public int m_70142_() {
            return this.f_70138_;
        }
    }
}

