/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.flat;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.Features;
import net.minecraft.data.worldgen.StructureFeatures;
import net.minecraft.resources.RegistryLookupCodec;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.LayerConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraft.world.level.levelgen.flat.FlatLayerInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FlatLevelGeneratorSettings {
    private static final Logger f_70348_ = LogManager.getLogger();
    public static final Codec<FlatLevelGeneratorSettings> f_70347_ = RecordCodecBuilder.create(p_70373_ -> p_70373_.group((App)RegistryLookupCodec.m_135622_(Registry.f_122885_).forGetter(p_161916_ -> p_161916_.f_70350_), (App)StructureSettings.f_64579_.fieldOf("structures").forGetter(FlatLevelGeneratorSettings::m_70395_), (App)FlatLayerInfo.f_70329_.listOf().fieldOf("layers").forGetter(FlatLevelGeneratorSettings::m_70401_), (App)Codec.BOOL.fieldOf("lakes").orElse((Object)false).forGetter(p_161914_ -> p_161914_.f_70357_), (App)Codec.BOOL.fieldOf("features").orElse((Object)false).forGetter(p_161912_ -> p_161912_.f_70356_), (App)Biome.f_47431_.optionalFieldOf("biome").orElseGet(Optional::empty).forGetter(p_161908_ -> Optional.of(p_161908_.f_70353_))).apply((Applicative)p_70373_, FlatLevelGeneratorSettings::new)).comapFlatMap(FlatLevelGeneratorSettings::m_161905_, Function.identity()).stable();
    private static final Map<StructureFeature<?>, ConfiguredStructureFeature<?, ?>> f_70349_ = Util.m_137469_(Maps.newHashMap(), p_70379_ -> {
        p_70379_.put(StructureFeature.f_67014_, StructureFeatures.f_127240_);
        p_70379_.put(StructureFeature.f_67028_, StructureFeatures.f_127258_);
        p_70379_.put(StructureFeature.f_67022_, StructureFeatures.f_127249_);
        p_70379_.put(StructureFeature.f_67021_, StructureFeatures.f_127248_);
        p_70379_.put(StructureFeature.f_67017_, StructureFeatures.f_127244_);
        p_70379_.put(StructureFeature.f_67016_, StructureFeatures.f_127243_);
        p_70379_.put(StructureFeature.f_67018_, StructureFeatures.f_127245_);
        p_70379_.put(StructureFeature.f_67024_, StructureFeatures.f_127251_);
        p_70379_.put(StructureFeature.f_67020_, StructureFeatures.f_127246_);
        p_70379_.put(StructureFeature.f_67023_, StructureFeatures.f_127250_);
        p_70379_.put(StructureFeature.f_67026_, StructureFeatures.f_127255_);
        p_70379_.put(StructureFeature.f_67015_, StructureFeatures.f_127242_);
        p_70379_.put(StructureFeature.f_67025_, StructureFeatures.f_127253_);
        p_70379_.put(StructureFeature.f_67013_, StructureFeatures.f_127239_);
        p_70379_.put(StructureFeature.f_67019_, StructureFeatures.f_127263_);
        p_70379_.put(StructureFeature.f_67030_, StructureFeatures.f_127257_);
    });
    private final Registry<Biome> f_70350_;
    private final StructureSettings f_70351_;
    private final List<FlatLayerInfo> f_70352_ = Lists.newArrayList();
    private Supplier<Biome> f_70353_;
    private final List<BlockState> f_70354_;
    private boolean f_70355_;
    private boolean f_70356_;
    private boolean f_70357_;

    private static DataResult<FlatLevelGeneratorSettings> m_161905_(FlatLevelGeneratorSettings p_161906_) {
        int n = p_161906_.f_70352_.stream().mapToInt(FlatLayerInfo::m_70337_).sum();
        if (n > DimensionType.f_156651_) {
            return DataResult.error((String)("Sum of layer heights is > " + DimensionType.f_156651_), (Object)p_161906_);
        }
        return DataResult.success((Object)p_161906_);
    }

    private FlatLevelGeneratorSettings(Registry<Biome> p_70363_, StructureSettings p_70364_, List<FlatLayerInfo> p_70365_, boolean p_70366_, boolean p_70367_, Optional<Supplier<Biome>> p_70368_) {
        this(p_70364_, p_70363_);
        if (p_70366_) {
            this.m_70385_();
        }
        if (p_70367_) {
            this.m_70369_();
        }
        this.f_70352_.addAll(p_70365_);
        this.m_70403_();
        if (!p_70368_.isPresent()) {
            f_70348_.error("Unknown biome, defaulting to plains");
            this.f_70353_ = () -> p_70363_.m_123013_(Biomes.f_48202_);
        } else {
            this.f_70353_ = p_70368_.get();
        }
    }

    public FlatLevelGeneratorSettings(StructureSettings p_70360_, Registry<Biome> p_70361_) {
        this.f_70350_ = p_70361_;
        this.f_70351_ = p_70360_;
        this.f_70353_ = () -> p_70361_.m_123013_(Biomes.f_48202_);
        this.f_70354_ = Lists.newArrayList();
    }

    public FlatLevelGeneratorSettings m_70370_(StructureSettings p_70371_) {
        return this.m_70380_(this.f_70352_, p_70371_);
    }

    public FlatLevelGeneratorSettings m_70380_(List<FlatLayerInfo> p_70381_, StructureSettings p_70382_) {
        FlatLevelGeneratorSettings flatLevelGeneratorSettings = new FlatLevelGeneratorSettings(p_70382_, this.f_70350_);
        for (FlatLayerInfo flatLayerInfo : p_70381_) {
            flatLevelGeneratorSettings.f_70352_.add(new FlatLayerInfo(flatLayerInfo.m_70337_(), flatLayerInfo.m_70344_().m_60734_()));
            flatLevelGeneratorSettings.m_70403_();
        }
        flatLevelGeneratorSettings.m_70383_(this.f_70353_);
        if (this.f_70356_) {
            flatLevelGeneratorSettings.m_70369_();
        }
        if (this.f_70357_) {
            flatLevelGeneratorSettings.m_70385_();
        }
        return flatLevelGeneratorSettings;
    }

    public void m_70369_() {
        this.f_70356_ = true;
    }

    public void m_70385_() {
        this.f_70357_ = true;
    }

    public Biome m_70390_() {
        boolean bl;
        Biome biome = this.m_70400_();
        BiomeGenerationSettings \u00e2\u02dc\u01922 = biome.m_47536_();
        BiomeGenerationSettings.Builder \u00e2\u02dc\u01923 = new BiomeGenerationSettings.Builder().m_47855_(\u00e2\u02dc\u01922.m_47821_());
        if (this.f_70357_) {
            \u00e2\u02dc\u01923.m_47842_(GenerationStep.Decoration.LAKES, Features.f_126875_);
            \u00e2\u02dc\u01923.m_47842_(GenerationStep.Decoration.LAKES, Features.f_126876_);
        }
        for (Map.Entry<StructureFeature<?>, StructureFeatureConfiguration> entry : this.f_70351_.m_64590_().entrySet()) {
            \u00e2\u02dc\u01923.m_47849_(\u00e2\u02dc\u01922.m_47803_(f_70349_.get(entry.getKey())));
        }
        boolean bl2 = bl = (!this.f_70355_ || this.f_70350_.m_7854_(biome).equals(Optional.of(Biomes.f_48173_))) && this.f_70356_;
        if (bl) {
            List<List<Supplier<ConfiguredFeature<?, ?>>>> list = \u00e2\u02dc\u01922.m_47818_();
            for (int n = 0; n < list.size(); ++n) {
                if (n == GenerationStep.Decoration.UNDERGROUND_STRUCTURES.ordinal() || n == GenerationStep.Decoration.SURFACE_STRUCTURES.ordinal()) continue;
                List<Supplier<ConfiguredFeature<?, ?>>> list2 = list.get(n);
                for (Supplier<ConfiguredFeature<?, ?>> supplier : list2) {
                    \u00e2\u02dc\u01923.m_47834_(n, supplier);
                }
            }
        }
        List<BlockState> list = this.m_161917_();
        for (int i = 0; i < list.size(); ++i) {
            BlockState object = list.get(i);
            if (Heightmap.Types.MOTION_BLOCKING.m_64299_().test(object)) continue;
            list.set(i, null);
            \u00e2\u02dc\u01923.m_47842_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, Feature.f_65750_.m_65815_(new LayerConfiguration(i, object)));
        }
        return new Biome.BiomeBuilder().m_47597_(biome.m_47530_()).m_47595_(biome.m_47567_()).m_47593_(biome.m_47545_()).m_47607_(biome.m_47551_()).m_47609_(biome.m_47554_()).m_47611_(biome.m_47548_()).m_47603_(biome.m_47557_()).m_47601_(\u00e2\u02dc\u01923.m_47831_()).m_47605_(biome.m_47518_()).m_47592_();
    }

    public StructureSettings m_70395_() {
        return this.f_70351_;
    }

    public Biome m_70400_() {
        return this.f_70353_.get();
    }

    public void m_70383_(Supplier<Biome> p_70384_) {
        this.f_70353_ = p_70384_;
    }

    public List<FlatLayerInfo> m_70401_() {
        return this.f_70352_;
    }

    public List<BlockState> m_161917_() {
        return this.f_70354_;
    }

    public void m_70403_() {
        this.f_70354_.clear();
        for (FlatLayerInfo flatLayerInfo : this.f_70352_) {
            for (int i = 0; i < flatLayerInfo.m_70337_(); ++i) {
                this.f_70354_.add(flatLayerInfo.m_70344_());
            }
        }
        this.f_70355_ = this.f_70354_.stream().allMatch(p_161904_ -> p_161904_.m_60713_(Blocks.f_50016_));
    }

    public static FlatLevelGeneratorSettings m_70376_(Registry<Biome> p_70377_) {
        StructureSettings structureSettings = new StructureSettings(Optional.of(StructureSettings.f_64581_), Maps.newHashMap((Map)ImmutableMap.of(StructureFeature.f_67028_, (Object)((StructureFeatureConfiguration)StructureSettings.f_64580_.get(StructureFeature.f_67028_)))));
        FlatLevelGeneratorSettings \u00e2\u02dc\u01922 = new FlatLevelGeneratorSettings(structureSettings, p_70377_);
        \u00e2\u02dc\u01922.f_70353_ = () -> p_70377_.m_123013_(Biomes.f_48202_);
        \u00e2\u02dc\u01922.m_70401_().add(new FlatLayerInfo(1, Blocks.f_50752_));
        \u00e2\u02dc\u01922.m_70401_().add(new FlatLayerInfo(2, Blocks.f_50493_));
        \u00e2\u02dc\u01922.m_70401_().add(new FlatLayerInfo(1, Blocks.f_50440_));
        \u00e2\u02dc\u01922.m_70403_();
        return \u00e2\u02dc\u01922;
    }
}

