/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.structure.StructureFeatureIndexSavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class LegacyStructureDataHandler {
    private static final Map<String, String> f_71299_ = Util.m_137469_(Maps.newHashMap(), p_71337_ -> {
        p_71337_.put("Village", "Village");
        p_71337_.put("Mineshaft", "Mineshaft");
        p_71337_.put("Mansion", "Mansion");
        p_71337_.put("Igloo", "Temple");
        p_71337_.put("Desert_Pyramid", "Temple");
        p_71337_.put("Jungle_Pyramid", "Temple");
        p_71337_.put("Swamp_Hut", "Temple");
        p_71337_.put("Stronghold", "Stronghold");
        p_71337_.put("Monument", "Monument");
        p_71337_.put("Fortress", "Fortress");
        p_71337_.put("EndCity", "EndCity");
    });
    private static final Map<String, String> f_71300_ = Util.m_137469_(Maps.newHashMap(), p_71325_ -> {
        p_71325_.put("Iglu", "Igloo");
        p_71325_.put("TeDP", "Desert_Pyramid");
        p_71325_.put("TeJP", "Jungle_Pyramid");
        p_71325_.put("TeSH", "Swamp_Hut");
    });
    private final boolean f_71301_;
    private final Map<String, Long2ObjectMap<CompoundTag>> f_71302_ = Maps.newHashMap();
    private final Map<String, StructureFeatureIndexSavedData> f_71303_ = Maps.newHashMap();
    private final List<String> f_71304_;
    private final List<String> f_71305_;

    public LegacyStructureDataHandler(@Nullable DimensionDataStorage p_71308_, List<String> p_71309_, List<String> p_71310_) {
        this.f_71304_ = p_71309_;
        this.f_71305_ = p_71310_;
        this.m_71320_(p_71308_);
        boolean bl = false;
        for (String string : this.f_71305_) {
            bl |= this.f_71302_.get(string) != null;
        }
        this.f_71301_ = bl;
    }

    public void m_71318_(long p_71319_) {
        for (String string : this.f_71304_) {
            StructureFeatureIndexSavedData structureFeatureIndexSavedData = this.f_71303_.get(string);
            if (structureFeatureIndexSavedData == null || !structureFeatureIndexSavedData.m_73373_(p_71319_)) continue;
            structureFeatureIndexSavedData.m_73375_(p_71319_);
            structureFeatureIndexSavedData.m_77762_();
        }
    }

    public CompoundTag m_71326_(CompoundTag p_71327_) {
        CompoundTag compoundTag;
        CompoundTag compoundTag2 = p_71327_.m_128469_("Level");
        ChunkPos \u00e2\u02dc\u01922 = new ChunkPos(compoundTag2.m_128451_("xPos"), compoundTag2.m_128451_("zPos"));
        if (this.m_71311_(\u00e2\u02dc\u01922.f_45578_, \u00e2\u02dc\u01922.f_45579_)) {
            p_71327_ = this.m_71328_(p_71327_, \u00e2\u02dc\u01922);
        }
        compoundTag = compoundTag2.m_128469_("Structures");
        compoundTag3 = compoundTag.m_128469_("References");
        for (String string : this.f_71305_) {
            CompoundTag compoundTag3;
            StructureFeature structureFeature = (StructureFeature)StructureFeature.f_67012_.get((Object)string.toLowerCase(Locale.ROOT));
            if (compoundTag3.m_128425_(string, 12) || structureFeature == null) continue;
            int \u00e2\u02dc\u01923 = 8;
            LongArrayList \u00e2\u02dc\u01924 = new LongArrayList();
            for (int i = \u00e2\u02dc\u01922.f_45578_ - 8; i <= \u00e2\u02dc\u01922.f_45578_ + 8; ++i) {
                for (\u00e2\u02dc\u0192 = \u00e2\u02dc\u01922.f_45579_ - 8; \u00e2\u02dc\u0192 <= \u00e2\u02dc\u01922.f_45579_ + 8; ++\u00e2\u02dc\u0192) {
                    if (!this.m_71314_(i, \u00e2\u02dc\u0192, string)) continue;
                    \u00e2\u02dc\u01924.add(ChunkPos.m_45589_(i, \u00e2\u02dc\u0192));
                }
            }
            compoundTag3.m_128428_(string, (List<Long>)\u00e2\u02dc\u01924);
        }
        compoundTag.m_128365_("References", compoundTag3);
        compoundTag2.m_128365_("Structures", compoundTag);
        p_71327_.m_128365_("Level", compoundTag2);
        return p_71327_;
    }

    private boolean m_71314_(int p_71315_, int p_71316_, String p_71317_) {
        if (!this.f_71301_) {
            return false;
        }
        return this.f_71302_.get(p_71317_) != null && this.f_71303_.get(f_71299_.get(p_71317_)).m_73369_(ChunkPos.m_45589_(p_71315_, p_71316_));
    }

    private boolean m_71311_(int p_71312_, int p_71313_) {
        if (!this.f_71301_) {
            return false;
        }
        for (String string : this.f_71305_) {
            if (this.f_71302_.get(string) == null || !this.f_71303_.get(f_71299_.get(string)).m_73373_(ChunkPos.m_45589_(p_71312_, p_71313_))) continue;
            return true;
        }
        return false;
    }

    private CompoundTag m_71328_(CompoundTag p_71329_, ChunkPos p_71330_) {
        CompoundTag compoundTag = p_71329_.m_128469_("Level");
        \u00e2\u02dc\u0192 = compoundTag.m_128469_("Structures");
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192.m_128469_("Starts");
        for (String string : this.f_71305_) {
            Long2ObjectMap<CompoundTag> long2ObjectMap = this.f_71302_.get(string);
            if (long2ObjectMap == null) continue;
            long \u00e2\u02dc\u01922 = p_71330_.m_45588_();
            if (!this.f_71303_.get(f_71299_.get(string)).m_73373_(\u00e2\u02dc\u01922) || (\u00e2\u02dc\u0192 = (CompoundTag)long2ObjectMap.get(\u00e2\u02dc\u01922)) == null) continue;
            \u00e2\u02dc\u0192.m_128365_(string, \u00e2\u02dc\u0192);
        }
        \u00e2\u02dc\u0192.m_128365_("Starts", \u00e2\u02dc\u0192);
        compoundTag.m_128365_("Structures", \u00e2\u02dc\u0192);
        p_71329_.m_128365_("Level", compoundTag);
        return p_71329_;
    }

    private void m_71320_(@Nullable DimensionDataStorage p_71321_) {
        if (p_71321_ == null) {
            return;
        }
        for (String string2 : this.f_71304_) {
            CompoundTag compoundTag = new CompoundTag();
            try {
                compoundTag = p_71321_.m_78158_(string2, 1493).m_128469_("data").m_128469_("Features");
                if (compoundTag.m_128456_()) {
                    continue;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            for (String string : compoundTag.m_128431_()) {
                String string3;
                CompoundTag object = compoundTag.m_128469_(string);
                long l = ChunkPos.m_45589_(object.m_128451_("ChunkX"), object.m_128451_("ChunkZ"));
                ListTag \u00e2\u02dc\u01922 = object.m_128437_("Children", 10);
                if (!\u00e2\u02dc\u01922.isEmpty() && (string3 = f_71300_.get(\u00e2\u02dc\u0192 = \u00e2\u02dc\u01922.m_128728_(0).m_128461_("id"))) != null) {
                    object.m_128359_("id", string3);
                }
                String \u00e2\u02dc\u01923 = object.m_128461_("id");
                this.f_71302_.computeIfAbsent(\u00e2\u02dc\u01923, p_71335_ -> new Long2ObjectOpenHashMap()).put(l, (Object)object);
            }
            String string3 = string2 + "_index";
            StructureFeatureIndexSavedData structureFeatureIndexSavedData = p_71321_.m_164861_(StructureFeatureIndexSavedData::m_163534_, StructureFeatureIndexSavedData::new, string3);
            if (structureFeatureIndexSavedData.m_73364_().isEmpty()) {
                StructureFeatureIndexSavedData structureFeatureIndexSavedData2 = new StructureFeatureIndexSavedData();
                this.f_71303_.put(string2, structureFeatureIndexSavedData2);
                for (String string4 : compoundTag.m_128431_()) {
                    CompoundTag compoundTag2 = compoundTag.m_128469_(string4);
                    structureFeatureIndexSavedData2.m_73365_(ChunkPos.m_45589_(compoundTag2.m_128451_("ChunkX"), compoundTag2.m_128451_("ChunkZ")));
                }
                structureFeatureIndexSavedData2.m_77762_();
                continue;
            }
            this.f_71303_.put(string2, structureFeatureIndexSavedData);
        }
    }

    public static LegacyStructureDataHandler m_71331_(ResourceKey<Level> p_71332_, @Nullable DimensionDataStorage p_71333_) {
        if (p_71332_ == Level.f_46428_) {
            return new LegacyStructureDataHandler(p_71333_, (List<String>)ImmutableList.of((Object)"Monument", (Object)"Stronghold", (Object)"Village", (Object)"Mineshaft", (Object)"Temple", (Object)"Mansion"), (List<String>)ImmutableList.of((Object)"Village", (Object)"Mineshaft", (Object)"Mansion", (Object)"Igloo", (Object)"Desert_Pyramid", (Object)"Jungle_Pyramid", (Object)"Swamp_Hut", (Object)"Stronghold", (Object)"Monument"));
        }
        if (p_71332_ == Level.f_46429_) {
            ImmutableList immutableList = ImmutableList.of((Object)"Fortress");
            return new LegacyStructureDataHandler(p_71333_, (List<String>)immutableList, (List<String>)immutableList);
        }
        if (p_71332_ == Level.f_46430_) {
            ImmutableList immutableList = ImmutableList.of((Object)"EndCity");
            return new LegacyStructureDataHandler(p_71333_, (List<String>)immutableList, (List<String>)immutableList);
        }
        throw new RuntimeException(String.format("Unknown dimension type : %s", p_71332_));
    }
}

