/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.Lists;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.MinecartChest;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.MineshaftFeature;
import net.minecraft.world.level.levelgen.feature.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MineShaftPieces {
    static final Logger f_162462_ = LogManager.getLogger();
    private static final int f_162463_ = 3;
    private static final int f_162464_ = 3;
    private static final int f_162465_ = 5;
    private static final int f_162466_ = 20;
    private static final int f_162467_ = 50;
    private static final int f_162468_ = 8;

    private static MineShaftPiece m_162480_(StructurePieceAccessor p_162481_, Random p_162482_, int p_162483_, int p_162484_, int p_162485_, @Nullable Direction p_162486_, int p_162487_, MineshaftFeature.Type p_162488_) {
        int n = p_162482_.nextInt(100);
        if (n >= 80) {
            BoundingBox boundingBox = MineShaftCrossing.m_162563_(p_162481_, p_162482_, p_162483_, p_162484_, p_162485_, p_162486_);
            if (boundingBox != null) {
                return new MineShaftCrossing(p_162487_, boundingBox, p_162486_, p_162488_);
            }
        } else if (n >= 70) {
            BoundingBox boundingBox = MineShaftStairs.m_162614_(p_162481_, p_162482_, p_162483_, p_162484_, p_162485_, p_162486_);
            if (boundingBox != null) {
                return new MineShaftStairs(p_162487_, boundingBox, p_162486_, p_162488_);
            }
        } else {
            BoundingBox boundingBox = MineShaftCorridor.m_162537_(p_162481_, p_162482_, p_162483_, p_162484_, p_162485_, p_162486_);
            if (boundingBox != null) {
                return new MineShaftCorridor(p_162487_, p_162482_, boundingBox, p_162486_, p_162488_);
            }
        }
        return null;
    }

    static MineShaftPiece m_162471_(StructurePiece p_162472_, StructurePieceAccessor p_162473_, Random p_162474_, int p_162475_, int p_162476_, int p_162477_, Direction p_162478_, int p_162479_) {
        if (p_162479_ > 8) {
            return null;
        }
        if (Math.abs(p_162475_ - p_162472_.m_73547_().m_162395_()) > 80 || Math.abs(p_162477_ - p_162472_.m_73547_().m_162398_()) > 80) {
            return null;
        }
        MineshaftFeature.Type type = ((MineShaftPiece)p_162472_).f_71465_;
        MineShaftPiece \u00e2\u02dc\u01922 = MineShaftPieces.m_162480_(p_162473_, p_162474_, p_162475_, p_162476_, p_162477_, p_162478_, p_162479_ + 1, type);
        if (\u00e2\u02dc\u01922 != null) {
            p_162473_.m_142679_(\u00e2\u02dc\u01922);
            \u00e2\u02dc\u01922.m_142537_(p_162472_, p_162473_, p_162474_);
        }
        return \u00e2\u02dc\u01922;
    }

    public static class MineShaftCrossing
    extends MineShaftPiece {
        private final Direction f_71427_;
        private final boolean f_71428_;

        public MineShaftCrossing(ServerLevel p_162554_, CompoundTag p_162555_) {
            super(StructurePieceType.f_67137_, p_162555_);
            this.f_71428_ = p_162555_.m_128471_("tf");
            this.f_71427_ = Direction.m_122407_(p_162555_.m_128451_("D"));
        }

        @Override
        protected void m_142347_(ServerLevel p_162557_, CompoundTag p_162558_) {
            super.m_142347_(p_162557_, p_162558_);
            p_162558_.m_128379_("tf", this.f_71428_);
            p_162558_.m_128405_("D", this.f_71427_.m_122416_());
        }

        public MineShaftCrossing(int p_71430_, BoundingBox p_71431_, @Nullable Direction p_71432_, MineshaftFeature.Type p_71433_) {
            super(StructurePieceType.f_67137_, p_71430_, p_71433_, p_71431_);
            this.f_71427_ = p_71432_;
            this.f_71428_ = p_71431_.m_71057_() > 3;
        }

        @Nullable
        public static BoundingBox m_162563_(StructurePieceAccessor p_162564_, Random p_162565_, int p_162566_, int p_162567_, int p_162568_, Direction p_162569_) {
            int n = p_162565_.nextInt(4) == 0 ? 6 : 2;
            BoundingBox \u00e2\u02dc\u01922 = switch (p_162569_) {
                default -> new BoundingBox(-1, 0, -4, 3, n, 0);
                case Direction.SOUTH -> new BoundingBox(-1, 0, 0, 3, n, 4);
                case Direction.WEST -> new BoundingBox(-4, 0, -1, 0, n, 3);
                case Direction.EAST -> new BoundingBox(0, 0, -1, 4, n, 3);
            };
            \u00e2\u02dc\u01922.m_162367_(p_162566_, p_162567_, p_162568_);
            if (p_162564_.m_141921_(\u00e2\u02dc\u01922) != null) {
                return null;
            }
            return \u00e2\u02dc\u01922;
        }

        @Override
        public void m_142537_(StructurePiece p_162560_, StructurePieceAccessor p_162561_, Random p_162562_) {
            int n = this.m_73548_();
            switch (this.f_71427_) {
                default: {
                    MineShaftPieces.m_162471_(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() - 1, Direction.NORTH, n);
                    MineShaftPieces.m_162471_(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() + 1, Direction.WEST, n);
                    MineShaftPieces.m_162471_(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() + 1, Direction.EAST, n);
                    break;
                }
                case SOUTH: {
                    MineShaftPieces.m_162471_(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162401_() + 1, Direction.SOUTH, n);
                    MineShaftPieces.m_162471_(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() + 1, Direction.WEST, n);
                    MineShaftPieces.m_162471_(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() + 1, Direction.EAST, n);
                    break;
                }
                case WEST: {
                    MineShaftPieces.m_162471_(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() - 1, Direction.NORTH, n);
                    MineShaftPieces.m_162471_(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162401_() + 1, Direction.SOUTH, n);
                    MineShaftPieces.m_162471_(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() + 1, Direction.WEST, n);
                    break;
                }
                case EAST: {
                    MineShaftPieces.m_162471_(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() - 1, Direction.NORTH, n);
                    MineShaftPieces.m_162471_(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162401_() + 1, Direction.SOUTH, n);
                    MineShaftPieces.m_162471_(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() + 1, Direction.EAST, n);
                }
            }
            if (this.f_71428_) {
                if (p_162562_.nextBoolean()) {
                    MineShaftPieces.m_162471_(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_() + 3 + 1, this.f_73383_.m_162398_() - 1, Direction.NORTH, n);
                }
                if (p_162562_.nextBoolean()) {
                    MineShaftPieces.m_162471_(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_() + 3 + 1, this.f_73383_.m_162398_() + 1, Direction.WEST, n);
                }
                if (p_162562_.nextBoolean()) {
                    MineShaftPieces.m_162471_(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_() + 3 + 1, this.f_73383_.m_162398_() + 1, Direction.EAST, n);
                }
                if (p_162562_.nextBoolean()) {
                    MineShaftPieces.m_162471_(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_() + 3 + 1, this.f_73383_.m_162401_() + 1, Direction.SOUTH, n);
                }
            }
        }

        @Override
        public boolean m_7832_(WorldGenLevel p_71438_, StructureFeatureManager p_71439_, ChunkGenerator p_71440_, Random p_71441_, BoundingBox p_71442_, ChunkPos p_71443_, BlockPos p_71444_) {
            if (this.m_162578_(p_71438_, p_71442_)) {
                return false;
            }
            BlockState blockState = this.f_71465_.m_160062_();
            if (this.f_71428_) {
                this.m_73441_(p_71438_, p_71442_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_(), this.f_73383_.m_162399_() - 1, this.f_73383_.m_162396_() + 3 - 1, this.f_73383_.m_162401_(), f_73382_, f_73382_, false);
                this.m_73441_(p_71438_, p_71442_, this.f_73383_.m_162395_(), this.f_73383_.m_162396_(), this.f_73383_.m_162398_() + 1, this.f_73383_.m_162399_(), this.f_73383_.m_162396_() + 3 - 1, this.f_73383_.m_162401_() - 1, f_73382_, f_73382_, false);
                this.m_73441_(p_71438_, p_71442_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162400_() - 2, this.f_73383_.m_162398_(), this.f_73383_.m_162399_() - 1, this.f_73383_.m_162400_(), this.f_73383_.m_162401_(), f_73382_, f_73382_, false);
                this.m_73441_(p_71438_, p_71442_, this.f_73383_.m_162395_(), this.f_73383_.m_162400_() - 2, this.f_73383_.m_162398_() + 1, this.f_73383_.m_162399_(), this.f_73383_.m_162400_(), this.f_73383_.m_162401_() - 1, f_73382_, f_73382_, false);
                this.m_73441_(p_71438_, p_71442_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_() + 3, this.f_73383_.m_162398_() + 1, this.f_73383_.m_162399_() - 1, this.f_73383_.m_162396_() + 3, this.f_73383_.m_162401_() - 1, f_73382_, f_73382_, false);
            } else {
                this.m_73441_(p_71438_, p_71442_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_(), this.f_73383_.m_162399_() - 1, this.f_73383_.m_162400_(), this.f_73383_.m_162401_(), f_73382_, f_73382_, false);
                this.m_73441_(p_71438_, p_71442_, this.f_73383_.m_162395_(), this.f_73383_.m_162396_(), this.f_73383_.m_162398_() + 1, this.f_73383_.m_162399_(), this.f_73383_.m_162400_(), this.f_73383_.m_162401_() - 1, f_73382_, f_73382_, false);
            }
            this.m_71445_(p_71438_, p_71442_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() + 1, this.f_73383_.m_162400_());
            this.m_71445_(p_71438_, p_71442_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162401_() - 1, this.f_73383_.m_162400_());
            this.m_71445_(p_71438_, p_71442_, this.f_73383_.m_162399_() - 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() + 1, this.f_73383_.m_162400_());
            this.m_71445_(p_71438_, p_71442_, this.f_73383_.m_162399_() - 1, this.f_73383_.m_162396_(), this.f_73383_.m_162401_() - 1, this.f_73383_.m_162400_());
            int \u00e2\u02dc\u01922 = this.f_73383_.m_162396_() - 1;
            for (int i = this.f_73383_.m_162395_(); i <= this.f_73383_.m_162399_(); ++i) {
                for (\u00e2\u02dc\u0192 = this.f_73383_.m_162398_(); \u00e2\u02dc\u0192 <= this.f_73383_.m_162401_(); ++\u00e2\u02dc\u0192) {
                    this.m_162587_(p_71438_, p_71442_, blockState, i, \u00e2\u02dc\u01922, \u00e2\u02dc\u0192);
                }
            }
            return true;
        }

        private void m_71445_(WorldGenLevel p_71446_, BoundingBox p_71447_, int p_71448_, int p_71449_, int p_71450_, int p_71451_) {
            if (!this.m_73398_(p_71446_, p_71448_, p_71451_ + 1, p_71450_, p_71447_).m_60795_()) {
                this.m_73441_(p_71446_, p_71447_, p_71448_, p_71449_, p_71450_, p_71448_, p_71451_, p_71450_, this.f_71465_.m_160062_(), f_73382_, false);
            }
        }
    }

    public static class MineShaftStairs
    extends MineShaftPiece {
        public MineShaftStairs(int p_71513_, BoundingBox p_71514_, Direction p_71515_, MineshaftFeature.Type p_71516_) {
            super(StructurePieceType.f_67139_, p_71513_, p_71516_, p_71514_);
            this.m_73519_(p_71515_);
        }

        public MineShaftStairs(ServerLevel p_162608_, CompoundTag p_162609_) {
            super(StructurePieceType.f_67139_, p_162609_);
        }

        @Nullable
        public static BoundingBox m_162614_(StructurePieceAccessor p_162615_, Random p_162616_, int p_162617_, int p_162618_, int p_162619_, Direction p_162620_) {
            BoundingBox boundingBox = switch (p_162620_) {
                default -> new BoundingBox(0, -5, -8, 2, 2, 0);
                case Direction.SOUTH -> new BoundingBox(0, -5, 0, 2, 2, 8);
                case Direction.WEST -> new BoundingBox(-8, -5, 0, 0, 2, 2);
                case Direction.EAST -> new BoundingBox(0, -5, 0, 8, 2, 2);
            };
            boundingBox.m_162367_(p_162617_, p_162618_, p_162619_);
            if (p_162615_.m_141921_(boundingBox) != null) {
                return null;
            }
            return boundingBox;
        }

        @Override
        public void m_142537_(StructurePiece p_162611_, StructurePieceAccessor p_162612_, Random p_162613_) {
            int n = this.m_73548_();
            Direction \u00e2\u02dc\u01922 = this.m_73549_();
            if (\u00e2\u02dc\u01922 != null) {
                switch (\u00e2\u02dc\u01922) {
                    default: {
                        MineShaftPieces.m_162471_(p_162611_, p_162612_, p_162613_, this.f_73383_.m_162395_(), this.f_73383_.m_162396_(), this.f_73383_.m_162398_() - 1, Direction.NORTH, n);
                        break;
                    }
                    case SOUTH: {
                        MineShaftPieces.m_162471_(p_162611_, p_162612_, p_162613_, this.f_73383_.m_162395_(), this.f_73383_.m_162396_(), this.f_73383_.m_162401_() + 1, Direction.SOUTH, n);
                        break;
                    }
                    case WEST: {
                        MineShaftPieces.m_162471_(p_162611_, p_162612_, p_162613_, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_(), Direction.WEST, n);
                        break;
                    }
                    case EAST: {
                        MineShaftPieces.m_162471_(p_162611_, p_162612_, p_162613_, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_(), Direction.EAST, n);
                    }
                }
            }
        }

        @Override
        public boolean m_7832_(WorldGenLevel p_71521_, StructureFeatureManager p_71522_, ChunkGenerator p_71523_, Random p_71524_, BoundingBox p_71525_, ChunkPos p_71526_, BlockPos p_71527_) {
            if (this.m_162578_(p_71521_, p_71525_)) {
                return false;
            }
            this.m_73441_(p_71521_, p_71525_, 0, 5, 0, 2, 7, 1, f_73382_, f_73382_, false);
            this.m_73441_(p_71521_, p_71525_, 0, 0, 7, 2, 2, 8, f_73382_, f_73382_, false);
            for (int i = 0; i < 5; ++i) {
                this.m_73441_(p_71521_, p_71525_, 0, 5 - i - (i < 4 ? 1 : 0), 2 + i, 2, 7 - i, 2 + i, f_73382_, f_73382_, false);
            }
            return true;
        }
    }

    public static class MineShaftCorridor
    extends MineShaftPiece {
        private final boolean f_71368_;
        private final boolean f_71369_;
        private boolean f_71370_;
        private final int f_71371_;

        public MineShaftCorridor(ServerLevel p_162490_, CompoundTag p_162491_) {
            super(StructurePieceType.f_67132_, p_162491_);
            this.f_71368_ = p_162491_.m_128471_("hr");
            this.f_71369_ = p_162491_.m_128471_("sc");
            this.f_71370_ = p_162491_.m_128471_("hps");
            this.f_71371_ = p_162491_.m_128451_("Num");
        }

        @Override
        protected void m_142347_(ServerLevel p_162493_, CompoundTag p_162494_) {
            super.m_142347_(p_162493_, p_162494_);
            p_162494_.m_128379_("hr", this.f_71368_);
            p_162494_.m_128379_("sc", this.f_71369_);
            p_162494_.m_128379_("hps", this.f_71370_);
            p_162494_.m_128405_("Num", this.f_71371_);
        }

        public MineShaftCorridor(int p_71373_, Random p_71374_, BoundingBox p_71375_, Direction p_71376_, MineshaftFeature.Type p_71377_) {
            super(StructurePieceType.f_67132_, p_71373_, p_71377_, p_71375_);
            this.m_73519_(p_71376_);
            this.f_71368_ = p_71374_.nextInt(3) == 0;
            this.f_71369_ = !this.f_71368_ && p_71374_.nextInt(23) == 0;
            this.f_71371_ = this.m_73549_().m_122434_() == Direction.Axis.Z ? p_71375_.m_71058_() / 5 : p_71375_.m_71056_() / 5;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public static BoundingBox m_162537_(StructurePieceAccessor p_162538_, Random p_162539_, int p_162540_, int p_162541_, int p_162542_, Direction p_162543_) {
            for (int i = p_162539_.nextInt(3) + 2; i > 0; --i) {
                BoundingBox \u00e2\u02dc\u01923;
                n = i * 5;
                switch (p_162543_) {
                    default: {
                        BoundingBox \u00e2\u02dc\u01924 = new BoundingBox(0, 0, -(n - 1), 2, 2, 0);
                        break;
                    }
                    case SOUTH: {
                        int n;
                        BoundingBox \u00e2\u02dc\u01922 = new BoundingBox(0, 0, 0, 2, 2, n - 1);
                        break;
                    }
                    case WEST: {
                        int n;
                        BoundingBox \u00e2\u02dc\u01924 = new BoundingBox(-(n - 1), 0, 0, 0, 2, 2);
                        break;
                    }
                    case EAST: {
                        \u00e2\u02dc\u01923 = new BoundingBox(0, 0, 0, n - 1, 2, 2);
                    }
                }
                \u00e2\u02dc\u01923.m_162367_(p_162540_, p_162541_, p_162542_);
                if (p_162538_.m_141921_(\u00e2\u02dc\u01923) == null) return \u00e2\u02dc\u01923;
            }
            return null;
        }

        @Override
        public void m_142537_(StructurePiece p_162534_, StructurePieceAccessor p_162535_, Random p_162536_) {
            block24: {
                int n = this.m_73548_();
                \u00e2\u02dc\u0192 = p_162536_.nextInt(4);
                Direction \u00e2\u02dc\u01922 = this.m_73549_();
                if (\u00e2\u02dc\u01922 != null) {
                    switch (\u00e2\u02dc\u01922) {
                        default: {
                            if (\u00e2\u02dc\u0192 <= 1) {
                                MineShaftPieces.m_162471_(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162395_(), this.f_73383_.m_162396_() - 1 + p_162536_.nextInt(3), this.f_73383_.m_162398_() - 1, \u00e2\u02dc\u01922, n);
                                break;
                            }
                            if (\u00e2\u02dc\u0192 == 2) {
                                MineShaftPieces.m_162471_(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_() - 1 + p_162536_.nextInt(3), this.f_73383_.m_162398_(), Direction.WEST, n);
                                break;
                            }
                            MineShaftPieces.m_162471_(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_() - 1 + p_162536_.nextInt(3), this.f_73383_.m_162398_(), Direction.EAST, n);
                            break;
                        }
                        case SOUTH: {
                            if (\u00e2\u02dc\u0192 <= 1) {
                                MineShaftPieces.m_162471_(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162395_(), this.f_73383_.m_162396_() - 1 + p_162536_.nextInt(3), this.f_73383_.m_162401_() + 1, \u00e2\u02dc\u01922, n);
                                break;
                            }
                            if (\u00e2\u02dc\u0192 == 2) {
                                MineShaftPieces.m_162471_(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_() - 1 + p_162536_.nextInt(3), this.f_73383_.m_162401_() - 3, Direction.WEST, n);
                                break;
                            }
                            MineShaftPieces.m_162471_(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_() - 1 + p_162536_.nextInt(3), this.f_73383_.m_162401_() - 3, Direction.EAST, n);
                            break;
                        }
                        case WEST: {
                            if (\u00e2\u02dc\u0192 <= 1) {
                                MineShaftPieces.m_162471_(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_() - 1 + p_162536_.nextInt(3), this.f_73383_.m_162398_(), \u00e2\u02dc\u01922, n);
                                break;
                            }
                            if (\u00e2\u02dc\u0192 == 2) {
                                MineShaftPieces.m_162471_(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162395_(), this.f_73383_.m_162396_() - 1 + p_162536_.nextInt(3), this.f_73383_.m_162398_() - 1, Direction.NORTH, n);
                                break;
                            }
                            MineShaftPieces.m_162471_(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162395_(), this.f_73383_.m_162396_() - 1 + p_162536_.nextInt(3), this.f_73383_.m_162401_() + 1, Direction.SOUTH, n);
                            break;
                        }
                        case EAST: {
                            if (\u00e2\u02dc\u0192 <= 1) {
                                MineShaftPieces.m_162471_(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_() - 1 + p_162536_.nextInt(3), this.f_73383_.m_162398_(), \u00e2\u02dc\u01922, n);
                                break;
                            }
                            if (\u00e2\u02dc\u0192 == 2) {
                                MineShaftPieces.m_162471_(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162399_() - 3, this.f_73383_.m_162396_() - 1 + p_162536_.nextInt(3), this.f_73383_.m_162398_() - 1, Direction.NORTH, n);
                                break;
                            }
                            MineShaftPieces.m_162471_(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162399_() - 3, this.f_73383_.m_162396_() - 1 + p_162536_.nextInt(3), this.f_73383_.m_162401_() + 1, Direction.SOUTH, n);
                        }
                    }
                }
                if (n >= 8) break block24;
                if (\u00e2\u02dc\u01922 == Direction.NORTH || \u00e2\u02dc\u01922 == Direction.SOUTH) {
                    \u00e2\u02dc\u0192 = this.f_73383_.m_162398_() + 3;
                    while (\u00e2\u02dc\u0192 + 3 <= this.f_73383_.m_162401_()) {
                        \u00e2\u02dc\u0192 = p_162536_.nextInt(5);
                        if (\u00e2\u02dc\u0192 == 0) {
                            MineShaftPieces.m_162471_(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_(), \u00e2\u02dc\u0192, Direction.WEST, n + 1);
                        } else if (\u00e2\u02dc\u0192 == 1) {
                            MineShaftPieces.m_162471_(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_(), \u00e2\u02dc\u0192, Direction.EAST, n + 1);
                        }
                        \u00e2\u02dc\u0192 += 5;
                    }
                } else {
                    \u00e2\u02dc\u0192 = this.f_73383_.m_162395_() + 3;
                    while (\u00e2\u02dc\u0192 + 3 <= this.f_73383_.m_162399_()) {
                        \u00e2\u02dc\u0192 = p_162536_.nextInt(5);
                        if (\u00e2\u02dc\u0192 == 0) {
                            MineShaftPieces.m_162471_(p_162534_, p_162535_, p_162536_, \u00e2\u02dc\u0192, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() - 1, Direction.NORTH, n + 1);
                        } else if (\u00e2\u02dc\u0192 == 1) {
                            MineShaftPieces.m_162471_(p_162534_, p_162535_, p_162536_, \u00e2\u02dc\u0192, this.f_73383_.m_162396_(), this.f_73383_.m_162401_() + 1, Direction.SOUTH, n + 1);
                        }
                        \u00e2\u02dc\u0192 += 5;
                    }
                }
            }
        }

        @Override
        protected boolean m_5606_(WorldGenLevel p_71407_, BoundingBox p_71408_, Random p_71409_, int p_71410_, int p_71411_, int p_71412_, ResourceLocation p_71413_) {
            BlockPos.MutableBlockPos mutableBlockPos = this.m_163582_(p_71410_, p_71411_, p_71412_);
            if (p_71408_.m_71051_(mutableBlockPos) && p_71407_.m_8055_(mutableBlockPos).m_60795_() && !p_71407_.m_8055_(((BlockPos)mutableBlockPos).m_7495_()).m_60795_()) {
                BlockState blockState = (BlockState)Blocks.f_50156_.m_49966_().m_61124_(RailBlock.f_55392_, p_71409_.nextBoolean() ? RailShape.NORTH_SOUTH : RailShape.EAST_WEST);
                this.m_73434_(p_71407_, blockState, p_71410_, p_71411_, p_71412_, p_71408_);
                MinecartChest \u00e2\u02dc\u01922 = new MinecartChest(p_71407_.m_6018_(), (double)mutableBlockPos.m_123341_() + 0.5, (double)mutableBlockPos.m_123342_() + 0.5, (double)mutableBlockPos.m_123343_() + 0.5);
                \u00e2\u02dc\u01922.m_38236_(p_71413_, p_71409_.nextLong());
                p_71407_.m_7967_(\u00e2\u02dc\u01922);
                return true;
            }
            return false;
        }

        @Override
        public boolean m_7832_(WorldGenLevel p_71382_, StructureFeatureManager p_71383_, ChunkGenerator p_71384_, Random p_71385_, BoundingBox p_71386_, ChunkPos p_71387_, BlockPos p_71388_) {
            int n;
            if (this.m_162578_(p_71382_, p_71386_)) {
                return false;
            }
            boolean bl = false;
            int \u00e2\u02dc\u01922 = 2;
            \u00e2\u02dc\u0192 = false;
            int \u00e2\u02dc\u01923 = 2;
            int \u00e2\u02dc\u01924 = this.f_71371_ * 5 - 1;
            BlockState \u00e2\u02dc\u01925 = this.f_71465_.m_160062_();
            this.m_73441_(p_71382_, p_71386_, 0, 0, 0, 2, 1, \u00e2\u02dc\u01924, f_73382_, f_73382_, false);
            this.m_73476_(p_71382_, p_71386_, p_71385_, 0.8f, 0, 2, 0, 2, 2, \u00e2\u02dc\u01924, f_73382_, f_73382_, false, false);
            if (this.f_71369_) {
                this.m_73476_(p_71382_, p_71386_, p_71385_, 0.6f, 0, 0, 0, 2, 1, \u00e2\u02dc\u01924, Blocks.f_50033_.m_49966_(), f_73382_, false, true);
            }
            for (n = 0; n < this.f_71371_; ++n) {
                \u00e2\u02dc\u0192 = 2 + n * 5;
                this.m_71389_(p_71382_, p_71386_, 0, 0, \u00e2\u02dc\u0192, 2, 2, p_71385_);
                this.m_162525_(p_71382_, p_71386_, p_71385_, 0.1f, 0, 2, \u00e2\u02dc\u0192 - 1);
                this.m_162525_(p_71382_, p_71386_, p_71385_, 0.1f, 2, 2, \u00e2\u02dc\u0192 - 1);
                this.m_162525_(p_71382_, p_71386_, p_71385_, 0.1f, 0, 2, \u00e2\u02dc\u0192 + 1);
                this.m_162525_(p_71382_, p_71386_, p_71385_, 0.1f, 2, 2, \u00e2\u02dc\u0192 + 1);
                this.m_162525_(p_71382_, p_71386_, p_71385_, 0.05f, 0, 2, \u00e2\u02dc\u0192 - 2);
                this.m_162525_(p_71382_, p_71386_, p_71385_, 0.05f, 2, 2, \u00e2\u02dc\u0192 - 2);
                this.m_162525_(p_71382_, p_71386_, p_71385_, 0.05f, 0, 2, \u00e2\u02dc\u0192 + 2);
                this.m_162525_(p_71382_, p_71386_, p_71385_, 0.05f, 2, 2, \u00e2\u02dc\u0192 + 2);
                if (p_71385_.nextInt(100) == 0) {
                    this.m_5606_(p_71382_, p_71386_, p_71385_, 2, 0, \u00e2\u02dc\u0192 - 1, BuiltInLootTables.f_78759_);
                }
                if (p_71385_.nextInt(100) == 0) {
                    this.m_5606_(p_71382_, p_71386_, p_71385_, 0, 0, \u00e2\u02dc\u0192 + 1, BuiltInLootTables.f_78759_);
                }
                if (!this.f_71369_ || this.f_71370_) continue;
                i = 1;
                \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 - 1 + p_71385_.nextInt(3);
                BlockPos.MutableBlockPos mutableBlockPos = this.m_163582_(1, 0, \u00e2\u02dc\u0192);
                if (!p_71386_.m_71051_(mutableBlockPos) || !this.m_73414_(p_71382_, 1, 0, \u00e2\u02dc\u0192, p_71386_)) continue;
                this.f_71370_ = true;
                p_71382_.m_7731_(mutableBlockPos, Blocks.f_50085_.m_49966_(), 2);
                BlockEntity \u00e2\u02dc\u01926 = p_71382_.m_7702_(mutableBlockPos);
                if (!(\u00e2\u02dc\u01926 instanceof SpawnerBlockEntity)) continue;
                ((SpawnerBlockEntity)\u00e2\u02dc\u01926).m_59801_().m_45462_(EntityType.f_20554_);
            }
            for (n = 0; n <= 2; ++n) {
                for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 <= \u00e2\u02dc\u01924; ++\u00e2\u02dc\u0192) {
                    this.m_162587_(p_71382_, p_71386_, \u00e2\u02dc\u01925, n, -1, \u00e2\u02dc\u0192);
                }
            }
            n = 2;
            this.m_162512_(p_71382_, p_71386_, 0, -1, 2);
            if (this.f_71371_ > 1) {
                \u00e2\u02dc\u0192 = \u00e2\u02dc\u01924 - 2;
                this.m_162512_(p_71382_, p_71386_, 0, -1, \u00e2\u02dc\u0192);
            }
            if (this.f_71368_) {
                BlockState blockState = (BlockState)Blocks.f_50156_.m_49966_().m_61124_(RailBlock.f_55392_, RailShape.NORTH_SOUTH);
                for (int i = 0; i <= \u00e2\u02dc\u01924; ++i) {
                    BlockState blockState2 = this.m_73398_(p_71382_, 1, -1, i, p_71386_);
                    if (blockState2.m_60795_() || !blockState2.m_60804_(p_71382_, this.m_163582_(1, -1, i))) continue;
                    float \u00e2\u02dc\u01927 = this.m_73414_(p_71382_, 1, 0, i, p_71386_) ? 0.7f : 0.9f;
                    this.m_73491_(p_71382_, p_71386_, p_71385_, \u00e2\u02dc\u01927, 1, 0, i, blockState);
                }
            }
            return true;
        }

        private void m_162512_(WorldGenLevel p_162513_, BoundingBox p_162514_, int p_162515_, int p_162516_, int p_162517_) {
            BlockState blockState = this.f_71465_.m_160061_();
            \u00e2\u02dc\u0192 = this.f_71465_.m_160062_();
            if (this.m_73398_(p_162513_, p_162515_, p_162516_, p_162517_, p_162514_).m_60713_(\u00e2\u02dc\u0192.m_60734_())) {
                this.m_162544_(p_162513_, blockState, p_162515_, p_162516_, p_162517_, p_162514_);
            }
            if (this.m_73398_(p_162513_, p_162515_ + 2, p_162516_, p_162517_, p_162514_).m_60713_(\u00e2\u02dc\u0192.m_60734_())) {
                this.m_162544_(p_162513_, blockState, p_162515_ + 2, p_162516_, p_162517_, p_162514_);
            }
        }

        @Override
        protected void m_73528_(WorldGenLevel p_162500_, BlockState p_162501_, int p_162502_, int p_162503_, int p_162504_, BoundingBox p_162505_) {
            BlockPos.MutableBlockPos mutableBlockPos = this.m_163582_(p_162502_, p_162503_, p_162504_);
            if (!p_162505_.m_71051_(mutableBlockPos)) {
                return;
            }
            int \u00e2\u02dc\u01922 = mutableBlockPos.m_123342_();
            while (this.m_163572_(p_162500_.m_8055_(mutableBlockPos)) && mutableBlockPos.m_123342_() > p_162500_.m_141937_() + 1) {
                mutableBlockPos.m_122173_(Direction.DOWN);
            }
            if (!this.m_162551_(p_162500_.m_8055_(mutableBlockPos))) {
                return;
            }
            while (mutableBlockPos.m_123342_() < \u00e2\u02dc\u01922) {
                mutableBlockPos.m_122173_(Direction.UP);
                p_162500_.m_7731_(mutableBlockPos, p_162501_, 2);
            }
        }

        protected void m_162544_(WorldGenLevel p_162545_, BlockState p_162546_, int p_162547_, int p_162548_, int p_162549_, BoundingBox p_162550_) {
            BlockPos.MutableBlockPos mutableBlockPos = this.m_163582_(p_162547_, p_162548_, p_162549_);
            if (!p_162550_.m_71051_(mutableBlockPos)) {
                return;
            }
            int \u00e2\u02dc\u01922 = mutableBlockPos.m_123342_();
            int \u00e2\u02dc\u01923 = 1;
            boolean \u00e2\u02dc\u01924 = true;
            boolean \u00e2\u02dc\u01925 = true;
            while (\u00e2\u02dc\u01924 || \u00e2\u02dc\u01925) {
                BlockState \u00e2\u02dc\u01926;
                if (\u00e2\u02dc\u01924) {
                    mutableBlockPos.m_142448_(\u00e2\u02dc\u01922 - \u00e2\u02dc\u01923);
                    \u00e2\u02dc\u01926 = p_162545_.m_8055_(mutableBlockPos);
                    boolean bl = \u00e2\u02dc\u01927 = this.m_163572_(\u00e2\u02dc\u01926) && !\u00e2\u02dc\u01926.m_60713_(Blocks.f_49991_);
                    if (!\u00e2\u02dc\u01927 && this.m_162551_(\u00e2\u02dc\u01926)) {
                        MineShaftCorridor.m_162506_(p_162545_, p_162546_, mutableBlockPos, \u00e2\u02dc\u01922 - \u00e2\u02dc\u01923 + 1, \u00e2\u02dc\u01922);
                        return;
                    }
                    boolean bl2 = \u00e2\u02dc\u01924 = \u00e2\u02dc\u01923 <= 20 && \u00e2\u02dc\u01927 && mutableBlockPos.m_123342_() > p_162545_.m_141937_() + 1;
                }
                if (\u00e2\u02dc\u01925) {
                    mutableBlockPos.m_142448_(\u00e2\u02dc\u01922 + \u00e2\u02dc\u01923);
                    \u00e2\u02dc\u01926 = p_162545_.m_8055_(mutableBlockPos);
                    boolean \u00e2\u02dc\u01927 = this.m_163572_(\u00e2\u02dc\u01926);
                    if (!\u00e2\u02dc\u01927 && this.m_162495_(p_162545_, mutableBlockPos, \u00e2\u02dc\u01926)) {
                        p_162545_.m_7731_(mutableBlockPos.m_142448_(\u00e2\u02dc\u01922 + 1), this.f_71465_.m_160063_(), 2);
                        MineShaftCorridor.m_162506_(p_162545_, Blocks.f_50184_.m_49966_(), mutableBlockPos, \u00e2\u02dc\u01922 + 2, \u00e2\u02dc\u01922 + \u00e2\u02dc\u01923);
                        return;
                    }
                    \u00e2\u02dc\u01925 = \u00e2\u02dc\u01923 <= 50 && \u00e2\u02dc\u01927 && mutableBlockPos.m_123342_() < p_162545_.m_151558_() - 1;
                }
                ++\u00e2\u02dc\u01923;
            }
        }

        private static void m_162506_(WorldGenLevel p_162507_, BlockState p_162508_, BlockPos.MutableBlockPos p_162509_, int p_162510_, int p_162511_) {
            for (int i = p_162510_; i < p_162511_; ++i) {
                p_162507_.m_7731_(p_162509_.m_142448_(i), p_162508_, 2);
            }
        }

        private boolean m_162551_(BlockState p_162552_) {
            return !p_162552_.m_60713_(Blocks.f_50156_) && !p_162552_.m_60713_(Blocks.f_49991_);
        }

        private boolean m_162495_(LevelReader p_162496_, BlockPos p_162497_, BlockState p_162498_) {
            return Block.m_49863_(p_162496_, p_162497_, Direction.DOWN) && !(p_162498_.m_60734_() instanceof FallingBlock);
        }

        private void m_71389_(WorldGenLevel p_71390_, BoundingBox p_71391_, int p_71392_, int p_71393_, int p_71394_, int p_71395_, int p_71396_, Random p_71397_) {
            if (!this.m_71474_(p_71390_, p_71391_, p_71392_, p_71396_, p_71395_, p_71394_)) {
                return;
            }
            BlockState blockState = this.f_71465_.m_160062_();
            \u00e2\u02dc\u0192 = this.f_71465_.m_160063_();
            this.m_73441_(p_71390_, p_71391_, p_71392_, p_71393_, p_71394_, p_71392_, p_71395_ - 1, p_71394_, (BlockState)\u00e2\u02dc\u0192.m_61124_(FenceBlock.f_52312_, true), f_73382_, false);
            this.m_73441_(p_71390_, p_71391_, p_71396_, p_71393_, p_71394_, p_71396_, p_71395_ - 1, p_71394_, (BlockState)\u00e2\u02dc\u0192.m_61124_(FenceBlock.f_52310_, true), f_73382_, false);
            if (p_71397_.nextInt(4) == 0) {
                this.m_73441_(p_71390_, p_71391_, p_71392_, p_71395_, p_71394_, p_71392_, p_71395_, p_71394_, blockState, f_73382_, false);
                this.m_73441_(p_71390_, p_71391_, p_71396_, p_71395_, p_71394_, p_71396_, p_71395_, p_71394_, blockState, f_73382_, false);
            } else {
                this.m_73441_(p_71390_, p_71391_, p_71392_, p_71395_, p_71394_, p_71396_, p_71395_, p_71394_, blockState, f_73382_, false);
                this.m_73491_(p_71390_, p_71391_, p_71397_, 0.05f, p_71392_ + 1, p_71395_, p_71394_ - 1, (BlockState)Blocks.f_50082_.m_49966_().m_61124_(WallTorchBlock.f_58119_, Direction.NORTH));
                this.m_73491_(p_71390_, p_71391_, p_71397_, 0.05f, p_71392_ + 1, p_71395_, p_71394_ + 1, (BlockState)Blocks.f_50082_.m_49966_().m_61124_(WallTorchBlock.f_58119_, Direction.SOUTH));
            }
        }

        private void m_162525_(WorldGenLevel p_162526_, BoundingBox p_162527_, Random p_162528_, float p_162529_, int p_162530_, int p_162531_, int p_162532_) {
            if (this.m_73414_(p_162526_, p_162530_, p_162531_, p_162532_, p_162527_) && p_162528_.nextFloat() < p_162529_ && this.m_162518_(p_162526_, p_162527_, p_162530_, p_162531_, p_162532_, 2)) {
                this.m_73434_(p_162526_, Blocks.f_50033_.m_49966_(), p_162530_, p_162531_, p_162532_, p_162527_);
            }
        }

        private boolean m_162518_(WorldGenLevel p_162519_, BoundingBox p_162520_, int p_162521_, int p_162522_, int p_162523_, int p_162524_) {
            BlockPos.MutableBlockPos mutableBlockPos = this.m_163582_(p_162521_, p_162522_, p_162523_);
            int \u00e2\u02dc\u01922 = 0;
            for (Direction direction : Direction.values()) {
                mutableBlockPos.m_122173_(direction);
                if (p_162520_.m_71051_(mutableBlockPos) && p_162519_.m_8055_(mutableBlockPos).m_60783_(p_162519_, mutableBlockPos, direction.m_122424_()) && ++\u00e2\u02dc\u01922 >= p_162524_) {
                    return true;
                }
                mutableBlockPos.m_122173_(direction.m_122424_());
            }
            return false;
        }
    }

    static abstract class MineShaftPiece
    extends StructurePiece {
        protected MineshaftFeature.Type f_71465_;

        public MineShaftPiece(StructurePieceType p_162571_, int p_162572_, MineshaftFeature.Type p_162573_, BoundingBox p_162574_) {
            super(p_162571_, p_162572_, p_162574_);
            this.f_71465_ = p_162573_;
        }

        public MineShaftPiece(StructurePieceType p_71471_, CompoundTag p_71472_) {
            super(p_71471_, p_71472_);
            this.f_71465_ = MineshaftFeature.Type.m_66330_(p_71472_.m_128451_("MST"));
        }

        @Override
        protected boolean m_142085_(LevelReader p_162582_, int p_162583_, int p_162584_, int p_162585_, BoundingBox p_162586_) {
            BlockState blockState = this.m_73398_(p_162582_, p_162583_, p_162584_, p_162585_, p_162586_);
            return !blockState.m_60713_(this.f_71465_.m_160062_().m_60734_()) && !blockState.m_60713_(this.f_71465_.m_160061_().m_60734_()) && !blockState.m_60713_(this.f_71465_.m_160063_().m_60734_()) && !blockState.m_60713_(Blocks.f_50184_);
        }

        @Override
        protected void m_142347_(ServerLevel p_162576_, CompoundTag p_162577_) {
            p_162577_.m_128405_("MST", this.f_71465_.ordinal());
        }

        protected boolean m_71474_(BlockGetter p_71475_, BoundingBox p_71476_, int p_71477_, int p_71478_, int p_71479_, int p_71480_) {
            for (int i = p_71477_; i <= p_71478_; ++i) {
                if (!this.m_73398_(p_71475_, i, p_71479_ + 1, p_71480_, p_71476_).m_60795_()) continue;
                return false;
            }
            return true;
        }

        protected boolean m_162578_(BlockGetter p_162579_, BoundingBox p_162580_) {
            int n = Math.max(this.f_73383_.m_162395_() - 1, p_162580_.m_162395_());
            \u00e2\u02dc\u0192 = Math.max(this.f_73383_.m_162396_() - 1, p_162580_.m_162396_());
            \u00e2\u02dc\u0192 = Math.max(this.f_73383_.m_162398_() - 1, p_162580_.m_162398_());
            \u00e2\u02dc\u0192 = Math.min(this.f_73383_.m_162399_() + 1, p_162580_.m_162399_());
            \u00e2\u02dc\u0192 = Math.min(this.f_73383_.m_162400_() + 1, p_162580_.m_162400_());
            \u00e2\u02dc\u0192 = Math.min(this.f_73383_.m_162401_() + 1, p_162580_.m_162401_());
            BlockPos.MutableBlockPos \u00e2\u02dc\u01922 = new BlockPos.MutableBlockPos();
            for (\u00e2\u02dc\u0192 = n; \u00e2\u02dc\u0192 <= \u00e2\u02dc\u0192; ++\u00e2\u02dc\u0192) {
                for (\u00e2\u02dc\u0192 = \u00e2\u02dc\u0192; \u00e2\u02dc\u0192 <= \u00e2\u02dc\u0192; ++\u00e2\u02dc\u0192) {
                    if (p_162579_.m_8055_(\u00e2\u02dc\u01922.m_122178_(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192)).m_60767_().m_76332_()) {
                        return true;
                    }
                    if (!p_162579_.m_8055_(\u00e2\u02dc\u01922.m_122178_(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192)).m_60767_().m_76332_()) continue;
                    return true;
                }
            }
            for (\u00e2\u02dc\u0192 = n; \u00e2\u02dc\u0192 <= \u00e2\u02dc\u0192; ++\u00e2\u02dc\u0192) {
                for (\u00e2\u02dc\u0192 = \u00e2\u02dc\u0192; \u00e2\u02dc\u0192 <= \u00e2\u02dc\u0192; ++\u00e2\u02dc\u0192) {
                    if (p_162579_.m_8055_(\u00e2\u02dc\u01922.m_122178_(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192)).m_60767_().m_76332_()) {
                        return true;
                    }
                    if (!p_162579_.m_8055_(\u00e2\u02dc\u01922.m_122178_(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192)).m_60767_().m_76332_()) continue;
                    return true;
                }
            }
            for (\u00e2\u02dc\u0192 = \u00e2\u02dc\u0192; \u00e2\u02dc\u0192 <= \u00e2\u02dc\u0192; ++\u00e2\u02dc\u0192) {
                for (\u00e2\u02dc\u0192 = \u00e2\u02dc\u0192; \u00e2\u02dc\u0192 <= \u00e2\u02dc\u0192; ++\u00e2\u02dc\u0192) {
                    if (p_162579_.m_8055_(\u00e2\u02dc\u01922.m_122178_(n, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192)).m_60767_().m_76332_()) {
                        return true;
                    }
                    if (!p_162579_.m_8055_(\u00e2\u02dc\u01922.m_122178_(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192)).m_60767_().m_76332_()) continue;
                    return true;
                }
            }
            return false;
        }

        protected void m_162587_(WorldGenLevel p_162588_, BoundingBox p_162589_, BlockState p_162590_, int p_162591_, int p_162592_, int p_162593_) {
            if (!this.m_73414_(p_162588_, p_162591_, p_162592_, p_162593_, p_162589_)) {
                return;
            }
            BlockPos.MutableBlockPos mutableBlockPos = this.m_163582_(p_162591_, p_162592_, p_162593_);
            BlockState \u00e2\u02dc\u01922 = p_162588_.m_8055_(mutableBlockPos);
            if (\u00e2\u02dc\u01922.m_60795_() || \u00e2\u02dc\u01922.m_60713_(Blocks.f_50184_)) {
                p_162588_.m_7731_(mutableBlockPos, p_162590_, 2);
            }
        }
    }

    public static class MineShaftRoom
    extends MineShaftPiece {
        private final List<BoundingBox> f_71484_ = Lists.newLinkedList();

        public MineShaftRoom(int p_71486_, Random p_71487_, int p_71488_, int p_71489_, MineshaftFeature.Type p_71490_) {
            super(StructurePieceType.f_67138_, p_71486_, p_71490_, new BoundingBox(p_71488_, 50, p_71489_, p_71488_ + 7 + p_71487_.nextInt(6), 54 + p_71487_.nextInt(6), p_71489_ + 7 + p_71487_.nextInt(6)));
            this.f_71465_ = p_71490_;
        }

        public MineShaftRoom(ServerLevel p_162595_, CompoundTag p_162596_) {
            super(StructurePieceType.f_67138_, p_162596_);
            BoundingBox.f_162354_.listOf().parse((DynamicOps)NbtOps.f_128958_, (Object)p_162596_.m_128437_("Entrances", 11)).resultOrPartial(arg_0 -> ((Logger)f_162462_).error(arg_0)).ifPresent(this.f_71484_::addAll);
        }

        @Override
        public void m_142537_(StructurePiece p_162601_, StructurePieceAccessor p_162602_, Random p_162603_) {
            int n;
            BoundingBox \u00e2\u02dc\u01922;
            MineShaftPiece mineShaftPiece;
            int n2 = this.m_73548_();
            \u00e2\u02dc\u0192 = this.f_73383_.m_71057_() - 3 - 1;
            if (\u00e2\u02dc\u0192 <= 0) {
                \u00e2\u02dc\u0192 = 1;
            }
            for (n = 0; n < this.f_73383_.m_71056_() && (n += p_162603_.nextInt(this.f_73383_.m_71056_())) + 3 <= this.f_73383_.m_71056_(); n += 4) {
                mineShaftPiece = MineShaftPieces.m_162471_(p_162601_, p_162602_, p_162603_, this.f_73383_.m_162395_() + n, this.f_73383_.m_162396_() + p_162603_.nextInt(\u00e2\u02dc\u0192) + 1, this.f_73383_.m_162398_() - 1, Direction.NORTH, n2);
                if (mineShaftPiece == null) continue;
                \u00e2\u02dc\u01922 = mineShaftPiece.m_73547_();
                this.f_71484_.add(new BoundingBox(\u00e2\u02dc\u01922.m_162395_(), \u00e2\u02dc\u01922.m_162396_(), this.f_73383_.m_162398_(), \u00e2\u02dc\u01922.m_162399_(), \u00e2\u02dc\u01922.m_162400_(), this.f_73383_.m_162398_() + 1));
            }
            for (n = 0; n < this.f_73383_.m_71056_() && (n += p_162603_.nextInt(this.f_73383_.m_71056_())) + 3 <= this.f_73383_.m_71056_(); n += 4) {
                mineShaftPiece = MineShaftPieces.m_162471_(p_162601_, p_162602_, p_162603_, this.f_73383_.m_162395_() + n, this.f_73383_.m_162396_() + p_162603_.nextInt(\u00e2\u02dc\u0192) + 1, this.f_73383_.m_162401_() + 1, Direction.SOUTH, n2);
                if (mineShaftPiece == null) continue;
                \u00e2\u02dc\u01922 = mineShaftPiece.m_73547_();
                this.f_71484_.add(new BoundingBox(\u00e2\u02dc\u01922.m_162395_(), \u00e2\u02dc\u01922.m_162396_(), this.f_73383_.m_162401_() - 1, \u00e2\u02dc\u01922.m_162399_(), \u00e2\u02dc\u01922.m_162400_(), this.f_73383_.m_162401_()));
            }
            for (n = 0; n < this.f_73383_.m_71058_() && (n += p_162603_.nextInt(this.f_73383_.m_71058_())) + 3 <= this.f_73383_.m_71058_(); n += 4) {
                mineShaftPiece = MineShaftPieces.m_162471_(p_162601_, p_162602_, p_162603_, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_() + p_162603_.nextInt(\u00e2\u02dc\u0192) + 1, this.f_73383_.m_162398_() + n, Direction.WEST, n2);
                if (mineShaftPiece == null) continue;
                \u00e2\u02dc\u01922 = mineShaftPiece.m_73547_();
                this.f_71484_.add(new BoundingBox(this.f_73383_.m_162395_(), \u00e2\u02dc\u01922.m_162396_(), \u00e2\u02dc\u01922.m_162398_(), this.f_73383_.m_162395_() + 1, \u00e2\u02dc\u01922.m_162400_(), \u00e2\u02dc\u01922.m_162401_()));
            }
            for (n = 0; n < this.f_73383_.m_71058_() && (n += p_162603_.nextInt(this.f_73383_.m_71058_())) + 3 <= this.f_73383_.m_71058_(); n += 4) {
                mineShaftPiece = MineShaftPieces.m_162471_(p_162601_, p_162602_, p_162603_, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_() + p_162603_.nextInt(\u00e2\u02dc\u0192) + 1, this.f_73383_.m_162398_() + n, Direction.EAST, n2);
                if (mineShaftPiece == null) continue;
                \u00e2\u02dc\u01922 = mineShaftPiece.m_73547_();
                this.f_71484_.add(new BoundingBox(this.f_73383_.m_162399_() - 1, \u00e2\u02dc\u01922.m_162396_(), \u00e2\u02dc\u01922.m_162398_(), this.f_73383_.m_162399_(), \u00e2\u02dc\u01922.m_162400_(), \u00e2\u02dc\u01922.m_162401_()));
            }
        }

        @Override
        public boolean m_7832_(WorldGenLevel p_71499_, StructureFeatureManager p_71500_, ChunkGenerator p_71501_, Random p_71502_, BoundingBox p_71503_, ChunkPos p_71504_, BlockPos p_71505_) {
            if (this.m_162578_(p_71499_, p_71503_)) {
                return false;
            }
            this.m_73441_(p_71499_, p_71503_, this.f_73383_.m_162395_(), this.f_73383_.m_162396_(), this.f_73383_.m_162398_(), this.f_73383_.m_162399_(), this.f_73383_.m_162396_(), this.f_73383_.m_162401_(), Blocks.f_50493_.m_49966_(), f_73382_, true);
            this.m_73441_(p_71499_, p_71503_, this.f_73383_.m_162395_(), this.f_73383_.m_162396_() + 1, this.f_73383_.m_162398_(), this.f_73383_.m_162399_(), Math.min(this.f_73383_.m_162396_() + 3, this.f_73383_.m_162400_()), this.f_73383_.m_162401_(), f_73382_, f_73382_, false);
            for (BoundingBox boundingBox : this.f_71484_) {
                this.m_73441_(p_71499_, p_71503_, boundingBox.m_162395_(), boundingBox.m_162400_() - 2, boundingBox.m_162398_(), boundingBox.m_162399_(), boundingBox.m_162400_(), boundingBox.m_162401_(), f_73382_, f_73382_, false);
            }
            this.m_73453_(p_71499_, p_71503_, this.f_73383_.m_162395_(), this.f_73383_.m_162396_() + 4, this.f_73383_.m_162398_(), this.f_73383_.m_162399_(), this.f_73383_.m_162400_(), this.f_73383_.m_162401_(), f_73382_, false);
            return true;
        }

        @Override
        public void m_6324_(int p_71495_, int p_71496_, int p_71497_) {
            super.m_6324_(p_71495_, p_71496_, p_71497_);
            for (BoundingBox boundingBox : this.f_71484_) {
                boundingBox.m_162367_(p_71495_, p_71496_, p_71497_);
            }
        }

        @Override
        protected void m_142347_(ServerLevel p_162598_, CompoundTag p_162599_) {
            super.m_142347_(p_162598_, p_162599_);
            BoundingBox.f_162354_.listOf().encodeStart((DynamicOps)NbtOps.f_128958_, this.f_71484_).resultOrPartial(arg_0 -> ((Logger)f_162462_).error(arg_0)).ifPresent(p_162606_ -> p_162599_.m_128365_("Entrances", (Tag)p_162606_));
        }
    }
}

