/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public class NetherBridgePieces {
    private static final int f_162621_ = 30;
    private static final int f_162622_ = 10;
    static final PieceWeight[] f_71539_ = new PieceWeight[]{new PieceWeight(BridgeStraight.class, 30, 0, true), new PieceWeight(BridgeCrossing.class, 10, 4), new PieceWeight(RoomCrossing.class, 10, 4), new PieceWeight(StairsRoom.class, 10, 3), new PieceWeight(MonsterThrone.class, 5, 2), new PieceWeight(CastleEntrance.class, 5, 1)};
    static final PieceWeight[] f_71540_ = new PieceWeight[]{new PieceWeight(CastleSmallCorridorPiece.class, 25, 0, true), new PieceWeight(CastleSmallCorridorCrossingPiece.class, 15, 5), new PieceWeight(CastleSmallCorridorRightTurnPiece.class, 5, 10), new PieceWeight(CastleSmallCorridorLeftTurnPiece.class, 5, 10), new PieceWeight(CastleCorridorStairsPiece.class, 10, 3, true), new PieceWeight(CastleCorridorTBalconyPiece.class, 7, 2), new PieceWeight(CastleStalkRoom.class, 5, 2)};

    static NetherBridgePiece m_162624_(PieceWeight p_162625_, StructurePieceAccessor p_162626_, Random p_162627_, int p_162628_, int p_162629_, int p_162630_, Direction p_162631_, int p_162632_) {
        Class<? extends NetherBridgePiece> clazz = p_162625_.f_71950_;
        NetherBridgePiece \u00e2\u02dc\u01922 = null;
        if (clazz == BridgeStraight.class) {
            \u00e2\u02dc\u01922 = BridgeStraight.m_162681_(p_162626_, p_162627_, p_162628_, p_162629_, p_162630_, p_162631_, p_162632_);
        } else if (clazz == BridgeCrossing.class) {
            \u00e2\u02dc\u01922 = BridgeCrossing.m_162647_(p_162626_, p_162628_, p_162629_, p_162630_, p_162631_, p_162632_);
        } else if (clazz == RoomCrossing.class) {
            \u00e2\u02dc\u01922 = RoomCrossing.m_162908_(p_162626_, p_162628_, p_162629_, p_162630_, p_162631_, p_162632_);
        } else if (clazz == StairsRoom.class) {
            \u00e2\u02dc\u01922 = StairsRoom.m_162925_(p_162626_, p_162628_, p_162629_, p_162630_, p_162632_, p_162631_);
        } else if (clazz == MonsterThrone.class) {
            \u00e2\u02dc\u01922 = MonsterThrone.m_162843_(p_162626_, p_162628_, p_162629_, p_162630_, p_162632_, p_162631_);
        } else if (clazz == CastleEntrance.class) {
            \u00e2\u02dc\u01922 = CastleEntrance.m_162733_(p_162626_, p_162627_, p_162628_, p_162629_, p_162630_, p_162631_, p_162632_);
        } else if (clazz == CastleSmallCorridorPiece.class) {
            \u00e2\u02dc\u01922 = CastleSmallCorridorPiece.m_162789_(p_162626_, p_162628_, p_162629_, p_162630_, p_162631_, p_162632_);
        } else if (clazz == CastleSmallCorridorRightTurnPiece.class) {
            \u00e2\u02dc\u01922 = CastleSmallCorridorRightTurnPiece.m_162809_(p_162626_, p_162627_, p_162628_, p_162629_, p_162630_, p_162631_, p_162632_);
        } else if (clazz == CastleSmallCorridorLeftTurnPiece.class) {
            \u00e2\u02dc\u01922 = CastleSmallCorridorLeftTurnPiece.m_162771_(p_162626_, p_162627_, p_162628_, p_162629_, p_162630_, p_162631_, p_162632_);
        } else if (clazz == CastleCorridorStairsPiece.class) {
            \u00e2\u02dc\u01922 = CastleCorridorStairsPiece.m_162699_(p_162626_, p_162628_, p_162629_, p_162630_, p_162631_, p_162632_);
        } else if (clazz == CastleCorridorTBalconyPiece.class) {
            \u00e2\u02dc\u01922 = CastleCorridorTBalconyPiece.m_162716_(p_162626_, p_162628_, p_162629_, p_162630_, p_162631_, p_162632_);
        } else if (clazz == CastleSmallCorridorCrossingPiece.class) {
            \u00e2\u02dc\u01922 = CastleSmallCorridorCrossingPiece.m_162751_(p_162626_, p_162628_, p_162629_, p_162630_, p_162631_, p_162632_);
        } else if (clazz == CastleStalkRoom.class) {
            \u00e2\u02dc\u01922 = CastleStalkRoom.m_162827_(p_162626_, p_162628_, p_162629_, p_162630_, p_162631_, p_162632_);
        }
        return \u00e2\u02dc\u01922;
    }

    static class PieceWeight {
        public final Class<? extends NetherBridgePiece> f_71950_;
        public final int f_71951_;
        public int f_71952_;
        public final int f_71953_;
        public final boolean f_71954_;

        public PieceWeight(Class<? extends NetherBridgePiece> p_71960_, int p_71961_, int p_71962_, boolean p_71963_) {
            this.f_71950_ = p_71960_;
            this.f_71951_ = p_71961_;
            this.f_71953_ = p_71962_;
            this.f_71954_ = p_71963_;
        }

        public PieceWeight(Class<? extends NetherBridgePiece> p_71956_, int p_71957_, int p_71958_) {
            this(p_71956_, p_71957_, p_71958_, false);
        }

        public boolean m_71965_(int p_71966_) {
            return this.f_71953_ == 0 || this.f_71952_ < this.f_71953_;
        }

        public boolean m_71964_() {
            return this.f_71953_ == 0 || this.f_71952_ < this.f_71953_;
        }
    }

    public static class BridgeStraight
    extends NetherBridgePiece {
        private static final int f_162671_ = 5;
        private static final int f_162672_ = 10;
        private static final int f_162673_ = 19;

        public BridgeStraight(int p_71625_, Random p_71626_, BoundingBox p_71627_, Direction p_71628_) {
            super(StructurePieceType.f_67142_, p_71625_, p_71627_);
            this.m_73519_(p_71628_);
        }

        public BridgeStraight(ServerLevel p_162675_, CompoundTag p_162676_) {
            super(StructurePieceType.f_67142_, p_162676_);
        }

        @Override
        public void m_142537_(StructurePiece p_162678_, StructurePieceAccessor p_162679_, Random p_162680_) {
            this.m_162867_((StartPiece)p_162678_, p_162679_, p_162680_, 1, 3, false);
        }

        public static BridgeStraight m_162681_(StructurePieceAccessor p_162682_, Random p_162683_, int p_162684_, int p_162685_, int p_162686_, Direction p_162687_, int p_162688_) {
            BoundingBox boundingBox = BoundingBox.m_71031_(p_162684_, p_162685_, p_162686_, -1, -3, 0, 5, 10, 19, p_162687_);
            if (!BridgeStraight.m_71903_(boundingBox) || p_162682_.m_141921_(boundingBox) != null) {
                return null;
            }
            return new BridgeStraight(p_162688_, p_162683_, boundingBox, p_162687_);
        }

        @Override
        public boolean m_7832_(WorldGenLevel p_71633_, StructureFeatureManager p_71634_, ChunkGenerator p_71635_, Random p_71636_, BoundingBox p_71637_, ChunkPos p_71638_, BlockPos p_71639_) {
            this.m_73441_(p_71633_, p_71637_, 0, 3, 0, 4, 4, 18, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71633_, p_71637_, 1, 5, 0, 3, 7, 18, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), false);
            this.m_73441_(p_71633_, p_71637_, 0, 5, 0, 0, 5, 18, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71633_, p_71637_, 4, 5, 0, 4, 5, 18, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71633_, p_71637_, 0, 2, 0, 4, 2, 5, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71633_, p_71637_, 0, 2, 13, 4, 2, 18, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71633_, p_71637_, 0, 0, 0, 4, 1, 3, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71633_, p_71637_, 0, 0, 15, 4, 1, 18, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            for (int i = 0; i <= 4; ++i) {
                for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 <= 2; ++\u00e2\u02dc\u0192) {
                    this.m_73528_(p_71633_, Blocks.f_50197_.m_49966_(), i, -1, \u00e2\u02dc\u0192, p_71637_);
                    this.m_73528_(p_71633_, Blocks.f_50197_.m_49966_(), i, -1, 18 - \u00e2\u02dc\u0192, p_71637_);
                }
            }
            BlockState blockState = (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52309_, true)).m_61124_(FenceBlock.f_52311_, true);
            \u00e2\u02dc\u0192 = (BlockState)blockState.m_61124_(FenceBlock.f_52310_, true);
            \u00e2\u02dc\u0192 = (BlockState)blockState.m_61124_(FenceBlock.f_52312_, true);
            this.m_73441_(p_71633_, p_71637_, 0, 1, 1, 0, 4, 1, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, false);
            this.m_73441_(p_71633_, p_71637_, 0, 3, 4, 0, 4, 4, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, false);
            this.m_73441_(p_71633_, p_71637_, 0, 3, 14, 0, 4, 14, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, false);
            this.m_73441_(p_71633_, p_71637_, 0, 1, 17, 0, 4, 17, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, false);
            this.m_73441_(p_71633_, p_71637_, 4, 1, 1, 4, 4, 1, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, false);
            this.m_73441_(p_71633_, p_71637_, 4, 3, 4, 4, 4, 4, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, false);
            this.m_73441_(p_71633_, p_71637_, 4, 3, 14, 4, 4, 14, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, false);
            this.m_73441_(p_71633_, p_71637_, 4, 1, 17, 4, 4, 17, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, false);
            return true;
        }
    }

    public static class BridgeCrossing
    extends NetherBridgePiece {
        private static final int f_162633_ = 19;
        private static final int f_162634_ = 10;
        private static final int f_162635_ = 19;

        public BridgeCrossing(int p_71565_, BoundingBox p_71566_, Direction p_71567_) {
            super(StructurePieceType.f_67140_, p_71565_, p_71566_);
            this.m_73519_(p_71567_);
        }

        protected BridgeCrossing(int p_162637_, int p_162638_, Direction p_162639_) {
            super(StructurePieceType.f_67140_, 0, StructurePiece.m_163541_(p_162637_, 64, p_162638_, p_162639_, 19, 10, 19));
            this.m_73519_(p_162639_);
        }

        protected BridgeCrossing(StructurePieceType p_71569_, CompoundTag p_71570_) {
            super(p_71569_, p_71570_);
        }

        public BridgeCrossing(ServerLevel p_162641_, CompoundTag p_162642_) {
            this(StructurePieceType.f_67140_, p_162642_);
        }

        @Override
        public void m_142537_(StructurePiece p_162644_, StructurePieceAccessor p_162645_, Random p_162646_) {
            this.m_162867_((StartPiece)p_162644_, p_162645_, p_162646_, 8, 3, false);
            this.m_162884_((StartPiece)p_162644_, p_162645_, p_162646_, 3, 8, false);
            this.m_162891_((StartPiece)p_162644_, p_162645_, p_162646_, 3, 8, false);
        }

        public static BridgeCrossing m_162647_(StructurePieceAccessor p_162648_, int p_162649_, int p_162650_, int p_162651_, Direction p_162652_, int p_162653_) {
            BoundingBox boundingBox = BoundingBox.m_71031_(p_162649_, p_162650_, p_162651_, -8, -3, 0, 19, 10, 19, p_162652_);
            if (!BridgeCrossing.m_71903_(boundingBox) || p_162648_.m_141921_(boundingBox) != null) {
                return null;
            }
            return new BridgeCrossing(p_162653_, boundingBox, p_162652_);
        }

        @Override
        public boolean m_7832_(WorldGenLevel p_71579_, StructureFeatureManager p_71580_, ChunkGenerator p_71581_, Random p_71582_, BoundingBox p_71583_, ChunkPos p_71584_, BlockPos p_71585_) {
            int n;
            this.m_73441_(p_71579_, p_71583_, 7, 3, 0, 11, 4, 18, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71579_, p_71583_, 0, 3, 7, 18, 4, 11, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71579_, p_71583_, 8, 5, 0, 10, 7, 18, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), false);
            this.m_73441_(p_71579_, p_71583_, 0, 5, 8, 18, 7, 10, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), false);
            this.m_73441_(p_71579_, p_71583_, 7, 5, 0, 7, 5, 7, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71579_, p_71583_, 7, 5, 11, 7, 5, 18, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71579_, p_71583_, 11, 5, 0, 11, 5, 7, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71579_, p_71583_, 11, 5, 11, 11, 5, 18, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71579_, p_71583_, 0, 5, 7, 7, 5, 7, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71579_, p_71583_, 11, 5, 7, 18, 5, 7, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71579_, p_71583_, 0, 5, 11, 7, 5, 11, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71579_, p_71583_, 11, 5, 11, 18, 5, 11, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71579_, p_71583_, 7, 2, 0, 11, 2, 5, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71579_, p_71583_, 7, 2, 13, 11, 2, 18, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71579_, p_71583_, 7, 0, 0, 11, 1, 3, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71579_, p_71583_, 7, 0, 15, 11, 1, 18, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            for (n = 7; n <= 11; ++n) {
                for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 <= 2; ++\u00e2\u02dc\u0192) {
                    this.m_73528_(p_71579_, Blocks.f_50197_.m_49966_(), n, -1, \u00e2\u02dc\u0192, p_71583_);
                    this.m_73528_(p_71579_, Blocks.f_50197_.m_49966_(), n, -1, 18 - \u00e2\u02dc\u0192, p_71583_);
                }
            }
            this.m_73441_(p_71579_, p_71583_, 0, 2, 7, 5, 2, 11, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71579_, p_71583_, 13, 2, 7, 18, 2, 11, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71579_, p_71583_, 0, 0, 7, 3, 1, 11, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71579_, p_71583_, 15, 0, 7, 18, 1, 11, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            for (n = 0; n <= 2; ++n) {
                for (\u00e2\u02dc\u0192 = 7; \u00e2\u02dc\u0192 <= 11; ++\u00e2\u02dc\u0192) {
                    this.m_73528_(p_71579_, Blocks.f_50197_.m_49966_(), n, -1, \u00e2\u02dc\u0192, p_71583_);
                    this.m_73528_(p_71579_, Blocks.f_50197_.m_49966_(), 18 - n, -1, \u00e2\u02dc\u0192, p_71583_);
                }
            }
            return true;
        }
    }

    public static class RoomCrossing
    extends NetherBridgePiece {
        private static final int f_162898_ = 7;
        private static final int f_162899_ = 9;
        private static final int f_162900_ = 7;

        public RoomCrossing(int p_71968_, BoundingBox p_71969_, Direction p_71970_) {
            super(StructurePieceType.f_67152_, p_71968_, p_71969_);
            this.m_73519_(p_71970_);
        }

        public RoomCrossing(ServerLevel p_162902_, CompoundTag p_162903_) {
            super(StructurePieceType.f_67152_, p_162903_);
        }

        @Override
        public void m_142537_(StructurePiece p_162905_, StructurePieceAccessor p_162906_, Random p_162907_) {
            this.m_162867_((StartPiece)p_162905_, p_162906_, p_162907_, 2, 0, false);
            this.m_162884_((StartPiece)p_162905_, p_162906_, p_162907_, 0, 2, false);
            this.m_162891_((StartPiece)p_162905_, p_162906_, p_162907_, 0, 2, false);
        }

        public static RoomCrossing m_162908_(StructurePieceAccessor p_162909_, int p_162910_, int p_162911_, int p_162912_, Direction p_162913_, int p_162914_) {
            BoundingBox boundingBox = BoundingBox.m_71031_(p_162910_, p_162911_, p_162912_, -2, 0, 0, 7, 9, 7, p_162913_);
            if (!RoomCrossing.m_71903_(boundingBox) || p_162909_.m_141921_(boundingBox) != null) {
                return null;
            }
            return new RoomCrossing(p_162914_, boundingBox, p_162913_);
        }

        @Override
        public boolean m_7832_(WorldGenLevel p_71975_, StructureFeatureManager p_71976_, ChunkGenerator p_71977_, Random p_71978_, BoundingBox p_71979_, ChunkPos p_71980_, BlockPos p_71981_) {
            this.m_73441_(p_71975_, p_71979_, 0, 0, 0, 6, 1, 6, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71975_, p_71979_, 0, 2, 0, 6, 7, 6, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), false);
            this.m_73441_(p_71975_, p_71979_, 0, 2, 0, 1, 6, 0, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71975_, p_71979_, 0, 2, 6, 1, 6, 6, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71975_, p_71979_, 5, 2, 0, 6, 6, 0, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71975_, p_71979_, 5, 2, 6, 6, 6, 6, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71975_, p_71979_, 0, 2, 0, 0, 6, 1, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71975_, p_71979_, 0, 2, 5, 0, 6, 6, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71975_, p_71979_, 6, 2, 0, 6, 6, 1, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71975_, p_71979_, 6, 2, 5, 6, 6, 6, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            BlockState blockState = (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52312_, true)).m_61124_(FenceBlock.f_52310_, true);
            \u00e2\u02dc\u0192 = (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52309_, true)).m_61124_(FenceBlock.f_52311_, true);
            this.m_73441_(p_71975_, p_71979_, 2, 6, 0, 4, 6, 0, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71975_, p_71979_, 2, 5, 0, 4, 5, 0, blockState, blockState, false);
            this.m_73441_(p_71975_, p_71979_, 2, 6, 6, 4, 6, 6, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71975_, p_71979_, 2, 5, 6, 4, 5, 6, blockState, blockState, false);
            this.m_73441_(p_71975_, p_71979_, 0, 6, 2, 0, 6, 4, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71975_, p_71979_, 0, 5, 2, 0, 5, 4, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, false);
            this.m_73441_(p_71975_, p_71979_, 6, 6, 2, 6, 6, 4, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71975_, p_71979_, 6, 5, 2, 6, 5, 4, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, false);
            for (int i = 0; i <= 6; ++i) {
                for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 <= 6; ++\u00e2\u02dc\u0192) {
                    this.m_73528_(p_71975_, Blocks.f_50197_.m_49966_(), i, -1, \u00e2\u02dc\u0192, p_71979_);
                }
            }
            return true;
        }
    }

    public static class StairsRoom
    extends NetherBridgePiece {
        private static final int f_162915_ = 7;
        private static final int f_162916_ = 11;
        private static final int f_162917_ = 7;

        public StairsRoom(int p_71994_, BoundingBox p_71995_, Direction p_71996_) {
            super(StructurePieceType.f_67153_, p_71994_, p_71995_);
            this.m_73519_(p_71996_);
        }

        public StairsRoom(ServerLevel p_162919_, CompoundTag p_162920_) {
            super(StructurePieceType.f_67153_, p_162920_);
        }

        @Override
        public void m_142537_(StructurePiece p_162922_, StructurePieceAccessor p_162923_, Random p_162924_) {
            this.m_162891_((StartPiece)p_162922_, p_162923_, p_162924_, 6, 2, false);
        }

        public static StairsRoom m_162925_(StructurePieceAccessor p_162926_, int p_162927_, int p_162928_, int p_162929_, int p_162930_, Direction p_162931_) {
            BoundingBox boundingBox = BoundingBox.m_71031_(p_162927_, p_162928_, p_162929_, -2, 0, 0, 7, 11, 7, p_162931_);
            if (!StairsRoom.m_71903_(boundingBox) || p_162926_.m_141921_(boundingBox) != null) {
                return null;
            }
            return new StairsRoom(p_162930_, boundingBox, p_162931_);
        }

        @Override
        public boolean m_7832_(WorldGenLevel p_72001_, StructureFeatureManager p_72002_, ChunkGenerator p_72003_, Random p_72004_, BoundingBox p_72005_, ChunkPos p_72006_, BlockPos p_72007_) {
            this.m_73441_(p_72001_, p_72005_, 0, 0, 0, 6, 1, 6, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_72001_, p_72005_, 0, 2, 0, 6, 10, 6, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), false);
            this.m_73441_(p_72001_, p_72005_, 0, 2, 0, 1, 8, 0, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_72001_, p_72005_, 5, 2, 0, 6, 8, 0, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_72001_, p_72005_, 0, 2, 1, 0, 8, 6, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_72001_, p_72005_, 6, 2, 1, 6, 8, 6, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_72001_, p_72005_, 1, 2, 6, 5, 8, 6, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            BlockState blockState = (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52312_, true)).m_61124_(FenceBlock.f_52310_, true);
            \u00e2\u02dc\u0192 = (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52309_, true)).m_61124_(FenceBlock.f_52311_, true);
            this.m_73441_(p_72001_, p_72005_, 0, 3, 2, 0, 5, 4, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, false);
            this.m_73441_(p_72001_, p_72005_, 6, 3, 2, 6, 5, 2, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, false);
            this.m_73441_(p_72001_, p_72005_, 6, 3, 4, 6, 5, 4, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, false);
            this.m_73434_(p_72001_, Blocks.f_50197_.m_49966_(), 5, 2, 5, p_72005_);
            this.m_73441_(p_72001_, p_72005_, 4, 2, 5, 4, 3, 5, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_72001_, p_72005_, 3, 2, 5, 3, 4, 5, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_72001_, p_72005_, 2, 2, 5, 2, 5, 5, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_72001_, p_72005_, 1, 2, 5, 1, 6, 5, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_72001_, p_72005_, 1, 7, 1, 5, 7, 4, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_72001_, p_72005_, 6, 8, 2, 6, 8, 4, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), false);
            this.m_73441_(p_72001_, p_72005_, 2, 6, 0, 4, 8, 0, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_72001_, p_72005_, 2, 5, 0, 4, 5, 0, blockState, blockState, false);
            for (int i = 0; i <= 6; ++i) {
                for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 <= 6; ++\u00e2\u02dc\u0192) {
                    this.m_73528_(p_72001_, Blocks.f_50197_.m_49966_(), i, -1, \u00e2\u02dc\u0192, p_72005_);
                }
            }
            return true;
        }
    }

    public static class MonsterThrone
    extends NetherBridgePiece {
        private static final int f_162834_ = 7;
        private static final int f_162835_ = 8;
        private static final int f_162836_ = 9;
        private boolean f_71872_;

        public MonsterThrone(int p_71874_, BoundingBox p_71875_, Direction p_71876_) {
            super(StructurePieceType.f_67151_, p_71874_, p_71875_);
            this.m_73519_(p_71876_);
        }

        public MonsterThrone(ServerLevel p_162838_, CompoundTag p_162839_) {
            super(StructurePieceType.f_67151_, p_162839_);
            this.f_71872_ = p_162839_.m_128471_("Mob");
        }

        @Override
        protected void m_142347_(ServerLevel p_162841_, CompoundTag p_162842_) {
            super.m_142347_(p_162841_, p_162842_);
            p_162842_.m_128379_("Mob", this.f_71872_);
        }

        public static MonsterThrone m_162843_(StructurePieceAccessor p_162844_, int p_162845_, int p_162846_, int p_162847_, int p_162848_, Direction p_162849_) {
            BoundingBox boundingBox = BoundingBox.m_71031_(p_162845_, p_162846_, p_162847_, -2, 0, 0, 7, 8, 9, p_162849_);
            if (!MonsterThrone.m_71903_(boundingBox) || p_162844_.m_141921_(boundingBox) != null) {
                return null;
            }
            return new MonsterThrone(p_162848_, boundingBox, p_162849_);
        }

        @Override
        public boolean m_7832_(WorldGenLevel p_71881_, StructureFeatureManager p_71882_, ChunkGenerator p_71883_, Random p_71884_, BoundingBox p_71885_, ChunkPos p_71886_, BlockPos p_71887_) {
            this.m_73441_(p_71881_, p_71885_, 0, 2, 0, 6, 7, 7, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), false);
            this.m_73441_(p_71881_, p_71885_, 1, 0, 0, 5, 1, 7, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71881_, p_71885_, 1, 2, 1, 5, 2, 7, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71881_, p_71885_, 1, 3, 2, 5, 3, 7, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71881_, p_71885_, 1, 4, 3, 5, 4, 7, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71881_, p_71885_, 1, 2, 0, 1, 4, 2, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71881_, p_71885_, 5, 2, 0, 5, 4, 2, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71881_, p_71885_, 1, 5, 2, 1, 5, 3, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71881_, p_71885_, 5, 5, 2, 5, 5, 3, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71881_, p_71885_, 0, 5, 3, 0, 5, 8, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71881_, p_71885_, 6, 5, 3, 6, 5, 8, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71881_, p_71885_, 1, 5, 8, 5, 5, 8, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            BlockState blockState = (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52312_, true)).m_61124_(FenceBlock.f_52310_, true);
            \u00e2\u02dc\u0192 = (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52309_, true)).m_61124_(FenceBlock.f_52311_, true);
            this.m_73434_(p_71881_, (BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52312_, true), 1, 6, 3, p_71885_);
            this.m_73434_(p_71881_, (BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52310_, true), 5, 6, 3, p_71885_);
            this.m_73434_(p_71881_, (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52310_, true)).m_61124_(FenceBlock.f_52309_, true), 0, 6, 3, p_71885_);
            this.m_73434_(p_71881_, (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52312_, true)).m_61124_(FenceBlock.f_52309_, true), 6, 6, 3, p_71885_);
            this.m_73441_(p_71881_, p_71885_, 0, 6, 4, 0, 6, 7, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, false);
            this.m_73441_(p_71881_, p_71885_, 6, 6, 4, 6, 6, 7, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, false);
            this.m_73434_(p_71881_, (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52310_, true)).m_61124_(FenceBlock.f_52311_, true), 0, 6, 8, p_71885_);
            this.m_73434_(p_71881_, (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52312_, true)).m_61124_(FenceBlock.f_52311_, true), 6, 6, 8, p_71885_);
            this.m_73441_(p_71881_, p_71885_, 1, 6, 8, 5, 6, 8, blockState, blockState, false);
            this.m_73434_(p_71881_, (BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52310_, true), 1, 7, 8, p_71885_);
            this.m_73441_(p_71881_, p_71885_, 2, 7, 8, 4, 7, 8, blockState, blockState, false);
            this.m_73434_(p_71881_, (BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52312_, true), 5, 7, 8, p_71885_);
            this.m_73434_(p_71881_, (BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52310_, true), 2, 8, 8, p_71885_);
            this.m_73434_(p_71881_, blockState, 3, 8, 8, p_71885_);
            this.m_73434_(p_71881_, (BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52312_, true), 4, 8, 8, p_71885_);
            if (!this.f_71872_ && p_71885_.m_71051_(\u00e2\u02dc\u0192 = this.m_163582_(3, 5, 5))) {
                this.f_71872_ = true;
                p_71881_.m_7731_(\u00e2\u02dc\u0192, Blocks.f_50085_.m_49966_(), 2);
                BlockEntity blockEntity = p_71881_.m_7702_(\u00e2\u02dc\u0192);
                if (blockEntity instanceof SpawnerBlockEntity) {
                    ((SpawnerBlockEntity)blockEntity).m_59801_().m_45462_(EntityType.f_20551_);
                }
            }
            for (int i = 0; i <= 6; ++i) {
                for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 <= 6; ++\u00e2\u02dc\u0192) {
                    this.m_73528_(p_71881_, Blocks.f_50197_.m_49966_(), i, -1, \u00e2\u02dc\u0192, p_71885_);
                }
            }
            return true;
        }
    }

    public static class CastleEntrance
    extends NetherBridgePiece {
        private static final int f_162723_ = 13;
        private static final int f_162724_ = 14;
        private static final int f_162725_ = 13;

        public CastleEntrance(int p_71705_, Random p_71706_, BoundingBox p_71707_, Direction p_71708_) {
            super(StructurePieceType.f_67145_, p_71705_, p_71707_);
            this.m_73519_(p_71708_);
        }

        public CastleEntrance(ServerLevel p_162727_, CompoundTag p_162728_) {
            super(StructurePieceType.f_67145_, p_162728_);
        }

        @Override
        public void m_142537_(StructurePiece p_162730_, StructurePieceAccessor p_162731_, Random p_162732_) {
            this.m_162867_((StartPiece)p_162730_, p_162731_, p_162732_, 5, 3, true);
        }

        public static CastleEntrance m_162733_(StructurePieceAccessor p_162734_, Random p_162735_, int p_162736_, int p_162737_, int p_162738_, Direction p_162739_, int p_162740_) {
            BoundingBox boundingBox = BoundingBox.m_71031_(p_162736_, p_162737_, p_162738_, -5, -3, 0, 13, 14, 13, p_162739_);
            if (!CastleEntrance.m_71903_(boundingBox) || p_162734_.m_141921_(boundingBox) != null) {
                return null;
            }
            return new CastleEntrance(p_162740_, p_162735_, boundingBox, p_162739_);
        }

        @Override
        public boolean m_7832_(WorldGenLevel p_71713_, StructureFeatureManager p_71714_, ChunkGenerator p_71715_, Random p_71716_, BoundingBox p_71717_, ChunkPos p_71718_, BlockPos p_71719_) {
            int n;
            this.m_73441_(p_71713_, p_71717_, 0, 3, 0, 12, 4, 12, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71713_, p_71717_, 0, 5, 0, 12, 13, 12, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), false);
            this.m_73441_(p_71713_, p_71717_, 0, 5, 0, 1, 12, 12, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71713_, p_71717_, 11, 5, 0, 12, 12, 12, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71713_, p_71717_, 2, 5, 11, 4, 12, 12, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71713_, p_71717_, 8, 5, 11, 10, 12, 12, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71713_, p_71717_, 5, 9, 11, 7, 12, 12, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71713_, p_71717_, 2, 5, 0, 4, 12, 1, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71713_, p_71717_, 8, 5, 0, 10, 12, 1, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71713_, p_71717_, 5, 9, 0, 7, 12, 1, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71713_, p_71717_, 2, 11, 2, 10, 12, 10, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71713_, p_71717_, 5, 8, 0, 7, 8, 0, Blocks.f_50198_.m_49966_(), Blocks.f_50198_.m_49966_(), false);
            BlockState blockState = (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52312_, true)).m_61124_(FenceBlock.f_52310_, true);
            \u00e2\u02dc\u0192 = (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52309_, true)).m_61124_(FenceBlock.f_52311_, true);
            for (n = 1; n <= 11; n += 2) {
                this.m_73441_(p_71713_, p_71717_, n, 10, 0, n, 11, 0, blockState, blockState, false);
                this.m_73441_(p_71713_, p_71717_, n, 10, 12, n, 11, 12, blockState, blockState, false);
                this.m_73441_(p_71713_, p_71717_, 0, 10, n, 0, 11, n, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, false);
                this.m_73441_(p_71713_, p_71717_, 12, 10, n, 12, 11, n, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, false);
                this.m_73434_(p_71713_, Blocks.f_50197_.m_49966_(), n, 13, 0, p_71717_);
                this.m_73434_(p_71713_, Blocks.f_50197_.m_49966_(), n, 13, 12, p_71717_);
                this.m_73434_(p_71713_, Blocks.f_50197_.m_49966_(), 0, 13, n, p_71717_);
                this.m_73434_(p_71713_, Blocks.f_50197_.m_49966_(), 12, 13, n, p_71717_);
                if (n == 11) continue;
                this.m_73434_(p_71713_, blockState, n + 1, 13, 0, p_71717_);
                this.m_73434_(p_71713_, blockState, n + 1, 13, 12, p_71717_);
                this.m_73434_(p_71713_, \u00e2\u02dc\u0192, 0, 13, n + 1, p_71717_);
                this.m_73434_(p_71713_, \u00e2\u02dc\u0192, 12, 13, n + 1, p_71717_);
            }
            this.m_73434_(p_71713_, (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52309_, true)).m_61124_(FenceBlock.f_52310_, true), 0, 13, 0, p_71717_);
            this.m_73434_(p_71713_, (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52311_, true)).m_61124_(FenceBlock.f_52310_, true), 0, 13, 12, p_71717_);
            this.m_73434_(p_71713_, (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52311_, true)).m_61124_(FenceBlock.f_52312_, true), 12, 13, 12, p_71717_);
            this.m_73434_(p_71713_, (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52309_, true)).m_61124_(FenceBlock.f_52312_, true), 12, 13, 0, p_71717_);
            for (n = 3; n <= 9; n += 2) {
                this.m_73441_(p_71713_, p_71717_, 1, 7, n, 1, 8, n, (BlockState)\u00e2\u02dc\u0192.m_61124_(FenceBlock.f_52312_, true), (BlockState)\u00e2\u02dc\u0192.m_61124_(FenceBlock.f_52312_, true), false);
                this.m_73441_(p_71713_, p_71717_, 11, 7, n, 11, 8, n, (BlockState)\u00e2\u02dc\u0192.m_61124_(FenceBlock.f_52310_, true), (BlockState)\u00e2\u02dc\u0192.m_61124_(FenceBlock.f_52310_, true), false);
            }
            this.m_73441_(p_71713_, p_71717_, 4, 2, 0, 8, 2, 12, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71713_, p_71717_, 0, 2, 4, 12, 2, 8, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71713_, p_71717_, 4, 0, 0, 8, 1, 3, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71713_, p_71717_, 4, 0, 9, 8, 1, 12, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71713_, p_71717_, 0, 0, 4, 3, 1, 8, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71713_, p_71717_, 9, 0, 4, 12, 1, 8, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            for (n = 4; n <= 8; ++n) {
                for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 <= 2; ++\u00e2\u02dc\u0192) {
                    this.m_73528_(p_71713_, Blocks.f_50197_.m_49966_(), n, -1, \u00e2\u02dc\u0192, p_71717_);
                    this.m_73528_(p_71713_, Blocks.f_50197_.m_49966_(), n, -1, 12 - \u00e2\u02dc\u0192, p_71717_);
                }
            }
            for (n = 0; n <= 2; ++n) {
                for (\u00e2\u02dc\u0192 = 4; \u00e2\u02dc\u0192 <= 8; ++\u00e2\u02dc\u0192) {
                    this.m_73528_(p_71713_, Blocks.f_50197_.m_49966_(), n, -1, \u00e2\u02dc\u0192, p_71717_);
                    this.m_73528_(p_71713_, Blocks.f_50197_.m_49966_(), 12 - n, -1, \u00e2\u02dc\u0192, p_71717_);
                }
            }
            this.m_73441_(p_71713_, p_71717_, 5, 5, 5, 7, 5, 7, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71713_, p_71717_, 6, 1, 6, 6, 4, 6, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), false);
            this.m_73434_(p_71713_, Blocks.f_50197_.m_49966_(), 6, 0, 6, p_71717_);
            this.m_73434_(p_71713_, Blocks.f_49991_.m_49966_(), 6, 5, 6, p_71717_);
            BlockPos.MutableBlockPos mutableBlockPos = this.m_163582_(6, 5, 6);
            if (p_71717_.m_71051_(mutableBlockPos)) {
                p_71713_.m_6217_().m_5945_(mutableBlockPos, Fluids.f_76195_, 0);
            }
            return true;
        }
    }

    public static class CastleSmallCorridorPiece
    extends NetherBridgePiece {
        private static final int f_162779_ = 5;
        private static final int f_162780_ = 7;
        private static final int f_162781_ = 5;

        public CastleSmallCorridorPiece(int p_71790_, BoundingBox p_71791_, Direction p_71792_) {
            super(StructurePieceType.f_67148_, p_71790_, p_71791_);
            this.m_73519_(p_71792_);
        }

        public CastleSmallCorridorPiece(ServerLevel p_162783_, CompoundTag p_162784_) {
            super(StructurePieceType.f_67148_, p_162784_);
        }

        @Override
        public void m_142537_(StructurePiece p_162786_, StructurePieceAccessor p_162787_, Random p_162788_) {
            this.m_162867_((StartPiece)p_162786_, p_162787_, p_162788_, 1, 0, true);
        }

        public static CastleSmallCorridorPiece m_162789_(StructurePieceAccessor p_162790_, int p_162791_, int p_162792_, int p_162793_, Direction p_162794_, int p_162795_) {
            BoundingBox boundingBox = BoundingBox.m_71031_(p_162791_, p_162792_, p_162793_, -1, 0, 0, 5, 7, 5, p_162794_);
            if (!CastleSmallCorridorPiece.m_71903_(boundingBox) || p_162790_.m_141921_(boundingBox) != null) {
                return null;
            }
            return new CastleSmallCorridorPiece(p_162795_, boundingBox, p_162794_);
        }

        @Override
        public boolean m_7832_(WorldGenLevel p_71797_, StructureFeatureManager p_71798_, ChunkGenerator p_71799_, Random p_71800_, BoundingBox p_71801_, ChunkPos p_71802_, BlockPos p_71803_) {
            this.m_73441_(p_71797_, p_71801_, 0, 0, 0, 4, 1, 4, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71797_, p_71801_, 0, 2, 0, 4, 5, 4, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), false);
            BlockState blockState = (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52309_, true)).m_61124_(FenceBlock.f_52311_, true);
            this.m_73441_(p_71797_, p_71801_, 0, 2, 0, 0, 5, 4, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71797_, p_71801_, 4, 2, 0, 4, 5, 4, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71797_, p_71801_, 0, 3, 1, 0, 4, 1, blockState, blockState, false);
            this.m_73441_(p_71797_, p_71801_, 0, 3, 3, 0, 4, 3, blockState, blockState, false);
            this.m_73441_(p_71797_, p_71801_, 4, 3, 1, 4, 4, 1, blockState, blockState, false);
            this.m_73441_(p_71797_, p_71801_, 4, 3, 3, 4, 4, 3, blockState, blockState, false);
            this.m_73441_(p_71797_, p_71801_, 0, 6, 0, 4, 6, 4, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            for (int i = 0; i <= 4; ++i) {
                for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 <= 4; ++\u00e2\u02dc\u0192) {
                    this.m_73528_(p_71797_, Blocks.f_50197_.m_49966_(), i, -1, \u00e2\u02dc\u0192, p_71801_);
                }
            }
            return true;
        }
    }

    public static class CastleSmallCorridorRightTurnPiece
    extends NetherBridgePiece {
        private static final int f_162796_ = 5;
        private static final int f_162797_ = 7;
        private static final int f_162798_ = 5;
        private boolean f_71815_;

        public CastleSmallCorridorRightTurnPiece(int p_71817_, Random p_71818_, BoundingBox p_71819_, Direction p_71820_) {
            super(StructurePieceType.f_67149_, p_71817_, p_71819_);
            this.m_73519_(p_71820_);
            this.f_71815_ = p_71818_.nextInt(3) == 0;
        }

        public CastleSmallCorridorRightTurnPiece(ServerLevel p_162800_, CompoundTag p_162801_) {
            super(StructurePieceType.f_67149_, p_162801_);
            this.f_71815_ = p_162801_.m_128471_("Chest");
        }

        @Override
        protected void m_142347_(ServerLevel p_162803_, CompoundTag p_162804_) {
            super.m_142347_(p_162803_, p_162804_);
            p_162804_.m_128379_("Chest", this.f_71815_);
        }

        @Override
        public void m_142537_(StructurePiece p_162806_, StructurePieceAccessor p_162807_, Random p_162808_) {
            this.m_162891_((StartPiece)p_162806_, p_162807_, p_162808_, 0, 1, true);
        }

        public static CastleSmallCorridorRightTurnPiece m_162809_(StructurePieceAccessor p_162810_, Random p_162811_, int p_162812_, int p_162813_, int p_162814_, Direction p_162815_, int p_162816_) {
            BoundingBox boundingBox = BoundingBox.m_71031_(p_162812_, p_162813_, p_162814_, -1, 0, 0, 5, 7, 5, p_162815_);
            if (!CastleSmallCorridorRightTurnPiece.m_71903_(boundingBox) || p_162810_.m_141921_(boundingBox) != null) {
                return null;
            }
            return new CastleSmallCorridorRightTurnPiece(p_162816_, p_162811_, boundingBox, p_162815_);
        }

        @Override
        public boolean m_7832_(WorldGenLevel p_71825_, StructureFeatureManager p_71826_, ChunkGenerator p_71827_, Random p_71828_, BoundingBox p_71829_, ChunkPos p_71830_, BlockPos p_71831_) {
            this.m_73441_(p_71825_, p_71829_, 0, 0, 0, 4, 1, 4, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71825_, p_71829_, 0, 2, 0, 4, 5, 4, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), false);
            BlockState blockState = (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52312_, true)).m_61124_(FenceBlock.f_52310_, true);
            \u00e2\u02dc\u0192 = (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52309_, true)).m_61124_(FenceBlock.f_52311_, true);
            this.m_73441_(p_71825_, p_71829_, 0, 2, 0, 0, 5, 4, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71825_, p_71829_, 0, 3, 1, 0, 4, 1, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, false);
            this.m_73441_(p_71825_, p_71829_, 0, 3, 3, 0, 4, 3, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, false);
            this.m_73441_(p_71825_, p_71829_, 4, 2, 0, 4, 5, 0, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71825_, p_71829_, 1, 2, 4, 4, 5, 4, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71825_, p_71829_, 1, 3, 4, 1, 4, 4, blockState, blockState, false);
            this.m_73441_(p_71825_, p_71829_, 3, 3, 4, 3, 4, 4, blockState, blockState, false);
            if (this.f_71815_ && p_71829_.m_71051_(this.m_163582_(1, 2, 3))) {
                this.f_71815_ = false;
                this.m_5606_(p_71825_, p_71829_, p_71828_, 1, 2, 3, BuiltInLootTables.f_78760_);
            }
            this.m_73441_(p_71825_, p_71829_, 0, 6, 0, 4, 6, 4, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            for (int i = 0; i <= 4; ++i) {
                for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 <= 4; ++\u00e2\u02dc\u0192) {
                    this.m_73528_(p_71825_, Blocks.f_50197_.m_49966_(), i, -1, \u00e2\u02dc\u0192, p_71829_);
                }
            }
            return true;
        }
    }

    public static class CastleSmallCorridorLeftTurnPiece
    extends NetherBridgePiece {
        private static final int f_162758_ = 5;
        private static final int f_162759_ = 7;
        private static final int f_162760_ = 5;
        private boolean f_71758_;

        public CastleSmallCorridorLeftTurnPiece(int p_71760_, Random p_71761_, BoundingBox p_71762_, Direction p_71763_) {
            super(StructurePieceType.f_67147_, p_71760_, p_71762_);
            this.m_73519_(p_71763_);
            this.f_71758_ = p_71761_.nextInt(3) == 0;
        }

        public CastleSmallCorridorLeftTurnPiece(ServerLevel p_162762_, CompoundTag p_162763_) {
            super(StructurePieceType.f_67147_, p_162763_);
            this.f_71758_ = p_162763_.m_128471_("Chest");
        }

        @Override
        protected void m_142347_(ServerLevel p_162765_, CompoundTag p_162766_) {
            super.m_142347_(p_162765_, p_162766_);
            p_162766_.m_128379_("Chest", this.f_71758_);
        }

        @Override
        public void m_142537_(StructurePiece p_162768_, StructurePieceAccessor p_162769_, Random p_162770_) {
            this.m_162884_((StartPiece)p_162768_, p_162769_, p_162770_, 0, 1, true);
        }

        public static CastleSmallCorridorLeftTurnPiece m_162771_(StructurePieceAccessor p_162772_, Random p_162773_, int p_162774_, int p_162775_, int p_162776_, Direction p_162777_, int p_162778_) {
            BoundingBox boundingBox = BoundingBox.m_71031_(p_162774_, p_162775_, p_162776_, -1, 0, 0, 5, 7, 5, p_162777_);
            if (!CastleSmallCorridorLeftTurnPiece.m_71903_(boundingBox) || p_162772_.m_141921_(boundingBox) != null) {
                return null;
            }
            return new CastleSmallCorridorLeftTurnPiece(p_162778_, p_162773_, boundingBox, p_162777_);
        }

        @Override
        public boolean m_7832_(WorldGenLevel p_71768_, StructureFeatureManager p_71769_, ChunkGenerator p_71770_, Random p_71771_, BoundingBox p_71772_, ChunkPos p_71773_, BlockPos p_71774_) {
            this.m_73441_(p_71768_, p_71772_, 0, 0, 0, 4, 1, 4, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71768_, p_71772_, 0, 2, 0, 4, 5, 4, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), false);
            BlockState blockState = (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52312_, true)).m_61124_(FenceBlock.f_52310_, true);
            \u00e2\u02dc\u0192 = (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52309_, true)).m_61124_(FenceBlock.f_52311_, true);
            this.m_73441_(p_71768_, p_71772_, 4, 2, 0, 4, 5, 4, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71768_, p_71772_, 4, 3, 1, 4, 4, 1, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, false);
            this.m_73441_(p_71768_, p_71772_, 4, 3, 3, 4, 4, 3, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, false);
            this.m_73441_(p_71768_, p_71772_, 0, 2, 0, 0, 5, 0, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71768_, p_71772_, 0, 2, 4, 3, 5, 4, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71768_, p_71772_, 1, 3, 4, 1, 4, 4, blockState, blockState, false);
            this.m_73441_(p_71768_, p_71772_, 3, 3, 4, 3, 4, 4, blockState, blockState, false);
            if (this.f_71758_ && p_71772_.m_71051_(this.m_163582_(3, 2, 3))) {
                this.f_71758_ = false;
                this.m_5606_(p_71768_, p_71772_, p_71771_, 3, 2, 3, BuiltInLootTables.f_78760_);
            }
            this.m_73441_(p_71768_, p_71772_, 0, 6, 0, 4, 6, 4, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            for (int i = 0; i <= 4; ++i) {
                for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 <= 4; ++\u00e2\u02dc\u0192) {
                    this.m_73528_(p_71768_, Blocks.f_50197_.m_49966_(), i, -1, \u00e2\u02dc\u0192, p_71772_);
                }
            }
            return true;
        }
    }

    public static class CastleCorridorStairsPiece
    extends NetherBridgePiece {
        private static final int f_162689_ = 5;
        private static final int f_162690_ = 14;
        private static final int f_162691_ = 10;

        public CastleCorridorStairsPiece(int p_71653_, BoundingBox p_71654_, Direction p_71655_) {
            super(StructurePieceType.f_67143_, p_71653_, p_71654_);
            this.m_73519_(p_71655_);
        }

        public CastleCorridorStairsPiece(ServerLevel p_162693_, CompoundTag p_162694_) {
            super(StructurePieceType.f_67143_, p_162694_);
        }

        @Override
        public void m_142537_(StructurePiece p_162696_, StructurePieceAccessor p_162697_, Random p_162698_) {
            this.m_162867_((StartPiece)p_162696_, p_162697_, p_162698_, 1, 0, true);
        }

        public static CastleCorridorStairsPiece m_162699_(StructurePieceAccessor p_162700_, int p_162701_, int p_162702_, int p_162703_, Direction p_162704_, int p_162705_) {
            BoundingBox boundingBox = BoundingBox.m_71031_(p_162701_, p_162702_, p_162703_, -1, -7, 0, 5, 14, 10, p_162704_);
            if (!CastleCorridorStairsPiece.m_71903_(boundingBox) || p_162700_.m_141921_(boundingBox) != null) {
                return null;
            }
            return new CastleCorridorStairsPiece(p_162705_, boundingBox, p_162704_);
        }

        @Override
        public boolean m_7832_(WorldGenLevel p_71660_, StructureFeatureManager p_71661_, ChunkGenerator p_71662_, Random p_71663_, BoundingBox p_71664_, ChunkPos p_71665_, BlockPos p_71666_) {
            BlockState blockState = (BlockState)Blocks.f_50199_.m_49966_().m_61124_(StairBlock.f_56841_, Direction.SOUTH);
            \u00e2\u02dc\u0192 = (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52309_, true)).m_61124_(FenceBlock.f_52311_, true);
            for (int i = 0; i <= 9; ++i) {
                \u00e2\u02dc\u0192 = Math.max(1, 7 - i);
                \u00e2\u02dc\u0192 = Math.min(Math.max(\u00e2\u02dc\u0192 + 5, 14 - i), 13);
                \u00e2\u02dc\u0192 = i;
                this.m_73441_(p_71660_, p_71664_, 0, 0, \u00e2\u02dc\u0192, 4, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
                this.m_73441_(p_71660_, p_71664_, 1, \u00e2\u02dc\u0192 + 1, \u00e2\u02dc\u0192, 3, \u00e2\u02dc\u0192 - 1, \u00e2\u02dc\u0192, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), false);
                if (i <= 6) {
                    this.m_73434_(p_71660_, blockState, 1, \u00e2\u02dc\u0192 + 1, \u00e2\u02dc\u0192, p_71664_);
                    this.m_73434_(p_71660_, blockState, 2, \u00e2\u02dc\u0192 + 1, \u00e2\u02dc\u0192, p_71664_);
                    this.m_73434_(p_71660_, blockState, 3, \u00e2\u02dc\u0192 + 1, \u00e2\u02dc\u0192, p_71664_);
                }
                this.m_73441_(p_71660_, p_71664_, 0, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, 4, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
                this.m_73441_(p_71660_, p_71664_, 0, \u00e2\u02dc\u0192 + 1, \u00e2\u02dc\u0192, 0, \u00e2\u02dc\u0192 - 1, \u00e2\u02dc\u0192, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
                this.m_73441_(p_71660_, p_71664_, 4, \u00e2\u02dc\u0192 + 1, \u00e2\u02dc\u0192, 4, \u00e2\u02dc\u0192 - 1, \u00e2\u02dc\u0192, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
                if ((i & 1) == 0) {
                    this.m_73441_(p_71660_, p_71664_, 0, \u00e2\u02dc\u0192 + 2, \u00e2\u02dc\u0192, 0, \u00e2\u02dc\u0192 + 3, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, false);
                    this.m_73441_(p_71660_, p_71664_, 4, \u00e2\u02dc\u0192 + 2, \u00e2\u02dc\u0192, 4, \u00e2\u02dc\u0192 + 3, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, false);
                }
                for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 <= 4; ++\u00e2\u02dc\u0192) {
                    this.m_73528_(p_71660_, Blocks.f_50197_.m_49966_(), \u00e2\u02dc\u0192, -1, \u00e2\u02dc\u0192, p_71664_);
                }
            }
            return true;
        }
    }

    public static class CastleCorridorTBalconyPiece
    extends NetherBridgePiece {
        private static final int f_162706_ = 9;
        private static final int f_162707_ = 7;
        private static final int f_162708_ = 9;

        public CastleCorridorTBalconyPiece(int p_71679_, BoundingBox p_71680_, Direction p_71681_) {
            super(StructurePieceType.f_67144_, p_71679_, p_71680_);
            this.m_73519_(p_71681_);
        }

        public CastleCorridorTBalconyPiece(ServerLevel p_162710_, CompoundTag p_162711_) {
            super(StructurePieceType.f_67144_, p_162711_);
        }

        @Override
        public void m_142537_(StructurePiece p_162713_, StructurePieceAccessor p_162714_, Random p_162715_) {
            int n = 1;
            Direction \u00e2\u02dc\u01922 = this.m_73549_();
            if (\u00e2\u02dc\u01922 == Direction.WEST || \u00e2\u02dc\u01922 == Direction.NORTH) {
                n = 5;
            }
            this.m_162884_((StartPiece)p_162713_, p_162714_, p_162715_, 0, n, p_162715_.nextInt(8) > 0);
            this.m_162891_((StartPiece)p_162713_, p_162714_, p_162715_, 0, n, p_162715_.nextInt(8) > 0);
        }

        public static CastleCorridorTBalconyPiece m_162716_(StructurePieceAccessor p_162717_, int p_162718_, int p_162719_, int p_162720_, Direction p_162721_, int p_162722_) {
            BoundingBox boundingBox = BoundingBox.m_71031_(p_162718_, p_162719_, p_162720_, -3, 0, 0, 9, 7, 9, p_162721_);
            if (!CastleCorridorTBalconyPiece.m_71903_(boundingBox) || p_162717_.m_141921_(boundingBox) != null) {
                return null;
            }
            return new CastleCorridorTBalconyPiece(p_162722_, boundingBox, p_162721_);
        }

        @Override
        public boolean m_7832_(WorldGenLevel p_71686_, StructureFeatureManager p_71687_, ChunkGenerator p_71688_, Random p_71689_, BoundingBox p_71690_, ChunkPos p_71691_, BlockPos p_71692_) {
            BlockState blockState = (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52309_, true)).m_61124_(FenceBlock.f_52311_, true);
            \u00e2\u02dc\u0192 = (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52312_, true)).m_61124_(FenceBlock.f_52310_, true);
            this.m_73441_(p_71686_, p_71690_, 0, 0, 0, 8, 1, 8, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71686_, p_71690_, 0, 2, 0, 8, 5, 8, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), false);
            this.m_73441_(p_71686_, p_71690_, 0, 6, 0, 8, 6, 5, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71686_, p_71690_, 0, 2, 0, 2, 5, 0, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71686_, p_71690_, 6, 2, 0, 8, 5, 0, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71686_, p_71690_, 1, 3, 0, 1, 4, 0, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, false);
            this.m_73441_(p_71686_, p_71690_, 7, 3, 0, 7, 4, 0, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, false);
            this.m_73441_(p_71686_, p_71690_, 0, 2, 4, 8, 2, 8, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71686_, p_71690_, 1, 1, 4, 2, 2, 4, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), false);
            this.m_73441_(p_71686_, p_71690_, 6, 1, 4, 7, 2, 4, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), false);
            this.m_73441_(p_71686_, p_71690_, 1, 3, 8, 7, 3, 8, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, false);
            this.m_73434_(p_71686_, (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52310_, true)).m_61124_(FenceBlock.f_52311_, true), 0, 3, 8, p_71690_);
            this.m_73434_(p_71686_, (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52312_, true)).m_61124_(FenceBlock.f_52311_, true), 8, 3, 8, p_71690_);
            this.m_73441_(p_71686_, p_71690_, 0, 3, 6, 0, 3, 7, blockState, blockState, false);
            this.m_73441_(p_71686_, p_71690_, 8, 3, 6, 8, 3, 7, blockState, blockState, false);
            this.m_73441_(p_71686_, p_71690_, 0, 3, 4, 0, 5, 5, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71686_, p_71690_, 8, 3, 4, 8, 5, 5, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71686_, p_71690_, 1, 3, 5, 2, 5, 5, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71686_, p_71690_, 6, 3, 5, 7, 5, 5, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71686_, p_71690_, 1, 4, 5, 1, 5, 5, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, false);
            this.m_73441_(p_71686_, p_71690_, 7, 4, 5, 7, 5, 5, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, false);
            for (int i = 0; i <= 5; ++i) {
                for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 <= 8; ++\u00e2\u02dc\u0192) {
                    this.m_73528_(p_71686_, Blocks.f_50197_.m_49966_(), \u00e2\u02dc\u0192, -1, i, p_71690_);
                }
            }
            return true;
        }
    }

    public static class CastleSmallCorridorCrossingPiece
    extends NetherBridgePiece {
        private static final int f_162741_ = 5;
        private static final int f_162742_ = 7;
        private static final int f_162743_ = 5;

        public CastleSmallCorridorCrossingPiece(int p_71733_, BoundingBox p_71734_, Direction p_71735_) {
            super(StructurePieceType.f_67146_, p_71733_, p_71734_);
            this.m_73519_(p_71735_);
        }

        public CastleSmallCorridorCrossingPiece(ServerLevel p_162745_, CompoundTag p_162746_) {
            super(StructurePieceType.f_67146_, p_162746_);
        }

        @Override
        public void m_142537_(StructurePiece p_162748_, StructurePieceAccessor p_162749_, Random p_162750_) {
            this.m_162867_((StartPiece)p_162748_, p_162749_, p_162750_, 1, 0, true);
            this.m_162884_((StartPiece)p_162748_, p_162749_, p_162750_, 0, 1, true);
            this.m_162891_((StartPiece)p_162748_, p_162749_, p_162750_, 0, 1, true);
        }

        public static CastleSmallCorridorCrossingPiece m_162751_(StructurePieceAccessor p_162752_, int p_162753_, int p_162754_, int p_162755_, Direction p_162756_, int p_162757_) {
            BoundingBox boundingBox = BoundingBox.m_71031_(p_162753_, p_162754_, p_162755_, -1, 0, 0, 5, 7, 5, p_162756_);
            if (!CastleSmallCorridorCrossingPiece.m_71903_(boundingBox) || p_162752_.m_141921_(boundingBox) != null) {
                return null;
            }
            return new CastleSmallCorridorCrossingPiece(p_162757_, boundingBox, p_162756_);
        }

        @Override
        public boolean m_7832_(WorldGenLevel p_71740_, StructureFeatureManager p_71741_, ChunkGenerator p_71742_, Random p_71743_, BoundingBox p_71744_, ChunkPos p_71745_, BlockPos p_71746_) {
            this.m_73441_(p_71740_, p_71744_, 0, 0, 0, 4, 1, 4, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71740_, p_71744_, 0, 2, 0, 4, 5, 4, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), false);
            this.m_73441_(p_71740_, p_71744_, 0, 2, 0, 0, 5, 0, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71740_, p_71744_, 4, 2, 0, 4, 5, 0, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71740_, p_71744_, 0, 2, 4, 0, 5, 4, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71740_, p_71744_, 4, 2, 4, 4, 5, 4, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71740_, p_71744_, 0, 6, 0, 4, 6, 4, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            for (int i = 0; i <= 4; ++i) {
                for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 <= 4; ++\u00e2\u02dc\u0192) {
                    this.m_73528_(p_71740_, Blocks.f_50197_.m_49966_(), i, -1, \u00e2\u02dc\u0192, p_71744_);
                }
            }
            return true;
        }
    }

    public static class CastleStalkRoom
    extends NetherBridgePiece {
        private static final int f_162817_ = 13;
        private static final int f_162818_ = 14;
        private static final int f_162819_ = 13;

        public CastleStalkRoom(int p_71847_, BoundingBox p_71848_, Direction p_71849_) {
            super(StructurePieceType.f_67150_, p_71847_, p_71848_);
            this.m_73519_(p_71849_);
        }

        public CastleStalkRoom(ServerLevel p_162821_, CompoundTag p_162822_) {
            super(StructurePieceType.f_67150_, p_162822_);
        }

        @Override
        public void m_142537_(StructurePiece p_162824_, StructurePieceAccessor p_162825_, Random p_162826_) {
            this.m_162867_((StartPiece)p_162824_, p_162825_, p_162826_, 5, 3, true);
            this.m_162867_((StartPiece)p_162824_, p_162825_, p_162826_, 5, 11, true);
        }

        public static CastleStalkRoom m_162827_(StructurePieceAccessor p_162828_, int p_162829_, int p_162830_, int p_162831_, Direction p_162832_, int p_162833_) {
            BoundingBox boundingBox = BoundingBox.m_71031_(p_162829_, p_162830_, p_162831_, -5, -3, 0, 13, 14, 13, p_162832_);
            if (!CastleStalkRoom.m_71903_(boundingBox) || p_162828_.m_141921_(boundingBox) != null) {
                return null;
            }
            return new CastleStalkRoom(p_162833_, boundingBox, p_162832_);
        }

        @Override
        public boolean m_7832_(WorldGenLevel p_71854_, StructureFeatureManager p_71855_, ChunkGenerator p_71856_, Random p_71857_, BoundingBox p_71858_, ChunkPos p_71859_, BlockPos p_71860_) {
            int n;
            BlockState blockState;
            int n2;
            int n3;
            this.m_73441_(p_71854_, p_71858_, 0, 3, 0, 12, 4, 12, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71854_, p_71858_, 0, 5, 0, 12, 13, 12, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), false);
            this.m_73441_(p_71854_, p_71858_, 0, 5, 0, 1, 12, 12, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71854_, p_71858_, 11, 5, 0, 12, 12, 12, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71854_, p_71858_, 2, 5, 11, 4, 12, 12, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71854_, p_71858_, 8, 5, 11, 10, 12, 12, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71854_, p_71858_, 5, 9, 11, 7, 12, 12, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71854_, p_71858_, 2, 5, 0, 4, 12, 1, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71854_, p_71858_, 8, 5, 0, 10, 12, 1, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71854_, p_71858_, 5, 9, 0, 7, 12, 1, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71854_, p_71858_, 2, 11, 2, 10, 12, 10, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            BlockState blockState2 = (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52312_, true)).m_61124_(FenceBlock.f_52310_, true);
            \u00e2\u02dc\u0192 = (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52309_, true)).m_61124_(FenceBlock.f_52311_, true);
            \u00e2\u02dc\u0192 = (BlockState)\u00e2\u02dc\u0192.m_61124_(FenceBlock.f_52312_, true);
            blockState = (BlockState)\u00e2\u02dc\u0192.m_61124_(FenceBlock.f_52310_, true);
            for (n3 = 1; n3 <= 11; n3 += 2) {
                this.m_73441_(p_71854_, p_71858_, n3, 10, 0, n3, 11, 0, blockState2, blockState2, false);
                this.m_73441_(p_71854_, p_71858_, n3, 10, 12, n3, 11, 12, blockState2, blockState2, false);
                this.m_73441_(p_71854_, p_71858_, 0, 10, n3, 0, 11, n3, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, false);
                this.m_73441_(p_71854_, p_71858_, 12, 10, n3, 12, 11, n3, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, false);
                this.m_73434_(p_71854_, Blocks.f_50197_.m_49966_(), n3, 13, 0, p_71858_);
                this.m_73434_(p_71854_, Blocks.f_50197_.m_49966_(), n3, 13, 12, p_71858_);
                this.m_73434_(p_71854_, Blocks.f_50197_.m_49966_(), 0, 13, n3, p_71858_);
                this.m_73434_(p_71854_, Blocks.f_50197_.m_49966_(), 12, 13, n3, p_71858_);
                if (n3 == 11) continue;
                this.m_73434_(p_71854_, blockState2, n3 + 1, 13, 0, p_71858_);
                this.m_73434_(p_71854_, blockState2, n3 + 1, 13, 12, p_71858_);
                this.m_73434_(p_71854_, \u00e2\u02dc\u0192, 0, 13, n3 + 1, p_71858_);
                this.m_73434_(p_71854_, \u00e2\u02dc\u0192, 12, 13, n3 + 1, p_71858_);
            }
            this.m_73434_(p_71854_, (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52309_, true)).m_61124_(FenceBlock.f_52310_, true), 0, 13, 0, p_71858_);
            this.m_73434_(p_71854_, (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52311_, true)).m_61124_(FenceBlock.f_52310_, true), 0, 13, 12, p_71858_);
            this.m_73434_(p_71854_, (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52311_, true)).m_61124_(FenceBlock.f_52312_, true), 12, 13, 12, p_71858_);
            this.m_73434_(p_71854_, (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52309_, true)).m_61124_(FenceBlock.f_52312_, true), 12, 13, 0, p_71858_);
            for (n3 = 3; n3 <= 9; n3 += 2) {
                this.m_73441_(p_71854_, p_71858_, 1, 7, n3, 1, 8, n3, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, false);
                this.m_73441_(p_71854_, p_71858_, 11, 7, n3, 11, 8, n3, blockState, blockState, false);
            }
            BlockState blockState3 = (BlockState)Blocks.f_50199_.m_49966_().m_61124_(StairBlock.f_56841_, Direction.NORTH);
            for (n2 = 0; n2 <= 6; ++n2) {
                \u00e2\u02dc\u0192 = n2 + 4;
                for (n = 5; n <= 7; ++n) {
                    this.m_73434_(p_71854_, blockState3, n, 5 + n2, \u00e2\u02dc\u0192, p_71858_);
                }
                if (\u00e2\u02dc\u0192 >= 5 && \u00e2\u02dc\u0192 <= 8) {
                    this.m_73441_(p_71854_, p_71858_, 5, 5, \u00e2\u02dc\u0192, 7, n2 + 4, \u00e2\u02dc\u0192, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
                } else if (\u00e2\u02dc\u0192 >= 9 && \u00e2\u02dc\u0192 <= 10) {
                    this.m_73441_(p_71854_, p_71858_, 5, 8, \u00e2\u02dc\u0192, 7, n2 + 4, \u00e2\u02dc\u0192, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
                }
                if (n2 < 1) continue;
                this.m_73441_(p_71854_, p_71858_, 5, 6 + n2, \u00e2\u02dc\u0192, 7, 9 + n2, \u00e2\u02dc\u0192, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), false);
            }
            for (n2 = 5; n2 <= 7; ++n2) {
                this.m_73434_(p_71854_, blockState3, n2, 12, 11, p_71858_);
            }
            this.m_73441_(p_71854_, p_71858_, 5, 6, 7, 5, 7, 7, blockState, blockState, false);
            this.m_73441_(p_71854_, p_71858_, 7, 6, 7, 7, 7, 7, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, false);
            this.m_73441_(p_71854_, p_71858_, 5, 13, 12, 7, 13, 12, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), false);
            this.m_73441_(p_71854_, p_71858_, 2, 5, 2, 3, 5, 3, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71854_, p_71858_, 2, 5, 9, 3, 5, 10, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71854_, p_71858_, 2, 5, 4, 2, 5, 8, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71854_, p_71858_, 9, 5, 2, 10, 5, 3, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71854_, p_71858_, 9, 5, 9, 10, 5, 10, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71854_, p_71858_, 10, 5, 4, 10, 5, 8, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            \u00e2\u02dc\u0192 = (BlockState)blockState3.m_61124_(StairBlock.f_56841_, Direction.EAST);
            \u00e2\u02dc\u0192 = (BlockState)blockState3.m_61124_(StairBlock.f_56841_, Direction.WEST);
            this.m_73434_(p_71854_, \u00e2\u02dc\u0192, 4, 5, 2, p_71858_);
            this.m_73434_(p_71854_, \u00e2\u02dc\u0192, 4, 5, 3, p_71858_);
            this.m_73434_(p_71854_, \u00e2\u02dc\u0192, 4, 5, 9, p_71858_);
            this.m_73434_(p_71854_, \u00e2\u02dc\u0192, 4, 5, 10, p_71858_);
            this.m_73434_(p_71854_, \u00e2\u02dc\u0192, 8, 5, 2, p_71858_);
            this.m_73434_(p_71854_, \u00e2\u02dc\u0192, 8, 5, 3, p_71858_);
            this.m_73434_(p_71854_, \u00e2\u02dc\u0192, 8, 5, 9, p_71858_);
            this.m_73434_(p_71854_, \u00e2\u02dc\u0192, 8, 5, 10, p_71858_);
            this.m_73441_(p_71854_, p_71858_, 3, 4, 4, 4, 4, 8, Blocks.f_50135_.m_49966_(), Blocks.f_50135_.m_49966_(), false);
            this.m_73441_(p_71854_, p_71858_, 8, 4, 4, 9, 4, 8, Blocks.f_50135_.m_49966_(), Blocks.f_50135_.m_49966_(), false);
            this.m_73441_(p_71854_, p_71858_, 3, 5, 4, 4, 5, 8, Blocks.f_50200_.m_49966_(), Blocks.f_50200_.m_49966_(), false);
            this.m_73441_(p_71854_, p_71858_, 8, 5, 4, 9, 5, 8, Blocks.f_50200_.m_49966_(), Blocks.f_50200_.m_49966_(), false);
            this.m_73441_(p_71854_, p_71858_, 4, 2, 0, 8, 2, 12, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71854_, p_71858_, 0, 2, 4, 12, 2, 8, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71854_, p_71858_, 4, 0, 0, 8, 1, 3, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71854_, p_71858_, 4, 0, 9, 8, 1, 12, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71854_, p_71858_, 0, 0, 4, 3, 1, 8, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_71854_, p_71858_, 9, 0, 4, 12, 1, 8, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            for (n = 4; n <= 8; ++n) {
                for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 <= 2; ++\u00e2\u02dc\u0192) {
                    this.m_73528_(p_71854_, Blocks.f_50197_.m_49966_(), n, -1, \u00e2\u02dc\u0192, p_71858_);
                    this.m_73528_(p_71854_, Blocks.f_50197_.m_49966_(), n, -1, 12 - \u00e2\u02dc\u0192, p_71858_);
                }
            }
            for (n = 0; n <= 2; ++n) {
                for (\u00e2\u02dc\u0192 = 4; \u00e2\u02dc\u0192 <= 8; ++\u00e2\u02dc\u0192) {
                    this.m_73528_(p_71854_, Blocks.f_50197_.m_49966_(), n, -1, \u00e2\u02dc\u0192, p_71858_);
                    this.m_73528_(p_71854_, Blocks.f_50197_.m_49966_(), 12 - n, -1, \u00e2\u02dc\u0192, p_71858_);
                }
            }
            return true;
        }
    }

    public static class BridgeEndFiller
    extends NetherBridgePiece {
        private static final int f_162654_ = 5;
        private static final int f_162655_ = 10;
        private static final int f_162656_ = 8;
        private final int f_71597_;

        public BridgeEndFiller(int p_71599_, Random p_71600_, BoundingBox p_71601_, Direction p_71602_) {
            super(StructurePieceType.f_67141_, p_71599_, p_71601_);
            this.m_73519_(p_71602_);
            this.f_71597_ = p_71600_.nextInt();
        }

        public BridgeEndFiller(ServerLevel p_162658_, CompoundTag p_162659_) {
            super(StructurePieceType.f_67141_, p_162659_);
            this.f_71597_ = p_162659_.m_128451_("Seed");
        }

        public static BridgeEndFiller m_162663_(StructurePieceAccessor p_162664_, Random p_162665_, int p_162666_, int p_162667_, int p_162668_, Direction p_162669_, int p_162670_) {
            BoundingBox boundingBox = BoundingBox.m_71031_(p_162666_, p_162667_, p_162668_, -1, -3, 0, 5, 10, 8, p_162669_);
            if (!BridgeEndFiller.m_71903_(boundingBox) || p_162664_.m_141921_(boundingBox) != null) {
                return null;
            }
            return new BridgeEndFiller(p_162670_, p_162665_, boundingBox, p_162669_);
        }

        @Override
        protected void m_142347_(ServerLevel p_162661_, CompoundTag p_162662_) {
            super.m_142347_(p_162661_, p_162662_);
            p_162662_.m_128405_("Seed", this.f_71597_);
        }

        @Override
        public boolean m_7832_(WorldGenLevel p_71607_, StructureFeatureManager p_71608_, ChunkGenerator p_71609_, Random p_71610_, BoundingBox p_71611_, ChunkPos p_71612_, BlockPos p_71613_) {
            int n;
            int \u00e2\u02dc\u01922;
            Random random = new Random(this.f_71597_);
            for (\u00e2\u02dc\u01922 = 0; \u00e2\u02dc\u01922 <= 4; ++\u00e2\u02dc\u01922) {
                for (n = 3; n <= 4; ++n) {
                    \u00e2\u02dc\u0192 = random.nextInt(8);
                    this.m_73441_(p_71607_, p_71611_, \u00e2\u02dc\u01922, n, 0, \u00e2\u02dc\u01922, n, \u00e2\u02dc\u0192, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
                }
            }
            \u00e2\u02dc\u01922 = random.nextInt(8);
            this.m_73441_(p_71607_, p_71611_, 0, 5, 0, 0, 5, \u00e2\u02dc\u01922, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            \u00e2\u02dc\u01922 = random.nextInt(8);
            this.m_73441_(p_71607_, p_71611_, 4, 5, 0, 4, 5, \u00e2\u02dc\u01922, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            for (\u00e2\u02dc\u01922 = 0; \u00e2\u02dc\u01922 <= 4; ++\u00e2\u02dc\u01922) {
                n = random.nextInt(5);
                this.m_73441_(p_71607_, p_71611_, \u00e2\u02dc\u01922, 2, 0, \u00e2\u02dc\u01922, 2, n, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            }
            for (\u00e2\u02dc\u01922 = 0; \u00e2\u02dc\u01922 <= 4; ++\u00e2\u02dc\u01922) {
                for (n = 0; n <= 1; ++n) {
                    \u00e2\u02dc\u0192 = random.nextInt(3);
                    this.m_73441_(p_71607_, p_71611_, \u00e2\u02dc\u01922, n, 0, \u00e2\u02dc\u01922, n, \u00e2\u02dc\u0192, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
                }
            }
            return true;
        }
    }

    public static class StartPiece
    extends BridgeCrossing {
        public PieceWeight f_72019_;
        public List<PieceWeight> f_72020_;
        public List<PieceWeight> f_72021_;
        public final List<StructurePiece> f_72022_ = Lists.newArrayList();

        public StartPiece(Random p_72027_, int p_72028_, int p_72029_) {
            super(p_72028_, p_72029_, StartPiece.m_163580_(p_72027_));
            this.f_72020_ = Lists.newArrayList();
            for (PieceWeight pieceWeight : f_71539_) {
                pieceWeight.f_71952_ = 0;
                this.f_72020_.add(pieceWeight);
            }
            this.f_72021_ = Lists.newArrayList();
            for (PieceWeight pieceWeight : f_71540_) {
                pieceWeight.f_71952_ = 0;
                this.f_72021_.add(pieceWeight);
            }
        }

        public StartPiece(ServerLevel p_162933_, CompoundTag p_162934_) {
            super(StructurePieceType.f_67154_, p_162934_);
        }
    }

    static abstract class NetherBridgePiece
    extends StructurePiece {
        protected NetherBridgePiece(StructurePieceType p_162851_, int p_162852_, BoundingBox p_162853_) {
            super(p_162851_, p_162852_, p_162853_);
        }

        public NetherBridgePiece(StructurePieceType p_71901_, CompoundTag p_71902_) {
            super(p_71901_, p_71902_);
        }

        @Override
        protected void m_142347_(ServerLevel p_162855_, CompoundTag p_162856_) {
        }

        private int m_71932_(List<PieceWeight> p_71933_) {
            boolean bl = false;
            int \u00e2\u02dc\u01922 = 0;
            for (PieceWeight pieceWeight2 : p_71933_) {
                PieceWeight pieceWeight2;
                if (pieceWeight2.f_71953_ > 0 && pieceWeight2.f_71952_ < pieceWeight2.f_71953_) {
                    bl = true;
                }
                \u00e2\u02dc\u01922 += pieceWeight2.f_71951_;
            }
            return bl ? \u00e2\u02dc\u01922 : -1;
        }

        private NetherBridgePiece m_162874_(StartPiece p_162875_, List<PieceWeight> p_162876_, StructurePieceAccessor p_162877_, Random p_162878_, int p_162879_, int p_162880_, int p_162881_, Direction p_162882_, int p_162883_) {
            int n = this.m_71932_(p_162876_);
            boolean \u00e2\u02dc\u01922 = n > 0 && p_162883_ <= 30;
            \u00e2\u02dc\u0192 = 0;
            block0: while (\u00e2\u02dc\u0192 < 5 && \u00e2\u02dc\u01922) {
                ++\u00e2\u02dc\u0192;
                \u00e2\u02dc\u0192 = p_162878_.nextInt(n);
                for (PieceWeight pieceWeight : p_162876_) {
                    if ((\u00e2\u02dc\u0192 -= pieceWeight.f_71951_) >= 0) continue;
                    if (!pieceWeight.m_71965_(p_162883_) || pieceWeight == p_162875_.f_72019_ && !pieceWeight.f_71954_) continue block0;
                    NetherBridgePiece netherBridgePiece = NetherBridgePieces.m_162624_(pieceWeight, p_162877_, p_162878_, p_162879_, p_162880_, p_162881_, p_162882_, p_162883_);
                    if (netherBridgePiece == null) continue;
                    ++pieceWeight.f_71952_;
                    p_162875_.f_72019_ = pieceWeight;
                    if (!pieceWeight.m_71964_()) {
                        p_162876_.remove(pieceWeight);
                    }
                    return netherBridgePiece;
                }
            }
            return BridgeEndFiller.m_162663_(p_162877_, p_162878_, p_162879_, p_162880_, p_162881_, p_162882_, p_162883_);
        }

        private StructurePiece m_162857_(StartPiece p_162858_, StructurePieceAccessor p_162859_, Random p_162860_, int p_162861_, int p_162862_, int p_162863_, @Nullable Direction p_162864_, int p_162865_, boolean p_162866_) {
            if (Math.abs(p_162861_ - p_162858_.m_73547_().m_162395_()) > 112 || Math.abs(p_162863_ - p_162858_.m_73547_().m_162398_()) > 112) {
                return BridgeEndFiller.m_162663_(p_162859_, p_162860_, p_162861_, p_162862_, p_162863_, p_162864_, p_162865_);
            }
            List<PieceWeight> list = p_162858_.f_72020_;
            if (p_162866_) {
                list = p_162858_.f_72021_;
            }
            if ((\u00e2\u02dc\u0192 = this.m_162874_(p_162858_, list, p_162859_, p_162860_, p_162861_, p_162862_, p_162863_, p_162864_, p_162865_ + 1)) != null) {
                p_162859_.m_142679_(\u00e2\u02dc\u0192);
                p_162858_.f_72022_.add(\u00e2\u02dc\u0192);
            }
            return \u00e2\u02dc\u0192;
        }

        @Nullable
        protected StructurePiece m_162867_(StartPiece p_162868_, StructurePieceAccessor p_162869_, Random p_162870_, int p_162871_, int p_162872_, boolean p_162873_) {
            Direction direction = this.m_73549_();
            if (direction != null) {
                switch (direction) {
                    case NORTH: {
                        return this.m_162857_(p_162868_, p_162869_, p_162870_, this.f_73383_.m_162395_() + p_162871_, this.f_73383_.m_162396_() + p_162872_, this.f_73383_.m_162398_() - 1, direction, this.m_73548_(), p_162873_);
                    }
                    case SOUTH: {
                        return this.m_162857_(p_162868_, p_162869_, p_162870_, this.f_73383_.m_162395_() + p_162871_, this.f_73383_.m_162396_() + p_162872_, this.f_73383_.m_162401_() + 1, direction, this.m_73548_(), p_162873_);
                    }
                    case WEST: {
                        return this.m_162857_(p_162868_, p_162869_, p_162870_, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_() + p_162872_, this.f_73383_.m_162398_() + p_162871_, direction, this.m_73548_(), p_162873_);
                    }
                    case EAST: {
                        return this.m_162857_(p_162868_, p_162869_, p_162870_, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_() + p_162872_, this.f_73383_.m_162398_() + p_162871_, direction, this.m_73548_(), p_162873_);
                    }
                }
            }
            return null;
        }

        @Nullable
        protected StructurePiece m_162884_(StartPiece p_162885_, StructurePieceAccessor p_162886_, Random p_162887_, int p_162888_, int p_162889_, boolean p_162890_) {
            Direction direction = this.m_73549_();
            if (direction != null) {
                switch (direction) {
                    case NORTH: {
                        return this.m_162857_(p_162885_, p_162886_, p_162887_, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_() + p_162888_, this.f_73383_.m_162398_() + p_162889_, Direction.WEST, this.m_73548_(), p_162890_);
                    }
                    case SOUTH: {
                        return this.m_162857_(p_162885_, p_162886_, p_162887_, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_() + p_162888_, this.f_73383_.m_162398_() + p_162889_, Direction.WEST, this.m_73548_(), p_162890_);
                    }
                    case WEST: {
                        return this.m_162857_(p_162885_, p_162886_, p_162887_, this.f_73383_.m_162395_() + p_162889_, this.f_73383_.m_162396_() + p_162888_, this.f_73383_.m_162398_() - 1, Direction.NORTH, this.m_73548_(), p_162890_);
                    }
                    case EAST: {
                        return this.m_162857_(p_162885_, p_162886_, p_162887_, this.f_73383_.m_162395_() + p_162889_, this.f_73383_.m_162396_() + p_162888_, this.f_73383_.m_162398_() - 1, Direction.NORTH, this.m_73548_(), p_162890_);
                    }
                }
            }
            return null;
        }

        @Nullable
        protected StructurePiece m_162891_(StartPiece p_162892_, StructurePieceAccessor p_162893_, Random p_162894_, int p_162895_, int p_162896_, boolean p_162897_) {
            Direction direction = this.m_73549_();
            if (direction != null) {
                switch (direction) {
                    case NORTH: {
                        return this.m_162857_(p_162892_, p_162893_, p_162894_, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_() + p_162895_, this.f_73383_.m_162398_() + p_162896_, Direction.EAST, this.m_73548_(), p_162897_);
                    }
                    case SOUTH: {
                        return this.m_162857_(p_162892_, p_162893_, p_162894_, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_() + p_162895_, this.f_73383_.m_162398_() + p_162896_, Direction.EAST, this.m_73548_(), p_162897_);
                    }
                    case WEST: {
                        return this.m_162857_(p_162892_, p_162893_, p_162894_, this.f_73383_.m_162395_() + p_162896_, this.f_73383_.m_162396_() + p_162895_, this.f_73383_.m_162401_() + 1, Direction.SOUTH, this.m_73548_(), p_162897_);
                    }
                    case EAST: {
                        return this.m_162857_(p_162892_, p_162893_, p_162894_, this.f_73383_.m_162395_() + p_162896_, this.f_73383_.m_162396_() + p_162895_, this.f_73383_.m_162401_() + 1, Direction.SOUTH, this.m_73548_(), p_162897_);
                    }
                }
            }
            return null;
        }

        protected static boolean m_71903_(BoundingBox p_71904_) {
            return p_71904_ != null && p_71904_.m_162396_() > 10;
        }
    }
}

