/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.StructurePieceType;
import net.minecraft.world.level.levelgen.feature.configurations.OceanRuinConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.OceanRuinFeature;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockRotProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public class OceanRuinPieces {
    private static final ResourceLocation[] f_72519_ = new ResourceLocation[]{new ResourceLocation("underwater_ruin/warm_1"), new ResourceLocation("underwater_ruin/warm_2"), new ResourceLocation("underwater_ruin/warm_3"), new ResourceLocation("underwater_ruin/warm_4"), new ResourceLocation("underwater_ruin/warm_5"), new ResourceLocation("underwater_ruin/warm_6"), new ResourceLocation("underwater_ruin/warm_7"), new ResourceLocation("underwater_ruin/warm_8")};
    private static final ResourceLocation[] f_72520_ = new ResourceLocation[]{new ResourceLocation("underwater_ruin/brick_1"), new ResourceLocation("underwater_ruin/brick_2"), new ResourceLocation("underwater_ruin/brick_3"), new ResourceLocation("underwater_ruin/brick_4"), new ResourceLocation("underwater_ruin/brick_5"), new ResourceLocation("underwater_ruin/brick_6"), new ResourceLocation("underwater_ruin/brick_7"), new ResourceLocation("underwater_ruin/brick_8")};
    private static final ResourceLocation[] f_72521_ = new ResourceLocation[]{new ResourceLocation("underwater_ruin/cracked_1"), new ResourceLocation("underwater_ruin/cracked_2"), new ResourceLocation("underwater_ruin/cracked_3"), new ResourceLocation("underwater_ruin/cracked_4"), new ResourceLocation("underwater_ruin/cracked_5"), new ResourceLocation("underwater_ruin/cracked_6"), new ResourceLocation("underwater_ruin/cracked_7"), new ResourceLocation("underwater_ruin/cracked_8")};
    private static final ResourceLocation[] f_72522_ = new ResourceLocation[]{new ResourceLocation("underwater_ruin/mossy_1"), new ResourceLocation("underwater_ruin/mossy_2"), new ResourceLocation("underwater_ruin/mossy_3"), new ResourceLocation("underwater_ruin/mossy_4"), new ResourceLocation("underwater_ruin/mossy_5"), new ResourceLocation("underwater_ruin/mossy_6"), new ResourceLocation("underwater_ruin/mossy_7"), new ResourceLocation("underwater_ruin/mossy_8")};
    private static final ResourceLocation[] f_72523_ = new ResourceLocation[]{new ResourceLocation("underwater_ruin/big_brick_1"), new ResourceLocation("underwater_ruin/big_brick_2"), new ResourceLocation("underwater_ruin/big_brick_3"), new ResourceLocation("underwater_ruin/big_brick_8")};
    private static final ResourceLocation[] f_72524_ = new ResourceLocation[]{new ResourceLocation("underwater_ruin/big_mossy_1"), new ResourceLocation("underwater_ruin/big_mossy_2"), new ResourceLocation("underwater_ruin/big_mossy_3"), new ResourceLocation("underwater_ruin/big_mossy_8")};
    private static final ResourceLocation[] f_72525_ = new ResourceLocation[]{new ResourceLocation("underwater_ruin/big_cracked_1"), new ResourceLocation("underwater_ruin/big_cracked_2"), new ResourceLocation("underwater_ruin/big_cracked_3"), new ResourceLocation("underwater_ruin/big_cracked_8")};
    private static final ResourceLocation[] f_72526_ = new ResourceLocation[]{new ResourceLocation("underwater_ruin/big_warm_4"), new ResourceLocation("underwater_ruin/big_warm_5"), new ResourceLocation("underwater_ruin/big_warm_6"), new ResourceLocation("underwater_ruin/big_warm_7")};

    private static ResourceLocation m_72551_(Random p_72552_) {
        return Util.m_137545_(f_72519_, p_72552_);
    }

    private static ResourceLocation m_72557_(Random p_72558_) {
        return Util.m_137545_(f_72526_, p_72558_);
    }

    public static void m_163078_(StructureManager p_163079_, BlockPos p_163080_, Rotation p_163081_, StructurePieceAccessor p_163082_, Random p_163083_, OceanRuinConfiguration p_163084_) {
        boolean bl = p_163083_.nextFloat() <= p_163084_.f_67822_;
        float \u00e2\u02dc\u01922 = bl ? 0.9f : 0.8f;
        OceanRuinPieces.m_163085_(p_163079_, p_163080_, p_163081_, p_163082_, p_163083_, p_163084_, bl, \u00e2\u02dc\u01922);
        if (bl && p_163083_.nextFloat() <= p_163084_.f_67823_) {
            OceanRuinPieces.m_163094_(p_163079_, p_163083_, p_163081_, p_163080_, p_163084_, p_163082_);
        }
    }

    private static void m_163094_(StructureManager p_163095_, Random p_163096_, Rotation p_163097_, BlockPos p_163098_, OceanRuinConfiguration p_163099_, StructurePieceAccessor p_163100_) {
        BlockPos blockPos = new BlockPos(p_163098_.m_123341_(), 90, p_163098_.m_123343_());
        \u00e2\u02dc\u0192 = StructureTemplate.m_74593_(new BlockPos(15, 0, 15), Mirror.NONE, p_163097_, BlockPos.f_121853_).m_141952_(blockPos);
        BoundingBox \u00e2\u02dc\u01922 = BoundingBox.m_162375_(blockPos, \u00e2\u02dc\u0192);
        \u00e2\u02dc\u0192 = new BlockPos(Math.min(blockPos.m_123341_(), \u00e2\u02dc\u0192.m_123341_()), blockPos.m_123342_(), Math.min(blockPos.m_123343_(), \u00e2\u02dc\u0192.m_123343_()));
        List<BlockPos> \u00e2\u02dc\u01923 = OceanRuinPieces.m_163101_(p_163096_, \u00e2\u02dc\u0192);
        int \u00e2\u02dc\u01924 = Mth.m_14072_(p_163096_, 4, 8);
        for (int i = 0; i < \u00e2\u02dc\u01924; ++i) {
            if (\u00e2\u02dc\u01923.isEmpty() || (\u00e2\u02dc\u0192 = BoundingBox.m_162375_(\u00e2\u02dc\u0192 = \u00e2\u02dc\u01923.remove(\u00e2\u02dc\u0192 = p_163096_.nextInt(\u00e2\u02dc\u01923.size())), \u00e2\u02dc\u0192 = StructureTemplate.m_74593_(new BlockPos(5, 0, 6), Mirror.NONE, \u00e2\u02dc\u0192 = Rotation.m_55956_(p_163096_), BlockPos.f_121853_).m_141952_(\u00e2\u02dc\u0192))).m_71049_(\u00e2\u02dc\u01922)) continue;
            OceanRuinPieces.m_163085_(p_163095_, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, p_163100_, p_163096_, p_163099_, false, 0.8f);
        }
    }

    private static List<BlockPos> m_163101_(Random p_163102_, BlockPos p_163103_) {
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add(p_163103_.m_142082_(-16 + Mth.m_14072_(p_163102_, 1, 8), 0, 16 + Mth.m_14072_(p_163102_, 1, 7)));
        arrayList.add(p_163103_.m_142082_(-16 + Mth.m_14072_(p_163102_, 1, 8), 0, Mth.m_14072_(p_163102_, 1, 7)));
        arrayList.add(p_163103_.m_142082_(-16 + Mth.m_14072_(p_163102_, 1, 8), 0, -16 + Mth.m_14072_(p_163102_, 4, 8)));
        arrayList.add(p_163103_.m_142082_(Mth.m_14072_(p_163102_, 1, 7), 0, 16 + Mth.m_14072_(p_163102_, 1, 7)));
        arrayList.add(p_163103_.m_142082_(Mth.m_14072_(p_163102_, 1, 7), 0, -16 + Mth.m_14072_(p_163102_, 4, 6)));
        arrayList.add(p_163103_.m_142082_(16 + Mth.m_14072_(p_163102_, 1, 7), 0, 16 + Mth.m_14072_(p_163102_, 3, 8)));
        arrayList.add(p_163103_.m_142082_(16 + Mth.m_14072_(p_163102_, 1, 7), 0, Mth.m_14072_(p_163102_, 1, 7)));
        arrayList.add(p_163103_.m_142082_(16 + Mth.m_14072_(p_163102_, 1, 7), 0, -16 + Mth.m_14072_(p_163102_, 4, 8)));
        return arrayList;
    }

    private static void m_163085_(StructureManager p_163086_, BlockPos p_163087_, Rotation p_163088_, StructurePieceAccessor p_163089_, Random p_163090_, OceanRuinConfiguration p_163091_, boolean p_163092_, float p_163093_) {
        switch (p_163091_.f_67821_) {
            default: {
                ResourceLocation resourceLocation = p_163092_ ? OceanRuinPieces.m_72557_(p_163090_) : OceanRuinPieces.m_72551_(p_163090_);
                p_163089_.m_142679_(new OceanRuinPiece(p_163086_, resourceLocation, p_163087_, p_163088_, p_163093_, p_163091_.f_67821_, p_163092_));
                break;
            }
            case COLD: {
                ResourceLocation[] resourceLocationArray = p_163092_ ? f_72523_ : f_72520_;
                \u00e2\u02dc\u0192 = p_163092_ ? f_72525_ : f_72521_;
                \u00e2\u02dc\u0192 = p_163092_ ? f_72524_ : f_72522_;
                int \u00e2\u02dc\u01922 = p_163090_.nextInt(resourceLocationArray.length);
                p_163089_.m_142679_(new OceanRuinPiece(p_163086_, resourceLocationArray[\u00e2\u02dc\u01922], p_163087_, p_163088_, p_163093_, p_163091_.f_67821_, p_163092_));
                p_163089_.m_142679_(new OceanRuinPiece(p_163086_, \u00e2\u02dc\u0192[\u00e2\u02dc\u01922], p_163087_, p_163088_, 0.7f, p_163091_.f_67821_, p_163092_));
                p_163089_.m_142679_(new OceanRuinPiece(p_163086_, \u00e2\u02dc\u0192[\u00e2\u02dc\u01922], p_163087_, p_163088_, 0.5f, p_163091_.f_67821_, p_163092_));
            }
        }
    }

    public static class OceanRuinPiece
    extends TemplateStructurePiece {
        private final OceanRuinFeature.Type f_72559_;
        private final float f_72560_;
        private final boolean f_72563_;

        public OceanRuinPiece(StructureManager p_72568_, ResourceLocation p_72569_, BlockPos p_72570_, Rotation p_72571_, float p_72572_, OceanRuinFeature.Type p_72573_, boolean p_72574_) {
            super(StructurePieceType.f_67113_, 0, p_72568_, p_72569_, p_72569_.toString(), OceanRuinPiece.m_163112_(p_72571_), p_72570_);
            this.f_72560_ = p_72572_;
            this.f_72559_ = p_72573_;
            this.f_72563_ = p_72574_;
        }

        public OceanRuinPiece(ServerLevel p_163107_, CompoundTag p_163108_) {
            super(StructurePieceType.f_67113_, p_163108_, p_163107_, p_163116_ -> OceanRuinPiece.m_163112_(Rotation.valueOf(p_163108_.m_128461_("Rot"))));
            this.f_72560_ = p_163108_.m_128457_("Integrity");
            this.f_72559_ = OceanRuinFeature.Type.valueOf(p_163108_.m_128461_("BiomeType"));
            this.f_72563_ = p_163108_.m_128471_("IsLarge");
        }

        private static StructurePlaceSettings m_163112_(Rotation p_163113_) {
            return new StructurePlaceSettings().m_74379_(p_163113_).m_74377_(Mirror.NONE).m_74383_(BlockIgnoreProcessor.f_74048_);
        }

        @Override
        protected void m_142347_(ServerLevel p_163110_, CompoundTag p_163111_) {
            super.m_142347_(p_163110_, p_163111_);
            p_163111_.m_128359_("Rot", this.f_73657_.m_74404_().name());
            p_163111_.m_128350_("Integrity", this.f_72560_);
            p_163111_.m_128359_("BiomeType", this.f_72559_.toString());
            p_163111_.m_128379_("IsLarge", this.f_72563_);
        }

        @Override
        protected void m_7756_(String p_72590_, BlockPos p_72591_, ServerLevelAccessor p_72592_, Random p_72593_, BoundingBox p_72594_) {
            if ("chest".equals(p_72590_)) {
                p_72592_.m_7731_(p_72591_, (BlockState)Blocks.f_50087_.m_49966_().m_61124_(ChestBlock.f_51480_, p_72592_.m_6425_(p_72591_).m_76153_(FluidTags.f_13131_)), 2);
                BlockEntity blockEntity = p_72592_.m_7702_(p_72591_);
                if (blockEntity instanceof ChestBlockEntity) {
                    ((ChestBlockEntity)blockEntity).m_59626_(this.f_72563_ ? BuiltInLootTables.f_78691_ : BuiltInLootTables.f_78690_, p_72593_.nextLong());
                }
            } else if ("drowned".equals(p_72590_)) {
                Drowned drowned = EntityType.f_20562_.m_20615_(p_72592_.m_6018_());
                drowned.m_21530_();
                drowned.m_20035_(p_72591_, 0.0f, 0.0f);
                drowned.m_6518_(p_72592_, p_72592_.m_6436_(p_72591_), MobSpawnType.STRUCTURE, null, null);
                p_72592_.m_47205_(drowned);
                if (p_72591_.m_123342_() > p_72592_.m_5736_()) {
                    p_72592_.m_7731_(p_72591_, Blocks.f_50016_.m_49966_(), 2);
                } else {
                    p_72592_.m_7731_(p_72591_, Blocks.f_49990_.m_49966_(), 2);
                }
            }
        }

        @Override
        public boolean m_7832_(WorldGenLevel p_72576_, StructureFeatureManager p_72577_, ChunkGenerator p_72578_, Random p_72579_, BoundingBox p_72580_, ChunkPos p_72581_, BlockPos p_72582_) {
            this.f_73657_.m_74394_().m_74383_(new BlockRotProcessor(this.f_72560_)).m_74383_(BlockIgnoreProcessor.f_74048_);
            int n = p_72576_.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, this.f_73658_.m_123341_(), this.f_73658_.m_123343_());
            this.f_73658_ = new BlockPos(this.f_73658_.m_123341_(), n, this.f_73658_.m_123343_());
            BlockPos \u00e2\u02dc\u01922 = StructureTemplate.m_74593_(new BlockPos(this.f_73656_.m_163801_().m_123341_() - 1, 0, this.f_73656_.m_163801_().m_123343_() - 1), Mirror.NONE, this.f_73657_.m_74404_(), BlockPos.f_121853_).m_141952_(this.f_73658_);
            this.f_73658_ = new BlockPos(this.f_73658_.m_123341_(), this.m_72585_(this.f_73658_, p_72576_, \u00e2\u02dc\u01922), this.f_73658_.m_123343_());
            return super.m_7832_(p_72576_, p_72577_, p_72578_, p_72579_, p_72580_, p_72581_, p_72582_);
        }

        private int m_72585_(BlockPos p_72586_, BlockGetter p_72587_, BlockPos p_72588_) {
            int n = p_72586_.m_123342_();
            \u00e2\u02dc\u0192 = 512;
            \u00e2\u02dc\u0192 = n - 1;
            \u00e2\u02dc\u0192 = 0;
            for (BlockPos blockPos : BlockPos.m_121940_(p_72586_, p_72588_)) {
                int n2 = blockPos.m_123341_();
                \u00e2\u02dc\u0192 = blockPos.m_123343_();
                \u00e2\u02dc\u0192 = p_72586_.m_123342_() - 1;
                BlockPos.MutableBlockPos \u00e2\u02dc\u01922 = new BlockPos.MutableBlockPos(n2, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
                BlockState \u00e2\u02dc\u01923 = p_72587_.m_8055_(\u00e2\u02dc\u01922);
                FluidState \u00e2\u02dc\u01924 = p_72587_.m_6425_(\u00e2\u02dc\u01922);
                while ((\u00e2\u02dc\u01923.m_60795_() || \u00e2\u02dc\u01924.m_76153_(FluidTags.f_13131_) || \u00e2\u02dc\u01923.m_60620_(BlockTags.f_13047_)) && \u00e2\u02dc\u0192 > p_72587_.m_141937_() + 1) {
                    \u00e2\u02dc\u01922.m_122178_(n2, --\u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
                    \u00e2\u02dc\u01923 = p_72587_.m_8055_(\u00e2\u02dc\u01922);
                    \u00e2\u02dc\u01924 = p_72587_.m_6425_(\u00e2\u02dc\u01922);
                }
                \u00e2\u02dc\u0192 = Math.min(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
                if (\u00e2\u02dc\u0192 >= \u00e2\u02dc\u0192 - 2) continue;
                ++\u00e2\u02dc\u0192;
            }
            \u00e2\u02dc\u0192 = Math.abs(p_72586_.m_123341_() - p_72588_.m_123341_());
            if (\u00e2\u02dc\u0192 - \u00e2\u02dc\u0192 > 2 && \u00e2\u02dc\u0192 > \u00e2\u02dc\u0192 - 2) {
                n = \u00e2\u02dc\u0192 + 1;
            }
            return n;
        }
    }
}

