/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class TemplateStructurePiece
extends StructurePiece {
    private static final Logger f_73659_ = LogManager.getLogger();
    protected final String f_163658_;
    protected StructureTemplate f_73656_;
    protected StructurePlaceSettings f_73657_;
    protected BlockPos f_73658_;

    public TemplateStructurePiece(StructurePieceType p_163660_, int p_163661_, StructureManager p_163662_, ResourceLocation p_163663_, String p_163664_, StructurePlaceSettings p_163665_, BlockPos p_163666_) {
        super(p_163660_, p_163661_, p_163662_.m_74341_(p_163663_).m_74633_(p_163665_, p_163666_));
        this.m_73519_(Direction.NORTH);
        this.f_163658_ = p_163664_;
        this.f_73658_ = p_163666_;
        this.f_73656_ = p_163662_.m_74341_(p_163663_);
        this.f_73657_ = p_163665_;
    }

    public TemplateStructurePiece(StructurePieceType p_163668_, CompoundTag p_163669_, ServerLevel p_163670_, Function<ResourceLocation, StructurePlaceSettings> p_163671_) {
        super(p_163668_, p_163669_);
        this.m_73519_(Direction.NORTH);
        this.f_163658_ = p_163669_.m_128461_("Template");
        this.f_73658_ = new BlockPos(p_163669_.m_128451_("TPX"), p_163669_.m_128451_("TPY"), p_163669_.m_128451_("TPZ"));
        ResourceLocation resourceLocation = this.m_142415_();
        this.f_73656_ = p_163670_.m_8875_().m_74341_(resourceLocation);
        this.f_73657_ = p_163671_.apply(resourceLocation);
        this.f_73383_ = this.f_73656_.m_74633_(this.f_73657_, this.f_73658_);
    }

    protected ResourceLocation m_142415_() {
        return new ResourceLocation(this.f_163658_);
    }

    @Override
    protected void m_142347_(ServerLevel p_163673_, CompoundTag p_163674_) {
        p_163674_.m_128405_("TPX", this.f_73658_.m_123341_());
        p_163674_.m_128405_("TPY", this.f_73658_.m_123342_());
        p_163674_.m_128405_("TPZ", this.f_73658_.m_123343_());
        p_163674_.m_128359_("Template", this.f_163658_);
    }

    @Override
    public boolean m_7832_(WorldGenLevel p_73672_, StructureFeatureManager p_73673_, ChunkGenerator p_73674_, Random p_73675_, BoundingBox p_73676_, ChunkPos p_73677_, BlockPos p_73678_) {
        this.f_73657_.m_74381_(p_73676_);
        this.f_73383_ = this.f_73656_.m_74633_(this.f_73657_, this.f_73658_);
        if (this.f_73656_.m_74536_(p_73672_, this.f_73658_, p_73678_, this.f_73657_, p_73675_, 2)) {
            List<StructureTemplate.StructureBlockInfo> list = this.f_73656_.m_74603_(this.f_73658_, this.f_73657_, Blocks.f_50677_);
            for (StructureTemplate.StructureBlockInfo structureBlockInfo : list) {
                StructureMode structureMode;
                if (structureBlockInfo.f_74677_ == null || (structureMode = StructureMode.valueOf(structureBlockInfo.f_74677_.m_128461_("mode"))) != StructureMode.DATA) continue;
                this.m_7756_(structureBlockInfo.f_74677_.m_128461_("metadata"), structureBlockInfo.f_74675_, p_73672_, p_73675_, p_73676_);
            }
            List<StructureTemplate.StructureBlockInfo> list2 = this.f_73656_.m_74603_(this.f_73658_, this.f_73657_, Blocks.f_50678_);
            for (StructureTemplate.StructureBlockInfo structureBlockInfo : list2) {
                if (structureBlockInfo.f_74677_ == null) continue;
                String string = structureBlockInfo.f_74677_.m_128461_("final_state");
                BlockStateParser \u00e2\u02dc\u01922 = new BlockStateParser(new StringReader(string), false);
                BlockState \u00e2\u02dc\u01923 = Blocks.f_50016_.m_49966_();
                try {
                    \u00e2\u02dc\u01922.m_116806_(true);
                    BlockState blockState = \u00e2\u02dc\u01922.m_116808_();
                    if (blockState != null) {
                        \u00e2\u02dc\u01923 = blockState;
                    } else {
                        f_73659_.error("Error while parsing blockstate {} in jigsaw block @ {}", (Object)string, (Object)structureBlockInfo.f_74675_);
                    }
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    f_73659_.error("Error while parsing blockstate {} in jigsaw block @ {}", (Object)string, (Object)structureBlockInfo.f_74675_);
                }
                p_73672_.m_7731_(structureBlockInfo.f_74675_, \u00e2\u02dc\u01923, 3);
            }
        }
        return true;
    }

    protected abstract void m_7756_(String var1, BlockPos var2, ServerLevelAccessor var3, Random var4, BoundingBox var5);

    @Override
    public void m_6324_(int p_73668_, int p_73669_, int p_73670_) {
        super.m_6324_(p_73668_, p_73669_, p_73670_);
        this.f_73658_ = this.f_73658_.m_142082_(p_73668_, p_73669_, p_73670_);
    }

    @Override
    public Rotation m_6830_() {
        return this.f_73657_.m_74404_();
    }
}

