/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public class WoodlandMansionPieces {
    public static void m_73691_(StructureManager p_73692_, BlockPos p_73693_, Rotation p_73694_, List<WoodlandMansionPiece> p_73695_, Random p_73696_) {
        MansionGrid mansionGrid = new MansionGrid(p_73696_);
        MansionPiecePlacer \u00e2\u02dc\u01922 = new MansionPiecePlacer(p_73692_, p_73696_);
        \u00e2\u02dc\u01922.m_73781_(p_73693_, p_73694_, p_73695_, mansionGrid);
    }

    public static void m_163676_(String[] p_163677_) {
        Random random = new Random();
        long \u00e2\u02dc\u01922 = random.nextLong();
        System.out.println("Seed: " + \u00e2\u02dc\u01922);
        random.setSeed(\u00e2\u02dc\u01922);
        MansionGrid \u00e2\u02dc\u01923 = new MansionGrid(random);
        \u00e2\u02dc\u01923.m_163694_();
    }

    static class MansionGrid {
        private static final int f_163678_ = 11;
        private static final int f_163679_ = 0;
        private static final int f_163680_ = 1;
        private static final int f_163681_ = 2;
        private static final int f_163682_ = 3;
        private static final int f_163683_ = 4;
        private static final int f_163684_ = 5;
        private static final int f_163685_ = 65536;
        private static final int f_163686_ = 131072;
        private static final int f_163687_ = 262144;
        private static final int f_163688_ = 0x100000;
        private static final int f_163689_ = 0x200000;
        private static final int f_163690_ = 0x400000;
        private static final int f_163691_ = 0x800000;
        private static final int f_163692_ = 983040;
        private static final int f_163693_ = 65535;
        private final Random f_73728_;
        final SimpleGrid f_73729_;
        final SimpleGrid f_73730_;
        final SimpleGrid[] f_73731_;
        final int f_73732_;
        final int f_73733_;

        public MansionGrid(Random p_73735_) {
            this.f_73728_ = p_73735_;
            int n = 11;
            this.f_73732_ = 7;
            this.f_73733_ = 4;
            this.f_73729_ = new SimpleGrid(11, 11, 5);
            this.f_73729_.m_73884_(this.f_73732_, this.f_73733_, this.f_73732_ + 1, this.f_73733_ + 1, 3);
            this.f_73729_.m_73884_(this.f_73732_ - 1, this.f_73733_, this.f_73732_ - 1, this.f_73733_ + 1, 2);
            this.f_73729_.m_73884_(this.f_73732_ + 2, this.f_73733_ - 2, this.f_73732_ + 3, this.f_73733_ + 3, 5);
            this.f_73729_.m_73884_(this.f_73732_ + 1, this.f_73733_ - 2, this.f_73732_ + 1, this.f_73733_ - 1, 1);
            this.f_73729_.m_73884_(this.f_73732_ + 1, this.f_73733_ + 2, this.f_73732_ + 1, this.f_73733_ + 3, 1);
            this.f_73729_.m_73875_(this.f_73732_ - 1, this.f_73733_ - 1, 1);
            this.f_73729_.m_73875_(this.f_73732_ - 1, this.f_73733_ + 2, 1);
            this.f_73729_.m_73884_(0, 0, 11, 1, 5);
            this.f_73729_.m_73884_(0, 9, 11, 11, 5);
            this.m_73750_(this.f_73729_, this.f_73732_, this.f_73733_ - 2, Direction.WEST, 6);
            this.m_73750_(this.f_73729_, this.f_73732_, this.f_73733_ + 3, Direction.WEST, 6);
            this.m_73750_(this.f_73729_, this.f_73732_ - 2, this.f_73733_ - 1, Direction.WEST, 3);
            this.m_73750_(this.f_73729_, this.f_73732_ - 2, this.f_73733_ + 2, Direction.WEST, 3);
            while (this.m_73738_(this.f_73729_)) {
            }
            this.f_73731_ = new SimpleGrid[3];
            this.f_73731_[0] = new SimpleGrid(11, 11, 5);
            this.f_73731_[1] = new SimpleGrid(11, 11, 5);
            this.f_73731_[2] = new SimpleGrid(11, 11, 5);
            this.m_73756_(this.f_73729_, this.f_73731_[0]);
            this.m_73756_(this.f_73729_, this.f_73731_[1]);
            this.f_73731_[0].m_73884_(this.f_73732_ + 1, this.f_73733_, this.f_73732_ + 1, this.f_73733_ + 1, 0x800000);
            this.f_73731_[1].m_73884_(this.f_73732_ + 1, this.f_73733_, this.f_73732_ + 1, this.f_73733_ + 1, 0x800000);
            this.f_73730_ = new SimpleGrid(this.f_73729_.f_73865_, this.f_73729_.f_73866_, 5);
            this.m_73759_();
            this.m_73756_(this.f_73730_, this.f_73731_[2]);
        }

        public static boolean m_73740_(SimpleGrid p_73741_, int p_73742_, int p_73743_) {
            int n = p_73741_.m_73872_(p_73742_, p_73743_);
            return n == 1 || n == 2 || n == 3 || n == 4;
        }

        public boolean m_73744_(SimpleGrid p_73745_, int p_73746_, int p_73747_, int p_73748_, int p_73749_) {
            return (this.f_73731_[p_73748_].m_73872_(p_73746_, p_73747_) & 0xFFFF) == p_73749_;
        }

        @Nullable
        public Direction m_73762_(SimpleGrid p_73763_, int p_73764_, int p_73765_, int p_73766_, int p_73767_) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (!this.m_73744_(p_73763_, p_73764_ + direction.m_122429_(), p_73765_ + direction.m_122431_(), p_73766_, p_73767_)) continue;
                return direction;
            }
            return null;
        }

        private void m_73750_(SimpleGrid p_73751_, int p_73752_, int p_73753_, Direction p_73754_, int p_73755_) {
            if (p_73755_ <= 0) {
                return;
            }
            p_73751_.m_73875_(p_73752_, p_73753_, 1);
            p_73751_.m_73879_(p_73752_ + p_73754_.m_122429_(), p_73753_ + p_73754_.m_122431_(), 0, 1);
            for (int i = 0; i < 8; ++i) {
                Direction direction = Direction.m_122407_(this.f_73728_.nextInt(4));
                if (direction == p_73754_.m_122424_() || direction == Direction.EAST && this.f_73728_.nextBoolean()) continue;
                int \u00e2\u02dc\u01922 = p_73752_ + p_73754_.m_122429_();
                int \u00e2\u02dc\u01923 = p_73753_ + p_73754_.m_122431_();
                if (p_73751_.m_73872_(\u00e2\u02dc\u01922 + direction.m_122429_(), \u00e2\u02dc\u01923 + direction.m_122431_()) != 0 || p_73751_.m_73872_(\u00e2\u02dc\u01922 + direction.m_122429_() * 2, \u00e2\u02dc\u01923 + direction.m_122431_() * 2) != 0) continue;
                this.m_73750_(p_73751_, p_73752_ + p_73754_.m_122429_() + direction.m_122429_(), p_73753_ + p_73754_.m_122431_() + direction.m_122431_(), direction, p_73755_ - 1);
                break;
            }
            \u00e2\u02dc\u0192 = p_73754_.m_122427_();
            direction = p_73754_.m_122428_();
            p_73751_.m_73879_(p_73752_ + \u00e2\u02dc\u0192.m_122429_(), p_73753_ + \u00e2\u02dc\u0192.m_122431_(), 0, 2);
            p_73751_.m_73879_(p_73752_ + direction.m_122429_(), p_73753_ + direction.m_122431_(), 0, 2);
            p_73751_.m_73879_(p_73752_ + p_73754_.m_122429_() + \u00e2\u02dc\u0192.m_122429_(), p_73753_ + p_73754_.m_122431_() + \u00e2\u02dc\u0192.m_122431_(), 0, 2);
            p_73751_.m_73879_(p_73752_ + p_73754_.m_122429_() + direction.m_122429_(), p_73753_ + p_73754_.m_122431_() + direction.m_122431_(), 0, 2);
            p_73751_.m_73879_(p_73752_ + p_73754_.m_122429_() * 2, p_73753_ + p_73754_.m_122431_() * 2, 0, 2);
            p_73751_.m_73879_(p_73752_ + \u00e2\u02dc\u0192.m_122429_() * 2, p_73753_ + \u00e2\u02dc\u0192.m_122431_() * 2, 0, 2);
            p_73751_.m_73879_(p_73752_ + direction.m_122429_() * 2, p_73753_ + direction.m_122431_() * 2, 0, 2);
        }

        private boolean m_73738_(SimpleGrid p_73739_) {
            boolean \u00e2\u02dc\u01922 = false;
            for (int i = 0; i < p_73739_.f_73866_; ++i) {
                for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < p_73739_.f_73865_; ++\u00e2\u02dc\u0192) {
                    int n;
                    if (p_73739_.m_73872_(\u00e2\u02dc\u0192, i) != 0) continue;
                    n = 0;
                    n += MansionGrid.m_73740_(p_73739_, \u00e2\u02dc\u0192 + 1, i) ? 1 : 0;
                    n += MansionGrid.m_73740_(p_73739_, \u00e2\u02dc\u0192 - 1, i) ? 1 : 0;
                    n += MansionGrid.m_73740_(p_73739_, \u00e2\u02dc\u0192, i + 1) ? 1 : 0;
                    if ((n += MansionGrid.m_73740_(p_73739_, \u00e2\u02dc\u0192, i - 1) ? 1 : 0) >= 3) {
                        p_73739_.m_73875_(\u00e2\u02dc\u0192, i, 2);
                        \u00e2\u02dc\u01922 = true;
                        continue;
                    }
                    if (n != 2) continue;
                    int n2 = 0;
                    n2 += MansionGrid.m_73740_(p_73739_, \u00e2\u02dc\u0192 + 1, i + 1) ? 1 : 0;
                    n2 += MansionGrid.m_73740_(p_73739_, \u00e2\u02dc\u0192 - 1, i + 1) ? 1 : 0;
                    n2 += MansionGrid.m_73740_(p_73739_, \u00e2\u02dc\u0192 + 1, i - 1) ? 1 : 0;
                    if ((n2 += MansionGrid.m_73740_(p_73739_, \u00e2\u02dc\u0192 - 1, i - 1) ? 1 : 0) > 1) continue;
                    p_73739_.m_73875_(\u00e2\u02dc\u0192, i, 2);
                    \u00e2\u02dc\u01922 = true;
                }
            }
            return \u00e2\u02dc\u01922;
        }

        private void m_73759_() {
            ArrayList arrayList = Lists.newArrayList();
            SimpleGrid \u00e2\u02dc\u01922 = this.f_73731_[1];
            for (int i = 0; i < this.f_73730_.f_73866_; ++i) {
                for (\u00e2\u02dc\u01924 = 0; \u00e2\u02dc\u01924 < this.f_73730_.f_73865_; ++\u00e2\u02dc\u01924) {
                    \u00e2\u02dc\u0192 = \u00e2\u02dc\u01922.m_73872_(\u00e2\u02dc\u01924, i);
                    \u00e2\u02dc\u01926 = \u00e2\u02dc\u0192 & 0xF0000;
                    if (\u00e2\u02dc\u01926 != 131072 || (\u00e2\u02dc\u0192 & 0x200000) != 0x200000) continue;
                    arrayList.add(new Tuple<Integer, Integer>(\u00e2\u02dc\u01924, i));
                }
            }
            if (arrayList.isEmpty()) {
                this.f_73730_.m_73884_(0, 0, this.f_73730_.f_73865_, this.f_73730_.f_73866_, 5);
                return;
            }
            Tuple \u00e2\u02dc\u01923 = (Tuple)arrayList.get(this.f_73728_.nextInt(arrayList.size()));
            int \u00e2\u02dc\u01924 = \u00e2\u02dc\u01922.m_73872_((Integer)\u00e2\u02dc\u01923.m_14418_(), (Integer)\u00e2\u02dc\u01923.m_14419_());
            \u00e2\u02dc\u01922.m_73875_((Integer)\u00e2\u02dc\u01923.m_14418_(), (Integer)\u00e2\u02dc\u01923.m_14419_(), \u00e2\u02dc\u01924 | 0x400000);
            Direction \u00e2\u02dc\u01925 = this.m_73762_(this.f_73729_, (Integer)\u00e2\u02dc\u01923.m_14418_(), (Integer)\u00e2\u02dc\u01923.m_14419_(), 1, \u00e2\u02dc\u01924 & 0xFFFF);
            int \u00e2\u02dc\u01926 = (Integer)\u00e2\u02dc\u01923.m_14418_() + \u00e2\u02dc\u01925.m_122429_();
            int \u00e2\u02dc\u01927 = (Integer)\u00e2\u02dc\u01923.m_14419_() + \u00e2\u02dc\u01925.m_122431_();
            for (int i = 0; i < this.f_73730_.f_73866_; ++i) {
                for (\u00e2\u02dc\u01928 = 0; \u00e2\u02dc\u01928 < this.f_73730_.f_73865_; ++\u00e2\u02dc\u01928) {
                    if (!MansionGrid.m_73740_(this.f_73729_, \u00e2\u02dc\u01928, i)) {
                        this.f_73730_.m_73875_(\u00e2\u02dc\u01928, i, 5);
                        continue;
                    }
                    if (\u00e2\u02dc\u01928 == (Integer)\u00e2\u02dc\u01923.m_14418_() && i == (Integer)\u00e2\u02dc\u01923.m_14419_()) {
                        this.f_73730_.m_73875_(\u00e2\u02dc\u01928, i, 3);
                        continue;
                    }
                    if (\u00e2\u02dc\u01928 != \u00e2\u02dc\u01926 || i != \u00e2\u02dc\u01927) continue;
                    this.f_73730_.m_73875_(\u00e2\u02dc\u01928, i, 3);
                    this.f_73731_[2].m_73875_(\u00e2\u02dc\u01928, i, 0x800000);
                }
            }
            ArrayList arrayList2 = Lists.newArrayList();
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (this.f_73730_.m_73872_(\u00e2\u02dc\u01926 + direction.m_122429_(), \u00e2\u02dc\u01927 + direction.m_122431_()) != 0) continue;
                arrayList2.add(direction);
            }
            if (arrayList2.isEmpty()) {
                this.f_73730_.m_73884_(0, 0, this.f_73730_.f_73865_, this.f_73730_.f_73866_, 5);
                \u00e2\u02dc\u01922.m_73875_((Integer)\u00e2\u02dc\u01923.m_14418_(), (Integer)\u00e2\u02dc\u01923.m_14419_(), \u00e2\u02dc\u01924);
                return;
            }
            Direction \u00e2\u02dc\u01928 = (Direction)arrayList2.get(this.f_73728_.nextInt(arrayList2.size()));
            this.m_73750_(this.f_73730_, \u00e2\u02dc\u01926 + \u00e2\u02dc\u01928.m_122429_(), \u00e2\u02dc\u01927 + \u00e2\u02dc\u01928.m_122431_(), \u00e2\u02dc\u01928, 4);
            while (this.m_73738_(this.f_73730_)) {
            }
        }

        private void m_73756_(SimpleGrid p_73757_, SimpleGrid p_73758_) {
            int \u00e2\u02dc\u01922;
            ArrayList arrayList = Lists.newArrayList();
            for (\u00e2\u02dc\u01922 = 0; \u00e2\u02dc\u01922 < p_73757_.f_73866_; ++\u00e2\u02dc\u01922) {
                for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < p_73757_.f_73865_; ++\u00e2\u02dc\u0192) {
                    if (p_73757_.m_73872_(\u00e2\u02dc\u0192, \u00e2\u02dc\u01922) != 2) continue;
                    arrayList.add(new Tuple<Integer, Integer>(\u00e2\u02dc\u0192, \u00e2\u02dc\u01922));
                }
            }
            Collections.shuffle(arrayList, this.f_73728_);
            \u00e2\u02dc\u01922 = 10;
            for (Tuple tuple : arrayList) {
                int n = (Integer)tuple.m_14418_();
                if (p_73758_.m_73872_(n, \u00e2\u02dc\u0192 = ((Integer)tuple.m_14419_()).intValue()) != 0) continue;
                \u00e2\u02dc\u0192 = n;
                \u00e2\u02dc\u0192 = n;
                \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192;
                \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192;
                \u00e2\u02dc\u0192 = 65536;
                if (p_73758_.m_73872_(n + 1, \u00e2\u02dc\u0192) == 0 && p_73758_.m_73872_(n, \u00e2\u02dc\u0192 + 1) == 0 && p_73758_.m_73872_(n + 1, \u00e2\u02dc\u0192 + 1) == 0 && p_73757_.m_73872_(n + 1, \u00e2\u02dc\u0192) == 2 && p_73757_.m_73872_(n, \u00e2\u02dc\u0192 + 1) == 2 && p_73757_.m_73872_(n + 1, \u00e2\u02dc\u0192 + 1) == 2) {
                    ++\u00e2\u02dc\u0192;
                    ++\u00e2\u02dc\u0192;
                    \u00e2\u02dc\u0192 = 262144;
                } else if (p_73758_.m_73872_(n - 1, \u00e2\u02dc\u0192) == 0 && p_73758_.m_73872_(n, \u00e2\u02dc\u0192 + 1) == 0 && p_73758_.m_73872_(n - 1, \u00e2\u02dc\u0192 + 1) == 0 && p_73757_.m_73872_(n - 1, \u00e2\u02dc\u0192) == 2 && p_73757_.m_73872_(n, \u00e2\u02dc\u0192 + 1) == 2 && p_73757_.m_73872_(n - 1, \u00e2\u02dc\u0192 + 1) == 2) {
                    --\u00e2\u02dc\u0192;
                    ++\u00e2\u02dc\u0192;
                    \u00e2\u02dc\u0192 = 262144;
                } else if (p_73758_.m_73872_(n - 1, \u00e2\u02dc\u0192) == 0 && p_73758_.m_73872_(n, \u00e2\u02dc\u0192 - 1) == 0 && p_73758_.m_73872_(n - 1, \u00e2\u02dc\u0192 - 1) == 0 && p_73757_.m_73872_(n - 1, \u00e2\u02dc\u0192) == 2 && p_73757_.m_73872_(n, \u00e2\u02dc\u0192 - 1) == 2 && p_73757_.m_73872_(n - 1, \u00e2\u02dc\u0192 - 1) == 2) {
                    --\u00e2\u02dc\u0192;
                    --\u00e2\u02dc\u0192;
                    \u00e2\u02dc\u0192 = 262144;
                } else if (p_73758_.m_73872_(n + 1, \u00e2\u02dc\u0192) == 0 && p_73757_.m_73872_(n + 1, \u00e2\u02dc\u0192) == 2) {
                    ++\u00e2\u02dc\u0192;
                    \u00e2\u02dc\u0192 = 131072;
                } else if (p_73758_.m_73872_(n, \u00e2\u02dc\u0192 + 1) == 0 && p_73757_.m_73872_(n, \u00e2\u02dc\u0192 + 1) == 2) {
                    ++\u00e2\u02dc\u0192;
                    \u00e2\u02dc\u0192 = 131072;
                } else if (p_73758_.m_73872_(n - 1, \u00e2\u02dc\u0192) == 0 && p_73757_.m_73872_(n - 1, \u00e2\u02dc\u0192) == 2) {
                    --\u00e2\u02dc\u0192;
                    \u00e2\u02dc\u0192 = 131072;
                } else if (p_73758_.m_73872_(n, \u00e2\u02dc\u0192 - 1) == 0 && p_73757_.m_73872_(n, \u00e2\u02dc\u0192 - 1) == 2) {
                    --\u00e2\u02dc\u0192;
                    \u00e2\u02dc\u0192 = 131072;
                }
                \u00e2\u02dc\u0192 = this.f_73728_.nextBoolean() ? \u00e2\u02dc\u0192 : \u00e2\u02dc\u0192;
                \u00e2\u02dc\u0192 = this.f_73728_.nextBoolean() ? \u00e2\u02dc\u0192 : \u00e2\u02dc\u0192;
                \u00e2\u02dc\u0192 = 0x200000;
                if (!p_73757_.m_73892_(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192, 1)) {
                    \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 == \u00e2\u02dc\u0192 ? \u00e2\u02dc\u0192 : \u00e2\u02dc\u0192;
                    int n2 = \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 == \u00e2\u02dc\u0192 ? \u00e2\u02dc\u0192 : \u00e2\u02dc\u0192;
                    if (!p_73757_.m_73892_(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192, 1)) {
                        int n3 = \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 == \u00e2\u02dc\u0192 ? \u00e2\u02dc\u0192 : \u00e2\u02dc\u0192;
                        if (!p_73757_.m_73892_(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192, 1)) {
                            \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 == \u00e2\u02dc\u0192 ? \u00e2\u02dc\u0192 : \u00e2\u02dc\u0192;
                            int n4 = \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 == \u00e2\u02dc\u0192 ? \u00e2\u02dc\u0192 : \u00e2\u02dc\u0192;
                            if (!p_73757_.m_73892_(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192, 1)) {
                                \u00e2\u02dc\u0192 = 0;
                                \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192;
                                \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192;
                            }
                        }
                    }
                }
                for (\u00e2\u02dc\u0192 = \u00e2\u02dc\u0192; \u00e2\u02dc\u0192 <= \u00e2\u02dc\u0192; ++\u00e2\u02dc\u0192) {
                    for (\u00e2\u02dc\u0192 = \u00e2\u02dc\u0192; \u00e2\u02dc\u0192 <= \u00e2\u02dc\u0192; ++\u00e2\u02dc\u0192) {
                        if (\u00e2\u02dc\u0192 == \u00e2\u02dc\u0192 && \u00e2\u02dc\u0192 == \u00e2\u02dc\u0192) {
                            p_73758_.m_73875_(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192, 0x100000 | \u00e2\u02dc\u0192 | \u00e2\u02dc\u0192 | \u00e2\u02dc\u01922);
                            continue;
                        }
                        p_73758_.m_73875_(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192 | \u00e2\u02dc\u01922);
                    }
                }
                ++\u00e2\u02dc\u01922;
            }
        }

        public void m_163694_() {
            for (int i = 0; i < 2; ++i) {
                SimpleGrid simpleGrid = i == 0 ? this.f_73729_ : this.f_73730_;
                for (int j = 0; j < simpleGrid.f_73866_; ++j) {
                    for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < simpleGrid.f_73865_; ++\u00e2\u02dc\u0192) {
                        \u00e2\u02dc\u0192 = simpleGrid.m_73872_(\u00e2\u02dc\u0192, j);
                        if (\u00e2\u02dc\u0192 == 1) {
                            System.out.print("+");
                            continue;
                        }
                        if (\u00e2\u02dc\u0192 == 4) {
                            System.out.print("x");
                            continue;
                        }
                        if (\u00e2\u02dc\u0192 == 2) {
                            System.out.print("X");
                            continue;
                        }
                        if (\u00e2\u02dc\u0192 == 3) {
                            System.out.print("O");
                            continue;
                        }
                        if (\u00e2\u02dc\u0192 == 5) {
                            System.out.print("#");
                            continue;
                        }
                        System.out.print(" ");
                    }
                    System.out.println("");
                }
                System.out.println("");
            }
        }
    }

    static class MansionPiecePlacer {
        private final StructureManager f_73774_;
        private final Random f_73775_;
        private int f_73776_;
        private int f_73777_;

        public MansionPiecePlacer(StructureManager p_73779_, Random p_73780_) {
            this.f_73774_ = p_73779_;
            this.f_73775_ = p_73780_;
        }

        public void m_73781_(BlockPos p_73782_, Rotation p_73783_, List<WoodlandMansionPiece> p_73784_, MansionGrid p_73785_) {
            PlacementData placementData = new PlacementData();
            placementData.f_73840_ = p_73782_;
            placementData.f_73839_ = p_73783_;
            placementData.f_73841_ = "wall_flat";
            \u00e2\u02dc\u0192 = new PlacementData();
            this.m_73786_(p_73784_, placementData);
            \u00e2\u02dc\u0192.f_73840_ = placementData.f_73840_.m_6630_(8);
            \u00e2\u02dc\u0192.f_73839_ = placementData.f_73839_;
            \u00e2\u02dc\u0192.f_73841_ = "wall_window";
            if (!p_73784_.isEmpty()) {
                // empty if block
            }
            SimpleGrid \u00e2\u02dc\u01922 = p_73785_.f_73729_;
            SimpleGrid \u00e2\u02dc\u01923 = p_73785_.f_73730_;
            this.f_73776_ = p_73785_.f_73732_ + 1;
            this.f_73777_ = p_73785_.f_73733_ + 1;
            int \u00e2\u02dc\u01924 = p_73785_.f_73732_ + 1;
            int \u00e2\u02dc\u01925 = p_73785_.f_73733_;
            this.m_73789_(p_73784_, placementData, \u00e2\u02dc\u01922, Direction.SOUTH, this.f_73776_, this.f_73777_, \u00e2\u02dc\u01924, \u00e2\u02dc\u01925);
            this.m_73789_(p_73784_, \u00e2\u02dc\u0192, \u00e2\u02dc\u01922, Direction.SOUTH, this.f_73776_, this.f_73777_, \u00e2\u02dc\u01924, \u00e2\u02dc\u01925);
            \u00e2\u02dc\u0192 = new PlacementData();
            \u00e2\u02dc\u0192.f_73840_ = placementData.f_73840_.m_6630_(19);
            \u00e2\u02dc\u0192.f_73839_ = placementData.f_73839_;
            \u00e2\u02dc\u0192.f_73841_ = "wall_window";
            boolean \u00e2\u02dc\u01926 = false;
            for (int i = 0; i < \u00e2\u02dc\u01923.f_73866_ && !\u00e2\u02dc\u01926; ++i) {
                for (i = \u00e2\u02dc\u01923.f_73865_ - 1; i >= 0 && !\u00e2\u02dc\u01926; --i) {
                    if (!MansionGrid.m_73740_(\u00e2\u02dc\u01923, i, i)) continue;
                    \u00e2\u02dc\u0192.f_73840_ = \u00e2\u02dc\u0192.f_73840_.m_5484_(p_73783_.m_55954_(Direction.SOUTH), 8 + (i - this.f_73777_) * 8);
                    \u00e2\u02dc\u0192.f_73840_ = \u00e2\u02dc\u0192.f_73840_.m_5484_(p_73783_.m_55954_(Direction.EAST), (i - this.f_73776_) * 8);
                    this.m_73830_(p_73784_, \u00e2\u02dc\u0192);
                    this.m_73789_(p_73784_, \u00e2\u02dc\u0192, \u00e2\u02dc\u01923, Direction.SOUTH, i, i, i, i);
                    \u00e2\u02dc\u01926 = true;
                }
            }
            this.m_73803_(p_73784_, p_73782_.m_6630_(16), p_73783_, \u00e2\u02dc\u01922, \u00e2\u02dc\u01923);
            this.m_73803_(p_73784_, p_73782_.m_6630_(27), p_73783_, \u00e2\u02dc\u01923, null);
            if (!p_73784_.isEmpty()) {
                // empty if block
            }
            FloorRoomCollection[] floorRoomCollectionArray = new FloorRoomCollection[]{new FirstFloorRoomCollection(), new SecondFloorRoomCollection(), new ThirdFloorRoomCollection()};
            for (int i = 0; i < 3; ++i) {
                Object \u00e2\u02dc\u019213;
                BlockPos blockPos = p_73782_.m_6630_(8 * i + (i == 2 ? 3 : 0));
                SimpleGrid \u00e2\u02dc\u01927 = p_73785_.f_73731_[i];
                SimpleGrid \u00e2\u02dc\u01928 = i == 2 ? \u00e2\u02dc\u01923 : \u00e2\u02dc\u01922;
                String \u00e2\u02dc\u01929 = i == 0 ? "carpet_south_1" : "carpet_south_2";
                String \u00e2\u02dc\u019210 = i == 0 ? "carpet_west_1" : "carpet_west_2";
                for (int j = 0; j < \u00e2\u02dc\u01928.f_73866_; ++j) {
                    for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < \u00e2\u02dc\u01928.f_73865_; ++\u00e2\u02dc\u0192) {
                        if (\u00e2\u02dc\u01928.m_73872_(\u00e2\u02dc\u0192, j) != 1) continue;
                        \u00e2\u02dc\u019213 = blockPos.m_5484_(p_73783_.m_55954_(Direction.SOUTH), 8 + (j - this.f_73777_) * 8);
                        \u00e2\u02dc\u019213 = ((BlockPos)\u00e2\u02dc\u019213).m_5484_(p_73783_.m_55954_(Direction.EAST), (\u00e2\u02dc\u0192 - this.f_73776_) * 8);
                        p_73784_.add(new WoodlandMansionPiece(this.f_73774_, "corridor_floor", (BlockPos)\u00e2\u02dc\u019213, p_73783_));
                        if (\u00e2\u02dc\u01928.m_73872_(\u00e2\u02dc\u0192, j - 1) == 1 || (\u00e2\u02dc\u01927.m_73872_(\u00e2\u02dc\u0192, j - 1) & 0x800000) == 0x800000) {
                            p_73784_.add(new WoodlandMansionPiece(this.f_73774_, "carpet_north", ((BlockPos)\u00e2\u02dc\u019213).m_5484_(p_73783_.m_55954_(Direction.EAST), 1).m_7494_(), p_73783_));
                        }
                        if (\u00e2\u02dc\u01928.m_73872_(\u00e2\u02dc\u0192 + 1, j) == 1 || (\u00e2\u02dc\u01927.m_73872_(\u00e2\u02dc\u0192 + 1, j) & 0x800000) == 0x800000) {
                            p_73784_.add(new WoodlandMansionPiece(this.f_73774_, "carpet_east", ((BlockPos)\u00e2\u02dc\u019213).m_5484_(p_73783_.m_55954_(Direction.SOUTH), 1).m_5484_(p_73783_.m_55954_(Direction.EAST), 5).m_7494_(), p_73783_));
                        }
                        if (\u00e2\u02dc\u01928.m_73872_(\u00e2\u02dc\u0192, j + 1) == 1 || (\u00e2\u02dc\u01927.m_73872_(\u00e2\u02dc\u0192, j + 1) & 0x800000) == 0x800000) {
                            p_73784_.add(new WoodlandMansionPiece(this.f_73774_, \u00e2\u02dc\u01929, ((BlockPos)\u00e2\u02dc\u019213).m_5484_(p_73783_.m_55954_(Direction.SOUTH), 5).m_5484_(p_73783_.m_55954_(Direction.WEST), 1), p_73783_));
                        }
                        if (\u00e2\u02dc\u01928.m_73872_(\u00e2\u02dc\u0192 - 1, j) != 1 && (\u00e2\u02dc\u01927.m_73872_(\u00e2\u02dc\u0192 - 1, j) & 0x800000) != 0x800000) continue;
                        p_73784_.add(new WoodlandMansionPiece(this.f_73774_, \u00e2\u02dc\u019210, ((BlockPos)\u00e2\u02dc\u019213).m_5484_(p_73783_.m_55954_(Direction.WEST), 1).m_5484_(p_73783_.m_55954_(Direction.NORTH), 1), p_73783_));
                    }
                }
                String \u00e2\u02dc\u019211 = i == 0 ? "indoors_wall_1" : "indoors_wall_2";
                String \u00e2\u02dc\u019212 = i == 0 ? "indoors_door_1" : "indoors_door_2";
                \u00e2\u02dc\u019213 = Lists.newArrayList();
                for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < \u00e2\u02dc\u01928.f_73866_; ++\u00e2\u02dc\u0192) {
                    for (n2 = 0; n2 < \u00e2\u02dc\u01928.f_73865_; ++n2) {
                        int n;
                        int n2;
                        Object object;
                        Object \u00e2\u02dc\u0192142;
                        boolean bl = bl2 = i == 2 && \u00e2\u02dc\u01928.m_73872_(n2, \u00e2\u02dc\u0192) == 3;
                        if (\u00e2\u02dc\u01928.m_73872_(n2, \u00e2\u02dc\u0192) != 2 && !bl2) continue;
                        \u00e2\u02dc\u0192 = \u00e2\u02dc\u01927.m_73872_(n2, \u00e2\u02dc\u0192);
                        n = \u00e2\u02dc\u0192 & 0xF0000;
                        \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 & 0xFFFF;
                        boolean bl2 = bl2 && (\u00e2\u02dc\u0192 & 0x800000) == 0x800000;
                        \u00e2\u02dc\u019213.clear();
                        if ((\u00e2\u02dc\u0192 & 0x200000) == 0x200000) {
                            for (Object \u00e2\u02dc\u0192142 : Direction.Plane.HORIZONTAL) {
                                if (\u00e2\u02dc\u01928.m_73872_(n2 + ((Direction)\u00e2\u02dc\u0192142).m_122429_(), \u00e2\u02dc\u0192 + ((Direction)\u00e2\u02dc\u0192142).m_122431_()) != 1) continue;
                                \u00e2\u02dc\u019213.add(\u00e2\u02dc\u0192142);
                            }
                        }
                        Direction direction = null;
                        if (!\u00e2\u02dc\u019213.isEmpty()) {
                            direction = (Direction)\u00e2\u02dc\u019213.get(this.f_73775_.nextInt(\u00e2\u02dc\u019213.size()));
                        } else if ((\u00e2\u02dc\u0192 & 0x100000) == 0x100000) {
                            direction = Direction.UP;
                        }
                        \u00e2\u02dc\u0192142 = blockPos.m_5484_(p_73783_.m_55954_(Direction.SOUTH), 8 + (\u00e2\u02dc\u0192 - this.f_73777_) * 8);
                        \u00e2\u02dc\u0192142 = ((BlockPos)\u00e2\u02dc\u0192142).m_5484_(p_73783_.m_55954_(Direction.EAST), -1 + (n2 - this.f_73776_) * 8);
                        if (MansionGrid.m_73740_(\u00e2\u02dc\u01928, n2 - 1, \u00e2\u02dc\u0192) && !p_73785_.m_73744_(\u00e2\u02dc\u01928, n2 - 1, \u00e2\u02dc\u0192, i, \u00e2\u02dc\u0192)) {
                            p_73784_.add(new WoodlandMansionPiece(this.f_73774_, direction == Direction.WEST ? \u00e2\u02dc\u019212 : \u00e2\u02dc\u019211, (BlockPos)\u00e2\u02dc\u0192142, p_73783_));
                        }
                        if (\u00e2\u02dc\u01928.m_73872_(n2 + 1, \u00e2\u02dc\u0192) == 1 && !bl2) {
                            object = ((BlockPos)\u00e2\u02dc\u0192142).m_5484_(p_73783_.m_55954_(Direction.EAST), 8);
                            p_73784_.add(new WoodlandMansionPiece(this.f_73774_, direction == Direction.EAST ? \u00e2\u02dc\u019212 : \u00e2\u02dc\u019211, (BlockPos)object, p_73783_));
                        }
                        if (MansionGrid.m_73740_(\u00e2\u02dc\u01928, n2, \u00e2\u02dc\u0192 + 1) && !p_73785_.m_73744_(\u00e2\u02dc\u01928, n2, \u00e2\u02dc\u0192 + 1, i, \u00e2\u02dc\u0192)) {
                            object = ((BlockPos)\u00e2\u02dc\u0192142).m_5484_(p_73783_.m_55954_(Direction.SOUTH), 7);
                            object = ((BlockPos)object).m_5484_(p_73783_.m_55954_(Direction.EAST), 7);
                            p_73784_.add(new WoodlandMansionPiece(this.f_73774_, direction == Direction.SOUTH ? \u00e2\u02dc\u019212 : \u00e2\u02dc\u019211, (BlockPos)object, p_73783_.m_55952_(Rotation.CLOCKWISE_90)));
                        }
                        if (\u00e2\u02dc\u01928.m_73872_(n2, \u00e2\u02dc\u0192 - 1) == 1 && !bl2) {
                            object = ((BlockPos)\u00e2\u02dc\u0192142).m_5484_(p_73783_.m_55954_(Direction.NORTH), 1);
                            object = ((BlockPos)object).m_5484_(p_73783_.m_55954_(Direction.EAST), 7);
                            p_73784_.add(new WoodlandMansionPiece(this.f_73774_, direction == Direction.NORTH ? \u00e2\u02dc\u019212 : \u00e2\u02dc\u019211, (BlockPos)object, p_73783_.m_55952_(Rotation.CLOCKWISE_90)));
                        }
                        if (n == 65536) {
                            this.m_73809_(p_73784_, (BlockPos)\u00e2\u02dc\u0192142, p_73783_, direction, floorRoomCollectionArray[i]);
                            continue;
                        }
                        if (n == 131072 && direction != null) {
                            object = p_73785_.m_73762_(\u00e2\u02dc\u01928, n2, \u00e2\u02dc\u0192, i, \u00e2\u02dc\u0192);
                            boolean \u00e2\u02dc\u019215 = (\u00e2\u02dc\u0192 & 0x400000) == 0x400000;
                            this.m_73822_(p_73784_, (BlockPos)\u00e2\u02dc\u0192142, p_73783_, (Direction)object, direction, floorRoomCollectionArray[i], \u00e2\u02dc\u019215);
                            continue;
                        }
                        if (n == 262144 && direction != null && direction != Direction.UP) {
                            object = direction.m_122427_();
                            if (!p_73785_.m_73744_(\u00e2\u02dc\u01928, n2 + ((Direction)object).m_122429_(), \u00e2\u02dc\u0192 + ((Direction)object).m_122431_(), i, \u00e2\u02dc\u0192)) {
                                object = ((Direction)object).m_122424_();
                            }
                            this.m_73815_(p_73784_, (BlockPos)\u00e2\u02dc\u0192142, p_73783_, (Direction)object, direction, floorRoomCollectionArray[i]);
                            continue;
                        }
                        if (n != 262144 || direction != Direction.UP) continue;
                        this.m_73798_(p_73784_, (BlockPos)\u00e2\u02dc\u0192142, p_73783_, floorRoomCollectionArray[i]);
                    }
                }
            }
        }

        private void m_73789_(List<WoodlandMansionPiece> p_73790_, PlacementData p_73791_, SimpleGrid p_73792_, Direction p_73793_, int p_73794_, int p_73795_, int p_73796_, int p_73797_) {
            int n = p_73794_;
            \u00e2\u02dc\u0192 = p_73795_;
            Direction \u00e2\u02dc\u01922 = p_73793_;
            do {
                if (!MansionGrid.m_73740_(p_73792_, n + p_73793_.m_122429_(), \u00e2\u02dc\u0192 + p_73793_.m_122431_())) {
                    this.m_73833_(p_73790_, p_73791_);
                    p_73793_ = p_73793_.m_122427_();
                    if (n == p_73796_ && \u00e2\u02dc\u0192 == p_73797_ && \u00e2\u02dc\u01922 == p_73793_) continue;
                    this.m_73830_(p_73790_, p_73791_);
                    continue;
                }
                if (MansionGrid.m_73740_(p_73792_, n + p_73793_.m_122429_(), \u00e2\u02dc\u0192 + p_73793_.m_122431_()) && MansionGrid.m_73740_(p_73792_, n + p_73793_.m_122429_() + p_73793_.m_122428_().m_122429_(), \u00e2\u02dc\u0192 + p_73793_.m_122431_() + p_73793_.m_122428_().m_122431_())) {
                    this.m_73836_(p_73790_, p_73791_);
                    n += p_73793_.m_122429_();
                    \u00e2\u02dc\u0192 += p_73793_.m_122431_();
                    p_73793_ = p_73793_.m_122428_();
                    continue;
                }
                if ((n += p_73793_.m_122429_()) == p_73796_ && (\u00e2\u02dc\u0192 += p_73793_.m_122431_()) == p_73797_ && \u00e2\u02dc\u01922 == p_73793_) continue;
                this.m_73830_(p_73790_, p_73791_);
            } while (n != p_73796_ || \u00e2\u02dc\u0192 != p_73797_ || \u00e2\u02dc\u01922 != p_73793_);
        }

        private void m_73803_(List<WoodlandMansionPiece> p_73804_, BlockPos p_73805_, Rotation p_73806_, SimpleGrid p_73807_, @Nullable SimpleGrid p_73808_) {
            boolean \u00e2\u02dc\u01922;
            BlockPos blockPos;
            int n;
            for (n = 0; n < p_73807_.f_73866_; ++n) {
                for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < p_73807_.f_73865_; ++\u00e2\u02dc\u0192) {
                    blockPos = p_73805_;
                    blockPos = blockPos.m_5484_(p_73806_.m_55954_(Direction.SOUTH), 8 + (n - this.f_73777_) * 8);
                    blockPos = blockPos.m_5484_(p_73806_.m_55954_(Direction.EAST), (\u00e2\u02dc\u0192 - this.f_73776_) * 8);
                    boolean bl = \u00e2\u02dc\u01922 = p_73808_ != null && MansionGrid.m_73740_(p_73808_, \u00e2\u02dc\u0192, n);
                    if (!MansionGrid.m_73740_(p_73807_, \u00e2\u02dc\u0192, n) || \u00e2\u02dc\u01922) continue;
                    p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "roof", blockPos.m_6630_(3), p_73806_));
                    if (!MansionGrid.m_73740_(p_73807_, \u00e2\u02dc\u0192 + 1, n)) {
                        \u00e2\u02dc\u0192 = blockPos.m_5484_(p_73806_.m_55954_(Direction.EAST), 6);
                        p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "roof_front", \u00e2\u02dc\u0192, p_73806_));
                    }
                    if (!MansionGrid.m_73740_(p_73807_, \u00e2\u02dc\u0192 - 1, n)) {
                        \u00e2\u02dc\u0192 = blockPos.m_5484_(p_73806_.m_55954_(Direction.EAST), 0);
                        \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192.m_5484_(p_73806_.m_55954_(Direction.SOUTH), 7);
                        p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "roof_front", \u00e2\u02dc\u0192, p_73806_.m_55952_(Rotation.CLOCKWISE_180)));
                    }
                    if (!MansionGrid.m_73740_(p_73807_, \u00e2\u02dc\u0192, n - 1)) {
                        \u00e2\u02dc\u0192 = blockPos.m_5484_(p_73806_.m_55954_(Direction.WEST), 1);
                        p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "roof_front", \u00e2\u02dc\u0192, p_73806_.m_55952_(Rotation.COUNTERCLOCKWISE_90)));
                    }
                    if (MansionGrid.m_73740_(p_73807_, \u00e2\u02dc\u0192, n + 1)) continue;
                    \u00e2\u02dc\u0192 = blockPos.m_5484_(p_73806_.m_55954_(Direction.EAST), 6);
                    \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192.m_5484_(p_73806_.m_55954_(Direction.SOUTH), 6);
                    p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "roof_front", \u00e2\u02dc\u0192, p_73806_.m_55952_(Rotation.CLOCKWISE_90)));
                }
            }
            if (p_73808_ != null) {
                for (n = 0; n < p_73807_.f_73866_; ++n) {
                    for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < p_73807_.f_73865_; ++\u00e2\u02dc\u0192) {
                        blockPos = p_73805_;
                        blockPos = blockPos.m_5484_(p_73806_.m_55954_(Direction.SOUTH), 8 + (n - this.f_73777_) * 8);
                        blockPos = blockPos.m_5484_(p_73806_.m_55954_(Direction.EAST), (\u00e2\u02dc\u0192 - this.f_73776_) * 8);
                        \u00e2\u02dc\u01922 = MansionGrid.m_73740_(p_73808_, \u00e2\u02dc\u0192, n);
                        if (!MansionGrid.m_73740_(p_73807_, \u00e2\u02dc\u0192, n) || !\u00e2\u02dc\u01922) continue;
                        if (!MansionGrid.m_73740_(p_73807_, \u00e2\u02dc\u0192 + 1, n)) {
                            \u00e2\u02dc\u0192 = blockPos.m_5484_(p_73806_.m_55954_(Direction.EAST), 7);
                            p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "small_wall", \u00e2\u02dc\u0192, p_73806_));
                        }
                        if (!MansionGrid.m_73740_(p_73807_, \u00e2\u02dc\u0192 - 1, n)) {
                            \u00e2\u02dc\u0192 = blockPos.m_5484_(p_73806_.m_55954_(Direction.WEST), 1);
                            \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192.m_5484_(p_73806_.m_55954_(Direction.SOUTH), 6);
                            p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "small_wall", \u00e2\u02dc\u0192, p_73806_.m_55952_(Rotation.CLOCKWISE_180)));
                        }
                        if (!MansionGrid.m_73740_(p_73807_, \u00e2\u02dc\u0192, n - 1)) {
                            \u00e2\u02dc\u0192 = blockPos.m_5484_(p_73806_.m_55954_(Direction.WEST), 0);
                            \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192.m_5484_(p_73806_.m_55954_(Direction.NORTH), 1);
                            p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "small_wall", \u00e2\u02dc\u0192, p_73806_.m_55952_(Rotation.COUNTERCLOCKWISE_90)));
                        }
                        if (!MansionGrid.m_73740_(p_73807_, \u00e2\u02dc\u0192, n + 1)) {
                            \u00e2\u02dc\u0192 = blockPos.m_5484_(p_73806_.m_55954_(Direction.EAST), 6);
                            \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192.m_5484_(p_73806_.m_55954_(Direction.SOUTH), 7);
                            p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "small_wall", \u00e2\u02dc\u0192, p_73806_.m_55952_(Rotation.CLOCKWISE_90)));
                        }
                        if (!MansionGrid.m_73740_(p_73807_, \u00e2\u02dc\u0192 + 1, n)) {
                            if (!MansionGrid.m_73740_(p_73807_, \u00e2\u02dc\u0192, n - 1)) {
                                \u00e2\u02dc\u0192 = blockPos.m_5484_(p_73806_.m_55954_(Direction.EAST), 7);
                                \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192.m_5484_(p_73806_.m_55954_(Direction.NORTH), 2);
                                p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "small_wall_corner", \u00e2\u02dc\u0192, p_73806_));
                            }
                            if (!MansionGrid.m_73740_(p_73807_, \u00e2\u02dc\u0192, n + 1)) {
                                \u00e2\u02dc\u0192 = blockPos.m_5484_(p_73806_.m_55954_(Direction.EAST), 8);
                                \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192.m_5484_(p_73806_.m_55954_(Direction.SOUTH), 7);
                                p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "small_wall_corner", \u00e2\u02dc\u0192, p_73806_.m_55952_(Rotation.CLOCKWISE_90)));
                            }
                        }
                        if (MansionGrid.m_73740_(p_73807_, \u00e2\u02dc\u0192 - 1, n)) continue;
                        if (!MansionGrid.m_73740_(p_73807_, \u00e2\u02dc\u0192, n - 1)) {
                            \u00e2\u02dc\u0192 = blockPos.m_5484_(p_73806_.m_55954_(Direction.WEST), 2);
                            \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192.m_5484_(p_73806_.m_55954_(Direction.NORTH), 1);
                            p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "small_wall_corner", \u00e2\u02dc\u0192, p_73806_.m_55952_(Rotation.COUNTERCLOCKWISE_90)));
                        }
                        if (MansionGrid.m_73740_(p_73807_, \u00e2\u02dc\u0192, n + 1)) continue;
                        \u00e2\u02dc\u0192 = blockPos.m_5484_(p_73806_.m_55954_(Direction.WEST), 1);
                        \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192.m_5484_(p_73806_.m_55954_(Direction.SOUTH), 8);
                        p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "small_wall_corner", \u00e2\u02dc\u0192, p_73806_.m_55952_(Rotation.CLOCKWISE_180)));
                    }
                }
            }
            for (n = 0; n < p_73807_.f_73866_; ++n) {
                for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < p_73807_.f_73865_; ++\u00e2\u02dc\u0192) {
                    blockPos = p_73805_;
                    blockPos = blockPos.m_5484_(p_73806_.m_55954_(Direction.SOUTH), 8 + (n - this.f_73777_) * 8);
                    blockPos = blockPos.m_5484_(p_73806_.m_55954_(Direction.EAST), (\u00e2\u02dc\u0192 - this.f_73776_) * 8);
                    boolean bl = \u00e2\u02dc\u01922 = p_73808_ != null && MansionGrid.m_73740_(p_73808_, \u00e2\u02dc\u0192, n);
                    if (!MansionGrid.m_73740_(p_73807_, \u00e2\u02dc\u0192, n) || \u00e2\u02dc\u01922) continue;
                    if (!MansionGrid.m_73740_(p_73807_, \u00e2\u02dc\u0192 + 1, n)) {
                        \u00e2\u02dc\u0192 = blockPos.m_5484_(p_73806_.m_55954_(Direction.EAST), 6);
                        if (!MansionGrid.m_73740_(p_73807_, \u00e2\u02dc\u0192, n + 1)) {
                            \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192.m_5484_(p_73806_.m_55954_(Direction.SOUTH), 6);
                            p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "roof_corner", \u00e2\u02dc\u0192, p_73806_));
                        } else if (MansionGrid.m_73740_(p_73807_, \u00e2\u02dc\u0192 + 1, n + 1)) {
                            \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192.m_5484_(p_73806_.m_55954_(Direction.SOUTH), 5);
                            p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "roof_inner_corner", \u00e2\u02dc\u0192, p_73806_));
                        }
                        if (!MansionGrid.m_73740_(p_73807_, \u00e2\u02dc\u0192, n - 1)) {
                            p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "roof_corner", \u00e2\u02dc\u0192, p_73806_.m_55952_(Rotation.COUNTERCLOCKWISE_90)));
                        } else if (MansionGrid.m_73740_(p_73807_, \u00e2\u02dc\u0192 + 1, n - 1)) {
                            \u00e2\u02dc\u0192 = blockPos.m_5484_(p_73806_.m_55954_(Direction.EAST), 9);
                            \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192.m_5484_(p_73806_.m_55954_(Direction.NORTH), 2);
                            p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "roof_inner_corner", \u00e2\u02dc\u0192, p_73806_.m_55952_(Rotation.CLOCKWISE_90)));
                        }
                    }
                    if (MansionGrid.m_73740_(p_73807_, \u00e2\u02dc\u0192 - 1, n)) continue;
                    \u00e2\u02dc\u0192 = blockPos.m_5484_(p_73806_.m_55954_(Direction.EAST), 0);
                    \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192.m_5484_(p_73806_.m_55954_(Direction.SOUTH), 0);
                    if (!MansionGrid.m_73740_(p_73807_, \u00e2\u02dc\u0192, n + 1)) {
                        \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192.m_5484_(p_73806_.m_55954_(Direction.SOUTH), 6);
                        p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "roof_corner", \u00e2\u02dc\u0192, p_73806_.m_55952_(Rotation.CLOCKWISE_90)));
                    } else if (MansionGrid.m_73740_(p_73807_, \u00e2\u02dc\u0192 - 1, n + 1)) {
                        \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192.m_5484_(p_73806_.m_55954_(Direction.SOUTH), 8);
                        \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192.m_5484_(p_73806_.m_55954_(Direction.WEST), 3);
                        p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "roof_inner_corner", \u00e2\u02dc\u0192, p_73806_.m_55952_(Rotation.COUNTERCLOCKWISE_90)));
                    }
                    if (!MansionGrid.m_73740_(p_73807_, \u00e2\u02dc\u0192, n - 1)) {
                        p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "roof_corner", \u00e2\u02dc\u0192, p_73806_.m_55952_(Rotation.CLOCKWISE_180)));
                        continue;
                    }
                    if (!MansionGrid.m_73740_(p_73807_, \u00e2\u02dc\u0192 - 1, n - 1)) continue;
                    \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192.m_5484_(p_73806_.m_55954_(Direction.SOUTH), 1);
                    p_73804_.add(new WoodlandMansionPiece(this.f_73774_, "roof_inner_corner", \u00e2\u02dc\u0192, p_73806_.m_55952_(Rotation.CLOCKWISE_180)));
                }
            }
        }

        private void m_73786_(List<WoodlandMansionPiece> p_73787_, PlacementData p_73788_) {
            Direction direction = p_73788_.f_73839_.m_55954_(Direction.WEST);
            p_73787_.add(new WoodlandMansionPiece(this.f_73774_, "entrance", p_73788_.f_73840_.m_5484_(direction, 9), p_73788_.f_73839_));
            p_73788_.f_73840_ = p_73788_.f_73840_.m_5484_(p_73788_.f_73839_.m_55954_(Direction.SOUTH), 16);
        }

        private void m_73830_(List<WoodlandMansionPiece> p_73831_, PlacementData p_73832_) {
            p_73831_.add(new WoodlandMansionPiece(this.f_73774_, p_73832_.f_73841_, p_73832_.f_73840_.m_5484_(p_73832_.f_73839_.m_55954_(Direction.EAST), 7), p_73832_.f_73839_));
            p_73832_.f_73840_ = p_73832_.f_73840_.m_5484_(p_73832_.f_73839_.m_55954_(Direction.SOUTH), 8);
        }

        private void m_73833_(List<WoodlandMansionPiece> p_73834_, PlacementData p_73835_) {
            p_73835_.f_73840_ = p_73835_.f_73840_.m_5484_(p_73835_.f_73839_.m_55954_(Direction.SOUTH), -1);
            p_73834_.add(new WoodlandMansionPiece(this.f_73774_, "wall_corner", p_73835_.f_73840_, p_73835_.f_73839_));
            p_73835_.f_73840_ = p_73835_.f_73840_.m_5484_(p_73835_.f_73839_.m_55954_(Direction.SOUTH), -7);
            p_73835_.f_73840_ = p_73835_.f_73840_.m_5484_(p_73835_.f_73839_.m_55954_(Direction.WEST), -6);
            p_73835_.f_73839_ = p_73835_.f_73839_.m_55952_(Rotation.CLOCKWISE_90);
        }

        private void m_73836_(List<WoodlandMansionPiece> p_73837_, PlacementData p_73838_) {
            p_73838_.f_73840_ = p_73838_.f_73840_.m_5484_(p_73838_.f_73839_.m_55954_(Direction.SOUTH), 6);
            p_73838_.f_73840_ = p_73838_.f_73840_.m_5484_(p_73838_.f_73839_.m_55954_(Direction.EAST), 8);
            p_73838_.f_73839_ = p_73838_.f_73839_.m_55952_(Rotation.COUNTERCLOCKWISE_90);
        }

        private void m_73809_(List<WoodlandMansionPiece> p_73810_, BlockPos p_73811_, Rotation p_73812_, Direction p_73813_, FloorRoomCollection p_73814_) {
            Rotation rotation = Rotation.NONE;
            String \u00e2\u02dc\u01922 = p_73814_.m_7668_(this.f_73775_);
            if (p_73813_ != Direction.EAST) {
                if (p_73813_ == Direction.NORTH) {
                    rotation = rotation.m_55952_(Rotation.COUNTERCLOCKWISE_90);
                } else if (p_73813_ == Direction.WEST) {
                    rotation = rotation.m_55952_(Rotation.CLOCKWISE_180);
                } else if (p_73813_ == Direction.SOUTH) {
                    rotation = rotation.m_55952_(Rotation.CLOCKWISE_90);
                } else {
                    \u00e2\u02dc\u01922 = p_73814_.m_7669_(this.f_73775_);
                }
            }
            BlockPos \u00e2\u02dc\u01923 = StructureTemplate.m_74587_(new BlockPos(1, 0, 0), Mirror.NONE, rotation, 7, 7);
            rotation = rotation.m_55952_(p_73812_);
            \u00e2\u02dc\u01923 = \u00e2\u02dc\u01923.m_7954_(p_73812_);
            BlockPos \u00e2\u02dc\u01924 = p_73811_.m_142082_(\u00e2\u02dc\u01923.m_123341_(), 0, \u00e2\u02dc\u01923.m_123343_());
            p_73810_.add(new WoodlandMansionPiece(this.f_73774_, \u00e2\u02dc\u01922, \u00e2\u02dc\u01924, rotation));
        }

        private void m_73822_(List<WoodlandMansionPiece> p_73823_, BlockPos p_73824_, Rotation p_73825_, Direction p_73826_, Direction p_73827_, FloorRoomCollection p_73828_, boolean p_73829_) {
            if (p_73827_ == Direction.EAST && p_73826_ == Direction.SOUTH) {
                BlockPos blockPos = p_73824_.m_5484_(p_73825_.m_55954_(Direction.EAST), 1);
                p_73823_.add(new WoodlandMansionPiece(this.f_73774_, p_73828_.m_5900_(this.f_73775_, p_73829_), blockPos, p_73825_));
            } else if (p_73827_ == Direction.EAST && p_73826_ == Direction.NORTH) {
                BlockPos blockPos = p_73824_.m_5484_(p_73825_.m_55954_(Direction.EAST), 1);
                blockPos = blockPos.m_5484_(p_73825_.m_55954_(Direction.SOUTH), 6);
                p_73823_.add(new WoodlandMansionPiece(this.f_73774_, p_73828_.m_5900_(this.f_73775_, p_73829_), blockPos, p_73825_, Mirror.LEFT_RIGHT));
            } else if (p_73827_ == Direction.WEST && p_73826_ == Direction.NORTH) {
                BlockPos blockPos = p_73824_.m_5484_(p_73825_.m_55954_(Direction.EAST), 7);
                blockPos = blockPos.m_5484_(p_73825_.m_55954_(Direction.SOUTH), 6);
                p_73823_.add(new WoodlandMansionPiece(this.f_73774_, p_73828_.m_5900_(this.f_73775_, p_73829_), blockPos, p_73825_.m_55952_(Rotation.CLOCKWISE_180)));
            } else if (p_73827_ == Direction.WEST && p_73826_ == Direction.SOUTH) {
                BlockPos blockPos = p_73824_.m_5484_(p_73825_.m_55954_(Direction.EAST), 7);
                p_73823_.add(new WoodlandMansionPiece(this.f_73774_, p_73828_.m_5900_(this.f_73775_, p_73829_), blockPos, p_73825_, Mirror.FRONT_BACK));
            } else if (p_73827_ == Direction.SOUTH && p_73826_ == Direction.EAST) {
                BlockPos blockPos = p_73824_.m_5484_(p_73825_.m_55954_(Direction.EAST), 1);
                p_73823_.add(new WoodlandMansionPiece(this.f_73774_, p_73828_.m_5900_(this.f_73775_, p_73829_), blockPos, p_73825_.m_55952_(Rotation.CLOCKWISE_90), Mirror.LEFT_RIGHT));
            } else if (p_73827_ == Direction.SOUTH && p_73826_ == Direction.WEST) {
                BlockPos blockPos = p_73824_.m_5484_(p_73825_.m_55954_(Direction.EAST), 7);
                p_73823_.add(new WoodlandMansionPiece(this.f_73774_, p_73828_.m_5900_(this.f_73775_, p_73829_), blockPos, p_73825_.m_55952_(Rotation.CLOCKWISE_90)));
            } else if (p_73827_ == Direction.NORTH && p_73826_ == Direction.WEST) {
                BlockPos blockPos = p_73824_.m_5484_(p_73825_.m_55954_(Direction.EAST), 7);
                blockPos = blockPos.m_5484_(p_73825_.m_55954_(Direction.SOUTH), 6);
                p_73823_.add(new WoodlandMansionPiece(this.f_73774_, p_73828_.m_5900_(this.f_73775_, p_73829_), blockPos, p_73825_.m_55952_(Rotation.CLOCKWISE_90), Mirror.FRONT_BACK));
            } else if (p_73827_ == Direction.NORTH && p_73826_ == Direction.EAST) {
                BlockPos blockPos = p_73824_.m_5484_(p_73825_.m_55954_(Direction.EAST), 1);
                blockPos = blockPos.m_5484_(p_73825_.m_55954_(Direction.SOUTH), 6);
                p_73823_.add(new WoodlandMansionPiece(this.f_73774_, p_73828_.m_5900_(this.f_73775_, p_73829_), blockPos, p_73825_.m_55952_(Rotation.COUNTERCLOCKWISE_90)));
            } else if (p_73827_ == Direction.SOUTH && p_73826_ == Direction.NORTH) {
                BlockPos blockPos = p_73824_.m_5484_(p_73825_.m_55954_(Direction.EAST), 1);
                blockPos = blockPos.m_5484_(p_73825_.m_55954_(Direction.NORTH), 8);
                p_73823_.add(new WoodlandMansionPiece(this.f_73774_, p_73828_.m_5899_(this.f_73775_, p_73829_), blockPos, p_73825_));
            } else if (p_73827_ == Direction.NORTH && p_73826_ == Direction.SOUTH) {
                BlockPos blockPos = p_73824_.m_5484_(p_73825_.m_55954_(Direction.EAST), 7);
                blockPos = blockPos.m_5484_(p_73825_.m_55954_(Direction.SOUTH), 14);
                p_73823_.add(new WoodlandMansionPiece(this.f_73774_, p_73828_.m_5899_(this.f_73775_, p_73829_), blockPos, p_73825_.m_55952_(Rotation.CLOCKWISE_180)));
            } else if (p_73827_ == Direction.WEST && p_73826_ == Direction.EAST) {
                BlockPos blockPos = p_73824_.m_5484_(p_73825_.m_55954_(Direction.EAST), 15);
                p_73823_.add(new WoodlandMansionPiece(this.f_73774_, p_73828_.m_5899_(this.f_73775_, p_73829_), blockPos, p_73825_.m_55952_(Rotation.CLOCKWISE_90)));
            } else if (p_73827_ == Direction.EAST && p_73826_ == Direction.WEST) {
                BlockPos blockPos = p_73824_.m_5484_(p_73825_.m_55954_(Direction.WEST), 7);
                blockPos = blockPos.m_5484_(p_73825_.m_55954_(Direction.SOUTH), 6);
                p_73823_.add(new WoodlandMansionPiece(this.f_73774_, p_73828_.m_5899_(this.f_73775_, p_73829_), blockPos, p_73825_.m_55952_(Rotation.COUNTERCLOCKWISE_90)));
            } else if (p_73827_ == Direction.UP && p_73826_ == Direction.EAST) {
                BlockPos blockPos = p_73824_.m_5484_(p_73825_.m_55954_(Direction.EAST), 15);
                p_73823_.add(new WoodlandMansionPiece(this.f_73774_, p_73828_.m_7672_(this.f_73775_), blockPos, p_73825_.m_55952_(Rotation.CLOCKWISE_90)));
            } else if (p_73827_ == Direction.UP && p_73826_ == Direction.SOUTH) {
                BlockPos blockPos = p_73824_.m_5484_(p_73825_.m_55954_(Direction.EAST), 1);
                blockPos = blockPos.m_5484_(p_73825_.m_55954_(Direction.NORTH), 0);
                p_73823_.add(new WoodlandMansionPiece(this.f_73774_, p_73828_.m_7672_(this.f_73775_), blockPos, p_73825_));
            }
        }

        private void m_73815_(List<WoodlandMansionPiece> p_73816_, BlockPos p_73817_, Rotation p_73818_, Direction p_73819_, Direction p_73820_, FloorRoomCollection p_73821_) {
            int n = 0;
            \u00e2\u02dc\u0192 = 0;
            Rotation \u00e2\u02dc\u01922 = p_73818_;
            Mirror \u00e2\u02dc\u01923 = Mirror.NONE;
            if (p_73820_ == Direction.EAST && p_73819_ == Direction.SOUTH) {
                n = -7;
            } else if (p_73820_ == Direction.EAST && p_73819_ == Direction.NORTH) {
                n = -7;
                \u00e2\u02dc\u0192 = 6;
                \u00e2\u02dc\u01923 = Mirror.LEFT_RIGHT;
            } else if (p_73820_ == Direction.NORTH && p_73819_ == Direction.EAST) {
                n = 1;
                \u00e2\u02dc\u0192 = 14;
                \u00e2\u02dc\u01922 = p_73818_.m_55952_(Rotation.COUNTERCLOCKWISE_90);
            } else if (p_73820_ == Direction.NORTH && p_73819_ == Direction.WEST) {
                n = 7;
                \u00e2\u02dc\u0192 = 14;
                \u00e2\u02dc\u01922 = p_73818_.m_55952_(Rotation.COUNTERCLOCKWISE_90);
                \u00e2\u02dc\u01923 = Mirror.LEFT_RIGHT;
            } else if (p_73820_ == Direction.SOUTH && p_73819_ == Direction.WEST) {
                n = 7;
                \u00e2\u02dc\u0192 = -8;
                \u00e2\u02dc\u01922 = p_73818_.m_55952_(Rotation.CLOCKWISE_90);
            } else if (p_73820_ == Direction.SOUTH && p_73819_ == Direction.EAST) {
                n = 1;
                \u00e2\u02dc\u0192 = -8;
                \u00e2\u02dc\u01922 = p_73818_.m_55952_(Rotation.CLOCKWISE_90);
                \u00e2\u02dc\u01923 = Mirror.LEFT_RIGHT;
            } else if (p_73820_ == Direction.WEST && p_73819_ == Direction.NORTH) {
                n = 15;
                \u00e2\u02dc\u0192 = 6;
                \u00e2\u02dc\u01922 = p_73818_.m_55952_(Rotation.CLOCKWISE_180);
            } else if (p_73820_ == Direction.WEST && p_73819_ == Direction.SOUTH) {
                n = 15;
                \u00e2\u02dc\u01923 = Mirror.FRONT_BACK;
            }
            BlockPos \u00e2\u02dc\u01924 = p_73817_.m_5484_(p_73818_.m_55954_(Direction.EAST), n);
            \u00e2\u02dc\u01924 = \u00e2\u02dc\u01924.m_5484_(p_73818_.m_55954_(Direction.SOUTH), \u00e2\u02dc\u0192);
            p_73816_.add(new WoodlandMansionPiece(this.f_73774_, p_73821_.m_7661_(this.f_73775_), \u00e2\u02dc\u01924, \u00e2\u02dc\u01922, \u00e2\u02dc\u01923));
        }

        private void m_73798_(List<WoodlandMansionPiece> p_73799_, BlockPos p_73800_, Rotation p_73801_, FloorRoomCollection p_73802_) {
            BlockPos blockPos = p_73800_.m_5484_(p_73801_.m_55954_(Direction.EAST), 1);
            p_73799_.add(new WoodlandMansionPiece(this.f_73774_, p_73802_.m_7676_(this.f_73775_), blockPos, p_73801_, Mirror.NONE));
        }
    }

    static class ThirdFloorRoomCollection
    extends SecondFloorRoomCollection {
        ThirdFloorRoomCollection() {
        }
    }

    static class SecondFloorRoomCollection
    extends FloorRoomCollection {
        SecondFloorRoomCollection() {
        }

        @Override
        public String m_7668_(Random p_73849_) {
            return "1x1_b" + (p_73849_.nextInt(4) + 1);
        }

        @Override
        public String m_7669_(Random p_73854_) {
            return "1x1_as" + (p_73854_.nextInt(4) + 1);
        }

        @Override
        public String m_5900_(Random p_73851_, boolean p_73852_) {
            if (p_73852_) {
                return "1x2_c_stairs";
            }
            return "1x2_c" + (p_73851_.nextInt(4) + 1);
        }

        @Override
        public String m_5899_(Random p_73856_, boolean p_73857_) {
            if (p_73857_) {
                return "1x2_d_stairs";
            }
            return "1x2_d" + (p_73856_.nextInt(5) + 1);
        }

        @Override
        public String m_7672_(Random p_73859_) {
            return "1x2_se" + (p_73859_.nextInt(1) + 1);
        }

        @Override
        public String m_7661_(Random p_73861_) {
            return "2x2_b" + (p_73861_.nextInt(5) + 1);
        }

        @Override
        public String m_7676_(Random p_73863_) {
            return "2x2_s1";
        }
    }

    static class FirstFloorRoomCollection
    extends FloorRoomCollection {
        FirstFloorRoomCollection() {
        }

        @Override
        public String m_7668_(Random p_73701_) {
            return "1x1_a" + (p_73701_.nextInt(5) + 1);
        }

        @Override
        public String m_7669_(Random p_73706_) {
            return "1x1_as" + (p_73706_.nextInt(4) + 1);
        }

        @Override
        public String m_5900_(Random p_73703_, boolean p_73704_) {
            return "1x2_a" + (p_73703_.nextInt(9) + 1);
        }

        @Override
        public String m_5899_(Random p_73708_, boolean p_73709_) {
            return "1x2_b" + (p_73708_.nextInt(5) + 1);
        }

        @Override
        public String m_7672_(Random p_73711_) {
            return "1x2_s" + (p_73711_.nextInt(2) + 1);
        }

        @Override
        public String m_7661_(Random p_73713_) {
            return "2x2_a" + (p_73713_.nextInt(4) + 1);
        }

        @Override
        public String m_7676_(Random p_73715_) {
            return "2x2_s1";
        }
    }

    static abstract class FloorRoomCollection {
        FloorRoomCollection() {
        }

        public abstract String m_7668_(Random var1);

        public abstract String m_7669_(Random var1);

        public abstract String m_5900_(Random var1, boolean var2);

        public abstract String m_5899_(Random var1, boolean var2);

        public abstract String m_7672_(Random var1);

        public abstract String m_7661_(Random var1);

        public abstract String m_7676_(Random var1);
    }

    static class SimpleGrid {
        private final int[][] f_73864_;
        final int f_73865_;
        final int f_73866_;
        private final int f_73867_;

        public SimpleGrid(int p_73869_, int p_73870_, int p_73871_) {
            this.f_73865_ = p_73869_;
            this.f_73866_ = p_73870_;
            this.f_73867_ = p_73871_;
            this.f_73864_ = new int[p_73869_][p_73870_];
        }

        public void m_73875_(int p_73876_, int p_73877_, int p_73878_) {
            if (p_73876_ >= 0 && p_73876_ < this.f_73865_ && p_73877_ >= 0 && p_73877_ < this.f_73866_) {
                this.f_73864_[p_73876_][p_73877_] = p_73878_;
            }
        }

        public void m_73884_(int p_73885_, int p_73886_, int p_73887_, int p_73888_, int p_73889_) {
            for (int i = p_73886_; i <= p_73888_; ++i) {
                for (\u00e2\u02dc\u0192 = p_73885_; \u00e2\u02dc\u0192 <= p_73887_; ++\u00e2\u02dc\u0192) {
                    this.m_73875_(\u00e2\u02dc\u0192, i, p_73889_);
                }
            }
        }

        public int m_73872_(int p_73873_, int p_73874_) {
            if (p_73873_ >= 0 && p_73873_ < this.f_73865_ && p_73874_ >= 0 && p_73874_ < this.f_73866_) {
                return this.f_73864_[p_73873_][p_73874_];
            }
            return this.f_73867_;
        }

        public void m_73879_(int p_73880_, int p_73881_, int p_73882_, int p_73883_) {
            if (this.m_73872_(p_73880_, p_73881_) == p_73882_) {
                this.m_73875_(p_73880_, p_73881_, p_73883_);
            }
        }

        public boolean m_73892_(int p_73893_, int p_73894_, int p_73895_) {
            return this.m_73872_(p_73893_ - 1, p_73894_) == p_73895_ || this.m_73872_(p_73893_ + 1, p_73894_) == p_73895_ || this.m_73872_(p_73893_, p_73894_ + 1) == p_73895_ || this.m_73872_(p_73893_, p_73894_ - 1) == p_73895_;
        }
    }

    static class PlacementData {
        public Rotation f_73839_;
        public BlockPos f_73840_;
        public String f_73841_;

        PlacementData() {
        }
    }

    public static class WoodlandMansionPiece
    extends TemplateStructurePiece {
        public WoodlandMansionPiece(StructureManager p_73905_, String p_73906_, BlockPos p_73907_, Rotation p_73908_) {
            this(p_73905_, p_73906_, p_73907_, p_73908_, Mirror.NONE);
        }

        public WoodlandMansionPiece(StructureManager p_73910_, String p_73911_, BlockPos p_73912_, Rotation p_73913_, Mirror p_73914_) {
            super(StructurePieceType.f_67131_, 0, p_73910_, WoodlandMansionPiece.m_163705_(p_73911_), p_73911_, WoodlandMansionPiece.m_163702_(p_73914_, p_73913_), p_73912_);
        }

        public WoodlandMansionPiece(ServerLevel p_163696_, CompoundTag p_163697_) {
            super(StructurePieceType.f_67131_, p_163697_, p_163696_, (ResourceLocation p_163709_) -> WoodlandMansionPiece.m_163702_(Mirror.valueOf(p_163697_.m_128461_("Mi")), Rotation.valueOf(p_163697_.m_128461_("Rot"))));
        }

        @Override
        protected ResourceLocation m_142415_() {
            return WoodlandMansionPiece.m_163705_(this.f_163658_);
        }

        private static ResourceLocation m_163705_(String p_163706_) {
            return new ResourceLocation("woodland_mansion/" + p_163706_);
        }

        private static StructurePlaceSettings m_163702_(Mirror p_163703_, Rotation p_163704_) {
            return new StructurePlaceSettings().m_74392_(true).m_74379_(p_163704_).m_74377_(p_163703_).m_74383_(BlockIgnoreProcessor.f_74046_);
        }

        @Override
        protected void m_142347_(ServerLevel p_163700_, CompoundTag p_163701_) {
            super.m_142347_(p_163700_, p_163701_);
            p_163701_.m_128359_("Rot", this.f_73657_.m_74404_().name());
            p_163701_.m_128359_("Mi", this.f_73657_.m_74401_().name());
        }

        @Override
        protected void m_7756_(String p_73921_, BlockPos p_73922_, ServerLevelAccessor p_73923_, Random p_73924_, BoundingBox p_73925_) {
            if (p_73921_.startsWith("Chest")) {
                Rotation rotation = this.f_73657_.m_74404_();
                BlockState \u00e2\u02dc\u01922 = Blocks.f_50087_.m_49966_();
                if ("ChestWest".equals(p_73921_)) {
                    \u00e2\u02dc\u01922 = (BlockState)\u00e2\u02dc\u01922.m_61124_(ChestBlock.f_51478_, rotation.m_55954_(Direction.WEST));
                } else if ("ChestEast".equals(p_73921_)) {
                    \u00e2\u02dc\u01922 = (BlockState)\u00e2\u02dc\u01922.m_61124_(ChestBlock.f_51478_, rotation.m_55954_(Direction.EAST));
                } else if ("ChestSouth".equals(p_73921_)) {
                    \u00e2\u02dc\u01922 = (BlockState)\u00e2\u02dc\u01922.m_61124_(ChestBlock.f_51478_, rotation.m_55954_(Direction.SOUTH));
                } else if ("ChestNorth".equals(p_73921_)) {
                    \u00e2\u02dc\u01922 = (BlockState)\u00e2\u02dc\u01922.m_61124_(ChestBlock.f_51478_, rotation.m_55954_(Direction.NORTH));
                }
                this.m_73420_(p_73923_, p_73925_, p_73924_, p_73922_, BuiltInLootTables.f_78689_, \u00e2\u02dc\u01922);
            } else {
                AbstractIllager abstractIllager;
                switch (p_73921_) {
                    case "Mage": {
                        abstractIllager = EntityType.f_20568_.m_20615_(p_73923_.m_6018_());
                        break;
                    }
                    case "Warrior": {
                        abstractIllager = EntityType.f_20493_.m_20615_(p_73923_.m_6018_());
                        break;
                    }
                    default: {
                        return;
                    }
                }
                abstractIllager.m_21530_();
                abstractIllager.m_20035_(p_73922_, 0.0f, 0.0f);
                abstractIllager.m_6518_(p_73923_, p_73923_.m_6436_(abstractIllager.m_142538_()), MobSpawnType.STRUCTURE, null, null);
                p_73923_.m_47205_(abstractIllager);
                p_73923_.m_7731_(p_73922_, Blocks.f_50016_.m_49966_(), 2);
            }
        }
    }
}

