/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.IdMapper;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;

public class StructureTemplate {
    public static final String f_163789_ = "palette";
    public static final String f_163790_ = "palettes";
    public static final String f_163791_ = "entities";
    public static final String f_163792_ = "blocks";
    public static final String f_163793_ = "pos";
    public static final String f_163794_ = "state";
    public static final String f_163795_ = "nbt";
    public static final String f_163796_ = "pos";
    public static final String f_163797_ = "blockPos";
    public static final String f_163798_ = "nbt";
    public static final String f_163799_ = "size";
    static final int f_163800_ = 16;
    private final List<Palette> f_74482_ = Lists.newArrayList();
    private final List<StructureEntityInfo> f_74483_ = Lists.newArrayList();
    private Vec3i f_74484_ = Vec3i.f_123288_;
    private String f_74485_ = "?";

    public Vec3i m_163801_() {
        return this.f_74484_;
    }

    public void m_74612_(String p_74613_) {
        this.f_74485_ = p_74613_;
    }

    public String m_74627_() {
        return this.f_74485_;
    }

    public void m_163802_(Level p_163803_, BlockPos p_163804_, Vec3i p_163805_, boolean p_163806_, @Nullable Block p_163807_) {
        if (p_163805_.m_123341_() < 1 || p_163805_.m_123342_() < 1 || p_163805_.m_123343_() < 1) {
            return;
        }
        BlockPos blockPos = p_163804_.m_141952_(p_163805_).m_142082_(-1, -1, -1);
        ArrayList \u00e2\u02dc\u01922 = Lists.newArrayList();
        ArrayList \u00e2\u02dc\u01923 = Lists.newArrayList();
        ArrayList \u00e2\u02dc\u01924 = Lists.newArrayList();
        \u00e2\u02dc\u0192 = new BlockPos(Math.min(p_163804_.m_123341_(), blockPos.m_123341_()), Math.min(p_163804_.m_123342_(), blockPos.m_123342_()), Math.min(p_163804_.m_123343_(), blockPos.m_123343_()));
        \u00e2\u02dc\u0192 = new BlockPos(Math.max(p_163804_.m_123341_(), blockPos.m_123341_()), Math.max(p_163804_.m_123342_(), blockPos.m_123342_()), Math.max(p_163804_.m_123343_(), blockPos.m_123343_()));
        this.f_74484_ = p_163805_;
        for (BlockPos blockPos2 : BlockPos.m_121940_(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192)) {
            StructureBlockInfo \u00e2\u02dc\u01926;
            \u00e2\u02dc\u0192 = blockPos2.m_141950_(\u00e2\u02dc\u0192);
            BlockState blockState = p_163803_.m_8055_(blockPos2);
            if (p_163807_ != null && blockState.m_60713_(p_163807_)) continue;
            BlockEntity \u00e2\u02dc\u01925 = p_163803_.m_7702_(blockPos2);
            if (\u00e2\u02dc\u01925 != null) {
                CompoundTag compoundTag = \u00e2\u02dc\u01925.m_6945_(new CompoundTag());
                compoundTag.m_128473_("x");
                compoundTag.m_128473_("y");
                compoundTag.m_128473_("z");
                \u00e2\u02dc\u01926 = new StructureBlockInfo(\u00e2\u02dc\u0192, blockState, compoundTag.m_6426_());
            } else {
                \u00e2\u02dc\u01926 = new StructureBlockInfo(\u00e2\u02dc\u0192, blockState, null);
            }
            StructureTemplate.m_74573_(\u00e2\u02dc\u01926, \u00e2\u02dc\u01922, \u00e2\u02dc\u01923, \u00e2\u02dc\u01924);
        }
        List<StructureBlockInfo> list = StructureTemplate.m_74614_(\u00e2\u02dc\u01922, \u00e2\u02dc\u01923, \u00e2\u02dc\u01924);
        this.f_74482_.clear();
        this.f_74482_.add(new Palette(list));
        if (p_163806_) {
            this.m_74500_(p_163803_, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192.m_142082_(1, 1, 1));
        } else {
            this.f_74483_.clear();
        }
    }

    private static void m_74573_(StructureBlockInfo p_74574_, List<StructureBlockInfo> p_74575_, List<StructureBlockInfo> p_74576_, List<StructureBlockInfo> p_74577_) {
        if (p_74574_.f_74677_ != null) {
            p_74576_.add(p_74574_);
        } else if (!p_74574_.f_74676_.m_60734_().m_49967_() && p_74574_.f_74676_.m_60838_(EmptyBlockGetter.INSTANCE, BlockPos.f_121853_)) {
            p_74575_.add(p_74574_);
        } else {
            p_74577_.add(p_74574_);
        }
    }

    private static List<StructureBlockInfo> m_74614_(List<StructureBlockInfo> p_74615_, List<StructureBlockInfo> p_74616_, List<StructureBlockInfo> p_74617_) {
        Comparator<StructureBlockInfo> comparator = Comparator.comparingInt(p_74641_ -> p_74641_.f_74675_.m_123342_()).thenComparingInt(p_74637_ -> p_74637_.f_74675_.m_123341_()).thenComparingInt(p_74572_ -> p_74572_.f_74675_.m_123343_());
        p_74615_.sort(comparator);
        p_74617_.sort(comparator);
        p_74616_.sort(comparator);
        ArrayList \u00e2\u02dc\u01922 = Lists.newArrayList();
        \u00e2\u02dc\u01922.addAll(p_74615_);
        \u00e2\u02dc\u01922.addAll(p_74617_);
        \u00e2\u02dc\u01922.addAll(p_74616_);
        return \u00e2\u02dc\u01922;
    }

    private void m_74500_(Level p_74501_, BlockPos p_74502_, BlockPos p_74503_) {
        List<Entity> list = p_74501_.m_6443_(Entity.class, new AABB(p_74502_, p_74503_), p_74499_ -> !(p_74499_ instanceof Player));
        this.f_74483_.clear();
        for (Entity entity : list) {
            Vec3 vec3 = new Vec3(entity.m_20185_() - (double)p_74502_.m_123341_(), entity.m_20186_() - (double)p_74502_.m_123342_(), entity.m_20189_() - (double)p_74502_.m_123343_());
            CompoundTag \u00e2\u02dc\u01922 = new CompoundTag();
            entity.m_20223_(\u00e2\u02dc\u01922);
            BlockPos \u00e2\u02dc\u01923 = entity instanceof Painting ? ((Painting)entity).m_31748_().m_141950_(p_74502_) : new BlockPos(vec3);
            this.f_74483_.add(new StructureEntityInfo(vec3, \u00e2\u02dc\u01923, \u00e2\u02dc\u01922.m_6426_()));
        }
    }

    public List<StructureBlockInfo> m_74603_(BlockPos p_74604_, StructurePlaceSettings p_74605_, Block p_74606_) {
        return this.m_74607_(p_74604_, p_74605_, p_74606_, true);
    }

    public List<StructureBlockInfo> m_74607_(BlockPos p_74608_, StructurePlaceSettings p_74609_, Block p_74610_, boolean p_74611_) {
        ArrayList arrayList = Lists.newArrayList();
        BoundingBox \u00e2\u02dc\u01922 = p_74609_.m_74409_();
        if (this.f_74482_.isEmpty()) {
            return Collections.emptyList();
        }
        for (StructureBlockInfo structureBlockInfo : p_74609_.m_74387_(this.f_74482_, p_74608_).m_74653_(p_74610_)) {
            BlockPos blockPos = \u00e2\u02dc\u0192 = p_74611_ ? StructureTemplate.m_74563_(p_74609_, structureBlockInfo.f_74675_).m_141952_(p_74608_) : structureBlockInfo.f_74675_;
            if (\u00e2\u02dc\u01922 != null && !\u00e2\u02dc\u01922.m_71051_(\u00e2\u02dc\u0192)) continue;
            arrayList.add(new StructureBlockInfo(\u00e2\u02dc\u0192, structureBlockInfo.f_74676_.m_60717_(p_74609_.m_74404_()), structureBlockInfo.f_74677_));
        }
        return arrayList;
    }

    public BlockPos m_74566_(StructurePlaceSettings p_74567_, BlockPos p_74568_, StructurePlaceSettings p_74569_, BlockPos p_74570_) {
        BlockPos blockPos = StructureTemplate.m_74563_(p_74567_, p_74568_);
        \u00e2\u02dc\u0192 = StructureTemplate.m_74563_(p_74569_, p_74570_);
        return blockPos.m_141950_(\u00e2\u02dc\u0192);
    }

    public static BlockPos m_74563_(StructurePlaceSettings p_74564_, BlockPos p_74565_) {
        return StructureTemplate.m_74593_(p_74565_, p_74564_.m_74401_(), p_74564_.m_74404_(), p_74564_.m_74407_());
    }

    public boolean m_74536_(ServerLevelAccessor p_74537_, BlockPos p_74538_, BlockPos p_74539_, StructurePlaceSettings p_74540_, Random p_74541_, int p_74542_) {
        Object object;
        if (this.f_74482_.isEmpty()) {
            return false;
        }
        List<StructureBlockInfo> list = p_74540_.m_74387_(this.f_74482_, p_74538_).m_74652_();
        if (list.isEmpty() && (p_74540_.m_74408_() || this.f_74483_.isEmpty()) || this.f_74484_.m_123341_() < 1 || this.f_74484_.m_123342_() < 1 || this.f_74484_.m_123343_() < 1) {
            return false;
        }
        BoundingBox \u00e2\u02dc\u01922 = p_74540_.m_74409_();
        ArrayList \u00e2\u02dc\u01923 = Lists.newArrayListWithCapacity((int)(p_74540_.m_74413_() ? list.size() : 0));
        ArrayList \u00e2\u02dc\u01924 = Lists.newArrayListWithCapacity((int)(p_74540_.m_74413_() ? list.size() : 0));
        ArrayList \u00e2\u02dc\u01925 = Lists.newArrayListWithCapacity((int)list.size());
        int \u00e2\u02dc\u01926 = Integer.MAX_VALUE;
        int \u00e2\u02dc\u01927 = Integer.MAX_VALUE;
        int \u00e2\u02dc\u01928 = Integer.MAX_VALUE;
        int \u00e2\u02dc\u01929 = Integer.MIN_VALUE;
        int \u00e2\u02dc\u019210 = Integer.MIN_VALUE;
        int \u00e2\u02dc\u019211 = Integer.MIN_VALUE;
        List<StructureBlockInfo> list2 = StructureTemplate.m_74517_(p_74537_, p_74538_, p_74539_, p_74540_, list);
        for (StructureBlockInfo structureBlockInfo : list2) {
            BlockPos object2 = structureBlockInfo.f_74675_;
            if (\u00e2\u02dc\u01922 != null && !\u00e2\u02dc\u01922.m_71051_(object2)) continue;
            Object object3 = p_74540_.m_74413_() ? p_74537_.m_6425_(object2) : null;
            BlockState \u00e2\u02dc\u019212 = structureBlockInfo.f_74676_.m_60715_(p_74540_.m_74401_()).m_60717_(p_74540_.m_74404_());
            if (structureBlockInfo.f_74677_ != null) {
                BlockEntity blockEntity = p_74537_.m_7702_(object2);
                Clearable.m_18908_(blockEntity);
                p_74537_.m_7731_(object2, Blocks.f_50375_.m_49966_(), 20);
            }
            if (!p_74537_.m_7731_(object2, \u00e2\u02dc\u019212, p_74542_)) continue;
            \u00e2\u02dc\u01926 = Math.min(\u00e2\u02dc\u01926, object2.m_123341_());
            \u00e2\u02dc\u01927 = Math.min(\u00e2\u02dc\u01927, object2.m_123342_());
            \u00e2\u02dc\u01928 = Math.min(\u00e2\u02dc\u01928, object2.m_123343_());
            \u00e2\u02dc\u01929 = Math.max(\u00e2\u02dc\u01929, object2.m_123341_());
            \u00e2\u02dc\u019210 = Math.max(\u00e2\u02dc\u019210, object2.m_123342_());
            \u00e2\u02dc\u019211 = Math.max(\u00e2\u02dc\u019211, object2.m_123343_());
            \u00e2\u02dc\u01925.add(Pair.of((Object)object2, (Object)structureBlockInfo.f_74677_));
            if (structureBlockInfo.f_74677_ != null && (\u00e2\u02dc\u0192 = p_74537_.m_7702_(object2)) != null) {
                structureBlockInfo.f_74677_.m_128405_("x", object2.m_123341_());
                structureBlockInfo.f_74677_.m_128405_("y", object2.m_123342_());
                structureBlockInfo.f_74677_.m_128405_("z", object2.m_123343_());
                if (\u00e2\u02dc\u0192 instanceof RandomizableContainerBlockEntity) {
                    structureBlockInfo.f_74677_.m_128356_("LootTableSeed", p_74541_.nextLong());
                }
                \u00e2\u02dc\u0192.m_142466_(structureBlockInfo.f_74677_);
            }
            if (object3 == null) continue;
            if (\u00e2\u02dc\u019212.m_60819_().m_76170_()) {
                \u00e2\u02dc\u01924.add(object2);
                continue;
            }
            if (!(\u00e2\u02dc\u019212.m_60734_() instanceof LiquidBlockContainer)) continue;
            ((LiquidBlockContainer)((Object)\u00e2\u02dc\u019212.m_60734_())).m_7361_(p_74537_, object2, \u00e2\u02dc\u019212, (FluidState)object3);
            if (((FluidState)object3).m_76170_()) continue;
            \u00e2\u02dc\u01923.add(object2);
        }
        boolean bl = true;
        Direction[] directionArray = new Direction[]{Direction.UP, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
        while (bl && !\u00e2\u02dc\u01923.isEmpty()) {
            bl = false;
            object = \u00e2\u02dc\u01923.iterator();
            while (object.hasNext()) {
                object3 = (BlockPos)object.next();
                FluidState \u00e2\u02dc\u019213 = p_74537_.m_6425_((BlockPos)object3);
                for (int i = 0; i < directionArray.length && !\u00e2\u02dc\u019213.m_76170_(); ++i) {
                    Object object4 = ((BlockPos)object3).m_142300_(directionArray[i]);
                    FluidState \u00e2\u02dc\u019214 = p_74537_.m_6425_((BlockPos)object4);
                    if (!\u00e2\u02dc\u019214.m_76170_() || \u00e2\u02dc\u01924.contains(object4)) continue;
                    \u00e2\u02dc\u019213 = \u00e2\u02dc\u019214;
                }
                if (!\u00e2\u02dc\u019213.m_76170_() || !((object4 = (\u00e2\u02dc\u0192 = p_74537_.m_8055_((BlockPos)object3)).m_60734_()) instanceof LiquidBlockContainer)) continue;
                ((LiquidBlockContainer)object4).m_7361_(p_74537_, (BlockPos)object3, \u00e2\u02dc\u0192, \u00e2\u02dc\u019213);
                bl = true;
                object.remove();
            }
        }
        if (\u00e2\u02dc\u01926 <= \u00e2\u02dc\u01929) {
            if (!p_74540_.m_74410_()) {
                object = new BitSetDiscreteVoxelShape(\u00e2\u02dc\u01929 - \u00e2\u02dc\u01926 + 1, \u00e2\u02dc\u019210 - \u00e2\u02dc\u01927 + 1, \u00e2\u02dc\u019211 - \u00e2\u02dc\u01928 + 1);
                int \u00e2\u02dc\u019215 = \u00e2\u02dc\u01926;
                int \u00e2\u02dc\u019216 = \u00e2\u02dc\u01927;
                int \u00e2\u02dc\u019217 = \u00e2\u02dc\u01928;
                for (Pair pair : \u00e2\u02dc\u01925) {
                    BlockPos blockPos = (BlockPos)pair.getFirst();
                    ((DiscreteVoxelShape)object).m_142703_(blockPos.m_123341_() - \u00e2\u02dc\u019215, blockPos.m_123342_() - \u00e2\u02dc\u019216, blockPos.m_123343_() - \u00e2\u02dc\u019217);
                }
                StructureTemplate.m_74510_(p_74537_, p_74542_, (DiscreteVoxelShape)object, \u00e2\u02dc\u019215, \u00e2\u02dc\u019216, \u00e2\u02dc\u019217);
            }
            for (Pair pair2 : \u00e2\u02dc\u01925) {
                BlockEntity blockEntity;
                BlockPos blockPos = (BlockPos)pair2.getFirst();
                if (!p_74540_.m_74410_()) {
                    BlockState object2;
                    BlockState blockState = p_74537_.m_8055_(blockPos);
                    if (blockState != (object2 = Block.m_49931_(blockState, p_74537_, blockPos))) {
                        p_74537_.m_7731_(blockPos, object2, p_74542_ & 0xFFFFFFFE | 0x10);
                    }
                    p_74537_.m_6289_(blockPos, object2.m_60734_());
                }
                if (pair2.getSecond() == null || (blockEntity = p_74537_.m_7702_(blockPos)) == null) continue;
                blockEntity.m_6596_();
            }
        }
        if (!p_74540_.m_74408_()) {
            this.m_74523_(p_74537_, p_74538_, p_74540_.m_74401_(), p_74540_.m_74404_(), p_74540_.m_74407_(), \u00e2\u02dc\u01922, p_74540_.m_74414_());
        }
        return true;
    }

    public static void m_74510_(LevelAccessor p_74511_, int p_74512_, DiscreteVoxelShape p_74513_, int p_74514_, int p_74515_, int p_74516_) {
        p_74513_.m_82810_((p_74494_, p_74495_, p_74496_, p_74497_) -> {
            BlockPos blockPos = new BlockPos(p_74514_ + p_74495_, p_74515_ + p_74496_, p_74516_ + p_74497_);
            \u00e2\u02dc\u0192 = blockPos.m_142300_(p_74494_);
            BlockState \u00e2\u02dc\u01922 = p_74511_.m_8055_(blockPos);
            if (\u00e2\u02dc\u01922 != (\u00e2\u02dc\u0192 = \u00e2\u02dc\u01922.m_60728_(p_74494_, \u00e2\u02dc\u0192 = p_74511_.m_8055_(\u00e2\u02dc\u0192), p_74511_, blockPos, \u00e2\u02dc\u0192))) {
                p_74511_.m_7731_(blockPos, \u00e2\u02dc\u0192, p_74512_ & 0xFFFFFFFE);
            }
            if (\u00e2\u02dc\u0192 != (\u00e2\u02dc\u0192 = \u00e2\u02dc\u0192.m_60728_(p_74494_.m_122424_(), \u00e2\u02dc\u0192, p_74511_, \u00e2\u02dc\u0192, blockPos))) {
                p_74511_.m_7731_(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192, p_74512_ & 0xFFFFFFFE);
            }
        });
    }

    public static List<StructureBlockInfo> m_74517_(LevelAccessor p_74518_, BlockPos p_74519_, BlockPos p_74520_, StructurePlaceSettings p_74521_, List<StructureBlockInfo> p_74522_) {
        ArrayList arrayList = Lists.newArrayList();
        for (StructureBlockInfo structureBlockInfo : p_74522_) {
            BlockPos blockPos = StructureTemplate.m_74563_(p_74521_, structureBlockInfo.f_74675_).m_141952_(p_74519_);
            StructureBlockInfo \u00e2\u02dc\u01922 = new StructureBlockInfo(blockPos, structureBlockInfo.f_74676_, structureBlockInfo.f_74677_ != null ? structureBlockInfo.f_74677_.m_6426_() : null);
            Iterator<StructureProcessor> \u00e2\u02dc\u01923 = p_74521_.m_74411_().iterator();
            while (\u00e2\u02dc\u01922 != null && \u00e2\u02dc\u01923.hasNext()) {
                \u00e2\u02dc\u01922 = \u00e2\u02dc\u01923.next().m_7382_(p_74518_, p_74519_, p_74520_, structureBlockInfo, \u00e2\u02dc\u01922, p_74521_);
            }
            if (\u00e2\u02dc\u01922 == null) continue;
            arrayList.add(\u00e2\u02dc\u01922);
        }
        return arrayList;
    }

    private void m_74523_(ServerLevelAccessor p_74524_, BlockPos p_74525_, Mirror p_74526_, Rotation p_74527_, BlockPos p_74528_, @Nullable BoundingBox p_74529_, boolean p_74530_) {
        for (StructureEntityInfo structureEntityInfo : this.f_74483_) {
            BlockPos blockPos = StructureTemplate.m_74593_(structureEntityInfo.f_74684_, p_74526_, p_74527_, p_74528_).m_141952_(p_74525_);
            if (p_74529_ != null && !p_74529_.m_71051_(blockPos)) continue;
            CompoundTag \u00e2\u02dc\u01922 = structureEntityInfo.f_74685_.m_6426_();
            Vec3 \u00e2\u02dc\u01923 = StructureTemplate.m_74578_(structureEntityInfo.f_74683_, p_74526_, p_74527_, p_74528_);
            Vec3 \u00e2\u02dc\u01924 = \u00e2\u02dc\u01923.m_82520_(p_74525_.m_123341_(), p_74525_.m_123342_(), p_74525_.m_123343_());
            ListTag \u00e2\u02dc\u01925 = new ListTag();
            \u00e2\u02dc\u01925.add(DoubleTag.m_128500_(\u00e2\u02dc\u01924.f_82479_));
            \u00e2\u02dc\u01925.add(DoubleTag.m_128500_(\u00e2\u02dc\u01924.f_82480_));
            \u00e2\u02dc\u01925.add(DoubleTag.m_128500_(\u00e2\u02dc\u01924.f_82481_));
            \u00e2\u02dc\u01922.m_128365_("Pos", \u00e2\u02dc\u01925);
            \u00e2\u02dc\u01922.m_128473_("UUID");
            StructureTemplate.m_74543_(p_74524_, \u00e2\u02dc\u01922).ifPresent(p_74553_ -> {
                float f = p_74553_.m_6961_(p_74526_);
                p_74553_.m_7678_(p_74549_.f_82479_, p_74549_.f_82480_, p_74549_.f_82481_, f += p_74553_.m_146908_() - p_74553_.m_7890_(p_74527_), p_74553_.m_146909_());
                if (p_74530_ && p_74553_ instanceof Mob) {
                    ((Mob)p_74553_).m_6518_(p_74524_, p_74524_.m_6436_(new BlockPos(\u00e2\u02dc\u01924)), MobSpawnType.STRUCTURE, null, \u00e2\u02dc\u01922);
                }
                p_74524_.m_47205_((Entity)p_74553_);
            });
        }
    }

    private static Optional<Entity> m_74543_(ServerLevelAccessor p_74544_, CompoundTag p_74545_) {
        try {
            return EntityType.m_20642_(p_74545_, p_74544_.m_6018_());
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    public Vec3i m_163808_(Rotation p_163809_) {
        switch (p_163809_) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                return new Vec3i(this.f_74484_.m_123343_(), this.f_74484_.m_123342_(), this.f_74484_.m_123341_());
            }
        }
        return this.f_74484_;
    }

    public static BlockPos m_74593_(BlockPos p_74594_, Mirror p_74595_, Rotation p_74596_, BlockPos p_74597_) {
        int n = p_74594_.m_123341_();
        \u00e2\u02dc\u0192 = p_74594_.m_123342_();
        \u00e2\u02dc\u0192 = p_74594_.m_123343_();
        boolean \u00e2\u02dc\u01922 = true;
        switch (p_74595_) {
            case LEFT_RIGHT: {
                \u00e2\u02dc\u0192 = -\u00e2\u02dc\u0192;
                break;
            }
            case FRONT_BACK: {
                n = -n;
                break;
            }
            default: {
                \u00e2\u02dc\u01922 = false;
            }
        }
        \u00e2\u02dc\u0192 = p_74597_.m_123341_();
        \u00e2\u02dc\u0192 = p_74597_.m_123343_();
        switch (p_74596_) {
            case CLOCKWISE_180: {
                return new BlockPos(\u00e2\u02dc\u0192 + \u00e2\u02dc\u0192 - n, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192 + \u00e2\u02dc\u0192 - \u00e2\u02dc\u0192);
            }
            case COUNTERCLOCKWISE_90: {
                return new BlockPos(\u00e2\u02dc\u0192 - \u00e2\u02dc\u0192 + \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192 + \u00e2\u02dc\u0192 - n);
            }
            case CLOCKWISE_90: {
                return new BlockPos(\u00e2\u02dc\u0192 + \u00e2\u02dc\u0192 - \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192 - \u00e2\u02dc\u0192 + n);
            }
        }
        return \u00e2\u02dc\u01922 ? new BlockPos(n, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192) : p_74594_;
    }

    public static Vec3 m_74578_(Vec3 p_74579_, Mirror p_74580_, Rotation p_74581_, BlockPos p_74582_) {
        double d = p_74579_.f_82479_;
        \u00e2\u02dc\u0192 = p_74579_.f_82480_;
        \u00e2\u02dc\u0192 = p_74579_.f_82481_;
        boolean \u00e2\u02dc\u01922 = true;
        switch (p_74580_) {
            case LEFT_RIGHT: {
                \u00e2\u02dc\u0192 = 1.0 - \u00e2\u02dc\u0192;
                break;
            }
            case FRONT_BACK: {
                d = 1.0 - d;
                break;
            }
            default: {
                \u00e2\u02dc\u01922 = false;
            }
        }
        int \u00e2\u02dc\u01923 = p_74582_.m_123341_();
        int \u00e2\u02dc\u01924 = p_74582_.m_123343_();
        switch (p_74581_) {
            case CLOCKWISE_180: {
                return new Vec3((double)(\u00e2\u02dc\u01923 + \u00e2\u02dc\u01923 + 1) - d, \u00e2\u02dc\u0192, (double)(\u00e2\u02dc\u01924 + \u00e2\u02dc\u01924 + 1) - \u00e2\u02dc\u0192);
            }
            case COUNTERCLOCKWISE_90: {
                return new Vec3((double)(\u00e2\u02dc\u01923 - \u00e2\u02dc\u01924) + \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, (double)(\u00e2\u02dc\u01923 + \u00e2\u02dc\u01924 + 1) - d);
            }
            case CLOCKWISE_90: {
                return new Vec3((double)(\u00e2\u02dc\u01923 + \u00e2\u02dc\u01924 + 1) - \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, (double)(\u00e2\u02dc\u01924 - \u00e2\u02dc\u01923) + d);
            }
        }
        return \u00e2\u02dc\u01922 ? new Vec3(d, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192) : p_74579_;
    }

    public BlockPos m_74583_(BlockPos p_74584_, Mirror p_74585_, Rotation p_74586_) {
        return StructureTemplate.m_74587_(p_74584_, p_74585_, p_74586_, this.m_163801_().m_123341_(), this.m_163801_().m_123343_());
    }

    public static BlockPos m_74587_(BlockPos p_74588_, Mirror p_74589_, Rotation p_74590_, int p_74591_, int p_74592_) {
        int n = p_74589_ == Mirror.FRONT_BACK ? --p_74591_ : 0;
        \u00e2\u02dc\u0192 = p_74589_ == Mirror.LEFT_RIGHT ? --p_74592_ : 0;
        BlockPos \u00e2\u02dc\u01922 = p_74588_;
        switch (p_74590_) {
            case NONE: {
                \u00e2\u02dc\u01922 = p_74588_.m_142082_(n, 0, \u00e2\u02dc\u0192);
                break;
            }
            case CLOCKWISE_90: {
                \u00e2\u02dc\u01922 = p_74588_.m_142082_(p_74592_ - \u00e2\u02dc\u0192, 0, n);
                break;
            }
            case CLOCKWISE_180: {
                \u00e2\u02dc\u01922 = p_74588_.m_142082_(p_74591_ - n, 0, p_74592_ - \u00e2\u02dc\u0192);
                break;
            }
            case COUNTERCLOCKWISE_90: {
                \u00e2\u02dc\u01922 = p_74588_.m_142082_(\u00e2\u02dc\u0192, 0, p_74591_ - n);
            }
        }
        return \u00e2\u02dc\u01922;
    }

    public BoundingBox m_74633_(StructurePlaceSettings p_74634_, BlockPos p_74635_) {
        return this.m_74598_(p_74635_, p_74634_.m_74404_(), p_74634_.m_74407_(), p_74634_.m_74401_());
    }

    public BoundingBox m_74598_(BlockPos p_74599_, Rotation p_74600_, BlockPos p_74601_, Mirror p_74602_) {
        return StructureTemplate.m_163810_(p_74599_, p_74600_, p_74601_, p_74602_, this.f_74484_);
    }

    @VisibleForTesting
    protected static BoundingBox m_163810_(BlockPos p_163811_, Rotation p_163812_, BlockPos p_163813_, Mirror p_163814_, Vec3i p_163815_) {
        Vec3i vec3i = p_163815_.m_142082_(-1, -1, -1);
        BlockPos \u00e2\u02dc\u01922 = StructureTemplate.m_74593_(BlockPos.f_121853_, p_163814_, p_163812_, p_163813_);
        BlockPos \u00e2\u02dc\u01923 = StructureTemplate.m_74593_(BlockPos.f_121853_.m_141952_(vec3i), p_163814_, p_163812_, p_163813_);
        return BoundingBox.m_162375_(\u00e2\u02dc\u01922, \u00e2\u02dc\u01923).m_162373_(p_163811_);
    }

    /*
     * WARNING - void declaration
     */
    public CompoundTag m_74618_(CompoundTag p_74619_) {
        Object object;
        if (this.f_74482_.isEmpty()) {
            p_74619_.m_128365_(f_163792_, new ListTag());
            p_74619_.m_128365_(f_163789_, new ListTag());
        } else {
            void var4_5;
            ArrayList abstractList = Lists.newArrayList();
            SimplePalette \u00e2\u02dc\u01922 = new SimplePalette();
            abstractList.add(\u00e2\u02dc\u01922);
            boolean bl = true;
            while (var4_5 < this.f_74482_.size()) {
                abstractList.add(new SimplePalette());
                ++var4_5;
            }
            ListTag listTag = new ListTag();
            object = this.f_74482_.get(0).m_74652_();
            for (int i = 0; i < object.size(); ++i) {
                StructureBlockInfo structureBlockInfo = (StructureBlockInfo)object.get(i);
                CompoundTag \u00e2\u02dc\u01923 = new CompoundTag();
                \u00e2\u02dc\u01923.m_128365_("pos", this.m_74625_(structureBlockInfo.f_74675_.m_123341_(), structureBlockInfo.f_74675_.m_123342_(), structureBlockInfo.f_74675_.m_123343_()));
                int \u00e2\u02dc\u01924 = \u00e2\u02dc\u01922.m_74669_(structureBlockInfo.f_74676_);
                \u00e2\u02dc\u01923.m_128405_(f_163794_, \u00e2\u02dc\u01924);
                if (structureBlockInfo.f_74677_ != null) {
                    \u00e2\u02dc\u01923.m_128365_("nbt", structureBlockInfo.f_74677_);
                }
                listTag.add(\u00e2\u02dc\u01923);
                for (int j = 1; j < this.f_74482_.size(); ++j) {
                    SimplePalette simplePalette = (SimplePalette)abstractList.get(j);
                    simplePalette.m_74671_(this.f_74482_.get((int)j).m_74652_().get((int)i).f_74676_, \u00e2\u02dc\u01924);
                }
            }
            p_74619_.m_128365_(f_163792_, listTag);
            if (abstractList.size() == 1) {
                \u00e2\u02dc\u0192 = new ListTag();
                for (Object object2 : \u00e2\u02dc\u01922) {
                    \u00e2\u02dc\u0192.add(NbtUtils.m_129202_((BlockState)object2));
                }
                p_74619_.m_128365_(f_163789_, \u00e2\u02dc\u0192);
            } else {
                \u00e2\u02dc\u0192 = new ListTag();
                for (Object object2 : abstractList) {
                    ListTag listTag2 = new ListTag();
                    Iterator<BlockState> iterator = ((SimplePalette)object2).iterator();
                    while (iterator.hasNext()) {
                        BlockState object3 = iterator.next();
                        listTag2.add(NbtUtils.m_129202_(object3));
                    }
                    \u00e2\u02dc\u0192.add(listTag2);
                }
                p_74619_.m_128365_(f_163790_, \u00e2\u02dc\u0192);
            }
        }
        ListTag listTag = new ListTag();
        for (StructureEntityInfo structureEntityInfo : this.f_74483_) {
            object = new CompoundTag();
            ((CompoundTag)object).m_128365_("pos", this.m_74623_(structureEntityInfo.f_74683_.f_82479_, structureEntityInfo.f_74683_.f_82480_, structureEntityInfo.f_74683_.f_82481_));
            ((CompoundTag)object).m_128365_(f_163797_, this.m_74625_(structureEntityInfo.f_74684_.m_123341_(), structureEntityInfo.f_74684_.m_123342_(), structureEntityInfo.f_74684_.m_123343_()));
            if (structureEntityInfo.f_74685_ != null) {
                ((CompoundTag)object).m_128365_("nbt", structureEntityInfo.f_74685_);
            }
            listTag.add(object);
        }
        p_74619_.m_128365_(f_163791_, listTag);
        p_74619_.m_128365_(f_163799_, this.m_74625_(this.f_74484_.m_123341_(), this.f_74484_.m_123342_(), this.f_74484_.m_123343_()));
        p_74619_.m_128405_("DataVersion", SharedConstants.m_136187_().getWorldVersion());
        return p_74619_;
    }

    public void m_74638_(CompoundTag p_74639_) {
        int n;
        this.f_74482_.clear();
        this.f_74483_.clear();
        ListTag listTag = p_74639_.m_128437_(f_163799_, 3);
        this.f_74484_ = new Vec3i(listTag.m_128763_(0), listTag.m_128763_(1), listTag.m_128763_(2));
        listTag2 = p_74639_.m_128437_(f_163792_, 10);
        if (p_74639_.m_128425_(f_163790_, 9)) {
            listTag3 = p_74639_.m_128437_(f_163790_, 9);
            for (n = 0; n < listTag3.size(); ++n) {
                this.m_74620_(listTag3.m_128744_(n), listTag2);
            }
        } else {
            ListTag listTag2;
            this.m_74620_(p_74639_.m_128437_(f_163789_, 10), listTag2);
        }
        ListTag listTag3 = p_74639_.m_128437_(f_163791_, 10);
        for (n = 0; n < listTag3.size(); ++n) {
            CompoundTag compoundTag = listTag3.m_128728_(n);
            ListTag \u00e2\u02dc\u01922 = compoundTag.m_128437_("pos", 6);
            Vec3 \u00e2\u02dc\u01923 = new Vec3(\u00e2\u02dc\u01922.m_128772_(0), \u00e2\u02dc\u01922.m_128772_(1), \u00e2\u02dc\u01922.m_128772_(2));
            ListTag \u00e2\u02dc\u01924 = compoundTag.m_128437_(f_163797_, 3);
            BlockPos \u00e2\u02dc\u01925 = new BlockPos(\u00e2\u02dc\u01924.m_128763_(0), \u00e2\u02dc\u01924.m_128763_(1), \u00e2\u02dc\u01924.m_128763_(2));
            if (!compoundTag.m_128441_("nbt")) continue;
            \u00e2\u02dc\u0192 = compoundTag.m_128469_("nbt");
            this.f_74483_.add(new StructureEntityInfo(\u00e2\u02dc\u01923, \u00e2\u02dc\u01925, \u00e2\u02dc\u0192));
        }
    }

    private void m_74620_(ListTag p_74621_, ListTag p_74622_) {
        SimplePalette simplePalette = new SimplePalette();
        for (int i = 0; i < p_74621_.size(); ++i) {
            simplePalette.m_74671_(NbtUtils.m_129241_(p_74621_.m_128728_(i)), i);
        }
        ArrayList arrayList = Lists.newArrayList();
        \u00e2\u02dc\u0192 = Lists.newArrayList();
        \u00e2\u02dc\u0192 = Lists.newArrayList();
        for (int i = 0; i < p_74622_.size(); ++i) {
            CompoundTag compoundTag = p_74622_.m_128728_(i);
            ListTag \u00e2\u02dc\u01922 = compoundTag.m_128437_("pos", 3);
            BlockPos \u00e2\u02dc\u01923 = new BlockPos(\u00e2\u02dc\u01922.m_128763_(0), \u00e2\u02dc\u01922.m_128763_(1), \u00e2\u02dc\u01922.m_128763_(2));
            BlockState \u00e2\u02dc\u01924 = simplePalette.m_74667_(compoundTag.m_128451_(f_163794_));
            \u00e2\u02dc\u0192 = compoundTag.m_128441_("nbt") ? compoundTag.m_128469_("nbt") : null;
            StructureBlockInfo \u00e2\u02dc\u01925 = new StructureBlockInfo(\u00e2\u02dc\u01923, \u00e2\u02dc\u01924, \u00e2\u02dc\u0192);
            StructureTemplate.m_74573_(\u00e2\u02dc\u01925, arrayList, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
        }
        List<StructureBlockInfo> list = StructureTemplate.m_74614_(arrayList, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
        this.f_74482_.add(new Palette(list));
    }

    private ListTag m_74625_(int ... p_74626_) {
        ListTag listTag = new ListTag();
        for (int n : p_74626_) {
            listTag.add(IntTag.m_128679_(n));
        }
        return listTag;
    }

    private ListTag m_74623_(double ... p_74624_) {
        ListTag listTag = new ListTag();
        for (double d : p_74624_) {
            listTag.add(DoubleTag.m_128500_(d));
        }
        return listTag;
    }

    public static class StructureBlockInfo {
        public final BlockPos f_74675_;
        public final BlockState f_74676_;
        public final CompoundTag f_74677_;

        public StructureBlockInfo(BlockPos p_74679_, BlockState p_74680_, @Nullable CompoundTag p_74681_) {
            this.f_74675_ = p_74679_;
            this.f_74676_ = p_74680_;
            this.f_74677_ = p_74681_;
        }

        public String toString() {
            return String.format("<StructureBlockInfo | %s | %s | %s>", this.f_74675_, this.f_74676_, this.f_74677_);
        }
    }

    public static final class Palette {
        private final List<StructureBlockInfo> f_74645_;
        private final Map<Block, List<StructureBlockInfo>> f_74646_ = Maps.newHashMap();

        Palette(List<StructureBlockInfo> p_74648_) {
            this.f_74645_ = p_74648_;
        }

        public List<StructureBlockInfo> m_74652_() {
            return this.f_74645_;
        }

        public List<StructureBlockInfo> m_74653_(Block p_74654_) {
            return this.f_74646_.computeIfAbsent(p_74654_, p_74659_ -> this.f_74645_.stream().filter(p_163818_ -> p_163818_.f_74676_.m_60713_((Block)p_74659_)).collect(Collectors.toList()));
        }
    }

    public static class StructureEntityInfo {
        public final Vec3 f_74683_;
        public final BlockPos f_74684_;
        public final CompoundTag f_74685_;

        public StructureEntityInfo(Vec3 p_74687_, BlockPos p_74688_, CompoundTag p_74689_) {
            this.f_74683_ = p_74687_;
            this.f_74684_ = p_74688_;
            this.f_74685_ = p_74689_;
        }
    }

    static class SimplePalette
    implements Iterable<BlockState> {
        public static final BlockState f_74660_ = Blocks.f_50016_.m_49966_();
        private final IdMapper<BlockState> f_74661_ = new IdMapper(16);
        private int f_74662_;

        SimplePalette() {
        }

        public int m_74669_(BlockState p_74670_) {
            int n = this.f_74661_.m_7447_(p_74670_);
            if (n == -1) {
                n = this.f_74662_++;
                this.f_74661_.m_122664_(p_74670_, n);
            }
            return n;
        }

        @Nullable
        public BlockState m_74667_(int p_74668_) {
            BlockState blockState = this.f_74661_.m_7942_(p_74668_);
            return blockState == null ? f_74660_ : blockState;
        }

        @Override
        public Iterator<BlockState> iterator() {
            return this.f_74661_.iterator();
        }

        public void m_74671_(BlockState p_74672_, int p_74673_) {
            this.f_74661_.m_122664_(p_74672_, p_74673_);
        }
    }
}

