/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.synth;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.util.List;
import java.util.function.LongFunction;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.synth.ImprovedNoise;
import net.minecraft.world.level.levelgen.synth.SurfaceNoise;

public class PerlinNoise
implements SurfaceNoise {
    private static final int f_164358_ = 0x2000000;
    private final ImprovedNoise[] f_75390_;
    private final DoubleList f_75391_;
    private final double f_75392_;
    private final double f_75393_;

    public PerlinNoise(RandomSource p_164377_, IntStream p_164378_) {
        this(p_164377_, (List)p_164378_.boxed().collect(ImmutableList.toImmutableList()));
    }

    public PerlinNoise(RandomSource p_164374_, List<Integer> p_164375_) {
        this(p_164374_, (IntSortedSet)new IntRBTreeSet(p_164375_));
    }

    public static PerlinNoise m_164385_(RandomSource p_164386_, int p_164387_, double ... p_164388_) {
        return PerlinNoise.m_164381_(p_164386_, p_164387_, (DoubleList)new DoubleArrayList(p_164388_));
    }

    public static PerlinNoise m_164381_(RandomSource p_164382_, int p_164383_, DoubleList p_164384_) {
        return new PerlinNoise(p_164382_, (Pair<Integer, DoubleList>)Pair.of((Object)p_164383_, (Object)p_164384_));
    }

    private static Pair<Integer, DoubleList> m_75430_(IntSortedSet p_75431_) {
        if (p_75431_.isEmpty()) {
            throw new IllegalArgumentException("Need some octaves!");
        }
        int n = -p_75431_.firstInt();
        \u00e2\u02dc\u0192 = n + (\u00e2\u02dc\u0192 = p_75431_.lastInt()) + 1;
        if (\u00e2\u02dc\u0192 < 1) {
            throw new IllegalArgumentException("Total number of octaves needs to be >= 1");
        }
        DoubleArrayList \u00e2\u02dc\u01922 = new DoubleArrayList(new double[\u00e2\u02dc\u0192]);
        IntBidirectionalIterator \u00e2\u02dc\u01923 = p_75431_.iterator();
        while (\u00e2\u02dc\u01923.hasNext()) {
            \u00e2\u02dc\u0192 = \u00e2\u02dc\u01923.nextInt();
            \u00e2\u02dc\u01922.set(\u00e2\u02dc\u0192 + n, 1.0);
        }
        return Pair.of((Object)(-n), (Object)\u00e2\u02dc\u01922);
    }

    private PerlinNoise(RandomSource p_164367_, IntSortedSet p_164368_) {
        this(p_164367_, p_164368_, WorldgenRandom::new);
    }

    private PerlinNoise(RandomSource p_164370_, IntSortedSet p_164371_, LongFunction<RandomSource> p_164372_) {
        this(p_164370_, PerlinNoise.m_75430_(p_164371_), p_164372_);
    }

    protected PerlinNoise(RandomSource p_164360_, Pair<Integer, DoubleList> p_164361_) {
        this(p_164360_, p_164361_, WorldgenRandom::new);
    }

    protected PerlinNoise(RandomSource p_164363_, Pair<Integer, DoubleList> p_164364_, LongFunction<RandomSource> p_164365_) {
        int n;
        int n2 = (Integer)p_164364_.getFirst();
        this.f_75391_ = (DoubleList)p_164364_.getSecond();
        ImprovedNoise \u00e2\u02dc\u01922 = new ImprovedNoise(p_164363_);
        \u00e2\u02dc\u0192 = this.f_75391_.size();
        n = -n2;
        this.f_75390_ = new ImprovedNoise[\u00e2\u02dc\u0192];
        if (n >= 0 && n < \u00e2\u02dc\u0192 && (\u00e2\u02dc\u0192 = this.f_75391_.getDouble(n)) != 0.0) {
            this.f_75390_[n] = \u00e2\u02dc\u01922;
        }
        for (\u00e2\u02dc\u0192 = n - 1; \u00e2\u02dc\u0192 >= 0; --\u00e2\u02dc\u0192) {
            if (\u00e2\u02dc\u0192 < \u00e2\u02dc\u0192) {
                double d = this.f_75391_.getDouble(\u00e2\u02dc\u0192);
                if (d != 0.0) {
                    this.f_75390_[\u00e2\u02dc\u0192] = new ImprovedNoise(p_164363_);
                    continue;
                }
                PerlinNoise.m_164379_(p_164363_);
                continue;
            }
            PerlinNoise.m_164379_(p_164363_);
        }
        if (n < \u00e2\u02dc\u0192 - 1) {
            throw new IllegalArgumentException("Positive octaves are temporarily disabled");
        }
        this.f_75393_ = Math.pow(2.0, -n);
        this.f_75392_ = Math.pow(2.0, \u00e2\u02dc\u0192 - 1) / (Math.pow(2.0, \u00e2\u02dc\u0192) - 1.0);
    }

    private static void m_164379_(RandomSource p_164380_) {
        p_164380_.m_158876_(262);
    }

    public double m_75408_(double p_75409_, double p_75410_, double p_75411_) {
        return this.m_75417_(p_75409_, p_75410_, p_75411_, 0.0, 0.0, false);
    }

    @Deprecated
    public double m_75417_(double p_75418_, double p_75419_, double p_75420_, double p_75421_, double p_75422_, boolean p_75423_) {
        double d = 0.0;
        \u00e2\u02dc\u0192 = this.f_75393_;
        \u00e2\u02dc\u0192 = this.f_75392_;
        for (int i = 0; i < this.f_75390_.length; ++i) {
            ImprovedNoise improvedNoise = this.f_75390_[i];
            if (improvedNoise != null) {
                double d2 = improvedNoise.m_75327_(PerlinNoise.m_75406_(p_75418_ * \u00e2\u02dc\u0192), p_75423_ ? -improvedNoise.f_75322_ : PerlinNoise.m_75406_(p_75419_ * \u00e2\u02dc\u0192), PerlinNoise.m_75406_(p_75420_ * \u00e2\u02dc\u0192), p_75421_ * \u00e2\u02dc\u0192, p_75422_ * \u00e2\u02dc\u0192);
                d += this.f_75391_.getDouble(i) * d2 * \u00e2\u02dc\u0192;
            }
            \u00e2\u02dc\u0192 *= 2.0;
            \u00e2\u02dc\u0192 /= 2.0;
        }
        return d;
    }

    @Nullable
    public ImprovedNoise m_75424_(int p_75425_) {
        return this.f_75390_[this.f_75390_.length - 1 - p_75425_];
    }

    public static double m_75406_(double p_75407_) {
        return p_75407_ - (double)Mth.m_14134_(p_75407_ / 3.3554432E7 + 0.5) * 3.3554432E7;
    }

    @Override
    public double m_5495_(double p_75413_, double p_75414_, double p_75415_, double p_75416_) {
        return this.m_75417_(p_75413_, p_75414_, 0.0, p_75415_, p_75416_, false);
    }
}

