/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.LayerLightEngine;
import net.minecraft.world.level.lighting.SkyLightSectionStorage;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableInt;

public final class SkyLightEngine
extends LayerLightEngine<SkyLightSectionStorage.SkyDataLayerStorageMap, SkyLightSectionStorage> {
    private static final Direction[] f_75839_ = Direction.values();
    private static final Direction[] f_75840_ = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};

    public SkyLightEngine(LightChunkGetter p_75843_) {
        super(p_75843_, LightLayer.SKY, new SkyLightSectionStorage(p_75843_));
    }

    @Override
    protected int m_6359_(long p_75855_, long p_75856_, int p_75857_) {
        if (p_75856_ == Long.MAX_VALUE || p_75855_ == Long.MAX_VALUE) {
            return 15;
        }
        if (p_75857_ >= 15) {
            return p_75857_;
        }
        MutableInt mutableInt = new MutableInt();
        BlockState \u00e2\u02dc\u01922 = this.m_75664_(p_75856_, mutableInt);
        if (mutableInt.getValue() >= 15) {
            return 15;
        }
        int \u00e2\u02dc\u01923 = BlockPos.m_121983_(p_75855_);
        int \u00e2\u02dc\u01924 = BlockPos.m_122008_(p_75855_);
        int \u00e2\u02dc\u01925 = BlockPos.m_122015_(p_75855_);
        int \u00e2\u02dc\u01926 = BlockPos.m_121983_(p_75856_);
        int \u00e2\u02dc\u01927 = BlockPos.m_122008_(p_75856_);
        int \u00e2\u02dc\u01928 = BlockPos.m_122015_(p_75856_);
        int \u00e2\u02dc\u01929 = Integer.signum(\u00e2\u02dc\u01926 - \u00e2\u02dc\u01923);
        Direction \u00e2\u02dc\u019210 = Direction.m_122378_(\u00e2\u02dc\u01929, \u00e2\u02dc\u0192 = Integer.signum(\u00e2\u02dc\u01927 - \u00e2\u02dc\u01924), \u00e2\u02dc\u0192 = Integer.signum(\u00e2\u02dc\u01928 - \u00e2\u02dc\u01925));
        if (\u00e2\u02dc\u019210 == null) {
            throw new IllegalStateException(String.format("Light was spread in illegal direction %d, %d, %d", \u00e2\u02dc\u01929, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192));
        }
        BlockState \u00e2\u02dc\u019211 = this.m_75664_(p_75855_, null);
        VoxelShape \u00e2\u02dc\u019212 = this.m_75678_(\u00e2\u02dc\u019211, p_75855_, \u00e2\u02dc\u019210);
        if (Shapes.m_83145_(\u00e2\u02dc\u019212, \u00e2\u02dc\u0192 = this.m_75678_(\u00e2\u02dc\u01922, p_75856_, \u00e2\u02dc\u019210.m_122424_()))) {
            return 15;
        }
        boolean \u00e2\u02dc\u019213 = \u00e2\u02dc\u01923 == \u00e2\u02dc\u01926 && \u00e2\u02dc\u01925 == \u00e2\u02dc\u01928;
        boolean bl = \u00e2\u02dc\u0192 = \u00e2\u02dc\u019213 && \u00e2\u02dc\u01924 > \u00e2\u02dc\u01927;
        if (\u00e2\u02dc\u0192 && p_75857_ == 0 && mutableInt.getValue() == 0) {
            return 0;
        }
        return p_75857_ + Math.max(1, mutableInt.getValue());
    }

    @Override
    protected void m_7900_(long p_75845_, int p_75846_, boolean p_75847_) {
        int n;
        long l = SectionPos.m_123235_(p_75845_);
        int \u00e2\u02dc\u01922 = BlockPos.m_122008_(p_75845_);
        int \u00e2\u02dc\u01923 = SectionPos.m_123207_(\u00e2\u02dc\u01922);
        int \u00e2\u02dc\u01924 = SectionPos.m_123171_(\u00e2\u02dc\u01922);
        if (\u00e2\u02dc\u01923 != 0) {
            n = 0;
        } else {
            int n2 = 0;
            while (!((SkyLightSectionStorage)this.f_75632_).m_75791_(SectionPos.m_123186_(l, 0, -n2 - 1, 0)) && ((SkyLightSectionStorage)this.f_75632_).m_75870_(\u00e2\u02dc\u01924 - n2 - 1)) {
                ++n2;
            }
            n = n2;
        }
        long \u00e2\u02dc\u01925 = BlockPos.m_121910_(p_75845_, 0, -1 - n * 16, 0);
        long \u00e2\u02dc\u01926 = SectionPos.m_123235_(\u00e2\u02dc\u01925);
        if (l == \u00e2\u02dc\u01926 || ((SkyLightSectionStorage)this.f_75632_).m_75791_(\u00e2\u02dc\u01926)) {
            this.m_75593_(p_75845_, \u00e2\u02dc\u01925, p_75846_, p_75847_);
        }
        if (l == (\u00e2\u02dc\u0192 = SectionPos.m_123235_(\u00e2\u02dc\u0192 = BlockPos.m_121915_(p_75845_, Direction.UP))) || ((SkyLightSectionStorage)this.f_75632_).m_75791_(\u00e2\u02dc\u0192)) {
            this.m_75593_(p_75845_, \u00e2\u02dc\u0192, p_75846_, p_75847_);
        }
        block1: for (Direction direction : f_75840_) {
            int n3 = 0;
            do {
                if (l == (\u00e2\u02dc\u0192 = SectionPos.m_123235_(\u00e2\u02dc\u0192 = BlockPos.m_121910_(p_75845_, direction.m_122429_(), -n3, direction.m_122431_())))) {
                    this.m_75593_(p_75845_, \u00e2\u02dc\u0192, p_75846_, p_75847_);
                    continue block1;
                }
                if (!((SkyLightSectionStorage)this.f_75632_).m_75791_(\u00e2\u02dc\u0192)) continue;
                long l2 = BlockPos.m_121910_(p_75845_, 0, -n3, 0);
                this.m_75593_(l2, \u00e2\u02dc\u0192, p_75846_, p_75847_);
            } while (++n3 <= n * 16);
        }
    }

    @Override
    protected int m_6357_(long p_75849_, long p_75850_, int p_75851_) {
        int n = p_75851_;
        long \u00e2\u02dc\u01922 = SectionPos.m_123235_(p_75849_);
        DataLayer \u00e2\u02dc\u01923 = ((SkyLightSectionStorage)this.f_75632_).m_75758_(\u00e2\u02dc\u01922, true);
        for (Direction direction2 : f_75839_) {
            int \u00e2\u02dc\u01925;
            long l = BlockPos.m_121915_(p_75849_, direction2);
            if (l == p_75850_) continue;
            \u00e2\u02dc\u0192 = SectionPos.m_123235_(l);
            DataLayer \u00e2\u02dc\u01924 = \u00e2\u02dc\u01922 == \u00e2\u02dc\u0192 ? \u00e2\u02dc\u01923 : ((SkyLightSectionStorage)this.f_75632_).m_75758_(\u00e2\u02dc\u0192, true);
            if (\u00e2\u02dc\u01924 != null) {
                \u00e2\u02dc\u01925 = this.m_75682_(\u00e2\u02dc\u01924, l);
            } else {
                Direction direction2;
                if (direction2 == Direction.DOWN) continue;
                \u00e2\u02dc\u01925 = 15 - ((SkyLightSectionStorage)this.f_75632_).m_164457_(l, true);
            }
            int n2 = this.m_6359_(l, p_75849_, \u00e2\u02dc\u01925);
            if (n > n2) {
                n = n2;
            }
            if (n != 0) continue;
            return n;
        }
        return n;
    }

    @Override
    protected void m_6185_(long p_75859_) {
        ((SkyLightSectionStorage)this.f_75632_).m_75785_();
        long l = SectionPos.m_123235_(p_75859_);
        if (((SkyLightSectionStorage)this.f_75632_).m_75791_(l)) {
            super.m_6185_(p_75859_);
        } else {
            p_75859_ = BlockPos.m_122027_(p_75859_);
            while (!((SkyLightSectionStorage)this.f_75632_).m_75791_(l) && !((SkyLightSectionStorage)this.f_75632_).m_75890_(l)) {
                l = SectionPos.m_123191_(l, Direction.UP);
                p_75859_ = BlockPos.m_121910_(p_75859_, 0, 16, 0);
            }
            if (((SkyLightSectionStorage)this.f_75632_).m_75791_(l)) {
                super.m_6185_(p_75859_);
            }
        }
    }

    @Override
    public String m_6647_(long p_75853_) {
        return super.m_6647_(p_75853_) + (((SkyLightSectionStorage)this.f_75632_).m_75890_(p_75853_) ? "*" : "");
    }
}

